# MySQL dump of database 'edu_apsis' on host 'localhost'
# Backup Date and Time: 2019-03-30 10:41
# Built by FrontAccounting 2.3.22
# http://frontaccounting.com
# Company: BOLIVIAIMPUESTOS.COM SRL
# User: Administrador



### Structure of table `0_areas` ###

DROP TABLE IF EXISTS `0_areas`;

CREATE TABLE `0_areas` (
  `area_code` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`area_code`),
  UNIQUE KEY `description` (`description`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 ;

### Data of table `0_areas` ###

INSERT INTO `0_areas` VALUES
('1', 'Global', '0');

### Structure of table `0_attachments` ###

DROP TABLE IF EXISTS `0_attachments`;

CREATE TABLE `0_attachments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `type_no` int(11) NOT NULL DEFAULT '0',
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `unique_name` varchar(60) NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `filename` varchar(60) NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT '0',
  `filetype` varchar(60) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_no` (`type_no`,`trans_no`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ;

### Data of table `0_attachments` ###


### Structure of table `0_audit_trail` ###

DROP TABLE IF EXISTS `0_audit_trail`;

CREATE TABLE `0_audit_trail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `user` smallint(6) unsigned NOT NULL DEFAULT '0',
  `stamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `description` varchar(60) DEFAULT NULL,
  `fiscal_year` int(11) NOT NULL,
  `gl_date` date NOT NULL DEFAULT '0000-00-00',
  `gl_seq` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Seq` (`fiscal_year`,`gl_date`,`gl_seq`),
  KEY `Type_and_Number` (`type`,`trans_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ;

### Data of table `0_audit_trail` ###


### Structure of table `0_bank_accounts` ###

DROP TABLE IF EXISTS `0_bank_accounts`;

CREATE TABLE `0_bank_accounts` (
  `account_code` varchar(15) NOT NULL DEFAULT '',
  `account_type` smallint(6) NOT NULL DEFAULT '0',
  `bank_account_name` varchar(60) NOT NULL DEFAULT '',
  `bank_account_number` varchar(100) NOT NULL DEFAULT '',
  `bank_name` varchar(60) NOT NULL DEFAULT '',
  `bank_address` tinytext,
  `bank_curr_code` char(3) NOT NULL DEFAULT '',
  `dflt_curr_act` tinyint(1) NOT NULL DEFAULT '0',
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `last_reconciled_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ending_reconcile_balance` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `bank_account_name` (`bank_account_name`),
  KEY `bank_account_number` (`bank_account_number`),
  KEY `account_code` (`account_code`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 ;

### Data of table `0_bank_accounts` ###

INSERT INTO `0_bank_accounts` VALUES
('1065', '3', 'Efectivo', 'N/A', 'N/A', NULL, 'BS', '0', '2', '2017-11-08 00:00:00', '0', '0');

### Structure of table `0_bank_trans` ###

DROP TABLE IF EXISTS `0_bank_trans`;

CREATE TABLE `0_bank_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `bank_act` varchar(15) NOT NULL DEFAULT '',
  `ref` varchar(40) DEFAULT NULL,
  `trans_date` date NOT NULL DEFAULT '0000-00-00',
  `amount` double DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `person_type_id` int(11) NOT NULL DEFAULT '0',
  `person_id` tinyblob,
  `reconciled` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_act` (`bank_act`,`ref`),
  KEY `type` (`type`,`trans_no`),
  KEY `bank_act_2` (`bank_act`,`reconciled`),
  KEY `bank_act_3` (`bank_act`,`trans_date`)
) ENGINE=InnoDB AUTO_INCREMENT=434 DEFAULT CHARSET=latin1 ;

### Data of table `0_bank_trans` ###

INSERT INTO `0_bank_trans` VALUES
('1', '12', '1', '2', '1', '2017-09-15', '179', '0', '0', '2', '6', '2017-11-08'),
('2', '12', '2', '2', '2', '2017-09-15', '358', '0', '0', '2', '7', '2017-11-08'),
('3', '12', '3', '2', '3', '2017-09-15', '149', '0', '0', '2', '8', '2017-11-08'),
('4', '12', '4', '2', '4', '2017-09-15', '477', '0', '0', '2', '9', '2017-11-08'),
('5', '12', '5', '2', '5', '2017-09-15', '179', '0', '0', '2', '10', '2017-11-08'),
('6', '12', '6', '2', '6', '2017-09-15', '149', '0', '0', '2', '11', '2017-11-08'),
('7', '12', '7', '2', '7', '2017-09-15', '358', '0', '0', '2', '12', NULL),
('8', '12', '8', '2', '8', '2017-09-15', '328', '0', '0', '2', '13', NULL),
('9', '12', '9', '2', '9', '2017-09-15', '298', '0', '0', '2', '14', NULL),
('10', '12', '10', '2', '10', '2017-09-15', '98', '0', '0', '2', '15', NULL),
('11', '12', '11', '2', '11', '2017-09-15', '98', '0', '0', '2', '16', NULL),
('12', '12', '12', '2', '12', '2017-09-15', '98', '0', '0', '2', '17', NULL),
('13', '12', '13', '2', '13', '2017-09-15', '98', '0', '0', '2', '18', NULL),
('14', '12', '14', '2', '14', '2017-09-15', '98', '0', '0', '2', '19', NULL),
('15', '12', '15', '2', '15', '2017-09-15', '98', '0', '0', '2', '20', NULL),
('16', '12', '16', '2', '16', '2017-09-15', '98', '0', '0', '2', '21', NULL),
('17', '12', '17', '2', '17', '2017-09-15', '328', '0', '0', '2', '22', NULL),
('18', '12', '18', '2', '18', '2017-09-15', '298', '0', '0', '2', '23', NULL),
('19', '12', '19', '2', '19', '2017-09-15', '98', '0', '0', '2', '24', NULL),
('20', '12', '20', '2', '20', '2017-09-15', '98', '0', '0', '2', '25', NULL),
('21', '12', '21', '2', '21', '2017-09-15', '98', '0', '0', '2', '26', NULL),
('22', '12', '22', '2', '22', '2017-09-15', '98', '0', '0', '2', '27', NULL),
('23', '12', '23', '2', '23', '2017-09-15', '98', '0', '0', '2', '28', NULL),
('24', '12', '24', '2', '24', '2017-09-15', '98', '0', '0', '2', '29', NULL),
('25', '12', '25', '2', '25', '2017-09-15', '98', '0', '0', '2', '30', NULL),
('26', '12', '26', '2', '26', '2017-09-15', '98', '0', '0', '2', '31', NULL),
('27', '12', '27', '2', '27', '2017-09-15', '98', '0', '0', '2', '32', NULL),
('28', '12', '28', '2', '28', '2017-09-16', '1600', '0', '0', '2', '1', NULL),
('29', '12', '29', '2', '29', '2017-09-18', '98', '0', '0', '2', '33', NULL),
('30', '12', '30', '2', '30', '2017-09-18', '98', '0', '0', '2', '34', NULL),
('31', '12', '31', '2', '31', '2017-09-18', '98', '0', '0', '2', '35', NULL),
('32', '12', '32', '2', '32', '2017-09-18', '98', '0', '0', '2', '36', NULL),
('33', '12', '33', '2', '33', '2017-09-18', '98', '0', '0', '2', '37', NULL),
('34', '12', '34', '2', '34', '2017-09-18', '179', '0', '0', '2', '38', NULL),
('35', '12', '35', '2', '35', '2017-09-18', '98', '0', '0', '2', '39', NULL),
('36', '12', '36', '2', '36', '2017-09-18', '98', '0', '0', '2', '40', NULL),
('37', '12', '37', '2', '37', '2017-09-18', '88', '0', '0', '2', '41', NULL),
('38', '12', '38', '2', '38', '2017-09-18', '98', '0', '0', '2', '42', NULL),
('39', '12', '39', '2', '39', '2017-09-18', '98', '0', '0', '2', '43', NULL),
('40', '12', '40', '2', '40', '2017-09-18', '98', '0', '0', '2', '44', NULL),
('41', '12', '41', '2', '41', '2017-09-18', '98', '0', '0', '2', '45', NULL),
('42', '12', '42', '2', '42', '2017-09-18', '98', '0', '0', '2', '46', NULL),
('43', '12', '43', '2', '43', '2017-09-18', '98', '0', '0', '2', '47', NULL),
('44', '12', '44', '2', '44', '2017-09-18', '98', '0', '0', '2', '48', NULL),
('45', '12', '45', '2', '45', '2017-09-18', '98', '0', '0', '2', '49', NULL),
('46', '12', '46', '2', '46', '2017-09-18', '98', '0', '0', '2', '50', NULL),
('47', '12', '47', '2', '47', '2017-09-18', '98', '0', '0', '2', '51', NULL),
('48', '12', '48', '2', '48', '2017-09-18', '98', '0', '0', '2', '52', NULL),
('49', '12', '49', '2', '49', '2017-09-18', '98', '0', '0', '2', '53', NULL),
('50', '12', '50', '2', '50', '2017-09-18', '98', '0', '0', '2', '54', NULL),
('51', '12', '51', '2', '51', '2017-09-18', '98', '0', '0', '2', '55', NULL),
('52', '12', '52', '2', '52', '2017-09-18', '98', '0', '0', '2', '56', NULL),
('53', '12', '53', '2', '53', '2017-09-18', '98', '0', '0', '2', '57', NULL),
('54', '12', '54', '2', '54', '2017-09-18', '98', '0', '0', '2', '58', NULL),
('55', '12', '55', '2', '55', '2017-09-18', '98', '0', '0', '2', '59', NULL),
('56', '12', '56', '2', '56', '2017-09-18', '488', '0', '0', '2', '59', NULL),
('57', '12', '57', '2', '57', '2017-09-18', '98', '0', '0', '2', '60', NULL),
('58', '12', '58', '2', '58', '2017-09-18', '98', '0', '0', '2', '61', NULL),
('59', '12', '59', '2', '59', '2017-09-18', '179', '0', '0', '2', '62', NULL),
('60', '12', '60', '2', '60', '2017-09-18', '98', '0', '0', '2', '63', NULL),
('61', '12', '61', '2', '61', '2017-09-18', '98', '0', '0', '2', '64', NULL),
('62', '12', '62', '2', '62', '2017-09-18', '98', '0', '0', '2', '65', NULL),
('63', '12', '63', '2', '63', '2017-09-18', '98', '0', '0', '2', '66', NULL),
('64', '12', '64', '2', '64', '2017-09-18', '98', '0', '0', '2', '67', NULL),
('65', '12', '65', '2', '65', '2017-09-18', '98', '0', '0', '2', '68', NULL),
('66', '12', '66', '2', '66', '2017-09-18', '98', '0', '0', '2', '69', NULL),
('67', '12', '67', '2', '67', '2017-09-18', '98', '0', '0', '2', '70', NULL),
('68', '12', '68', '2', '68', '2017-09-18', '98', '0', '0', '2', '71', NULL),
('69', '12', '69', '2', '69', '2017-09-18', '179', '0', '0', '2', '72', NULL),
('70', '12', '70', '2', '70', '2017-09-18', '98', '0', '0', '2', '73', NULL),
('71', '12', '71', '2', '71', '2017-09-18', '98', '0', '0', '2', '74', NULL),
('72', '12', '72', '2', '72', '2017-09-18', '98', '0', '0', '2', '75', NULL),
('73', '12', '73', '2', '73', '2017-09-18', '98', '0', '0', '2', '76', NULL),
('74', '12', '74', '2', '74', '2017-09-18', '358', '0', '0', '2', '77', NULL),
('75', '12', '75', '2', '75', '2017-09-18', '98', '0', '0', '2', '78', NULL),
('76', '12', '76', '2', '76', '2017-09-18', '98', '0', '0', '2', '79', NULL),
('77', '12', '77', '2', '77', '2017-09-18', '98', '0', '0', '2', '80', NULL),
('78', '12', '78', '2', '78', '2017-09-18', '98', '0', '0', '2', '81', NULL),
('79', '12', '79', '2', '79', '2017-09-18', '98', '0', '0', '2', '82', NULL),
('80', '12', '80', '2', '80', '2017-09-18', '98', '0', '0', '2', '83', NULL),
('81', '12', '81', '2', '81', '2017-09-19', '98', '0', '0', '2', '84', NULL),
('82', '12', '82', '2', '82', '2017-09-19', '98', '0', '0', '2', '85', NULL),
('83', '12', '83', '2', '83', '2017-09-19', '98', '0', '0', '2', '86', NULL),
('84', '12', '84', '2', '84', '2017-09-19', '358', '0', '0', '2', '87', NULL),
('85', '12', '85', '2', '85', '2017-09-19', '98', '0', '0', '2', '88', NULL),
('86', '12', '86', '2', '86', '2017-09-19', '98', '0', '0', '2', '89', NULL),
('87', '12', '87', '2', '87', '2017-09-19', '98', '0', '0', '2', '90', NULL),
('88', '12', '88', '2', '88', '2017-09-19', '328', '0', '0', '2', '91', NULL),
('89', '12', '89', '2', '89', '2017-09-19', '98', '0', '0', '2', '91', NULL),
('90', '12', '90', '2', '90', '2017-09-19', '98', '0', '0', '2', '92', NULL),
('91', '12', '91', '2', '91', '2017-09-19', '98', '0', '0', '2', '93', NULL),
('92', '12', '92', '2', '92', '2017-09-19', '98', '0', '0', '2', '94', NULL),
('93', '12', '93', '2', '93', '2017-09-19', '98', '0', '0', '2', '95', NULL),
('94', '12', '94', '2', '94', '2017-09-19', '98', '0', '0', '2', '96', NULL),
('95', '12', '95', '2', '95', '2017-09-19', '98', '0', '0', '2', '97', NULL),
('96', '12', '96', '2', '96', '2017-09-19', '98', '0', '0', '2', '98', NULL),
('97', '12', '97', '2', '97', '2017-09-19', '98', '0', '0', '2', '99', NULL),
('98', '12', '98', '2', '98', '2017-09-19', '239', '0', '0', '2', '100', NULL),
('99', '12', '99', '2', '99', '2017-09-19', '98', '0', '0', '2', '101', NULL),
('100', '12', '100', '2', '100', '2017-09-19', '98', '0', '0', '2', '102', NULL),
('101', '12', '101', '2', '101', '2017-09-19', '98', '0', '0', '2', '103', NULL),
('102', '12', '102', '2', '102', '2017-09-19', '98', '0', '0', '2', '104', NULL),
('103', '12', '103', '2', '103', '2017-09-19', '98', '0', '0', '2', '105', NULL),
('104', '12', '104', '2', '104', '2017-09-19', '98', '0', '0', '2', '106', NULL),
('105', '12', '105', '2', '105', '2017-09-19', '98', '0', '0', '2', '107', NULL),
('106', '12', '106', '2', '106', '2017-09-19', '98', '0', '0', '2', '108', NULL),
('107', '12', '107', '2', '107', '2017-09-19', '179', '0', '0', '2', '108', NULL),
('108', '12', '108', '2', '108', '2017-09-19', '98', '0', '0', '2', '109', NULL),
('109', '12', '109', '2', '109', '2017-09-19', '98', '0', '0', '2', '110', NULL),
('110', '12', '110', '2', '110', '2017-09-20', '98', '0', '0', '2', '111', NULL),
('111', '12', '111', '2', '111', '2017-09-20', '98', '0', '0', '2', '112', NULL),
('112', '12', '112', '2', '112', '2017-09-20', '98', '0', '0', '2', '113', NULL),
('113', '12', '113', '2', '113', '2017-09-20', '98', '0', '0', '2', '114', NULL),
('114', '12', '114', '2', '114', '2017-09-20', '98', '0', '0', '2', '115', NULL),
('115', '12', '115', '2', '115', '2017-09-20', '98', '0', '0', '2', '116', NULL),
('116', '12', '116', '2', '116', '2017-09-20', '98', '0', '0', '2', '117', NULL),
('117', '12', '117', '2', '117', '2017-09-20', '98', '0', '0', '2', '118', NULL),
('118', '12', '118', '2', '118', '2017-09-20', '98', '0', '0', '2', '119', NULL),
('119', '12', '119', '2', '119', '2017-09-20', '98', '0', '0', '2', '120', NULL),
('120', '12', '120', '2', '120', '2017-09-20', '98', '0', '0', '2', '121', NULL),
('121', '12', '121', '2', '121', '2017-09-20', '98', '0', '0', '2', '122', NULL),
('122', '12', '122', '2', '122', '2017-09-20', '98', '0', '0', '2', '123', NULL),
('123', '12', '123', '2', '123', '2017-09-20', '98', '0', '0', '2', '124', NULL),
('124', '12', '124', '2', '124', '2017-09-20', '98', '0', '0', '2', '125', NULL),
('125', '12', '125', '2', '125', '2017-09-20', '98', '0', '0', '2', '126', NULL),
('126', '12', '126', '2', '126', '2017-09-21', '98', '0', '0', '2', '127', NULL),
('127', '12', '127', '2', '127', '2017-09-21', '358', '0', '0', '2', '128', NULL),
('128', '12', '128', '2', '128', '2017-09-21', '98', '0', '0', '2', '129', NULL),
('129', '12', '129', '2', '129', '2017-09-21', '98', '0', '0', '2', '130', NULL),
('130', '12', '130', '2', '130', '2017-09-21', '98', '0', '0', '2', '22', NULL),
('131', '12', '131', '2', '131', '2017-09-21', '98', '0', '0', '2', '131', NULL),
('132', '12', '132', '2', '132', '2017-09-21', '98', '0', '0', '2', '132', NULL),
('133', '12', '133', '2', '133', '2017-09-21', '98', '0', '0', '2', '133', NULL),
('134', '12', '134', '2', '134', '2017-09-21', '88', '0', '0', '2', '134', NULL),
('135', '12', '135', '2', '135', '2017-09-21', '98', '0', '0', '2', '135', NULL),
('136', '12', '136', '2', '136', '2017-09-21', '179', '0', '0', '2', '136', NULL),
('137', '12', '137', '2', '137', '2017-09-21', '98', '0', '0', '2', '137', NULL),
('138', '12', '138', '2', '138', '2017-09-21', '98', '0', '0', '2', '138', NULL),
('139', '12', '139', '2', '139', '2017-09-21', '98', '0', '0', '2', '139', NULL),
('140', '12', '140', '2', '140', '2017-09-21', '98', '0', '0', '2', '140', NULL),
('141', '12', '141', '2', '141', '2017-09-21', '98', '0', '0', '2', '141', NULL),
('142', '12', '142', '2', '142', '2017-09-21', '98', '0', '0', '2', '142', NULL),
('143', '12', '143', '2', '143', '2017-09-25', '500', '0', '0', '2', '134', NULL),
('144', '12', '144', '2', '144', '2017-09-25', '179', '0', '0', '2', '143', NULL),
('145', '12', '145', '2', '145', '2017-09-25', '98', '0', '0', '2', '144', NULL),
('146', '12', '146', '2', '146', '2017-09-25', '88', '0', '0', '2', '145', NULL),
('147', '12', '147', '2', '147', '2017-09-25', '98', '0', '0', '2', '146', NULL),
('148', '12', '148', '2', '148', '2017-09-25', '239', '0', '0', '2', '147', NULL),
('149', '12', '149', '2', '149', '2017-09-25', '98', '0', '0', '2', '148', NULL),
('150', '12', '150', '2', '150', '2017-09-25', '98', '0', '0', '2', '149', NULL),
('151', '12', '151', '2', '151', '2017-09-25', '98', '0', '0', '2', '150', NULL),
('152', '12', '152', '2', '152', '2017-09-25', '98', '0', '0', '2', '151', NULL),
('153', '12', '153', '2', '153', '2017-09-25', '98', '0', '0', '2', '152', NULL),
('154', '12', '154', '2', '154', '2017-09-25', '98', '0', '0', '2', '153', NULL),
('155', '12', '155', '2', '155', '2017-09-25', '729', '0', '0', '2', '154', NULL),
('156', '12', '156', '2', '156', '2017-09-25', '100', '0', '0', '2', '155', NULL),
('157', '12', '157', '2', '157', '2017-09-25', '98', '0', '0', '2', '156', NULL),
('158', '12', '158', '2', '158', '2017-09-27', '298', '0', '0', '2', '157', NULL),
('159', '12', '159', '2', '159', '2017-09-27', '298', '0', '0', '2', '158', NULL),
('160', '12', '160', '2', '160', '2017-09-27', '98', '0', '0', '2', '159', NULL),
('161', '12', '161', '2', '161', '2017-09-27', '350', '0', '0', '2', '160', NULL),
('162', '12', '162', '2', '162', '2017-09-27', '98', '0', '0', '2', '161', NULL),
('163', '12', '163', '2', '163', '2017-09-27', '98', '0', '0', '2', '162', NULL),
('164', '12', '164', '2', '164', '2017-09-27', '98', '0', '0', '2', '163', NULL),
('165', '12', '165', '2', '165', '2017-09-27', '98', '0', '0', '2', '164', NULL),
('166', '12', '166', '2', '166', '2017-09-27', '418', '0', '0', '2', '165', NULL),
('167', '12', '167', '2', '167', '2017-09-27', '328', '0', '0', '2', '166', NULL),
('168', '12', '168', '2', '168', '2017-09-27', '98', '0', '0', '2', '167', NULL),
('169', '12', '169', '2', '169', '2017-09-27', '98', '0', '0', '2', '168', NULL),
('170', '12', '170', '2', '170', '2017-09-29', '100', '0', '0', '2', '169', NULL),
('171', '12', '171', '2', '171', '2017-09-29', '98', '0', '0', '2', '170', NULL),
('172', '12', '172', '2', '172', '2017-09-29', '98', '0', '0', '2', '171', NULL),
('173', '12', '173', '2', '173', '2017-09-29', '98', '0', '0', '2', '172', NULL),
('174', '12', '174', '2', '174', '2017-09-29', '98', '0', '0', '2', '173', NULL),
('175', '12', '175', '2', '175', '2017-09-29', '98', '0', '0', '2', '174', NULL),
('176', '12', '176', '2', '176', '2017-09-29', '179', '0', '0', '2', '175', NULL),
('177', '12', '177', '2', '177', '2017-09-29', '98', '0', '0', '2', '176', NULL),
('178', '12', '178', '2', '178', '2017-09-29', '98', '0', '0', '2', '177', NULL),
('179', '12', '179', '2', '179', '2017-09-29', '98', '0', '0', '2', '178', NULL),
('180', '12', '180', '2', '180', '2017-09-29', '98', '0', '0', '2', '179', NULL),
('181', '12', '181', '2', '181', '2017-09-29', '98', '0', '0', '2', '180', NULL),
('182', '12', '182', '2', '182', '2017-09-29', '490', '0', '0', '2', '180', NULL),
('183', '12', '183', '2', '183', '2017-09-28', '418', '0', '0', '2', '181', NULL),
('184', '12', '184', '2', '184', '2017-09-28', '98', '0', '0', '2', '182', NULL),
('185', '12', '185', '2', '185', '2017-09-28', '98', '0', '0', '2', '183', NULL),
('186', '12', '186', '2', '186', '2017-10-02', '98', '0', '0', '2', '184', NULL),
('187', '12', '187', '2', '187', '2017-10-02', '179', '0', '0', '2', '185', NULL),
('188', '12', '188', '2', '188', '2017-10-02', '179', '0', '0', '2', '186', NULL),
('189', '12', '189', '2', '189', '2017-10-02', '639', '0', '0', '2', '187', NULL),
('190', '12', '190', '2', '190', '2017-10-02', '179', '0', '0', '2', '188', NULL),
('191', '12', '191', '2', '191', '2017-10-02', '98', '0', '0', '2', '188', NULL),
('192', '12', '192', '2', '192', '2017-10-02', '418', '0', '0', '2', '189', NULL),
('193', '12', '193', '2', '193', '2017-10-02', '98', '0', '0', '2', '190', NULL),
('194', '12', '194', '2', '194', '2017-10-02', '98', '0', '0', '2', '191', NULL),
('195', '12', '195', '2', '195', '2017-10-02', '88', '0', '0', '2', '92', NULL),
('196', '12', '196', '2', '196', '2017-10-02', '98', '0', '0', '2', '192', NULL),
('197', '12', '197', '2', '197', '2017-10-02', '768', '0', '0', '2', '193', NULL),
('198', '12', '198', '2', '198', '2017-10-02', '98', '0', '0', '2', '194', NULL),
('199', '12', '199', '2', '199', '2017-10-02', '98', '0', '0', '2', '195', NULL),
('200', '12', '200', '2', '200', '2017-10-02', '499', '0', '0', '2', '196', NULL),
('201', '12', '201', '2', '201', '2017-10-02', '239', '0', '0', '2', '197', NULL),
('202', '12', '202', '2', '202', '2017-10-03', '98', '0', '0', '2', '198', NULL),
('203', '12', '203', '2', '203', '2017-10-03', '179', '0', '0', '2', '199', NULL),
('204', '12', '204', '2', '204', '2017-10-03', '98', '0', '0', '2', '199', NULL),
('205', '12', '205', '2', '205', '2017-10-03', '98', '0', '0', '2', '200', NULL),
('206', '12', '206', '2', '206', '2017-10-03', '98', '0', '0', '2', '201', NULL),
('207', '12', '207', '2', '207', '2017-10-03', '179', '0', '0', '2', '202', NULL),
('208', '12', '208', '2', '208', '2017-10-03', '98', '0', '0', '2', '203', NULL),
('209', '12', '209', '2', '209', '2017-10-03', '98', '0', '0', '2', '204', NULL),
('210', '12', '210', '2', '210', '2017-10-03', '98', '0', '0', '2', '205', NULL),
('211', '12', '211', '2', '211', '2017-10-03', '98', '0', '0', '2', '206', NULL),
('212', '12', '212', '2', '212', '2017-10-03', '98', '0', '0', '2', '207', NULL),
('213', '12', '213', '2', '213', '2017-10-03', '98', '0', '0', '2', '208', NULL),
('214', '12', '214', '2', '214', '2017-10-05', '98', '0', '0', '2', '209', NULL),
('215', '12', '215', '2', '215', '2017-10-05', '149', '0', '0', '2', '210', NULL),
('216', '12', '216', '2', '216', '2017-10-05', '350', '0', '0', '2', '211', NULL),
('217', '12', '217', '2', '217', '2017-10-05', '98', '0', '0', '2', '212', NULL),
('218', '12', '218', '2', '218', '2017-10-05', '98', '0', '0', '2', '213', NULL),
('219', '12', '219', '2', '219', '2017-10-05', '98', '0', '0', '2', '214', NULL),
('220', '12', '220', '2', '220', '2017-10-05', '98', '0', '0', '2', '214', NULL),
('221', '12', '221', '2', '221', '2017-10-05', '98', '0', '0', '2', '215', NULL),
('222', '12', '222', '2', '222', '2017-10-05', '98', '0', '0', '2', '216', NULL),
('223', '12', '223', '2', '223', '2017-10-05', '98', '0', '0', '2', '217', NULL),
('224', '12', '224', '2', '224', '2017-10-05', '98', '0', '0', '2', '218', NULL),
('225', '12', '225', '2', '225', '2017-10-05', '328', '0', '0', '2', '219', NULL),
('226', '12', '226', '2', '226', '2017-10-05', '580', '0', '0', '2', '220', NULL),
('227', '12', '227', '2', '227', '2017-10-06', '100', '0', '0', '2', '221', NULL),
('228', '12', '228', '2', '228', '2017-10-06', '98', '0', '0', '2', '222', NULL),
('229', '12', '229', '2', '229', '2017-10-06', '98', '0', '0', '2', '223', NULL),
('230', '12', '230', '2', '230', '2017-10-06', '98', '0', '0', '2', '224', NULL),
('231', '12', '231', '2', '231', '2017-10-06', '98', '0', '0', '2', '225', NULL),
('232', '12', '232', '2', '232', '2017-10-09', '328', '0', '0', '2', '226', NULL),
('233', '12', '233', '2', '233', '2017-10-10', '98', '0', '0', '2', '227', NULL),
('234', '12', '234', '2', '234', '2017-10-11', '98', '0', '0', '2', '228', NULL),
('235', '12', '235', '2', '235', '2017-10-11', '98', '0', '0', '2', '229', NULL),
('236', '12', '236', '2', '236', '2017-10-11', '98', '0', '0', '2', '230', NULL),
('237', '12', '237', '2', '237', '2017-10-11', '669', '0', '0', '2', '231', NULL),
('238', '12', '238', '2', '238', '2017-10-11', '98', '0', '0', '2', '232', NULL),
('239', '12', '239', '2', '239', '2017-10-11', '98', '0', '0', '2', '233', NULL),
('240', '12', '240', '2', '240', '2017-10-11', '98', '0', '0', '2', '234', NULL),
('241', '12', '241', '2', '241', '2017-10-11', '98', '0', '0', '2', '235', NULL),
('242', '12', '242', '2', '242', '2017-10-11', '98', '0', '0', '2', '236', NULL),
('243', '12', '243', '2', '243', '2017-10-11', '98', '0', '0', '2', '237', NULL),
('244', '12', '244', '2', '244', '2017-10-11', '98', '0', '0', '2', '238', NULL),
('245', '12', '245', '2', '245', '2017-10-11', '179', '0', '0', '2', '239', NULL),
('246', '12', '246', '2', '246', '2017-10-11', '98', '0', '0', '2', '240', NULL),
('247', '12', '247', '2', '247', '2017-10-12', '98', '0', '0', '2', '241', NULL),
('248', '12', '248', '2', '248', '2017-10-12', '499', '0', '0', '2', '242', NULL),
('249', '12', '249', '2', '249', '2017-10-12', '98', '0', '0', '2', '243', NULL),
('250', '12', '250', '2', '250', '2017-10-12', '149', '0', '0', '2', '244', NULL),
('251', '12', '251', '2', '251', '2017-10-12', '98', '0', '0', '2', '245', NULL),
('252', '12', '252', '2', '252', '2017-10-12', '98', '0', '0', '2', '246', NULL),
('253', '12', '253', '2', '253', '2017-10-12', '149', '0', '0', '2', '247', NULL),
('254', '12', '254', '2', '254', '2017-10-12', '98', '0', '0', '2', '248', NULL),
('255', '12', '255', '2', '255', '2017-10-12', '98', '0', '0', '2', '249', NULL),
('256', '12', '256', '2', '256', '2017-10-12', '350', '0', '0', '2', '250', NULL),
('257', '12', '257', '2', '257', '2017-10-12', '98', '0', '0', '2', '251', NULL),
('258', '12', '258', '2', '258', '2017-10-12', '149', '0', '0', '2', '252', NULL),
('259', '12', '259', '2', '259', '2017-10-12', '98', '0', '0', '2', '253', NULL),
('260', '12', '260', '2', '260', '2017-10-12', '98', '0', '0', '2', '254', NULL),
('261', '12', '261', '2', '261', '2017-10-13', '179', '0', '0', '2', '255', NULL),
('262', '12', '262', '2', '262', '2017-10-13', '179', '0', '0', '2', '256', NULL),
('263', '12', '263', '2', '263', '2017-10-13', '98', '0', '0', '2', '256', NULL),
('264', '12', '264', '2', '264', '2017-10-13', '98', '0', '0', '2', '257', NULL),
('265', '12', '265', '2', '265', '2017-10-13', '179', '0', '0', '2', '257', NULL),
('266', '12', '266', '2', '266', '2017-10-13', '179', '0', '0', '2', '258', NULL),
('267', '12', '267', '2', '267', '2017-10-13', '179', '0', '0', '2', '259', NULL),
('268', '12', '268', '2', '268', '2017-10-17', '149', '0', '0', '2', '260', NULL),
('269', '12', '269', '2', '269', '2017-10-17', '98', '0', '0', '2', '260', NULL),
('270', '12', '270', '2', '270', '2017-10-17', '358', '0', '0', '2', '261', NULL),
('271', '12', '271', '2', '271', '2017-10-17', '98', '0', '0', '2', '262', NULL),
('272', '12', '272', '2', '272', '2017-10-17', '358', '0', '0', '2', '263', NULL),
('273', '12', '273', '2', '273', '2017-10-17', '239', '0', '0', '2', '264', NULL),
('274', '12', '274', '2', '274', '2017-10-17', '350', '0', '0', '2', '265', NULL),
('275', '12', '275', '2', '275', '2017-10-17', '98', '0', '0', '2', '266', NULL),
('276', '12', '276', '2', '276', '2017-10-17', '358', '0', '0', '2', '267', NULL),
('277', '12', '277', '2', '277', '2017-10-17', '179', '0', '0', '2', '268', NULL),
('278', '12', '278', '2', '278', '2017-10-17', '418', '0', '0', '2', '269', NULL),
('279', '12', '279', '2', '279', '2017-10-17', '98', '0', '0', '2', '270', NULL),
('280', '12', '280', '2', '280', '2017-10-17', '98', '0', '0', '2', '271', NULL),
('281', '12', '281', '2', '281', '2017-10-17', '350', '0', '0', '2', '272', NULL),
('282', '12', '282', '2', '282', '2017-10-19', '98', '0', '0', '2', '273', NULL),
('283', '12', '283', '2', '283', '2017-10-19', '98', '0', '0', '2', '274', NULL),
('284', '12', '284', '2', '284', '2017-10-19', '98', '0', '0', '2', '275', NULL),
('285', '12', '285', '2', '285', '2017-10-19', '418', '0', '0', '2', '276', NULL),
('286', '12', '286', '2', '286', '2017-10-19', '328', '0', '0', '2', '277', NULL),
('287', '12', '287', '2', '287', '2017-10-19', '239', '0', '0', '2', '278', NULL),
('288', '12', '288', '2', '288', '2017-10-19', '418', '0', '0', '2', '279', NULL),
('289', '12', '289', '2', '289', '2017-10-19', '98', '0', '0', '2', '280', NULL),
('290', '12', '290', '2', '290', '2017-10-19', '179', '0', '0', '2', '281', NULL),
('291', '12', '291', '2', '291', '2017-10-19', '98', '0', '0', '2', '282', NULL),
('292', '12', '292', '2', '292', '2017-10-19', '149', '0', '0', '2', '283', NULL),
('293', '12', '293', '2', '293', '2017-10-19', '98', '0', '0', '2', '284', NULL),
('294', '12', '294', '2', '294', '2017-10-19', '98', '0', '0', '2', '285', NULL),
('295', '12', '295', '2', '295', '2017-10-19', '179', '0', '0', '2', '286', NULL),
('296', '12', '296', '2', '296', '2017-10-19', '337', '0', '0', '2', '287', NULL),
('297', '12', '297', '2', '297', '2017-10-23', '98', '0', '0', '2', '288', NULL),
('298', '12', '298', '2', '298', '2017-10-23', '98', '0', '0', '2', '289', NULL),
('299', '12', '299', '2', '299', '2017-10-23', '418', '0', '0', '2', '290', NULL),
('300', '12', '300', '2', '300', '2017-10-23', '98', '0', '0', '2', '290', NULL),
('301', '12', '301', '2', '301', '2017-10-23', '100', '0', '0', '2', '291', NULL),
('302', '12', '302', '2', '302', '2017-10-23', '98', '0', '0', '2', '292', NULL),
('303', '12', '303', '2', '303', '2017-10-23', '98', '0', '0', '2', '293', NULL),
('304', '12', '304', '2', '304', '2017-10-23', '478', '0', '0', '2', '293', NULL),
('305', '12', '305', '2', '305', '2017-10-23', '98', '0', '0', '2', '294', NULL),
('306', '12', '306', '2', '306', '2017-10-23', '100', '0', '0', '2', '295', NULL),
('307', '12', '307', '2', '307', '2017-10-23', '100', '0', '0', '2', '296', NULL),
('308', '12', '308', '2', '308', '2017-10-23', '179', '0', '0', '2', '297', NULL),
('309', '12', '309', '2', '309', '2017-10-25', '149', '0', '0', '2', '298', NULL),
('310', '12', '310', '2', '310', '2017-10-25', '400', '0', '0', '2', '299', NULL),
('311', '12', '311', '2', '311', '2017-10-25', '98', '0', '0', '2', '300', NULL),
('312', '12', '312', '2', '312', '2017-10-25', '388', '0', '0', '2', '301', NULL),
('313', '12', '313', '2', '313', '2017-10-25', '98', '0', '0', '2', '302', NULL),
('314', '12', '314', '2', '314', '2017-10-25', '490', '0', '0', '2', '303', NULL),
('315', '12', '315', '2', '315', '2017-10-25', '98', '0', '0', '2', '304', NULL),
('316', '12', '316', '2', '316', '2017-10-25', '98', '0', '0', '2', '305', NULL),
('317', '12', '317', '2', '317', '2017-10-25', '100', '0', '0', '2', '306', NULL),
('318', '12', '318', '2', '318', '2017-10-25', '98', '0', '0', '2', '307', NULL),
('319', '12', '319', '2', '319', '2017-10-25', '98', '0', '0', '2', '308', NULL),
('320', '12', '320', '2', '320', '2017-10-25', '418', '0', '0', '2', '309', NULL),
('321', '12', '321', '2', '321', '2017-10-27', '98', '0', '0', '2', '310', NULL),
('322', '12', '322', '2', '322', '2017-10-27', '98', '0', '0', '2', '311', NULL),
('323', '12', '323', '2', '323', '2017-10-27', '418', '0', '0', '2', '295', NULL),
('324', '12', '324', '2', '324', '2017-10-27', '98', '0', '0', '2', '312', NULL),
('325', '12', '325', '2', '325', '2017-10-27', '98', '0', '0', '2', '313', NULL),
('326', '12', '326', '2', '326', '2017-10-27', '249', '0', '0', '2', '314', NULL),
('327', '12', '327', '2', '327', '2017-10-27', '98', '0', '0', '2', '315', NULL),
('328', '12', '328', '2', '328', '2017-10-27', '179', '0', '0', '2', '316', NULL),
('329', '12', '329', '2', '329', '2017-11-03', '98', '0', '0', '2', '317', NULL),
('330', '12', '330', '2', '330', '2017-11-06', '98', '0', '0', '2', '318', NULL),
('331', '12', '331', '2', '331', '2017-11-06', '98', '0', '0', '2', '319', NULL),
('332', '12', '332', '2', '332', '2017-11-07', '98', '0', '0', '2', '320', NULL),
('333', '12', '333', '2', '333', '2017-11-07', '179', '0', '0', '2', '321', NULL),
('334', '12', '334', '2', '334', '2017-11-07', '239', '0', '0', '2', '322', NULL),
('335', '12', '335', '2', '335', '2017-11-07', '98', '0', '0', '2', '323', NULL),
('336', '12', '336', '2', '336', '2017-11-07', '388', '0', '0', '2', '324', NULL),
('337', '12', '337', '2', '337', '2017-11-07', '98', '0', '0', '2', '325', NULL),
('338', '12', '338', '2', '338', '2017-11-07', '179', '0', '0', '2', '326', NULL),
('339', '12', '339', '2', '339', '2017-11-07', '98', '0', '0', '2', '327', NULL),
('340', '12', '340', '2', '340', '2017-11-07', '88', '0', '0', '2', '328', NULL),
('341', '12', '341', '2', '341', '2017-11-07', '418', '0', '0', '2', '329', NULL),
('342', '12', '342', '2', '342', '2017-11-07', '418', '0', '0', '2', '330', NULL),
('343', '12', '343', '2', '343', '2017-11-07', '490', '0', '0', '2', '331', NULL),
('344', '12', '344', '2', '344', '2017-11-07', '180', '0', '0', '2', '332', NULL),
('345', '12', '345', '2', '345', '2017-11-07', '298', '0', '0', '2', '333', NULL),
('346', '12', '346', '2', '346', '2017-11-07', '98', '0', '0', '2', '335', NULL),
('347', '12', '347', '2', '347', '2017-11-07', '477', '0', '0', '2', '335', NULL),
('348', '12', '348', '2', '348', '2017-11-07', '477', '0', '0', '2', '334', NULL),
('349', '12', '349', '2', '349', '2017-11-07', '180', '0', '0', '2', '336', NULL),
('350', '12', '350', '2', '350', '2017-11-07', '180', '0', '0', '2', '336', NULL),
('351', '12', '351', '2', '351', '2017-11-07', '98', '0', '0', '2', '337', NULL),
('352', '12', '352', '2', '352', '2017-11-07', '1', '0', '0', '2', '337', NULL),
('353', '12', '353', '2', '353', '2017-11-07', '477', '0', '0', '2', '334', NULL),
('354', '12', '354', '2', '354', '2017-11-07', '98', '0', '0', '2', '337', NULL),
('355', '12', '355', '2', '355', '2017-11-07', '180', '0', '0', '2', '336', NULL),
('356', '12', '356', '2', '356', '2017-11-14', '100', '0', '0', '2', '278', NULL),
('357', '12', '357', '2', '357', '2017-11-23', '209', '0', '0', '2', '229', NULL),
('358', '12', '358', '2', '358', '2017-11-23', '209', '0', '0', '2', '308', NULL),
('359', '12', '359', '2', '359', '2017-11-28', '245', '0', '0', '2', '260', NULL),
('360', '12', '360', '2', '360', '2017-11-28', '245', '0', '0', '2', '232', NULL),
('361', '12', '361', '2', '361', '2017-11-28', '245', '0', '0', '2', '289', NULL),
('362', '12', '362', '2', '362', '2017-11-28', '200', '0', '0', '2', '231', NULL),
('363', '12', '363', '2', '363', '2017-11-28', '245', '0', '0', '2', '228', NULL),
('364', '12', '364', '2', '364', '2017-11-28', '75', '0', '0', '2', '285', NULL),
('365', '12', '365', '2', '365', '2017-11-28', '165', '0', '0', '2', '327', NULL),
('366', '12', '366', '2', '366', '2017-11-30', '245', '0', '0', '2', '296', NULL),
('367', '12', '367', '2', '367', '2017-11-30', '490', '0', '0', '2', '220', NULL),
('368', '12', '368', '2', '368', '2017-12-05', '50', '0', '0', '2', '272', NULL),
('369', '12', '369', '2', '369', '2017-12-28', '350', '0', '0', '2', '236', NULL),
('370', '12', '370', '2', '370', '2018-01-10', '580', '0', '0', '2', '220', NULL),
('371', '12', '371', '2', '371', '2018-01-26', '419', '0', '0', '2', '273', NULL),
('372', '12', '372', '2', '372', '2018-01-31', '179', '0', '0', '2', '225', NULL),
('373', '12', '373', '2', '373', '2018-02-02', '329', '0', '0', '2', '295', NULL),
('374', '12', '374', '2', '374', '2018-02-05', '378', '0', '0', '2', '245', NULL),
('375', '12', '375', '2', '375', '2018-02-05', '179', '0', '0', '2', '248', NULL),
('376', '12', '376', '2', '376', '2018-02-08', '388', '0', '0', '2', '273', NULL),
('377', '12', '377', '2', '377', '2018-02-19', '490', '0', '0', '2', '225', NULL),
('378', '12', '378', '2', '378', '2018-03-08', '149', '0', '0', '2', '255', NULL),
('379', '12', '379', '2', '379', '2018-03-09', '477', '0', '0', '2', '238', NULL),
('380', '12', '380', '2', '380', '2018-03-09', '149', '0', '0', '2', '245', NULL),
('381', '12', '381', '2', '381', '2018-03-09', '149', '0', '0', '2', '245', NULL),
('382', '12', '382', '2', '382', '2018-03-09', '500', '0', '0', '2', '264', NULL),
('383', '12', '383', '2', '383', '2018-03-22', '428', '0', '0', '2', '267', NULL),
('384', '12', '384', '2', '384', '2018-03-22', '249', '0', '0', '2', '247', NULL),
('385', '12', '385', '2', '385', '2018-03-23', '490', '0', '0', '2', '259', NULL),
('386', '12', '386', '2', '386', '2018-03-23', '249', '0', '0', '2', '281', NULL),
('387', '12', '387', '2', '387', '2018-03-29', '398', '0', '0', '2', '263', NULL),
('388', '12', '388', '2', '388', '2018-04-04', '249', '0', '0', '2', '229', NULL),
('389', '12', '389', '2', '389', '2018-04-10', '249', '0', '0', '2', '220', NULL),
('390', '12', '390', '2', '390', '2018-04-10', '249', '0', '0', '2', '243', NULL),
('391', '12', '391', '2', '391', '2018-04-18', '149', '0', '0', '2', '296', NULL),
('392', '12', '392', '2', '392', '2018-04-18', '580', '0', '0', '2', '220', NULL),
('393', '12', '393', '2', '393', '2018-05-07', '490', '0', '0', '2', '245', NULL),
('394', '12', '394', '2', '394', '2018-05-12', '150', '0', '0', '2', '296', NULL),
('395', '12', '395', '2', '395', '2018-05-23', '149', '0', '0', '2', '230', NULL),
('396', '12', '396', '2', '396', '2018-05-23', '350', '0', '0', '2', '236', NULL),
('397', '12', '397', '2', '397', '2018-05-23', '249', '0', '0', '2', '268', NULL),
('398', '12', '398', '2', '398', '2018-05-29', '179', '0', '0', '2', '296', NULL),
('399', '12', '399', '2', '399', '2018-06-02', '490', '0', '0', '2', '237', NULL),
('400', '12', '400', '2', '400', '2018-06-13', '149', '0', '0', '2', '324', NULL),
('401', '12', '401', '2', '401', '2018-06-18', '89', '0', '0', '2', '282', NULL),
('402', '12', '402', '2', '402', '2018-06-23', '328', '0', '0', '2', '220', NULL),
('403', '12', '403', '2', '403', '2018-06-23', '350', '0', '0', '2', '220', NULL),
('404', '12', '404', '2', '404', '2018-07-13', '350', '0', '0', '2', '236', NULL),
('405', '12', '405', '2', '405', '2018-07-13', '98', '0', '0', '2', '296', NULL),
('406', '12', '406', '2', '406', '2018-07-20', '398', '0', '0', '2', '290', NULL),
('407', '12', '407', '2', '407', '2018-07-25', '149', '0', '0', '2', '296', NULL),
('408', '12', '408', '2', '408', '2018-07-26', '149', '0', '0', '2', '296', NULL),
('409', '12', '409', '2', '409', '2018-10-01', '179', '0', '0', '2', '248', NULL),
('410', '12', '410', '2', '410', '2018-10-02', '179', '0', '0', '2', '1', NULL),
('411', '12', '411', '2', '411', '2018-10-02', '179', '0', '0', '2', '259', NULL),
('412', '12', '412', '2', '412', '2018-10-05', '149', '0', '0', '2', '296', NULL),
('413', '12', '413', '2', '413', '2018-10-05', '179', '0', '0', '2', '275', NULL),
('414', '12', '414', '2', '414', '2018-10-08', '179', '0', '0', '2', '243', NULL),
('415', '12', '415', '2', '415', '2018-10-18', '179', '0', '0', '2', '296', NULL),
('416', '12', '416', '2', '416', '2018-10-29', '676', '0', '0', '2', '221', NULL),
('417', '12', '417', '2', '417', '2018-10-29', '427', '0', '0', '2', '242', NULL),
('418', '12', '418', '2', '418', '2018-10-29', '248', '0', '0', '2', '316', NULL),
('419', '12', '419', '2', '419', '2018-10-29', '427', '0', '0', '2', '239', NULL),
('420', '12', '420', '2', '420', '2018-10-29', '427', '0', '0', '2', '220', NULL),
('421', '12', '421', '2', '421', '2018-10-30', '350', '0', '0', '2', '220', NULL),
('422', '12', '422', '2', '422', '2018-11-06', '179', '0', '0', '2', '296', NULL),
('423', '12', '423', '2', '423', '2018-11-06', '248', '0', '0', '2', '296', NULL),
('424', '12', '424', '2', '424', '2018-11-08', '248', '0', '0', '2', '268', NULL),
('425', '12', '425', '2', '425', '2018-11-14', '248', '0', '0', '2', '245', NULL),
('426', '12', '426', '2', '426', '2018-11-20', '248', '0', '0', '2', '229', NULL),
('427', '12', '427', '2', '427', '2018-12-17', '249', '0', '0', '2', '242', NULL),
('428', '12', '428', '2', '428', '2018-12-18', '89', '0', '0', '2', '264', NULL),
('429', '12', '429', '2', '429', '2018-12-31', '89', '0', '0', '2', '220', NULL),
('430', '12', '430', '2', '430', '2019-03-16', '89', '0', '0', '2', '222', NULL),
('431', '12', '431', '2', '431', '2019-03-20', '250', '0', '0', '2', '322', NULL),
('432', '12', '432', '2', '432', '2019-03-22', '250', '0', '0', '2', '220', NULL),
('433', '12', '433', '2', '433', '2019-03-29', '248', '0', '0', '2', '236', NULL);

### Structure of table `0_bom` ###

DROP TABLE IF EXISTS `0_bom`;

CREATE TABLE `0_bom` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` char(20) NOT NULL DEFAULT '',
  `component` char(20) NOT NULL DEFAULT '',
  `workcentre_added` int(11) NOT NULL DEFAULT '0',
  `loc_code` char(5) NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT '1',
  PRIMARY KEY (`parent`,`component`,`workcentre_added`,`loc_code`),
  KEY `component` (`component`),
  KEY `id` (`id`),
  KEY `loc_code` (`loc_code`),
  KEY `parent` (`parent`,`loc_code`),
  KEY `workcentre_added` (`workcentre_added`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 ;

### Data of table `0_bom` ###

INSERT INTO `0_bom` VALUES
('1', '3400', '102', '1', 'DEF', '1'),
('2', '3400', '103', '1', 'DEF', '1'),
('5', '3400', '104', '1', 'DEF', '1'),
('4', '3400', '201', '1', 'DEF', '1');

### Structure of table `0_budget_trans` ###

DROP TABLE IF EXISTS `0_budget_trans`;

CREATE TABLE `0_budget_trans` (
  `counter` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL DEFAULT '0',
  `type_no` bigint(16) NOT NULL DEFAULT '1',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) NOT NULL DEFAULT '',
  `memo_` tinytext NOT NULL,
  `amount` double NOT NULL DEFAULT '0',
  `dimension_id` int(11) DEFAULT '0',
  `dimension2_id` int(11) DEFAULT '0',
  `person_type_id` int(11) DEFAULT NULL,
  `person_id` tinyblob,
  PRIMARY KEY (`counter`),
  KEY `Type_and_Number` (`type`,`type_no`),
  KEY `Account` (`account`,`tran_date`,`dimension_id`,`dimension2_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ;

### Data of table `0_budget_trans` ###


### Structure of table `0_chart_class` ###

DROP TABLE IF EXISTS `0_chart_class`;

CREATE TABLE `0_chart_class` (
  `cid` varchar(3) NOT NULL,
  `class_name` varchar(60) NOT NULL DEFAULT '',
  `ctype` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ;

### Data of table `0_chart_class` ###

INSERT INTO `0_chart_class` VALUES
('1', 'Activos', '1', '0'),
('2', 'Pasivos', '2', '0'),
('3', 'Ingresos', '4', '0'),
('4', 'Gastos', '6', '0');

### Structure of table `0_chart_master` ###

DROP TABLE IF EXISTS `0_chart_master`;

CREATE TABLE `0_chart_master` (
  `account_code` varchar(15) NOT NULL DEFAULT '',
  `account_code2` varchar(15) NOT NULL DEFAULT '',
  `account_name` varchar(60) NOT NULL DEFAULT '',
  `account_type` varchar(10) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_code`),
  KEY `account_name` (`account_name`),
  KEY `accounts_by_type` (`account_type`,`account_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ;

### Data of table `0_chart_master` ###

INSERT INTO `0_chart_master` VALUES
('5470', '', 'Aguinaldos', '11', '0'),
('5460', '', 'Subsidios', '11', '0'),
('5450', '', 'Aportes patronales', '11', '0'),
('5440', '', 'RC IVA por pagar', '11', '0'),
('5430', '', 'Honorarios profesionales', '11', '0'),
('5420', '', 'Sueldos, horas extra', '11', '0'),
('5410', '', 'Sueldos y salarios', '11', '0'),
('5100', '', 'Fletes', '10', '0'),
('5060', '', 'Descuentos resibidos', '10', '0'),
('5050', '', 'Venta de materiales', '10', '0'),
('5040', '', 'Variacion en precio de venta', '10', '0'),
('5030', '', 'Materiales fungibles', '10', '0'),
('5020', '', 'Variacion en materiales', '10', '0'),
('5010', '', 'Costo de ventas', '10', '0'),
('4510', '', 'Descuento en Ventas', '9', '0'),
('4500', '', 'Descuento por pronto pago', '9', '0'),
('4450', '', 'Diferencias de cambio', '9', '0'),
('4440', '', 'Intereses', '9', '0'),
('4430', '', 'Empaque y manipuleo', '9', '0'),
('4010', '', 'Ventas', '9', '0'),
('3590', '', 'Resultados Acumulados', '7.1', '0'),
('3350', '', 'Capital social', '7', '0'),
('2680', '', 'Prestamo de terceros', '6', '0'),
('2620', '', 'Prstamo bancario', '6', '0'),
('2380', '', 'Cuenta Z por pagar', '5', '0'),
('2370', '', 'Cuenta Y por pagar', '5', '0'),
('2360', '', 'cuenta x por pagar', '5', '0'),
('2350', '', 'Operaciones pendientes', '5', '0'),
('2340', '', 'Provision para aguinaldos', '5', '0'),
('2330', '', 'Prevision para indemnizacion', '5', '0'),
('2320', '', 'AFPs por pagar', '5', '0'),
('2310', '', 'Aguinaldos por pagar', '5', '0'),
('2240', '', 'Beneficios por pagar', '5', '0'),
('2230', '', 'Sueldos y salarios por pagar', '5', '0'),
('2220', '', 'Retenciones por pagar', '5', '0'),
('2210', '', 'IT por pagar (fact comput)', '5', '0'),
('2160', '', 'IT por pagar', '5', '0'),
('2150', '', 'Debito Fiscal', '5', '0'),
('2140', '', 'Debito Fiscal (facturacion computarizada)', '5', '0'),
('2130', '', 'RC IVA por pagar', '5', '0'),
('2120', '', 'Tasas y patentes', '5', '0'),
('2110', '', 'IUE por pagar', '5', '0'),
('2100', '', 'Cuentas por pagar', '5', '0'),
('1845', '', 'Dep. Accum. Vehiculos', '4', '0'),
('1840', '', 'Vehiculos', '4', '0'),
('1825', '', 'Dep. Acum. Muebles y enseres', '4', '0'),
('1820', '', 'Muebles y enseres', '4', '0'),
('1550', '', 'Productos a cuenta', '3', '0'),
('1540', '', 'Produccin terminada', '3', '0'),
('1530', '', 'Produccin en proceso', '3', '0'),
('1520', '', 'Materia prima', '3', '0'),
('1510', '', 'Inventarios', '3', '0'),
('1205', '', 'Provision cuentas incobrables', '2', '0'),
('1200', '', 'Cuentas por cobrar', '2', '0'),
('1065', '', 'Caja', '1', '0'),
('1060', '', 'Bancos', '1', '0'),
('5510', '', 'Indemnizaciones', '11', '0'),
('5520', '', 'Vacaciones', '11', '0'),
('5530', '', 'Otros beneficios al personal', '11', '0'),
('5540', '', 'otros por pagar personal', '11', '0'),
('5550', '', 'Bonos al personal por pagar', '11', '0'),
('5560', '', 'Canastones y similares', '11', '0'),
('5610', '', 'Retenciones ', '12', '0'),
('5615', '', 'Tasas y patentes', '12', '0'),
('5620', '', 'Debitos a regularizar', '12', '0'),
('5660', '', 'Depreciaciones', '12', '0'),
('5685', '', 'IT (fact comput)', '12', '0'),
('5690', '', 'IT', '12', '0'),
('5700', '', 'Material de escritorio', '12', '0'),
('5760', '', 'Alquileres', '12', '0'),
('5765', '', 'Mantenimiento y reparaciones', '12', '0'),
('5780', '', 'Servicios basicos', '12', '0'),
('5785', '', 'Viajes y entretenimiento', '12', '0'),
('5790', '', 'Membresias', '12', '0'),
('5795', '', 'AITB', '12', '0'),
('5800', '', 'IUE', '12', '0'),
('5810', '', 'Otros gastos', '12', '0'),
('9990', '', 'Perdidas y ganancias', '12', '0'),
('1301', '', 'Crdito Fiscal IVA', '2', '0');

### Structure of table `0_chart_types` ###

DROP TABLE IF EXISTS `0_chart_types`;

CREATE TABLE `0_chart_types` (
  `id` varchar(10) NOT NULL,
  `name` varchar(60) NOT NULL DEFAULT '',
  `class_id` varchar(3) NOT NULL DEFAULT '',
  `parent` varchar(10) NOT NULL DEFAULT '-1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `class_id` (`class_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ;

### Data of table `0_chart_types` ###

INSERT INTO `0_chart_types` VALUES
('11', 'Gastos factor trabajo', '4', '', '0'),
('10', 'Costos', '4', '', '0'),
('9', 'Otros ingresos', '3', '', '0'),
('8', 'Ventas', '3', '', '0'),
('7.1', 'Resultados Acumulados', '2', '', '0'),
('7', 'Patrimonio', '2', '', '0'),
('6', 'Pasivos a Largo plazo', '2', '', '0'),
('5', 'Pasivos a corto plazo', '2', '', '0'),
('4', 'Activo Fijo', '1', '', '0'),
('1', 'Disponible', '1', '', '0'),
('3', 'Realizable', '1', '', '0'),
('12', 'Gastos administrativos y generales', '4', '', '0'),
('2', 'Exigible', '1', '', '0');

### Structure of table `0_comments` ###

DROP TABLE IF EXISTS `0_comments`;

CREATE TABLE `0_comments` (
  `type` int(11) NOT NULL DEFAULT '0',
  `id` int(11) NOT NULL DEFAULT '0',
  `date_` date DEFAULT '0000-00-00',
  `memo_` tinytext,
  KEY `type_and_id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ;

### Data of table `0_comments` ###

INSERT INTO `0_comments` VALUES
('17', '1', '2017-07-25', 'safas'),
('12', '1', '2017-09-15', 'Factura de Contado 2'),
('12', '2', '2017-09-15', 'Factura de Contado 3'),
('12', '3', '2017-09-15', 'Factura de Contado 4'),
('12', '4', '2017-09-15', 'Factura de Contado 5'),
('12', '5', '2017-09-15', 'Factura de Contado 6'),
('12', '6', '2017-09-15', 'Factura de Contado 7'),
('12', '7', '2017-09-15', 'Factura de Contado 8'),
('12', '8', '2017-09-15', 'Factura de Contado 9'),
('12', '9', '2017-09-15', 'Factura de Contado 10'),
('12', '10', '2017-09-15', 'Factura de Contado 11'),
('12', '11', '2017-09-15', 'Factura de Contado 12'),
('12', '12', '2017-09-15', 'Factura de Contado 13'),
('12', '13', '2017-09-15', 'Factura de Contado 14'),
('12', '14', '2017-09-15', 'Factura de Contado 15'),
('12', '15', '2017-09-15', 'Factura de Contado 16'),
('12', '16', '2017-09-15', 'Factura de Contado 17'),
('12', '17', '2017-09-15', 'Factura de Contado 18'),
('12', '18', '2017-09-15', 'Factura de Contado 19'),
('12', '19', '2017-09-15', 'Factura de Contado 20'),
('12', '20', '2017-09-15', 'Factura de Contado 21'),
('12', '21', '2017-09-15', 'Factura de Contado 22'),
('12', '22', '2017-09-15', 'Factura de Contado 23'),
('12', '23', '2017-09-15', 'Factura de Contado 24'),
('12', '24', '2017-09-15', 'Factura de Contado 25'),
('12', '25', '2017-09-15', 'Factura de Contado 26'),
('12', '26', '2017-09-15', 'Factura de Contado 27'),
('12', '27', '2017-09-15', 'Factura de Contado 28'),
('12', '28', '2017-09-16', 'Factura de Contado 29'),
('12', '29', '2017-09-18', 'Factura de Contado 30'),
('12', '30', '2017-09-18', 'Factura de Contado 31'),
('12', '31', '2017-09-18', 'Factura de Contado 32'),
('12', '32', '2017-09-18', 'Factura de Contado 33'),
('12', '33', '2017-09-18', 'Factura de Contado 34'),
('12', '34', '2017-09-18', 'Factura de Contado 35'),
('12', '35', '2017-09-18', 'Factura de Contado 36'),
('12', '36', '2017-09-18', 'Factura de Contado 37'),
('12', '37', '2017-09-18', 'Factura de Contado 38'),
('12', '38', '2017-09-18', 'Factura de Contado 39'),
('12', '39', '2017-09-18', 'Factura de Contado 40'),
('12', '40', '2017-09-18', 'Factura de Contado 41'),
('12', '41', '2017-09-18', 'Factura de Contado 42'),
('12', '42', '2017-09-18', 'Factura de Contado 43'),
('12', '43', '2017-09-18', 'Factura de Contado 44'),
('12', '44', '2017-09-18', 'Factura de Contado 45'),
('12', '45', '2017-09-18', 'Factura de Contado 46'),
('12', '46', '2017-09-18', 'Factura de Contado 47'),
('12', '47', '2017-09-18', 'Factura de Contado 48'),
('12', '48', '2017-09-18', 'Factura de Contado 49'),
('12', '49', '2017-09-18', 'Factura de Contado 50'),
('12', '50', '2017-09-18', 'Factura de Contado 51'),
('12', '51', '2017-09-18', 'Factura de Contado 52'),
('12', '52', '2017-09-18', 'Factura de Contado 53'),
('12', '53', '2017-09-18', 'Factura de Contado 54'),
('12', '54', '2017-09-18', 'Factura de Contado 55'),
('12', '55', '2017-09-18', 'Factura de Contado 56'),
('12', '56', '2017-09-18', 'Factura de Contado 57'),
('12', '57', '2017-09-18', 'Factura de Contado 58'),
('12', '58', '2017-09-18', 'Factura de Contado 59'),
('12', '59', '2017-09-18', 'Factura de Contado 60'),
('12', '60', '2017-09-18', 'Factura de Contado 61'),
('12', '61', '2017-09-18', 'Factura de Contado 62'),
('12', '62', '2017-09-18', 'Factura de Contado 63'),
('12', '63', '2017-09-18', 'Factura de Contado 64'),
('12', '64', '2017-09-18', 'Factura de Contado 65'),
('12', '65', '2017-09-18', 'Factura de Contado 66'),
('12', '66', '2017-09-18', 'Factura de Contado 67'),
('12', '67', '2017-09-18', 'Factura de Contado 68'),
('12', '68', '2017-09-18', 'Factura de Contado 69'),
('12', '69', '2017-09-18', 'Factura de Contado 70'),
('12', '70', '2017-09-18', 'Factura de Contado 71'),
('12', '71', '2017-09-18', 'Factura de Contado 72'),
('12', '72', '2017-09-18', 'Factura de Contado 73'),
('12', '73', '2017-09-18', 'Factura de Contado 74'),
('12', '74', '2017-09-18', 'Factura de Contado 75'),
('12', '75', '2017-09-18', 'Factura de Contado 76'),
('12', '76', '2017-09-18', 'Factura de Contado 77'),
('12', '77', '2017-09-18', 'Factura de Contado 78'),
('12', '78', '2017-09-18', 'Factura de Contado 79'),
('12', '79', '2017-09-18', 'Factura de Contado 80'),
('12', '80', '2017-09-18', 'Factura de Contado 81'),
('12', '81', '2017-09-19', 'Factura de Contado 82'),
('12', '82', '2017-09-19', 'Factura de Contado 83'),
('12', '83', '2017-09-19', 'Factura de Contado 84'),
('12', '84', '2017-09-19', 'Factura de Contado 85'),
('12', '85', '2017-09-19', 'Factura de Contado 86'),
('12', '86', '2017-09-19', 'Factura de Contado 87'),
('12', '87', '2017-09-19', 'Factura de Contado 88'),
('12', '88', '2017-09-19', 'Factura de Contado 89'),
('12', '89', '2017-09-19', 'Factura de Contado 90'),
('12', '90', '2017-09-19', 'Factura de Contado 91'),
('12', '91', '2017-09-19', 'Factura de Contado 92'),
('12', '92', '2017-09-19', 'Factura de Contado 93'),
('12', '93', '2017-09-19', 'Factura de Contado 94'),
('12', '94', '2017-09-19', 'Factura de Contado 95'),
('12', '95', '2017-09-19', 'Factura de Contado 96'),
('12', '96', '2017-09-19', 'Factura de Contado 97'),
('12', '97', '2017-09-19', 'Factura de Contado 98'),
('12', '98', '2017-09-19', 'Factura de Contado 99'),
('12', '99', '2017-09-19', 'Factura de Contado 100'),
('12', '100', '2017-09-19', 'Factura de Contado 101'),
('12', '101', '2017-09-19', 'Factura de Contado 102'),
('12', '102', '2017-09-19', 'Factura de Contado 103'),
('12', '103', '2017-09-19', 'Factura de Contado 104'),
('12', '104', '2017-09-19', 'Factura de Contado 105'),
('12', '105', '2017-09-19', 'Factura de Contado 106'),
('12', '106', '2017-09-19', 'Factura de Contado 107'),
('12', '107', '2017-09-19', 'Factura de Contado 108'),
('12', '108', '2017-09-19', 'Factura de Contado 109'),
('12', '109', '2017-09-19', 'Factura de Contado 110'),
('12', '110', '2017-09-20', 'Factura de Contado 111'),
('12', '111', '2017-09-20', 'Factura de Contado 112'),
('12', '112', '2017-09-20', 'Factura de Contado 113'),
('12', '113', '2017-09-20', 'Factura de Contado 114'),
('12', '114', '2017-09-20', 'Factura de Contado 115'),
('12', '115', '2017-09-20', 'Factura de Contado 116'),
('12', '116', '2017-09-20', 'Factura de Contado 117'),
('12', '117', '2017-09-20', 'Factura de Contado 118'),
('12', '118', '2017-09-20', 'Factura de Contado 119'),
('12', '119', '2017-09-20', 'Factura de Contado 120'),
('12', '120', '2017-09-20', 'Factura de Contado 121'),
('12', '121', '2017-09-20', 'Factura de Contado 122'),
('12', '122', '2017-09-20', 'Factura de Contado 123'),
('12', '123', '2017-09-20', 'Factura de Contado 124'),
('12', '124', '2017-09-20', 'Factura de Contado 125'),
('12', '125', '2017-09-20', 'Factura de Contado 126'),
('12', '126', '2017-09-21', 'Factura de Contado 127'),
('12', '127', '2017-09-21', 'Factura de Contado 128'),
('12', '128', '2017-09-21', 'Factura de Contado 129'),
('12', '129', '2017-09-21', 'Factura de Contado 130'),
('12', '130', '2017-09-21', 'Factura de Contado 131'),
('12', '131', '2017-09-21', 'Factura de Contado 132'),
('12', '132', '2017-09-21', 'Factura de Contado 133'),
('12', '133', '2017-09-21', 'Factura de Contado 134'),
('12', '134', '2017-09-21', 'Factura de Contado 135'),
('12', '135', '2017-09-21', 'Factura de Contado 136'),
('12', '136', '2017-09-21', 'Factura de Contado 137'),
('12', '137', '2017-09-21', 'Factura de Contado 138'),
('12', '138', '2017-09-21', 'Factura de Contado 139'),
('12', '139', '2017-09-21', 'Factura de Contado 140'),
('12', '140', '2017-09-21', 'Factura de Contado 141'),
('12', '141', '2017-09-21', 'Factura de Contado 142'),
('12', '142', '2017-09-21', 'Factura de Contado 143'),
('12', '143', '2017-09-25', 'Factura de Contado 144'),
('12', '144', '2017-09-25', 'Factura de Contado 145'),
('12', '145', '2017-09-25', 'Factura de Contado 146'),
('12', '146', '2017-09-25', 'Factura de Contado 147'),
('12', '147', '2017-09-25', 'Factura de Contado 148'),
('12', '148', '2017-09-25', 'Factura de Contado 149'),
('12', '149', '2017-09-25', 'Factura de Contado 150'),
('12', '150', '2017-09-25', 'Factura de Contado 151'),
('12', '151', '2017-09-25', 'Factura de Contado 152'),
('12', '152', '2017-09-25', 'Factura de Contado 153'),
('12', '153', '2017-09-25', 'Factura de Contado 154'),
('12', '154', '2017-09-25', 'Factura de Contado 155'),
('12', '155', '2017-09-25', 'Factura de Contado 156'),
('12', '156', '2017-09-25', 'Factura de Contado 157'),
('12', '157', '2017-09-25', 'Factura de Contado 158'),
('12', '158', '2017-09-27', 'Factura de Contado 159'),
('12', '159', '2017-09-27', 'Factura de Contado 160'),
('12', '160', '2017-09-27', 'Factura de Contado 161'),
('12', '161', '2017-09-27', 'Factura de Contado 162'),
('12', '162', '2017-09-27', 'Factura de Contado 163'),
('12', '163', '2017-09-27', 'Factura de Contado 164'),
('12', '164', '2017-09-27', 'Factura de Contado 165'),
('12', '165', '2017-09-27', 'Factura de Contado 166'),
('12', '166', '2017-09-27', 'Factura de Contado 167'),
('12', '167', '2017-09-27', 'Factura de Contado 168'),
('12', '168', '2017-09-27', 'Factura de Contado 169'),
('12', '169', '2017-09-27', 'Factura de Contado 170'),
('12', '170', '2017-09-29', 'Factura de Contado 171'),
('12', '171', '2017-09-29', 'Factura de Contado 172'),
('12', '172', '2017-09-29', 'Factura de Contado 173'),
('12', '173', '2017-09-29', 'Factura de Contado 174'),
('12', '174', '2017-09-29', 'Factura de Contado 175'),
('12', '175', '2017-09-29', 'Factura de Contado 176'),
('12', '176', '2017-09-29', 'Factura de Contado 177'),
('12', '177', '2017-09-29', 'Factura de Contado 178'),
('12', '178', '2017-09-29', 'Factura de Contado 179'),
('12', '179', '2017-09-29', 'Factura de Contado 180'),
('12', '180', '2017-09-29', 'Factura de Contado 181'),
('12', '181', '2017-09-29', 'Factura de Contado 182'),
('12', '182', '2017-09-29', 'Factura de Contado 183'),
('12', '183', '2017-09-28', 'Factura de Contado 184'),
('12', '184', '2017-09-28', 'Factura de Contado 185'),
('12', '185', '2017-09-28', 'Factura de Contado 186'),
('12', '186', '2017-10-02', 'Factura de Contado 187'),
('12', '187', '2017-10-02', 'Factura de Contado 188'),
('12', '188', '2017-10-02', 'Factura de Contado 189'),
('12', '189', '2017-10-02', 'Factura de Contado 190'),
('12', '190', '2017-10-02', 'Factura de Contado 191'),
('12', '191', '2017-10-02', 'Factura de Contado 192'),
('12', '192', '2017-10-02', 'Factura de Contado 193'),
('12', '193', '2017-10-02', 'Factura de Contado 194'),
('12', '194', '2017-10-02', 'Factura de Contado 195'),
('12', '195', '2017-10-02', 'Factura de Contado 196'),
('12', '196', '2017-10-02', 'Factura de Contado 197'),
('12', '197', '2017-10-02', 'Factura de Contado 198'),
('12', '198', '2017-10-02', 'Factura de Contado 199'),
('12', '199', '2017-10-02', 'Factura de Contado 200'),
('12', '200', '2017-10-02', 'Factura de Contado 201'),
('12', '201', '2017-10-02', 'Factura de Contado 202'),
('12', '202', '2017-10-03', 'Factura de Contado 203'),
('12', '203', '2017-10-03', 'Factura de Contado 204'),
('12', '204', '2017-10-03', 'Factura de Contado 205'),
('12', '205', '2017-10-03', 'Factura de Contado 206'),
('12', '206', '2017-10-03', 'Factura de Contado 207'),
('12', '207', '2017-10-03', 'Factura de Contado 208'),
('12', '208', '2017-10-03', 'Factura de Contado 209'),
('12', '209', '2017-10-03', 'Factura de Contado 210'),
('12', '210', '2017-10-03', 'Factura de Contado 211'),
('12', '211', '2017-10-03', 'Factura de Contado 212'),
('12', '212', '2017-10-03', 'Factura de Contado 213'),
('12', '213', '2017-10-03', 'Factura de Contado 214'),
('12', '214', '2017-10-05', 'Factura de Contado 215'),
('12', '215', '2017-10-05', 'Factura de Contado 216'),
('12', '216', '2017-10-05', 'Factura de Contado 217'),
('12', '217', '2017-10-05', 'Factura de Contado 218'),
('12', '218', '2017-10-05', 'Factura de Contado 219'),
('12', '219', '2017-10-05', 'Factura de Contado 220'),
('12', '220', '2017-10-05', 'Factura de Contado 221'),
('12', '221', '2017-10-05', 'Factura de Contado 222'),
('12', '222', '2017-10-05', 'Factura de Contado 223'),
('12', '223', '2017-10-05', 'Factura de Contado 224'),
('12', '224', '2017-10-05', 'Factura de Contado 225'),
('12', '225', '2017-10-05', 'Factura de Contado 226'),
('12', '226', '2017-10-05', 'Factura de Contado 227'),
('12', '227', '2017-10-06', 'Factura de Contado 228'),
('12', '228', '2017-10-06', 'Factura de Contado 229'),
('12', '229', '2017-10-06', 'Factura de Contado 230'),
('12', '230', '2017-10-06', 'Factura de Contado 231'),
('12', '231', '2017-10-06', 'Factura de Contado 232'),
('12', '232', '2017-10-09', 'Factura de Contado 233'),
('12', '233', '2017-10-10', 'Factura de Contado 234'),
('12', '234', '2017-10-11', 'Factura de Contado 235'),
('12', '235', '2017-10-11', 'Factura de Contado 236'),
('12', '236', '2017-10-11', 'Factura de Contado 237'),
('12', '237', '2017-10-11', 'Factura de Contado 238'),
('12', '238', '2017-10-11', 'Factura de Contado 239'),
('12', '239', '2017-10-11', 'Factura de Contado 240'),
('12', '240', '2017-10-11', 'Factura de Contado 241'),
('12', '241', '2017-10-11', 'Factura de Contado 242'),
('12', '242', '2017-10-11', 'Factura de Contado 243'),
('12', '243', '2017-10-11', 'Factura de Contado 244'),
('12', '244', '2017-10-11', 'Factura de Contado 245'),
('12', '245', '2017-10-11', 'Factura de Contado 246'),
('12', '246', '2017-10-11', 'Factura de Contado 247'),
('12', '247', '2017-10-12', 'Factura de Contado 248'),
('12', '248', '2017-10-12', 'Factura de Contado 249'),
('12', '249', '2017-10-12', 'Factura de Contado 250'),
('12', '250', '2017-10-12', 'Factura de Contado 251'),
('12', '251', '2017-10-12', 'Factura de Contado 252'),
('12', '252', '2017-10-12', 'Factura de Contado 253'),
('12', '253', '2017-10-12', 'Factura de Contado 254'),
('12', '254', '2017-10-12', 'Factura de Contado 255'),
('12', '255', '2017-10-12', 'Factura de Contado 256'),
('12', '256', '2017-10-12', 'Factura de Contado 257'),
('12', '257', '2017-10-12', 'Factura de Contado 258'),
('12', '258', '2017-10-12', 'Factura de Contado 259'),
('12', '259', '2017-10-12', 'Factura de Contado 260'),
('12', '260', '2017-10-12', 'Factura de Contado 261'),
('12', '261', '2017-10-13', 'Factura de Contado 262'),
('12', '262', '2017-10-13', 'Factura de Contado 263'),
('12', '263', '2017-10-13', 'Factura de Contado 264'),
('12', '264', '2017-10-13', 'Factura de Contado 265'),
('12', '265', '2017-10-13', 'Factura de Contado 266'),
('12', '266', '2017-10-13', 'Factura de Contado 267'),
('12', '267', '2017-10-13', 'Factura de Contado 268'),
('12', '268', '2017-10-17', 'Factura de Contado 269'),
('12', '269', '2017-10-17', 'Factura de Contado 270'),
('12', '270', '2017-10-17', 'Factura de Contado 271'),
('12', '271', '2017-10-17', 'Factura de Contado 272'),
('12', '272', '2017-10-17', 'Factura de Contado 273'),
('12', '273', '2017-10-17', 'Factura de Contado 274'),
('12', '274', '2017-10-17', 'Factura de Contado 275'),
('12', '275', '2017-10-17', 'Factura de Contado 276'),
('12', '276', '2017-10-17', 'Factura de Contado 277'),
('12', '277', '2017-10-17', 'Factura de Contado 278'),
('12', '278', '2017-10-17', 'Factura de Contado 279'),
('12', '279', '2017-10-17', 'Factura de Contado 280'),
('12', '280', '2017-10-17', 'Factura de Contado 281'),
('12', '281', '2017-10-17', 'Factura de Contado 282'),
('12', '282', '2017-10-19', 'Factura de Contado 283'),
('12', '283', '2017-10-19', 'Factura de Contado 284'),
('12', '284', '2017-10-19', 'Factura de Contado 285'),
('12', '285', '2017-10-19', 'Factura de Contado 286'),
('12', '286', '2017-10-19', 'Factura de Contado 287'),
('12', '287', '2017-10-19', 'Factura de Contado 288'),
('12', '288', '2017-10-19', 'Factura de Contado 289'),
('12', '289', '2017-10-19', 'Factura de Contado 290'),
('12', '290', '2017-10-19', 'Factura de Contado 291'),
('12', '291', '2017-10-19', 'Factura de Contado 292'),
('12', '292', '2017-10-19', 'Factura de Contado 293'),
('12', '293', '2017-10-19', 'Factura de Contado 294'),
('12', '294', '2017-10-19', 'Factura de Contado 295'),
('12', '295', '2017-10-19', 'Factura de Contado 296'),
('12', '296', '2017-10-19', 'Factura de Contado 297'),
('12', '297', '2017-10-23', 'Factura de Contado 298'),
('12', '298', '2017-10-23', 'Factura de Contado 299'),
('12', '299', '2017-10-23', 'Factura de Contado 300'),
('12', '300', '2017-10-23', 'Factura de Contado 301'),
('12', '301', '2017-10-23', 'Factura de Contado 302'),
('12', '302', '2017-10-23', 'Factura de Contado 303'),
('12', '303', '2017-10-23', 'Factura de Contado 304'),
('12', '304', '2017-10-23', 'Factura de Contado 305'),
('12', '305', '2017-10-23', 'Factura de Contado 306'),
('12', '306', '2017-10-23', 'Factura de Contado 307'),
('12', '307', '2017-10-23', 'Factura de Contado 308'),
('12', '308', '2017-10-23', 'Factura de Contado 309'),
('12', '309', '2017-10-25', 'Factura de Contado 310'),
('12', '310', '2017-10-25', 'Factura de Contado 311'),
('12', '311', '2017-10-25', 'Factura de Contado 312'),
('12', '312', '2017-10-25', 'Factura de Contado 313'),
('12', '313', '2017-10-25', 'Factura de Contado 314'),
('12', '314', '2017-10-25', 'Factura de Contado 315'),
('12', '315', '2017-10-25', 'Factura de Contado 316'),
('12', '316', '2017-10-25', 'Factura de Contado 317'),
('12', '317', '2017-10-25', 'Factura de Contado 318'),
('12', '318', '2017-10-25', 'Factura de Contado 319'),
('12', '319', '2017-10-25', 'Factura de Contado 320'),
('12', '320', '2017-10-25', 'Factura de Contado 321'),
('12', '321', '2017-10-27', 'Factura de Contado 322'),
('12', '322', '2017-10-27', 'Factura de Contado 323'),
('12', '323', '2017-10-27', 'Factura de Contado 324'),
('12', '324', '2017-10-27', 'Factura de Contado 325'),
('12', '325', '2017-10-27', 'Factura de Contado 326'),
('12', '326', '2017-10-27', 'Factura de Contado 327'),
('12', '327', '2017-10-27', 'Factura de Contado 328'),
('12', '328', '2017-10-27', 'Factura de Contado 329'),
('12', '329', '2017-11-03', 'Factura de Contado 330'),
('12', '330', '2017-11-06', 'Factura de Contado 331'),
('12', '331', '2017-11-06', 'Factura de Contado 332'),
('12', '332', '2017-11-07', 'Factura de Contado 333'),
('12', '333', '2017-11-07', 'Factura de Contado 334'),
('12', '334', '2017-11-07', 'Factura de Contado 335'),
('12', '335', '2017-11-07', 'Factura de Contado 336'),
('12', '336', '2017-11-07', 'Factura de Contado 337'),
('12', '337', '2017-11-07', 'Factura de Contado 338'),
('12', '338', '2017-11-07', 'Factura de Contado 339'),
('12', '339', '2017-11-07', 'Factura de Contado 340'),
('12', '340', '2017-11-07', 'Factura de Contado 341'),
('12', '341', '2017-11-07', 'Factura de Contado 342'),
('12', '342', '2017-11-07', 'Factura de Contado 343'),
('12', '343', '2017-11-07', 'Factura de Contado 344'),
('12', '344', '2017-11-07', 'Factura de Contado 345'),
('12', '345', '2017-11-07', 'Factura de Contado 346'),
('12', '346', '2017-11-07', 'Factura de Contado 347'),
('12', '347', '2017-11-07', 'Factura de Contado 348'),
('12', '348', '2017-11-07', 'Factura de Contado 349'),
('12', '349', '2017-11-07', 'Factura de Contado 350'),
('12', '350', '2017-11-07', 'Factura de Contado 351'),
('12', '351', '2017-11-07', 'Factura de Contado 352'),
('12', '352', '2017-11-07', 'Factura de Contado 353'),
('12', '353', '2017-11-07', 'Factura de Contado 354'),
('12', '354', '2017-11-07', 'Factura de Contado 355'),
('12', '355', '2017-11-07', 'Factura de Contado 356'),
('12', '356', '2017-11-14', 'Factura de Contado 369'),
('12', '357', '2017-11-23', 'Factura de Contado 418'),
('12', '358', '2017-11-23', 'Factura de Contado 436'),
('12', '359', '2017-11-28', 'Factura de Contado 462'),
('12', '360', '2017-11-28', 'Factura de Contado 489'),
('12', '361', '2017-11-28', 'Factura de Contado 508'),
('12', '362', '2017-11-28', 'Factura de Contado 529'),
('12', '363', '2017-11-28', 'Factura de Contado 540'),
('12', '364', '2017-11-28', 'Factura de Contado 543'),
('12', '365', '2017-11-28', 'Factura de Contado 567'),
('12', '366', '2017-11-30', 'Factura de Contado 645'),
('12', '367', '2017-11-30', 'Factura de Contado 705'),
('12', '368', '2017-12-05', 'Factura de Contado 740'),
('12', '369', '2017-12-28', 'Factura de Contado 795'),
('12', '370', '2018-01-10', 'Factura de Contado 837'),
('12', '371', '2018-01-26', 'Factura de Contado 943'),
('12', '372', '2018-01-31', 'Factura de Contado 958'),
('12', '373', '2018-02-02', 'Factura de Contado 993'),
('12', '374', '2018-02-05', 'Factura de Contado 1022'),
('12', '375', '2018-02-05', 'Factura de Contado 1023'),
('12', '376', '2018-02-08', 'Factura de Contado 1083'),
('12', '377', '2018-02-19', 'Factura de Contado 1145'),
('12', '378', '2018-03-08', 'Factura de Contado 1253'),
('12', '379', '2018-03-09', 'Factura de Contado 1305'),
('12', '380', '2018-03-09', 'Factura de Contado 1310'),
('12', '381', '2018-03-09', 'Factura de Contado 1314'),
('12', '382', '2018-03-09', 'Factura de Contado 1321'),
('12', '383', '2018-03-22', 'Factura de Contado 1439'),
('12', '384', '2018-03-22', 'Factura de Contado 1444'),
('12', '385', '2018-03-23', 'Factura de Contado 1469'),
('12', '386', '2018-03-23', 'Factura de Contado 1476'),
('12', '387', '2018-03-29', 'Factura de Contado 1624'),
('12', '388', '2018-04-04', 'Factura de Contado 1700'),
('12', '389', '2018-04-10', 'Factura de Contado 1788'),
('12', '390', '2018-04-10', 'Factura de Contado 1789'),
('12', '391', '2018-04-18', 'Factura de Contado 1869'),
('12', '392', '2018-04-18', 'Factura de Contado 1881'),
('12', '393', '2018-05-07', 'Factura de Contado 2046'),
('12', '394', '2018-05-12', 'Factura de Contado 2075'),
('12', '395', '2018-05-23', 'Factura de Contado 2145'),
('12', '396', '2018-05-23', 'Factura de Contado 2147'),
('12', '397', '2018-05-23', 'Factura de Contado 2150'),
('12', '398', '2018-05-29', 'Factura de Contado 2168'),
('12', '399', '2018-06-02', 'Factura de Contado 2183'),
('13', '2239', '2018-06-13', 'INVERSIONES INMOBILIARIAS INDACO S.A.'),
('10', '2239', '2018-06-13', 'INVERSIONES INMOBILIARIAS INDACO S.A.'),
('12', '400', '2018-06-13', 'Factura de Contado 2239'),
('13', '2253', '2018-06-18', 'Quiroga'),
('10', '2253', '2018-06-18', 'Quiroga'),
('12', '401', '2018-06-18', 'Factura de Contado 2253'),
('13', '2272', '2018-06-23', 'COPERAGRO SRL.'),
('10', '2272', '2018-06-23', 'COPERAGRO SRL.'),
('12', '402', '2018-06-23', 'Factura de Contado 2272'),
('13', '2273', '2018-06-23', 'COPERAGRO SRL.'),
('10', '2273', '2018-06-23', 'COPERAGRO SRL.'),
('12', '403', '2018-06-23', 'Factura de Contado 2273'),
('13', '2345', '2018-07-13', 'Tacuarandi srl '),
('10', '2345', '2018-07-13', 'Tacuarandi srl '),
('12', '404', '2018-07-13', 'Factura de Contado 2345'),
('13', '2352', '2018-07-13', 'christian boris copa aquino'),
('10', '2352', '2018-07-13', 'christian boris copa aquino'),
('12', '405', '2018-07-13', 'Factura de Contado 2352'),
('13', '2389', '2018-07-20', 'LABORATORIOS MINERVA S.R.L.'),
('10', '2389', '2018-07-20', 'LABORATORIOS MINERVA S.R.L.'),
('12', '406', '2018-07-20', 'Factura de Contado 2389'),
('13', '2402', '2018-07-25', 'christian boris copa aquino'),
('10', '2402', '2018-07-25', 'christian boris copa aquino'),
('12', '407', '2018-07-25', 'Factura de Contado 2402'),
('13', '2410', '2018-07-26', 'christian boris copa aquino'),
('10', '2410', '2018-07-26', 'christian boris copa aquino'),
('12', '408', '2018-07-26', 'Factura de Contado 2410'),
('13', '2554', '2018-09-11', 'TMF Bolivia SRL'),
('10', '2554', '2018-09-11', 'TMF Bolivia SRL'),
('13', '2638', '2018-10-01', 'Denisse salvatierra'),
('10', '2638', '2018-10-01', 'Denisse salvatierra'),
('12', '409', '2018-10-01', 'Factura de Contado 2638'),
('13', '2670', '2018-10-02', 'GREEN FOREST PRODUCTS S.A.'),
('10', '2670', '2018-10-02', 'GREEN FOREST PRODUCTS S.A.'),
('12', '410', '2018-10-02', 'Factura de Contado 2670'),
('13', '2678', '2018-10-02', 'HUGO PORTILLO'),
('10', '2678', '2018-10-02', 'HUGO PORTILLO'),
('12', '411', '2018-10-02', 'Factura de Contado 2678'),
('13', '2680', '2018-10-04', 'guevara &amp; gumiel asociados srl'),
('10', '2680', '2018-10-04', 'guevara &amp; gumiel asociados srl'),
('13', '2715', '2018-10-05', 'christian boris copa aquino'),
('10', '2715', '2018-10-05', 'christian boris copa aquino'),
('12', '412', '2018-10-05', 'Factura de Contado 2715'),
('13', '2719', '2018-10-05', 'Ramiro Aquino Salazar'),
('10', '2719', '2018-10-05', 'Ramiro Aquino Salazar'),
('12', '413', '2018-10-05', 'Factura de Contado 2719'),
('13', '2731', '2018-10-08', 'Maidana'),
('10', '2731', '2018-10-08', 'Maidana'),
('12', '414', '2018-10-08', 'Factura de Contado 2731'),
('13', '2737', '2018-10-08', 'Dana Lupe Aguilar Rodriguez'),
('10', '2737', '2018-10-08', 'Dana Lupe Aguilar Rodriguez'),
('13', '2757', '2018-10-08', 'MARCELO MONTAO'),
('10', '2757', '2018-10-08', 'MARCELO MONTAO'),
('13', '2800', '2018-10-10', 'Remy Orgaz Antezana'),
('10', '2800', '2018-10-10', 'Remy Orgaz Antezana'),
('13', '2832', '2018-10-15', 'Mario Espada Rivera'),
('10', '2832', '2018-10-15', 'Mario Espada Rivera'),
('13', '2858', '2018-10-18', 'christian boris copa aquino'),
('10', '2858', '2018-10-18', 'christian boris copa aquino'),
('12', '415', '2018-10-18', 'Factura de Contado 2858'),
('13', '2949', '2018-10-29', 'Zilma Salcedo Eamara'),
('10', '2949', '2018-10-29', 'Zilma Salcedo Eamara'),
('12', '416', '2018-10-29', 'Factura de Contado 2949'),
('13', '2959', '2018-10-29', 'PANAMERICAN SECURITIES S.A.'),
('10', '2959', '2018-10-29', 'PANAMERICAN SECURITIES S.A.'),
('12', '417', '2018-10-29', 'Factura de Contado 2959'),
('13', '2962', '2018-10-29', 'SOALPRO S.R.L'),
('10', '2962', '2018-10-29', 'SOALPRO S.R.L'),
('12', '418', '2018-10-29', 'Factura de Contado 2962'),
('13', '2969', '2018-10-29', 'METALES DEL ORIENTE S.R.L.'),
('10', '2969', '2018-10-29', 'METALES DEL ORIENTE S.R.L.'),
('12', '419', '2018-10-29', 'Factura de Contado 2969'),
('13', '2970', '2018-10-29', 'COPERAGRO S.R.L'),
('10', '2970', '2018-10-29', 'COPERAGRO S.R.L'),
('12', '420', '2018-10-29', 'Factura de Contado 2970'),
('13', '2995', '2018-10-30', 'Empresa Minera Sinchi Metals Cv Export S. R. L'),
('10', '2995', '2018-10-30', 'Empresa Minera Sinchi Metals Cv Export S. R. L'),
('13', '3002', '2018-10-30', 'COPERAGRO S.R.L.      '),
('10', '3002', '2018-10-30', 'COPERAGRO S.R.L.      '),
('12', '421', '2018-10-30', 'Factura de Contado 3002'),
('13', '3010', '2018-10-31', 'Jhonny W. Veizaga Araoz'),
('10', '3010', '2018-10-31', 'Jhonny W. Veizaga Araoz'),
('13', '3014', '2018-10-31', 'Javier Lpez'),
('10', '3014', '2018-10-31', 'Javier Lpez'),
('13', '3017', '2018-10-31', 'Mario Antonio Mattos Mercado'),
('10', '3017', '2018-10-31', 'Mario Antonio Mattos Mercado'),
('13', '3027', '2018-11-06', 'CERAMICA BOLITAL S.R.L'),
('10', '3027', '2018-11-06', 'CERAMICA BOLITAL S.R.L'),
('13', '3032', '2018-11-06', 'christian boris copa aquino'),
('10', '3032', '2018-11-06', 'christian boris copa aquino'),
('12', '422', '2018-11-06', 'Factura de Contado 3032'),
('13', '3034', '2018-11-06', 'christian boris copa aquino'),
('10', '3034', '2018-11-06', 'christian boris copa aquino'),
('12', '423', '2018-11-06', 'Factura de Contado 3034'),
('13', '3068', '2018-11-08', 'PRAXIS INGENIERIA SRL'),
('10', '3068', '2018-11-08', 'PRAXIS INGENIERIA SRL'),
('12', '424', '2018-11-08', 'Factura de Contado 3068'),
('13', '3099', '2018-11-14', 'Basatec  Ltda.'),
('10', '3099', '2018-11-14', 'Basatec  Ltda.'),
('12', '425', '2018-11-14', 'Factura de Contado 3099'),
('13', '3131', '2018-11-16', 'CENTRO CULTURAL ALEMN'),
('10', '3131', '2018-11-16', 'CENTRO CULTURAL ALEMN'),
('13', '3152', '2018-11-20', 'COSSIO'),
('10', '3152', '2018-11-20', 'COSSIO'),
('12', '426', '2018-11-20', 'Factura de Contado 3152'),
('13', '3468', '2018-12-17', 'PANAMERICAN SECURITIES S.A.'),
('10', '3468', '2018-12-17', 'PANAMERICAN SECURITIES S.A.'),
('12', '427', '2018-12-17', 'Factura de Contado 3468'),
('13', '3476', '2018-12-18', 'PIRAI LTDA'),
('10', '3476', '2018-12-18', 'PIRAI LTDA'),
('12', '428', '2018-12-18', 'Factura de Contado 3476'),
('13', '3522', '2018-12-31', 'COPERAGRO SRL. '),
('10', '3522', '2018-12-31', 'COPERAGRO SRL. '),
('12', '429', '2018-12-31', 'Factura de Contado 3522'),
('10', '3712', '2019-02-04', '5918708'),
('12', '430', '2019-03-16', 'Factura de Contado 3937'),
('12', '431', '2019-03-20', 'Factura de Contado 3950'),
('12', '432', '2019-03-22', 'Factura de Contado 3974'),
('12', '433', '2019-03-29', 'Factura de Contado 4039');

### Structure of table `0_config` ###

DROP TABLE IF EXISTS `0_config`;

CREATE TABLE `0_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `config_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `config_value` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_config` ###

INSERT INTO `0_config` VALUES
('1', 'visible_tabs', 'orders,stock,GL,system');

### Structure of table `0_credit_status` ###

DROP TABLE IF EXISTS `0_credit_status`;

CREATE TABLE `0_credit_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason_description` char(100) NOT NULL DEFAULT '',
  `dissallow_invoices` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reason_description` (`reason_description`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 ;

### Data of table `0_credit_status` ###

INSERT INTO `0_credit_status` VALUES
('1', 'Buena historia', '0', '0'),
('3', 'No trabajar mas hasta recibir pago', '1', '0'),
('4', 'En liquidacion', '1', '0');

### Structure of table `0_crm_categories` ###

DROP TABLE IF EXISTS `0_crm_categories`;

CREATE TABLE `0_crm_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'pure technical key',
  `type` varchar(20) NOT NULL COMMENT 'contact type e.g. customer',
  `action` varchar(20) NOT NULL COMMENT 'detailed usage e.g. department',
  `name` varchar(30) NOT NULL COMMENT 'for category selector',
  `description` tinytext NOT NULL COMMENT 'usage description',
  `system` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'nonzero for core system usage',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`action`),
  UNIQUE KEY `type_2` (`type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1 ;

### Data of table `0_crm_categories` ###

INSERT INTO `0_crm_categories` VALUES
('1', 'cust_branch', 'general', 'General', 'datos de contacto general de cliente (anula datos por defecto)', '1', '0'),
('2', 'cust_branch', 'invoice', 'Facturas', 'Envio de facturas (anula datos por defecto)', '1', '0'),
('3', 'cust_branch', 'order', 'Ordenes', 'Confirmar ordenes (anula datos por defecto)', '1', '0'),
('4', 'cust_branch', 'delivery', 'Envios', 'Coordinacin de envos (anula datos por defecto)', '1', '0'),
('5', 'customer', 'general', 'General', 'Datos de contacto general de cliente', '1', '0'),
('6', 'customer', 'order', 'Ordenes', 'Confirmar ordenes', '1', '0'),
('7', 'customer', 'delivery', 'Envios', 'Coordinacin de envos', '1', '0'),
('8', 'customer', 'invoice', 'Facturas', 'Envio de facturas', '1', '0'),
('9', 'supplier', 'general', 'General', 'Datos de contacto general de proveedor', '1', '0'),
('10', 'supplier', 'order', 'Ordenes', 'Confirmar ordenes', '1', '0'),
('11', 'supplier', 'delivery', 'Envios', 'Coordinacin de envos', '1', '0'),
('12', 'supplier', 'invoice', 'Facturas', 'Envio de facturas', '1', '0');

### Structure of table `0_crm_contacts` ###

DROP TABLE IF EXISTS `0_crm_contacts`;

CREATE TABLE `0_crm_contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL DEFAULT '0' COMMENT 'foreign key to crm_contacts',
  `type` varchar(20) NOT NULL COMMENT 'foreign key to crm_categories',
  `action` varchar(20) NOT NULL COMMENT 'foreign key to crm_categories',
  `entity_id` varchar(11) DEFAULT NULL COMMENT 'entity id in related class table',
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`action`)
) ENGINE=InnoDB AUTO_INCREMENT=6462 DEFAULT CHARSET=latin1 ;

### Data of table `0_crm_contacts` ###

INSERT INTO `0_crm_contacts` VALUES
('1', '1', 'customer', 'general', '1'),
('3', '3', 'customer', 'general', '3'),
('4', '4', 'cust_branch', 'general', '1'),
('6', '6', 'cust_branch', 'general', '3'),
('7', '7', 'supplier', 'general', '1'),
('8', '8', 'supplier', 'general', '2'),
('9', '9', 'supplier', 'general', '3'),
('10', '10', 'cust_branch', 'general', '4'),
('11', '10', 'customer', 'general', '4'),
('12', '11', 'cust_branch', 'general', '5'),
('13', '11', 'customer', 'general', '5'),
('14', '12', 'cust_branch', 'general', '6'),
('15', '12', 'customer', 'general', '6'),
('16', '13', 'supplier', 'general', '4'),
('17', '14', 'supplier', 'general', '5'),
('18', '15', 'cust_branch', 'general', '7'),
('19', '15', 'customer', 'general', '7'),
('20', '16', 'cust_branch', 'general', '8'),
('21', '16', 'customer', 'general', '8'),
('22', '17', 'cust_branch', 'general', '9'),
('23', '17', 'customer', 'general', '9'),
('24', '18', 'cust_branch', 'general', '10'),
('25', '18', 'customer', 'general', '10'),
('26', '19', 'cust_branch', 'general', '11'),
('27', '19', 'customer', 'general', '11'),
('28', '20', 'cust_branch', 'general', '12'),
('29', '20', 'customer', 'general', '12'),
('30', '21', 'cust_branch', 'general', '13'),
('31', '21', 'customer', 'general', '13'),
('32', '22', 'cust_branch', 'general', '14'),
('33', '22', 'customer', 'general', '14'),
('34', '23', 'cust_branch', 'general', '15'),
('35', '23', 'customer', 'general', '15'),
('36', '24', 'cust_branch', 'general', '16'),
('37', '24', 'customer', 'general', '16'),
('38', '25', 'cust_branch', 'general', '17'),
('39', '25', 'customer', 'general', '17'),
('40', '26', 'cust_branch', 'general', '18'),
('41', '26', 'customer', 'general', '18'),
('42', '27', 'cust_branch', 'general', '19'),
('43', '27', 'customer', 'general', '19'),
('44', '28', 'cust_branch', 'general', '20'),
('45', '28', 'customer', 'general', '20'),
('46', '29', 'cust_branch', 'general', '21'),
('47', '29', 'customer', 'general', '21'),
('48', '30', 'cust_branch', 'general', '22'),
('49', '30', 'customer', 'general', '22'),
('50', '31', 'cust_branch', 'general', '23'),
('51', '31', 'customer', 'general', '23'),
('52', '32', 'cust_branch', 'general', '24'),
('53', '32', 'customer', 'general', '24'),
('54', '33', 'cust_branch', 'general', '1'),
('55', '33', 'customer', 'general', '1'),
('56', '34', 'supplier', 'general', '6'),
('59', '36', 'cust_branch', 'general', '3'),
('60', '36', 'customer', 'general', '3'),
('61', '37', 'cust_branch', 'general', '1'),
('62', '37', 'customer', 'general', '1'),
('65', '39', 'supplier', 'general', '1'),
('66', '1', 'cust_branch', 'general', '3'),
('67', '1', 'customer', 'general', '3'),
('68', '2', 'cust_branch', 'general', '4'),
('69', '2', 'customer', 'general', '4'),
('70', '3', 'cust_branch', 'general', '5'),
('71', '3', 'customer', 'general', '5'),
('72', '4', 'cust_branch', 'general', '6'),
('73', '4', 'customer', 'general', '6'),
('74', '5', 'cust_branch', 'general', '7'),
('75', '5', 'customer', 'general', '7'),
('76', '6', 'cust_branch', 'general', '8'),
('77', '6', 'customer', 'general', '8'),
('78', '7', 'cust_branch', 'general', '9'),
('79', '7', 'customer', 'general', '9'),
('80', '8', 'cust_branch', 'general', '10'),
('81', '8', 'customer', 'general', '10'),
('82', '9', 'cust_branch', 'general', '11'),
('83', '9', 'customer', 'general', '11'),
('84', '10', 'cust_branch', 'general', '12'),
('85', '10', 'customer', 'general', '12'),
('86', '11', 'cust_branch', 'general', '13'),
('87', '11', 'customer', 'general', '13'),
('88', '12', 'cust_branch', 'general', '14'),
('89', '12', 'customer', 'general', '14'),
('90', '13', 'cust_branch', 'general', '15'),
('91', '13', 'customer', 'general', '15'),
('92', '14', 'cust_branch', 'general', '16'),
('93', '14', 'customer', 'general', '16'),
('94', '15', 'cust_branch', 'general', '17'),
('95', '15', 'customer', 'general', '17'),
('96', '16', 'cust_branch', 'general', '18'),
('97', '16', 'customer', 'general', '18'),
('98', '17', 'cust_branch', 'general', '19'),
('99', '17', 'customer', 'general', '19'),
('100', '18', 'cust_branch', 'general', '20'),
('101', '18', 'customer', 'general', '20'),
('102', '19', 'cust_branch', 'general', '21'),
('103', '19', 'customer', 'general', '21'),
('104', '20', 'cust_branch', 'general', '22'),
('105', '20', 'customer', 'general', '22'),
('106', '21', 'cust_branch', 'general', '23'),
('107', '21', 'customer', 'general', '23'),
('108', '22', 'cust_branch', 'general', '24'),
('109', '22', 'customer', 'general', '24'),
('110', '23', 'cust_branch', 'general', '25'),
('111', '23', 'customer', 'general', '25'),
('112', '24', 'cust_branch', 'general', '26'),
('113', '24', 'customer', 'general', '26'),
('114', '25', 'cust_branch', 'general', '27'),
('115', '25', 'customer', 'general', '27'),
('116', '26', 'cust_branch', 'general', '28'),
('117', '26', 'customer', 'general', '28'),
('118', '27', 'cust_branch', 'general', '29'),
('119', '27', 'customer', 'general', '29'),
('120', '28', 'cust_branch', 'general', '30'),
('121', '28', 'customer', 'general', '30'),
('122', '29', 'cust_branch', 'general', '31'),
('123', '29', 'customer', 'general', '31'),
('124', '30', 'cust_branch', 'general', '32'),
('125', '30', 'customer', 'general', '32'),
('126', '31', 'cust_branch', 'general', '33'),
('127', '31', 'customer', 'general', '33'),
('128', '32', 'cust_branch', 'general', '34'),
('129', '32', 'customer', 'general', '34'),
('130', '33', 'cust_branch', 'general', '35'),
('131', '33', 'customer', 'general', '35'),
('132', '34', 'cust_branch', 'general', '36'),
('133', '34', 'customer', 'general', '36'),
('134', '35', 'cust_branch', 'general', '37'),
('135', '35', 'customer', 'general', '37'),
('136', '36', 'cust_branch', 'general', '38'),
('137', '36', 'customer', 'general', '38'),
('138', '37', 'cust_branch', 'general', '39'),
('139', '37', 'customer', 'general', '39'),
('140', '38', 'cust_branch', 'general', '40'),
('141', '38', 'customer', 'general', '40'),
('142', '39', 'cust_branch', 'general', '41'),
('143', '39', 'customer', 'general', '41'),
('144', '40', 'cust_branch', 'general', '42'),
('145', '40', 'customer', 'general', '42'),
('146', '41', 'cust_branch', 'general', '43'),
('147', '41', 'customer', 'general', '43'),
('148', '42', 'cust_branch', 'general', '44'),
('149', '42', 'customer', 'general', '44'),
('150', '43', 'cust_branch', 'general', '45'),
('151', '43', 'customer', 'general', '45'),
('152', '44', 'cust_branch', 'general', '46'),
('153', '44', 'customer', 'general', '46'),
('154', '45', 'cust_branch', 'general', '47'),
('155', '45', 'customer', 'general', '47'),
('156', '46', 'cust_branch', 'general', '48'),
('157', '46', 'customer', 'general', '48'),
('158', '47', 'cust_branch', 'general', '49'),
('159', '47', 'customer', 'general', '49'),
('160', '48', 'cust_branch', 'general', '50'),
('161', '48', 'customer', 'general', '50'),
('162', '49', 'cust_branch', 'general', '51'),
('163', '49', 'customer', 'general', '51'),
('164', '50', 'cust_branch', 'general', '52'),
('165', '50', 'customer', 'general', '52'),
('166', '51', 'cust_branch', 'general', '53'),
('167', '51', 'customer', 'general', '53'),
('168', '52', 'cust_branch', 'general', '54'),
('169', '52', 'customer', 'general', '54'),
('170', '53', 'cust_branch', 'general', '55'),
('171', '53', 'customer', 'general', '55'),
('172', '54', 'cust_branch', 'general', '56'),
('173', '54', 'customer', 'general', '56'),
('174', '55', 'cust_branch', 'general', '57'),
('175', '55', 'customer', 'general', '57'),
('176', '56', 'cust_branch', 'general', '58'),
('177', '56', 'customer', 'general', '58'),
('178', '57', 'cust_branch', 'general', '59'),
('179', '57', 'customer', 'general', '59'),
('180', '58', 'cust_branch', 'general', '60'),
('181', '58', 'customer', 'general', '60'),
('182', '59', 'cust_branch', 'general', '61'),
('183', '59', 'customer', 'general', '61'),
('184', '60', 'cust_branch', 'general', '62'),
('185', '60', 'customer', 'general', '62'),
('186', '61', 'cust_branch', 'general', '63'),
('187', '61', 'customer', 'general', '63'),
('188', '62', 'cust_branch', 'general', '64'),
('189', '62', 'customer', 'general', '64'),
('190', '63', 'cust_branch', 'general', '65'),
('191', '63', 'customer', 'general', '65'),
('192', '64', 'cust_branch', 'general', '66'),
('193', '64', 'customer', 'general', '66'),
('194', '65', 'cust_branch', 'general', '67'),
('195', '65', 'customer', 'general', '67'),
('196', '66', 'cust_branch', 'general', '68'),
('197', '66', 'customer', 'general', '68'),
('198', '67', 'cust_branch', 'general', '69'),
('199', '67', 'customer', 'general', '69'),
('200', '68', 'cust_branch', 'general', '70'),
('201', '68', 'customer', 'general', '70'),
('202', '69', 'cust_branch', 'general', '71'),
('203', '69', 'customer', 'general', '71'),
('204', '70', 'cust_branch', 'general', '72'),
('205', '70', 'customer', 'general', '72'),
('206', '71', 'cust_branch', 'general', '73'),
('207', '71', 'customer', 'general', '73'),
('208', '72', 'cust_branch', 'general', '74'),
('209', '72', 'customer', 'general', '74'),
('210', '73', 'cust_branch', 'general', '75'),
('211', '73', 'customer', 'general', '75'),
('212', '74', 'cust_branch', 'general', '76'),
('213', '74', 'customer', 'general', '76'),
('214', '75', 'cust_branch', 'general', '77'),
('215', '75', 'customer', 'general', '77'),
('216', '76', 'cust_branch', 'general', '78'),
('217', '76', 'customer', 'general', '78'),
('218', '77', 'cust_branch', 'general', '79'),
('219', '77', 'customer', 'general', '79'),
('220', '78', 'cust_branch', 'general', '80'),
('221', '78', 'customer', 'general', '80'),
('222', '79', 'cust_branch', 'general', '81'),
('223', '79', 'customer', 'general', '81'),
('224', '80', 'cust_branch', 'general', '82'),
('225', '80', 'customer', 'general', '82'),
('226', '81', 'cust_branch', 'general', '83'),
('227', '81', 'customer', 'general', '83'),
('228', '82', 'cust_branch', 'general', '84'),
('229', '82', 'customer', 'general', '84'),
('230', '83', 'cust_branch', 'general', '85'),
('231', '83', 'customer', 'general', '85'),
('232', '84', 'cust_branch', 'general', '86'),
('233', '84', 'customer', 'general', '86'),
('234', '85', 'cust_branch', 'general', '87'),
('235', '85', 'customer', 'general', '87'),
('236', '86', 'cust_branch', 'general', '88'),
('237', '86', 'customer', 'general', '88'),
('238', '87', 'cust_branch', 'general', '89'),
('239', '87', 'customer', 'general', '89'),
('240', '88', 'cust_branch', 'general', '90'),
('241', '88', 'customer', 'general', '90'),
('242', '89', 'cust_branch', 'general', '91'),
('243', '89', 'customer', 'general', '91'),
('244', '90', 'cust_branch', 'general', '92'),
('245', '90', 'customer', 'general', '92'),
('246', '91', 'cust_branch', 'general', '93'),
('247', '91', 'customer', 'general', '93'),
('248', '92', 'cust_branch', 'general', '94'),
('249', '92', 'customer', 'general', '94'),
('250', '93', 'cust_branch', 'general', '95'),
('251', '93', 'customer', 'general', '95'),
('252', '94', 'cust_branch', 'general', '96'),
('253', '94', 'customer', 'general', '96'),
('254', '95', 'cust_branch', 'general', '97'),
('255', '95', 'customer', 'general', '97'),
('256', '96', 'cust_branch', 'general', '98'),
('257', '96', 'customer', 'general', '98'),
('258', '97', 'cust_branch', 'general', '99'),
('259', '97', 'customer', 'general', '99'),
('260', '98', 'cust_branch', 'general', '100'),
('261', '98', 'customer', 'general', '100'),
('262', '99', 'cust_branch', 'general', '101'),
('263', '99', 'customer', 'general', '101'),
('264', '100', 'cust_branch', 'general', '102'),
('265', '100', 'customer', 'general', '102'),
('266', '101', 'cust_branch', 'general', '103'),
('267', '101', 'customer', 'general', '103'),
('268', '102', 'cust_branch', 'general', '104'),
('269', '102', 'customer', 'general', '104'),
('270', '103', 'cust_branch', 'general', '105'),
('271', '103', 'customer', 'general', '105'),
('272', '104', 'cust_branch', 'general', '106'),
('273', '104', 'customer', 'general', '106'),
('274', '105', 'cust_branch', 'general', '107'),
('275', '105', 'customer', 'general', '107'),
('276', '106', 'cust_branch', 'general', '108'),
('277', '106', 'customer', 'general', '108'),
('278', '107', 'cust_branch', 'general', '109'),
('279', '107', 'customer', 'general', '109'),
('280', '108', 'cust_branch', 'general', '110'),
('281', '108', 'customer', 'general', '110'),
('282', '109', 'cust_branch', 'general', '111'),
('283', '109', 'customer', 'general', '111'),
('284', '110', 'cust_branch', 'general', '112'),
('285', '110', 'customer', 'general', '112'),
('286', '111', 'cust_branch', 'general', '113'),
('287', '111', 'customer', 'general', '113'),
('288', '112', 'cust_branch', 'general', '114'),
('289', '112', 'customer', 'general', '114'),
('290', '113', 'cust_branch', 'general', '115'),
('291', '113', 'customer', 'general', '115'),
('292', '114', 'cust_branch', 'general', '116'),
('293', '114', 'customer', 'general', '116'),
('294', '115', 'cust_branch', 'general', '117'),
('295', '115', 'customer', 'general', '117'),
('296', '116', 'cust_branch', 'general', '118'),
('297', '116', 'customer', 'general', '118'),
('298', '117', 'cust_branch', 'general', '119'),
('299', '117', 'customer', 'general', '119'),
('300', '118', 'cust_branch', 'general', '120'),
('301', '118', 'customer', 'general', '120'),
('302', '119', 'cust_branch', 'general', '121'),
('303', '119', 'customer', 'general', '121'),
('304', '120', 'cust_branch', 'general', '122'),
('305', '120', 'customer', 'general', '122'),
('306', '121', 'cust_branch', 'general', '123'),
('307', '121', 'customer', 'general', '123'),
('308', '122', 'cust_branch', 'general', '124'),
('309', '122', 'customer', 'general', '124'),
('310', '123', 'cust_branch', 'general', '125'),
('311', '123', 'customer', 'general', '125'),
('312', '124', 'cust_branch', 'general', '126'),
('313', '124', 'customer', 'general', '126'),
('314', '125', 'cust_branch', 'general', '127'),
('315', '125', 'customer', 'general', '127'),
('316', '126', 'cust_branch', 'general', '128'),
('317', '126', 'customer', 'general', '128'),
('318', '127', 'cust_branch', 'general', '129'),
('319', '127', 'customer', 'general', '129'),
('320', '128', 'cust_branch', 'general', '130'),
('321', '128', 'customer', 'general', '130'),
('322', '129', 'cust_branch', 'general', '131'),
('323', '129', 'customer', 'general', '131'),
('324', '130', 'cust_branch', 'general', '132'),
('325', '130', 'customer', 'general', '132'),
('326', '131', 'cust_branch', 'general', '133'),
('327', '131', 'customer', 'general', '133'),
('328', '132', 'cust_branch', 'general', '134'),
('329', '132', 'customer', 'general', '134'),
('330', '133', 'cust_branch', 'general', '135'),
('331', '133', 'customer', 'general', '135'),
('332', '134', 'cust_branch', 'general', '136'),
('333', '134', 'customer', 'general', '136'),
('334', '135', 'cust_branch', 'general', '137'),
('335', '135', 'customer', 'general', '137'),
('336', '136', 'cust_branch', 'general', '138'),
('337', '136', 'customer', 'general', '138'),
('338', '137', 'cust_branch', 'general', '139'),
('339', '137', 'customer', 'general', '139'),
('340', '138', 'cust_branch', 'general', '140'),
('341', '138', 'customer', 'general', '140'),
('342', '139', 'cust_branch', 'general', '141'),
('343', '139', 'customer', 'general', '141'),
('344', '140', 'cust_branch', 'general', '142'),
('345', '140', 'customer', 'general', '142'),
('346', '141', 'cust_branch', 'general', '143'),
('347', '141', 'customer', 'general', '143'),
('348', '142', 'cust_branch', 'general', '144'),
('349', '142', 'customer', 'general', '144'),
('350', '143', 'cust_branch', 'general', '145'),
('351', '143', 'customer', 'general', '145'),
('352', '144', 'cust_branch', 'general', '146'),
('353', '144', 'customer', 'general', '146'),
('354', '145', 'cust_branch', 'general', '147'),
('355', '145', 'customer', 'general', '147'),
('356', '146', 'cust_branch', 'general', '148'),
('357', '146', 'customer', 'general', '148'),
('358', '147', 'cust_branch', 'general', '149'),
('359', '147', 'customer', 'general', '149'),
('360', '148', 'cust_branch', 'general', '150'),
('361', '148', 'customer', 'general', '150'),
('362', '149', 'cust_branch', 'general', '151'),
('363', '149', 'customer', 'general', '151'),
('364', '150', 'cust_branch', 'general', '152'),
('365', '150', 'customer', 'general', '152'),
('366', '151', 'cust_branch', 'general', '153'),
('367', '151', 'customer', 'general', '153'),
('368', '152', 'cust_branch', 'general', '154'),
('369', '152', 'customer', 'general', '154'),
('370', '153', 'cust_branch', 'general', '155'),
('371', '153', 'customer', 'general', '155'),
('372', '154', 'cust_branch', 'general', '156'),
('373', '154', 'customer', 'general', '156'),
('374', '155', 'cust_branch', 'general', '157'),
('375', '155', 'customer', 'general', '157'),
('376', '156', 'cust_branch', 'general', '158'),
('377', '156', 'customer', 'general', '158'),
('378', '157', 'cust_branch', 'general', '159'),
('379', '157', 'customer', 'general', '159'),
('380', '158', 'cust_branch', 'general', '160'),
('381', '158', 'customer', 'general', '160'),
('382', '159', 'cust_branch', 'general', '161'),
('383', '159', 'customer', 'general', '161'),
('384', '160', 'cust_branch', 'general', '162'),
('385', '160', 'customer', 'general', '162'),
('386', '161', 'cust_branch', 'general', '163'),
('387', '161', 'customer', 'general', '163'),
('388', '162', 'cust_branch', 'general', '164'),
('389', '162', 'customer', 'general', '164'),
('390', '163', 'cust_branch', 'general', '165'),
('391', '163', 'customer', 'general', '165'),
('392', '164', 'cust_branch', 'general', '166'),
('393', '164', 'customer', 'general', '166'),
('394', '165', 'cust_branch', 'general', '167'),
('395', '165', 'customer', 'general', '167'),
('396', '166', 'cust_branch', 'general', '168'),
('397', '166', 'customer', 'general', '168'),
('398', '167', 'cust_branch', 'general', '169'),
('399', '167', 'customer', 'general', '169'),
('400', '168', 'cust_branch', 'general', '170'),
('401', '168', 'customer', 'general', '170'),
('402', '169', 'cust_branch', 'general', '171'),
('403', '169', 'customer', 'general', '171'),
('404', '170', 'cust_branch', 'general', '172'),
('405', '170', 'customer', 'general', '172'),
('406', '171', 'cust_branch', 'general', '173'),
('407', '171', 'customer', 'general', '173'),
('408', '172', 'cust_branch', 'general', '174'),
('409', '172', 'customer', 'general', '174'),
('410', '173', 'cust_branch', 'general', '175'),
('411', '173', 'customer', 'general', '175'),
('412', '174', 'cust_branch', 'general', '176'),
('413', '174', 'customer', 'general', '176'),
('414', '175', 'cust_branch', 'general', '177'),
('415', '175', 'customer', 'general', '177'),
('416', '176', 'cust_branch', 'general', '178'),
('417', '176', 'customer', 'general', '178'),
('418', '177', 'cust_branch', 'general', '179'),
('419', '177', 'customer', 'general', '179'),
('420', '178', 'cust_branch', 'general', '180'),
('421', '178', 'customer', 'general', '180'),
('422', '179', 'cust_branch', 'general', '181'),
('423', '179', 'customer', 'general', '181'),
('424', '180', 'cust_branch', 'general', '182'),
('425', '180', 'customer', 'general', '182'),
('426', '181', 'cust_branch', 'general', '183'),
('427', '181', 'customer', 'general', '183'),
('428', '182', 'cust_branch', 'general', '184'),
('429', '182', 'customer', 'general', '184'),
('430', '183', 'cust_branch', 'general', '185'),
('431', '183', 'customer', 'general', '185'),
('432', '184', 'cust_branch', 'general', '186'),
('433', '184', 'customer', 'general', '186'),
('434', '185', 'cust_branch', 'general', '187'),
('435', '185', 'customer', 'general', '187'),
('436', '186', 'cust_branch', 'general', '188'),
('437', '186', 'customer', 'general', '188'),
('438', '187', 'cust_branch', 'general', '189'),
('439', '187', 'customer', 'general', '189'),
('440', '188', 'cust_branch', 'general', '190'),
('441', '188', 'customer', 'general', '190'),
('442', '189', 'cust_branch', 'general', '191'),
('443', '189', 'customer', 'general', '191'),
('444', '190', 'cust_branch', 'general', '192'),
('445', '190', 'customer', 'general', '192'),
('446', '191', 'cust_branch', 'general', '193'),
('447', '191', 'customer', 'general', '193'),
('448', '192', 'cust_branch', 'general', '194'),
('449', '192', 'customer', 'general', '194'),
('450', '193', 'cust_branch', 'general', '195'),
('451', '193', 'customer', 'general', '195'),
('452', '194', 'cust_branch', 'general', '196'),
('453', '194', 'customer', 'general', '196'),
('454', '195', 'cust_branch', 'general', '197'),
('455', '195', 'customer', 'general', '197'),
('456', '196', 'cust_branch', 'general', '198'),
('457', '196', 'customer', 'general', '198'),
('458', '197', 'cust_branch', 'general', '199'),
('459', '197', 'customer', 'general', '199'),
('460', '198', 'cust_branch', 'general', '200'),
('461', '198', 'customer', 'general', '200'),
('462', '199', 'cust_branch', 'general', '201'),
('463', '199', 'customer', 'general', '201'),
('464', '200', 'cust_branch', 'general', '202'),
('465', '200', 'customer', 'general', '202'),
('466', '201', 'cust_branch', 'general', '203'),
('467', '201', 'customer', 'general', '203'),
('468', '202', 'cust_branch', 'general', '204'),
('469', '202', 'customer', 'general', '204'),
('470', '203', 'cust_branch', 'general', '205'),
('471', '203', 'customer', 'general', '205'),
('472', '204', 'cust_branch', 'general', '206'),
('473', '204', 'customer', 'general', '206'),
('474', '205', 'cust_branch', 'general', '207'),
('475', '205', 'customer', 'general', '207'),
('476', '206', 'cust_branch', 'general', '208'),
('477', '206', 'customer', 'general', '208'),
('478', '207', 'cust_branch', 'general', '209'),
('479', '207', 'customer', 'general', '209'),
('480', '208', 'cust_branch', 'general', '210'),
('481', '208', 'customer', 'general', '210'),
('482', '209', 'cust_branch', 'general', '211'),
('483', '209', 'customer', 'general', '211'),
('484', '210', 'cust_branch', 'general', '212'),
('485', '210', 'customer', 'general', '212'),
('486', '211', 'cust_branch', 'general', '213'),
('487', '211', 'customer', 'general', '213'),
('488', '212', 'cust_branch', 'general', '214'),
('489', '212', 'customer', 'general', '214'),
('490', '213', 'cust_branch', 'general', '215'),
('491', '213', 'customer', 'general', '215'),
('492', '214', 'cust_branch', 'general', '216'),
('493', '214', 'customer', 'general', '216'),
('494', '215', 'cust_branch', 'general', '217'),
('495', '215', 'customer', 'general', '217'),
('496', '216', 'cust_branch', 'general', '218'),
('497', '216', 'customer', 'general', '218'),
('498', '217', 'cust_branch', 'general', '219'),
('499', '217', 'customer', 'general', '219'),
('500', '218', 'cust_branch', 'general', '220'),
('501', '218', 'customer', 'general', '220'),
('502', '219', 'cust_branch', 'general', '221'),
('503', '219', 'customer', 'general', '221'),
('504', '220', 'cust_branch', 'general', '222'),
('505', '220', 'customer', 'general', '222'),
('506', '221', 'cust_branch', 'general', '223'),
('507', '221', 'customer', 'general', '223'),
('508', '222', 'cust_branch', 'general', '224'),
('509', '222', 'customer', 'general', '224'),
('510', '223', 'cust_branch', 'general', '225'),
('511', '223', 'customer', 'general', '225'),
('512', '224', 'cust_branch', 'general', '226'),
('513', '224', 'customer', 'general', '226'),
('514', '225', 'cust_branch', 'general', '227'),
('515', '225', 'customer', 'general', '227'),
('516', '226', 'cust_branch', 'general', '228'),
('517', '226', 'customer', 'general', '228'),
('518', '227', 'cust_branch', 'general', '229'),
('519', '227', 'customer', 'general', '229'),
('520', '228', 'cust_branch', 'general', '230'),
('521', '228', 'customer', 'general', '230'),
('522', '229', 'cust_branch', 'general', '231'),
('523', '229', 'customer', 'general', '231'),
('524', '230', 'cust_branch', 'general', '232'),
('525', '230', 'customer', 'general', '232'),
('526', '231', 'cust_branch', 'general', '233'),
('527', '231', 'customer', 'general', '233'),
('528', '232', 'cust_branch', 'general', '234'),
('529', '232', 'customer', 'general', '234'),
('530', '233', 'cust_branch', 'general', '235'),
('531', '233', 'customer', 'general', '235'),
('532', '234', 'cust_branch', 'general', '236'),
('533', '234', 'customer', 'general', '236'),
('534', '235', 'cust_branch', 'general', '237'),
('535', '235', 'customer', 'general', '237'),
('536', '236', 'cust_branch', 'general', '238'),
('537', '236', 'customer', 'general', '238'),
('538', '237', 'cust_branch', 'general', '239'),
('539', '237', 'customer', 'general', '239'),
('540', '238', 'cust_branch', 'general', '240'),
('541', '238', 'customer', 'general', '240'),
('542', '239', 'cust_branch', 'general', '241'),
('543', '239', 'customer', 'general', '241'),
('544', '240', 'cust_branch', 'general', '242'),
('545', '240', 'customer', 'general', '242'),
('546', '241', 'cust_branch', 'general', '243'),
('547', '241', 'customer', 'general', '243'),
('548', '242', 'cust_branch', 'general', '244'),
('549', '242', 'customer', 'general', '244'),
('550', '243', 'cust_branch', 'general', '245'),
('551', '243', 'customer', 'general', '245'),
('552', '244', 'cust_branch', 'general', '246'),
('553', '244', 'customer', 'general', '246'),
('554', '245', 'cust_branch', 'general', '247'),
('555', '245', 'customer', 'general', '247'),
('556', '246', 'cust_branch', 'general', '248'),
('557', '246', 'customer', 'general', '248'),
('558', '247', 'cust_branch', 'general', '249'),
('559', '247', 'customer', 'general', '249'),
('560', '248', 'cust_branch', 'general', '250'),
('561', '248', 'customer', 'general', '250'),
('562', '249', 'cust_branch', 'general', '251'),
('563', '249', 'customer', 'general', '251'),
('564', '250', 'cust_branch', 'general', '252'),
('565', '250', 'customer', 'general', '252'),
('566', '251', 'cust_branch', 'general', '253'),
('567', '251', 'customer', 'general', '253'),
('568', '252', 'cust_branch', 'general', '254'),
('569', '252', 'customer', 'general', '254'),
('570', '253', 'cust_branch', 'general', '255'),
('571', '253', 'customer', 'general', '255'),
('572', '254', 'cust_branch', 'general', '256'),
('573', '254', 'customer', 'general', '256'),
('574', '255', 'cust_branch', 'general', '257'),
('575', '255', 'customer', 'general', '257'),
('576', '256', 'cust_branch', 'general', '258'),
('577', '256', 'customer', 'general', '258'),
('578', '257', 'cust_branch', 'general', '259'),
('579', '257', 'customer', 'general', '259'),
('580', '258', 'cust_branch', 'general', '260'),
('581', '258', 'customer', 'general', '260'),
('582', '259', 'cust_branch', 'general', '261'),
('583', '259', 'customer', 'general', '261'),
('584', '260', 'cust_branch', 'general', '262'),
('585', '260', 'customer', 'general', '262'),
('586', '261', 'cust_branch', 'general', '263'),
('587', '261', 'customer', 'general', '263'),
('588', '262', 'cust_branch', 'general', '264'),
('589', '262', 'customer', 'general', '264'),
('590', '263', 'cust_branch', 'general', '265'),
('591', '263', 'customer', 'general', '265'),
('592', '264', 'cust_branch', 'general', '266'),
('593', '264', 'customer', 'general', '266'),
('594', '265', 'cust_branch', 'general', '267'),
('595', '265', 'customer', 'general', '267'),
('596', '266', 'cust_branch', 'general', '268'),
('597', '266', 'customer', 'general', '268'),
('598', '267', 'cust_branch', 'general', '269'),
('599', '267', 'customer', 'general', '269'),
('600', '268', 'cust_branch', 'general', '270'),
('601', '268', 'customer', 'general', '270'),
('602', '269', 'cust_branch', 'general', '271'),
('603', '269', 'customer', 'general', '271'),
('604', '270', 'cust_branch', 'general', '272'),
('605', '270', 'customer', 'general', '272'),
('606', '271', 'cust_branch', 'general', '273'),
('607', '271', 'customer', 'general', '273'),
('608', '272', 'cust_branch', 'general', '274'),
('609', '272', 'customer', 'general', '274'),
('610', '273', 'cust_branch', 'general', '275'),
('611', '273', 'customer', 'general', '275'),
('612', '274', 'cust_branch', 'general', '276'),
('613', '274', 'customer', 'general', '276'),
('614', '275', 'cust_branch', 'general', '277'),
('615', '275', 'customer', 'general', '277'),
('616', '276', 'cust_branch', 'general', '278'),
('617', '276', 'customer', 'general', '278'),
('618', '277', 'cust_branch', 'general', '279'),
('619', '277', 'customer', 'general', '279'),
('620', '278', 'cust_branch', 'general', '280'),
('621', '278', 'customer', 'general', '280'),
('622', '279', 'cust_branch', 'general', '281'),
('623', '279', 'customer', 'general', '281'),
('624', '280', 'cust_branch', 'general', '282'),
('625', '280', 'customer', 'general', '282'),
('626', '281', 'cust_branch', 'general', '283'),
('627', '281', 'customer', 'general', '283'),
('628', '282', 'cust_branch', 'general', '284'),
('629', '282', 'customer', 'general', '284'),
('630', '283', 'cust_branch', 'general', '285'),
('631', '283', 'customer', 'general', '285'),
('632', '284', 'cust_branch', 'general', '286'),
('633', '284', 'customer', 'general', '286'),
('634', '285', 'cust_branch', 'general', '287'),
('635', '285', 'customer', 'general', '287'),
('636', '286', 'cust_branch', 'general', '288'),
('637', '286', 'customer', 'general', '288'),
('638', '287', 'cust_branch', 'general', '289'),
('639', '287', 'customer', 'general', '289'),
('640', '288', 'cust_branch', 'general', '290'),
('641', '288', 'customer', 'general', '290'),
('642', '289', 'cust_branch', 'general', '291'),
('643', '289', 'customer', 'general', '291'),
('644', '290', 'cust_branch', 'general', '292'),
('645', '290', 'customer', 'general', '292'),
('646', '291', 'cust_branch', 'general', '293'),
('647', '291', 'customer', 'general', '293'),
('648', '292', 'cust_branch', 'general', '294'),
('649', '292', 'customer', 'general', '294'),
('650', '293', 'cust_branch', 'general', '295'),
('651', '293', 'customer', 'general', '295'),
('652', '294', 'cust_branch', 'general', '296'),
('653', '294', 'customer', 'general', '296'),
('654', '295', 'cust_branch', 'general', '297'),
('655', '295', 'customer', 'general', '297'),
('656', '296', 'cust_branch', 'general', '298'),
('657', '296', 'customer', 'general', '298'),
('658', '297', 'cust_branch', 'general', '299'),
('659', '297', 'customer', 'general', '299'),
('660', '298', 'cust_branch', 'general', '300'),
('661', '298', 'customer', 'general', '300'),
('662', '299', 'cust_branch', 'general', '301'),
('663', '299', 'customer', 'general', '301'),
('664', '300', 'cust_branch', 'general', '302'),
('665', '300', 'customer', 'general', '302'),
('666', '301', 'cust_branch', 'general', '303'),
('667', '301', 'customer', 'general', '303'),
('668', '302', 'cust_branch', 'general', '304'),
('669', '302', 'customer', 'general', '304'),
('670', '303', 'cust_branch', 'general', '305'),
('671', '303', 'customer', 'general', '305'),
('672', '304', 'cust_branch', 'general', '306'),
('673', '304', 'customer', 'general', '306'),
('674', '305', 'cust_branch', 'general', '307'),
('675', '305', 'customer', 'general', '307'),
('676', '306', 'cust_branch', 'general', '308'),
('677', '306', 'customer', 'general', '308'),
('678', '307', 'cust_branch', 'general', '309'),
('679', '307', 'customer', 'general', '309'),
('680', '308', 'cust_branch', 'general', '310'),
('681', '308', 'customer', 'general', '310'),
('682', '309', 'cust_branch', 'general', '311'),
('683', '309', 'customer', 'general', '311'),
('684', '310', 'cust_branch', 'general', '312'),
('685', '310', 'customer', 'general', '312'),
('686', '311', 'cust_branch', 'general', '313'),
('687', '311', 'customer', 'general', '313'),
('688', '312', 'cust_branch', 'general', '314'),
('689', '312', 'customer', 'general', '314'),
('690', '313', 'cust_branch', 'general', '315'),
('691', '313', 'customer', 'general', '315'),
('692', '314', 'cust_branch', 'general', '316'),
('693', '314', 'customer', 'general', '316'),
('694', '315', 'cust_branch', 'general', '317'),
('695', '315', 'customer', 'general', '317'),
('696', '316', 'cust_branch', 'general', '318'),
('697', '316', 'customer', 'general', '318'),
('698', '317', 'cust_branch', 'general', '319'),
('699', '317', 'customer', 'general', '319'),
('700', '318', 'cust_branch', 'general', '320'),
('701', '318', 'customer', 'general', '320'),
('702', '319', 'cust_branch', 'general', '321'),
('703', '319', 'customer', 'general', '321'),
('704', '320', 'cust_branch', 'general', '322'),
('705', '320', 'customer', 'general', '322'),
('706', '321', 'cust_branch', 'general', '323'),
('707', '321', 'customer', 'general', '323'),
('708', '322', 'cust_branch', 'general', '324'),
('709', '322', 'customer', 'general', '324'),
('710', '323', 'cust_branch', 'general', '325'),
('711', '323', 'customer', 'general', '325'),
('712', '324', 'cust_branch', 'general', '326'),
('713', '324', 'customer', 'general', '326'),
('714', '325', 'cust_branch', 'general', '327'),
('715', '325', 'customer', 'general', '327'),
('716', '326', 'cust_branch', 'general', '328'),
('717', '326', 'customer', 'general', '328'),
('718', '327', 'cust_branch', 'general', '329'),
('719', '327', 'customer', 'general', '329'),
('720', '328', 'cust_branch', 'general', '330'),
('721', '328', 'customer', 'general', '330'),
('722', '329', 'cust_branch', 'general', '331'),
('723', '329', 'customer', 'general', '331'),
('724', '330', 'cust_branch', 'general', '332'),
('725', '330', 'customer', 'general', '332'),
('726', '331', 'cust_branch', 'general', '333'),
('727', '331', 'customer', 'general', '333'),
('728', '332', 'cust_branch', 'general', '334'),
('729', '332', 'customer', 'general', '334'),
('730', '333', 'cust_branch', 'general', '335'),
('731', '333', 'customer', 'general', '335'),
('732', '334', 'cust_branch', 'general', '336'),
('733', '334', 'customer', 'general', '336'),
('734', '335', 'cust_branch', 'general', '337'),
('735', '335', 'customer', 'general', '337'),
('736', '336', 'cust_branch', 'general', '338'),
('737', '336', 'customer', 'general', '338'),
('738', '337', 'cust_branch', 'general', '339'),
('739', '337', 'customer', 'general', '339'),
('740', '338', 'cust_branch', 'general', '340'),
('741', '338', 'customer', 'general', '340'),
('742', '339', 'cust_branch', 'general', '341'),
('743', '339', 'customer', 'general', '341'),
('744', '340', 'cust_branch', 'general', '342'),
('745', '340', 'customer', 'general', '342'),
('746', '341', 'cust_branch', 'general', '343'),
('747', '341', 'customer', 'general', '343'),
('748', '342', 'cust_branch', 'general', '344'),
('749', '342', 'customer', 'general', '344'),
('750', '343', 'cust_branch', 'general', '345'),
('751', '343', 'customer', 'general', '345'),
('752', '344', 'cust_branch', 'general', '346'),
('753', '344', 'customer', 'general', '346'),
('754', '345', 'cust_branch', 'general', '347'),
('755', '345', 'customer', 'general', '347'),
('756', '346', 'cust_branch', 'general', '348'),
('757', '346', 'customer', 'general', '348'),
('758', '347', 'cust_branch', 'general', '349'),
('759', '347', 'customer', 'general', '349'),
('760', '348', 'cust_branch', 'general', '350'),
('761', '348', 'customer', 'general', '350'),
('762', '349', 'cust_branch', 'general', '351'),
('763', '349', 'customer', 'general', '351'),
('764', '350', 'cust_branch', 'general', '352'),
('765', '350', 'customer', 'general', '352'),
('766', '351', 'cust_branch', 'general', '353'),
('767', '351', 'customer', 'general', '353'),
('768', '352', 'cust_branch', 'general', '354'),
('769', '352', 'customer', 'general', '354'),
('770', '353', 'cust_branch', 'general', '355'),
('771', '353', 'customer', 'general', '355'),
('772', '354', 'cust_branch', 'general', '356'),
('773', '354', 'customer', 'general', '356'),
('774', '355', 'cust_branch', 'general', '357'),
('775', '355', 'customer', 'general', '357'),
('776', '356', 'cust_branch', 'general', '358'),
('777', '356', 'customer', 'general', '358'),
('778', '357', 'cust_branch', 'general', '359'),
('779', '357', 'customer', 'general', '359'),
('780', '358', 'cust_branch', 'general', '360'),
('781', '358', 'customer', 'general', '360'),
('782', '359', 'cust_branch', 'general', '361'),
('783', '359', 'customer', 'general', '361'),
('784', '360', 'cust_branch', 'general', '362'),
('785', '360', 'customer', 'general', '362'),
('786', '361', 'cust_branch', 'general', '363'),
('787', '361', 'customer', 'general', '363'),
('788', '362', 'cust_branch', 'general', '364'),
('789', '362', 'customer', 'general', '364'),
('790', '363', 'cust_branch', 'general', '365'),
('791', '363', 'customer', 'general', '365'),
('792', '364', 'cust_branch', 'general', '366'),
('793', '364', 'customer', 'general', '366'),
('794', '365', 'cust_branch', 'general', '367'),
('795', '365', 'customer', 'general', '367'),
('796', '366', 'cust_branch', 'general', '368'),
('797', '366', 'customer', 'general', '368'),
('798', '367', 'cust_branch', 'general', '369'),
('799', '367', 'customer', 'general', '369'),
('800', '368', 'cust_branch', 'general', '370'),
('801', '368', 'customer', 'general', '370'),
('802', '369', 'cust_branch', 'general', '371'),
('803', '369', 'customer', 'general', '371'),
('804', '370', 'cust_branch', 'general', '372'),
('805', '370', 'customer', 'general', '372'),
('806', '371', 'cust_branch', 'general', '373'),
('807', '371', 'customer', 'general', '373'),
('808', '372', 'cust_branch', 'general', '374'),
('809', '372', 'customer', 'general', '374'),
('810', '373', 'cust_branch', 'general', '375'),
('811', '373', 'customer', 'general', '375'),
('812', '374', 'cust_branch', 'general', '376'),
('813', '374', 'customer', 'general', '376'),
('814', '375', 'cust_branch', 'general', '377'),
('815', '375', 'customer', 'general', '377'),
('816', '376', 'cust_branch', 'general', '378'),
('817', '376', 'customer', 'general', '378'),
('818', '377', 'cust_branch', 'general', '379'),
('819', '377', 'customer', 'general', '379'),
('820', '378', 'cust_branch', 'general', '380'),
('821', '378', 'customer', 'general', '380'),
('822', '379', 'cust_branch', 'general', '381'),
('823', '379', 'customer', 'general', '381'),
('824', '380', 'cust_branch', 'general', '382'),
('825', '380', 'customer', 'general', '382'),
('826', '381', 'cust_branch', 'general', '383'),
('827', '381', 'customer', 'general', '383'),
('828', '382', 'cust_branch', 'general', '384'),
('829', '382', 'customer', 'general', '384'),
('830', '383', 'cust_branch', 'general', '385'),
('831', '383', 'customer', 'general', '385'),
('832', '384', 'cust_branch', 'general', '386'),
('833', '384', 'customer', 'general', '386'),
('834', '385', 'cust_branch', 'general', '387'),
('835', '385', 'customer', 'general', '387'),
('836', '386', 'cust_branch', 'general', '388'),
('837', '386', 'customer', 'general', '388'),
('838', '387', 'cust_branch', 'general', '389'),
('839', '387', 'customer', 'general', '389'),
('840', '388', 'cust_branch', 'general', '390'),
('841', '388', 'customer', 'general', '390'),
('842', '389', 'cust_branch', 'general', '391'),
('843', '389', 'customer', 'general', '391'),
('844', '390', 'cust_branch', 'general', '392'),
('845', '390', 'customer', 'general', '392'),
('846', '391', 'cust_branch', 'general', '393'),
('847', '391', 'customer', 'general', '393'),
('848', '392', 'cust_branch', 'general', '394'),
('849', '392', 'customer', 'general', '394'),
('850', '393', 'cust_branch', 'general', '395'),
('851', '393', 'customer', 'general', '395'),
('852', '394', 'cust_branch', 'general', '396'),
('853', '394', 'customer', 'general', '396'),
('854', '395', 'cust_branch', 'general', '397'),
('855', '395', 'customer', 'general', '397'),
('856', '396', 'cust_branch', 'general', '398'),
('857', '396', 'customer', 'general', '398'),
('858', '397', 'cust_branch', 'general', '399'),
('859', '397', 'customer', 'general', '399'),
('860', '398', 'cust_branch', 'general', '400'),
('861', '398', 'customer', 'general', '400'),
('862', '399', 'cust_branch', 'general', '401'),
('863', '399', 'customer', 'general', '401'),
('864', '400', 'cust_branch', 'general', '402'),
('865', '400', 'customer', 'general', '402'),
('866', '401', 'cust_branch', 'general', '403'),
('867', '401', 'customer', 'general', '403'),
('868', '402', 'cust_branch', 'general', '404'),
('869', '402', 'customer', 'general', '404'),
('870', '403', 'cust_branch', 'general', '405'),
('871', '403', 'customer', 'general', '405'),
('872', '404', 'cust_branch', 'general', '406'),
('873', '404', 'customer', 'general', '406'),
('874', '405', 'cust_branch', 'general', '407'),
('875', '405', 'customer', 'general', '407'),
('876', '406', 'cust_branch', 'general', '408'),
('877', '406', 'customer', 'general', '408'),
('878', '407', 'cust_branch', 'general', '409'),
('879', '407', 'customer', 'general', '409'),
('880', '408', 'cust_branch', 'general', '410'),
('881', '408', 'customer', 'general', '410'),
('882', '409', 'cust_branch', 'general', '411'),
('883', '409', 'customer', 'general', '411'),
('884', '410', 'cust_branch', 'general', '412'),
('885', '410', 'customer', 'general', '412'),
('886', '411', 'cust_branch', 'general', '413'),
('887', '411', 'customer', 'general', '413'),
('888', '412', 'cust_branch', 'general', '414'),
('889', '412', 'customer', 'general', '414'),
('890', '413', 'cust_branch', 'general', '415'),
('891', '413', 'customer', 'general', '415'),
('892', '414', 'cust_branch', 'general', '416'),
('893', '414', 'customer', 'general', '416'),
('894', '415', 'cust_branch', 'general', '417'),
('895', '415', 'customer', 'general', '417'),
('896', '416', 'cust_branch', 'general', '418'),
('897', '416', 'customer', 'general', '418'),
('898', '417', 'cust_branch', 'general', '419'),
('899', '417', 'customer', 'general', '419'),
('900', '418', 'cust_branch', 'general', '420'),
('901', '418', 'customer', 'general', '420'),
('902', '419', 'cust_branch', 'general', '421'),
('903', '419', 'customer', 'general', '421'),
('904', '420', 'cust_branch', 'general', '422'),
('905', '420', 'customer', 'general', '422'),
('906', '421', 'cust_branch', 'general', '423'),
('907', '421', 'customer', 'general', '423'),
('908', '422', 'cust_branch', 'general', '424'),
('909', '422', 'customer', 'general', '424'),
('910', '423', 'cust_branch', 'general', '425'),
('911', '423', 'customer', 'general', '425'),
('912', '424', 'cust_branch', 'general', '426'),
('913', '424', 'customer', 'general', '426'),
('914', '425', 'cust_branch', 'general', '427'),
('915', '425', 'customer', 'general', '427'),
('916', '426', 'cust_branch', 'general', '428'),
('917', '426', 'customer', 'general', '428'),
('918', '427', 'cust_branch', 'general', '429'),
('919', '427', 'customer', 'general', '429'),
('920', '428', 'cust_branch', 'general', '430'),
('921', '428', 'customer', 'general', '430'),
('922', '429', 'cust_branch', 'general', '431'),
('923', '429', 'customer', 'general', '431'),
('924', '430', 'cust_branch', 'general', '432'),
('925', '430', 'customer', 'general', '432'),
('926', '431', 'cust_branch', 'general', '433'),
('927', '431', 'customer', 'general', '433'),
('928', '432', 'cust_branch', 'general', '434'),
('929', '432', 'customer', 'general', '434'),
('930', '433', 'cust_branch', 'general', '435'),
('931', '433', 'customer', 'general', '435'),
('932', '434', 'cust_branch', 'general', '436'),
('933', '434', 'customer', 'general', '436'),
('934', '435', 'cust_branch', 'general', '437'),
('935', '435', 'customer', 'general', '437'),
('936', '436', 'cust_branch', 'general', '438'),
('937', '436', 'customer', 'general', '438'),
('938', '437', 'cust_branch', 'general', '439'),
('939', '437', 'customer', 'general', '439'),
('940', '438', 'cust_branch', 'general', '440'),
('941', '438', 'customer', 'general', '440'),
('942', '439', 'cust_branch', 'general', '441'),
('943', '439', 'customer', 'general', '441'),
('944', '440', 'cust_branch', 'general', '442'),
('945', '440', 'customer', 'general', '442'),
('946', '441', 'cust_branch', 'general', '443'),
('947', '441', 'customer', 'general', '443'),
('948', '442', 'cust_branch', 'general', '444'),
('949', '442', 'customer', 'general', '444'),
('950', '443', 'cust_branch', 'general', '445'),
('951', '443', 'customer', 'general', '445'),
('952', '444', 'cust_branch', 'general', '446'),
('953', '444', 'customer', 'general', '446'),
('954', '445', 'cust_branch', 'general', '447'),
('955', '445', 'customer', 'general', '447'),
('956', '446', 'cust_branch', 'general', '448'),
('957', '446', 'customer', 'general', '448'),
('958', '447', 'cust_branch', 'general', '449'),
('959', '447', 'customer', 'general', '449'),
('960', '448', 'cust_branch', 'general', '450'),
('961', '448', 'customer', 'general', '450'),
('962', '449', 'cust_branch', 'general', '451'),
('963', '449', 'customer', 'general', '451'),
('964', '450', 'cust_branch', 'general', '452'),
('965', '450', 'customer', 'general', '452'),
('966', '451', 'cust_branch', 'general', '453'),
('967', '451', 'customer', 'general', '453'),
('968', '452', 'cust_branch', 'general', '454'),
('969', '452', 'customer', 'general', '454'),
('970', '453', 'cust_branch', 'general', '455'),
('971', '453', 'customer', 'general', '455'),
('972', '454', 'cust_branch', 'general', '456'),
('973', '454', 'customer', 'general', '456'),
('974', '455', 'cust_branch', 'general', '457'),
('975', '455', 'customer', 'general', '457'),
('976', '456', 'cust_branch', 'general', '458'),
('977', '456', 'customer', 'general', '458'),
('978', '457', 'cust_branch', 'general', '459'),
('979', '457', 'customer', 'general', '459'),
('980', '458', 'cust_branch', 'general', '460'),
('981', '458', 'customer', 'general', '460'),
('982', '459', 'cust_branch', 'general', '461'),
('983', '459', 'customer', 'general', '461'),
('984', '460', 'cust_branch', 'general', '462'),
('985', '460', 'customer', 'general', '462'),
('986', '461', 'cust_branch', 'general', '463'),
('987', '461', 'customer', 'general', '463'),
('988', '462', 'cust_branch', 'general', '464'),
('989', '462', 'customer', 'general', '464'),
('990', '463', 'cust_branch', 'general', '465'),
('991', '463', 'customer', 'general', '465'),
('992', '464', 'cust_branch', 'general', '466'),
('993', '464', 'customer', 'general', '466'),
('994', '465', 'cust_branch', 'general', '467'),
('995', '465', 'customer', 'general', '467'),
('996', '466', 'cust_branch', 'general', '468'),
('997', '466', 'customer', 'general', '468'),
('998', '467', 'cust_branch', 'general', '469'),
('999', '467', 'customer', 'general', '469'),
('1000', '468', 'cust_branch', 'general', '470'),
('1001', '468', 'customer', 'general', '470'),
('1002', '469', 'cust_branch', 'general', '471'),
('1003', '469', 'customer', 'general', '471'),
('1004', '470', 'cust_branch', 'general', '472'),
('1005', '470', 'customer', 'general', '472'),
('1006', '471', 'cust_branch', 'general', '473'),
('1007', '471', 'customer', 'general', '473'),
('1008', '472', 'cust_branch', 'general', '474'),
('1009', '472', 'customer', 'general', '474'),
('1010', '473', 'cust_branch', 'general', '475'),
('1011', '473', 'customer', 'general', '475'),
('1012', '474', 'cust_branch', 'general', '476'),
('1013', '474', 'customer', 'general', '476'),
('1014', '475', 'cust_branch', 'general', '477'),
('1015', '475', 'customer', 'general', '477'),
('1016', '476', 'cust_branch', 'general', '478'),
('1017', '476', 'customer', 'general', '478'),
('1018', '477', 'cust_branch', 'general', '479'),
('1019', '477', 'customer', 'general', '479'),
('1020', '478', 'cust_branch', 'general', '480'),
('1021', '478', 'customer', 'general', '480'),
('1022', '479', 'cust_branch', 'general', '481'),
('1023', '479', 'customer', 'general', '481'),
('1024', '480', 'cust_branch', 'general', '482'),
('1025', '480', 'customer', 'general', '482'),
('1026', '481', 'cust_branch', 'general', '483'),
('1027', '481', 'customer', 'general', '483'),
('1028', '482', 'cust_branch', 'general', '484'),
('1029', '482', 'customer', 'general', '484'),
('1030', '483', 'cust_branch', 'general', '485'),
('1031', '483', 'customer', 'general', '485'),
('1032', '484', 'cust_branch', 'general', '486'),
('1033', '484', 'customer', 'general', '486'),
('1034', '485', 'cust_branch', 'general', '487'),
('1035', '485', 'customer', 'general', '487'),
('1036', '486', 'cust_branch', 'general', '488'),
('1037', '486', 'customer', 'general', '488'),
('1038', '487', 'cust_branch', 'general', '489'),
('1039', '487', 'customer', 'general', '489'),
('1040', '488', 'cust_branch', 'general', '490'),
('1041', '488', 'customer', 'general', '490'),
('1042', '489', 'cust_branch', 'general', '491'),
('1043', '489', 'customer', 'general', '491'),
('1044', '490', 'cust_branch', 'general', '492'),
('1045', '490', 'customer', 'general', '492'),
('1046', '491', 'cust_branch', 'general', '493'),
('1047', '491', 'customer', 'general', '493'),
('1048', '492', 'cust_branch', 'general', '494'),
('1049', '492', 'customer', 'general', '494'),
('1050', '493', 'cust_branch', 'general', '495'),
('1051', '493', 'customer', 'general', '495'),
('1052', '494', 'cust_branch', 'general', '496'),
('1053', '494', 'customer', 'general', '496'),
('1054', '495', 'cust_branch', 'general', '497'),
('1055', '495', 'customer', 'general', '497'),
('1056', '496', 'cust_branch', 'general', '498'),
('1057', '496', 'customer', 'general', '498'),
('1058', '497', 'cust_branch', 'general', '499'),
('1059', '497', 'customer', 'general', '499'),
('1060', '498', 'cust_branch', 'general', '500'),
('1061', '498', 'customer', 'general', '500'),
('1062', '499', 'cust_branch', 'general', '501'),
('1063', '499', 'customer', 'general', '501'),
('1064', '500', 'cust_branch', 'general', '502'),
('1065', '500', 'customer', 'general', '502'),
('1066', '501', 'cust_branch', 'general', '503'),
('1067', '501', 'customer', 'general', '503'),
('1068', '502', 'cust_branch', 'general', '504'),
('1069', '502', 'customer', 'general', '504'),
('1070', '503', 'cust_branch', 'general', '505'),
('1071', '503', 'customer', 'general', '505'),
('1072', '504', 'cust_branch', 'general', '506'),
('1073', '504', 'customer', 'general', '506'),
('1074', '505', 'cust_branch', 'general', '507'),
('1075', '505', 'customer', 'general', '507'),
('1076', '506', 'cust_branch', 'general', '508'),
('1077', '506', 'customer', 'general', '508'),
('1078', '507', 'cust_branch', 'general', '509'),
('1079', '507', 'customer', 'general', '509'),
('1080', '508', 'cust_branch', 'general', '510'),
('1081', '508', 'customer', 'general', '510'),
('1082', '509', 'cust_branch', 'general', '511'),
('1083', '509', 'customer', 'general', '511'),
('1084', '510', 'cust_branch', 'general', '512'),
('1085', '510', 'customer', 'general', '512'),
('1086', '511', 'cust_branch', 'general', '513'),
('1087', '511', 'customer', 'general', '513'),
('1088', '512', 'cust_branch', 'general', '514'),
('1089', '512', 'customer', 'general', '514'),
('1090', '513', 'cust_branch', 'general', '515'),
('1091', '513', 'customer', 'general', '515'),
('1092', '514', 'cust_branch', 'general', '516'),
('1093', '514', 'customer', 'general', '516'),
('1094', '515', 'cust_branch', 'general', '517'),
('1095', '515', 'customer', 'general', '517'),
('1096', '516', 'cust_branch', 'general', '518'),
('1097', '516', 'customer', 'general', '518'),
('1098', '517', 'cust_branch', 'general', '519'),
('1099', '517', 'customer', 'general', '519'),
('1100', '518', 'cust_branch', 'general', '520'),
('1101', '518', 'customer', 'general', '520'),
('1102', '519', 'cust_branch', 'general', '521'),
('1103', '519', 'customer', 'general', '521'),
('1104', '520', 'cust_branch', 'general', '522'),
('1105', '520', 'customer', 'general', '522'),
('1106', '521', 'cust_branch', 'general', '523'),
('1107', '521', 'customer', 'general', '523'),
('1108', '522', 'cust_branch', 'general', '524'),
('1109', '522', 'customer', 'general', '524'),
('1110', '523', 'cust_branch', 'general', '525'),
('1111', '523', 'customer', 'general', '525'),
('1112', '524', 'cust_branch', 'general', '526'),
('1113', '524', 'customer', 'general', '526'),
('1114', '525', 'cust_branch', 'general', '527'),
('1115', '525', 'customer', 'general', '527'),
('1116', '526', 'cust_branch', 'general', '528');
INSERT INTO `0_crm_contacts` VALUES
('1117', '526', 'customer', 'general', '528'),
('1118', '527', 'cust_branch', 'general', '529'),
('1119', '527', 'customer', 'general', '529'),
('1120', '528', 'cust_branch', 'general', '530'),
('1121', '528', 'customer', 'general', '530'),
('1122', '529', 'cust_branch', 'general', '531'),
('1123', '529', 'customer', 'general', '531'),
('1124', '530', 'cust_branch', 'general', '532'),
('1125', '530', 'customer', 'general', '532'),
('1126', '531', 'cust_branch', 'general', '533'),
('1127', '531', 'customer', 'general', '533'),
('1128', '532', 'cust_branch', 'general', '534'),
('1129', '532', 'customer', 'general', '534'),
('1130', '533', 'cust_branch', 'general', '535'),
('1131', '533', 'customer', 'general', '535'),
('1132', '534', 'cust_branch', 'general', '536'),
('1133', '534', 'customer', 'general', '536'),
('1134', '535', 'cust_branch', 'general', '537'),
('1135', '535', 'customer', 'general', '537'),
('1136', '536', 'cust_branch', 'general', '538'),
('1137', '536', 'customer', 'general', '538'),
('1138', '537', 'cust_branch', 'general', '539'),
('1139', '537', 'customer', 'general', '539'),
('1140', '538', 'cust_branch', 'general', '540'),
('1141', '538', 'customer', 'general', '540'),
('1142', '539', 'cust_branch', 'general', '541'),
('1143', '539', 'customer', 'general', '541'),
('1144', '540', 'cust_branch', 'general', '542'),
('1145', '540', 'customer', 'general', '542'),
('1146', '541', 'cust_branch', 'general', '543'),
('1147', '541', 'customer', 'general', '543'),
('1148', '542', 'cust_branch', 'general', '544'),
('1149', '542', 'customer', 'general', '544'),
('1150', '543', 'cust_branch', 'general', '545'),
('1151', '543', 'customer', 'general', '545'),
('1152', '544', 'cust_branch', 'general', '546'),
('1153', '544', 'customer', 'general', '546'),
('1154', '545', 'cust_branch', 'general', '547'),
('1155', '545', 'customer', 'general', '547'),
('1156', '546', 'cust_branch', 'general', '548'),
('1157', '546', 'customer', 'general', '548'),
('1158', '547', 'cust_branch', 'general', '549'),
('1159', '547', 'customer', 'general', '549'),
('1160', '548', 'cust_branch', 'general', '550'),
('1161', '548', 'customer', 'general', '550'),
('1162', '549', 'cust_branch', 'general', '551'),
('1163', '549', 'customer', 'general', '551'),
('1164', '550', 'cust_branch', 'general', '552'),
('1165', '550', 'customer', 'general', '552'),
('1166', '551', 'cust_branch', 'general', '553'),
('1167', '551', 'customer', 'general', '553'),
('1168', '552', 'cust_branch', 'general', '554'),
('1169', '552', 'customer', 'general', '554'),
('1170', '553', 'cust_branch', 'general', '555'),
('1171', '553', 'customer', 'general', '555'),
('1172', '554', 'cust_branch', 'general', '556'),
('1173', '554', 'customer', 'general', '556'),
('1174', '555', 'cust_branch', 'general', '557'),
('1175', '555', 'customer', 'general', '557'),
('1176', '556', 'cust_branch', 'general', '558'),
('1177', '556', 'customer', 'general', '558'),
('1178', '557', 'cust_branch', 'general', '559'),
('1179', '557', 'customer', 'general', '559'),
('1180', '558', 'cust_branch', 'general', '560'),
('1181', '558', 'customer', 'general', '560'),
('1182', '559', 'cust_branch', 'general', '561'),
('1183', '559', 'customer', 'general', '561'),
('1184', '560', 'cust_branch', 'general', '562'),
('1185', '560', 'customer', 'general', '562'),
('1186', '561', 'cust_branch', 'general', '563'),
('1187', '561', 'customer', 'general', '563'),
('1188', '562', 'cust_branch', 'general', '564'),
('1189', '562', 'customer', 'general', '564'),
('1190', '563', 'cust_branch', 'general', '565'),
('1191', '563', 'customer', 'general', '565'),
('1192', '564', 'cust_branch', 'general', '566'),
('1193', '564', 'customer', 'general', '566'),
('1194', '565', 'cust_branch', 'general', '567'),
('1195', '565', 'customer', 'general', '567'),
('1196', '566', 'cust_branch', 'general', '568'),
('1197', '566', 'customer', 'general', '568'),
('1198', '567', 'cust_branch', 'general', '569'),
('1199', '567', 'customer', 'general', '569'),
('1200', '568', 'cust_branch', 'general', '570'),
('1201', '568', 'customer', 'general', '570'),
('1202', '569', 'cust_branch', 'general', '571'),
('1203', '569', 'customer', 'general', '571'),
('1204', '570', 'cust_branch', 'general', '572'),
('1205', '570', 'customer', 'general', '572'),
('1206', '571', 'cust_branch', 'general', '573'),
('1207', '571', 'customer', 'general', '573'),
('1208', '572', 'cust_branch', 'general', '574'),
('1209', '572', 'customer', 'general', '574'),
('1210', '573', 'cust_branch', 'general', '575'),
('1211', '573', 'customer', 'general', '575'),
('1212', '574', 'cust_branch', 'general', '576'),
('1213', '574', 'customer', 'general', '576'),
('1214', '575', 'cust_branch', 'general', '577'),
('1215', '575', 'customer', 'general', '577'),
('1216', '576', 'cust_branch', 'general', '578'),
('1217', '576', 'customer', 'general', '578'),
('1218', '577', 'cust_branch', 'general', '579'),
('1219', '577', 'customer', 'general', '579'),
('1220', '578', 'cust_branch', 'general', '580'),
('1221', '578', 'customer', 'general', '580'),
('1222', '579', 'cust_branch', 'general', '581'),
('1223', '579', 'customer', 'general', '581'),
('1224', '580', 'cust_branch', 'general', '582'),
('1225', '580', 'customer', 'general', '582'),
('1226', '581', 'cust_branch', 'general', '583'),
('1227', '581', 'customer', 'general', '583'),
('1228', '582', 'cust_branch', 'general', '584'),
('1229', '582', 'customer', 'general', '584'),
('1230', '583', 'cust_branch', 'general', '585'),
('1231', '583', 'customer', 'general', '585'),
('1232', '584', 'cust_branch', 'general', '586'),
('1233', '584', 'customer', 'general', '586'),
('1234', '585', 'cust_branch', 'general', '587'),
('1235', '585', 'customer', 'general', '587'),
('1236', '586', 'cust_branch', 'general', '588'),
('1237', '586', 'customer', 'general', '588'),
('1238', '587', 'cust_branch', 'general', '589'),
('1239', '587', 'customer', 'general', '589'),
('1240', '588', 'cust_branch', 'general', '590'),
('1241', '588', 'customer', 'general', '590'),
('1242', '589', 'cust_branch', 'general', '591'),
('1243', '589', 'customer', 'general', '591'),
('1244', '590', 'cust_branch', 'general', '592'),
('1245', '590', 'customer', 'general', '592'),
('1246', '591', 'cust_branch', 'general', '593'),
('1247', '591', 'customer', 'general', '593'),
('1248', '592', 'cust_branch', 'general', '594'),
('1249', '592', 'customer', 'general', '594'),
('1250', '593', 'cust_branch', 'general', '595'),
('1251', '593', 'customer', 'general', '595'),
('1252', '594', 'cust_branch', 'general', '596'),
('1253', '594', 'customer', 'general', '596'),
('1254', '595', 'cust_branch', 'general', '597'),
('1255', '595', 'customer', 'general', '597'),
('1256', '596', 'cust_branch', 'general', '598'),
('1257', '596', 'customer', 'general', '598'),
('1258', '597', 'cust_branch', 'general', '599'),
('1259', '597', 'customer', 'general', '599'),
('1260', '598', 'cust_branch', 'general', '600'),
('1261', '598', 'customer', 'general', '600'),
('1262', '599', 'cust_branch', 'general', '601'),
('1263', '599', 'customer', 'general', '601'),
('1264', '600', 'cust_branch', 'general', '602'),
('1265', '600', 'customer', 'general', '602'),
('1266', '601', 'cust_branch', 'general', '603'),
('1267', '601', 'customer', 'general', '603'),
('1268', '602', 'cust_branch', 'general', '604'),
('1269', '602', 'customer', 'general', '604'),
('1270', '603', 'cust_branch', 'general', '605'),
('1271', '603', 'customer', 'general', '605'),
('1272', '604', 'cust_branch', 'general', '606'),
('1273', '604', 'customer', 'general', '606'),
('1274', '605', 'cust_branch', 'general', '607'),
('1275', '605', 'customer', 'general', '607'),
('1276', '606', 'cust_branch', 'general', '608'),
('1277', '606', 'customer', 'general', '608'),
('1278', '607', 'cust_branch', 'general', '609'),
('1279', '607', 'customer', 'general', '609'),
('1280', '608', 'cust_branch', 'general', '610'),
('1281', '608', 'customer', 'general', '610'),
('1282', '609', 'cust_branch', 'general', '611'),
('1283', '609', 'customer', 'general', '611'),
('1284', '610', 'cust_branch', 'general', '612'),
('1285', '610', 'customer', 'general', '612'),
('1286', '611', 'cust_branch', 'general', '613'),
('1287', '611', 'customer', 'general', '613'),
('1288', '612', 'cust_branch', 'general', '614'),
('1289', '612', 'customer', 'general', '614'),
('1290', '613', 'cust_branch', 'general', '615'),
('1291', '613', 'customer', 'general', '615'),
('1292', '614', 'cust_branch', 'general', '616'),
('1293', '614', 'customer', 'general', '616'),
('1294', '615', 'cust_branch', 'general', '617'),
('1295', '615', 'customer', 'general', '617'),
('1296', '616', 'cust_branch', 'general', '618'),
('1297', '616', 'customer', 'general', '618'),
('1298', '617', 'cust_branch', 'general', '619'),
('1299', '617', 'customer', 'general', '619'),
('1300', '618', 'cust_branch', 'general', '620'),
('1301', '618', 'customer', 'general', '620'),
('1302', '619', 'cust_branch', 'general', '621'),
('1303', '619', 'customer', 'general', '621'),
('1304', '620', 'cust_branch', 'general', '622'),
('1305', '620', 'customer', 'general', '622'),
('1306', '621', 'cust_branch', 'general', '623'),
('1307', '621', 'customer', 'general', '623'),
('1308', '622', 'cust_branch', 'general', '624'),
('1309', '622', 'customer', 'general', '624'),
('1310', '623', 'cust_branch', 'general', '625'),
('1311', '623', 'customer', 'general', '625'),
('1312', '624', 'cust_branch', 'general', '626'),
('1313', '624', 'customer', 'general', '626'),
('1314', '625', 'cust_branch', 'general', '627'),
('1315', '625', 'customer', 'general', '627'),
('1316', '626', 'cust_branch', 'general', '628'),
('1317', '626', 'customer', 'general', '628'),
('1318', '627', 'cust_branch', 'general', '629'),
('1319', '627', 'customer', 'general', '629'),
('1320', '628', 'cust_branch', 'general', '630'),
('1321', '628', 'customer', 'general', '630'),
('1322', '629', 'cust_branch', 'general', '631'),
('1323', '629', 'customer', 'general', '631'),
('1324', '630', 'cust_branch', 'general', '632'),
('1325', '630', 'customer', 'general', '632'),
('1326', '631', 'cust_branch', 'general', '633'),
('1327', '631', 'customer', 'general', '633'),
('1328', '632', 'cust_branch', 'general', '634'),
('1329', '632', 'customer', 'general', '634'),
('1330', '633', 'cust_branch', 'general', '635'),
('1331', '633', 'customer', 'general', '635'),
('1332', '634', 'cust_branch', 'general', '636'),
('1333', '634', 'customer', 'general', '636'),
('1334', '635', 'cust_branch', 'general', '637'),
('1335', '635', 'customer', 'general', '637'),
('1336', '636', 'cust_branch', 'general', '638'),
('1337', '636', 'customer', 'general', '638'),
('1338', '637', 'cust_branch', 'general', '639'),
('1339', '637', 'customer', 'general', '639'),
('1340', '638', 'cust_branch', 'general', '640'),
('1341', '638', 'customer', 'general', '640'),
('1342', '639', 'cust_branch', 'general', '641'),
('1343', '639', 'customer', 'general', '641'),
('1344', '640', 'cust_branch', 'general', '642'),
('1345', '640', 'customer', 'general', '642'),
('1346', '641', 'cust_branch', 'general', '643'),
('1347', '641', 'customer', 'general', '643'),
('1348', '642', 'cust_branch', 'general', '644'),
('1349', '642', 'customer', 'general', '644'),
('1350', '643', 'cust_branch', 'general', '645'),
('1351', '643', 'customer', 'general', '645'),
('1352', '644', 'cust_branch', 'general', '646'),
('1353', '644', 'customer', 'general', '646'),
('1354', '645', 'cust_branch', 'general', '647'),
('1355', '645', 'customer', 'general', '647'),
('1356', '646', 'cust_branch', 'general', '648'),
('1357', '646', 'customer', 'general', '648'),
('1358', '647', 'cust_branch', 'general', '649'),
('1359', '647', 'customer', 'general', '649'),
('1360', '648', 'cust_branch', 'general', '650'),
('1361', '648', 'customer', 'general', '650'),
('1362', '649', 'cust_branch', 'general', '651'),
('1363', '649', 'customer', 'general', '651'),
('1364', '650', 'cust_branch', 'general', '652'),
('1365', '650', 'customer', 'general', '652'),
('1366', '651', 'cust_branch', 'general', '653'),
('1367', '651', 'customer', 'general', '653'),
('1368', '652', 'cust_branch', 'general', '654'),
('1369', '652', 'customer', 'general', '654'),
('1370', '653', 'cust_branch', 'general', '655'),
('1371', '653', 'customer', 'general', '655'),
('1372', '654', 'cust_branch', 'general', '656'),
('1373', '654', 'customer', 'general', '656'),
('1374', '655', 'cust_branch', 'general', '657'),
('1375', '655', 'customer', 'general', '657'),
('1376', '656', 'cust_branch', 'general', '658'),
('1377', '656', 'customer', 'general', '658'),
('1378', '657', 'cust_branch', 'general', '659'),
('1379', '657', 'customer', 'general', '659'),
('1380', '658', 'cust_branch', 'general', '660'),
('1381', '658', 'customer', 'general', '660'),
('1382', '659', 'cust_branch', 'general', '661'),
('1383', '659', 'customer', 'general', '661'),
('1384', '660', 'cust_branch', 'general', '662'),
('1385', '660', 'customer', 'general', '662'),
('1386', '661', 'cust_branch', 'general', '663'),
('1387', '661', 'customer', 'general', '663'),
('1388', '662', 'cust_branch', 'general', '664'),
('1389', '662', 'customer', 'general', '664'),
('1390', '663', 'cust_branch', 'general', '665'),
('1391', '663', 'customer', 'general', '665'),
('1392', '664', 'cust_branch', 'general', '666'),
('1393', '664', 'customer', 'general', '666'),
('1394', '665', 'cust_branch', 'general', '667'),
('1395', '665', 'customer', 'general', '667'),
('1396', '666', 'cust_branch', 'general', '668'),
('1397', '666', 'customer', 'general', '668'),
('1398', '667', 'cust_branch', 'general', '669'),
('1399', '667', 'customer', 'general', '669'),
('1400', '668', 'cust_branch', 'general', '670'),
('1401', '668', 'customer', 'general', '670'),
('1402', '669', 'cust_branch', 'general', '671'),
('1403', '669', 'customer', 'general', '671'),
('1404', '670', 'cust_branch', 'general', '672'),
('1405', '670', 'customer', 'general', '672'),
('1406', '671', 'cust_branch', 'general', '673'),
('1407', '671', 'customer', 'general', '673'),
('1408', '672', 'cust_branch', 'general', '674'),
('1409', '672', 'customer', 'general', '674'),
('1410', '673', 'cust_branch', 'general', '675'),
('1411', '673', 'customer', 'general', '675'),
('1412', '674', 'cust_branch', 'general', '676'),
('1413', '674', 'customer', 'general', '676'),
('1414', '675', 'cust_branch', 'general', '677'),
('1415', '675', 'customer', 'general', '677'),
('1416', '676', 'cust_branch', 'general', '678'),
('1417', '676', 'customer', 'general', '678'),
('1418', '677', 'cust_branch', 'general', '679'),
('1419', '677', 'customer', 'general', '679'),
('1420', '678', 'cust_branch', 'general', '680'),
('1421', '678', 'customer', 'general', '680'),
('1422', '679', 'cust_branch', 'general', '681'),
('1423', '679', 'customer', 'general', '681'),
('1424', '680', 'cust_branch', 'general', '682'),
('1425', '680', 'customer', 'general', '682'),
('1426', '681', 'cust_branch', 'general', '683'),
('1427', '681', 'customer', 'general', '683'),
('1428', '682', 'cust_branch', 'general', '684'),
('1429', '682', 'customer', 'general', '684'),
('1430', '683', 'cust_branch', 'general', '685'),
('1431', '683', 'customer', 'general', '685'),
('1432', '684', 'cust_branch', 'general', '686'),
('1433', '684', 'customer', 'general', '686'),
('1434', '685', 'cust_branch', 'general', '687'),
('1435', '685', 'customer', 'general', '687'),
('1436', '686', 'cust_branch', 'general', '688'),
('1437', '686', 'customer', 'general', '688'),
('1438', '687', 'cust_branch', 'general', '689'),
('1439', '687', 'customer', 'general', '689'),
('1440', '688', 'cust_branch', 'general', '690'),
('1441', '688', 'customer', 'general', '690'),
('1442', '689', 'cust_branch', 'general', '691'),
('1443', '689', 'customer', 'general', '691'),
('1444', '690', 'cust_branch', 'general', '692'),
('1445', '690', 'customer', 'general', '692'),
('1446', '691', 'cust_branch', 'general', '693'),
('1447', '691', 'customer', 'general', '693'),
('1448', '692', 'cust_branch', 'general', '694'),
('1449', '692', 'customer', 'general', '694'),
('1450', '693', 'cust_branch', 'general', '695'),
('1451', '693', 'customer', 'general', '695'),
('1452', '694', 'cust_branch', 'general', '696'),
('1453', '694', 'customer', 'general', '696'),
('1454', '695', 'cust_branch', 'general', '697'),
('1455', '695', 'customer', 'general', '697'),
('1456', '696', 'cust_branch', 'general', '698'),
('1457', '696', 'customer', 'general', '698'),
('1458', '697', 'cust_branch', 'general', '699'),
('1459', '697', 'customer', 'general', '699'),
('1460', '698', 'cust_branch', 'general', '700'),
('1461', '698', 'customer', 'general', '700'),
('1462', '699', 'cust_branch', 'general', '701'),
('1463', '699', 'customer', 'general', '701'),
('1464', '700', 'cust_branch', 'general', '702'),
('1465', '700', 'customer', 'general', '702'),
('1466', '701', 'cust_branch', 'general', '703'),
('1467', '701', 'customer', 'general', '703'),
('1468', '702', 'cust_branch', 'general', '704'),
('1469', '702', 'customer', 'general', '704'),
('1470', '703', 'cust_branch', 'general', '705'),
('1471', '703', 'customer', 'general', '705'),
('1472', '704', 'cust_branch', 'general', '706'),
('1473', '704', 'customer', 'general', '706'),
('1474', '705', 'cust_branch', 'general', '707'),
('1475', '705', 'customer', 'general', '707'),
('1476', '706', 'cust_branch', 'general', '708'),
('1477', '706', 'customer', 'general', '708'),
('1478', '707', 'cust_branch', 'general', '709'),
('1479', '707', 'customer', 'general', '709'),
('1480', '708', 'cust_branch', 'general', '710'),
('1481', '708', 'customer', 'general', '710'),
('1482', '709', 'cust_branch', 'general', '711'),
('1483', '709', 'customer', 'general', '711'),
('1484', '710', 'cust_branch', 'general', '712'),
('1485', '710', 'customer', 'general', '712'),
('1486', '711', 'cust_branch', 'general', '713'),
('1487', '711', 'customer', 'general', '713'),
('1488', '712', 'cust_branch', 'general', '714'),
('1489', '712', 'customer', 'general', '714'),
('1490', '713', 'cust_branch', 'general', '715'),
('1491', '713', 'customer', 'general', '715'),
('1492', '714', 'cust_branch', 'general', '716'),
('1493', '714', 'customer', 'general', '716'),
('1494', '715', 'cust_branch', 'general', '717'),
('1495', '715', 'customer', 'general', '717'),
('1496', '716', 'cust_branch', 'general', '718'),
('1497', '716', 'customer', 'general', '718'),
('1498', '717', 'cust_branch', 'general', '719'),
('1499', '717', 'customer', 'general', '719'),
('1500', '718', 'cust_branch', 'general', '720'),
('1501', '718', 'customer', 'general', '720'),
('1502', '719', 'cust_branch', 'general', '721'),
('1503', '719', 'customer', 'general', '721'),
('1504', '720', 'cust_branch', 'general', '722'),
('1505', '720', 'customer', 'general', '722'),
('1506', '721', 'cust_branch', 'general', '723'),
('1507', '721', 'customer', 'general', '723'),
('1508', '722', 'cust_branch', 'general', '724'),
('1509', '722', 'customer', 'general', '724'),
('1510', '723', 'cust_branch', 'general', '725'),
('1511', '723', 'customer', 'general', '725'),
('1512', '724', 'cust_branch', 'general', '726'),
('1513', '724', 'customer', 'general', '726'),
('1514', '725', 'cust_branch', 'general', '727'),
('1515', '725', 'customer', 'general', '727'),
('1516', '726', 'cust_branch', 'general', '728'),
('1517', '726', 'customer', 'general', '728'),
('1518', '727', 'cust_branch', 'general', '729'),
('1519', '727', 'customer', 'general', '729'),
('1520', '728', 'cust_branch', 'general', '730'),
('1521', '728', 'customer', 'general', '730'),
('1522', '729', 'cust_branch', 'general', '731'),
('1523', '729', 'customer', 'general', '731'),
('1524', '730', 'cust_branch', 'general', '732'),
('1525', '730', 'customer', 'general', '732'),
('1526', '731', 'cust_branch', 'general', '733'),
('1527', '731', 'customer', 'general', '733'),
('1528', '732', 'cust_branch', 'general', '734'),
('1529', '732', 'customer', 'general', '734'),
('1530', '733', 'cust_branch', 'general', '735'),
('1531', '733', 'customer', 'general', '735'),
('1532', '734', 'cust_branch', 'general', '736'),
('1533', '734', 'customer', 'general', '736'),
('1534', '735', 'cust_branch', 'general', '737'),
('1535', '735', 'customer', 'general', '737'),
('1536', '736', 'cust_branch', 'general', '738'),
('1537', '736', 'customer', 'general', '738'),
('1538', '737', 'cust_branch', 'general', '739'),
('1539', '737', 'customer', 'general', '739'),
('1540', '738', 'cust_branch', 'general', '740'),
('1541', '738', 'customer', 'general', '740'),
('1542', '739', 'cust_branch', 'general', '741'),
('1543', '739', 'customer', 'general', '741'),
('1544', '740', 'cust_branch', 'general', '742'),
('1545', '740', 'customer', 'general', '742'),
('1546', '741', 'cust_branch', 'general', '743'),
('1547', '741', 'customer', 'general', '743'),
('1548', '742', 'cust_branch', 'general', '744'),
('1549', '742', 'customer', 'general', '744'),
('1550', '743', 'cust_branch', 'general', '745'),
('1551', '743', 'customer', 'general', '745'),
('1552', '744', 'cust_branch', 'general', '746'),
('1553', '744', 'customer', 'general', '746'),
('1554', '745', 'cust_branch', 'general', '747'),
('1555', '745', 'customer', 'general', '747'),
('1556', '746', 'cust_branch', 'general', '748'),
('1557', '746', 'customer', 'general', '748'),
('1558', '747', 'cust_branch', 'general', '749'),
('1559', '747', 'customer', 'general', '749'),
('1560', '748', 'cust_branch', 'general', '750'),
('1561', '748', 'customer', 'general', '750'),
('1562', '749', 'cust_branch', 'general', '751'),
('1563', '749', 'customer', 'general', '751'),
('1564', '750', 'cust_branch', 'general', '752'),
('1565', '750', 'customer', 'general', '752'),
('1566', '751', 'cust_branch', 'general', '753'),
('1567', '751', 'customer', 'general', '753'),
('1568', '752', 'cust_branch', 'general', '754'),
('1569', '752', 'customer', 'general', '754'),
('1570', '753', 'cust_branch', 'general', '755'),
('1571', '753', 'customer', 'general', '755'),
('1572', '754', 'cust_branch', 'general', '756'),
('1573', '754', 'customer', 'general', '756'),
('1574', '755', 'cust_branch', 'general', '757'),
('1575', '755', 'customer', 'general', '757'),
('1576', '756', 'cust_branch', 'general', '758'),
('1577', '756', 'customer', 'general', '758'),
('1578', '757', 'cust_branch', 'general', '759'),
('1579', '757', 'customer', 'general', '759'),
('1580', '758', 'cust_branch', 'general', '760'),
('1581', '758', 'customer', 'general', '760'),
('1582', '759', 'cust_branch', 'general', '761'),
('1583', '759', 'customer', 'general', '761'),
('1584', '760', 'cust_branch', 'general', '762'),
('1585', '760', 'customer', 'general', '762'),
('1586', '761', 'cust_branch', 'general', '763'),
('1587', '761', 'customer', 'general', '763'),
('1588', '762', 'cust_branch', 'general', '764'),
('1589', '762', 'customer', 'general', '764'),
('1590', '763', 'cust_branch', 'general', '765'),
('1591', '763', 'customer', 'general', '765'),
('1592', '764', 'cust_branch', 'general', '766'),
('1593', '764', 'customer', 'general', '766'),
('1594', '765', 'cust_branch', 'general', '767'),
('1595', '765', 'customer', 'general', '767'),
('1596', '766', 'cust_branch', 'general', '768'),
('1597', '766', 'customer', 'general', '768'),
('1598', '767', 'cust_branch', 'general', '769'),
('1599', '767', 'customer', 'general', '769'),
('1600', '768', 'cust_branch', 'general', '770'),
('1601', '768', 'customer', 'general', '770'),
('1602', '769', 'cust_branch', 'general', '771'),
('1603', '769', 'customer', 'general', '771'),
('1604', '770', 'cust_branch', 'general', '772'),
('1605', '770', 'customer', 'general', '772'),
('1606', '771', 'cust_branch', 'general', '773'),
('1607', '771', 'customer', 'general', '773'),
('1608', '772', 'cust_branch', 'general', '774'),
('1609', '772', 'customer', 'general', '774'),
('1610', '773', 'cust_branch', 'general', '775'),
('1611', '773', 'customer', 'general', '775'),
('1612', '774', 'cust_branch', 'general', '776'),
('1613', '774', 'customer', 'general', '776'),
('1614', '775', 'cust_branch', 'general', '777'),
('1615', '775', 'customer', 'general', '777'),
('1616', '776', 'cust_branch', 'general', '778'),
('1617', '776', 'customer', 'general', '778'),
('1618', '777', 'cust_branch', 'general', '779'),
('1619', '777', 'customer', 'general', '779'),
('1620', '778', 'cust_branch', 'general', '780'),
('1621', '778', 'customer', 'general', '780'),
('1622', '779', 'cust_branch', 'general', '781'),
('1623', '779', 'customer', 'general', '781'),
('1624', '780', 'cust_branch', 'general', '782'),
('1625', '780', 'customer', 'general', '782'),
('1626', '781', 'cust_branch', 'general', '783'),
('1627', '781', 'customer', 'general', '783'),
('1628', '782', 'cust_branch', 'general', '784'),
('1629', '782', 'customer', 'general', '784'),
('1630', '783', 'cust_branch', 'general', '785'),
('1631', '783', 'customer', 'general', '785'),
('1632', '784', 'cust_branch', 'general', '786'),
('1633', '784', 'customer', 'general', '786'),
('1634', '785', 'cust_branch', 'general', '787'),
('1635', '785', 'customer', 'general', '787'),
('1636', '786', 'cust_branch', 'general', '788'),
('1637', '786', 'customer', 'general', '788'),
('1638', '787', 'cust_branch', 'general', '789'),
('1639', '787', 'customer', 'general', '789'),
('1640', '788', 'cust_branch', 'general', '790'),
('1641', '788', 'customer', 'general', '790'),
('1642', '789', 'cust_branch', 'general', '791'),
('1643', '789', 'customer', 'general', '791'),
('1644', '790', 'cust_branch', 'general', '792'),
('1645', '790', 'customer', 'general', '792'),
('1646', '791', 'cust_branch', 'general', '793'),
('1647', '791', 'customer', 'general', '793'),
('1648', '792', 'cust_branch', 'general', '794'),
('1649', '792', 'customer', 'general', '794'),
('1650', '793', 'cust_branch', 'general', '795'),
('1651', '793', 'customer', 'general', '795'),
('1652', '794', 'cust_branch', 'general', '796'),
('1653', '794', 'customer', 'general', '796'),
('1654', '795', 'cust_branch', 'general', '797'),
('1655', '795', 'customer', 'general', '797'),
('1656', '796', 'cust_branch', 'general', '798'),
('1657', '796', 'customer', 'general', '798'),
('1658', '797', 'cust_branch', 'general', '799'),
('1659', '797', 'customer', 'general', '799'),
('1660', '798', 'cust_branch', 'general', '800'),
('1661', '798', 'customer', 'general', '800'),
('1662', '799', 'cust_branch', 'general', '801'),
('1663', '799', 'customer', 'general', '801'),
('1664', '800', 'cust_branch', 'general', '802'),
('1665', '800', 'customer', 'general', '802'),
('1666', '801', 'cust_branch', 'general', '803'),
('1667', '801', 'customer', 'general', '803'),
('1668', '802', 'cust_branch', 'general', '804'),
('1669', '802', 'customer', 'general', '804'),
('1670', '803', 'cust_branch', 'general', '805'),
('1671', '803', 'customer', 'general', '805'),
('1672', '804', 'cust_branch', 'general', '806'),
('1673', '804', 'customer', 'general', '806'),
('1674', '805', 'cust_branch', 'general', '807'),
('1675', '805', 'customer', 'general', '807'),
('1676', '806', 'cust_branch', 'general', '808'),
('1677', '806', 'customer', 'general', '808'),
('1678', '807', 'cust_branch', 'general', '809'),
('1679', '807', 'customer', 'general', '809'),
('1680', '808', 'cust_branch', 'general', '810'),
('1681', '808', 'customer', 'general', '810'),
('1682', '809', 'cust_branch', 'general', '811'),
('1683', '809', 'customer', 'general', '811'),
('1684', '810', 'cust_branch', 'general', '812'),
('1685', '810', 'customer', 'general', '812'),
('1686', '811', 'cust_branch', 'general', '813'),
('1687', '811', 'customer', 'general', '813'),
('1688', '812', 'cust_branch', 'general', '814'),
('1689', '812', 'customer', 'general', '814'),
('1690', '813', 'cust_branch', 'general', '815'),
('1691', '813', 'customer', 'general', '815'),
('1692', '814', 'cust_branch', 'general', '816'),
('1693', '814', 'customer', 'general', '816'),
('1694', '815', 'cust_branch', 'general', '817'),
('1695', '815', 'customer', 'general', '817'),
('1696', '816', 'cust_branch', 'general', '818'),
('1697', '816', 'customer', 'general', '818'),
('1698', '817', 'cust_branch', 'general', '819'),
('1699', '817', 'customer', 'general', '819'),
('1700', '818', 'cust_branch', 'general', '820'),
('1701', '818', 'customer', 'general', '820'),
('1702', '819', 'cust_branch', 'general', '821'),
('1703', '819', 'customer', 'general', '821'),
('1704', '820', 'cust_branch', 'general', '822'),
('1705', '820', 'customer', 'general', '822'),
('1706', '821', 'cust_branch', 'general', '823'),
('1707', '821', 'customer', 'general', '823'),
('1708', '822', 'cust_branch', 'general', '824'),
('1709', '822', 'customer', 'general', '824'),
('1710', '823', 'cust_branch', 'general', '825'),
('1711', '823', 'customer', 'general', '825'),
('1712', '824', 'cust_branch', 'general', '826'),
('1713', '824', 'customer', 'general', '826'),
('1714', '825', 'cust_branch', 'general', '827'),
('1715', '825', 'customer', 'general', '827'),
('1716', '826', 'cust_branch', 'general', '828'),
('1717', '826', 'customer', 'general', '828'),
('1718', '827', 'cust_branch', 'general', '829'),
('1719', '827', 'customer', 'general', '829'),
('1720', '828', 'cust_branch', 'general', '830'),
('1721', '828', 'customer', 'general', '830'),
('1722', '829', 'cust_branch', 'general', '831'),
('1723', '829', 'customer', 'general', '831'),
('1724', '830', 'cust_branch', 'general', '832'),
('1725', '830', 'customer', 'general', '832'),
('1726', '831', 'cust_branch', 'general', '833'),
('1727', '831', 'customer', 'general', '833'),
('1728', '832', 'cust_branch', 'general', '834'),
('1729', '832', 'customer', 'general', '834'),
('1730', '833', 'cust_branch', 'general', '835'),
('1731', '833', 'customer', 'general', '835'),
('1732', '834', 'cust_branch', 'general', '836'),
('1733', '834', 'customer', 'general', '836'),
('1734', '835', 'cust_branch', 'general', '837'),
('1735', '835', 'customer', 'general', '837'),
('1736', '836', 'cust_branch', 'general', '838'),
('1737', '836', 'customer', 'general', '838'),
('1738', '837', 'cust_branch', 'general', '839'),
('1739', '837', 'customer', 'general', '839'),
('1740', '838', 'cust_branch', 'general', '840'),
('1741', '838', 'customer', 'general', '840'),
('1742', '839', 'cust_branch', 'general', '841'),
('1743', '839', 'customer', 'general', '841'),
('1744', '840', 'cust_branch', 'general', '842'),
('1745', '840', 'customer', 'general', '842'),
('1746', '841', 'cust_branch', 'general', '843'),
('1747', '841', 'customer', 'general', '843'),
('1748', '842', 'cust_branch', 'general', '844'),
('1749', '842', 'customer', 'general', '844'),
('1750', '843', 'cust_branch', 'general', '845'),
('1751', '843', 'customer', 'general', '845'),
('1752', '844', 'cust_branch', 'general', '846'),
('1753', '844', 'customer', 'general', '846'),
('1754', '845', 'cust_branch', 'general', '847'),
('1755', '845', 'customer', 'general', '847'),
('1756', '846', 'cust_branch', 'general', '848'),
('1757', '846', 'customer', 'general', '848'),
('1758', '847', 'cust_branch', 'general', '849'),
('1759', '847', 'customer', 'general', '849'),
('1760', '848', 'cust_branch', 'general', '850'),
('1761', '848', 'customer', 'general', '850'),
('1762', '849', 'cust_branch', 'general', '851'),
('1763', '849', 'customer', 'general', '851'),
('1764', '850', 'cust_branch', 'general', '852'),
('1765', '850', 'customer', 'general', '852'),
('1766', '851', 'cust_branch', 'general', '853'),
('1767', '851', 'customer', 'general', '853'),
('1768', '852', 'cust_branch', 'general', '854'),
('1769', '852', 'customer', 'general', '854'),
('1770', '853', 'cust_branch', 'general', '855'),
('1771', '853', 'customer', 'general', '855'),
('1772', '854', 'cust_branch', 'general', '856'),
('1773', '854', 'customer', 'general', '856'),
('1774', '855', 'cust_branch', 'general', '857'),
('1775', '855', 'customer', 'general', '857'),
('1776', '856', 'cust_branch', 'general', '858'),
('1777', '856', 'customer', 'general', '858'),
('1778', '857', 'cust_branch', 'general', '859'),
('1779', '857', 'customer', 'general', '859'),
('1780', '858', 'cust_branch', 'general', '860'),
('1781', '858', 'customer', 'general', '860'),
('1782', '859', 'cust_branch', 'general', '861'),
('1783', '859', 'customer', 'general', '861'),
('1784', '860', 'cust_branch', 'general', '862'),
('1785', '860', 'customer', 'general', '862'),
('1786', '861', 'cust_branch', 'general', '863'),
('1787', '861', 'customer', 'general', '863'),
('1788', '862', 'cust_branch', 'general', '864'),
('1789', '862', 'customer', 'general', '864'),
('1790', '863', 'cust_branch', 'general', '865'),
('1791', '863', 'customer', 'general', '865'),
('1792', '864', 'cust_branch', 'general', '866'),
('1793', '864', 'customer', 'general', '866'),
('1794', '865', 'cust_branch', 'general', '867'),
('1795', '865', 'customer', 'general', '867'),
('1796', '866', 'cust_branch', 'general', '868'),
('1797', '866', 'customer', 'general', '868'),
('1798', '867', 'cust_branch', 'general', '869'),
('1799', '867', 'customer', 'general', '869'),
('1800', '868', 'cust_branch', 'general', '870'),
('1801', '868', 'customer', 'general', '870'),
('1802', '869', 'cust_branch', 'general', '871'),
('1803', '869', 'customer', 'general', '871'),
('1804', '870', 'cust_branch', 'general', '872'),
('1805', '870', 'customer', 'general', '872'),
('1806', '871', 'cust_branch', 'general', '873'),
('1807', '871', 'customer', 'general', '873'),
('1808', '872', 'cust_branch', 'general', '874'),
('1809', '872', 'customer', 'general', '874'),
('1810', '873', 'cust_branch', 'general', '875'),
('1811', '873', 'customer', 'general', '875'),
('1812', '874', 'cust_branch', 'general', '876'),
('1813', '874', 'customer', 'general', '876'),
('1814', '875', 'cust_branch', 'general', '877'),
('1815', '875', 'customer', 'general', '877'),
('1816', '876', 'cust_branch', 'general', '878'),
('1817', '876', 'customer', 'general', '878'),
('1818', '877', 'cust_branch', 'general', '879'),
('1819', '877', 'customer', 'general', '879'),
('1820', '878', 'cust_branch', 'general', '880'),
('1821', '878', 'customer', 'general', '880'),
('1822', '879', 'cust_branch', 'general', '881'),
('1823', '879', 'customer', 'general', '881'),
('1824', '880', 'cust_branch', 'general', '882'),
('1825', '880', 'customer', 'general', '882'),
('1826', '881', 'cust_branch', 'general', '883'),
('1827', '881', 'customer', 'general', '883'),
('1828', '882', 'cust_branch', 'general', '884'),
('1829', '882', 'customer', 'general', '884'),
('1830', '883', 'cust_branch', 'general', '885'),
('1831', '883', 'customer', 'general', '885'),
('1832', '884', 'cust_branch', 'general', '886'),
('1833', '884', 'customer', 'general', '886'),
('1834', '885', 'cust_branch', 'general', '887'),
('1835', '885', 'customer', 'general', '887'),
('1836', '886', 'cust_branch', 'general', '888'),
('1837', '886', 'customer', 'general', '888'),
('1838', '887', 'cust_branch', 'general', '889'),
('1839', '887', 'customer', 'general', '889'),
('1840', '888', 'cust_branch', 'general', '890'),
('1841', '888', 'customer', 'general', '890'),
('1842', '889', 'cust_branch', 'general', '891'),
('1843', '889', 'customer', 'general', '891'),
('1844', '890', 'cust_branch', 'general', '892'),
('1845', '890', 'customer', 'general', '892'),
('1846', '891', 'cust_branch', 'general', '893'),
('1847', '891', 'customer', 'general', '893'),
('1848', '892', 'cust_branch', 'general', '894'),
('1849', '892', 'customer', 'general', '894'),
('1850', '893', 'cust_branch', 'general', '895'),
('1851', '893', 'customer', 'general', '895'),
('1852', '894', 'cust_branch', 'general', '896'),
('1853', '894', 'customer', 'general', '896'),
('1854', '895', 'cust_branch', 'general', '897'),
('1855', '895', 'customer', 'general', '897'),
('1856', '896', 'cust_branch', 'general', '898'),
('1857', '896', 'customer', 'general', '898'),
('1858', '897', 'cust_branch', 'general', '899'),
('1859', '897', 'customer', 'general', '899'),
('1860', '898', 'cust_branch', 'general', '900'),
('1861', '898', 'customer', 'general', '900'),
('1862', '899', 'cust_branch', 'general', '901'),
('1863', '899', 'customer', 'general', '901'),
('1864', '900', 'cust_branch', 'general', '902'),
('1865', '900', 'customer', 'general', '902'),
('1866', '901', 'cust_branch', 'general', '903'),
('1867', '901', 'customer', 'general', '903'),
('1868', '902', 'cust_branch', 'general', '904'),
('1869', '902', 'customer', 'general', '904'),
('1870', '903', 'cust_branch', 'general', '905'),
('1871', '903', 'customer', 'general', '905'),
('1872', '904', 'cust_branch', 'general', '906'),
('1873', '904', 'customer', 'general', '906'),
('1874', '905', 'cust_branch', 'general', '907'),
('1875', '905', 'customer', 'general', '907'),
('1876', '906', 'cust_branch', 'general', '908'),
('1877', '906', 'customer', 'general', '908'),
('1878', '907', 'cust_branch', 'general', '909'),
('1879', '907', 'customer', 'general', '909'),
('1880', '908', 'cust_branch', 'general', '910'),
('1881', '908', 'customer', 'general', '910'),
('1882', '909', 'cust_branch', 'general', '911'),
('1883', '909', 'customer', 'general', '911'),
('1884', '910', 'cust_branch', 'general', '912'),
('1885', '910', 'customer', 'general', '912'),
('1886', '911', 'cust_branch', 'general', '913'),
('1887', '911', 'customer', 'general', '913'),
('1888', '912', 'cust_branch', 'general', '914'),
('1889', '912', 'customer', 'general', '914'),
('1890', '913', 'cust_branch', 'general', '915'),
('1891', '913', 'customer', 'general', '915'),
('1892', '914', 'cust_branch', 'general', '916'),
('1893', '914', 'customer', 'general', '916'),
('1894', '915', 'cust_branch', 'general', '917'),
('1895', '915', 'customer', 'general', '917'),
('1896', '916', 'cust_branch', 'general', '918'),
('1897', '916', 'customer', 'general', '918'),
('1898', '917', 'cust_branch', 'general', '919'),
('1899', '917', 'customer', 'general', '919'),
('1900', '918', 'cust_branch', 'general', '920'),
('1901', '918', 'customer', 'general', '920'),
('1902', '919', 'cust_branch', 'general', '921'),
('1903', '919', 'customer', 'general', '921'),
('1904', '920', 'cust_branch', 'general', '922'),
('1905', '920', 'customer', 'general', '922'),
('1906', '921', 'cust_branch', 'general', '923'),
('1907', '921', 'customer', 'general', '923'),
('1908', '922', 'cust_branch', 'general', '924'),
('1909', '922', 'customer', 'general', '924'),
('1910', '923', 'cust_branch', 'general', '925'),
('1911', '923', 'customer', 'general', '925'),
('1912', '924', 'cust_branch', 'general', '926'),
('1913', '924', 'customer', 'general', '926'),
('1914', '925', 'cust_branch', 'general', '927'),
('1915', '925', 'customer', 'general', '927'),
('1916', '926', 'cust_branch', 'general', '928'),
('1917', '926', 'customer', 'general', '928'),
('1918', '927', 'cust_branch', 'general', '929'),
('1919', '927', 'customer', 'general', '929'),
('1920', '928', 'cust_branch', 'general', '930'),
('1921', '928', 'customer', 'general', '930'),
('1922', '929', 'cust_branch', 'general', '931'),
('1923', '929', 'customer', 'general', '931'),
('1924', '930', 'cust_branch', 'general', '932'),
('1925', '930', 'customer', 'general', '932'),
('1926', '931', 'cust_branch', 'general', '933'),
('1927', '931', 'customer', 'general', '933'),
('1928', '932', 'cust_branch', 'general', '934'),
('1929', '932', 'customer', 'general', '934'),
('1930', '933', 'cust_branch', 'general', '935'),
('1931', '933', 'customer', 'general', '935'),
('1932', '934', 'cust_branch', 'general', '936'),
('1933', '934', 'customer', 'general', '936'),
('1934', '935', 'cust_branch', 'general', '937'),
('1935', '935', 'customer', 'general', '937'),
('1936', '936', 'cust_branch', 'general', '938'),
('1937', '936', 'customer', 'general', '938'),
('1938', '937', 'cust_branch', 'general', '939'),
('1939', '937', 'customer', 'general', '939'),
('1940', '938', 'cust_branch', 'general', '940'),
('1941', '938', 'customer', 'general', '940'),
('1942', '939', 'cust_branch', 'general', '941'),
('1943', '939', 'customer', 'general', '941'),
('1944', '940', 'cust_branch', 'general', '942'),
('1945', '940', 'customer', 'general', '942'),
('1946', '941', 'cust_branch', 'general', '943'),
('1947', '941', 'customer', 'general', '943'),
('1948', '942', 'cust_branch', 'general', '944'),
('1949', '942', 'customer', 'general', '944'),
('1950', '943', 'cust_branch', 'general', '945'),
('1951', '943', 'customer', 'general', '945'),
('1952', '944', 'cust_branch', 'general', '946'),
('1953', '944', 'customer', 'general', '946'),
('1954', '945', 'cust_branch', 'general', '947'),
('1955', '945', 'customer', 'general', '947'),
('1956', '946', 'cust_branch', 'general', '948'),
('1957', '946', 'customer', 'general', '948'),
('1958', '947', 'cust_branch', 'general', '949'),
('1959', '947', 'customer', 'general', '949'),
('1960', '948', 'cust_branch', 'general', '950'),
('1961', '948', 'customer', 'general', '950'),
('1962', '949', 'cust_branch', 'general', '951'),
('1963', '949', 'customer', 'general', '951'),
('1964', '950', 'cust_branch', 'general', '952'),
('1965', '950', 'customer', 'general', '952'),
('1966', '951', 'cust_branch', 'general', '953'),
('1967', '951', 'customer', 'general', '953'),
('1968', '952', 'cust_branch', 'general', '954'),
('1969', '952', 'customer', 'general', '954'),
('1970', '953', 'cust_branch', 'general', '955'),
('1971', '953', 'customer', 'general', '955'),
('1972', '954', 'cust_branch', 'general', '956'),
('1973', '954', 'customer', 'general', '956'),
('1974', '955', 'cust_branch', 'general', '957'),
('1975', '955', 'customer', 'general', '957'),
('1976', '956', 'cust_branch', 'general', '958'),
('1977', '956', 'customer', 'general', '958'),
('1978', '957', 'cust_branch', 'general', '959'),
('1979', '957', 'customer', 'general', '959'),
('1980', '958', 'cust_branch', 'general', '960'),
('1981', '958', 'customer', 'general', '960'),
('1982', '959', 'cust_branch', 'general', '961'),
('1983', '959', 'customer', 'general', '961'),
('1984', '960', 'cust_branch', 'general', '962'),
('1985', '960', 'customer', 'general', '962'),
('1986', '961', 'cust_branch', 'general', '963'),
('1987', '961', 'customer', 'general', '963'),
('1988', '962', 'cust_branch', 'general', '964'),
('1989', '962', 'customer', 'general', '964'),
('1990', '963', 'cust_branch', 'general', '965'),
('1991', '963', 'customer', 'general', '965'),
('1992', '964', 'cust_branch', 'general', '966'),
('1993', '964', 'customer', 'general', '966'),
('1994', '965', 'cust_branch', 'general', '967'),
('1995', '965', 'customer', 'general', '967'),
('1996', '966', 'cust_branch', 'general', '968'),
('1997', '966', 'customer', 'general', '968'),
('1998', '967', 'cust_branch', 'general', '969'),
('1999', '967', 'customer', 'general', '969'),
('2000', '968', 'cust_branch', 'general', '970'),
('2001', '968', 'customer', 'general', '970'),
('2002', '969', 'cust_branch', 'general', '971'),
('2003', '969', 'customer', 'general', '971'),
('2004', '970', 'cust_branch', 'general', '972'),
('2005', '970', 'customer', 'general', '972'),
('2006', '971', 'cust_branch', 'general', '973'),
('2007', '971', 'customer', 'general', '973'),
('2008', '972', 'cust_branch', 'general', '974'),
('2009', '972', 'customer', 'general', '974'),
('2010', '973', 'cust_branch', 'general', '975'),
('2011', '973', 'customer', 'general', '975'),
('2012', '974', 'cust_branch', 'general', '976'),
('2013', '974', 'customer', 'general', '976'),
('2014', '975', 'cust_branch', 'general', '977'),
('2015', '975', 'customer', 'general', '977'),
('2016', '976', 'cust_branch', 'general', '978'),
('2017', '976', 'customer', 'general', '978'),
('2018', '977', 'cust_branch', 'general', '979'),
('2019', '977', 'customer', 'general', '979'),
('2020', '978', 'cust_branch', 'general', '980'),
('2021', '978', 'customer', 'general', '980'),
('2022', '979', 'cust_branch', 'general', '981'),
('2023', '979', 'customer', 'general', '981'),
('2024', '980', 'cust_branch', 'general', '982'),
('2025', '980', 'customer', 'general', '982'),
('2026', '981', 'cust_branch', 'general', '983'),
('2027', '981', 'customer', 'general', '983'),
('2028', '982', 'cust_branch', 'general', '984'),
('2029', '982', 'customer', 'general', '984'),
('2030', '983', 'cust_branch', 'general', '985'),
('2031', '983', 'customer', 'general', '985'),
('2032', '984', 'cust_branch', 'general', '986'),
('2033', '984', 'customer', 'general', '986'),
('2034', '985', 'cust_branch', 'general', '987'),
('2035', '985', 'customer', 'general', '987'),
('2036', '986', 'cust_branch', 'general', '988'),
('2037', '986', 'customer', 'general', '988'),
('2038', '987', 'cust_branch', 'general', '989'),
('2039', '987', 'customer', 'general', '989'),
('2040', '988', 'cust_branch', 'general', '990'),
('2041', '988', 'customer', 'general', '990'),
('2042', '989', 'cust_branch', 'general', '991'),
('2043', '989', 'customer', 'general', '991'),
('2044', '990', 'cust_branch', 'general', '992'),
('2045', '990', 'customer', 'general', '992'),
('2046', '991', 'cust_branch', 'general', '993'),
('2047', '991', 'customer', 'general', '993'),
('2048', '992', 'cust_branch', 'general', '994'),
('2049', '992', 'customer', 'general', '994'),
('2050', '993', 'cust_branch', 'general', '995'),
('2051', '993', 'customer', 'general', '995'),
('2052', '994', 'cust_branch', 'general', '996'),
('2053', '994', 'customer', 'general', '996'),
('2054', '995', 'cust_branch', 'general', '997'),
('2055', '995', 'customer', 'general', '997'),
('2056', '996', 'cust_branch', 'general', '998'),
('2057', '996', 'customer', 'general', '998'),
('2058', '997', 'cust_branch', 'general', '999'),
('2059', '997', 'customer', 'general', '999'),
('2060', '998', 'cust_branch', 'general', '1000'),
('2061', '998', 'customer', 'general', '1000'),
('2062', '999', 'cust_branch', 'general', '1001'),
('2063', '999', 'customer', 'general', '1001'),
('2064', '1000', 'cust_branch', 'general', '1002'),
('2065', '1000', 'customer', 'general', '1002'),
('2066', '1001', 'cust_branch', 'general', '1003'),
('2067', '1001', 'customer', 'general', '1003'),
('2068', '1002', 'cust_branch', 'general', '1004'),
('2069', '1002', 'customer', 'general', '1004'),
('2070', '1003', 'cust_branch', 'general', '1005'),
('2071', '1003', 'customer', 'general', '1005'),
('2072', '1004', 'cust_branch', 'general', '1006'),
('2073', '1004', 'customer', 'general', '1006'),
('2074', '1005', 'cust_branch', 'general', '1007'),
('2075', '1005', 'customer', 'general', '1007'),
('2076', '1006', 'cust_branch', 'general', '1008'),
('2077', '1006', 'customer', 'general', '1008'),
('2078', '1007', 'cust_branch', 'general', '1009'),
('2079', '1007', 'customer', 'general', '1009'),
('2080', '1008', 'cust_branch', 'general', '1010'),
('2081', '1008', 'customer', 'general', '1010'),
('2082', '1009', 'cust_branch', 'general', '1011'),
('2083', '1009', 'customer', 'general', '1011'),
('2084', '1010', 'cust_branch', 'general', '1012'),
('2085', '1010', 'customer', 'general', '1012'),
('2086', '1011', 'cust_branch', 'general', '1013'),
('2087', '1011', 'customer', 'general', '1013'),
('2088', '1012', 'cust_branch', 'general', '1014'),
('2089', '1012', 'customer', 'general', '1014'),
('2090', '1013', 'cust_branch', 'general', '1015'),
('2091', '1013', 'customer', 'general', '1015'),
('2092', '1014', 'cust_branch', 'general', '1016'),
('2093', '1014', 'customer', 'general', '1016'),
('2094', '1015', 'cust_branch', 'general', '1017'),
('2095', '1015', 'customer', 'general', '1017'),
('2096', '1016', 'cust_branch', 'general', '1018'),
('2097', '1016', 'customer', 'general', '1018'),
('2098', '1017', 'cust_branch', 'general', '1019'),
('2099', '1017', 'customer', 'general', '1019'),
('2100', '1018', 'cust_branch', 'general', '1020'),
('2101', '1018', 'customer', 'general', '1020'),
('2102', '1019', 'cust_branch', 'general', '1021'),
('2103', '1019', 'customer', 'general', '1021'),
('2104', '1020', 'cust_branch', 'general', '1022'),
('2105', '1020', 'customer', 'general', '1022'),
('2106', '1021', 'cust_branch', 'general', '1023'),
('2107', '1021', 'customer', 'general', '1023'),
('2108', '1022', 'cust_branch', 'general', '1024'),
('2109', '1022', 'customer', 'general', '1024'),
('2110', '1023', 'cust_branch', 'general', '1025'),
('2111', '1023', 'customer', 'general', '1025'),
('2112', '1024', 'cust_branch', 'general', '1026'),
('2113', '1024', 'customer', 'general', '1026'),
('2114', '1025', 'cust_branch', 'general', '1027'),
('2115', '1025', 'customer', 'general', '1027'),
('2116', '1026', 'cust_branch', 'general', '1028'),
('2117', '1026', 'customer', 'general', '1028'),
('2118', '1027', 'cust_branch', 'general', '1029'),
('2119', '1027', 'customer', 'general', '1029'),
('2120', '1028', 'cust_branch', 'general', '1030'),
('2121', '1028', 'customer', 'general', '1030'),
('2122', '1029', 'cust_branch', 'general', '1031'),
('2123', '1029', 'customer', 'general', '1031'),
('2124', '1030', 'cust_branch', 'general', '1032'),
('2125', '1030', 'customer', 'general', '1032'),
('2126', '1031', 'cust_branch', 'general', '1033'),
('2127', '1031', 'customer', 'general', '1033'),
('2128', '1032', 'cust_branch', 'general', '1034'),
('2129', '1032', 'customer', 'general', '1034'),
('2130', '1033', 'cust_branch', 'general', '1035'),
('2131', '1033', 'customer', 'general', '1035'),
('2132', '1034', 'cust_branch', 'general', '1036'),
('2133', '1034', 'customer', 'general', '1036'),
('2134', '1035', 'cust_branch', 'general', '1037'),
('2135', '1035', 'customer', 'general', '1037'),
('2136', '1036', 'cust_branch', 'general', '1038'),
('2137', '1036', 'customer', 'general', '1038'),
('2138', '1037', 'cust_branch', 'general', '1039'),
('2139', '1037', 'customer', 'general', '1039'),
('2140', '1038', 'cust_branch', 'general', '1040'),
('2141', '1038', 'customer', 'general', '1040'),
('2142', '1039', 'cust_branch', 'general', '1041'),
('2143', '1039', 'customer', 'general', '1041'),
('2144', '1040', 'cust_branch', 'general', '1042'),
('2145', '1040', 'customer', 'general', '1042'),
('2146', '1041', 'cust_branch', 'general', '1043'),
('2147', '1041', 'customer', 'general', '1043'),
('2148', '1042', 'cust_branch', 'general', '1044'),
('2149', '1042', 'customer', 'general', '1044'),
('2150', '1043', 'cust_branch', 'general', '1045'),
('2151', '1043', 'customer', 'general', '1045'),
('2152', '1044', 'cust_branch', 'general', '1046'),
('2153', '1044', 'customer', 'general', '1046'),
('2154', '1045', 'cust_branch', 'general', '1047'),
('2155', '1045', 'customer', 'general', '1047'),
('2156', '1046', 'cust_branch', 'general', '1048'),
('2157', '1046', 'customer', 'general', '1048'),
('2158', '1047', 'cust_branch', 'general', '1049'),
('2159', '1047', 'customer', 'general', '1049'),
('2160', '1048', 'cust_branch', 'general', '1050'),
('2161', '1048', 'customer', 'general', '1050'),
('2162', '1049', 'cust_branch', 'general', '1051'),
('2163', '1049', 'customer', 'general', '1051'),
('2164', '1050', 'cust_branch', 'general', '1052'),
('2165', '1050', 'customer', 'general', '1052'),
('2166', '1051', 'cust_branch', 'general', '1053'),
('2167', '1051', 'customer', 'general', '1053'),
('2168', '1052', 'cust_branch', 'general', '1054'),
('2169', '1052', 'customer', 'general', '1054'),
('2170', '1053', 'cust_branch', 'general', '1055'),
('2171', '1053', 'customer', 'general', '1055'),
('2172', '1054', 'cust_branch', 'general', '1056'),
('2173', '1054', 'customer', 'general', '1056'),
('2174', '1055', 'cust_branch', 'general', '1057'),
('2175', '1055', 'customer', 'general', '1057'),
('2176', '1056', 'cust_branch', 'general', '1058'),
('2177', '1056', 'customer', 'general', '1058'),
('2178', '1057', 'cust_branch', 'general', '1059'),
('2179', '1057', 'customer', 'general', '1059'),
('2180', '1058', 'cust_branch', 'general', '1060'),
('2181', '1058', 'customer', 'general', '1060'),
('2182', '1059', 'cust_branch', 'general', '1061'),
('2183', '1059', 'customer', 'general', '1061'),
('2184', '1060', 'cust_branch', 'general', '1062'),
('2185', '1060', 'customer', 'general', '1062');
INSERT INTO `0_crm_contacts` VALUES
('2186', '1061', 'cust_branch', 'general', '1063'),
('2187', '1061', 'customer', 'general', '1063'),
('2188', '1062', 'cust_branch', 'general', '1064'),
('2189', '1062', 'customer', 'general', '1064'),
('2190', '1063', 'cust_branch', 'general', '1065'),
('2191', '1063', 'customer', 'general', '1065'),
('2192', '1064', 'cust_branch', 'general', '1066'),
('2193', '1064', 'customer', 'general', '1066'),
('2194', '1065', 'cust_branch', 'general', '1067'),
('2195', '1065', 'customer', 'general', '1067'),
('2196', '1066', 'cust_branch', 'general', '1068'),
('2197', '1066', 'customer', 'general', '1068'),
('2198', '1067', 'cust_branch', 'general', '1069'),
('2199', '1067', 'customer', 'general', '1069'),
('2200', '1068', 'cust_branch', 'general', '1070'),
('2201', '1068', 'customer', 'general', '1070'),
('2202', '1069', 'cust_branch', 'general', '1071'),
('2203', '1069', 'customer', 'general', '1071'),
('2204', '1070', 'cust_branch', 'general', '1072'),
('2205', '1070', 'customer', 'general', '1072'),
('2206', '1071', 'cust_branch', 'general', '1073'),
('2207', '1071', 'customer', 'general', '1073'),
('2208', '1072', 'cust_branch', 'general', '1074'),
('2209', '1072', 'customer', 'general', '1074'),
('2210', '1073', 'cust_branch', 'general', '1075'),
('2211', '1073', 'customer', 'general', '1075'),
('2212', '1074', 'cust_branch', 'general', '1076'),
('2213', '1074', 'customer', 'general', '1076'),
('2214', '1075', 'cust_branch', 'general', '1077'),
('2215', '1075', 'customer', 'general', '1077'),
('2216', '1076', 'cust_branch', 'general', '1078'),
('2217', '1076', 'customer', 'general', '1078'),
('2218', '1077', 'cust_branch', 'general', '1079'),
('2219', '1077', 'customer', 'general', '1079'),
('2220', '1078', 'cust_branch', 'general', '1080'),
('2221', '1078', 'customer', 'general', '1080'),
('2222', '1079', 'cust_branch', 'general', '1081'),
('2223', '1079', 'customer', 'general', '1081'),
('2224', '1080', 'cust_branch', 'general', '1082'),
('2225', '1080', 'customer', 'general', '1082'),
('2226', '1081', 'cust_branch', 'general', '1083'),
('2227', '1081', 'customer', 'general', '1083'),
('2228', '1082', 'cust_branch', 'general', '1084'),
('2229', '1082', 'customer', 'general', '1084'),
('2230', '1083', 'cust_branch', 'general', '1085'),
('2231', '1083', 'customer', 'general', '1085'),
('2232', '1084', 'cust_branch', 'general', '1086'),
('2233', '1084', 'customer', 'general', '1086'),
('2234', '1085', 'cust_branch', 'general', '1087'),
('2235', '1085', 'customer', 'general', '1087'),
('2236', '1086', 'cust_branch', 'general', '1088'),
('2237', '1086', 'customer', 'general', '1088'),
('2238', '1087', 'cust_branch', 'general', '1089'),
('2239', '1087', 'customer', 'general', '1089'),
('2240', '1088', 'cust_branch', 'general', '1090'),
('2241', '1088', 'customer', 'general', '1090'),
('2242', '1089', 'cust_branch', 'general', '1091'),
('2243', '1089', 'customer', 'general', '1091'),
('2244', '1090', 'cust_branch', 'general', '1092'),
('2245', '1090', 'customer', 'general', '1092'),
('2246', '1091', 'cust_branch', 'general', '1093'),
('2247', '1091', 'customer', 'general', '1093'),
('2248', '1092', 'cust_branch', 'general', '1094'),
('2249', '1092', 'customer', 'general', '1094'),
('2250', '1093', 'cust_branch', 'general', '1095'),
('2251', '1093', 'customer', 'general', '1095'),
('2252', '1094', 'cust_branch', 'general', '1096'),
('2253', '1094', 'customer', 'general', '1096'),
('2254', '1095', 'cust_branch', 'general', '1097'),
('2255', '1095', 'customer', 'general', '1097'),
('2256', '1096', 'cust_branch', 'general', '1098'),
('2257', '1096', 'customer', 'general', '1098'),
('2258', '1097', 'cust_branch', 'general', '1099'),
('2259', '1097', 'customer', 'general', '1099'),
('2260', '1098', 'cust_branch', 'general', '1100'),
('2261', '1098', 'customer', 'general', '1100'),
('2262', '1099', 'cust_branch', 'general', '1101'),
('2263', '1099', 'customer', 'general', '1101'),
('2264', '1100', 'cust_branch', 'general', '1102'),
('2265', '1100', 'customer', 'general', '1102'),
('2266', '1101', 'cust_branch', 'general', '1103'),
('2267', '1101', 'customer', 'general', '1103'),
('2268', '1102', 'cust_branch', 'general', '1104'),
('2269', '1102', 'customer', 'general', '1104'),
('2270', '1103', 'cust_branch', 'general', '1105'),
('2271', '1103', 'customer', 'general', '1105'),
('2272', '1104', 'cust_branch', 'general', '1106'),
('2273', '1104', 'customer', 'general', '1106'),
('2274', '1105', 'cust_branch', 'general', '1107'),
('2275', '1105', 'customer', 'general', '1107'),
('2276', '1106', 'cust_branch', 'general', '1108'),
('2277', '1106', 'customer', 'general', '1108'),
('2278', '1107', 'cust_branch', 'general', '1109'),
('2279', '1107', 'customer', 'general', '1109'),
('2280', '1108', 'cust_branch', 'general', '1110'),
('2281', '1108', 'customer', 'general', '1110'),
('2282', '1109', 'cust_branch', 'general', '1111'),
('2283', '1109', 'customer', 'general', '1111'),
('2284', '1110', 'cust_branch', 'general', '1112'),
('2285', '1110', 'customer', 'general', '1112'),
('2286', '1111', 'cust_branch', 'general', '1113'),
('2287', '1111', 'customer', 'general', '1113'),
('2288', '1112', 'cust_branch', 'general', '1114'),
('2289', '1112', 'customer', 'general', '1114'),
('2290', '1113', 'cust_branch', 'general', '1115'),
('2291', '1113', 'customer', 'general', '1115'),
('2292', '1114', 'cust_branch', 'general', '1116'),
('2293', '1114', 'customer', 'general', '1116'),
('2294', '1115', 'cust_branch', 'general', '1117'),
('2295', '1115', 'customer', 'general', '1117'),
('2296', '1116', 'cust_branch', 'general', '1118'),
('2297', '1116', 'customer', 'general', '1118'),
('2298', '1117', 'cust_branch', 'general', '1119'),
('2299', '1117', 'customer', 'general', '1119'),
('2300', '1118', 'cust_branch', 'general', '1120'),
('2301', '1118', 'customer', 'general', '1120'),
('2302', '1119', 'cust_branch', 'general', '1121'),
('2303', '1119', 'customer', 'general', '1121'),
('2304', '1120', 'cust_branch', 'general', '1122'),
('2305', '1120', 'customer', 'general', '1122'),
('2306', '1121', 'cust_branch', 'general', '1123'),
('2307', '1121', 'customer', 'general', '1123'),
('2308', '1122', 'cust_branch', 'general', '1124'),
('2309', '1122', 'customer', 'general', '1124'),
('2310', '1123', 'cust_branch', 'general', '1125'),
('2311', '1123', 'customer', 'general', '1125'),
('2312', '1124', 'cust_branch', 'general', '1126'),
('2313', '1124', 'customer', 'general', '1126'),
('2314', '1125', 'cust_branch', 'general', '1127'),
('2315', '1125', 'customer', 'general', '1127'),
('2316', '1126', 'cust_branch', 'general', '1128'),
('2317', '1126', 'customer', 'general', '1128'),
('2318', '1127', 'cust_branch', 'general', '1129'),
('2319', '1127', 'customer', 'general', '1129'),
('2320', '1128', 'cust_branch', 'general', '1130'),
('2321', '1128', 'customer', 'general', '1130'),
('2322', '1129', 'cust_branch', 'general', '1131'),
('2323', '1129', 'customer', 'general', '1131'),
('2324', '1130', 'cust_branch', 'general', '1132'),
('2325', '1130', 'customer', 'general', '1132'),
('2326', '1131', 'cust_branch', 'general', '1133'),
('2327', '1131', 'customer', 'general', '1133'),
('2328', '1132', 'cust_branch', 'general', '1134'),
('2329', '1132', 'customer', 'general', '1134'),
('2330', '1133', 'cust_branch', 'general', '1135'),
('2331', '1133', 'customer', 'general', '1135'),
('2332', '1134', 'cust_branch', 'general', '1136'),
('2333', '1134', 'customer', 'general', '1136'),
('2334', '1135', 'cust_branch', 'general', '1137'),
('2335', '1135', 'customer', 'general', '1137'),
('2336', '1136', 'cust_branch', 'general', '1138'),
('2337', '1136', 'customer', 'general', '1138'),
('2338', '1137', 'cust_branch', 'general', '1139'),
('2339', '1137', 'customer', 'general', '1139'),
('2340', '1138', 'cust_branch', 'general', '1140'),
('2341', '1138', 'customer', 'general', '1140'),
('2342', '1139', 'cust_branch', 'general', '1141'),
('2343', '1139', 'customer', 'general', '1141'),
('2344', '1140', 'cust_branch', 'general', '1142'),
('2345', '1140', 'customer', 'general', '1142'),
('2346', '1141', 'cust_branch', 'general', '1143'),
('2347', '1141', 'customer', 'general', '1143'),
('2348', '1142', 'cust_branch', 'general', '1144'),
('2349', '1142', 'customer', 'general', '1144'),
('2350', '1143', 'cust_branch', 'general', '1145'),
('2351', '1143', 'customer', 'general', '1145'),
('2352', '1144', 'cust_branch', 'general', '1146'),
('2353', '1144', 'customer', 'general', '1146'),
('2354', '1145', 'cust_branch', 'general', '1147'),
('2355', '1145', 'customer', 'general', '1147'),
('2356', '1146', 'cust_branch', 'general', '1148'),
('2357', '1146', 'customer', 'general', '1148'),
('2358', '1147', 'cust_branch', 'general', '1149'),
('2359', '1147', 'customer', 'general', '1149'),
('2360', '1148', 'cust_branch', 'general', '1150'),
('2361', '1148', 'customer', 'general', '1150'),
('2362', '1149', 'cust_branch', 'general', '1151'),
('2363', '1149', 'customer', 'general', '1151'),
('2364', '1150', 'cust_branch', 'general', '1152'),
('2365', '1150', 'customer', 'general', '1152'),
('2366', '1151', 'cust_branch', 'general', '1153'),
('2367', '1151', 'customer', 'general', '1153'),
('2368', '1152', 'cust_branch', 'general', '1154'),
('2369', '1152', 'customer', 'general', '1154'),
('2370', '1153', 'cust_branch', 'general', '1155'),
('2371', '1153', 'customer', 'general', '1155'),
('2372', '1154', 'cust_branch', 'general', '1156'),
('2373', '1154', 'customer', 'general', '1156'),
('2374', '1155', 'cust_branch', 'general', '1157'),
('2375', '1155', 'customer', 'general', '1157'),
('2376', '1156', 'cust_branch', 'general', '1158'),
('2377', '1156', 'customer', 'general', '1158'),
('2378', '1157', 'cust_branch', 'general', '1159'),
('2379', '1157', 'customer', 'general', '1159'),
('2380', '1158', 'cust_branch', 'general', '1160'),
('2381', '1158', 'customer', 'general', '1160'),
('2382', '1159', 'cust_branch', 'general', '1161'),
('2383', '1159', 'customer', 'general', '1161'),
('2384', '1160', 'cust_branch', 'general', '1162'),
('2385', '1160', 'customer', 'general', '1162'),
('2386', '1161', 'cust_branch', 'general', '1163'),
('2387', '1161', 'customer', 'general', '1163'),
('2388', '1162', 'cust_branch', 'general', '1164'),
('2389', '1162', 'customer', 'general', '1164'),
('2390', '1163', 'cust_branch', 'general', '1165'),
('2391', '1163', 'customer', 'general', '1165'),
('2392', '1164', 'cust_branch', 'general', '1166'),
('2393', '1164', 'customer', 'general', '1166'),
('2394', '1165', 'cust_branch', 'general', '1167'),
('2395', '1165', 'customer', 'general', '1167'),
('2396', '1166', 'cust_branch', 'general', '1168'),
('2397', '1166', 'customer', 'general', '1168'),
('2398', '1167', 'cust_branch', 'general', '1169'),
('2399', '1167', 'customer', 'general', '1169'),
('2400', '1168', 'cust_branch', 'general', '1170'),
('2401', '1168', 'customer', 'general', '1170'),
('2402', '1169', 'cust_branch', 'general', '1171'),
('2403', '1169', 'customer', 'general', '1171'),
('2404', '1170', 'cust_branch', 'general', '1172'),
('2405', '1170', 'customer', 'general', '1172'),
('2406', '1171', 'cust_branch', 'general', '1173'),
('2407', '1171', 'customer', 'general', '1173'),
('2408', '1172', 'cust_branch', 'general', '1174'),
('2409', '1172', 'customer', 'general', '1174'),
('2410', '1173', 'cust_branch', 'general', '1175'),
('2411', '1173', 'customer', 'general', '1175'),
('2412', '1174', 'cust_branch', 'general', '1176'),
('2413', '1174', 'customer', 'general', '1176'),
('2414', '1175', 'cust_branch', 'general', '1177'),
('2415', '1175', 'customer', 'general', '1177'),
('2416', '1176', 'cust_branch', 'general', '1178'),
('2417', '1176', 'customer', 'general', '1178'),
('2418', '1177', 'cust_branch', 'general', '1179'),
('2419', '1177', 'customer', 'general', '1179'),
('2420', '1178', 'cust_branch', 'general', '1180'),
('2421', '1178', 'customer', 'general', '1180'),
('2422', '1179', 'cust_branch', 'general', '1181'),
('2423', '1179', 'customer', 'general', '1181'),
('2424', '1180', 'cust_branch', 'general', '1182'),
('2425', '1180', 'customer', 'general', '1182'),
('2426', '1181', 'cust_branch', 'general', '1183'),
('2427', '1181', 'customer', 'general', '1183'),
('2428', '1182', 'cust_branch', 'general', '1184'),
('2429', '1182', 'customer', 'general', '1184'),
('2430', '1183', 'cust_branch', 'general', '1185'),
('2431', '1183', 'customer', 'general', '1185'),
('2432', '1184', 'cust_branch', 'general', '1186'),
('2433', '1184', 'customer', 'general', '1186'),
('2434', '1185', 'cust_branch', 'general', '1187'),
('2435', '1185', 'customer', 'general', '1187'),
('2436', '1186', 'cust_branch', 'general', '1188'),
('2437', '1186', 'customer', 'general', '1188'),
('2438', '1187', 'cust_branch', 'general', '1189'),
('2439', '1187', 'customer', 'general', '1189'),
('2440', '1188', 'cust_branch', 'general', '1190'),
('2441', '1188', 'customer', 'general', '1190'),
('2442', '1189', 'cust_branch', 'general', '1191'),
('2443', '1189', 'customer', 'general', '1191'),
('2444', '1190', 'cust_branch', 'general', '1192'),
('2445', '1190', 'customer', 'general', '1192'),
('2446', '1191', 'cust_branch', 'general', '1193'),
('2447', '1191', 'customer', 'general', '1193'),
('2448', '1192', 'cust_branch', 'general', '1194'),
('2449', '1192', 'customer', 'general', '1194'),
('2450', '1193', 'cust_branch', 'general', '1195'),
('2451', '1193', 'customer', 'general', '1195'),
('2452', '1194', 'cust_branch', 'general', '1196'),
('2453', '1194', 'customer', 'general', '1196'),
('2454', '1195', 'cust_branch', 'general', '1197'),
('2455', '1195', 'customer', 'general', '1197'),
('2456', '1196', 'cust_branch', 'general', '1198'),
('2457', '1196', 'customer', 'general', '1198'),
('2458', '1197', 'cust_branch', 'general', '1199'),
('2459', '1197', 'customer', 'general', '1199'),
('2460', '1198', 'cust_branch', 'general', '1200'),
('2461', '1198', 'customer', 'general', '1200'),
('2462', '1199', 'cust_branch', 'general', '1201'),
('2463', '1199', 'customer', 'general', '1201'),
('2464', '1200', 'cust_branch', 'general', '1202'),
('2465', '1200', 'customer', 'general', '1202'),
('2466', '1201', 'cust_branch', 'general', '1203'),
('2467', '1201', 'customer', 'general', '1203'),
('2468', '1202', 'cust_branch', 'general', '1204'),
('2469', '1202', 'customer', 'general', '1204'),
('2470', '1203', 'cust_branch', 'general', '1205'),
('2471', '1203', 'customer', 'general', '1205'),
('2472', '1204', 'cust_branch', 'general', '1206'),
('2473', '1204', 'customer', 'general', '1206'),
('2474', '1205', 'cust_branch', 'general', '1207'),
('2475', '1205', 'customer', 'general', '1207'),
('2476', '1206', 'cust_branch', 'general', '1208'),
('2477', '1206', 'customer', 'general', '1208'),
('2478', '1207', 'cust_branch', 'general', '1209'),
('2479', '1207', 'customer', 'general', '1209'),
('2480', '1208', 'cust_branch', 'general', '1210'),
('2481', '1208', 'customer', 'general', '1210'),
('2482', '1209', 'cust_branch', 'general', '1211'),
('2483', '1209', 'customer', 'general', '1211'),
('2484', '1210', 'cust_branch', 'general', '1212'),
('2485', '1210', 'customer', 'general', '1212'),
('2486', '1211', 'cust_branch', 'general', '1213'),
('2487', '1211', 'customer', 'general', '1213'),
('2488', '1212', 'cust_branch', 'general', '1214'),
('2489', '1212', 'customer', 'general', '1214'),
('2490', '1213', 'cust_branch', 'general', '1215'),
('2491', '1213', 'customer', 'general', '1215'),
('2492', '1214', 'cust_branch', 'general', '1216'),
('2493', '1214', 'customer', 'general', '1216'),
('2494', '1215', 'cust_branch', 'general', '1217'),
('2495', '1215', 'customer', 'general', '1217'),
('2496', '1216', 'cust_branch', 'general', '1218'),
('2497', '1216', 'customer', 'general', '1218'),
('2498', '1217', 'cust_branch', 'general', '1219'),
('2499', '1217', 'customer', 'general', '1219'),
('2500', '1218', 'cust_branch', 'general', '1220'),
('2501', '1218', 'customer', 'general', '1220'),
('2502', '1219', 'cust_branch', 'general', '1221'),
('2503', '1219', 'customer', 'general', '1221'),
('2504', '1220', 'cust_branch', 'general', '1222'),
('2505', '1220', 'customer', 'general', '1222'),
('2506', '1221', 'cust_branch', 'general', '1223'),
('2507', '1221', 'customer', 'general', '1223'),
('2508', '1222', 'cust_branch', 'general', '1224'),
('2509', '1222', 'customer', 'general', '1224'),
('2510', '1223', 'cust_branch', 'general', '1225'),
('2511', '1223', 'customer', 'general', '1225'),
('2512', '1224', 'cust_branch', 'general', '1226'),
('2513', '1224', 'customer', 'general', '1226'),
('2514', '1225', 'cust_branch', 'general', '1227'),
('2515', '1225', 'customer', 'general', '1227'),
('2516', '1226', 'cust_branch', 'general', '1228'),
('2517', '1226', 'customer', 'general', '1228'),
('2518', '1227', 'cust_branch', 'general', '1229'),
('2519', '1227', 'customer', 'general', '1229'),
('2520', '1228', 'cust_branch', 'general', '1230'),
('2521', '1228', 'customer', 'general', '1230'),
('2522', '1229', 'cust_branch', 'general', '1231'),
('2523', '1229', 'customer', 'general', '1231'),
('2524', '1230', 'cust_branch', 'general', '1232'),
('2525', '1230', 'customer', 'general', '1232'),
('2526', '1231', 'cust_branch', 'general', '1233'),
('2527', '1231', 'customer', 'general', '1233'),
('2528', '1232', 'cust_branch', 'general', '1234'),
('2529', '1232', 'customer', 'general', '1234'),
('2530', '1233', 'cust_branch', 'general', '1235'),
('2531', '1233', 'customer', 'general', '1235'),
('2532', '1234', 'cust_branch', 'general', '1236'),
('2533', '1234', 'customer', 'general', '1236'),
('2534', '1235', 'cust_branch', 'general', '1237'),
('2535', '1235', 'customer', 'general', '1237'),
('2536', '1236', 'cust_branch', 'general', '1238'),
('2537', '1236', 'customer', 'general', '1238'),
('2538', '1237', 'cust_branch', 'general', '1239'),
('2539', '1237', 'customer', 'general', '1239'),
('2540', '1238', 'cust_branch', 'general', '1240'),
('2541', '1238', 'customer', 'general', '1240'),
('2542', '1239', 'cust_branch', 'general', '1241'),
('2543', '1239', 'customer', 'general', '1241'),
('2544', '1240', 'cust_branch', 'general', '1242'),
('2545', '1240', 'customer', 'general', '1242'),
('2546', '1241', 'cust_branch', 'general', '1243'),
('2547', '1241', 'customer', 'general', '1243'),
('2548', '1242', 'cust_branch', 'general', '1244'),
('2549', '1242', 'customer', 'general', '1244'),
('2550', '1243', 'cust_branch', 'general', '1245'),
('2551', '1243', 'customer', 'general', '1245'),
('2552', '1244', 'cust_branch', 'general', '1246'),
('2553', '1244', 'customer', 'general', '1246'),
('2554', '1245', 'cust_branch', 'general', '1247'),
('2555', '1245', 'customer', 'general', '1247'),
('2556', '1246', 'cust_branch', 'general', '1248'),
('2557', '1246', 'customer', 'general', '1248'),
('2558', '1247', 'cust_branch', 'general', '1249'),
('2559', '1247', 'customer', 'general', '1249'),
('2560', '1248', 'cust_branch', 'general', '1250'),
('2561', '1248', 'customer', 'general', '1250'),
('2562', '1249', 'cust_branch', 'general', '1251'),
('2563', '1249', 'customer', 'general', '1251'),
('2564', '1250', 'cust_branch', 'general', '1252'),
('2565', '1250', 'customer', 'general', '1252'),
('2566', '1251', 'cust_branch', 'general', '1253'),
('2567', '1251', 'customer', 'general', '1253'),
('2568', '1252', 'cust_branch', 'general', '1254'),
('2569', '1252', 'customer', 'general', '1254'),
('2570', '1253', 'cust_branch', 'general', '1255'),
('2571', '1253', 'customer', 'general', '1255'),
('2572', '1254', 'cust_branch', 'general', '1256'),
('2573', '1254', 'customer', 'general', '1256'),
('2574', '1255', 'cust_branch', 'general', '1257'),
('2575', '1255', 'customer', 'general', '1257'),
('2576', '1256', 'cust_branch', 'general', '1258'),
('2577', '1256', 'customer', 'general', '1258'),
('2578', '1257', 'cust_branch', 'general', '1259'),
('2579', '1257', 'customer', 'general', '1259'),
('2580', '1258', 'cust_branch', 'general', '1260'),
('2581', '1258', 'customer', 'general', '1260'),
('2582', '1259', 'cust_branch', 'general', '1261'),
('2583', '1259', 'customer', 'general', '1261'),
('2584', '1260', 'cust_branch', 'general', '1262'),
('2585', '1260', 'customer', 'general', '1262'),
('2586', '1261', 'cust_branch', 'general', '1263'),
('2587', '1261', 'customer', 'general', '1263'),
('2588', '1262', 'cust_branch', 'general', '1264'),
('2589', '1262', 'customer', 'general', '1264'),
('2590', '1263', 'cust_branch', 'general', '1265'),
('2591', '1263', 'customer', 'general', '1265'),
('2592', '1264', 'cust_branch', 'general', '1266'),
('2593', '1264', 'customer', 'general', '1266'),
('2594', '1265', 'cust_branch', 'general', '1267'),
('2595', '1265', 'customer', 'general', '1267'),
('2596', '1266', 'cust_branch', 'general', '1268'),
('2597', '1266', 'customer', 'general', '1268'),
('2598', '1267', 'cust_branch', 'general', '1269'),
('2599', '1267', 'customer', 'general', '1269'),
('2600', '1268', 'cust_branch', 'general', '1270'),
('2601', '1268', 'customer', 'general', '1270'),
('2602', '1269', 'cust_branch', 'general', '1271'),
('2603', '1269', 'customer', 'general', '1271'),
('2604', '1270', 'cust_branch', 'general', '1272'),
('2605', '1270', 'customer', 'general', '1272'),
('2606', '1271', 'cust_branch', 'general', '1273'),
('2607', '1271', 'customer', 'general', '1273'),
('2608', '1272', 'cust_branch', 'general', '1274'),
('2609', '1272', 'customer', 'general', '1274'),
('2610', '1273', 'cust_branch', 'general', '1275'),
('2611', '1273', 'customer', 'general', '1275'),
('2612', '1274', 'cust_branch', 'general', '1276'),
('2613', '1274', 'customer', 'general', '1276'),
('2614', '1275', 'cust_branch', 'general', '1277'),
('2615', '1275', 'customer', 'general', '1277'),
('2616', '1276', 'cust_branch', 'general', '1278'),
('2617', '1276', 'customer', 'general', '1278'),
('2618', '1277', 'cust_branch', 'general', '1279'),
('2619', '1277', 'customer', 'general', '1279'),
('2620', '1278', 'cust_branch', 'general', '1280'),
('2621', '1278', 'customer', 'general', '1280'),
('2622', '1279', 'cust_branch', 'general', '1281'),
('2623', '1279', 'customer', 'general', '1281'),
('2624', '1280', 'cust_branch', 'general', '1282'),
('2625', '1280', 'customer', 'general', '1282'),
('2626', '1281', 'cust_branch', 'general', '1283'),
('2627', '1281', 'customer', 'general', '1283'),
('2628', '1282', 'cust_branch', 'general', '1284'),
('2629', '1282', 'customer', 'general', '1284'),
('2630', '1283', 'cust_branch', 'general', '1285'),
('2631', '1283', 'customer', 'general', '1285'),
('2632', '1284', 'cust_branch', 'general', '1286'),
('2633', '1284', 'customer', 'general', '1286'),
('2634', '1285', 'cust_branch', 'general', '1287'),
('2635', '1285', 'customer', 'general', '1287'),
('2636', '1286', 'cust_branch', 'general', '1288'),
('2637', '1286', 'customer', 'general', '1288'),
('2638', '1287', 'cust_branch', 'general', '1289'),
('2639', '1287', 'customer', 'general', '1289'),
('2640', '1288', 'cust_branch', 'general', '1290'),
('2641', '1288', 'customer', 'general', '1290'),
('2642', '1289', 'cust_branch', 'general', '1291'),
('2643', '1289', 'customer', 'general', '1291'),
('2644', '1290', 'cust_branch', 'general', '1292'),
('2645', '1290', 'customer', 'general', '1292'),
('2646', '1291', 'cust_branch', 'general', '1293'),
('2647', '1291', 'customer', 'general', '1293'),
('2648', '1292', 'cust_branch', 'general', '1294'),
('2649', '1292', 'customer', 'general', '1294'),
('2650', '1293', 'cust_branch', 'general', '1295'),
('2651', '1293', 'customer', 'general', '1295'),
('2652', '1294', 'cust_branch', 'general', '1296'),
('2653', '1294', 'customer', 'general', '1296'),
('2654', '1295', 'cust_branch', 'general', '1297'),
('2655', '1295', 'customer', 'general', '1297'),
('2656', '1296', 'cust_branch', 'general', '1298'),
('2657', '1296', 'customer', 'general', '1298'),
('2658', '1297', 'cust_branch', 'general', '1299'),
('2659', '1297', 'customer', 'general', '1299'),
('2660', '1298', 'cust_branch', 'general', '1300'),
('2661', '1298', 'customer', 'general', '1300'),
('2662', '1299', 'cust_branch', 'general', '1301'),
('2663', '1299', 'customer', 'general', '1301'),
('2664', '1300', 'cust_branch', 'general', '1302'),
('2665', '1300', 'customer', 'general', '1302'),
('2666', '1301', 'cust_branch', 'general', '1303'),
('2667', '1301', 'customer', 'general', '1303'),
('2668', '1302', 'cust_branch', 'general', '1304'),
('2669', '1302', 'customer', 'general', '1304'),
('2670', '1303', 'cust_branch', 'general', '1305'),
('2671', '1303', 'customer', 'general', '1305'),
('2672', '1304', 'cust_branch', 'general', '1306'),
('2673', '1304', 'customer', 'general', '1306'),
('2674', '1305', 'cust_branch', 'general', '1307'),
('2675', '1305', 'customer', 'general', '1307'),
('2676', '1306', 'cust_branch', 'general', '1308'),
('2677', '1306', 'customer', 'general', '1308'),
('2678', '1307', 'cust_branch', 'general', '1309'),
('2679', '1307', 'customer', 'general', '1309'),
('2680', '1308', 'cust_branch', 'general', '1310'),
('2681', '1308', 'customer', 'general', '1310'),
('2682', '1309', 'cust_branch', 'general', '1311'),
('2683', '1309', 'customer', 'general', '1311'),
('2684', '1310', 'cust_branch', 'general', '1312'),
('2685', '1310', 'customer', 'general', '1312'),
('2686', '1311', 'cust_branch', 'general', '1313'),
('2687', '1311', 'customer', 'general', '1313'),
('2688', '1312', 'cust_branch', 'general', '1314'),
('2689', '1312', 'customer', 'general', '1314'),
('2690', '1313', 'cust_branch', 'general', '1315'),
('2691', '1313', 'customer', 'general', '1315'),
('2692', '1314', 'cust_branch', 'general', '1316'),
('2693', '1314', 'customer', 'general', '1316'),
('2694', '1315', 'cust_branch', 'general', '1317'),
('2695', '1315', 'customer', 'general', '1317'),
('2696', '1316', 'cust_branch', 'general', '1318'),
('2697', '1316', 'customer', 'general', '1318'),
('2698', '1317', 'cust_branch', 'general', '1319'),
('2699', '1317', 'customer', 'general', '1319'),
('2700', '1318', 'cust_branch', 'general', '1320'),
('2701', '1318', 'customer', 'general', '1320'),
('2702', '1319', 'cust_branch', 'general', '1321'),
('2703', '1319', 'customer', 'general', '1321'),
('2704', '1320', 'cust_branch', 'general', '1322'),
('2705', '1320', 'customer', 'general', '1322'),
('2706', '1321', 'cust_branch', 'general', '1323'),
('2707', '1321', 'customer', 'general', '1323'),
('2708', '1322', 'cust_branch', 'general', '1324'),
('2709', '1322', 'customer', 'general', '1324'),
('2710', '1323', 'cust_branch', 'general', '1325'),
('2711', '1323', 'customer', 'general', '1325'),
('2712', '1324', 'cust_branch', 'general', '1326'),
('2713', '1324', 'customer', 'general', '1326'),
('2714', '1325', 'cust_branch', 'general', '1327'),
('2715', '1325', 'customer', 'general', '1327'),
('2716', '1326', 'cust_branch', 'general', '1328'),
('2717', '1326', 'customer', 'general', '1328'),
('2718', '1327', 'cust_branch', 'general', '1329'),
('2719', '1327', 'customer', 'general', '1329'),
('2720', '1328', 'cust_branch', 'general', '1330'),
('2721', '1328', 'customer', 'general', '1330'),
('2722', '1329', 'cust_branch', 'general', '1331'),
('2723', '1329', 'customer', 'general', '1331'),
('2724', '1330', 'cust_branch', 'general', '1332'),
('2725', '1330', 'customer', 'general', '1332'),
('2726', '1331', 'cust_branch', 'general', '1333'),
('2727', '1331', 'customer', 'general', '1333'),
('2728', '1332', 'cust_branch', 'general', '1334'),
('2729', '1332', 'customer', 'general', '1334'),
('2730', '1333', 'cust_branch', 'general', '1335'),
('2731', '1333', 'customer', 'general', '1335'),
('2732', '1334', 'cust_branch', 'general', '1336'),
('2733', '1334', 'customer', 'general', '1336'),
('2734', '1335', 'cust_branch', 'general', '1337'),
('2735', '1335', 'customer', 'general', '1337'),
('2736', '1336', 'cust_branch', 'general', '1338'),
('2737', '1336', 'customer', 'general', '1338'),
('2738', '1337', 'cust_branch', 'general', '1339'),
('2739', '1337', 'customer', 'general', '1339'),
('2740', '1338', 'cust_branch', 'general', '1340'),
('2741', '1338', 'customer', 'general', '1340'),
('2742', '1339', 'cust_branch', 'general', '1341'),
('2743', '1339', 'customer', 'general', '1341'),
('2744', '1340', 'cust_branch', 'general', '1342'),
('2745', '1340', 'customer', 'general', '1342'),
('2746', '1341', 'cust_branch', 'general', '1343'),
('2747', '1341', 'customer', 'general', '1343'),
('2748', '1342', 'cust_branch', 'general', '1344'),
('2749', '1342', 'customer', 'general', '1344'),
('2750', '1343', 'cust_branch', 'general', '1345'),
('2751', '1343', 'customer', 'general', '1345'),
('2752', '1344', 'cust_branch', 'general', '1346'),
('2753', '1344', 'customer', 'general', '1346'),
('2754', '1345', 'cust_branch', 'general', '1347'),
('2755', '1345', 'customer', 'general', '1347'),
('2756', '1346', 'cust_branch', 'general', '1348'),
('2757', '1346', 'customer', 'general', '1348'),
('2758', '1347', 'cust_branch', 'general', '1349'),
('2759', '1347', 'customer', 'general', '1349'),
('2760', '1348', 'cust_branch', 'general', '1350'),
('2761', '1348', 'customer', 'general', '1350'),
('2762', '1349', 'cust_branch', 'general', '1351'),
('2763', '1349', 'customer', 'general', '1351'),
('2764', '1350', 'cust_branch', 'general', '1352'),
('2765', '1350', 'customer', 'general', '1352'),
('2766', '1351', 'cust_branch', 'general', '1353'),
('2767', '1351', 'customer', 'general', '1353'),
('2768', '1352', 'cust_branch', 'general', '1354'),
('2769', '1352', 'customer', 'general', '1354'),
('2770', '1353', 'cust_branch', 'general', '1355'),
('2771', '1353', 'customer', 'general', '1355'),
('2772', '1354', 'cust_branch', 'general', '1356'),
('2773', '1354', 'customer', 'general', '1356'),
('2774', '1355', 'cust_branch', 'general', '1357'),
('2775', '1355', 'customer', 'general', '1357'),
('2776', '1356', 'cust_branch', 'general', '1358'),
('2777', '1356', 'customer', 'general', '1358'),
('2778', '1357', 'cust_branch', 'general', '1359'),
('2779', '1357', 'customer', 'general', '1359'),
('2780', '1358', 'cust_branch', 'general', '1360'),
('2781', '1358', 'customer', 'general', '1360'),
('2782', '1359', 'cust_branch', 'general', '1361'),
('2783', '1359', 'customer', 'general', '1361'),
('2784', '1360', 'cust_branch', 'general', '1362'),
('2785', '1360', 'customer', 'general', '1362'),
('2786', '1361', 'cust_branch', 'general', '1363'),
('2787', '1361', 'customer', 'general', '1363'),
('2788', '1362', 'cust_branch', 'general', '1364'),
('2789', '1362', 'customer', 'general', '1364'),
('2790', '1363', 'cust_branch', 'general', '1365'),
('2791', '1363', 'customer', 'general', '1365'),
('2792', '1364', 'cust_branch', 'general', '1366'),
('2793', '1364', 'customer', 'general', '1366'),
('2794', '1365', 'cust_branch', 'general', '1367'),
('2795', '1365', 'customer', 'general', '1367'),
('2796', '1366', 'cust_branch', 'general', '1368'),
('2797', '1366', 'customer', 'general', '1368'),
('2798', '1367', 'cust_branch', 'general', '1369'),
('2799', '1367', 'customer', 'general', '1369'),
('2800', '1368', 'cust_branch', 'general', '1370'),
('2801', '1368', 'customer', 'general', '1370'),
('2802', '1369', 'cust_branch', 'general', '1371'),
('2803', '1369', 'customer', 'general', '1371'),
('2804', '1370', 'cust_branch', 'general', '1372'),
('2805', '1370', 'customer', 'general', '1372'),
('2806', '1371', 'cust_branch', 'general', '1373'),
('2807', '1371', 'customer', 'general', '1373'),
('2808', '1372', 'cust_branch', 'general', '1374'),
('2809', '1372', 'customer', 'general', '1374'),
('2810', '1373', 'cust_branch', 'general', '1375'),
('2811', '1373', 'customer', 'general', '1375'),
('2812', '1374', 'cust_branch', 'general', '1376'),
('2813', '1374', 'customer', 'general', '1376'),
('2814', '1375', 'cust_branch', 'general', '1377'),
('2815', '1375', 'customer', 'general', '1377'),
('2816', '1376', 'cust_branch', 'general', '1378'),
('2817', '1376', 'customer', 'general', '1378'),
('2818', '1377', 'cust_branch', 'general', '1379'),
('2819', '1377', 'customer', 'general', '1379'),
('2820', '1378', 'cust_branch', 'general', '1380'),
('2821', '1378', 'customer', 'general', '1380'),
('2822', '1379', 'cust_branch', 'general', '1381'),
('2823', '1379', 'customer', 'general', '1381'),
('2824', '1380', 'cust_branch', 'general', '1382'),
('2825', '1380', 'customer', 'general', '1382'),
('2826', '1381', 'cust_branch', 'general', '1383'),
('2827', '1381', 'customer', 'general', '1383'),
('2828', '1382', 'cust_branch', 'general', '1384'),
('2829', '1382', 'customer', 'general', '1384'),
('2830', '1383', 'cust_branch', 'general', '1385'),
('2831', '1383', 'customer', 'general', '1385'),
('2832', '1384', 'cust_branch', 'general', '1386'),
('2833', '1384', 'customer', 'general', '1386'),
('2834', '1385', 'cust_branch', 'general', '1387'),
('2835', '1385', 'customer', 'general', '1387'),
('2836', '1386', 'cust_branch', 'general', '1388'),
('2837', '1386', 'customer', 'general', '1388'),
('2838', '1387', 'cust_branch', 'general', '1389'),
('2839', '1387', 'customer', 'general', '1389'),
('2840', '1388', 'cust_branch', 'general', '1390'),
('2841', '1388', 'customer', 'general', '1390'),
('2842', '1389', 'cust_branch', 'general', '1391'),
('2843', '1389', 'customer', 'general', '1391'),
('2844', '1390', 'cust_branch', 'general', '1392'),
('2845', '1390', 'customer', 'general', '1392'),
('2846', '1391', 'cust_branch', 'general', '1393'),
('2847', '1391', 'customer', 'general', '1393'),
('2848', '1392', 'cust_branch', 'general', '1394'),
('2849', '1392', 'customer', 'general', '1394'),
('2850', '1393', 'cust_branch', 'general', '1395'),
('2851', '1393', 'customer', 'general', '1395'),
('2852', '1394', 'cust_branch', 'general', '1396'),
('2853', '1394', 'customer', 'general', '1396'),
('2854', '1395', 'cust_branch', 'general', '1397'),
('2855', '1395', 'customer', 'general', '1397'),
('2856', '1396', 'cust_branch', 'general', '1398'),
('2857', '1396', 'customer', 'general', '1398'),
('2858', '1397', 'cust_branch', 'general', '1399'),
('2859', '1397', 'customer', 'general', '1399'),
('2860', '1398', 'cust_branch', 'general', '1400'),
('2861', '1398', 'customer', 'general', '1400'),
('2862', '1399', 'cust_branch', 'general', '1401'),
('2863', '1399', 'customer', 'general', '1401'),
('2864', '1400', 'cust_branch', 'general', '1402'),
('2865', '1400', 'customer', 'general', '1402'),
('2866', '1401', 'cust_branch', 'general', '1403'),
('2867', '1401', 'customer', 'general', '1403'),
('2868', '1402', 'cust_branch', 'general', '1404'),
('2869', '1402', 'customer', 'general', '1404'),
('2870', '1403', 'cust_branch', 'general', '1405'),
('2871', '1403', 'customer', 'general', '1405'),
('2872', '1404', 'cust_branch', 'general', '1406'),
('2873', '1404', 'customer', 'general', '1406'),
('2874', '1405', 'cust_branch', 'general', '1407'),
('2875', '1405', 'customer', 'general', '1407'),
('2876', '1406', 'cust_branch', 'general', '1408'),
('2877', '1406', 'customer', 'general', '1408'),
('2878', '1407', 'cust_branch', 'general', '1409'),
('2879', '1407', 'customer', 'general', '1409'),
('2880', '1408', 'cust_branch', 'general', '1410'),
('2881', '1408', 'customer', 'general', '1410'),
('2882', '1409', 'cust_branch', 'general', '1411'),
('2883', '1409', 'customer', 'general', '1411'),
('2884', '1410', 'cust_branch', 'general', '1412'),
('2885', '1410', 'customer', 'general', '1412'),
('2886', '1411', 'cust_branch', 'general', '1413'),
('2887', '1411', 'customer', 'general', '1413'),
('2888', '1412', 'cust_branch', 'general', '1414'),
('2889', '1412', 'customer', 'general', '1414'),
('2890', '1413', 'cust_branch', 'general', '1415'),
('2891', '1413', 'customer', 'general', '1415'),
('2892', '1414', 'cust_branch', 'general', '1416'),
('2893', '1414', 'customer', 'general', '1416'),
('2894', '1415', 'cust_branch', 'general', '1417'),
('2895', '1415', 'customer', 'general', '1417'),
('2896', '1416', 'cust_branch', 'general', '1418'),
('2897', '1416', 'customer', 'general', '1418'),
('2898', '1417', 'cust_branch', 'general', '1419'),
('2899', '1417', 'customer', 'general', '1419'),
('2900', '1418', 'cust_branch', 'general', '1420'),
('2901', '1418', 'customer', 'general', '1420'),
('2902', '1419', 'cust_branch', 'general', '1421'),
('2903', '1419', 'customer', 'general', '1421'),
('2904', '1420', 'cust_branch', 'general', '1422'),
('2905', '1420', 'customer', 'general', '1422'),
('2906', '1421', 'cust_branch', 'general', '1423'),
('2907', '1421', 'customer', 'general', '1423'),
('2908', '1422', 'cust_branch', 'general', '1424'),
('2909', '1422', 'customer', 'general', '1424'),
('2910', '1423', 'cust_branch', 'general', '1425'),
('2911', '1423', 'customer', 'general', '1425'),
('2912', '1424', 'cust_branch', 'general', '1426'),
('2913', '1424', 'customer', 'general', '1426'),
('2914', '1425', 'cust_branch', 'general', '1427'),
('2915', '1425', 'customer', 'general', '1427'),
('2916', '1426', 'cust_branch', 'general', '1428'),
('2917', '1426', 'customer', 'general', '1428'),
('2918', '1427', 'cust_branch', 'general', '1429'),
('2919', '1427', 'customer', 'general', '1429'),
('2920', '1428', 'cust_branch', 'general', '1430'),
('2921', '1428', 'customer', 'general', '1430'),
('2922', '1429', 'cust_branch', 'general', '1431'),
('2923', '1429', 'customer', 'general', '1431'),
('2924', '1430', 'cust_branch', 'general', '1432'),
('2925', '1430', 'customer', 'general', '1432'),
('2926', '1431', 'cust_branch', 'general', '1433'),
('2927', '1431', 'customer', 'general', '1433'),
('2928', '1432', 'cust_branch', 'general', '1434'),
('2929', '1432', 'customer', 'general', '1434'),
('2930', '1433', 'cust_branch', 'general', '1435'),
('2931', '1433', 'customer', 'general', '1435'),
('2932', '1434', 'cust_branch', 'general', '1436'),
('2933', '1434', 'customer', 'general', '1436'),
('2934', '1435', 'cust_branch', 'general', '1437'),
('2935', '1435', 'customer', 'general', '1437'),
('2936', '1436', 'cust_branch', 'general', '1438'),
('2937', '1436', 'customer', 'general', '1438'),
('2938', '1437', 'cust_branch', 'general', '1439'),
('2939', '1437', 'customer', 'general', '1439'),
('2940', '1438', 'cust_branch', 'general', '1440'),
('2941', '1438', 'customer', 'general', '1440'),
('2942', '1439', 'cust_branch', 'general', '1441'),
('2943', '1439', 'customer', 'general', '1441'),
('2944', '1440', 'cust_branch', 'general', '1442'),
('2945', '1440', 'customer', 'general', '1442'),
('2946', '1441', 'cust_branch', 'general', '1443'),
('2947', '1441', 'customer', 'general', '1443'),
('2948', '1442', 'cust_branch', 'general', '1444'),
('2949', '1442', 'customer', 'general', '1444'),
('2950', '1443', 'cust_branch', 'general', '1445'),
('2951', '1443', 'customer', 'general', '1445'),
('2952', '1444', 'cust_branch', 'general', '1446'),
('2953', '1444', 'customer', 'general', '1446'),
('2954', '1445', 'cust_branch', 'general', '1447'),
('2955', '1445', 'customer', 'general', '1447'),
('2956', '1446', 'cust_branch', 'general', '1448'),
('2957', '1446', 'customer', 'general', '1448'),
('2958', '1447', 'cust_branch', 'general', '1449'),
('2959', '1447', 'customer', 'general', '1449'),
('2960', '1448', 'cust_branch', 'general', '1450'),
('2961', '1448', 'customer', 'general', '1450'),
('2962', '1449', 'cust_branch', 'general', '1451'),
('2963', '1449', 'customer', 'general', '1451'),
('2964', '1450', 'cust_branch', 'general', '1452'),
('2965', '1450', 'customer', 'general', '1452'),
('2966', '1451', 'cust_branch', 'general', '1453'),
('2967', '1451', 'customer', 'general', '1453'),
('2968', '1452', 'cust_branch', 'general', '1454'),
('2969', '1452', 'customer', 'general', '1454'),
('2970', '1453', 'cust_branch', 'general', '1455'),
('2971', '1453', 'customer', 'general', '1455'),
('2972', '1454', 'cust_branch', 'general', '1456'),
('2973', '1454', 'customer', 'general', '1456'),
('2974', '1455', 'cust_branch', 'general', '1457'),
('2975', '1455', 'customer', 'general', '1457'),
('2976', '1456', 'cust_branch', 'general', '1458'),
('2977', '1456', 'customer', 'general', '1458'),
('2978', '1457', 'cust_branch', 'general', '1459'),
('2979', '1457', 'customer', 'general', '1459'),
('2980', '1458', 'cust_branch', 'general', '1460'),
('2981', '1458', 'customer', 'general', '1460'),
('2982', '1459', 'cust_branch', 'general', '1461'),
('2983', '1459', 'customer', 'general', '1461'),
('2984', '1460', 'cust_branch', 'general', '1462'),
('2985', '1460', 'customer', 'general', '1462'),
('2986', '1461', 'cust_branch', 'general', '1463'),
('2987', '1461', 'customer', 'general', '1463'),
('2988', '1462', 'cust_branch', 'general', '1464'),
('2989', '1462', 'customer', 'general', '1464'),
('2990', '1463', 'cust_branch', 'general', '1465'),
('2991', '1463', 'customer', 'general', '1465'),
('2992', '1464', 'cust_branch', 'general', '1466'),
('2993', '1464', 'customer', 'general', '1466'),
('2994', '1465', 'cust_branch', 'general', '1467'),
('2995', '1465', 'customer', 'general', '1467'),
('2996', '1466', 'cust_branch', 'general', '1468'),
('2997', '1466', 'customer', 'general', '1468'),
('2998', '1467', 'cust_branch', 'general', '1469'),
('2999', '1467', 'customer', 'general', '1469'),
('3000', '1468', 'cust_branch', 'general', '1470'),
('3001', '1468', 'customer', 'general', '1470'),
('3002', '1469', 'cust_branch', 'general', '1471'),
('3003', '1469', 'customer', 'general', '1471'),
('3004', '1470', 'cust_branch', 'general', '1472'),
('3005', '1470', 'customer', 'general', '1472'),
('3006', '1471', 'cust_branch', 'general', '1473'),
('3007', '1471', 'customer', 'general', '1473'),
('3008', '1472', 'cust_branch', 'general', '1474'),
('3009', '1472', 'customer', 'general', '1474'),
('3010', '1473', 'cust_branch', 'general', '1475'),
('3011', '1473', 'customer', 'general', '1475'),
('3012', '1474', 'cust_branch', 'general', '1476'),
('3013', '1474', 'customer', 'general', '1476'),
('3014', '1475', 'cust_branch', 'general', '1477'),
('3015', '1475', 'customer', 'general', '1477'),
('3016', '1476', 'cust_branch', 'general', '1478'),
('3017', '1476', 'customer', 'general', '1478'),
('3018', '1477', 'cust_branch', 'general', '1479'),
('3019', '1477', 'customer', 'general', '1479'),
('3020', '1478', 'cust_branch', 'general', '1480'),
('3021', '1478', 'customer', 'general', '1480'),
('3022', '1479', 'cust_branch', 'general', '1481'),
('3023', '1479', 'customer', 'general', '1481'),
('3024', '1480', 'cust_branch', 'general', '1482'),
('3025', '1480', 'customer', 'general', '1482'),
('3026', '1481', 'cust_branch', 'general', '1483'),
('3027', '1481', 'customer', 'general', '1483'),
('3028', '1482', 'cust_branch', 'general', '1484'),
('3029', '1482', 'customer', 'general', '1484'),
('3030', '1483', 'cust_branch', 'general', '1485'),
('3031', '1483', 'customer', 'general', '1485'),
('3032', '1484', 'cust_branch', 'general', '1486'),
('3033', '1484', 'customer', 'general', '1486'),
('3034', '1485', 'cust_branch', 'general', '1487'),
('3035', '1485', 'customer', 'general', '1487'),
('3036', '1486', 'cust_branch', 'general', '1488'),
('3037', '1486', 'customer', 'general', '1488'),
('3038', '1487', 'cust_branch', 'general', '1489'),
('3039', '1487', 'customer', 'general', '1489'),
('3040', '1488', 'cust_branch', 'general', '1490'),
('3041', '1488', 'customer', 'general', '1490'),
('3042', '1489', 'cust_branch', 'general', '1491'),
('3043', '1489', 'customer', 'general', '1491'),
('3044', '1490', 'cust_branch', 'general', '1492'),
('3045', '1490', 'customer', 'general', '1492'),
('3046', '1491', 'cust_branch', 'general', '1493'),
('3047', '1491', 'customer', 'general', '1493'),
('3048', '1492', 'cust_branch', 'general', '1494'),
('3049', '1492', 'customer', 'general', '1494'),
('3050', '1493', 'cust_branch', 'general', '1495'),
('3051', '1493', 'customer', 'general', '1495'),
('3052', '1494', 'cust_branch', 'general', '1496'),
('3053', '1494', 'customer', 'general', '1496'),
('3054', '1495', 'cust_branch', 'general', '1497'),
('3055', '1495', 'customer', 'general', '1497'),
('3056', '1496', 'cust_branch', 'general', '1498'),
('3057', '1496', 'customer', 'general', '1498'),
('3058', '1497', 'cust_branch', 'general', '1499'),
('3059', '1497', 'customer', 'general', '1499'),
('3060', '1498', 'cust_branch', 'general', '1500'),
('3061', '1498', 'customer', 'general', '1500'),
('3062', '1499', 'cust_branch', 'general', '1501'),
('3063', '1499', 'customer', 'general', '1501'),
('3064', '1500', 'cust_branch', 'general', '1502'),
('3065', '1500', 'customer', 'general', '1502'),
('3066', '1501', 'cust_branch', 'general', '1503'),
('3067', '1501', 'customer', 'general', '1503'),
('3068', '1502', 'cust_branch', 'general', '1504'),
('3069', '1502', 'customer', 'general', '1504'),
('3070', '1503', 'cust_branch', 'general', '1505'),
('3071', '1503', 'customer', 'general', '1505'),
('3072', '1504', 'cust_branch', 'general', '1506'),
('3073', '1504', 'customer', 'general', '1506'),
('3074', '1505', 'cust_branch', 'general', '1507'),
('3075', '1505', 'customer', 'general', '1507'),
('3076', '1506', 'cust_branch', 'general', '1508'),
('3077', '1506', 'customer', 'general', '1508'),
('3078', '1507', 'cust_branch', 'general', '1509'),
('3079', '1507', 'customer', 'general', '1509'),
('3080', '1508', 'cust_branch', 'general', '1510'),
('3081', '1508', 'customer', 'general', '1510'),
('3082', '1509', 'cust_branch', 'general', '1511'),
('3083', '1509', 'customer', 'general', '1511'),
('3084', '1510', 'cust_branch', 'general', '1512'),
('3085', '1510', 'customer', 'general', '1512'),
('3086', '1511', 'cust_branch', 'general', '1513'),
('3087', '1511', 'customer', 'general', '1513'),
('3088', '1512', 'cust_branch', 'general', '1514'),
('3089', '1512', 'customer', 'general', '1514'),
('3090', '1513', 'cust_branch', 'general', '1515'),
('3091', '1513', 'customer', 'general', '1515'),
('3092', '1514', 'cust_branch', 'general', '1516'),
('3093', '1514', 'customer', 'general', '1516'),
('3094', '1515', 'cust_branch', 'general', '1517'),
('3095', '1515', 'customer', 'general', '1517'),
('3096', '1516', 'cust_branch', 'general', '1518'),
('3097', '1516', 'customer', 'general', '1518'),
('3098', '1517', 'cust_branch', 'general', '1519'),
('3099', '1517', 'customer', 'general', '1519'),
('3100', '1518', 'cust_branch', 'general', '1520'),
('3101', '1518', 'customer', 'general', '1520'),
('3102', '1519', 'cust_branch', 'general', '1521'),
('3103', '1519', 'customer', 'general', '1521'),
('3104', '1520', 'cust_branch', 'general', '1522'),
('3105', '1520', 'customer', 'general', '1522'),
('3106', '1521', 'cust_branch', 'general', '1523'),
('3107', '1521', 'customer', 'general', '1523'),
('3108', '1522', 'cust_branch', 'general', '1524'),
('3109', '1522', 'customer', 'general', '1524'),
('3110', '1523', 'cust_branch', 'general', '1525'),
('3111', '1523', 'customer', 'general', '1525'),
('3112', '1524', 'cust_branch', 'general', '1526'),
('3113', '1524', 'customer', 'general', '1526'),
('3114', '1525', 'cust_branch', 'general', '1527'),
('3115', '1525', 'customer', 'general', '1527'),
('3116', '1526', 'cust_branch', 'general', '1528'),
('3117', '1526', 'customer', 'general', '1528'),
('3118', '1527', 'cust_branch', 'general', '1529'),
('3119', '1527', 'customer', 'general', '1529'),
('3120', '1528', 'cust_branch', 'general', '1530'),
('3121', '1528', 'customer', 'general', '1530'),
('3122', '1529', 'cust_branch', 'general', '1531'),
('3123', '1529', 'customer', 'general', '1531'),
('3124', '1530', 'cust_branch', 'general', '1532'),
('3125', '1530', 'customer', 'general', '1532'),
('3126', '1531', 'cust_branch', 'general', '1533'),
('3127', '1531', 'customer', 'general', '1533'),
('3128', '1532', 'cust_branch', 'general', '1534'),
('3129', '1532', 'customer', 'general', '1534'),
('3130', '1533', 'cust_branch', 'general', '1535'),
('3131', '1533', 'customer', 'general', '1535'),
('3132', '1534', 'cust_branch', 'general', '1536'),
('3133', '1534', 'customer', 'general', '1536'),
('3134', '1535', 'cust_branch', 'general', '1537'),
('3135', '1535', 'customer', 'general', '1537'),
('3136', '1536', 'cust_branch', 'general', '1538'),
('3137', '1536', 'customer', 'general', '1538'),
('3138', '1537', 'cust_branch', 'general', '1539'),
('3139', '1537', 'customer', 'general', '1539'),
('3140', '1538', 'cust_branch', 'general', '1540'),
('3141', '1538', 'customer', 'general', '1540'),
('3142', '1539', 'cust_branch', 'general', '1541'),
('3143', '1539', 'customer', 'general', '1541'),
('3144', '1540', 'cust_branch', 'general', '1542'),
('3145', '1540', 'customer', 'general', '1542'),
('3146', '1541', 'cust_branch', 'general', '1543'),
('3147', '1541', 'customer', 'general', '1543'),
('3148', '1542', 'cust_branch', 'general', '1544'),
('3149', '1542', 'customer', 'general', '1544'),
('3150', '1543', 'cust_branch', 'general', '1545'),
('3151', '1543', 'customer', 'general', '1545'),
('3152', '1544', 'cust_branch', 'general', '1546'),
('3153', '1544', 'customer', 'general', '1546'),
('3154', '1545', 'cust_branch', 'general', '1547'),
('3155', '1545', 'customer', 'general', '1547'),
('3156', '1546', 'cust_branch', 'general', '1548'),
('3157', '1546', 'customer', 'general', '1548'),
('3158', '1547', 'cust_branch', 'general', '1549'),
('3159', '1547', 'customer', 'general', '1549'),
('3160', '1548', 'cust_branch', 'general', '1550'),
('3161', '1548', 'customer', 'general', '1550'),
('3162', '1549', 'cust_branch', 'general', '1551'),
('3163', '1549', 'customer', 'general', '1551'),
('3164', '1550', 'cust_branch', 'general', '1552'),
('3165', '1550', 'customer', 'general', '1552'),
('3166', '1551', 'cust_branch', 'general', '1553'),
('3167', '1551', 'customer', 'general', '1553'),
('3168', '1552', 'cust_branch', 'general', '1554'),
('3169', '1552', 'customer', 'general', '1554'),
('3170', '1553', 'cust_branch', 'general', '1555'),
('3171', '1553', 'customer', 'general', '1555'),
('3172', '1554', 'cust_branch', 'general', '1556'),
('3173', '1554', 'customer', 'general', '1556'),
('3174', '1555', 'cust_branch', 'general', '1557'),
('3175', '1555', 'customer', 'general', '1557'),
('3176', '1556', 'cust_branch', 'general', '1558'),
('3177', '1556', 'customer', 'general', '1558'),
('3178', '1557', 'cust_branch', 'general', '1559'),
('3179', '1557', 'customer', 'general', '1559'),
('3180', '1558', 'cust_branch', 'general', '1560'),
('3181', '1558', 'customer', 'general', '1560'),
('3182', '1559', 'cust_branch', 'general', '1561'),
('3183', '1559', 'customer', 'general', '1561'),
('3184', '1560', 'cust_branch', 'general', '1562'),
('3185', '1560', 'customer', 'general', '1562'),
('3186', '1561', 'cust_branch', 'general', '1563'),
('3187', '1561', 'customer', 'general', '1563'),
('3188', '1562', 'cust_branch', 'general', '1564'),
('3189', '1562', 'customer', 'general', '1564'),
('3190', '1563', 'cust_branch', 'general', '1565'),
('3191', '1563', 'customer', 'general', '1565'),
('3192', '1564', 'cust_branch', 'general', '1566'),
('3193', '1564', 'customer', 'general', '1566'),
('3194', '1565', 'cust_branch', 'general', '1567'),
('3195', '1565', 'customer', 'general', '1567'),
('3196', '1566', 'cust_branch', 'general', '1568'),
('3197', '1566', 'customer', 'general', '1568'),
('3198', '1567', 'cust_branch', 'general', '1569'),
('3199', '1567', 'customer', 'general', '1569'),
('3200', '1568', 'cust_branch', 'general', '1570'),
('3201', '1568', 'customer', 'general', '1570'),
('3202', '1569', 'cust_branch', 'general', '1571'),
('3203', '1569', 'customer', 'general', '1571'),
('3204', '1570', 'cust_branch', 'general', '1572'),
('3205', '1570', 'customer', 'general', '1572'),
('3206', '1571', 'cust_branch', 'general', '1573'),
('3207', '1571', 'customer', 'general', '1573'),
('3208', '1572', 'cust_branch', 'general', '1574'),
('3209', '1572', 'customer', 'general', '1574'),
('3210', '1573', 'cust_branch', 'general', '1575'),
('3211', '1573', 'customer', 'general', '1575'),
('3212', '1574', 'cust_branch', 'general', '1576'),
('3213', '1574', 'customer', 'general', '1576'),
('3214', '1575', 'cust_branch', 'general', '1577'),
('3215', '1575', 'customer', 'general', '1577');
INSERT INTO `0_crm_contacts` VALUES
('3216', '1576', 'cust_branch', 'general', '1578'),
('3217', '1576', 'customer', 'general', '1578'),
('3218', '1577', 'cust_branch', 'general', '1579'),
('3219', '1577', 'customer', 'general', '1579'),
('3220', '1578', 'cust_branch', 'general', '1580'),
('3221', '1578', 'customer', 'general', '1580'),
('3222', '1579', 'cust_branch', 'general', '1581'),
('3223', '1579', 'customer', 'general', '1581'),
('3224', '1580', 'cust_branch', 'general', '1582'),
('3225', '1580', 'customer', 'general', '1582'),
('3226', '1581', 'cust_branch', 'general', '1583'),
('3227', '1581', 'customer', 'general', '1583'),
('3228', '1582', 'cust_branch', 'general', '1584'),
('3229', '1582', 'customer', 'general', '1584'),
('3230', '1583', 'cust_branch', 'general', '1585'),
('3231', '1583', 'customer', 'general', '1585'),
('3232', '1584', 'cust_branch', 'general', '1586'),
('3233', '1584', 'customer', 'general', '1586'),
('3234', '1585', 'cust_branch', 'general', '1587'),
('3235', '1585', 'customer', 'general', '1587'),
('3236', '1586', 'cust_branch', 'general', '1588'),
('3237', '1586', 'customer', 'general', '1588'),
('3238', '1587', 'cust_branch', 'general', '1589'),
('3239', '1587', 'customer', 'general', '1589'),
('3240', '1588', 'cust_branch', 'general', '1590'),
('3241', '1588', 'customer', 'general', '1590'),
('3242', '1589', 'cust_branch', 'general', '1591'),
('3243', '1589', 'customer', 'general', '1591'),
('3244', '1590', 'cust_branch', 'general', '1592'),
('3245', '1590', 'customer', 'general', '1592'),
('3246', '1591', 'cust_branch', 'general', '1593'),
('3247', '1591', 'customer', 'general', '1593'),
('3248', '1592', 'cust_branch', 'general', '1594'),
('3249', '1592', 'customer', 'general', '1594'),
('3250', '1593', 'cust_branch', 'general', '1595'),
('3251', '1593', 'customer', 'general', '1595'),
('3252', '1594', 'cust_branch', 'general', '1596'),
('3253', '1594', 'customer', 'general', '1596'),
('3254', '1595', 'cust_branch', 'general', '1597'),
('3255', '1595', 'customer', 'general', '1597'),
('3256', '1596', 'cust_branch', 'general', '1598'),
('3257', '1596', 'customer', 'general', '1598'),
('3258', '1597', 'cust_branch', 'general', '1599'),
('3259', '1597', 'customer', 'general', '1599'),
('3260', '1598', 'cust_branch', 'general', '1600'),
('3261', '1598', 'customer', 'general', '1600'),
('3262', '1599', 'cust_branch', 'general', '1601'),
('3263', '1599', 'customer', 'general', '1601'),
('3264', '1600', 'cust_branch', 'general', '1602'),
('3265', '1600', 'customer', 'general', '1602'),
('3266', '1601', 'cust_branch', 'general', '1603'),
('3267', '1601', 'customer', 'general', '1603'),
('3268', '1602', 'cust_branch', 'general', '1604'),
('3269', '1602', 'customer', 'general', '1604'),
('3270', '1603', 'cust_branch', 'general', '1605'),
('3271', '1603', 'customer', 'general', '1605'),
('3272', '1604', 'cust_branch', 'general', '1606'),
('3273', '1604', 'customer', 'general', '1606'),
('3274', '1605', 'cust_branch', 'general', '1607'),
('3275', '1605', 'customer', 'general', '1607'),
('3276', '1606', 'cust_branch', 'general', '1608'),
('3277', '1606', 'customer', 'general', '1608'),
('3278', '1607', 'cust_branch', 'general', '1609'),
('3279', '1607', 'customer', 'general', '1609'),
('3280', '1608', 'cust_branch', 'general', '1610'),
('3281', '1608', 'customer', 'general', '1610'),
('3282', '1609', 'cust_branch', 'general', '1611'),
('3283', '1609', 'customer', 'general', '1611'),
('3284', '1610', 'cust_branch', 'general', '1612'),
('3285', '1610', 'customer', 'general', '1612'),
('3286', '1611', 'cust_branch', 'general', '1613'),
('3287', '1611', 'customer', 'general', '1613'),
('3288', '1612', 'cust_branch', 'general', '1614'),
('3289', '1612', 'customer', 'general', '1614'),
('3290', '1613', 'cust_branch', 'general', '1615'),
('3291', '1613', 'customer', 'general', '1615'),
('3292', '1614', 'cust_branch', 'general', '1616'),
('3293', '1614', 'customer', 'general', '1616'),
('3294', '1615', 'cust_branch', 'general', '1617'),
('3295', '1615', 'customer', 'general', '1617'),
('3296', '1616', 'cust_branch', 'general', '1618'),
('3297', '1616', 'customer', 'general', '1618'),
('3298', '1617', 'cust_branch', 'general', '1619'),
('3299', '1617', 'customer', 'general', '1619'),
('3300', '1618', 'cust_branch', 'general', '1620'),
('3301', '1618', 'customer', 'general', '1620'),
('3302', '1619', 'cust_branch', 'general', '1621'),
('3303', '1619', 'customer', 'general', '1621'),
('3304', '1620', 'cust_branch', 'general', '1622'),
('3305', '1620', 'customer', 'general', '1622'),
('3306', '1621', 'cust_branch', 'general', '1623'),
('3307', '1621', 'customer', 'general', '1623'),
('3308', '1622', 'cust_branch', 'general', '1624'),
('3309', '1622', 'customer', 'general', '1624'),
('3310', '1623', 'cust_branch', 'general', '1625'),
('3311', '1623', 'customer', 'general', '1625'),
('3312', '1624', 'cust_branch', 'general', '1626'),
('3313', '1624', 'customer', 'general', '1626'),
('3314', '1625', 'cust_branch', 'general', '1627'),
('3315', '1625', 'customer', 'general', '1627'),
('3316', '1626', 'cust_branch', 'general', '1628'),
('3317', '1626', 'customer', 'general', '1628'),
('3318', '1627', 'cust_branch', 'general', '1629'),
('3319', '1627', 'customer', 'general', '1629'),
('3320', '1628', 'cust_branch', 'general', '1630'),
('3321', '1628', 'customer', 'general', '1630'),
('3322', '1629', 'cust_branch', 'general', '1631'),
('3323', '1629', 'customer', 'general', '1631'),
('3324', '1630', 'cust_branch', 'general', '1632'),
('3325', '1630', 'customer', 'general', '1632'),
('3326', '1631', 'cust_branch', 'general', '1633'),
('3327', '1631', 'customer', 'general', '1633'),
('3328', '1632', 'cust_branch', 'general', '1634'),
('3329', '1632', 'customer', 'general', '1634'),
('3330', '1633', 'cust_branch', 'general', '1635'),
('3331', '1633', 'customer', 'general', '1635'),
('3332', '1634', 'cust_branch', 'general', '1636'),
('3333', '1634', 'customer', 'general', '1636'),
('3334', '1635', 'cust_branch', 'general', '1637'),
('3335', '1635', 'customer', 'general', '1637'),
('3336', '1636', 'cust_branch', 'general', '1638'),
('3337', '1636', 'customer', 'general', '1638'),
('3338', '1637', 'cust_branch', 'general', '1639'),
('3339', '1637', 'customer', 'general', '1639'),
('3340', '1638', 'cust_branch', 'general', '1640'),
('3341', '1638', 'customer', 'general', '1640'),
('3342', '1639', 'cust_branch', 'general', '1641'),
('3343', '1639', 'customer', 'general', '1641'),
('3344', '1640', 'cust_branch', 'general', '1642'),
('3345', '1640', 'customer', 'general', '1642'),
('3346', '1641', 'cust_branch', 'general', '1643'),
('3347', '1641', 'customer', 'general', '1643'),
('3348', '1642', 'cust_branch', 'general', '1644'),
('3349', '1642', 'customer', 'general', '1644'),
('3350', '1643', 'cust_branch', 'general', '1645'),
('3351', '1643', 'customer', 'general', '1645'),
('3352', '1644', 'cust_branch', 'general', '1646'),
('3353', '1644', 'customer', 'general', '1646'),
('3354', '1645', 'cust_branch', 'general', '1647'),
('3355', '1645', 'customer', 'general', '1647'),
('3356', '1646', 'cust_branch', 'general', '1648'),
('3357', '1646', 'customer', 'general', '1648'),
('3358', '1647', 'cust_branch', 'general', '1649'),
('3359', '1647', 'customer', 'general', '1649'),
('3360', '1648', 'cust_branch', 'general', '1650'),
('3361', '1648', 'customer', 'general', '1650'),
('3362', '1649', 'cust_branch', 'general', '1651'),
('3363', '1649', 'customer', 'general', '1651'),
('3364', '1650', 'cust_branch', 'general', '1652'),
('3365', '1650', 'customer', 'general', '1652'),
('3366', '1651', 'cust_branch', 'general', '1653'),
('3367', '1651', 'customer', 'general', '1653'),
('3368', '1652', 'cust_branch', 'general', '1654'),
('3369', '1652', 'customer', 'general', '1654'),
('3370', '1653', 'cust_branch', 'general', '1655'),
('3371', '1653', 'customer', 'general', '1655'),
('3372', '1654', 'cust_branch', 'general', '1656'),
('3373', '1654', 'customer', 'general', '1656'),
('3374', '1655', 'cust_branch', 'general', '1657'),
('3375', '1655', 'customer', 'general', '1657'),
('3376', '1656', 'cust_branch', 'general', '1658'),
('3377', '1656', 'customer', 'general', '1658'),
('3378', '1657', 'cust_branch', 'general', '1659'),
('3379', '1657', 'customer', 'general', '1659'),
('3380', '1658', 'cust_branch', 'general', '1660'),
('3381', '1658', 'customer', 'general', '1660'),
('3382', '1659', 'cust_branch', 'general', '1661'),
('3383', '1659', 'customer', 'general', '1661'),
('3384', '1660', 'cust_branch', 'general', '1662'),
('3385', '1660', 'customer', 'general', '1662'),
('3386', '1661', 'cust_branch', 'general', '1663'),
('3387', '1661', 'customer', 'general', '1663'),
('3388', '1662', 'cust_branch', 'general', '1664'),
('3389', '1662', 'customer', 'general', '1664'),
('3390', '1663', 'cust_branch', 'general', '1665'),
('3391', '1663', 'customer', 'general', '1665'),
('3392', '1664', 'cust_branch', 'general', '1666'),
('3393', '1664', 'customer', 'general', '1666'),
('3394', '1665', 'cust_branch', 'general', '1667'),
('3395', '1665', 'customer', 'general', '1667'),
('3396', '1666', 'cust_branch', 'general', '1668'),
('3397', '1666', 'customer', 'general', '1668'),
('3398', '1667', 'cust_branch', 'general', '1669'),
('3399', '1667', 'customer', 'general', '1669'),
('3400', '1668', 'cust_branch', 'general', '1670'),
('3401', '1668', 'customer', 'general', '1670'),
('3402', '1669', 'cust_branch', 'general', '1671'),
('3403', '1669', 'customer', 'general', '1671'),
('3404', '1670', 'cust_branch', 'general', '1672'),
('3405', '1670', 'customer', 'general', '1672'),
('3406', '1671', 'cust_branch', 'general', '1673'),
('3407', '1671', 'customer', 'general', '1673'),
('3408', '1672', 'cust_branch', 'general', '1674'),
('3409', '1672', 'customer', 'general', '1674'),
('3410', '1673', 'cust_branch', 'general', '1675'),
('3411', '1673', 'customer', 'general', '1675'),
('3412', '1674', 'cust_branch', 'general', '1676'),
('3413', '1674', 'customer', 'general', '1676'),
('3414', '1675', 'cust_branch', 'general', '1677'),
('3415', '1675', 'customer', 'general', '1677'),
('3416', '1676', 'cust_branch', 'general', '1678'),
('3417', '1676', 'customer', 'general', '1678'),
('3418', '1677', 'cust_branch', 'general', '1679'),
('3419', '1677', 'customer', 'general', '1679'),
('3420', '1678', 'cust_branch', 'general', '1680'),
('3421', '1678', 'customer', 'general', '1680'),
('3422', '1679', 'cust_branch', 'general', '1681'),
('3423', '1679', 'customer', 'general', '1681'),
('3424', '1680', 'cust_branch', 'general', '1682'),
('3425', '1680', 'customer', 'general', '1682'),
('3426', '1681', 'cust_branch', 'general', '1683'),
('3427', '1681', 'customer', 'general', '1683'),
('3428', '1682', 'cust_branch', 'general', '1684'),
('3429', '1682', 'customer', 'general', '1684'),
('3430', '1683', 'cust_branch', 'general', '1685'),
('3431', '1683', 'customer', 'general', '1685'),
('3432', '1684', 'cust_branch', 'general', '1686'),
('3433', '1684', 'customer', 'general', '1686'),
('3434', '1685', 'cust_branch', 'general', '1687'),
('3435', '1685', 'customer', 'general', '1687'),
('3436', '1686', 'cust_branch', 'general', '1688'),
('3437', '1686', 'customer', 'general', '1688'),
('3438', '1687', 'cust_branch', 'general', '1689'),
('3439', '1687', 'customer', 'general', '1689'),
('3440', '1688', 'cust_branch', 'general', '1690'),
('3441', '1688', 'customer', 'general', '1690'),
('3442', '1689', 'cust_branch', 'general', '1691'),
('3443', '1689', 'customer', 'general', '1691'),
('3444', '1690', 'cust_branch', 'general', '1692'),
('3445', '1690', 'customer', 'general', '1692'),
('3446', '1691', 'cust_branch', 'general', '1693'),
('3447', '1691', 'customer', 'general', '1693'),
('3448', '1692', 'cust_branch', 'general', '1694'),
('3449', '1692', 'customer', 'general', '1694'),
('3450', '1693', 'cust_branch', 'general', '1695'),
('3451', '1693', 'customer', 'general', '1695'),
('3452', '1694', 'cust_branch', 'general', '1696'),
('3453', '1694', 'customer', 'general', '1696'),
('3454', '1695', 'cust_branch', 'general', '1697'),
('3455', '1695', 'customer', 'general', '1697'),
('3456', '1696', 'cust_branch', 'general', '1698'),
('3457', '1696', 'customer', 'general', '1698'),
('3458', '1697', 'cust_branch', 'general', '1699'),
('3459', '1697', 'customer', 'general', '1699'),
('3460', '1698', 'cust_branch', 'general', '1700'),
('3461', '1698', 'customer', 'general', '1700'),
('3462', '1699', 'cust_branch', 'general', '1701'),
('3463', '1699', 'customer', 'general', '1701'),
('3464', '1700', 'cust_branch', 'general', '1702'),
('3465', '1700', 'customer', 'general', '1702'),
('3466', '1701', 'cust_branch', 'general', '1703'),
('3467', '1701', 'customer', 'general', '1703'),
('3468', '1702', 'cust_branch', 'general', '1704'),
('3469', '1702', 'customer', 'general', '1704'),
('3470', '1703', 'cust_branch', 'general', '1705'),
('3471', '1703', 'customer', 'general', '1705'),
('3472', '1704', 'cust_branch', 'general', '1706'),
('3473', '1704', 'customer', 'general', '1706'),
('3474', '1705', 'cust_branch', 'general', '1707'),
('3475', '1705', 'customer', 'general', '1707'),
('3476', '1706', 'cust_branch', 'general', '1708'),
('3477', '1706', 'customer', 'general', '1708'),
('3478', '1707', 'cust_branch', 'general', '1709'),
('3479', '1707', 'customer', 'general', '1709'),
('3480', '1708', 'cust_branch', 'general', '1710'),
('3481', '1708', 'customer', 'general', '1710'),
('3482', '1709', 'cust_branch', 'general', '1711'),
('3483', '1709', 'customer', 'general', '1711'),
('3484', '1710', 'cust_branch', 'general', '1712'),
('3485', '1710', 'customer', 'general', '1712'),
('3486', '1711', 'cust_branch', 'general', '1713'),
('3487', '1711', 'customer', 'general', '1713'),
('3488', '1712', 'cust_branch', 'general', '1714'),
('3489', '1712', 'customer', 'general', '1714'),
('3490', '1713', 'cust_branch', 'general', '1715'),
('3491', '1713', 'customer', 'general', '1715'),
('3492', '1714', 'cust_branch', 'general', '1716'),
('3493', '1714', 'customer', 'general', '1716'),
('3494', '1715', 'cust_branch', 'general', '1717'),
('3495', '1715', 'customer', 'general', '1717'),
('3496', '1716', 'cust_branch', 'general', '1718'),
('3497', '1716', 'customer', 'general', '1718'),
('3498', '1717', 'cust_branch', 'general', '1719'),
('3499', '1717', 'customer', 'general', '1719'),
('3500', '1718', 'cust_branch', 'general', '1720'),
('3501', '1718', 'customer', 'general', '1720'),
('3502', '1719', 'cust_branch', 'general', '1721'),
('3503', '1719', 'customer', 'general', '1721'),
('3504', '1720', 'cust_branch', 'general', '1722'),
('3505', '1720', 'customer', 'general', '1722'),
('3506', '1721', 'cust_branch', 'general', '1723'),
('3507', '1721', 'customer', 'general', '1723'),
('3508', '1722', 'cust_branch', 'general', '1724'),
('3509', '1722', 'customer', 'general', '1724'),
('3510', '1723', 'cust_branch', 'general', '1725'),
('3511', '1723', 'customer', 'general', '1725'),
('3512', '1724', 'cust_branch', 'general', '1726'),
('3513', '1724', 'customer', 'general', '1726'),
('3514', '1725', 'cust_branch', 'general', '1727'),
('3515', '1725', 'customer', 'general', '1727'),
('3516', '1726', 'cust_branch', 'general', '1728'),
('3517', '1726', 'customer', 'general', '1728'),
('3518', '1727', 'cust_branch', 'general', '1729'),
('3519', '1727', 'customer', 'general', '1729'),
('3520', '1728', 'cust_branch', 'general', '1730'),
('3521', '1728', 'customer', 'general', '1730'),
('3522', '1729', 'cust_branch', 'general', '1731'),
('3523', '1729', 'customer', 'general', '1731'),
('3524', '1730', 'cust_branch', 'general', '1732'),
('3525', '1730', 'customer', 'general', '1732'),
('3526', '1731', 'cust_branch', 'general', '1733'),
('3527', '1731', 'customer', 'general', '1733'),
('3528', '1732', 'cust_branch', 'general', '1734'),
('3529', '1732', 'customer', 'general', '1734'),
('3530', '1733', 'cust_branch', 'general', '1735'),
('3531', '1733', 'customer', 'general', '1735'),
('3532', '1734', 'cust_branch', 'general', '1736'),
('3533', '1734', 'customer', 'general', '1736'),
('3534', '1735', 'cust_branch', 'general', '1737'),
('3535', '1735', 'customer', 'general', '1737'),
('3536', '1736', 'cust_branch', 'general', '1738'),
('3537', '1736', 'customer', 'general', '1738'),
('3538', '1737', 'cust_branch', 'general', '1739'),
('3539', '1737', 'customer', 'general', '1739'),
('3540', '1738', 'cust_branch', 'general', '1740'),
('3541', '1738', 'customer', 'general', '1740'),
('3542', '1739', 'cust_branch', 'general', '1741'),
('3543', '1739', 'customer', 'general', '1741'),
('3544', '1740', 'cust_branch', 'general', '1742'),
('3545', '1740', 'customer', 'general', '1742'),
('3546', '1741', 'cust_branch', 'general', '1743'),
('3547', '1741', 'customer', 'general', '1743'),
('3548', '1742', 'cust_branch', 'general', '1744'),
('3549', '1742', 'customer', 'general', '1744'),
('3550', '1743', 'cust_branch', 'general', '1745'),
('3551', '1743', 'customer', 'general', '1745'),
('3552', '1744', 'cust_branch', 'general', '1746'),
('3553', '1744', 'customer', 'general', '1746'),
('3554', '1745', 'cust_branch', 'general', '1747'),
('3555', '1745', 'customer', 'general', '1747'),
('3556', '1746', 'cust_branch', 'general', '1748'),
('3557', '1746', 'customer', 'general', '1748'),
('3558', '1747', 'cust_branch', 'general', '1749'),
('3559', '1747', 'customer', 'general', '1749'),
('3560', '1748', 'cust_branch', 'general', '1750'),
('3561', '1748', 'customer', 'general', '1750'),
('3562', '1749', 'cust_branch', 'general', '1751'),
('3563', '1749', 'customer', 'general', '1751'),
('3564', '1750', 'cust_branch', 'general', '1752'),
('3565', '1750', 'customer', 'general', '1752'),
('3566', '1751', 'cust_branch', 'general', '1753'),
('3567', '1751', 'customer', 'general', '1753'),
('3568', '1752', 'cust_branch', 'general', '1754'),
('3569', '1752', 'customer', 'general', '1754'),
('3570', '1753', 'cust_branch', 'general', '1755'),
('3571', '1753', 'customer', 'general', '1755'),
('3572', '1754', 'cust_branch', 'general', '1756'),
('3573', '1754', 'customer', 'general', '1756'),
('3574', '1755', 'cust_branch', 'general', '1757'),
('3575', '1755', 'customer', 'general', '1757'),
('3576', '1756', 'cust_branch', 'general', '1758'),
('3577', '1756', 'customer', 'general', '1758'),
('3578', '1757', 'cust_branch', 'general', '1759'),
('3579', '1757', 'customer', 'general', '1759'),
('3580', '1758', 'cust_branch', 'general', '1760'),
('3581', '1758', 'customer', 'general', '1760'),
('3582', '1759', 'cust_branch', 'general', '1761'),
('3583', '1759', 'customer', 'general', '1761'),
('3584', '1760', 'cust_branch', 'general', '1762'),
('3585', '1760', 'customer', 'general', '1762'),
('3586', '1761', 'cust_branch', 'general', '1763'),
('3587', '1761', 'customer', 'general', '1763'),
('3588', '1762', 'cust_branch', 'general', '1764'),
('3589', '1762', 'customer', 'general', '1764'),
('3590', '1763', 'cust_branch', 'general', '1765'),
('3591', '1763', 'customer', 'general', '1765'),
('3592', '1764', 'cust_branch', 'general', '1766'),
('3593', '1764', 'customer', 'general', '1766'),
('3594', '1765', 'cust_branch', 'general', '1767'),
('3595', '1765', 'customer', 'general', '1767'),
('3596', '1766', 'cust_branch', 'general', '1768'),
('3597', '1766', 'customer', 'general', '1768'),
('3598', '1767', 'cust_branch', 'general', '1769'),
('3599', '1767', 'customer', 'general', '1769'),
('3600', '1768', 'cust_branch', 'general', '1770'),
('3601', '1768', 'customer', 'general', '1770'),
('3602', '1769', 'cust_branch', 'general', '1771'),
('3603', '1769', 'customer', 'general', '1771'),
('3604', '1770', 'cust_branch', 'general', '1772'),
('3605', '1770', 'customer', 'general', '1772'),
('3606', '1771', 'cust_branch', 'general', '1773'),
('3607', '1771', 'customer', 'general', '1773'),
('3608', '1772', 'cust_branch', 'general', '1774'),
('3609', '1772', 'customer', 'general', '1774'),
('3610', '1773', 'cust_branch', 'general', '1775'),
('3611', '1773', 'customer', 'general', '1775'),
('3612', '1774', 'cust_branch', 'general', '1776'),
('3613', '1774', 'customer', 'general', '1776'),
('3614', '1775', 'cust_branch', 'general', '1777'),
('3615', '1775', 'customer', 'general', '1777'),
('3616', '1776', 'cust_branch', 'general', '1778'),
('3617', '1776', 'customer', 'general', '1778'),
('3618', '1777', 'cust_branch', 'general', '1779'),
('3619', '1777', 'customer', 'general', '1779'),
('3620', '1778', 'cust_branch', 'general', '1780'),
('3621', '1778', 'customer', 'general', '1780'),
('3622', '1779', 'cust_branch', 'general', '1781'),
('3623', '1779', 'customer', 'general', '1781'),
('3624', '1780', 'cust_branch', 'general', '1782'),
('3625', '1780', 'customer', 'general', '1782'),
('3626', '1781', 'cust_branch', 'general', '1783'),
('3627', '1781', 'customer', 'general', '1783'),
('3628', '1782', 'cust_branch', 'general', '1784'),
('3629', '1782', 'customer', 'general', '1784'),
('3630', '1783', 'cust_branch', 'general', '1785'),
('3631', '1783', 'customer', 'general', '1785'),
('3632', '1784', 'cust_branch', 'general', '1786'),
('3633', '1784', 'customer', 'general', '1786'),
('3634', '1785', 'cust_branch', 'general', '1787'),
('3635', '1785', 'customer', 'general', '1787'),
('3636', '1786', 'cust_branch', 'general', '1788'),
('3637', '1786', 'customer', 'general', '1788'),
('3638', '1787', 'cust_branch', 'general', '1789'),
('3639', '1787', 'customer', 'general', '1789'),
('3640', '1788', 'cust_branch', 'general', '1790'),
('3641', '1788', 'customer', 'general', '1790'),
('3642', '1789', 'cust_branch', 'general', '1791'),
('3643', '1789', 'customer', 'general', '1791'),
('3644', '1790', 'cust_branch', 'general', '1792'),
('3645', '1790', 'customer', 'general', '1792'),
('3646', '1791', 'cust_branch', 'general', '1793'),
('3647', '1791', 'customer', 'general', '1793'),
('3648', '1792', 'cust_branch', 'general', '1794'),
('3649', '1792', 'customer', 'general', '1794'),
('3650', '1793', 'cust_branch', 'general', '1795'),
('3651', '1793', 'customer', 'general', '1795'),
('3652', '1794', 'cust_branch', 'general', '1796'),
('3653', '1794', 'customer', 'general', '1796'),
('3654', '1795', 'cust_branch', 'general', '1797'),
('3655', '1795', 'customer', 'general', '1797'),
('3656', '1796', 'cust_branch', 'general', '1798'),
('3657', '1796', 'customer', 'general', '1798'),
('3658', '1797', 'cust_branch', 'general', '1799'),
('3659', '1797', 'customer', 'general', '1799'),
('3660', '1798', 'cust_branch', 'general', '1800'),
('3661', '1798', 'customer', 'general', '1800'),
('3662', '1799', 'cust_branch', 'general', '1801'),
('3663', '1799', 'customer', 'general', '1801'),
('3664', '1800', 'cust_branch', 'general', '1802'),
('3665', '1800', 'customer', 'general', '1802'),
('3666', '1801', 'cust_branch', 'general', '1803'),
('3667', '1801', 'customer', 'general', '1803'),
('3668', '1802', 'cust_branch', 'general', '1804'),
('3669', '1802', 'customer', 'general', '1804'),
('3670', '1803', 'cust_branch', 'general', '1805'),
('3671', '1803', 'customer', 'general', '1805'),
('3672', '1804', 'cust_branch', 'general', '1806'),
('3673', '1804', 'customer', 'general', '1806'),
('3674', '1805', 'cust_branch', 'general', '1807'),
('3675', '1805', 'customer', 'general', '1807'),
('3676', '1806', 'cust_branch', 'general', '1808'),
('3677', '1806', 'customer', 'general', '1808'),
('3678', '1807', 'cust_branch', 'general', '1809'),
('3679', '1807', 'customer', 'general', '1809'),
('3680', '1808', 'cust_branch', 'general', '1810'),
('3681', '1808', 'customer', 'general', '1810'),
('3682', '1809', 'cust_branch', 'general', '1811'),
('3683', '1809', 'customer', 'general', '1811'),
('3684', '1810', 'cust_branch', 'general', '1812'),
('3685', '1810', 'customer', 'general', '1812'),
('3686', '1811', 'cust_branch', 'general', '1813'),
('3687', '1811', 'customer', 'general', '1813'),
('3688', '1812', 'cust_branch', 'general', '1814'),
('3689', '1812', 'customer', 'general', '1814'),
('3690', '1813', 'cust_branch', 'general', '1815'),
('3691', '1813', 'customer', 'general', '1815'),
('3692', '1814', 'cust_branch', 'general', '1816'),
('3693', '1814', 'customer', 'general', '1816'),
('3694', '1815', 'cust_branch', 'general', '1817'),
('3695', '1815', 'customer', 'general', '1817'),
('3696', '1816', 'cust_branch', 'general', '1818'),
('3697', '1816', 'customer', 'general', '1818'),
('3698', '1817', 'cust_branch', 'general', '1819'),
('3699', '1817', 'customer', 'general', '1819'),
('3700', '1818', 'cust_branch', 'general', '1820'),
('3701', '1818', 'customer', 'general', '1820'),
('3702', '1819', 'cust_branch', 'general', '1821'),
('3703', '1819', 'customer', 'general', '1821'),
('3704', '1820', 'cust_branch', 'general', '1822'),
('3705', '1820', 'customer', 'general', '1822'),
('3706', '1821', 'cust_branch', 'general', '1823'),
('3707', '1821', 'customer', 'general', '1823'),
('3708', '1822', 'cust_branch', 'general', '1824'),
('3709', '1822', 'customer', 'general', '1824'),
('3710', '1823', 'cust_branch', 'general', '1825'),
('3711', '1823', 'customer', 'general', '1825'),
('3712', '1824', 'cust_branch', 'general', '1826'),
('3713', '1824', 'customer', 'general', '1826'),
('3714', '1825', 'cust_branch', 'general', '1827'),
('3715', '1825', 'customer', 'general', '1827'),
('3716', '1826', 'cust_branch', 'general', '1828'),
('3717', '1826', 'customer', 'general', '1828'),
('3718', '1827', 'cust_branch', 'general', '1829'),
('3719', '1827', 'customer', 'general', '1829'),
('3720', '1828', 'cust_branch', 'general', '1830'),
('3721', '1828', 'customer', 'general', '1830'),
('3722', '1829', 'cust_branch', 'general', '1831'),
('3723', '1829', 'customer', 'general', '1831'),
('3724', '1830', 'cust_branch', 'general', '1832'),
('3725', '1830', 'customer', 'general', '1832'),
('3726', '1831', 'cust_branch', 'general', '1833'),
('3727', '1831', 'customer', 'general', '1833'),
('3728', '1832', 'cust_branch', 'general', '1834'),
('3729', '1832', 'customer', 'general', '1834'),
('3730', '1833', 'cust_branch', 'general', '1835'),
('3731', '1833', 'customer', 'general', '1835'),
('3732', '1834', 'cust_branch', 'general', '1836'),
('3733', '1834', 'customer', 'general', '1836'),
('3734', '1835', 'cust_branch', 'general', '1837'),
('3735', '1835', 'customer', 'general', '1837'),
('3736', '1836', 'cust_branch', 'general', '1838'),
('3737', '1836', 'customer', 'general', '1838'),
('3738', '1837', 'cust_branch', 'general', '1839'),
('3739', '1837', 'customer', 'general', '1839'),
('3740', '1838', 'cust_branch', 'general', '1840'),
('3741', '1838', 'customer', 'general', '1840'),
('3742', '1839', 'cust_branch', 'general', '1841'),
('3743', '1839', 'customer', 'general', '1841'),
('3744', '1840', 'cust_branch', 'general', '1842'),
('3745', '1840', 'customer', 'general', '1842'),
('3746', '1841', 'cust_branch', 'general', '1843'),
('3747', '1841', 'customer', 'general', '1843'),
('3748', '1842', 'cust_branch', 'general', '1844'),
('3749', '1842', 'customer', 'general', '1844'),
('3750', '1843', 'cust_branch', 'general', '1845'),
('3751', '1843', 'customer', 'general', '1845'),
('3752', '1844', 'cust_branch', 'general', '1846'),
('3753', '1844', 'customer', 'general', '1846'),
('3754', '1845', 'cust_branch', 'general', '1847'),
('3755', '1845', 'customer', 'general', '1847'),
('3756', '1846', 'cust_branch', 'general', '1848'),
('3757', '1846', 'customer', 'general', '1848'),
('3758', '1847', 'cust_branch', 'general', '1849'),
('3759', '1847', 'customer', 'general', '1849'),
('3760', '1848', 'cust_branch', 'general', '1850'),
('3761', '1848', 'customer', 'general', '1850'),
('3762', '1849', 'cust_branch', 'general', '1851'),
('3763', '1849', 'customer', 'general', '1851'),
('3764', '1850', 'cust_branch', 'general', '1852'),
('3765', '1850', 'customer', 'general', '1852'),
('3766', '1851', 'cust_branch', 'general', '1853'),
('3767', '1851', 'customer', 'general', '1853'),
('3768', '1852', 'cust_branch', 'general', '1854'),
('3769', '1852', 'customer', 'general', '1854'),
('3770', '1853', 'cust_branch', 'general', '1855'),
('3771', '1853', 'customer', 'general', '1855'),
('3772', '1854', 'cust_branch', 'general', '1856'),
('3773', '1854', 'customer', 'general', '1856'),
('3774', '1855', 'cust_branch', 'general', '1857'),
('3775', '1855', 'customer', 'general', '1857'),
('3776', '1856', 'cust_branch', 'general', '1858'),
('3777', '1856', 'customer', 'general', '1858'),
('3778', '1857', 'cust_branch', 'general', '1859'),
('3779', '1857', 'customer', 'general', '1859'),
('3780', '1858', 'cust_branch', 'general', '1860'),
('3781', '1858', 'customer', 'general', '1860'),
('3782', '1859', 'cust_branch', 'general', '1861'),
('3783', '1859', 'customer', 'general', '1861'),
('3784', '1860', 'cust_branch', 'general', '1862'),
('3785', '1860', 'customer', 'general', '1862'),
('3786', '1861', 'cust_branch', 'general', '1863'),
('3787', '1861', 'customer', 'general', '1863'),
('3788', '1862', 'cust_branch', 'general', '1864'),
('3789', '1862', 'customer', 'general', '1864'),
('3790', '1863', 'cust_branch', 'general', '1865'),
('3791', '1863', 'customer', 'general', '1865'),
('3792', '1864', 'cust_branch', 'general', '1866'),
('3793', '1864', 'customer', 'general', '1866'),
('3794', '1865', 'cust_branch', 'general', '1867'),
('3795', '1865', 'customer', 'general', '1867'),
('3796', '1866', 'cust_branch', 'general', '1868'),
('3797', '1866', 'customer', 'general', '1868'),
('3798', '1867', 'cust_branch', 'general', '1869'),
('3799', '1867', 'customer', 'general', '1869'),
('3800', '1868', 'cust_branch', 'general', '1870'),
('3801', '1868', 'customer', 'general', '1870'),
('3802', '1869', 'cust_branch', 'general', '1871'),
('3803', '1869', 'customer', 'general', '1871'),
('3804', '1870', 'cust_branch', 'general', '1872'),
('3805', '1870', 'customer', 'general', '1872'),
('3806', '1871', 'cust_branch', 'general', '1873'),
('3807', '1871', 'customer', 'general', '1873'),
('3808', '1872', 'cust_branch', 'general', '1874'),
('3809', '1872', 'customer', 'general', '1874'),
('3810', '1873', 'cust_branch', 'general', '1875'),
('3811', '1873', 'customer', 'general', '1875'),
('3812', '1874', 'cust_branch', 'general', '1876'),
('3813', '1874', 'customer', 'general', '1876'),
('3814', '1875', 'cust_branch', 'general', '1877'),
('3815', '1875', 'customer', 'general', '1877'),
('3816', '1876', 'cust_branch', 'general', '1878'),
('3817', '1876', 'customer', 'general', '1878'),
('3818', '1877', 'cust_branch', 'general', '1879'),
('3819', '1877', 'customer', 'general', '1879'),
('3820', '1878', 'cust_branch', 'general', '1880'),
('3821', '1878', 'customer', 'general', '1880'),
('3822', '1879', 'cust_branch', 'general', '1881'),
('3823', '1879', 'customer', 'general', '1881'),
('3824', '1880', 'cust_branch', 'general', '1882'),
('3825', '1880', 'customer', 'general', '1882'),
('3826', '1881', 'cust_branch', 'general', '1883'),
('3827', '1881', 'customer', 'general', '1883'),
('3828', '1882', 'cust_branch', 'general', '1884'),
('3829', '1882', 'customer', 'general', '1884'),
('3830', '1883', 'cust_branch', 'general', '1885'),
('3831', '1883', 'customer', 'general', '1885'),
('3832', '1884', 'cust_branch', 'general', '1886'),
('3833', '1884', 'customer', 'general', '1886'),
('3834', '1885', 'cust_branch', 'general', '1887'),
('3835', '1885', 'customer', 'general', '1887'),
('3836', '1886', 'cust_branch', 'general', '1888'),
('3837', '1886', 'customer', 'general', '1888'),
('3838', '1887', 'cust_branch', 'general', '1889'),
('3839', '1887', 'customer', 'general', '1889'),
('3840', '1888', 'cust_branch', 'general', '1890'),
('3841', '1888', 'customer', 'general', '1890'),
('3842', '1889', 'cust_branch', 'general', '1891'),
('3843', '1889', 'customer', 'general', '1891'),
('3844', '1890', 'cust_branch', 'general', '1892'),
('3845', '1890', 'customer', 'general', '1892'),
('3846', '1891', 'cust_branch', 'general', '1893'),
('3847', '1891', 'customer', 'general', '1893'),
('3848', '1892', 'cust_branch', 'general', '1894'),
('3849', '1892', 'customer', 'general', '1894'),
('3850', '1893', 'cust_branch', 'general', '1895'),
('3851', '1893', 'customer', 'general', '1895'),
('3852', '1894', 'cust_branch', 'general', '1896'),
('3853', '1894', 'customer', 'general', '1896'),
('3854', '1895', 'cust_branch', 'general', '1897'),
('3855', '1895', 'customer', 'general', '1897'),
('3856', '1896', 'cust_branch', 'general', '1898'),
('3857', '1896', 'customer', 'general', '1898'),
('3858', '1897', 'cust_branch', 'general', '1899'),
('3859', '1897', 'customer', 'general', '1899'),
('3860', '1898', 'cust_branch', 'general', '1900'),
('3861', '1898', 'customer', 'general', '1900'),
('3862', '1899', 'cust_branch', 'general', '1901'),
('3863', '1899', 'customer', 'general', '1901'),
('3864', '1900', 'cust_branch', 'general', '1902'),
('3865', '1900', 'customer', 'general', '1902'),
('3866', '1901', 'cust_branch', 'general', '1903'),
('3867', '1901', 'customer', 'general', '1903'),
('3868', '1902', 'cust_branch', 'general', '1904'),
('3869', '1902', 'customer', 'general', '1904'),
('3870', '1903', 'cust_branch', 'general', '1905'),
('3871', '1903', 'customer', 'general', '1905'),
('3872', '1904', 'cust_branch', 'general', '1906'),
('3873', '1904', 'customer', 'general', '1906'),
('3874', '1905', 'cust_branch', 'general', '1907'),
('3875', '1905', 'customer', 'general', '1907'),
('3876', '1906', 'cust_branch', 'general', '1908'),
('3877', '1906', 'customer', 'general', '1908'),
('3878', '1907', 'cust_branch', 'general', '1909'),
('3879', '1907', 'customer', 'general', '1909'),
('3880', '1908', 'cust_branch', 'general', '1910'),
('3881', '1908', 'customer', 'general', '1910'),
('3882', '1909', 'cust_branch', 'general', '1911'),
('3883', '1909', 'customer', 'general', '1911'),
('3884', '1910', 'cust_branch', 'general', '1912'),
('3885', '1910', 'customer', 'general', '1912'),
('3886', '1911', 'cust_branch', 'general', '1913'),
('3887', '1911', 'customer', 'general', '1913'),
('3888', '1912', 'cust_branch', 'general', '1914'),
('3889', '1912', 'customer', 'general', '1914'),
('3890', '1913', 'cust_branch', 'general', '1915'),
('3891', '1913', 'customer', 'general', '1915'),
('3892', '1914', 'cust_branch', 'general', '1916'),
('3893', '1914', 'customer', 'general', '1916'),
('3894', '1915', 'cust_branch', 'general', '1917'),
('3895', '1915', 'customer', 'general', '1917'),
('3896', '1916', 'cust_branch', 'general', '1918'),
('3897', '1916', 'customer', 'general', '1918'),
('3898', '1917', 'cust_branch', 'general', '1919'),
('3899', '1917', 'customer', 'general', '1919'),
('3900', '1918', 'cust_branch', 'general', '1920'),
('3901', '1918', 'customer', 'general', '1920'),
('3902', '1919', 'cust_branch', 'general', '1921'),
('3903', '1919', 'customer', 'general', '1921'),
('3904', '1920', 'cust_branch', 'general', '1922'),
('3905', '1920', 'customer', 'general', '1922'),
('3906', '1921', 'cust_branch', 'general', '1923'),
('3907', '1921', 'customer', 'general', '1923'),
('3908', '1922', 'cust_branch', 'general', '1924'),
('3909', '1922', 'customer', 'general', '1924'),
('3910', '1923', 'cust_branch', 'general', '1925'),
('3911', '1923', 'customer', 'general', '1925'),
('3912', '1924', 'cust_branch', 'general', '1926'),
('3913', '1924', 'customer', 'general', '1926'),
('3914', '1925', 'cust_branch', 'general', '1927'),
('3915', '1925', 'customer', 'general', '1927'),
('3916', '1926', 'cust_branch', 'general', '1928'),
('3917', '1926', 'customer', 'general', '1928'),
('3918', '1927', 'cust_branch', 'general', '1929'),
('3919', '1927', 'customer', 'general', '1929'),
('3920', '1928', 'cust_branch', 'general', '1930'),
('3921', '1928', 'customer', 'general', '1930'),
('3922', '1929', 'cust_branch', 'general', '1931'),
('3923', '1929', 'customer', 'general', '1931'),
('3924', '1930', 'cust_branch', 'general', '1932'),
('3925', '1930', 'customer', 'general', '1932'),
('3926', '1931', 'cust_branch', 'general', '1933'),
('3927', '1931', 'customer', 'general', '1933'),
('3928', '1932', 'cust_branch', 'general', '1934'),
('3929', '1932', 'customer', 'general', '1934'),
('3930', '1933', 'cust_branch', 'general', '1935'),
('3931', '1933', 'customer', 'general', '1935'),
('3932', '1934', 'cust_branch', 'general', '1936'),
('3933', '1934', 'customer', 'general', '1936'),
('3934', '1935', 'cust_branch', 'general', '1937'),
('3935', '1935', 'customer', 'general', '1937'),
('3936', '1936', 'cust_branch', 'general', '1938'),
('3937', '1936', 'customer', 'general', '1938'),
('3938', '1937', 'cust_branch', 'general', '1939'),
('3939', '1937', 'customer', 'general', '1939'),
('3940', '1938', 'cust_branch', 'general', '1940'),
('3941', '1938', 'customer', 'general', '1940'),
('3942', '1939', 'cust_branch', 'general', '1941'),
('3943', '1939', 'customer', 'general', '1941'),
('3944', '1940', 'cust_branch', 'general', '1942'),
('3945', '1940', 'customer', 'general', '1942'),
('3946', '1941', 'cust_branch', 'general', '1943'),
('3947', '1941', 'customer', 'general', '1943'),
('3948', '1942', 'cust_branch', 'general', '1944'),
('3949', '1942', 'customer', 'general', '1944'),
('3950', '1943', 'cust_branch', 'general', '1945'),
('3951', '1943', 'customer', 'general', '1945'),
('3952', '1944', 'cust_branch', 'general', '1946'),
('3953', '1944', 'customer', 'general', '1946'),
('3954', '1945', 'cust_branch', 'general', '1947'),
('3955', '1945', 'customer', 'general', '1947'),
('3956', '1946', 'cust_branch', 'general', '1948'),
('3957', '1946', 'customer', 'general', '1948'),
('3958', '1947', 'cust_branch', 'general', '1949'),
('3959', '1947', 'customer', 'general', '1949'),
('3960', '1948', 'cust_branch', 'general', '1950'),
('3961', '1948', 'customer', 'general', '1950'),
('3962', '1949', 'cust_branch', 'general', '1951'),
('3963', '1949', 'customer', 'general', '1951'),
('3964', '1950', 'cust_branch', 'general', '1952'),
('3965', '1950', 'customer', 'general', '1952'),
('3966', '1951', 'cust_branch', 'general', '1953'),
('3967', '1951', 'customer', 'general', '1953'),
('3968', '1952', 'cust_branch', 'general', '1954'),
('3969', '1952', 'customer', 'general', '1954'),
('3970', '1953', 'cust_branch', 'general', '1955'),
('3971', '1953', 'customer', 'general', '1955'),
('3972', '1954', 'cust_branch', 'general', '1956'),
('3973', '1954', 'customer', 'general', '1956'),
('3974', '1955', 'cust_branch', 'general', '1957'),
('3975', '1955', 'customer', 'general', '1957'),
('3976', '1956', 'cust_branch', 'general', '1958'),
('3977', '1956', 'customer', 'general', '1958'),
('3978', '1957', 'cust_branch', 'general', '1959'),
('3979', '1957', 'customer', 'general', '1959'),
('3980', '1958', 'cust_branch', 'general', '1960'),
('3981', '1958', 'customer', 'general', '1960'),
('3982', '1959', 'cust_branch', 'general', '1961'),
('3983', '1959', 'customer', 'general', '1961'),
('3984', '1960', 'cust_branch', 'general', '1962'),
('3985', '1960', 'customer', 'general', '1962'),
('3986', '1961', 'cust_branch', 'general', '1963'),
('3987', '1961', 'customer', 'general', '1963'),
('3988', '1962', 'cust_branch', 'general', '1964'),
('3989', '1962', 'customer', 'general', '1964'),
('3990', '1963', 'cust_branch', 'general', '1965'),
('3991', '1963', 'customer', 'general', '1965'),
('3992', '1964', 'cust_branch', 'general', '1966'),
('3993', '1964', 'customer', 'general', '1966'),
('3994', '1965', 'cust_branch', 'general', '1967'),
('3995', '1965', 'customer', 'general', '1967'),
('3996', '1966', 'cust_branch', 'general', '1968'),
('3997', '1966', 'customer', 'general', '1968'),
('3998', '1967', 'cust_branch', 'general', '1969'),
('3999', '1967', 'customer', 'general', '1969'),
('4000', '1968', 'cust_branch', 'general', '1970'),
('4001', '1968', 'customer', 'general', '1970'),
('4002', '1969', 'cust_branch', 'general', '1971'),
('4003', '1969', 'customer', 'general', '1971'),
('4004', '1970', 'cust_branch', 'general', '1972'),
('4005', '1970', 'customer', 'general', '1972'),
('4006', '1971', 'cust_branch', 'general', '1973'),
('4007', '1971', 'customer', 'general', '1973'),
('4008', '1972', 'cust_branch', 'general', '1974'),
('4009', '1972', 'customer', 'general', '1974'),
('4010', '1973', 'cust_branch', 'general', '1975'),
('4011', '1973', 'customer', 'general', '1975'),
('4012', '1974', 'cust_branch', 'general', '1976'),
('4013', '1974', 'customer', 'general', '1976'),
('4014', '1975', 'cust_branch', 'general', '1977'),
('4015', '1975', 'customer', 'general', '1977'),
('4016', '1976', 'cust_branch', 'general', '1978'),
('4017', '1976', 'customer', 'general', '1978'),
('4018', '1977', 'cust_branch', 'general', '1979'),
('4019', '1977', 'customer', 'general', '1979'),
('4020', '1978', 'cust_branch', 'general', '1980'),
('4021', '1978', 'customer', 'general', '1980'),
('4022', '1979', 'cust_branch', 'general', '1981'),
('4023', '1979', 'customer', 'general', '1981'),
('4024', '1980', 'cust_branch', 'general', '1982'),
('4025', '1980', 'customer', 'general', '1982'),
('4026', '1981', 'cust_branch', 'general', '1983'),
('4027', '1981', 'customer', 'general', '1983'),
('4028', '1982', 'cust_branch', 'general', '1984'),
('4029', '1982', 'customer', 'general', '1984'),
('4030', '1983', 'cust_branch', 'general', '1985'),
('4031', '1983', 'customer', 'general', '1985'),
('4032', '1984', 'cust_branch', 'general', '1986'),
('4033', '1984', 'customer', 'general', '1986'),
('4034', '1985', 'cust_branch', 'general', '1987'),
('4035', '1985', 'customer', 'general', '1987'),
('4036', '1986', 'cust_branch', 'general', '1988'),
('4037', '1986', 'customer', 'general', '1988'),
('4038', '1987', 'cust_branch', 'general', '1989'),
('4039', '1987', 'customer', 'general', '1989'),
('4040', '1988', 'cust_branch', 'general', '1990'),
('4041', '1988', 'customer', 'general', '1990'),
('4042', '1989', 'cust_branch', 'general', '1991'),
('4043', '1989', 'customer', 'general', '1991'),
('4044', '1990', 'cust_branch', 'general', '1992'),
('4045', '1990', 'customer', 'general', '1992'),
('4046', '1991', 'cust_branch', 'general', '1993'),
('4047', '1991', 'customer', 'general', '1993'),
('4048', '1992', 'cust_branch', 'general', '1994'),
('4049', '1992', 'customer', 'general', '1994'),
('4050', '1993', 'cust_branch', 'general', '1995'),
('4051', '1993', 'customer', 'general', '1995'),
('4052', '1994', 'cust_branch', 'general', '1996'),
('4053', '1994', 'customer', 'general', '1996'),
('4054', '1995', 'cust_branch', 'general', '1997'),
('4055', '1995', 'customer', 'general', '1997'),
('4056', '1996', 'cust_branch', 'general', '1998'),
('4057', '1996', 'customer', 'general', '1998'),
('4058', '1997', 'cust_branch', 'general', '1999'),
('4059', '1997', 'customer', 'general', '1999'),
('4060', '1998', 'cust_branch', 'general', '2000'),
('4061', '1998', 'customer', 'general', '2000'),
('4062', '1999', 'cust_branch', 'general', '2001'),
('4063', '1999', 'customer', 'general', '2001'),
('4064', '2000', 'cust_branch', 'general', '2002'),
('4065', '2000', 'customer', 'general', '2002'),
('4066', '2001', 'cust_branch', 'general', '2003'),
('4067', '2001', 'customer', 'general', '2003'),
('4068', '2002', 'cust_branch', 'general', '2004'),
('4069', '2002', 'customer', 'general', '2004'),
('4070', '2003', 'cust_branch', 'general', '2005'),
('4071', '2003', 'customer', 'general', '2005'),
('4072', '2004', 'cust_branch', 'general', '2006'),
('4073', '2004', 'customer', 'general', '2006'),
('4074', '2005', 'cust_branch', 'general', '2007'),
('4075', '2005', 'customer', 'general', '2007'),
('4076', '2006', 'cust_branch', 'general', '2008'),
('4077', '2006', 'customer', 'general', '2008'),
('4078', '2007', 'cust_branch', 'general', '2009'),
('4079', '2007', 'customer', 'general', '2009'),
('4080', '2008', 'cust_branch', 'general', '2010'),
('4081', '2008', 'customer', 'general', '2010'),
('4082', '2009', 'cust_branch', 'general', '2011'),
('4083', '2009', 'customer', 'general', '2011'),
('4084', '2010', 'cust_branch', 'general', '2012'),
('4085', '2010', 'customer', 'general', '2012'),
('4086', '2011', 'cust_branch', 'general', '2013'),
('4087', '2011', 'customer', 'general', '2013'),
('4088', '2012', 'cust_branch', 'general', '2014'),
('4089', '2012', 'customer', 'general', '2014'),
('4090', '2013', 'cust_branch', 'general', '2015'),
('4091', '2013', 'customer', 'general', '2015'),
('4092', '2014', 'cust_branch', 'general', '2016'),
('4093', '2014', 'customer', 'general', '2016'),
('4094', '2015', 'cust_branch', 'general', '2017'),
('4095', '2015', 'customer', 'general', '2017'),
('4096', '2016', 'cust_branch', 'general', '2018'),
('4097', '2016', 'customer', 'general', '2018'),
('4098', '2017', 'cust_branch', 'general', '2019'),
('4099', '2017', 'customer', 'general', '2019'),
('4100', '2018', 'cust_branch', 'general', '2020'),
('4101', '2018', 'customer', 'general', '2020'),
('4102', '2019', 'cust_branch', 'general', '2021'),
('4103', '2019', 'customer', 'general', '2021'),
('4104', '2020', 'cust_branch', 'general', '2022'),
('4105', '2020', 'customer', 'general', '2022'),
('4106', '2021', 'cust_branch', 'general', '2023'),
('4107', '2021', 'customer', 'general', '2023'),
('4108', '2022', 'cust_branch', 'general', '2024'),
('4109', '2022', 'customer', 'general', '2024'),
('4110', '2023', 'cust_branch', 'general', '2025'),
('4111', '2023', 'customer', 'general', '2025'),
('4112', '2024', 'cust_branch', 'general', '2026'),
('4113', '2024', 'customer', 'general', '2026'),
('4114', '2025', 'cust_branch', 'general', '2027'),
('4115', '2025', 'customer', 'general', '2027'),
('4116', '2026', 'cust_branch', 'general', '2028'),
('4117', '2026', 'customer', 'general', '2028'),
('4118', '2027', 'cust_branch', 'general', '2029'),
('4119', '2027', 'customer', 'general', '2029'),
('4120', '2028', 'cust_branch', 'general', '2030'),
('4121', '2028', 'customer', 'general', '2030'),
('4122', '2029', 'cust_branch', 'general', '2031'),
('4123', '2029', 'customer', 'general', '2031'),
('4124', '2030', 'cust_branch', 'general', '2032'),
('4125', '2030', 'customer', 'general', '2032'),
('4126', '2031', 'cust_branch', 'general', '2033'),
('4127', '2031', 'customer', 'general', '2033'),
('4128', '2032', 'cust_branch', 'general', '2034'),
('4129', '2032', 'customer', 'general', '2034'),
('4130', '2033', 'cust_branch', 'general', '2035'),
('4131', '2033', 'customer', 'general', '2035'),
('4132', '2034', 'cust_branch', 'general', '2036'),
('4133', '2034', 'customer', 'general', '2036'),
('4134', '2035', 'cust_branch', 'general', '2037'),
('4135', '2035', 'customer', 'general', '2037'),
('4136', '2036', 'cust_branch', 'general', '2038'),
('4137', '2036', 'customer', 'general', '2038'),
('4138', '2037', 'cust_branch', 'general', '2039'),
('4139', '2037', 'customer', 'general', '2039'),
('4140', '2038', 'cust_branch', 'general', '2040'),
('4141', '2038', 'customer', 'general', '2040'),
('4142', '2039', 'cust_branch', 'general', '2041'),
('4143', '2039', 'customer', 'general', '2041'),
('4144', '2040', 'cust_branch', 'general', '2042'),
('4145', '2040', 'customer', 'general', '2042'),
('4146', '2041', 'cust_branch', 'general', '2043'),
('4147', '2041', 'customer', 'general', '2043'),
('4148', '2042', 'cust_branch', 'general', '2044'),
('4149', '2042', 'customer', 'general', '2044'),
('4150', '2043', 'cust_branch', 'general', '2045'),
('4151', '2043', 'customer', 'general', '2045'),
('4152', '2044', 'cust_branch', 'general', '2046'),
('4153', '2044', 'customer', 'general', '2046'),
('4154', '2045', 'cust_branch', 'general', '2047'),
('4155', '2045', 'customer', 'general', '2047'),
('4156', '2046', 'cust_branch', 'general', '2048'),
('4157', '2046', 'customer', 'general', '2048'),
('4158', '2047', 'cust_branch', 'general', '2049'),
('4159', '2047', 'customer', 'general', '2049'),
('4160', '2048', 'cust_branch', 'general', '2050'),
('4161', '2048', 'customer', 'general', '2050'),
('4162', '2049', 'cust_branch', 'general', '2051'),
('4163', '2049', 'customer', 'general', '2051'),
('4164', '2050', 'cust_branch', 'general', '2052'),
('4165', '2050', 'customer', 'general', '2052'),
('4166', '2051', 'cust_branch', 'general', '2053'),
('4167', '2051', 'customer', 'general', '2053'),
('4168', '2052', 'cust_branch', 'general', '2054'),
('4169', '2052', 'customer', 'general', '2054'),
('4170', '2053', 'cust_branch', 'general', '2055'),
('4171', '2053', 'customer', 'general', '2055'),
('4172', '2054', 'cust_branch', 'general', '2056'),
('4173', '2054', 'customer', 'general', '2056'),
('4174', '2055', 'cust_branch', 'general', '2057'),
('4175', '2055', 'customer', 'general', '2057'),
('4176', '2056', 'cust_branch', 'general', '2058'),
('4177', '2056', 'customer', 'general', '2058'),
('4178', '2057', 'cust_branch', 'general', '2059'),
('4179', '2057', 'customer', 'general', '2059'),
('4180', '2058', 'cust_branch', 'general', '2060'),
('4181', '2058', 'customer', 'general', '2060'),
('4182', '2059', 'cust_branch', 'general', '2061'),
('4183', '2059', 'customer', 'general', '2061'),
('4184', '2060', 'cust_branch', 'general', '2062'),
('4185', '2060', 'customer', 'general', '2062'),
('4186', '2061', 'cust_branch', 'general', '2063'),
('4187', '2061', 'customer', 'general', '2063'),
('4188', '2062', 'cust_branch', 'general', '2064'),
('4189', '2062', 'customer', 'general', '2064'),
('4190', '2063', 'cust_branch', 'general', '2065'),
('4191', '2063', 'customer', 'general', '2065'),
('4192', '2064', 'cust_branch', 'general', '2066'),
('4193', '2064', 'customer', 'general', '2066'),
('4194', '2065', 'cust_branch', 'general', '2067'),
('4195', '2065', 'customer', 'general', '2067'),
('4196', '2066', 'cust_branch', 'general', '2068'),
('4197', '2066', 'customer', 'general', '2068'),
('4198', '2067', 'cust_branch', 'general', '2069'),
('4199', '2067', 'customer', 'general', '2069'),
('4200', '2068', 'cust_branch', 'general', '2070'),
('4201', '2068', 'customer', 'general', '2070'),
('4202', '2069', 'cust_branch', 'general', '2071'),
('4203', '2069', 'customer', 'general', '2071'),
('4204', '2070', 'cust_branch', 'general', '2072'),
('4205', '2070', 'customer', 'general', '2072'),
('4206', '2071', 'cust_branch', 'general', '2073'),
('4207', '2071', 'customer', 'general', '2073'),
('4208', '2072', 'cust_branch', 'general', '2074'),
('4209', '2072', 'customer', 'general', '2074'),
('4210', '2073', 'cust_branch', 'general', '2075'),
('4211', '2073', 'customer', 'general', '2075'),
('4212', '2074', 'cust_branch', 'general', '2076'),
('4213', '2074', 'customer', 'general', '2076'),
('4214', '2075', 'cust_branch', 'general', '2077'),
('4215', '2075', 'customer', 'general', '2077'),
('4216', '2076', 'cust_branch', 'general', '2078'),
('4217', '2076', 'customer', 'general', '2078'),
('4218', '2077', 'cust_branch', 'general', '2079'),
('4219', '2077', 'customer', 'general', '2079'),
('4220', '2078', 'cust_branch', 'general', '2080'),
('4221', '2078', 'customer', 'general', '2080'),
('4222', '2079', 'cust_branch', 'general', '2081'),
('4223', '2079', 'customer', 'general', '2081'),
('4224', '2080', 'cust_branch', 'general', '2082'),
('4225', '2080', 'customer', 'general', '2082'),
('4226', '2081', 'cust_branch', 'general', '2083'),
('4227', '2081', 'customer', 'general', '2083'),
('4228', '2082', 'cust_branch', 'general', '2084'),
('4229', '2082', 'customer', 'general', '2084'),
('4230', '2083', 'cust_branch', 'general', '2085'),
('4231', '2083', 'customer', 'general', '2085'),
('4232', '2084', 'cust_branch', 'general', '2086'),
('4233', '2084', 'customer', 'general', '2086'),
('4234', '2085', 'cust_branch', 'general', '2087'),
('4235', '2085', 'customer', 'general', '2087'),
('4236', '2086', 'cust_branch', 'general', '2088'),
('4237', '2086', 'customer', 'general', '2088'),
('4238', '2087', 'cust_branch', 'general', '2089'),
('4239', '2087', 'customer', 'general', '2089'),
('4240', '2088', 'cust_branch', 'general', '2090'),
('4241', '2088', 'customer', 'general', '2090'),
('4242', '2089', 'cust_branch', 'general', '2091'),
('4243', '2089', 'customer', 'general', '2091'),
('4244', '2090', 'cust_branch', 'general', '2092'),
('4245', '2090', 'customer', 'general', '2092');
INSERT INTO `0_crm_contacts` VALUES
('4246', '2091', 'cust_branch', 'general', '2093'),
('4247', '2091', 'customer', 'general', '2093'),
('4248', '2092', 'cust_branch', 'general', '2094'),
('4249', '2092', 'customer', 'general', '2094'),
('4250', '2093', 'cust_branch', 'general', '2095'),
('4251', '2093', 'customer', 'general', '2095'),
('4252', '2094', 'cust_branch', 'general', '2096'),
('4253', '2094', 'customer', 'general', '2096'),
('4254', '2095', 'cust_branch', 'general', '2097'),
('4255', '2095', 'customer', 'general', '2097'),
('4256', '2096', 'cust_branch', 'general', '2098'),
('4257', '2096', 'customer', 'general', '2098'),
('4258', '2097', 'cust_branch', 'general', '2099'),
('4259', '2097', 'customer', 'general', '2099'),
('4260', '2098', 'cust_branch', 'general', '2100'),
('4261', '2098', 'customer', 'general', '2100'),
('4262', '2099', 'cust_branch', 'general', '2101'),
('4263', '2099', 'customer', 'general', '2101'),
('4264', '2100', 'cust_branch', 'general', '2102'),
('4265', '2100', 'customer', 'general', '2102'),
('4266', '2101', 'cust_branch', 'general', '2103'),
('4267', '2101', 'customer', 'general', '2103'),
('4268', '2102', 'cust_branch', 'general', '2104'),
('4269', '2102', 'customer', 'general', '2104'),
('4270', '2103', 'cust_branch', 'general', '2105'),
('4271', '2103', 'customer', 'general', '2105'),
('4272', '2104', 'cust_branch', 'general', '2106'),
('4273', '2104', 'customer', 'general', '2106'),
('4274', '2105', 'cust_branch', 'general', '2107'),
('4275', '2105', 'customer', 'general', '2107'),
('4276', '2106', 'cust_branch', 'general', '2108'),
('4277', '2106', 'customer', 'general', '2108'),
('4278', '2107', 'cust_branch', 'general', '2109'),
('4279', '2107', 'customer', 'general', '2109'),
('4280', '2108', 'cust_branch', 'general', '2110'),
('4281', '2108', 'customer', 'general', '2110'),
('4282', '2109', 'cust_branch', 'general', '2111'),
('4283', '2109', 'customer', 'general', '2111'),
('4284', '2110', 'cust_branch', 'general', '2112'),
('4285', '2110', 'customer', 'general', '2112'),
('4286', '2111', 'cust_branch', 'general', '2113'),
('4287', '2111', 'customer', 'general', '2113'),
('4288', '2112', 'cust_branch', 'general', '2114'),
('4289', '2112', 'customer', 'general', '2114'),
('4290', '2113', 'cust_branch', 'general', '2115'),
('4291', '2113', 'customer', 'general', '2115'),
('4292', '2114', 'cust_branch', 'general', '2116'),
('4293', '2114', 'customer', 'general', '2116'),
('4294', '2115', 'cust_branch', 'general', '2117'),
('4295', '2115', 'customer', 'general', '2117'),
('4296', '2116', 'cust_branch', 'general', '2118'),
('4297', '2116', 'customer', 'general', '2118'),
('4298', '2117', 'cust_branch', 'general', '2119'),
('4299', '2117', 'customer', 'general', '2119'),
('4300', '2118', 'cust_branch', 'general', '2120'),
('4301', '2118', 'customer', 'general', '2120'),
('4302', '2119', 'cust_branch', 'general', '2121'),
('4303', '2119', 'customer', 'general', '2121'),
('4304', '2120', 'cust_branch', 'general', '2122'),
('4305', '2120', 'customer', 'general', '2122'),
('4306', '2121', 'cust_branch', 'general', '2123'),
('4307', '2121', 'customer', 'general', '2123'),
('4308', '2122', 'cust_branch', 'general', '2124'),
('4309', '2122', 'customer', 'general', '2124'),
('4310', '2123', 'cust_branch', 'general', '2125'),
('4311', '2123', 'customer', 'general', '2125'),
('4312', '2124', 'cust_branch', 'general', '2126'),
('4313', '2124', 'customer', 'general', '2126'),
('4314', '2125', 'cust_branch', 'general', '2127'),
('4315', '2125', 'customer', 'general', '2127'),
('4316', '2126', 'cust_branch', 'general', '2128'),
('4317', '2126', 'customer', 'general', '2128'),
('4318', '2127', 'cust_branch', 'general', '2129'),
('4319', '2127', 'customer', 'general', '2129'),
('4320', '2128', 'cust_branch', 'general', '2130'),
('4321', '2128', 'customer', 'general', '2130'),
('4322', '2129', 'cust_branch', 'general', '2131'),
('4323', '2129', 'customer', 'general', '2131'),
('4324', '2130', 'cust_branch', 'general', '2132'),
('4325', '2130', 'customer', 'general', '2132'),
('4326', '2131', 'cust_branch', 'general', '2133'),
('4327', '2131', 'customer', 'general', '2133'),
('4328', '2132', 'cust_branch', 'general', '2134'),
('4329', '2132', 'customer', 'general', '2134'),
('4330', '2133', 'cust_branch', 'general', '2135'),
('4331', '2133', 'customer', 'general', '2135'),
('4332', '2134', 'cust_branch', 'general', '2136'),
('4333', '2134', 'customer', 'general', '2136'),
('4334', '2135', 'cust_branch', 'general', '2137'),
('4335', '2135', 'customer', 'general', '2137'),
('4336', '2136', 'cust_branch', 'general', '2138'),
('4337', '2136', 'customer', 'general', '2138'),
('4338', '2137', 'cust_branch', 'general', '2139'),
('4339', '2137', 'customer', 'general', '2139'),
('4340', '2138', 'cust_branch', 'general', '2140'),
('4341', '2138', 'customer', 'general', '2140'),
('4342', '2139', 'cust_branch', 'general', '2141'),
('4343', '2139', 'customer', 'general', '2141'),
('4344', '2140', 'cust_branch', 'general', '2142'),
('4345', '2140', 'customer', 'general', '2142'),
('4346', '2141', 'cust_branch', 'general', '2143'),
('4347', '2141', 'customer', 'general', '2143'),
('4348', '2142', 'cust_branch', 'general', '2144'),
('4349', '2142', 'customer', 'general', '2144'),
('4350', '2143', 'cust_branch', 'general', '2145'),
('4351', '2143', 'customer', 'general', '2145'),
('4352', '2144', 'cust_branch', 'general', '2146'),
('4353', '2144', 'customer', 'general', '2146'),
('4354', '2145', 'cust_branch', 'general', '2147'),
('4355', '2145', 'customer', 'general', '2147'),
('4356', '2146', 'cust_branch', 'general', '2148'),
('4357', '2146', 'customer', 'general', '2148'),
('4358', '2147', 'cust_branch', 'general', '2149'),
('4359', '2147', 'customer', 'general', '2149'),
('4360', '2148', 'cust_branch', 'general', '2150'),
('4361', '2148', 'customer', 'general', '2150'),
('4362', '2149', 'cust_branch', 'general', '2151'),
('4363', '2149', 'customer', 'general', '2151'),
('4364', '2150', 'cust_branch', 'general', '2152'),
('4365', '2150', 'customer', 'general', '2152'),
('4366', '2151', 'cust_branch', 'general', '2153'),
('4367', '2151', 'customer', 'general', '2153'),
('4368', '2152', 'cust_branch', 'general', '2154'),
('4369', '2152', 'customer', 'general', '2154'),
('4370', '2153', 'cust_branch', 'general', '2155'),
('4371', '2153', 'customer', 'general', '2155'),
('4372', '2154', 'cust_branch', 'general', '2156'),
('4373', '2154', 'customer', 'general', '2156'),
('4374', '2155', 'cust_branch', 'general', '2157'),
('4375', '2155', 'customer', 'general', '2157'),
('4376', '2156', 'cust_branch', 'general', '2158'),
('4377', '2156', 'customer', 'general', '2158'),
('4378', '2157', 'cust_branch', 'general', '2159'),
('4379', '2157', 'customer', 'general', '2159'),
('4380', '2158', 'cust_branch', 'general', '2160'),
('4381', '2158', 'customer', 'general', '2160'),
('4382', '2159', 'cust_branch', 'general', '2161'),
('4383', '2159', 'customer', 'general', '2161'),
('4384', '2160', 'cust_branch', 'general', '2162'),
('4385', '2160', 'customer', 'general', '2162'),
('4386', '2161', 'cust_branch', 'general', '2163'),
('4387', '2161', 'customer', 'general', '2163'),
('4388', '2162', 'cust_branch', 'general', '2164'),
('4389', '2162', 'customer', 'general', '2164'),
('4390', '2163', 'cust_branch', 'general', '2165'),
('4391', '2163', 'customer', 'general', '2165'),
('4392', '2164', 'cust_branch', 'general', '2166'),
('4393', '2164', 'customer', 'general', '2166'),
('4394', '2165', 'cust_branch', 'general', '2167'),
('4395', '2165', 'customer', 'general', '2167'),
('4396', '2166', 'cust_branch', 'general', '2168'),
('4397', '2166', 'customer', 'general', '2168'),
('4398', '2167', 'cust_branch', 'general', '2169'),
('4399', '2167', 'customer', 'general', '2169'),
('4400', '2168', 'cust_branch', 'general', '2170'),
('4401', '2168', 'customer', 'general', '2170'),
('4402', '2169', 'cust_branch', 'general', '2171'),
('4403', '2169', 'customer', 'general', '2171'),
('4404', '2170', 'cust_branch', 'general', '2172'),
('4405', '2170', 'customer', 'general', '2172'),
('4406', '2171', 'cust_branch', 'general', '2173'),
('4407', '2171', 'customer', 'general', '2173'),
('4408', '2172', 'cust_branch', 'general', '2174'),
('4409', '2172', 'customer', 'general', '2174'),
('4410', '2173', 'cust_branch', 'general', '2175'),
('4411', '2173', 'customer', 'general', '2175'),
('4412', '2174', 'cust_branch', 'general', '2176'),
('4413', '2174', 'customer', 'general', '2176'),
('4414', '2175', 'cust_branch', 'general', '2177'),
('4415', '2175', 'customer', 'general', '2177'),
('4416', '2176', 'cust_branch', 'general', '2178'),
('4417', '2176', 'customer', 'general', '2178'),
('4418', '2177', 'cust_branch', 'general', '2179'),
('4419', '2177', 'customer', 'general', '2179'),
('4420', '2178', 'cust_branch', 'general', '2180'),
('4421', '2178', 'customer', 'general', '2180'),
('4422', '2179', 'cust_branch', 'general', '2181'),
('4423', '2179', 'customer', 'general', '2181'),
('4424', '2180', 'cust_branch', 'general', '2182'),
('4425', '2180', 'customer', 'general', '2182'),
('4426', '2181', 'cust_branch', 'general', '2183'),
('4427', '2181', 'customer', 'general', '2183'),
('4428', '2182', 'cust_branch', 'general', '2184'),
('4429', '2182', 'customer', 'general', '2184'),
('4430', '2183', 'cust_branch', 'general', '2185'),
('4431', '2183', 'customer', 'general', '2185'),
('4432', '2184', 'cust_branch', 'general', '2186'),
('4433', '2184', 'customer', 'general', '2186'),
('4434', '2185', 'cust_branch', 'general', '2187'),
('4435', '2185', 'customer', 'general', '2187'),
('4436', '2186', 'cust_branch', 'general', '2188'),
('4437', '2186', 'customer', 'general', '2188'),
('4438', '2187', 'cust_branch', 'general', '2189'),
('4439', '2187', 'customer', 'general', '2189'),
('4440', '2188', 'cust_branch', 'general', '2190'),
('4441', '2188', 'customer', 'general', '2190'),
('4442', '2189', 'cust_branch', 'general', '2191'),
('4443', '2189', 'customer', 'general', '2191'),
('4444', '2190', 'cust_branch', 'general', '2192'),
('4445', '2190', 'customer', 'general', '2192'),
('4446', '2191', 'cust_branch', 'general', '2193'),
('4447', '2191', 'customer', 'general', '2193'),
('4448', '2192', 'cust_branch', 'general', '2194'),
('4449', '2192', 'customer', 'general', '2194'),
('4450', '2193', 'cust_branch', 'general', '2195'),
('4451', '2193', 'customer', 'general', '2195'),
('4452', '2194', 'cust_branch', 'general', '2196'),
('4453', '2194', 'customer', 'general', '2196'),
('4454', '2195', 'cust_branch', 'general', '2197'),
('4455', '2195', 'customer', 'general', '2197'),
('4456', '2196', 'cust_branch', 'general', '2198'),
('4457', '2196', 'customer', 'general', '2198'),
('4458', '2197', 'cust_branch', 'general', '2199'),
('4459', '2197', 'customer', 'general', '2199'),
('4460', '2198', 'cust_branch', 'general', '2200'),
('4461', '2198', 'customer', 'general', '2200'),
('4462', '2199', 'cust_branch', 'general', '2201'),
('4463', '2199', 'customer', 'general', '2201'),
('4464', '2200', 'cust_branch', 'general', '2202'),
('4465', '2200', 'customer', 'general', '2202'),
('4466', '2201', 'cust_branch', 'general', '2203'),
('4467', '2201', 'customer', 'general', '2203'),
('4468', '2202', 'cust_branch', 'general', '2204'),
('4469', '2202', 'customer', 'general', '2204'),
('4470', '2203', 'cust_branch', 'general', '2205'),
('4471', '2203', 'customer', 'general', '2205'),
('4472', '2204', 'cust_branch', 'general', '2206'),
('4473', '2204', 'customer', 'general', '2206'),
('4474', '2205', 'cust_branch', 'general', '2207'),
('4475', '2205', 'customer', 'general', '2207'),
('4476', '2206', 'cust_branch', 'general', '2208'),
('4477', '2206', 'customer', 'general', '2208'),
('4478', '2207', 'cust_branch', 'general', '2209'),
('4479', '2207', 'customer', 'general', '2209'),
('4480', '2208', 'cust_branch', 'general', '2210'),
('4481', '2208', 'customer', 'general', '2210'),
('4482', '2209', 'cust_branch', 'general', '2211'),
('4483', '2209', 'customer', 'general', '2211'),
('4484', '2210', 'cust_branch', 'general', '2212'),
('4485', '2210', 'customer', 'general', '2212'),
('4486', '2211', 'cust_branch', 'general', '2213'),
('4487', '2211', 'customer', 'general', '2213'),
('4488', '2212', 'cust_branch', 'general', '2214'),
('4489', '2212', 'customer', 'general', '2214'),
('4490', '2213', 'cust_branch', 'general', '2215'),
('4491', '2213', 'customer', 'general', '2215'),
('4492', '2214', 'cust_branch', 'general', '2216'),
('4493', '2214', 'customer', 'general', '2216'),
('4494', '2215', 'cust_branch', 'general', '2217'),
('4495', '2215', 'customer', 'general', '2217'),
('4496', '2216', 'cust_branch', 'general', '2218'),
('4497', '2216', 'customer', 'general', '2218'),
('4498', '2217', 'cust_branch', 'general', '2219'),
('4499', '2217', 'customer', 'general', '2219'),
('4500', '2218', 'cust_branch', 'general', '2220'),
('4501', '2218', 'customer', 'general', '2220'),
('4502', '2219', 'cust_branch', 'general', '2221'),
('4503', '2219', 'customer', 'general', '2221'),
('4504', '2220', 'cust_branch', 'general', '2222'),
('4505', '2220', 'customer', 'general', '2222'),
('4506', '2221', 'cust_branch', 'general', '2223'),
('4507', '2221', 'customer', 'general', '2223'),
('4508', '2222', 'cust_branch', 'general', '2224'),
('4509', '2222', 'customer', 'general', '2224'),
('4510', '2223', 'cust_branch', 'general', '2225'),
('4511', '2223', 'customer', 'general', '2225'),
('4512', '2224', 'cust_branch', 'general', '2226'),
('4513', '2224', 'customer', 'general', '2226'),
('4514', '2225', 'cust_branch', 'general', '2227'),
('4515', '2225', 'customer', 'general', '2227'),
('4516', '2226', 'cust_branch', 'general', '2228'),
('4517', '2226', 'customer', 'general', '2228'),
('4518', '2227', 'cust_branch', 'general', '2229'),
('4519', '2227', 'customer', 'general', '2229'),
('4520', '2228', 'cust_branch', 'general', '2230'),
('4521', '2228', 'customer', 'general', '2230'),
('4522', '2229', 'cust_branch', 'general', '2231'),
('4523', '2229', 'customer', 'general', '2231'),
('4524', '2230', 'cust_branch', 'general', '2232'),
('4525', '2230', 'customer', 'general', '2232'),
('4526', '2231', 'cust_branch', 'general', '2233'),
('4527', '2231', 'customer', 'general', '2233'),
('4528', '2232', 'cust_branch', 'general', '2234'),
('4529', '2232', 'customer', 'general', '2234'),
('4530', '2233', 'cust_branch', 'general', '2235'),
('4531', '2233', 'customer', 'general', '2235'),
('4532', '2234', 'cust_branch', 'general', '2236'),
('4533', '2234', 'customer', 'general', '2236'),
('4534', '2235', 'cust_branch', 'general', '2237'),
('4535', '2235', 'customer', 'general', '2237'),
('4536', '2236', 'cust_branch', 'general', '2238'),
('4537', '2236', 'customer', 'general', '2238'),
('4538', '2237', 'cust_branch', 'general', '2239'),
('4539', '2237', 'customer', 'general', '2239'),
('4540', '2238', 'cust_branch', 'general', '2240'),
('4541', '2238', 'customer', 'general', '2240'),
('4542', '2239', 'cust_branch', 'general', '2241'),
('4543', '2239', 'customer', 'general', '2241'),
('4544', '2240', 'cust_branch', 'general', '2242'),
('4545', '2240', 'customer', 'general', '2242'),
('4546', '2241', 'cust_branch', 'general', '2243'),
('4547', '2241', 'customer', 'general', '2243'),
('4548', '2242', 'cust_branch', 'general', '2244'),
('4549', '2242', 'customer', 'general', '2244'),
('4550', '2243', 'cust_branch', 'general', '2245'),
('4551', '2243', 'customer', 'general', '2245'),
('4552', '2244', 'cust_branch', 'general', '2246'),
('4553', '2244', 'customer', 'general', '2246'),
('4554', '2245', 'cust_branch', 'general', '2247'),
('4555', '2245', 'customer', 'general', '2247'),
('4556', '2246', 'cust_branch', 'general', '2248'),
('4557', '2246', 'customer', 'general', '2248'),
('4558', '2247', 'cust_branch', 'general', '2249'),
('4559', '2247', 'customer', 'general', '2249'),
('4560', '2248', 'cust_branch', 'general', '2250'),
('4561', '2248', 'customer', 'general', '2250'),
('4562', '2249', 'cust_branch', 'general', '2251'),
('4563', '2249', 'customer', 'general', '2251'),
('4564', '2250', 'cust_branch', 'general', '2252'),
('4565', '2250', 'customer', 'general', '2252'),
('4566', '2251', 'cust_branch', 'general', '2253'),
('4567', '2251', 'customer', 'general', '2253'),
('4568', '2252', 'cust_branch', 'general', '2254'),
('4569', '2252', 'customer', 'general', '2254'),
('4570', '2253', 'cust_branch', 'general', '2255'),
('4571', '2253', 'customer', 'general', '2255'),
('4572', '2254', 'cust_branch', 'general', '2256'),
('4573', '2254', 'customer', 'general', '2256'),
('4574', '2255', 'cust_branch', 'general', '2257'),
('4575', '2255', 'customer', 'general', '2257'),
('4576', '2256', 'cust_branch', 'general', '2258'),
('4577', '2256', 'customer', 'general', '2258'),
('4578', '2257', 'cust_branch', 'general', '2259'),
('4579', '2257', 'customer', 'general', '2259'),
('4580', '2258', 'cust_branch', 'general', '2260'),
('4581', '2258', 'customer', 'general', '2260'),
('4582', '2259', 'cust_branch', 'general', '2261'),
('4583', '2259', 'customer', 'general', '2261'),
('4584', '2260', 'cust_branch', 'general', '2262'),
('4585', '2260', 'customer', 'general', '2262'),
('4586', '2261', 'cust_branch', 'general', '2263'),
('4587', '2261', 'customer', 'general', '2263'),
('4588', '2262', 'cust_branch', 'general', '2264'),
('4589', '2262', 'customer', 'general', '2264'),
('4590', '2263', 'cust_branch', 'general', '2265'),
('4591', '2263', 'customer', 'general', '2265'),
('4592', '2264', 'cust_branch', 'general', '2266'),
('4593', '2264', 'customer', 'general', '2266'),
('4594', '2265', 'cust_branch', 'general', '2267'),
('4595', '2265', 'customer', 'general', '2267'),
('4596', '2266', 'cust_branch', 'general', '2268'),
('4597', '2266', 'customer', 'general', '2268'),
('4598', '2267', 'cust_branch', 'general', '2269'),
('4599', '2267', 'customer', 'general', '2269'),
('4600', '2268', 'cust_branch', 'general', '2270'),
('4601', '2268', 'customer', 'general', '2270'),
('4602', '2269', 'cust_branch', 'general', '2271'),
('4603', '2269', 'customer', 'general', '2271'),
('4604', '2270', 'cust_branch', 'general', '2272'),
('4605', '2270', 'customer', 'general', '2272'),
('4606', '2271', 'cust_branch', 'general', '2273'),
('4607', '2271', 'customer', 'general', '2273'),
('4608', '2272', 'cust_branch', 'general', '2274'),
('4609', '2272', 'customer', 'general', '2274'),
('4610', '2273', 'cust_branch', 'general', '2275'),
('4611', '2273', 'customer', 'general', '2275'),
('4612', '2274', 'cust_branch', 'general', '2276'),
('4613', '2274', 'customer', 'general', '2276'),
('4614', '2275', 'cust_branch', 'general', '2277'),
('4615', '2275', 'customer', 'general', '2277'),
('4616', '2276', 'cust_branch', 'general', '2278'),
('4617', '2276', 'customer', 'general', '2278'),
('4618', '2277', 'cust_branch', 'general', '2279'),
('4619', '2277', 'customer', 'general', '2279'),
('4620', '2278', 'cust_branch', 'general', '2280'),
('4621', '2278', 'customer', 'general', '2280'),
('4622', '2279', 'cust_branch', 'general', '2281'),
('4623', '2279', 'customer', 'general', '2281'),
('4624', '2280', 'cust_branch', 'general', '2282'),
('4625', '2280', 'customer', 'general', '2282'),
('4626', '2281', 'cust_branch', 'general', '2283'),
('4627', '2281', 'customer', 'general', '2283'),
('4628', '2282', 'cust_branch', 'general', '2284'),
('4629', '2282', 'customer', 'general', '2284'),
('4630', '2283', 'cust_branch', 'general', '2285'),
('4631', '2283', 'customer', 'general', '2285'),
('4632', '2284', 'cust_branch', 'general', '2286'),
('4633', '2284', 'customer', 'general', '2286'),
('4634', '2285', 'cust_branch', 'general', '2287'),
('4635', '2285', 'customer', 'general', '2287'),
('4636', '2286', 'cust_branch', 'general', '2288'),
('4637', '2286', 'customer', 'general', '2288'),
('4638', '2287', 'cust_branch', 'general', '2289'),
('4639', '2287', 'customer', 'general', '2289'),
('4640', '2288', 'cust_branch', 'general', '2290'),
('4641', '2288', 'customer', 'general', '2290'),
('4642', '2289', 'cust_branch', 'general', '2291'),
('4643', '2289', 'customer', 'general', '2291'),
('4644', '2290', 'cust_branch', 'general', '2292'),
('4645', '2290', 'customer', 'general', '2292'),
('4646', '2291', 'cust_branch', 'general', '2293'),
('4647', '2291', 'customer', 'general', '2293'),
('4648', '2292', 'cust_branch', 'general', '2294'),
('4649', '2292', 'customer', 'general', '2294'),
('4650', '2293', 'cust_branch', 'general', '2295'),
('4651', '2293', 'customer', 'general', '2295'),
('4652', '2294', 'cust_branch', 'general', '2296'),
('4653', '2294', 'customer', 'general', '2296'),
('4654', '2295', 'cust_branch', 'general', '2297'),
('4655', '2295', 'customer', 'general', '2297'),
('4656', '2296', 'cust_branch', 'general', '2298'),
('4657', '2296', 'customer', 'general', '2298'),
('4658', '2297', 'cust_branch', 'general', '2299'),
('4659', '2297', 'customer', 'general', '2299'),
('4660', '2298', 'cust_branch', 'general', '2300'),
('4661', '2298', 'customer', 'general', '2300'),
('4662', '2299', 'cust_branch', 'general', '2301'),
('4663', '2299', 'customer', 'general', '2301'),
('4664', '2300', 'cust_branch', 'general', '2302'),
('4665', '2300', 'customer', 'general', '2302'),
('4666', '2301', 'cust_branch', 'general', '2303'),
('4667', '2301', 'customer', 'general', '2303'),
('4668', '2302', 'cust_branch', 'general', '2304'),
('4669', '2302', 'customer', 'general', '2304'),
('4670', '2303', 'cust_branch', 'general', '2305'),
('4671', '2303', 'customer', 'general', '2305'),
('4672', '2304', 'cust_branch', 'general', '2306'),
('4673', '2304', 'customer', 'general', '2306'),
('4674', '2305', 'cust_branch', 'general', '2307'),
('4675', '2305', 'customer', 'general', '2307'),
('4676', '2306', 'cust_branch', 'general', '2308'),
('4677', '2306', 'customer', 'general', '2308'),
('4678', '2307', 'cust_branch', 'general', '2309'),
('4679', '2307', 'customer', 'general', '2309'),
('4680', '2308', 'cust_branch', 'general', '2310'),
('4681', '2308', 'customer', 'general', '2310'),
('4682', '2309', 'cust_branch', 'general', '2311'),
('4683', '2309', 'customer', 'general', '2311'),
('4684', '2310', 'cust_branch', 'general', '2312'),
('4685', '2310', 'customer', 'general', '2312'),
('4686', '2311', 'cust_branch', 'general', '2313'),
('4687', '2311', 'customer', 'general', '2313'),
('4688', '2312', 'cust_branch', 'general', '2314'),
('4689', '2312', 'customer', 'general', '2314'),
('4690', '2313', 'cust_branch', 'general', '2315'),
('4691', '2313', 'customer', 'general', '2315'),
('4692', '2314', 'cust_branch', 'general', '2316'),
('4693', '2314', 'customer', 'general', '2316'),
('4694', '2315', 'cust_branch', 'general', '2317'),
('4695', '2315', 'customer', 'general', '2317'),
('4696', '2316', 'cust_branch', 'general', '2318'),
('4697', '2316', 'customer', 'general', '2318'),
('4698', '2317', 'cust_branch', 'general', '2319'),
('4699', '2317', 'customer', 'general', '2319'),
('4700', '2318', 'cust_branch', 'general', '2320'),
('4701', '2318', 'customer', 'general', '2320'),
('4702', '2319', 'cust_branch', 'general', '2321'),
('4703', '2319', 'customer', 'general', '2321'),
('4704', '2320', 'cust_branch', 'general', '2322'),
('4705', '2320', 'customer', 'general', '2322'),
('4706', '2321', 'cust_branch', 'general', '2323'),
('4707', '2321', 'customer', 'general', '2323'),
('4708', '2322', 'cust_branch', 'general', '2324'),
('4709', '2322', 'customer', 'general', '2324'),
('4710', '2323', 'cust_branch', 'general', '2325'),
('4711', '2323', 'customer', 'general', '2325'),
('4712', '2324', 'cust_branch', 'general', '2326'),
('4713', '2324', 'customer', 'general', '2326'),
('4714', '2325', 'cust_branch', 'general', '2327'),
('4715', '2325', 'customer', 'general', '2327'),
('4716', '2326', 'cust_branch', 'general', '2328'),
('4717', '2326', 'customer', 'general', '2328'),
('4718', '2327', 'cust_branch', 'general', '2329'),
('4719', '2327', 'customer', 'general', '2329'),
('4720', '2328', 'cust_branch', 'general', '2330'),
('4721', '2328', 'customer', 'general', '2330'),
('4722', '2329', 'cust_branch', 'general', '2331'),
('4723', '2329', 'customer', 'general', '2331'),
('4724', '2330', 'cust_branch', 'general', '2332'),
('4725', '2330', 'customer', 'general', '2332'),
('4726', '2331', 'cust_branch', 'general', '2333'),
('4727', '2331', 'customer', 'general', '2333'),
('4728', '2332', 'cust_branch', 'general', '2334'),
('4729', '2332', 'customer', 'general', '2334'),
('4730', '2333', 'cust_branch', 'general', '2335'),
('4731', '2333', 'customer', 'general', '2335'),
('4732', '2334', 'cust_branch', 'general', '2336'),
('4733', '2334', 'customer', 'general', '2336'),
('4734', '2335', 'cust_branch', 'general', '2337'),
('4735', '2335', 'customer', 'general', '2337'),
('4736', '2336', 'cust_branch', 'general', '2338'),
('4737', '2336', 'customer', 'general', '2338'),
('4738', '2337', 'cust_branch', 'general', '2339'),
('4739', '2337', 'customer', 'general', '2339'),
('4740', '2338', 'cust_branch', 'general', '2340'),
('4741', '2338', 'customer', 'general', '2340'),
('4742', '2339', 'cust_branch', 'general', '2341'),
('4743', '2339', 'customer', 'general', '2341'),
('4744', '2340', 'cust_branch', 'general', '2342'),
('4745', '2340', 'customer', 'general', '2342'),
('4746', '2341', 'cust_branch', 'general', '2343'),
('4747', '2341', 'customer', 'general', '2343'),
('4748', '2342', 'cust_branch', 'general', '2344'),
('4749', '2342', 'customer', 'general', '2344'),
('4750', '2343', 'cust_branch', 'general', '2345'),
('4751', '2343', 'customer', 'general', '2345'),
('4752', '2344', 'cust_branch', 'general', '2346'),
('4753', '2344', 'customer', 'general', '2346'),
('4754', '2345', 'cust_branch', 'general', '2347'),
('4755', '2345', 'customer', 'general', '2347'),
('4756', '2346', 'cust_branch', 'general', '2348'),
('4757', '2346', 'customer', 'general', '2348'),
('4758', '2347', 'cust_branch', 'general', '2349'),
('4759', '2347', 'customer', 'general', '2349'),
('4760', '2348', 'cust_branch', 'general', '2350'),
('4761', '2348', 'customer', 'general', '2350'),
('4762', '2349', 'cust_branch', 'general', '2351'),
('4763', '2349', 'customer', 'general', '2351'),
('4764', '2350', 'cust_branch', 'general', '2352'),
('4765', '2350', 'customer', 'general', '2352'),
('4766', '2351', 'cust_branch', 'general', '2353'),
('4767', '2351', 'customer', 'general', '2353'),
('4768', '2352', 'cust_branch', 'general', '2354'),
('4769', '2352', 'customer', 'general', '2354'),
('4770', '2353', 'cust_branch', 'general', '2355'),
('4771', '2353', 'customer', 'general', '2355'),
('4772', '2354', 'cust_branch', 'general', '2356'),
('4773', '2354', 'customer', 'general', '2356'),
('4774', '2355', 'cust_branch', 'general', '2357'),
('4775', '2355', 'customer', 'general', '2357'),
('4776', '2356', 'cust_branch', 'general', '2358'),
('4777', '2356', 'customer', 'general', '2358'),
('4778', '2357', 'cust_branch', 'general', '2359'),
('4779', '2357', 'customer', 'general', '2359'),
('4780', '2358', 'cust_branch', 'general', '2360'),
('4781', '2358', 'customer', 'general', '2360'),
('4782', '2359', 'cust_branch', 'general', '2361'),
('4783', '2359', 'customer', 'general', '2361'),
('4784', '2360', 'cust_branch', 'general', '2362'),
('4785', '2360', 'customer', 'general', '2362'),
('4786', '2361', 'cust_branch', 'general', '2363'),
('4787', '2361', 'customer', 'general', '2363'),
('4788', '2362', 'cust_branch', 'general', '2364'),
('4789', '2362', 'customer', 'general', '2364'),
('4790', '2363', 'cust_branch', 'general', '2365'),
('4791', '2363', 'customer', 'general', '2365'),
('4792', '2364', 'cust_branch', 'general', '2366'),
('4793', '2364', 'customer', 'general', '2366'),
('4794', '2365', 'cust_branch', 'general', '2367'),
('4795', '2365', 'customer', 'general', '2367'),
('4796', '2366', 'cust_branch', 'general', '2368'),
('4797', '2366', 'customer', 'general', '2368'),
('4798', '2367', 'cust_branch', 'general', '2369'),
('4799', '2367', 'customer', 'general', '2369'),
('4800', '2368', 'cust_branch', 'general', '2370'),
('4801', '2368', 'customer', 'general', '2370'),
('4802', '2369', 'cust_branch', 'general', '2371'),
('4803', '2369', 'customer', 'general', '2371'),
('4804', '2370', 'cust_branch', 'general', '2372'),
('4805', '2370', 'customer', 'general', '2372'),
('4806', '2371', 'cust_branch', 'general', '2373'),
('4807', '2371', 'customer', 'general', '2373'),
('4808', '2372', 'cust_branch', 'general', '2374'),
('4809', '2372', 'customer', 'general', '2374'),
('4810', '2373', 'cust_branch', 'general', '2375'),
('4811', '2373', 'customer', 'general', '2375'),
('4812', '2374', 'cust_branch', 'general', '2376'),
('4813', '2374', 'customer', 'general', '2376'),
('4814', '2375', 'cust_branch', 'general', '2377'),
('4815', '2375', 'customer', 'general', '2377'),
('4816', '2376', 'cust_branch', 'general', '2378'),
('4817', '2376', 'customer', 'general', '2378'),
('4818', '2377', 'cust_branch', 'general', '2379'),
('4819', '2377', 'customer', 'general', '2379'),
('4820', '2378', 'cust_branch', 'general', '2380'),
('4821', '2378', 'customer', 'general', '2380'),
('4822', '2379', 'cust_branch', 'general', '2381'),
('4823', '2379', 'customer', 'general', '2381'),
('4824', '2380', 'cust_branch', 'general', '2382'),
('4825', '2380', 'customer', 'general', '2382'),
('4826', '2381', 'cust_branch', 'general', '2383'),
('4827', '2381', 'customer', 'general', '2383'),
('4828', '2382', 'cust_branch', 'general', '2384'),
('4829', '2382', 'customer', 'general', '2384'),
('4830', '2383', 'cust_branch', 'general', '2385'),
('4831', '2383', 'customer', 'general', '2385'),
('4832', '2384', 'cust_branch', 'general', '2386'),
('4833', '2384', 'customer', 'general', '2386'),
('4834', '2385', 'cust_branch', 'general', '2387'),
('4835', '2385', 'customer', 'general', '2387'),
('4836', '2386', 'cust_branch', 'general', '2388'),
('4837', '2386', 'customer', 'general', '2388'),
('4838', '2387', 'cust_branch', 'general', '2389'),
('4839', '2387', 'customer', 'general', '2389'),
('4840', '2388', 'cust_branch', 'general', '2390'),
('4841', '2388', 'customer', 'general', '2390'),
('4842', '2389', 'cust_branch', 'general', '2391'),
('4843', '2389', 'customer', 'general', '2391'),
('4844', '2390', 'cust_branch', 'general', '2392'),
('4845', '2390', 'customer', 'general', '2392'),
('4846', '2391', 'cust_branch', 'general', '2393'),
('4847', '2391', 'customer', 'general', '2393'),
('4848', '2392', 'cust_branch', 'general', '2394'),
('4849', '2392', 'customer', 'general', '2394'),
('4850', '2393', 'cust_branch', 'general', '2395'),
('4851', '2393', 'customer', 'general', '2395'),
('4852', '2394', 'cust_branch', 'general', '2396'),
('4853', '2394', 'customer', 'general', '2396'),
('4854', '2395', 'cust_branch', 'general', '2397'),
('4855', '2395', 'customer', 'general', '2397'),
('4856', '2396', 'cust_branch', 'general', '2398'),
('4857', '2396', 'customer', 'general', '2398'),
('4858', '2397', 'cust_branch', 'general', '2399'),
('4859', '2397', 'customer', 'general', '2399'),
('4860', '2398', 'cust_branch', 'general', '2400'),
('4861', '2398', 'customer', 'general', '2400'),
('4862', '2399', 'cust_branch', 'general', '2401'),
('4863', '2399', 'customer', 'general', '2401'),
('4864', '2400', 'cust_branch', 'general', '2402'),
('4865', '2400', 'customer', 'general', '2402'),
('4866', '2401', 'cust_branch', 'general', '2403'),
('4867', '2401', 'customer', 'general', '2403'),
('4868', '2402', 'cust_branch', 'general', '2404'),
('4869', '2402', 'customer', 'general', '2404'),
('4870', '2403', 'cust_branch', 'general', '2405'),
('4871', '2403', 'customer', 'general', '2405'),
('4872', '2404', 'cust_branch', 'general', '2406'),
('4873', '2404', 'customer', 'general', '2406'),
('4874', '2405', 'cust_branch', 'general', '2407'),
('4875', '2405', 'customer', 'general', '2407'),
('4876', '2406', 'cust_branch', 'general', '2408'),
('4877', '2406', 'customer', 'general', '2408'),
('4878', '2407', 'cust_branch', 'general', '2409'),
('4879', '2407', 'customer', 'general', '2409'),
('4880', '2408', 'cust_branch', 'general', '2410'),
('4881', '2408', 'customer', 'general', '2410'),
('4882', '2409', 'cust_branch', 'general', '2411'),
('4883', '2409', 'customer', 'general', '2411'),
('4884', '2410', 'cust_branch', 'general', '2412'),
('4885', '2410', 'customer', 'general', '2412'),
('4886', '2411', 'cust_branch', 'general', '2413'),
('4887', '2411', 'customer', 'general', '2413'),
('4888', '2412', 'cust_branch', 'general', '2414'),
('4889', '2412', 'customer', 'general', '2414'),
('4890', '2413', 'cust_branch', 'general', '2415'),
('4891', '2413', 'customer', 'general', '2415'),
('4892', '2414', 'cust_branch', 'general', '2416'),
('4893', '2414', 'customer', 'general', '2416'),
('4894', '2415', 'cust_branch', 'general', '2417'),
('4895', '2415', 'customer', 'general', '2417'),
('4896', '2416', 'cust_branch', 'general', '2418'),
('4897', '2416', 'customer', 'general', '2418'),
('4898', '2417', 'cust_branch', 'general', '2419'),
('4899', '2417', 'customer', 'general', '2419'),
('4900', '2418', 'cust_branch', 'general', '2420'),
('4901', '2418', 'customer', 'general', '2420'),
('4902', '2419', 'cust_branch', 'general', '2421'),
('4903', '2419', 'customer', 'general', '2421'),
('4904', '2420', 'cust_branch', 'general', '2422'),
('4905', '2420', 'customer', 'general', '2422'),
('4906', '2421', 'cust_branch', 'general', '2423'),
('4907', '2421', 'customer', 'general', '2423'),
('4908', '2422', 'cust_branch', 'general', '2424'),
('4909', '2422', 'customer', 'general', '2424'),
('4910', '2423', 'cust_branch', 'general', '2425'),
('4911', '2423', 'customer', 'general', '2425'),
('4912', '2424', 'cust_branch', 'general', '2426'),
('4913', '2424', 'customer', 'general', '2426'),
('4914', '2425', 'cust_branch', 'general', '2427'),
('4915', '2425', 'customer', 'general', '2427'),
('4916', '2426', 'cust_branch', 'general', '2428'),
('4917', '2426', 'customer', 'general', '2428'),
('4918', '2427', 'cust_branch', 'general', '2429'),
('4919', '2427', 'customer', 'general', '2429'),
('4920', '2428', 'cust_branch', 'general', '2430'),
('4921', '2428', 'customer', 'general', '2430'),
('4922', '2429', 'cust_branch', 'general', '2431'),
('4923', '2429', 'customer', 'general', '2431'),
('4924', '2430', 'cust_branch', 'general', '2432'),
('4925', '2430', 'customer', 'general', '2432'),
('4926', '2431', 'cust_branch', 'general', '2433'),
('4927', '2431', 'customer', 'general', '2433'),
('4928', '2432', 'cust_branch', 'general', '2434'),
('4929', '2432', 'customer', 'general', '2434'),
('4930', '2433', 'cust_branch', 'general', '2435'),
('4931', '2433', 'customer', 'general', '2435'),
('4932', '2434', 'cust_branch', 'general', '2436'),
('4933', '2434', 'customer', 'general', '2436'),
('4934', '2435', 'cust_branch', 'general', '2437'),
('4935', '2435', 'customer', 'general', '2437'),
('4936', '2436', 'cust_branch', 'general', '2438'),
('4937', '2436', 'customer', 'general', '2438'),
('4938', '2437', 'cust_branch', 'general', '2439'),
('4939', '2437', 'customer', 'general', '2439'),
('4940', '2438', 'cust_branch', 'general', '2440'),
('4941', '2438', 'customer', 'general', '2440'),
('4942', '2439', 'cust_branch', 'general', '2441'),
('4943', '2439', 'customer', 'general', '2441'),
('4944', '2440', 'cust_branch', 'general', '2442'),
('4945', '2440', 'customer', 'general', '2442'),
('4946', '2441', 'cust_branch', 'general', '2443'),
('4947', '2441', 'customer', 'general', '2443'),
('4948', '2442', 'cust_branch', 'general', '2444'),
('4949', '2442', 'customer', 'general', '2444'),
('4950', '2443', 'cust_branch', 'general', '2445'),
('4951', '2443', 'customer', 'general', '2445'),
('4952', '2444', 'cust_branch', 'general', '2446'),
('4953', '2444', 'customer', 'general', '2446'),
('4954', '2445', 'cust_branch', 'general', '2447'),
('4955', '2445', 'customer', 'general', '2447'),
('4956', '2446', 'cust_branch', 'general', '2448'),
('4957', '2446', 'customer', 'general', '2448'),
('4958', '2447', 'cust_branch', 'general', '2449'),
('4959', '2447', 'customer', 'general', '2449'),
('4960', '2448', 'cust_branch', 'general', '2450'),
('4961', '2448', 'customer', 'general', '2450'),
('4962', '2449', 'cust_branch', 'general', '2451'),
('4963', '2449', 'customer', 'general', '2451'),
('4964', '2450', 'cust_branch', 'general', '2452'),
('4965', '2450', 'customer', 'general', '2452'),
('4966', '2451', 'cust_branch', 'general', '2453'),
('4967', '2451', 'customer', 'general', '2453'),
('4968', '2452', 'cust_branch', 'general', '2454'),
('4969', '2452', 'customer', 'general', '2454'),
('4970', '2453', 'cust_branch', 'general', '2455'),
('4971', '2453', 'customer', 'general', '2455'),
('4972', '2454', 'cust_branch', 'general', '2456'),
('4973', '2454', 'customer', 'general', '2456'),
('4974', '2455', 'cust_branch', 'general', '2457'),
('4975', '2455', 'customer', 'general', '2457'),
('4976', '2456', 'cust_branch', 'general', '2458'),
('4977', '2456', 'customer', 'general', '2458'),
('4978', '2457', 'cust_branch', 'general', '2459'),
('4979', '2457', 'customer', 'general', '2459'),
('4980', '2458', 'cust_branch', 'general', '2460'),
('4981', '2458', 'customer', 'general', '2460'),
('4982', '2459', 'cust_branch', 'general', '2461'),
('4983', '2459', 'customer', 'general', '2461'),
('4984', '2460', 'cust_branch', 'general', '2462'),
('4985', '2460', 'customer', 'general', '2462'),
('4986', '2461', 'cust_branch', 'general', '2463'),
('4987', '2461', 'customer', 'general', '2463'),
('4988', '2462', 'cust_branch', 'general', '2464'),
('4989', '2462', 'customer', 'general', '2464'),
('4990', '2463', 'cust_branch', 'general', '2465'),
('4991', '2463', 'customer', 'general', '2465'),
('4992', '2464', 'cust_branch', 'general', '2466'),
('4993', '2464', 'customer', 'general', '2466'),
('4994', '2465', 'cust_branch', 'general', '2467'),
('4995', '2465', 'customer', 'general', '2467'),
('4996', '2466', 'cust_branch', 'general', '2468'),
('4997', '2466', 'customer', 'general', '2468'),
('4998', '2467', 'cust_branch', 'general', '2469'),
('4999', '2467', 'customer', 'general', '2469'),
('5000', '2468', 'cust_branch', 'general', '2470'),
('5001', '2468', 'customer', 'general', '2470'),
('5002', '2469', 'cust_branch', 'general', '2471'),
('5003', '2469', 'customer', 'general', '2471'),
('5004', '2470', 'cust_branch', 'general', '2472'),
('5005', '2470', 'customer', 'general', '2472'),
('5006', '2471', 'cust_branch', 'general', '2473'),
('5007', '2471', 'customer', 'general', '2473'),
('5008', '2472', 'cust_branch', 'general', '2474'),
('5009', '2472', 'customer', 'general', '2474'),
('5010', '2473', 'cust_branch', 'general', '2475'),
('5011', '2473', 'customer', 'general', '2475'),
('5012', '2474', 'cust_branch', 'general', '2476'),
('5013', '2474', 'customer', 'general', '2476'),
('5014', '2475', 'cust_branch', 'general', '2477'),
('5015', '2475', 'customer', 'general', '2477'),
('5016', '2476', 'cust_branch', 'general', '2478'),
('5017', '2476', 'customer', 'general', '2478'),
('5018', '2477', 'cust_branch', 'general', '2479'),
('5019', '2477', 'customer', 'general', '2479'),
('5020', '2478', 'cust_branch', 'general', '2480'),
('5021', '2478', 'customer', 'general', '2480'),
('5022', '2479', 'cust_branch', 'general', '2481'),
('5023', '2479', 'customer', 'general', '2481'),
('5024', '2480', 'cust_branch', 'general', '2482'),
('5025', '2480', 'customer', 'general', '2482'),
('5026', '2481', 'cust_branch', 'general', '2483'),
('5027', '2481', 'customer', 'general', '2483'),
('5028', '2482', 'cust_branch', 'general', '2484'),
('5029', '2482', 'customer', 'general', '2484'),
('5030', '2483', 'cust_branch', 'general', '2485'),
('5031', '2483', 'customer', 'general', '2485'),
('5032', '2484', 'cust_branch', 'general', '2486'),
('5033', '2484', 'customer', 'general', '2486'),
('5034', '2485', 'cust_branch', 'general', '2487'),
('5035', '2485', 'customer', 'general', '2487'),
('5036', '2486', 'cust_branch', 'general', '2488'),
('5037', '2486', 'customer', 'general', '2488'),
('5038', '2487', 'cust_branch', 'general', '2489'),
('5039', '2487', 'customer', 'general', '2489'),
('5040', '2488', 'cust_branch', 'general', '2490'),
('5041', '2488', 'customer', 'general', '2490'),
('5042', '2489', 'cust_branch', 'general', '2491'),
('5043', '2489', 'customer', 'general', '2491'),
('5044', '2490', 'cust_branch', 'general', '2492'),
('5045', '2490', 'customer', 'general', '2492'),
('5046', '2491', 'cust_branch', 'general', '2493'),
('5047', '2491', 'customer', 'general', '2493'),
('5048', '2492', 'cust_branch', 'general', '2494'),
('5049', '2492', 'customer', 'general', '2494'),
('5050', '2493', 'cust_branch', 'general', '2495'),
('5051', '2493', 'customer', 'general', '2495'),
('5052', '2494', 'cust_branch', 'general', '2496'),
('5053', '2494', 'customer', 'general', '2496'),
('5054', '2495', 'cust_branch', 'general', '2497'),
('5055', '2495', 'customer', 'general', '2497'),
('5056', '2496', 'cust_branch', 'general', '2498'),
('5057', '2496', 'customer', 'general', '2498'),
('5058', '2497', 'cust_branch', 'general', '2499'),
('5059', '2497', 'customer', 'general', '2499'),
('5060', '2498', 'cust_branch', 'general', '2500'),
('5061', '2498', 'customer', 'general', '2500'),
('5062', '2499', 'cust_branch', 'general', '2501'),
('5063', '2499', 'customer', 'general', '2501'),
('5064', '2500', 'cust_branch', 'general', '2502'),
('5065', '2500', 'customer', 'general', '2502'),
('5066', '2501', 'cust_branch', 'general', '2503'),
('5067', '2501', 'customer', 'general', '2503'),
('5068', '2502', 'cust_branch', 'general', '2504'),
('5069', '2502', 'customer', 'general', '2504'),
('5070', '2503', 'cust_branch', 'general', '2505'),
('5071', '2503', 'customer', 'general', '2505'),
('5072', '2504', 'cust_branch', 'general', '2506'),
('5073', '2504', 'customer', 'general', '2506'),
('5074', '2505', 'cust_branch', 'general', '2507'),
('5075', '2505', 'customer', 'general', '2507'),
('5076', '2506', 'cust_branch', 'general', '2508'),
('5077', '2506', 'customer', 'general', '2508'),
('5078', '2507', 'cust_branch', 'general', '2509'),
('5079', '2507', 'customer', 'general', '2509'),
('5080', '2508', 'cust_branch', 'general', '2510'),
('5081', '2508', 'customer', 'general', '2510'),
('5082', '2509', 'cust_branch', 'general', '2511'),
('5083', '2509', 'customer', 'general', '2511'),
('5084', '2510', 'cust_branch', 'general', '2512'),
('5085', '2510', 'customer', 'general', '2512'),
('5086', '2511', 'cust_branch', 'general', '2513'),
('5087', '2511', 'customer', 'general', '2513'),
('5088', '2512', 'cust_branch', 'general', '2514'),
('5089', '2512', 'customer', 'general', '2514'),
('5090', '2513', 'cust_branch', 'general', '2515'),
('5091', '2513', 'customer', 'general', '2515'),
('5092', '2514', 'cust_branch', 'general', '2516'),
('5093', '2514', 'customer', 'general', '2516'),
('5094', '2515', 'cust_branch', 'general', '2517'),
('5095', '2515', 'customer', 'general', '2517'),
('5096', '2516', 'cust_branch', 'general', '2518'),
('5097', '2516', 'customer', 'general', '2518'),
('5098', '2517', 'cust_branch', 'general', '2519'),
('5099', '2517', 'customer', 'general', '2519'),
('5100', '2518', 'cust_branch', 'general', '2520'),
('5101', '2518', 'customer', 'general', '2520'),
('5102', '2519', 'cust_branch', 'general', '2521'),
('5103', '2519', 'customer', 'general', '2521'),
('5104', '2520', 'cust_branch', 'general', '2522'),
('5105', '2520', 'customer', 'general', '2522'),
('5106', '2521', 'cust_branch', 'general', '2523'),
('5107', '2521', 'customer', 'general', '2523'),
('5108', '2522', 'cust_branch', 'general', '2524'),
('5109', '2522', 'customer', 'general', '2524'),
('5110', '2523', 'cust_branch', 'general', '2525'),
('5111', '2523', 'customer', 'general', '2525'),
('5112', '2524', 'cust_branch', 'general', '2526'),
('5113', '2524', 'customer', 'general', '2526'),
('5114', '2525', 'cust_branch', 'general', '2527'),
('5115', '2525', 'customer', 'general', '2527'),
('5116', '2526', 'cust_branch', 'general', '2528'),
('5117', '2526', 'customer', 'general', '2528'),
('5118', '2527', 'cust_branch', 'general', '2529'),
('5119', '2527', 'customer', 'general', '2529'),
('5120', '2528', 'cust_branch', 'general', '2530'),
('5121', '2528', 'customer', 'general', '2530'),
('5122', '2529', 'cust_branch', 'general', '2531'),
('5123', '2529', 'customer', 'general', '2531'),
('5124', '2530', 'cust_branch', 'general', '2532'),
('5125', '2530', 'customer', 'general', '2532'),
('5126', '2531', 'cust_branch', 'general', '2533'),
('5127', '2531', 'customer', 'general', '2533'),
('5128', '2532', 'cust_branch', 'general', '2534'),
('5129', '2532', 'customer', 'general', '2534'),
('5130', '2533', 'cust_branch', 'general', '2535'),
('5131', '2533', 'customer', 'general', '2535'),
('5132', '2534', 'cust_branch', 'general', '2536'),
('5133', '2534', 'customer', 'general', '2536'),
('5134', '2535', 'cust_branch', 'general', '2537'),
('5135', '2535', 'customer', 'general', '2537'),
('5136', '2536', 'cust_branch', 'general', '2538'),
('5137', '2536', 'customer', 'general', '2538'),
('5138', '2537', 'cust_branch', 'general', '2539'),
('5139', '2537', 'customer', 'general', '2539'),
('5140', '2538', 'cust_branch', 'general', '2540'),
('5141', '2538', 'customer', 'general', '2540'),
('5142', '2539', 'cust_branch', 'general', '2541'),
('5143', '2539', 'customer', 'general', '2541'),
('5144', '2540', 'cust_branch', 'general', '2542'),
('5145', '2540', 'customer', 'general', '2542'),
('5146', '2541', 'cust_branch', 'general', '2543'),
('5147', '2541', 'customer', 'general', '2543'),
('5148', '2542', 'cust_branch', 'general', '2544'),
('5149', '2542', 'customer', 'general', '2544'),
('5150', '2543', 'cust_branch', 'general', '2545'),
('5151', '2543', 'customer', 'general', '2545'),
('5152', '2544', 'cust_branch', 'general', '2546'),
('5153', '2544', 'customer', 'general', '2546'),
('5154', '2545', 'cust_branch', 'general', '2547'),
('5155', '2545', 'customer', 'general', '2547'),
('5156', '2546', 'cust_branch', 'general', '2548'),
('5157', '2546', 'customer', 'general', '2548'),
('5158', '2547', 'cust_branch', 'general', '2549'),
('5159', '2547', 'customer', 'general', '2549'),
('5160', '2548', 'cust_branch', 'general', '2550'),
('5161', '2548', 'customer', 'general', '2550'),
('5162', '2549', 'cust_branch', 'general', '2551'),
('5163', '2549', 'customer', 'general', '2551'),
('5164', '2550', 'cust_branch', 'general', '2552'),
('5165', '2550', 'customer', 'general', '2552'),
('5166', '2551', 'cust_branch', 'general', '2553'),
('5167', '2551', 'customer', 'general', '2553'),
('5168', '2552', 'cust_branch', 'general', '2554'),
('5169', '2552', 'customer', 'general', '2554'),
('5170', '2553', 'cust_branch', 'general', '2555'),
('5171', '2553', 'customer', 'general', '2555'),
('5172', '2554', 'cust_branch', 'general', '2556'),
('5173', '2554', 'customer', 'general', '2556'),
('5174', '2555', 'cust_branch', 'general', '2557'),
('5175', '2555', 'customer', 'general', '2557'),
('5176', '2556', 'cust_branch', 'general', '2558'),
('5177', '2556', 'customer', 'general', '2558'),
('5178', '2557', 'cust_branch', 'general', '2559'),
('5179', '2557', 'customer', 'general', '2559'),
('5180', '2558', 'cust_branch', 'general', '2560'),
('5181', '2558', 'customer', 'general', '2560'),
('5182', '2559', 'cust_branch', 'general', '2561'),
('5183', '2559', 'customer', 'general', '2561'),
('5184', '2560', 'cust_branch', 'general', '2562'),
('5185', '2560', 'customer', 'general', '2562'),
('5186', '2561', 'cust_branch', 'general', '2563'),
('5187', '2561', 'customer', 'general', '2563'),
('5188', '2562', 'cust_branch', 'general', '2564'),
('5189', '2562', 'customer', 'general', '2564'),
('5190', '2563', 'cust_branch', 'general', '2565'),
('5191', '2563', 'customer', 'general', '2565'),
('5192', '2564', 'cust_branch', 'general', '2566'),
('5193', '2564', 'customer', 'general', '2566'),
('5194', '2565', 'cust_branch', 'general', '2567'),
('5195', '2565', 'customer', 'general', '2567'),
('5196', '2566', 'cust_branch', 'general', '2568'),
('5197', '2566', 'customer', 'general', '2568'),
('5198', '2567', 'cust_branch', 'general', '2569'),
('5199', '2567', 'customer', 'general', '2569'),
('5200', '2568', 'cust_branch', 'general', '2570'),
('5201', '2568', 'customer', 'general', '2570'),
('5202', '2569', 'cust_branch', 'general', '2571'),
('5203', '2569', 'customer', 'general', '2571'),
('5204', '2570', 'cust_branch', 'general', '2572'),
('5205', '2570', 'customer', 'general', '2572'),
('5206', '2571', 'cust_branch', 'general', '2573'),
('5207', '2571', 'customer', 'general', '2573'),
('5208', '2572', 'cust_branch', 'general', '2574'),
('5209', '2572', 'customer', 'general', '2574'),
('5210', '2573', 'cust_branch', 'general', '2575'),
('5211', '2573', 'customer', 'general', '2575'),
('5212', '2574', 'cust_branch', 'general', '2576'),
('5213', '2574', 'customer', 'general', '2576'),
('5214', '2575', 'cust_branch', 'general', '2577'),
('5215', '2575', 'customer', 'general', '2577'),
('5216', '2576', 'cust_branch', 'general', '2578'),
('5217', '2576', 'customer', 'general', '2578'),
('5218', '2577', 'cust_branch', 'general', '2579'),
('5219', '2577', 'customer', 'general', '2579'),
('5220', '2578', 'cust_branch', 'general', '2580'),
('5221', '2578', 'customer', 'general', '2580'),
('5222', '2579', 'cust_branch', 'general', '2581'),
('5223', '2579', 'customer', 'general', '2581'),
('5224', '2580', 'cust_branch', 'general', '2582'),
('5225', '2580', 'customer', 'general', '2582'),
('5226', '2581', 'cust_branch', 'general', '2583'),
('5227', '2581', 'customer', 'general', '2583'),
('5228', '2582', 'cust_branch', 'general', '2584'),
('5229', '2582', 'customer', 'general', '2584'),
('5230', '2583', 'cust_branch', 'general', '2585'),
('5231', '2583', 'customer', 'general', '2585'),
('5232', '2584', 'cust_branch', 'general', '2586'),
('5233', '2584', 'customer', 'general', '2586'),
('5234', '2585', 'cust_branch', 'general', '2587'),
('5235', '2585', 'customer', 'general', '2587'),
('5236', '2586', 'cust_branch', 'general', '2588'),
('5237', '2586', 'customer', 'general', '2588'),
('5238', '2587', 'cust_branch', 'general', '2589'),
('5239', '2587', 'customer', 'general', '2589'),
('5240', '2588', 'cust_branch', 'general', '2590'),
('5241', '2588', 'customer', 'general', '2590'),
('5242', '2589', 'cust_branch', 'general', '2591'),
('5243', '2589', 'customer', 'general', '2591'),
('5244', '2590', 'cust_branch', 'general', '2592'),
('5245', '2590', 'customer', 'general', '2592'),
('5246', '2591', 'cust_branch', 'general', '2593'),
('5247', '2591', 'customer', 'general', '2593'),
('5248', '2592', 'cust_branch', 'general', '2594'),
('5249', '2592', 'customer', 'general', '2594'),
('5250', '2593', 'cust_branch', 'general', '2595'),
('5251', '2593', 'customer', 'general', '2595'),
('5252', '2594', 'cust_branch', 'general', '2596'),
('5253', '2594', 'customer', 'general', '2596'),
('5254', '2595', 'cust_branch', 'general', '2597'),
('5255', '2595', 'customer', 'general', '2597'),
('5256', '2596', 'cust_branch', 'general', '2598'),
('5257', '2596', 'customer', 'general', '2598'),
('5258', '2597', 'cust_branch', 'general', '2599'),
('5259', '2597', 'customer', 'general', '2599'),
('5260', '2598', 'cust_branch', 'general', '2600'),
('5261', '2598', 'customer', 'general', '2600'),
('5262', '2599', 'cust_branch', 'general', '2601'),
('5263', '2599', 'customer', 'general', '2601'),
('5264', '2600', 'cust_branch', 'general', '2602'),
('5265', '2600', 'customer', 'general', '2602'),
('5266', '2601', 'cust_branch', 'general', '2603'),
('5267', '2601', 'customer', 'general', '2603'),
('5268', '2602', 'cust_branch', 'general', '2604'),
('5269', '2602', 'customer', 'general', '2604'),
('5270', '2603', 'cust_branch', 'general', '2605'),
('5271', '2603', 'customer', 'general', '2605'),
('5272', '2604', 'cust_branch', 'general', '2606'),
('5273', '2604', 'customer', 'general', '2606'),
('5274', '2605', 'cust_branch', 'general', '2607'),
('5275', '2605', 'customer', 'general', '2607');
INSERT INTO `0_crm_contacts` VALUES
('5276', '2606', 'cust_branch', 'general', '2608'),
('5277', '2606', 'customer', 'general', '2608'),
('5278', '2607', 'cust_branch', 'general', '2609'),
('5279', '2607', 'customer', 'general', '2609'),
('5280', '2608', 'cust_branch', 'general', '2610'),
('5281', '2608', 'customer', 'general', '2610'),
('5282', '2609', 'cust_branch', 'general', '2611'),
('5283', '2609', 'customer', 'general', '2611'),
('5284', '2610', 'cust_branch', 'general', '2612'),
('5285', '2610', 'customer', 'general', '2612'),
('5286', '2611', 'cust_branch', 'general', '2613'),
('5287', '2611', 'customer', 'general', '2613'),
('5288', '2612', 'cust_branch', 'general', '2614'),
('5289', '2612', 'customer', 'general', '2614'),
('5290', '2613', 'cust_branch', 'general', '2615'),
('5291', '2613', 'customer', 'general', '2615'),
('5292', '2614', 'cust_branch', 'general', '2616'),
('5293', '2614', 'customer', 'general', '2616'),
('5294', '2615', 'cust_branch', 'general', '2617'),
('5295', '2615', 'customer', 'general', '2617'),
('5296', '2616', 'cust_branch', 'general', '2618'),
('5297', '2616', 'customer', 'general', '2618'),
('5298', '2617', 'cust_branch', 'general', '2619'),
('5299', '2617', 'customer', 'general', '2619'),
('5300', '2618', 'cust_branch', 'general', '2620'),
('5301', '2618', 'customer', 'general', '2620'),
('5302', '2619', 'cust_branch', 'general', '2621'),
('5303', '2619', 'customer', 'general', '2621'),
('5304', '2620', 'cust_branch', 'general', '2622'),
('5305', '2620', 'customer', 'general', '2622'),
('5306', '2621', 'cust_branch', 'general', '2623'),
('5307', '2621', 'customer', 'general', '2623'),
('5308', '2622', 'cust_branch', 'general', '2624'),
('5309', '2622', 'customer', 'general', '2624'),
('5310', '2623', 'cust_branch', 'general', '2625'),
('5311', '2623', 'customer', 'general', '2625'),
('5312', '2624', 'cust_branch', 'general', '2626'),
('5313', '2624', 'customer', 'general', '2626'),
('5314', '2625', 'cust_branch', 'general', '2627'),
('5315', '2625', 'customer', 'general', '2627'),
('5316', '2626', 'cust_branch', 'general', '2628'),
('5317', '2626', 'customer', 'general', '2628'),
('5318', '2627', 'cust_branch', 'general', '2629'),
('5319', '2627', 'customer', 'general', '2629'),
('5320', '2628', 'cust_branch', 'general', '2630'),
('5321', '2628', 'customer', 'general', '2630'),
('5322', '2629', 'cust_branch', 'general', '2631'),
('5323', '2629', 'customer', 'general', '2631'),
('5324', '2630', 'cust_branch', 'general', '2632'),
('5325', '2630', 'customer', 'general', '2632'),
('5326', '2631', 'cust_branch', 'general', '2633'),
('5327', '2631', 'customer', 'general', '2633'),
('5328', '2632', 'cust_branch', 'general', '2634'),
('5329', '2632', 'customer', 'general', '2634'),
('5330', '2633', 'cust_branch', 'general', '2635'),
('5331', '2633', 'customer', 'general', '2635'),
('5332', '2634', 'cust_branch', 'general', '2636'),
('5333', '2634', 'customer', 'general', '2636'),
('5334', '2635', 'cust_branch', 'general', '2637'),
('5335', '2635', 'customer', 'general', '2637'),
('5336', '2636', 'cust_branch', 'general', '2638'),
('5337', '2636', 'customer', 'general', '2638'),
('5338', '2637', 'cust_branch', 'general', '2639'),
('5339', '2637', 'customer', 'general', '2639'),
('5340', '2638', 'cust_branch', 'general', '2640'),
('5341', '2638', 'customer', 'general', '2640'),
('5342', '2639', 'cust_branch', 'general', '2641'),
('5343', '2639', 'customer', 'general', '2641'),
('5344', '2640', 'cust_branch', 'general', '2642'),
('5345', '2640', 'customer', 'general', '2642'),
('5346', '2641', 'cust_branch', 'general', '2643'),
('5347', '2641', 'customer', 'general', '2643'),
('5348', '2642', 'cust_branch', 'general', '2644'),
('5349', '2642', 'customer', 'general', '2644'),
('5350', '2643', 'cust_branch', 'general', '2645'),
('5351', '2643', 'customer', 'general', '2645'),
('5352', '2644', 'cust_branch', 'general', '2646'),
('5353', '2644', 'customer', 'general', '2646'),
('5354', '2645', 'cust_branch', 'general', '2647'),
('5355', '2645', 'customer', 'general', '2647'),
('5356', '2646', 'cust_branch', 'general', '2648'),
('5357', '2646', 'customer', 'general', '2648'),
('5358', '2647', 'cust_branch', 'general', '2649'),
('5359', '2647', 'customer', 'general', '2649'),
('5360', '2648', 'cust_branch', 'general', '2650'),
('5361', '2648', 'customer', 'general', '2650'),
('5362', '2649', 'cust_branch', 'general', '2651'),
('5363', '2649', 'customer', 'general', '2651'),
('5364', '2650', 'cust_branch', 'general', '2652'),
('5365', '2650', 'customer', 'general', '2652'),
('5366', '2651', 'cust_branch', 'general', '2653'),
('5367', '2651', 'customer', 'general', '2653'),
('5368', '2652', 'cust_branch', 'general', '2654'),
('5369', '2652', 'customer', 'general', '2654'),
('5370', '2653', 'cust_branch', 'general', '2655'),
('5371', '2653', 'customer', 'general', '2655'),
('5372', '2654', 'cust_branch', 'general', '2656'),
('5373', '2654', 'customer', 'general', '2656'),
('5374', '2655', 'cust_branch', 'general', '2657'),
('5375', '2655', 'customer', 'general', '2657'),
('5376', '2656', 'cust_branch', 'general', '2658'),
('5377', '2656', 'customer', 'general', '2658'),
('5378', '2657', 'cust_branch', 'general', '2659'),
('5379', '2657', 'customer', 'general', '2659'),
('5380', '2658', 'cust_branch', 'general', '2660'),
('5381', '2658', 'customer', 'general', '2660'),
('5382', '2659', 'cust_branch', 'general', '2661'),
('5383', '2659', 'customer', 'general', '2661'),
('5384', '2660', 'cust_branch', 'general', '2662'),
('5385', '2660', 'customer', 'general', '2662'),
('5386', '2661', 'cust_branch', 'general', '2663'),
('5387', '2661', 'customer', 'general', '2663'),
('5388', '2662', 'cust_branch', 'general', '2664'),
('5389', '2662', 'customer', 'general', '2664'),
('5390', '2663', 'cust_branch', 'general', '2665'),
('5391', '2663', 'customer', 'general', '2665'),
('5392', '2664', 'cust_branch', 'general', '2666'),
('5393', '2664', 'customer', 'general', '2666'),
('5394', '2665', 'cust_branch', 'general', '2667'),
('5395', '2665', 'customer', 'general', '2667'),
('5396', '2666', 'cust_branch', 'general', '2668'),
('5397', '2666', 'customer', 'general', '2668'),
('5398', '2667', 'cust_branch', 'general', '2669'),
('5399', '2667', 'customer', 'general', '2669'),
('5400', '2668', 'cust_branch', 'general', '2670'),
('5401', '2668', 'customer', 'general', '2670'),
('5402', '2669', 'cust_branch', 'general', '2671'),
('5403', '2669', 'customer', 'general', '2671'),
('5404', '2670', 'cust_branch', 'general', '2672'),
('5405', '2670', 'customer', 'general', '2672'),
('5406', '2671', 'cust_branch', 'general', '2673'),
('5407', '2671', 'customer', 'general', '2673'),
('5408', '2672', 'cust_branch', 'general', '2674'),
('5409', '2672', 'customer', 'general', '2674'),
('5410', '2673', 'cust_branch', 'general', '2675'),
('5411', '2673', 'customer', 'general', '2675'),
('5412', '2674', 'cust_branch', 'general', '2676'),
('5413', '2674', 'customer', 'general', '2676'),
('5414', '2675', 'cust_branch', 'general', '2677'),
('5415', '2675', 'customer', 'general', '2677'),
('5416', '2676', 'cust_branch', 'general', '2678'),
('5417', '2676', 'customer', 'general', '2678'),
('5418', '2677', 'cust_branch', 'general', '2679'),
('5419', '2677', 'customer', 'general', '2679'),
('5420', '2678', 'cust_branch', 'general', '2680'),
('5421', '2678', 'customer', 'general', '2680'),
('5422', '2679', 'cust_branch', 'general', '2681'),
('5423', '2679', 'customer', 'general', '2681'),
('5424', '2680', 'cust_branch', 'general', '2682'),
('5425', '2680', 'customer', 'general', '2682'),
('5426', '2681', 'cust_branch', 'general', '2683'),
('5427', '2681', 'customer', 'general', '2683'),
('5428', '2682', 'cust_branch', 'general', '2684'),
('5429', '2682', 'customer', 'general', '2684'),
('5430', '2683', 'cust_branch', 'general', '2685'),
('5431', '2683', 'customer', 'general', '2685'),
('5432', '2684', 'cust_branch', 'general', '2686'),
('5433', '2684', 'customer', 'general', '2686'),
('5434', '2685', 'cust_branch', 'general', '2687'),
('5435', '2685', 'customer', 'general', '2687'),
('5436', '2686', 'cust_branch', 'general', '2688'),
('5437', '2686', 'customer', 'general', '2688'),
('5438', '2687', 'cust_branch', 'general', '2689'),
('5439', '2687', 'customer', 'general', '2689'),
('5440', '2688', 'cust_branch', 'general', '2690'),
('5441', '2688', 'customer', 'general', '2690'),
('5442', '2689', 'cust_branch', 'general', '2691'),
('5443', '2689', 'customer', 'general', '2691'),
('5444', '2690', 'cust_branch', 'general', '2692'),
('5445', '2690', 'customer', 'general', '2692'),
('5446', '2691', 'cust_branch', 'general', '2693'),
('5447', '2691', 'customer', 'general', '2693'),
('5448', '2692', 'cust_branch', 'general', '2694'),
('5449', '2692', 'customer', 'general', '2694'),
('5450', '2693', 'cust_branch', 'general', '2695'),
('5451', '2693', 'customer', 'general', '2695'),
('5452', '2694', 'cust_branch', 'general', '2696'),
('5453', '2694', 'customer', 'general', '2696'),
('5454', '2695', 'cust_branch', 'general', '2697'),
('5455', '2695', 'customer', 'general', '2697'),
('5456', '2696', 'cust_branch', 'general', '2698'),
('5457', '2696', 'customer', 'general', '2698'),
('5458', '2697', 'cust_branch', 'general', '2699'),
('5459', '2697', 'customer', 'general', '2699'),
('5460', '2698', 'cust_branch', 'general', '2700'),
('5461', '2698', 'customer', 'general', '2700'),
('5462', '2699', 'cust_branch', 'general', '2701'),
('5463', '2699', 'customer', 'general', '2701'),
('5464', '2700', 'cust_branch', 'general', '2702'),
('5465', '2700', 'customer', 'general', '2702'),
('5466', '2701', 'cust_branch', 'general', '2703'),
('5467', '2701', 'customer', 'general', '2703'),
('5468', '2702', 'cust_branch', 'general', '2704'),
('5469', '2702', 'customer', 'general', '2704'),
('5470', '2703', 'cust_branch', 'general', '2705'),
('5471', '2703', 'customer', 'general', '2705'),
('5472', '2704', 'cust_branch', 'general', '2706'),
('5473', '2704', 'customer', 'general', '2706'),
('5474', '2705', 'cust_branch', 'general', '2707'),
('5475', '2705', 'customer', 'general', '2707'),
('5476', '2706', 'cust_branch', 'general', '2708'),
('5477', '2706', 'customer', 'general', '2708'),
('5478', '2707', 'cust_branch', 'general', '2709'),
('5479', '2707', 'customer', 'general', '2709'),
('5480', '2708', 'cust_branch', 'general', '2710'),
('5481', '2708', 'customer', 'general', '2710'),
('5482', '2709', 'cust_branch', 'general', '2711'),
('5483', '2709', 'customer', 'general', '2711'),
('5484', '2710', 'cust_branch', 'general', '2712'),
('5485', '2710', 'customer', 'general', '2712'),
('5486', '2711', 'cust_branch', 'general', '2713'),
('5487', '2711', 'customer', 'general', '2713'),
('5488', '2712', 'cust_branch', 'general', '2714'),
('5489', '2712', 'customer', 'general', '2714'),
('5490', '2713', 'cust_branch', 'general', '2715'),
('5491', '2713', 'customer', 'general', '2715'),
('5492', '2714', 'cust_branch', 'general', '2716'),
('5493', '2714', 'customer', 'general', '2716'),
('5494', '2715', 'cust_branch', 'general', '2717'),
('5495', '2715', 'customer', 'general', '2717'),
('5496', '2716', 'cust_branch', 'general', '2718'),
('5497', '2716', 'customer', 'general', '2718'),
('5498', '2717', 'cust_branch', 'general', '2719'),
('5499', '2717', 'customer', 'general', '2719'),
('5500', '2718', 'cust_branch', 'general', '2720'),
('5501', '2718', 'customer', 'general', '2720'),
('5502', '2719', 'cust_branch', 'general', '2721'),
('5503', '2719', 'customer', 'general', '2721'),
('5504', '2720', 'cust_branch', 'general', '2722'),
('5505', '2720', 'customer', 'general', '2722'),
('5506', '2721', 'cust_branch', 'general', '2723'),
('5507', '2721', 'customer', 'general', '2723'),
('5508', '2722', 'cust_branch', 'general', '2724'),
('5509', '2722', 'customer', 'general', '2724'),
('5510', '2723', 'cust_branch', 'general', '2725'),
('5511', '2723', 'customer', 'general', '2725'),
('5512', '2724', 'cust_branch', 'general', '2726'),
('5513', '2724', 'customer', 'general', '2726'),
('5514', '2725', 'cust_branch', 'general', '2727'),
('5515', '2725', 'customer', 'general', '2727'),
('5516', '2726', 'cust_branch', 'general', '2728'),
('5517', '2726', 'customer', 'general', '2728'),
('5518', '2727', 'cust_branch', 'general', '2729'),
('5519', '2727', 'customer', 'general', '2729'),
('5520', '2728', 'cust_branch', 'general', '2730'),
('5521', '2728', 'customer', 'general', '2730'),
('5522', '2729', 'cust_branch', 'general', '2731'),
('5523', '2729', 'customer', 'general', '2731'),
('5524', '2730', 'cust_branch', 'general', '2732'),
('5525', '2730', 'customer', 'general', '2732'),
('5526', '2731', 'cust_branch', 'general', '2733'),
('5527', '2731', 'customer', 'general', '2733'),
('5528', '2732', 'cust_branch', 'general', '2734'),
('5529', '2732', 'customer', 'general', '2734'),
('5530', '2733', 'cust_branch', 'general', '2735'),
('5531', '2733', 'customer', 'general', '2735'),
('5532', '2734', 'cust_branch', 'general', '2736'),
('5533', '2734', 'customer', 'general', '2736'),
('5534', '2735', 'cust_branch', 'general', '2737'),
('5535', '2735', 'customer', 'general', '2737'),
('5536', '2736', 'cust_branch', 'general', '2738'),
('5537', '2736', 'customer', 'general', '2738'),
('5538', '2737', 'cust_branch', 'general', '2739'),
('5539', '2737', 'customer', 'general', '2739'),
('5540', '2738', 'cust_branch', 'general', '2740'),
('5541', '2738', 'customer', 'general', '2740'),
('5542', '2739', 'cust_branch', 'general', '2741'),
('5543', '2739', 'customer', 'general', '2741'),
('5544', '2740', 'cust_branch', 'general', '2742'),
('5545', '2740', 'customer', 'general', '2742'),
('5546', '2741', 'cust_branch', 'general', '2743'),
('5547', '2741', 'customer', 'general', '2743'),
('5548', '2742', 'cust_branch', 'general', '2744'),
('5549', '2742', 'customer', 'general', '2744'),
('5550', '2743', 'cust_branch', 'general', '2745'),
('5551', '2743', 'customer', 'general', '2745'),
('5552', '2744', 'cust_branch', 'general', '2746'),
('5553', '2744', 'customer', 'general', '2746'),
('5554', '2745', 'cust_branch', 'general', '2747'),
('5555', '2745', 'customer', 'general', '2747'),
('5556', '2746', 'cust_branch', 'general', '2748'),
('5557', '2746', 'customer', 'general', '2748'),
('5558', '2747', 'cust_branch', 'general', '2749'),
('5559', '2747', 'customer', 'general', '2749'),
('5560', '2748', 'cust_branch', 'general', '2750'),
('5561', '2748', 'customer', 'general', '2750'),
('5562', '2749', 'cust_branch', 'general', '2751'),
('5563', '2749', 'customer', 'general', '2751'),
('5564', '2750', 'cust_branch', 'general', '2752'),
('5565', '2750', 'customer', 'general', '2752'),
('5566', '2751', 'cust_branch', 'general', '2753'),
('5567', '2751', 'customer', 'general', '2753'),
('5568', '2752', 'cust_branch', 'general', '2754'),
('5569', '2752', 'customer', 'general', '2754'),
('5570', '2753', 'cust_branch', 'general', '2755'),
('5571', '2753', 'customer', 'general', '2755'),
('5572', '2754', 'cust_branch', 'general', '2756'),
('5573', '2754', 'customer', 'general', '2756'),
('5574', '2755', 'cust_branch', 'general', '2757'),
('5575', '2755', 'customer', 'general', '2757'),
('5576', '2756', 'cust_branch', 'general', '2758'),
('5577', '2756', 'customer', 'general', '2758'),
('5578', '2757', 'cust_branch', 'general', '2759'),
('5579', '2757', 'customer', 'general', '2759'),
('5580', '2758', 'cust_branch', 'general', '2760'),
('5581', '2758', 'customer', 'general', '2760'),
('5582', '2759', 'cust_branch', 'general', '2761'),
('5583', '2759', 'customer', 'general', '2761'),
('5584', '2760', 'cust_branch', 'general', '2762'),
('5585', '2760', 'customer', 'general', '2762'),
('5586', '2761', 'cust_branch', 'general', '2763'),
('5587', '2761', 'customer', 'general', '2763'),
('5588', '2762', 'cust_branch', 'general', '2764'),
('5589', '2762', 'customer', 'general', '2764'),
('5590', '2763', 'cust_branch', 'general', '2765'),
('5591', '2763', 'customer', 'general', '2765'),
('5592', '2764', 'cust_branch', 'general', '2766'),
('5593', '2764', 'customer', 'general', '2766'),
('5594', '2765', 'cust_branch', 'general', '2767'),
('5595', '2765', 'customer', 'general', '2767'),
('5596', '2766', 'cust_branch', 'general', '2768'),
('5597', '2766', 'customer', 'general', '2768'),
('5598', '2767', 'cust_branch', 'general', '2769'),
('5599', '2767', 'customer', 'general', '2769'),
('5600', '2768', 'cust_branch', 'general', '2770'),
('5601', '2768', 'customer', 'general', '2770'),
('5602', '2769', 'cust_branch', 'general', '2771'),
('5603', '2769', 'customer', 'general', '2771'),
('5604', '2770', 'cust_branch', 'general', '2772'),
('5605', '2770', 'customer', 'general', '2772'),
('5606', '2771', 'cust_branch', 'general', '2773'),
('5607', '2771', 'customer', 'general', '2773'),
('5608', '2772', 'cust_branch', 'general', '2774'),
('5609', '2772', 'customer', 'general', '2774'),
('5610', '2773', 'cust_branch', 'general', '2775'),
('5611', '2773', 'customer', 'general', '2775'),
('5612', '2774', 'cust_branch', 'general', '2776'),
('5613', '2774', 'customer', 'general', '2776'),
('5614', '2775', 'cust_branch', 'general', '2777'),
('5615', '2775', 'customer', 'general', '2777'),
('5616', '2776', 'cust_branch', 'general', '2778'),
('5617', '2776', 'customer', 'general', '2778'),
('5618', '2777', 'cust_branch', 'general', '2779'),
('5619', '2777', 'customer', 'general', '2779'),
('5620', '2778', 'cust_branch', 'general', '2780'),
('5621', '2778', 'customer', 'general', '2780'),
('5622', '2779', 'cust_branch', 'general', '2781'),
('5623', '2779', 'customer', 'general', '2781'),
('5624', '2780', 'cust_branch', 'general', '2782'),
('5625', '2780', 'customer', 'general', '2782'),
('5626', '2781', 'cust_branch', 'general', '2783'),
('5627', '2781', 'customer', 'general', '2783'),
('5628', '2782', 'cust_branch', 'general', '2784'),
('5629', '2782', 'customer', 'general', '2784'),
('5630', '2783', 'cust_branch', 'general', '2785'),
('5631', '2783', 'customer', 'general', '2785'),
('5632', '2784', 'cust_branch', 'general', '2786'),
('5633', '2784', 'customer', 'general', '2786'),
('5634', '2785', 'cust_branch', 'general', '2787'),
('5635', '2785', 'customer', 'general', '2787'),
('5636', '2786', 'cust_branch', 'general', '2788'),
('5637', '2786', 'customer', 'general', '2788'),
('5638', '2787', 'cust_branch', 'general', '2789'),
('5639', '2787', 'customer', 'general', '2789'),
('5640', '2788', 'cust_branch', 'general', '2790'),
('5641', '2788', 'customer', 'general', '2790'),
('5642', '2789', 'cust_branch', 'general', '2791'),
('5643', '2789', 'customer', 'general', '2791'),
('5644', '2790', 'cust_branch', 'general', '2792'),
('5645', '2790', 'customer', 'general', '2792'),
('5646', '2791', 'cust_branch', 'general', '2793'),
('5647', '2791', 'customer', 'general', '2793'),
('5648', '2792', 'cust_branch', 'general', '2794'),
('5649', '2792', 'customer', 'general', '2794'),
('5650', '2793', 'cust_branch', 'general', '2795'),
('5651', '2793', 'customer', 'general', '2795'),
('5652', '2794', 'cust_branch', 'general', '2796'),
('5653', '2794', 'customer', 'general', '2796'),
('5654', '2795', 'cust_branch', 'general', '2797'),
('5655', '2795', 'customer', 'general', '2797'),
('5656', '2796', 'cust_branch', 'general', '2798'),
('5657', '2796', 'customer', 'general', '2798'),
('5658', '2797', 'cust_branch', 'general', '2799'),
('5659', '2797', 'customer', 'general', '2799'),
('5660', '2798', 'cust_branch', 'general', '2800'),
('5661', '2798', 'customer', 'general', '2800'),
('5662', '2799', 'cust_branch', 'general', '2801'),
('5663', '2799', 'customer', 'general', '2801'),
('5664', '2800', 'cust_branch', 'general', '2802'),
('5665', '2800', 'customer', 'general', '2802'),
('5666', '2801', 'cust_branch', 'general', '2803'),
('5667', '2801', 'customer', 'general', '2803'),
('5668', '2802', 'cust_branch', 'general', '2804'),
('5669', '2802', 'customer', 'general', '2804'),
('5670', '2803', 'cust_branch', 'general', '2805'),
('5671', '2803', 'customer', 'general', '2805'),
('5672', '2804', 'cust_branch', 'general', '2806'),
('5673', '2804', 'customer', 'general', '2806'),
('5674', '2805', 'cust_branch', 'general', '2807'),
('5675', '2805', 'customer', 'general', '2807'),
('5676', '2806', 'cust_branch', 'general', '2808'),
('5677', '2806', 'customer', 'general', '2808'),
('5678', '2807', 'cust_branch', 'general', '2809'),
('5679', '2807', 'customer', 'general', '2809'),
('5680', '2808', 'cust_branch', 'general', '2810'),
('5681', '2808', 'customer', 'general', '2810'),
('5682', '2809', 'cust_branch', 'general', '2811'),
('5683', '2809', 'customer', 'general', '2811'),
('5684', '2810', 'cust_branch', 'general', '2812'),
('5685', '2810', 'customer', 'general', '2812'),
('5686', '2811', 'cust_branch', 'general', '2813'),
('5687', '2811', 'customer', 'general', '2813'),
('5688', '2812', 'cust_branch', 'general', '2814'),
('5689', '2812', 'customer', 'general', '2814'),
('5690', '2813', 'cust_branch', 'general', '2815'),
('5691', '2813', 'customer', 'general', '2815'),
('5692', '2814', 'cust_branch', 'general', '2816'),
('5693', '2814', 'customer', 'general', '2816'),
('5694', '2815', 'cust_branch', 'general', '2817'),
('5695', '2815', 'customer', 'general', '2817'),
('5696', '2816', 'cust_branch', 'general', '2818'),
('5697', '2816', 'customer', 'general', '2818'),
('5698', '2817', 'cust_branch', 'general', '2819'),
('5699', '2817', 'customer', 'general', '2819'),
('5700', '2818', 'cust_branch', 'general', '2820'),
('5701', '2818', 'customer', 'general', '2820'),
('5702', '2819', 'cust_branch', 'general', '2821'),
('5703', '2819', 'customer', 'general', '2821'),
('5704', '2820', 'cust_branch', 'general', '2822'),
('5705', '2820', 'customer', 'general', '2822'),
('5706', '2821', 'cust_branch', 'general', '2823'),
('5707', '2821', 'customer', 'general', '2823'),
('5708', '2822', 'cust_branch', 'general', '2824'),
('5709', '2822', 'customer', 'general', '2824'),
('5710', '2823', 'cust_branch', 'general', '2825'),
('5711', '2823', 'customer', 'general', '2825'),
('5712', '2824', 'cust_branch', 'general', '2826'),
('5713', '2824', 'customer', 'general', '2826'),
('5714', '2825', 'cust_branch', 'general', '2827'),
('5715', '2825', 'customer', 'general', '2827'),
('5716', '2826', 'cust_branch', 'general', '2828'),
('5717', '2826', 'customer', 'general', '2828'),
('5718', '2827', 'cust_branch', 'general', '2829'),
('5719', '2827', 'customer', 'general', '2829'),
('5720', '2828', 'cust_branch', 'general', '2830'),
('5721', '2828', 'customer', 'general', '2830'),
('5722', '2829', 'cust_branch', 'general', '2831'),
('5723', '2829', 'customer', 'general', '2831'),
('5724', '2830', 'cust_branch', 'general', '2832'),
('5725', '2830', 'customer', 'general', '2832'),
('5726', '2831', 'cust_branch', 'general', '2833'),
('5727', '2831', 'customer', 'general', '2833'),
('5728', '2832', 'cust_branch', 'general', '2834'),
('5729', '2832', 'customer', 'general', '2834'),
('5730', '2833', 'cust_branch', 'general', '2835'),
('5731', '2833', 'customer', 'general', '2835'),
('5732', '2834', 'cust_branch', 'general', '2836'),
('5733', '2834', 'customer', 'general', '2836'),
('5734', '2835', 'cust_branch', 'general', '2837'),
('5735', '2835', 'customer', 'general', '2837'),
('5736', '2836', 'cust_branch', 'general', '2838'),
('5737', '2836', 'customer', 'general', '2838'),
('5738', '2837', 'cust_branch', 'general', '2839'),
('5739', '2837', 'customer', 'general', '2839'),
('5740', '2838', 'cust_branch', 'general', '2840'),
('5741', '2838', 'customer', 'general', '2840'),
('5742', '2839', 'cust_branch', 'general', '2841'),
('5743', '2839', 'customer', 'general', '2841'),
('5744', '2840', 'cust_branch', 'general', '2842'),
('5745', '2840', 'customer', 'general', '2842'),
('5746', '2841', 'cust_branch', 'general', '2843'),
('5747', '2841', 'customer', 'general', '2843'),
('5748', '2842', 'cust_branch', 'general', '2844'),
('5749', '2842', 'customer', 'general', '2844'),
('5750', '2843', 'cust_branch', 'general', '2845'),
('5751', '2843', 'customer', 'general', '2845'),
('5752', '2844', 'cust_branch', 'general', '2846'),
('5753', '2844', 'customer', 'general', '2846'),
('5754', '2845', 'cust_branch', 'general', '2847'),
('5755', '2845', 'customer', 'general', '2847'),
('5756', '2846', 'cust_branch', 'general', '2848'),
('5757', '2846', 'customer', 'general', '2848'),
('5758', '2847', 'cust_branch', 'general', '2849'),
('5759', '2847', 'customer', 'general', '2849'),
('5760', '2848', 'cust_branch', 'general', '2850'),
('5761', '2848', 'customer', 'general', '2850'),
('5762', '2849', 'cust_branch', 'general', '2851'),
('5763', '2849', 'customer', 'general', '2851'),
('5764', '2850', 'cust_branch', 'general', '2852'),
('5765', '2850', 'customer', 'general', '2852'),
('5766', '2851', 'cust_branch', 'general', '2853'),
('5767', '2851', 'customer', 'general', '2853'),
('5768', '2852', 'cust_branch', 'general', '2854'),
('5769', '2852', 'customer', 'general', '2854'),
('5770', '2853', 'cust_branch', 'general', '2855'),
('5771', '2853', 'customer', 'general', '2855'),
('5772', '2854', 'cust_branch', 'general', '2856'),
('5773', '2854', 'customer', 'general', '2856'),
('5774', '2855', 'cust_branch', 'general', '2857'),
('5775', '2855', 'customer', 'general', '2857'),
('5776', '2856', 'cust_branch', 'general', '2858'),
('5777', '2856', 'customer', 'general', '2858'),
('5778', '2857', 'cust_branch', 'general', '2859'),
('5779', '2857', 'customer', 'general', '2859'),
('5780', '2858', 'cust_branch', 'general', '2860'),
('5781', '2858', 'customer', 'general', '2860'),
('5782', '2859', 'cust_branch', 'general', '2861'),
('5783', '2859', 'customer', 'general', '2861'),
('5784', '2860', 'cust_branch', 'general', '2862'),
('5785', '2860', 'customer', 'general', '2862'),
('5786', '2861', 'cust_branch', 'general', '2863'),
('5787', '2861', 'customer', 'general', '2863'),
('5788', '2862', 'cust_branch', 'general', '2864'),
('5789', '2862', 'customer', 'general', '2864'),
('5790', '2863', 'cust_branch', 'general', '2865'),
('5791', '2863', 'customer', 'general', '2865'),
('5792', '2864', 'cust_branch', 'general', '2866'),
('5793', '2864', 'customer', 'general', '2866'),
('5794', '2865', 'cust_branch', 'general', '2867'),
('5795', '2865', 'customer', 'general', '2867'),
('5796', '2866', 'cust_branch', 'general', '2868'),
('5797', '2866', 'customer', 'general', '2868'),
('5798', '2867', 'cust_branch', 'general', '2869'),
('5799', '2867', 'customer', 'general', '2869'),
('5800', '2868', 'cust_branch', 'general', '2870'),
('5801', '2868', 'customer', 'general', '2870'),
('5802', '2869', 'cust_branch', 'general', '2871'),
('5803', '2869', 'customer', 'general', '2871'),
('5804', '2870', 'cust_branch', 'general', '2872'),
('5805', '2870', 'customer', 'general', '2872'),
('5806', '2871', 'cust_branch', 'general', '2873'),
('5807', '2871', 'customer', 'general', '2873'),
('5808', '2872', 'cust_branch', 'general', '2874'),
('5809', '2872', 'customer', 'general', '2874'),
('5810', '2873', 'cust_branch', 'general', '2875'),
('5811', '2873', 'customer', 'general', '2875'),
('5812', '2874', 'cust_branch', 'general', '2876'),
('5813', '2874', 'customer', 'general', '2876'),
('5814', '2875', 'cust_branch', 'general', '2877'),
('5815', '2875', 'customer', 'general', '2877'),
('5816', '2876', 'cust_branch', 'general', '2878'),
('5817', '2876', 'customer', 'general', '2878'),
('5818', '2877', 'cust_branch', 'general', '2879'),
('5819', '2877', 'customer', 'general', '2879'),
('5820', '2878', 'cust_branch', 'general', '2880'),
('5821', '2878', 'customer', 'general', '2880'),
('5822', '2879', 'cust_branch', 'general', '2881'),
('5823', '2879', 'customer', 'general', '2881'),
('5824', '2880', 'cust_branch', 'general', '2882'),
('5825', '2880', 'customer', 'general', '2882'),
('5826', '2881', 'cust_branch', 'general', '2883'),
('5827', '2881', 'customer', 'general', '2883'),
('5828', '2882', 'cust_branch', 'general', '2884'),
('5829', '2882', 'customer', 'general', '2884'),
('5830', '2883', 'cust_branch', 'general', '2885'),
('5831', '2883', 'customer', 'general', '2885'),
('5832', '2884', 'cust_branch', 'general', '2886'),
('5833', '2884', 'customer', 'general', '2886'),
('5834', '2885', 'cust_branch', 'general', '2887'),
('5835', '2885', 'customer', 'general', '2887'),
('5836', '2886', 'cust_branch', 'general', '2888'),
('5837', '2886', 'customer', 'general', '2888'),
('5838', '2887', 'cust_branch', 'general', '2889'),
('5839', '2887', 'customer', 'general', '2889'),
('5840', '2888', 'cust_branch', 'general', '2890'),
('5841', '2888', 'customer', 'general', '2890'),
('5842', '2889', 'cust_branch', 'general', '2891'),
('5843', '2889', 'customer', 'general', '2891'),
('5844', '2890', 'cust_branch', 'general', '2892'),
('5845', '2890', 'customer', 'general', '2892'),
('5846', '2891', 'cust_branch', 'general', '2893'),
('5847', '2891', 'customer', 'general', '2893'),
('5848', '2892', 'cust_branch', 'general', '2894'),
('5849', '2892', 'customer', 'general', '2894'),
('5850', '2893', 'cust_branch', 'general', '2895'),
('5851', '2893', 'customer', 'general', '2895'),
('5852', '2894', 'cust_branch', 'general', '2896'),
('5853', '2894', 'customer', 'general', '2896'),
('5854', '2895', 'cust_branch', 'general', '2897'),
('5855', '2895', 'customer', 'general', '2897'),
('5856', '2896', 'cust_branch', 'general', '2898'),
('5857', '2896', 'customer', 'general', '2898'),
('5858', '2897', 'cust_branch', 'general', '2899'),
('5859', '2897', 'customer', 'general', '2899'),
('5860', '2898', 'cust_branch', 'general', '2900'),
('5861', '2898', 'customer', 'general', '2900'),
('5862', '2899', 'cust_branch', 'general', '2901'),
('5863', '2899', 'customer', 'general', '2901'),
('5864', '2900', 'cust_branch', 'general', '2902'),
('5865', '2900', 'customer', 'general', '2902'),
('5866', '2901', 'cust_branch', 'general', '2903'),
('5867', '2901', 'customer', 'general', '2903'),
('5868', '2902', 'cust_branch', 'general', '2904'),
('5869', '2902', 'customer', 'general', '2904'),
('5870', '2903', 'cust_branch', 'general', '2905'),
('5871', '2903', 'customer', 'general', '2905'),
('5872', '2904', 'cust_branch', 'general', '2906'),
('5873', '2904', 'customer', 'general', '2906'),
('5874', '2905', 'cust_branch', 'general', '2907'),
('5875', '2905', 'customer', 'general', '2907'),
('5876', '2906', 'cust_branch', 'general', '2908'),
('5877', '2906', 'customer', 'general', '2908'),
('5878', '2907', 'cust_branch', 'general', '2909'),
('5879', '2907', 'customer', 'general', '2909'),
('5880', '2908', 'cust_branch', 'general', '2910'),
('5881', '2908', 'customer', 'general', '2910'),
('5882', '2909', 'cust_branch', 'general', '2911'),
('5883', '2909', 'customer', 'general', '2911'),
('5884', '2910', 'cust_branch', 'general', '2912'),
('5885', '2910', 'customer', 'general', '2912'),
('5886', '2911', 'cust_branch', 'general', '2913'),
('5887', '2911', 'customer', 'general', '2913'),
('5888', '2912', 'cust_branch', 'general', '2914'),
('5889', '2912', 'customer', 'general', '2914'),
('5890', '2913', 'cust_branch', 'general', '2915'),
('5891', '2913', 'customer', 'general', '2915'),
('5892', '2914', 'cust_branch', 'general', '2916'),
('5893', '2914', 'customer', 'general', '2916'),
('5894', '2915', 'cust_branch', 'general', '2917'),
('5895', '2915', 'customer', 'general', '2917'),
('5896', '2916', 'cust_branch', 'general', '2918'),
('5897', '2916', 'customer', 'general', '2918'),
('5898', '2917', 'cust_branch', 'general', '2919'),
('5899', '2917', 'customer', 'general', '2919'),
('5900', '2918', 'cust_branch', 'general', '2920'),
('5901', '2918', 'customer', 'general', '2920'),
('5902', '2919', 'cust_branch', 'general', '2921'),
('5903', '2919', 'customer', 'general', '2921'),
('5904', '2920', 'cust_branch', 'general', '2922'),
('5905', '2920', 'customer', 'general', '2922'),
('5906', '2921', 'cust_branch', 'general', '2923'),
('5907', '2921', 'customer', 'general', '2923'),
('5908', '2922', 'cust_branch', 'general', '2924'),
('5909', '2922', 'customer', 'general', '2924'),
('5910', '2923', 'cust_branch', 'general', '2925'),
('5911', '2923', 'customer', 'general', '2925'),
('5912', '2924', 'cust_branch', 'general', '2926'),
('5913', '2924', 'customer', 'general', '2926'),
('5914', '2925', 'cust_branch', 'general', '2927'),
('5915', '2925', 'customer', 'general', '2927'),
('5916', '2926', 'cust_branch', 'general', '2928'),
('5917', '2926', 'customer', 'general', '2928'),
('5918', '2927', 'cust_branch', 'general', '2929'),
('5919', '2927', 'customer', 'general', '2929'),
('5920', '2928', 'cust_branch', 'general', '2930'),
('5921', '2928', 'customer', 'general', '2930'),
('5922', '2929', 'cust_branch', 'general', '2931'),
('5923', '2929', 'customer', 'general', '2931'),
('5924', '2930', 'cust_branch', 'general', '2932'),
('5925', '2930', 'customer', 'general', '2932'),
('5926', '2931', 'cust_branch', 'general', '2933'),
('5927', '2931', 'customer', 'general', '2933'),
('5928', '2932', 'cust_branch', 'general', '2934'),
('5929', '2932', 'customer', 'general', '2934'),
('5930', '2933', 'cust_branch', 'general', '2935'),
('5931', '2933', 'customer', 'general', '2935'),
('5932', '2934', 'cust_branch', 'general', '2936'),
('5933', '2934', 'customer', 'general', '2936'),
('5934', '2935', 'cust_branch', 'general', '2937'),
('5935', '2935', 'customer', 'general', '2937'),
('5936', '2936', 'cust_branch', 'general', '2938'),
('5937', '2936', 'customer', 'general', '2938'),
('5938', '2937', 'cust_branch', 'general', '2939'),
('5939', '2937', 'customer', 'general', '2939'),
('5940', '2938', 'cust_branch', 'general', '2940'),
('5941', '2938', 'customer', 'general', '2940'),
('5942', '2939', 'cust_branch', 'general', '2941'),
('5943', '2939', 'customer', 'general', '2941'),
('5944', '2940', 'cust_branch', 'general', '2942'),
('5945', '2940', 'customer', 'general', '2942'),
('5946', '2941', 'cust_branch', 'general', '2943'),
('5947', '2941', 'customer', 'general', '2943'),
('5948', '2942', 'cust_branch', 'general', '2944'),
('5949', '2942', 'customer', 'general', '2944'),
('5950', '2943', 'cust_branch', 'general', '2945'),
('5951', '2943', 'customer', 'general', '2945'),
('5952', '2944', 'cust_branch', 'general', '2946'),
('5953', '2944', 'customer', 'general', '2946'),
('5954', '2945', 'cust_branch', 'general', '2947'),
('5955', '2945', 'customer', 'general', '2947'),
('5956', '2946', 'cust_branch', 'general', '2948'),
('5957', '2946', 'customer', 'general', '2948'),
('5958', '2947', 'cust_branch', 'general', '2949'),
('5959', '2947', 'customer', 'general', '2949'),
('5960', '2948', 'cust_branch', 'general', '2950'),
('5961', '2948', 'customer', 'general', '2950'),
('5962', '2949', 'cust_branch', 'general', '2951'),
('5963', '2949', 'customer', 'general', '2951'),
('5964', '2950', 'cust_branch', 'general', '2952'),
('5965', '2950', 'customer', 'general', '2952'),
('5966', '2951', 'cust_branch', 'general', '2953'),
('5967', '2951', 'customer', 'general', '2953'),
('5968', '2952', 'cust_branch', 'general', '2954'),
('5969', '2952', 'customer', 'general', '2954'),
('5970', '2953', 'cust_branch', 'general', '2955'),
('5971', '2953', 'customer', 'general', '2955'),
('5972', '2954', 'cust_branch', 'general', '2956'),
('5973', '2954', 'customer', 'general', '2956'),
('5974', '2955', 'cust_branch', 'general', '2957'),
('5975', '2955', 'customer', 'general', '2957'),
('5976', '2956', 'cust_branch', 'general', '2958'),
('5977', '2956', 'customer', 'general', '2958'),
('5978', '2957', 'cust_branch', 'general', '2959'),
('5979', '2957', 'customer', 'general', '2959'),
('5980', '2958', 'cust_branch', 'general', '2960'),
('5981', '2958', 'customer', 'general', '2960'),
('5982', '2959', 'cust_branch', 'general', '2961'),
('5983', '2959', 'customer', 'general', '2961'),
('5984', '2960', 'cust_branch', 'general', '2962'),
('5985', '2960', 'customer', 'general', '2962'),
('5986', '2961', 'cust_branch', 'general', '2963'),
('5987', '2961', 'customer', 'general', '2963'),
('5988', '2962', 'cust_branch', 'general', '2964'),
('5989', '2962', 'customer', 'general', '2964'),
('5990', '2963', 'cust_branch', 'general', '2965'),
('5991', '2963', 'customer', 'general', '2965'),
('5992', '2964', 'cust_branch', 'general', '2966'),
('5993', '2964', 'customer', 'general', '2966'),
('5994', '2965', 'cust_branch', 'general', '2967'),
('5995', '2965', 'customer', 'general', '2967'),
('5996', '2966', 'cust_branch', 'general', '2968'),
('5997', '2966', 'customer', 'general', '2968'),
('5998', '2967', 'cust_branch', 'general', '2969'),
('5999', '2967', 'customer', 'general', '2969'),
('6000', '2968', 'cust_branch', 'general', '2970'),
('6001', '2968', 'customer', 'general', '2970'),
('6002', '2969', 'cust_branch', 'general', '2971'),
('6003', '2969', 'customer', 'general', '2971'),
('6004', '2970', 'cust_branch', 'general', '2972'),
('6005', '2970', 'customer', 'general', '2972'),
('6006', '2971', 'cust_branch', 'general', '2973'),
('6007', '2971', 'customer', 'general', '2973'),
('6008', '2972', 'cust_branch', 'general', '2974'),
('6009', '2972', 'customer', 'general', '2974'),
('6010', '2973', 'cust_branch', 'general', '2975'),
('6011', '2973', 'customer', 'general', '2975'),
('6012', '2974', 'cust_branch', 'general', '2976'),
('6013', '2974', 'customer', 'general', '2976'),
('6014', '2975', 'cust_branch', 'general', '2977'),
('6015', '2975', 'customer', 'general', '2977'),
('6016', '2976', 'cust_branch', 'general', '2978'),
('6017', '2976', 'customer', 'general', '2978'),
('6018', '2977', 'cust_branch', 'general', '2979'),
('6019', '2977', 'customer', 'general', '2979'),
('6020', '2978', 'cust_branch', 'general', '2980'),
('6021', '2978', 'customer', 'general', '2980'),
('6022', '2979', 'cust_branch', 'general', '2981'),
('6023', '2979', 'customer', 'general', '2981'),
('6024', '2980', 'cust_branch', 'general', '2982'),
('6025', '2980', 'customer', 'general', '2982'),
('6026', '2981', 'cust_branch', 'general', '2983'),
('6027', '2981', 'customer', 'general', '2983'),
('6028', '2982', 'cust_branch', 'general', '2984'),
('6029', '2982', 'customer', 'general', '2984'),
('6030', '2983', 'cust_branch', 'general', '2985'),
('6031', '2983', 'customer', 'general', '2985'),
('6032', '2984', 'cust_branch', 'general', '2986'),
('6033', '2984', 'customer', 'general', '2986'),
('6034', '2985', 'cust_branch', 'general', '2987'),
('6035', '2985', 'customer', 'general', '2987'),
('6036', '2986', 'cust_branch', 'general', '2988'),
('6037', '2986', 'customer', 'general', '2988'),
('6038', '2987', 'cust_branch', 'general', '2989'),
('6039', '2987', 'customer', 'general', '2989'),
('6040', '2988', 'cust_branch', 'general', '2990'),
('6041', '2988', 'customer', 'general', '2990'),
('6042', '2989', 'cust_branch', 'general', '2991'),
('6043', '2989', 'customer', 'general', '2991'),
('6044', '2990', 'cust_branch', 'general', '2992'),
('6045', '2990', 'customer', 'general', '2992'),
('6046', '2991', 'cust_branch', 'general', '2993'),
('6047', '2991', 'customer', 'general', '2993'),
('6048', '2992', 'cust_branch', 'general', '2994'),
('6049', '2992', 'customer', 'general', '2994'),
('6050', '2993', 'cust_branch', 'general', '2995'),
('6051', '2993', 'customer', 'general', '2995'),
('6052', '2994', 'cust_branch', 'general', '2996'),
('6053', '2994', 'customer', 'general', '2996'),
('6054', '2995', 'cust_branch', 'general', '2997'),
('6055', '2995', 'customer', 'general', '2997'),
('6056', '2996', 'cust_branch', 'general', '2998'),
('6057', '2996', 'customer', 'general', '2998'),
('6058', '2997', 'cust_branch', 'general', '2999'),
('6059', '2997', 'customer', 'general', '2999'),
('6060', '2998', 'cust_branch', 'general', '3000'),
('6061', '2998', 'customer', 'general', '3000'),
('6062', '2999', 'cust_branch', 'general', '3001'),
('6063', '2999', 'customer', 'general', '3001'),
('6064', '3000', 'cust_branch', 'general', '3002'),
('6065', '3000', 'customer', 'general', '3002'),
('6066', '3001', 'cust_branch', 'general', '3003'),
('6067', '3001', 'customer', 'general', '3003'),
('6068', '3002', 'cust_branch', 'general', '3004'),
('6069', '3002', 'customer', 'general', '3004'),
('6070', '3003', 'cust_branch', 'general', '3005'),
('6071', '3003', 'customer', 'general', '3005'),
('6072', '3004', 'cust_branch', 'general', '3006'),
('6073', '3004', 'customer', 'general', '3006'),
('6074', '3005', 'cust_branch', 'general', '3007'),
('6075', '3005', 'customer', 'general', '3007'),
('6076', '3006', 'cust_branch', 'general', '3008'),
('6077', '3006', 'customer', 'general', '3008'),
('6078', '3007', 'cust_branch', 'general', '3009'),
('6079', '3007', 'customer', 'general', '3009'),
('6080', '3008', 'cust_branch', 'general', '3010'),
('6081', '3008', 'customer', 'general', '3010'),
('6082', '3009', 'cust_branch', 'general', '3011'),
('6083', '3009', 'customer', 'general', '3011'),
('6084', '3010', 'cust_branch', 'general', '3012'),
('6085', '3010', 'customer', 'general', '3012'),
('6086', '3011', 'cust_branch', 'general', '3013'),
('6087', '3011', 'customer', 'general', '3013'),
('6088', '3012', 'cust_branch', 'general', '3014'),
('6089', '3012', 'customer', 'general', '3014'),
('6090', '3013', 'cust_branch', 'general', '3015'),
('6091', '3013', 'customer', 'general', '3015'),
('6092', '3014', 'cust_branch', 'general', '3016'),
('6093', '3014', 'customer', 'general', '3016'),
('6094', '3015', 'cust_branch', 'general', '3017'),
('6095', '3015', 'customer', 'general', '3017'),
('6096', '3016', 'cust_branch', 'general', '3018'),
('6097', '3016', 'customer', 'general', '3018'),
('6098', '3017', 'cust_branch', 'general', '3019'),
('6099', '3017', 'customer', 'general', '3019'),
('6100', '3018', 'cust_branch', 'general', '3020'),
('6101', '3018', 'customer', 'general', '3020'),
('6102', '3019', 'cust_branch', 'general', '3021'),
('6103', '3019', 'customer', 'general', '3021'),
('6104', '3020', 'cust_branch', 'general', '3022'),
('6105', '3020', 'customer', 'general', '3022'),
('6106', '3021', 'cust_branch', 'general', '3023'),
('6107', '3021', 'customer', 'general', '3023'),
('6108', '3022', 'cust_branch', 'general', '3024'),
('6109', '3022', 'customer', 'general', '3024'),
('6110', '3023', 'cust_branch', 'general', '3025'),
('6111', '3023', 'customer', 'general', '3025'),
('6112', '3024', 'cust_branch', 'general', '3026'),
('6113', '3024', 'customer', 'general', '3026'),
('6114', '3025', 'cust_branch', 'general', '3027'),
('6115', '3025', 'customer', 'general', '3027'),
('6116', '3026', 'cust_branch', 'general', '3028'),
('6117', '3026', 'customer', 'general', '3028'),
('6118', '3027', 'cust_branch', 'general', '3029'),
('6119', '3027', 'customer', 'general', '3029'),
('6120', '3028', 'cust_branch', 'general', '3030'),
('6121', '3028', 'customer', 'general', '3030'),
('6122', '3029', 'cust_branch', 'general', '3031'),
('6123', '3029', 'customer', 'general', '3031'),
('6124', '3030', 'cust_branch', 'general', '3032'),
('6125', '3030', 'customer', 'general', '3032'),
('6126', '3031', 'cust_branch', 'general', '3033'),
('6127', '3031', 'customer', 'general', '3033'),
('6128', '3032', 'cust_branch', 'general', '3034'),
('6129', '3032', 'customer', 'general', '3034'),
('6130', '3033', 'cust_branch', 'general', '3035'),
('6131', '3033', 'customer', 'general', '3035'),
('6132', '3034', 'cust_branch', 'general', '3036'),
('6133', '3034', 'customer', 'general', '3036'),
('6134', '3035', 'cust_branch', 'general', '3037'),
('6135', '3035', 'customer', 'general', '3037'),
('6136', '3036', 'cust_branch', 'general', '3038'),
('6137', '3036', 'customer', 'general', '3038'),
('6138', '3037', 'cust_branch', 'general', '3039'),
('6139', '3037', 'customer', 'general', '3039'),
('6140', '3038', 'cust_branch', 'general', '3040'),
('6141', '3038', 'customer', 'general', '3040'),
('6142', '3039', 'cust_branch', 'general', '3041'),
('6143', '3039', 'customer', 'general', '3041'),
('6144', '3040', 'cust_branch', 'general', '3042'),
('6145', '3040', 'customer', 'general', '3042'),
('6146', '3041', 'cust_branch', 'general', '3043'),
('6147', '3041', 'customer', 'general', '3043'),
('6148', '3042', 'cust_branch', 'general', '3044'),
('6149', '3042', 'customer', 'general', '3044'),
('6150', '3043', 'cust_branch', 'general', '3045'),
('6151', '3043', 'customer', 'general', '3045'),
('6152', '3044', 'cust_branch', 'general', '3046'),
('6153', '3044', 'customer', 'general', '3046'),
('6154', '3045', 'cust_branch', 'general', '3047'),
('6155', '3045', 'customer', 'general', '3047'),
('6156', '3046', 'cust_branch', 'general', '3048'),
('6157', '3046', 'customer', 'general', '3048'),
('6158', '3047', 'cust_branch', 'general', '3049'),
('6159', '3047', 'customer', 'general', '3049'),
('6160', '3048', 'cust_branch', 'general', '3050'),
('6161', '3048', 'customer', 'general', '3050'),
('6162', '3049', 'cust_branch', 'general', '3051'),
('6163', '3049', 'customer', 'general', '3051'),
('6164', '3050', 'cust_branch', 'general', '3052'),
('6165', '3050', 'customer', 'general', '3052'),
('6166', '3051', 'cust_branch', 'general', '3053'),
('6167', '3051', 'customer', 'general', '3053'),
('6168', '3052', 'cust_branch', 'general', '3054'),
('6169', '3052', 'customer', 'general', '3054'),
('6170', '3053', 'cust_branch', 'general', '3055'),
('6171', '3053', 'customer', 'general', '3055'),
('6172', '3054', 'cust_branch', 'general', '3056'),
('6173', '3054', 'customer', 'general', '3056'),
('6174', '3055', 'cust_branch', 'general', '3057'),
('6175', '3055', 'customer', 'general', '3057'),
('6176', '3056', 'cust_branch', 'general', '3058'),
('6177', '3056', 'customer', 'general', '3058'),
('6178', '3057', 'cust_branch', 'general', '3059'),
('6179', '3057', 'customer', 'general', '3059'),
('6180', '3058', 'cust_branch', 'general', '3060'),
('6181', '3058', 'customer', 'general', '3060'),
('6182', '3059', 'cust_branch', 'general', '3061'),
('6183', '3059', 'customer', 'general', '3061'),
('6184', '3060', 'cust_branch', 'general', '3062'),
('6185', '3060', 'customer', 'general', '3062'),
('6186', '3061', 'cust_branch', 'general', '3063'),
('6187', '3061', 'customer', 'general', '3063'),
('6188', '3062', 'cust_branch', 'general', '3064'),
('6189', '3062', 'customer', 'general', '3064'),
('6190', '3063', 'cust_branch', 'general', '3065'),
('6191', '3063', 'customer', 'general', '3065'),
('6192', '3064', 'cust_branch', 'general', '3066'),
('6193', '3064', 'customer', 'general', '3066'),
('6194', '3065', 'cust_branch', 'general', '3067'),
('6195', '3065', 'customer', 'general', '3067'),
('6196', '3066', 'cust_branch', 'general', '3068'),
('6197', '3066', 'customer', 'general', '3068'),
('6198', '3067', 'cust_branch', 'general', '3069'),
('6199', '3067', 'customer', 'general', '3069'),
('6200', '3068', 'cust_branch', 'general', '3070'),
('6201', '3068', 'customer', 'general', '3070'),
('6202', '3069', 'cust_branch', 'general', '3071'),
('6203', '3069', 'customer', 'general', '3071'),
('6204', '3070', 'cust_branch', 'general', '3072'),
('6205', '3070', 'customer', 'general', '3072'),
('6206', '3071', 'cust_branch', 'general', '3073'),
('6207', '3071', 'customer', 'general', '3073'),
('6208', '3072', 'cust_branch', 'general', '3074'),
('6209', '3072', 'customer', 'general', '3074'),
('6210', '3073', 'cust_branch', 'general', '3075'),
('6211', '3073', 'customer', 'general', '3075'),
('6212', '3074', 'cust_branch', 'general', '3076'),
('6213', '3074', 'customer', 'general', '3076'),
('6214', '3075', 'cust_branch', 'general', '3077'),
('6215', '3075', 'customer', 'general', '3077'),
('6216', '3076', 'cust_branch', 'general', '3078'),
('6217', '3076', 'customer', 'general', '3078'),
('6218', '3077', 'cust_branch', 'general', '3079'),
('6219', '3077', 'customer', 'general', '3079'),
('6220', '3078', 'cust_branch', 'general', '3080'),
('6221', '3078', 'customer', 'general', '3080'),
('6222', '3079', 'cust_branch', 'general', '3081'),
('6223', '3079', 'customer', 'general', '3081'),
('6224', '3080', 'cust_branch', 'general', '3082'),
('6225', '3080', 'customer', 'general', '3082'),
('6226', '3081', 'cust_branch', 'general', '3083'),
('6227', '3081', 'customer', 'general', '3083'),
('6228', '3082', 'cust_branch', 'general', '3084'),
('6229', '3082', 'customer', 'general', '3084'),
('6230', '3083', 'cust_branch', 'general', '3085'),
('6231', '3083', 'customer', 'general', '3085'),
('6232', '3084', 'cust_branch', 'general', '3086'),
('6233', '3084', 'customer', 'general', '3086'),
('6234', '3085', 'cust_branch', 'general', '3087'),
('6235', '3085', 'customer', 'general', '3087'),
('6236', '3086', 'cust_branch', 'general', '3088'),
('6237', '3086', 'customer', 'general', '3088'),
('6238', '3087', 'cust_branch', 'general', '3089'),
('6239', '3087', 'customer', 'general', '3089'),
('6240', '3088', 'cust_branch', 'general', '3090'),
('6241', '3088', 'customer', 'general', '3090'),
('6242', '3089', 'cust_branch', 'general', '3091'),
('6243', '3089', 'customer', 'general', '3091'),
('6244', '3090', 'cust_branch', 'general', '3092'),
('6245', '3090', 'customer', 'general', '3092'),
('6246', '3091', 'cust_branch', 'general', '3093'),
('6247', '3091', 'customer', 'general', '3093'),
('6248', '3092', 'cust_branch', 'general', '3094'),
('6249', '3092', 'customer', 'general', '3094'),
('6250', '3093', 'cust_branch', 'general', '3095'),
('6251', '3093', 'customer', 'general', '3095'),
('6252', '3094', 'cust_branch', 'general', '3096'),
('6253', '3094', 'customer', 'general', '3096'),
('6254', '3095', 'cust_branch', 'general', '3097'),
('6255', '3095', 'customer', 'general', '3097'),
('6256', '3096', 'cust_branch', 'general', '3098'),
('6257', '3096', 'customer', 'general', '3098'),
('6258', '3097', 'cust_branch', 'general', '3099'),
('6259', '3097', 'customer', 'general', '3099'),
('6260', '3098', 'cust_branch', 'general', '3100'),
('6261', '3098', 'customer', 'general', '3100'),
('6262', '3099', 'cust_branch', 'general', '3101'),
('6263', '3099', 'customer', 'general', '3101'),
('6264', '3100', 'cust_branch', 'general', '3102'),
('6265', '3100', 'customer', 'general', '3102'),
('6266', '3101', 'cust_branch', 'general', '3103'),
('6267', '3101', 'customer', 'general', '3103'),
('6268', '3102', 'cust_branch', 'general', '3104'),
('6269', '3102', 'customer', 'general', '3104'),
('6270', '3103', 'cust_branch', 'general', '3105'),
('6271', '3103', 'customer', 'general', '3105'),
('6272', '3104', 'cust_branch', 'general', '3106'),
('6273', '3104', 'customer', 'general', '3106'),
('6274', '3105', 'cust_branch', 'general', '3107'),
('6275', '3105', 'customer', 'general', '3107'),
('6276', '3106', 'cust_branch', 'general', '3108'),
('6277', '3106', 'customer', 'general', '3108'),
('6278', '3107', 'cust_branch', 'general', '3109'),
('6279', '3107', 'customer', 'general', '3109'),
('6280', '3108', 'cust_branch', 'general', '3110'),
('6281', '3108', 'customer', 'general', '3110'),
('6282', '3109', 'cust_branch', 'general', '3111'),
('6283', '3109', 'customer', 'general', '3111'),
('6284', '3110', 'cust_branch', 'general', '3112'),
('6285', '3110', 'customer', 'general', '3112'),
('6286', '3111', 'cust_branch', 'general', '3113'),
('6287', '3111', 'customer', 'general', '3113'),
('6288', '3112', 'cust_branch', 'general', '3114'),
('6289', '3112', 'customer', 'general', '3114'),
('6290', '3113', 'cust_branch', 'general', '3115'),
('6291', '3113', 'customer', 'general', '3115'),
('6292', '3114', 'cust_branch', 'general', '3116'),
('6293', '3114', 'customer', 'general', '3116'),
('6294', '3115', 'cust_branch', 'general', '3117'),
('6295', '3115', 'customer', 'general', '3117'),
('6296', '3116', 'cust_branch', 'general', '3118'),
('6297', '3116', 'customer', 'general', '3118'),
('6298', '3117', 'cust_branch', 'general', '3119'),
('6299', '3117', 'customer', 'general', '3119'),
('6300', '3118', 'cust_branch', 'general', '3120'),
('6301', '3118', 'customer', 'general', '3120'),
('6302', '3119', 'cust_branch', 'general', '3121'),
('6303', '3119', 'customer', 'general', '3121'),
('6304', '3120', 'cust_branch', 'general', '3122'),
('6305', '3120', 'customer', 'general', '3122');
INSERT INTO `0_crm_contacts` VALUES
('6306', '3121', 'cust_branch', 'general', '3123'),
('6307', '3121', 'customer', 'general', '3123'),
('6308', '3122', 'cust_branch', 'general', '3124'),
('6309', '3122', 'customer', 'general', '3124'),
('6310', '3123', 'cust_branch', 'general', '3125'),
('6311', '3123', 'customer', 'general', '3125'),
('6312', '3124', 'cust_branch', 'general', '3126'),
('6313', '3124', 'customer', 'general', '3126'),
('6314', '3125', 'cust_branch', 'general', '3127'),
('6315', '3125', 'customer', 'general', '3127'),
('6316', '3126', 'cust_branch', 'general', '3128'),
('6317', '3126', 'customer', 'general', '3128'),
('6318', '3127', 'cust_branch', 'general', '3129'),
('6319', '3127', 'customer', 'general', '3129'),
('6320', '3128', 'cust_branch', 'general', '3130'),
('6321', '3128', 'customer', 'general', '3130'),
('6322', '3129', 'cust_branch', 'general', '3131'),
('6323', '3129', 'customer', 'general', '3131'),
('6324', '3130', 'cust_branch', 'general', '3132'),
('6325', '3130', 'customer', 'general', '3132'),
('6326', '3131', 'cust_branch', 'general', '3133'),
('6327', '3131', 'customer', 'general', '3133'),
('6328', '3132', 'cust_branch', 'general', '3134'),
('6329', '3132', 'customer', 'general', '3134'),
('6330', '3133', 'cust_branch', 'general', '3135'),
('6331', '3133', 'customer', 'general', '3135'),
('6332', '3134', 'cust_branch', 'general', '3136'),
('6333', '3134', 'customer', 'general', '3136'),
('6334', '3135', 'cust_branch', 'general', '3137'),
('6335', '3135', 'customer', 'general', '3137'),
('6336', '3136', 'cust_branch', 'general', '3138'),
('6337', '3136', 'customer', 'general', '3138'),
('6338', '3137', 'cust_branch', 'general', '3139'),
('6339', '3137', 'customer', 'general', '3139'),
('6340', '3138', 'cust_branch', 'general', '3140'),
('6341', '3138', 'customer', 'general', '3140'),
('6342', '3139', 'cust_branch', 'general', '3141'),
('6343', '3139', 'customer', 'general', '3141'),
('6344', '3140', 'cust_branch', 'general', '3142'),
('6345', '3140', 'customer', 'general', '3142'),
('6346', '3141', 'cust_branch', 'general', '3143'),
('6347', '3141', 'customer', 'general', '3143'),
('6348', '3142', 'cust_branch', 'general', '3144'),
('6349', '3142', 'customer', 'general', '3144'),
('6350', '3143', 'cust_branch', 'general', '3145'),
('6351', '3143', 'customer', 'general', '3145'),
('6352', '3144', 'cust_branch', 'general', '3146'),
('6353', '3144', 'customer', 'general', '3146'),
('6354', '3145', 'cust_branch', 'general', '3147'),
('6355', '3145', 'customer', 'general', '3147'),
('6356', '3146', 'cust_branch', 'general', '3148'),
('6357', '3146', 'customer', 'general', '3148'),
('6358', '3147', 'cust_branch', 'general', '3149'),
('6359', '3147', 'customer', 'general', '3149'),
('6360', '3148', 'cust_branch', 'general', '3150'),
('6361', '3148', 'customer', 'general', '3150'),
('6362', '3149', 'cust_branch', 'general', '3151'),
('6363', '3149', 'customer', 'general', '3151'),
('6364', '3150', 'cust_branch', 'general', '3152'),
('6365', '3150', 'customer', 'general', '3152'),
('6366', '3151', 'cust_branch', 'general', '3153'),
('6367', '3151', 'customer', 'general', '3153'),
('6368', '3152', 'cust_branch', 'general', '3154'),
('6369', '3152', 'customer', 'general', '3154'),
('6370', '3153', 'cust_branch', 'general', '3155'),
('6371', '3153', 'customer', 'general', '3155'),
('6372', '3154', 'cust_branch', 'general', '3156'),
('6373', '3154', 'customer', 'general', '3156'),
('6374', '3155', 'cust_branch', 'general', '3157'),
('6375', '3155', 'customer', 'general', '3157'),
('6376', '3156', 'cust_branch', 'general', '3158'),
('6377', '3156', 'customer', 'general', '3158'),
('6378', '3157', 'cust_branch', 'general', '3159'),
('6379', '3157', 'customer', 'general', '3159'),
('6380', '3158', 'cust_branch', 'general', '3160'),
('6381', '3158', 'customer', 'general', '3160'),
('6382', '3159', 'cust_branch', 'general', '3161'),
('6383', '3159', 'customer', 'general', '3161'),
('6384', '3160', 'cust_branch', 'general', '3162'),
('6385', '3160', 'customer', 'general', '3162'),
('6386', '3161', 'cust_branch', 'general', '3163'),
('6387', '3161', 'customer', 'general', '3163'),
('6388', '3162', 'cust_branch', 'general', '3164'),
('6389', '3162', 'customer', 'general', '3164'),
('6390', '3163', 'cust_branch', 'general', '3165'),
('6391', '3163', 'customer', 'general', '3165'),
('6392', '3164', 'cust_branch', 'general', '3166'),
('6393', '3164', 'customer', 'general', '3166'),
('6394', '3165', 'cust_branch', 'general', '3167'),
('6395', '3165', 'customer', 'general', '3167'),
('6396', '3166', 'cust_branch', 'general', '3168'),
('6397', '3166', 'customer', 'general', '3168'),
('6398', '3167', 'cust_branch', 'general', '3169'),
('6399', '3167', 'customer', 'general', '3169'),
('6400', '3168', 'cust_branch', 'general', '3170'),
('6401', '3168', 'customer', 'general', '3170'),
('6402', '3169', 'cust_branch', 'general', '3171'),
('6403', '3169', 'customer', 'general', '3171'),
('6404', '3170', 'cust_branch', 'general', '3172'),
('6405', '3170', 'customer', 'general', '3172'),
('6406', '3171', 'cust_branch', 'general', '3173'),
('6407', '3171', 'customer', 'general', '3173'),
('6408', '3172', 'cust_branch', 'general', '3174'),
('6409', '3172', 'customer', 'general', '3174'),
('6410', '3173', 'cust_branch', 'general', '3175'),
('6411', '3173', 'customer', 'general', '3175'),
('6412', '3174', 'cust_branch', 'general', '3176'),
('6413', '3174', 'customer', 'general', '3176'),
('6414', '3175', 'cust_branch', 'general', '3177'),
('6415', '3175', 'customer', 'general', '3177'),
('6416', '3176', 'cust_branch', 'general', '3178'),
('6417', '3176', 'customer', 'general', '3178'),
('6418', '3177', 'cust_branch', 'general', '3179'),
('6419', '3177', 'customer', 'general', '3179'),
('6420', '3178', 'cust_branch', 'general', '3180'),
('6421', '3178', 'customer', 'general', '3180'),
('6422', '3179', 'cust_branch', 'general', '3181'),
('6423', '3179', 'customer', 'general', '3181'),
('6424', '3180', 'cust_branch', 'general', '3182'),
('6425', '3180', 'customer', 'general', '3182'),
('6426', '3181', 'cust_branch', 'general', '3183'),
('6427', '3181', 'customer', 'general', '3183'),
('6428', '3182', 'cust_branch', 'general', '3184'),
('6429', '3182', 'customer', 'general', '3184'),
('6430', '3183', 'cust_branch', 'general', '3185'),
('6431', '3183', 'customer', 'general', '3185'),
('6432', '3184', 'cust_branch', 'general', '3186'),
('6433', '3184', 'customer', 'general', '3186'),
('6434', '3185', 'cust_branch', 'general', '3187'),
('6435', '3185', 'customer', 'general', '3187'),
('6436', '3186', 'cust_branch', 'general', '3188'),
('6437', '3186', 'customer', 'general', '3188'),
('6438', '3187', 'cust_branch', 'general', '3189'),
('6439', '3187', 'customer', 'general', '3189'),
('6440', '3188', 'cust_branch', 'general', '3190'),
('6441', '3188', 'customer', 'general', '3190'),
('6442', '3189', 'cust_branch', 'general', '3191'),
('6443', '3189', 'customer', 'general', '3191'),
('6444', '3190', 'cust_branch', 'general', '3192'),
('6445', '3190', 'customer', 'general', '3192'),
('6446', '3191', 'cust_branch', 'general', '3193'),
('6447', '3191', 'customer', 'general', '3193'),
('6448', '3192', 'cust_branch', 'general', '3194'),
('6449', '3192', 'customer', 'general', '3194'),
('6450', '3193', 'cust_branch', 'general', '3195'),
('6451', '3193', 'customer', 'general', '3195'),
('6452', '3194', 'cust_branch', 'general', '3196'),
('6453', '3194', 'customer', 'general', '3196'),
('6454', '3195', 'cust_branch', 'general', '3197'),
('6455', '3195', 'customer', 'general', '3197'),
('6456', '3196', 'cust_branch', 'general', '3198'),
('6457', '3196', 'customer', 'general', '3198'),
('6458', '3197', 'cust_branch', 'general', '3199'),
('6459', '3197', 'customer', 'general', '3199'),
('6460', '3198', 'cust_branch', 'general', '3200'),
('6461', '3198', 'customer', 'general', '3200');

### Structure of table `0_crm_persons` ###

DROP TABLE IF EXISTS `0_crm_persons`;

CREATE TABLE `0_crm_persons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) NOT NULL,
  `name` varchar(60) NOT NULL,
  `name2` varchar(60) DEFAULT NULL,
  `address` tinytext,
  `phone` varchar(30) DEFAULT NULL,
  `phone2` varchar(30) DEFAULT NULL,
  `fax` varchar(30) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `lang` char(5) DEFAULT NULL,
  `notes` tinytext NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ref` (`ref`)
) ENGINE=InnoDB AUTO_INCREMENT=3199 DEFAULT CHARSET=latin1 ;

### Data of table `0_crm_persons` ###

INSERT INTO `0_crm_persons` VALUES
('1', 'Perez', '10104598', NULL, '10104598', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2', 'Ramirez', '454654654', NULL, '454654654', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3', 'DOMINGO SANCHEZ EGUEZ', '3296545', NULL, '3296545', NULL, NULL, NULL, NULL, NULL, '', '0'),
('4', 'MARCO SILVA', 'm_silva_2002@hotmail.com', NULL, 'm_silva_2002@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('5', 'SAVI S.R.L.', 'marlitorivas@hotmail.com', NULL, 'marlitorivas@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('6', 'Ricardo Roda', 'migrabol.scz@gmail.com', NULL, 'migrabol.scz@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('7', 'EDGAR MAMANI QUISPE', 'quismas70@hotmail.com', NULL, 'quismas70@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('8', 'CENTRO DE ESTUDIOS Y APOYO AL ', 'vicoalano@gmail.com', NULL, 'vicoalano@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('9', 'ROMY MONTENEGRO', 'romisita_13@hotmail.com', NULL, 'romisita_13@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('10', 'TOBOROCHI SUITES S.R.L.', 'ritzerflores1982@gmail.com', NULL, 'ritzerflores1982@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('11', 'EFRAIN TIINI TIINI', 'efra_tiin@hotmail.com', NULL, 'efra_tiin@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('12', 'YVANA ARREDONDO CORIA', 'yvanarredondo@hotmail.com', NULL, 'yvanarredondo@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('13', 'Erwin Galarza Velasco', 'erwingv24@gmail.com', NULL, 'erwingv24@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('14', 'IBERICA S.R.L.', 'rbalcazar@ibericasrl.com', NULL, 'rbalcazar@ibericasrl.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('15', 'MARCELA JUSTINIANO', 'cvargasz@gmail.com', NULL, 'cvargasz@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('16', 'DIGITALWORK S.A.', 'ccartagena@vuela.bo', NULL, 'ccartagena@vuela.bo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('17', 'RAMOS', 'juan.ramos@laqfagal.com', NULL, 'juan.ramos@laqfagal.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('18', 'MICHAEL AVILA', 'jmas_26@hotmail.com', NULL, 'jmas_26@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('19', 'SOFGOM S.R.L.', 'info@sofgom.com', NULL, 'info@sofgom.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('20', 'DAVID BELTRAN', 'contadordb@outlook.com', NULL, 'contadordb@outlook.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('21', 'Argandoa', 'vjavier.arg@gmail.com', NULL, 'vjavier.arg@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('22', 'P.A.D.I.C. S.R.L.', 'jchirveches@padic-srl.com', NULL, 'jchirveches@padic-srl.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('23', 'Leandro Tumiri Lazcano', 'lean_305@hotmail.com', NULL, 'lean_305@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('24', 'Pelaez ', 'priscilapelaezzeballos@hotmail', NULL, 'priscilapelaezzeballos@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('25', 'Denard Mendez', 'dmendezperez@hotmail.com', NULL, 'dmendezperez@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('26', 'DYL CHACO LTDA.', 'sebastian.majlufbw@gmail.com', NULL, 'sebastian.majlufbw@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('27', 'ODESPRO S.R.L.', 'mcaceres@odespro.com', NULL, 'mcaceres@odespro.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('28', 'Junior Galvao', 'junior.galvao.h@gmail.com', NULL, 'junior.galvao.h@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('29', 'PREFORTE S.A.', 'mrevollo@preforte.com.bo', NULL, 'mrevollo@preforte.com.bo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('30', 'DOMINGO SANCHEZ EGUEZ', 'mingoeguez@hotmail.com', NULL, 'mingoeguez@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('31', 'TELEFERICOS DOPPELMAYR BOLIVIA', 'adrian.ledezma@doppelmayr.com', NULL, 'adrian.ledezma@doppelmayr.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('32', 'EVIA', 'fabianlozapaz@gmail.com', NULL, 'fabianlozapaz@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('33', 'Pacheco', 'belaiso08@gmail.com', NULL, 'belaiso08@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('34', 'AUDIADMI S.R.L. AUDITORES Y CO', 'francuve79@hotmail.com', NULL, 'francuve79@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('35', 'HAROLD ALMARAZ S.', 'aldo.aramayo04@hotmail.com', NULL, 'aldo.aramayo04@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('36', 'LIDIA GUARACHI CHIPATA', 'nurkis_18@hotmail.com', NULL, 'nurkis_18@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('37', 'GRUPO PALANTIR S.R.L.', 'zaulo.vasquez@gmail.com', NULL, 'zaulo.vasquez@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('38', 'Miguel Sirpa', 'miguel.sirpa@gmail.com', NULL, 'miguel.sirpa@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('39', 'Giovanna Gutierrez', 'giovannagutierrezfa@hotmail.co', NULL, 'giovannagutierrezfa@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('40', 'BP-TEK S.R.L.', 'melisa_pardo@hotmail.com', NULL, 'melisa_pardo@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('41', 'Ramos Calderon Auditores S.R.L', 'ramiro_calderon76@hotmail.com', NULL, 'ramiro_calderon76@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('42', 'MCOM S.R.L.', 'omedina_rojo@hotmail.com', NULL, 'omedina_rojo@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('43', 'Juan Paolo Paris Siles', 'sercontpyt@gmail.com', NULL, 'sercontpyt@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('44', 'SABIAZUL S.R.L.', 're_esed@hotmail.com', NULL, 're_esed@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('45', 'RODRIGUEZ', 'jmarisolqm@hotmail.com', NULL, 'jmarisolqm@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('46', 'HERRERA', 'herrera.heydi@gmail.com', NULL, 'herrera.heydi@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('47', 'FLORES ', 'rfloresadrian@gmail.com', NULL, 'rfloresadrian@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('48', 'CARMEN TINCUTA VALENCIA', 'tv.karmen@gmail.com', NULL, 'tv.karmen@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('49', 'Carolina Fernndez Choque', 'consultorahuarache@gmail.com', NULL, 'consultorahuarache@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('50', 'Nitza Morales', 'nitzamorales@gmail.com', NULL, 'nitzamorales@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('51', 'COPERAGRA S.R.L.', 'vargaslorgio@gmail.com', NULL, 'vargaslorgio@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('52', 'Enrique Luis Cruz Villarroel', 'marcia_montano_s@hotmail.com', NULL, 'marcia_montano_s@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('53', 'Bohiva Engineering S.R.L.', 'rrg@bohiva.com', NULL, 'rrg@bohiva.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('54', 'Laboratorio Bio Medic S.R.L.', 'dbiomedic.2015@hotmail.com', NULL, 'dbiomedic.2015@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('55', 'ORTIZ', 'jortiz_salas@hotmail.com', NULL, 'jortiz_salas@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('56', 'Christian Lpez', 'chris.w.lopez@gmail.com', NULL, 'chris.w.lopez@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('57', 'Gitec Consult GmbH Sucursal Bo', 'jj.castro@gitec-consult.com', NULL, 'jj.castro@gitec-consult.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('58', 'SOTCO LTDA.', 'sotco.cotizaciones@gmail.com', NULL, 'sotco.cotizaciones@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('59', 'Augusto Silicuana', 'asilicuana@hotmail.com', NULL, 'asilicuana@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('60', 'WIDMAN INTERNATIONAL S.R.L.', 'miguelangel.rocha@widman.biz', NULL, 'miguelangel.rocha@widman.biz', NULL, NULL, NULL, NULL, NULL, '', '0'),
('61', 'PABLO JIMENEZ SANTA CRUZ', 'pablo_jsc76@outlook.com', NULL, 'pablo_jsc76@outlook.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('62', 'Daniel Perez', 'dperezz@gmail.com', NULL, 'dperezz@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('63', 'Jhonny Montao Ramirez', 'kadmielbolivia@hotmail.com', NULL, 'kadmielbolivia@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('64', 'Audiwork S.R.L.', 'juanjitoramos@gmail.com', NULL, 'juanjitoramos@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('65', 'JUAN CARLOS GUZMAN', 'g-asesores@hotmail.com', NULL, 'g-asesores@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('66', 'HERRERA', 'giovannaherrera23@hotmail.com', NULL, 'giovannaherrera23@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('67', 'David Manzano Souza', 'gerencia.rialtopatrol@hotmail.', NULL, 'gerencia.rialtopatrol@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('68', 'Rioyata Madera Import. Export.', 'chalicito74@hotmail.com', NULL, 'chalicito74@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('69', 'UNIVERSAL BROKERS S.A.', 'xavier.palenque@unibrosa.com.b', NULL, 'xavier.palenque@unibrosa.com.bo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('70', 'Flores', 'christian.sin.faan@gmail.com', NULL, 'christian.sin.faan@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('71', 'Freddy Gutirrez', 'freddygutierrez@outlook.com', NULL, 'freddygutierrez@outlook.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('72', 'MOAN S.R.L.', 'kennethapaza@gmail.com', NULL, 'kennethapaza@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('73', 'CENTRO DE INVESTIGACIONES Y DE', 'ana_churqui@hotmail.com', NULL, 'ana_churqui@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('74', 'INMOBILIARIA UBC S.R.L.', 'rcanedo101@gmail.com', NULL, 'rcanedo101@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('75', 'MARIA YSABEL MENACHO MORRORE', 'mariaysabel_mm75@hotmail.com', NULL, 'mariaysabel_mm75@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('76', 'LOPEZ MUJICA S.R.L.', 'lopezmujica.asociados@gmail.co', NULL, 'lopezmujica.asociados@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('77', 'PABLO ROCA', 'procaspt@gmail.com', NULL, 'procaspt@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('78', 'Ana Eisa Montao Flores', 'ana-eisamf@hotmail.com', NULL, 'ana-eisamf@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('79', 'Marianela Salinas Montero', 'marianelasalinasmontero@gmail.', NULL, 'marianelasalinasmontero@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('80', 'RAMIRO CHOQUE CHOQUE', 'ramiroadmconta@hotmail.com', NULL, 'ramiroadmconta@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('81', 'Eduardo Olivo', 'fparada@sudseguros.com', NULL, 'fparada@sudseguros.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('82', 'Edward Fernandez Zurita', 'edward.fernandez@fernandezcons', NULL, 'edward.fernandez@fernandezconsultores.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('83', 'Rafael Agustin Tejada', 'administracion@metalurgicateja', NULL, 'administracion@metalurgicatejada.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('84', 'Gonzales', 'm.elytabb@hotmail.com', NULL, 'm.elytabb@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('85', 'Edgar Delgado Quintana', 'edgar.delgadoquintana@gmail.co', NULL, 'edgar.delgadoquintana@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('86', 'Mano a Mano Internacional', 'ryusoalex@gmail.com', NULL, 'ryusoalex@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('87', 'Tonconi', 'lucytm756@gmail.com', NULL, 'lucytm756@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('88', 'TERRAMIA S.A.', 'marcelo.cortez@terramiaresort.', NULL, 'marcelo.cortez@terramiaresort.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('89', 'FERNANDEZ', 'luz_fernandez_7@hotmail.com', NULL, 'luz_fernandez_7@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('90', 'RAMIRO VELASQUEZ LA FUENTE', 'mividaperla@gmail.com', NULL, 'mividaperla@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('91', 'POK HA BEK S.R.L.', 'yavi_852@hotmail.com', NULL, 'yavi_852@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('92', 'Manuel Robin Galindo Vale', 'mrgv1986@gmail.com', NULL, 'mrgv1986@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('93', 'Omar Saucedo Franco', 'omsafran@gmail.com', NULL, 'omsafran@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('94', 'LEBRAND S.R.L.', 'guiselasuarez@bpocenter.com.bo', NULL, 'guiselasuarez@bpocenter.com.bo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('95', 'ANGULO', 'nangulo@gruval.com', NULL, 'nangulo@gruval.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('96', 'URBANOVA DESARROLLOS URBANOS S', 'rmontano@micasamivida.bo', NULL, 'rmontano@micasamivida.bo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('97', 'ESPINOZA', 'e_espinoza75@hotmail.com', NULL, 'e_espinoza75@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('98', 'RAMON LEDEZMA ZAMBRANA', 'rledezmaz@hotmail.com', NULL, 'rledezmaz@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('99', 'ABEL GARCIA BLANCO', 'abel-garcia-blanco@hotmail.com', NULL, 'abel-garcia-blanco@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('100', 'Maria Angelica Calle Chambi', 'anyi.cch@gmail.com', NULL, 'anyi.cch@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('101', 'NINA', 'nfaby22@hotmail.com', NULL, 'nfaby22@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('102', 'Moises Huayta Morales', 'moihuaytam@hotmail.com', NULL, 'moihuaytam@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('103', 'EQUIPOS MORI S.R.L.', 'marcelomendivil@hotmail.com', NULL, 'marcelomendivil@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('104', 'MARIBEL CRESPO SORIA', 'maribel_mafvaf@hotmail.com', NULL, 'maribel_mafvaf@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('105', 'Virginia Soliz de Becerra', 'vsoliz_becerra@hotmail.com', NULL, 'vsoliz_becerra@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('106', 'Nils Maldonado', 'nils_maldonado@sci.com.bo', NULL, 'nils_maldonado@sci.com.bo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('107', 'INDSOL S.R.L.', 'gcornejo@ind-sol.com', NULL, 'gcornejo@ind-sol.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('108', 'MVO CONSTRUCCIONES &amp; SERVI', 'dvillarroel@mvoconstrucciones.', NULL, 'dvillarroel@mvoconstrucciones.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('109', 'CER LTDA.', 'tmacury25@hotmail.com', NULL, 'tmacury25@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('110', 'EMPRESA CONSTRUCTORA GYC S.R.L', 'hugocaballero1962@gmail.com', NULL, 'hugocaballero1962@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('111', 'IRIARTE ROJAS', 'maria_luisa37@hotmail.com', NULL, 'maria_luisa37@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('112', 'Nelo Stanley Pedrazas', 'o_gilda_klondy@hotmail.com', NULL, 'o_gilda_klondy@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('113', 'Wilson Yavi Quiroz', 'wilson.yavi@outlook.com', NULL, 'wilson.yavi@outlook.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('114', 'Ezequiel Hurtado Aponte', 'ezequiel_hurtado@hotmail.com', NULL, 'ezequiel_hurtado@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('115', 'RAQUEL YOVANA TAPIA ESPINOZA', 'raquel.yovana.tapia.espinoza@', NULL, 'raquel.yovana.tapia.espinoza@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('116', 'LUIS FERNANDO MARQUEZ', 'lourdesacosta2507@gmail.com', NULL, 'lourdesacosta2507@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('117', 'VARGAS', 'dvargas@legal.bo', NULL, 'dvargas@legal.bo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('118', 'Pirai Ltda. Agencia Despachant', 'pedroedwinmamani@gmail.com', NULL, 'pedroedwinmamani@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('119', 'Yolanda Vsquez Escobar', 'yvasquez@lacasadelalbanil.com', NULL, 'yvasquez@lacasadelalbanil.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('120', 'ORELLANA', 'construtech.10@gmail.com', NULL, 'construtech.10@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('121', 'SOMIVILLA S.R.L.', 'SOMIVILLASRL-2015@HOTMAIL.COM', NULL, 'SOMIVILLASRL-2015@HOTMAIL.COM', NULL, NULL, NULL, NULL, NULL, '', '0'),
('122', 'EMPETROL S.R.L.', 'ruddy_novoa@hotmail.com', NULL, 'ruddy_novoa@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('123', 'Bertha Rojas', 'bertharojasve@hotmail.com', NULL, 'bertharojasve@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('124', 'Torrico Julieta ', 'juli_torrico@hotmail.com', NULL, 'juli_torrico@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('125', 'Garcia', 'jacky_leo@hotmail.es', NULL, 'jacky_leo@hotmail.es', NULL, NULL, NULL, NULL, NULL, '', '0'),
('126', 'RENAN OSCAR BOZO ROJAS', 'oscarbozorojas@gmail.com', NULL, 'oscarbozorojas@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('127', 'Elvira Villagra', 'villagraoscar@gmail.com', NULL, 'villagraoscar@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('128', 'SALAZAR', 'imperator.scz@gmail.com', NULL, 'imperator.scz@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('129', 'C.E.H.S. S.R.L.', 'karinarico@hotmail.com', NULL, 'karinarico@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('130', 'Ach', 'zwapec14@gmail.com', NULL, 'zwapec14@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('131', 'SALAZAR Y MACHICADO S.A.', 'alannia.rojas@salazarbolivia.c', NULL, 'alannia.rojas@salazarbolivia.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('132', 'BOLIVIAN CONSTRUCTION COMPANY ', 'arnaldysp@gmail.com ', NULL, 'arnaldysp@gmail.com ', NULL, NULL, NULL, NULL, NULL, '', '0'),
('133', 'CHOQUE', 'w.illycalle@hotmail.com', NULL, 'w.illycalle@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('134', 'Lenny Olivera Flores', 'lenniluc123@gmail.com', NULL, 'lenniluc123@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('135', 'Vargas ', 'mirko_v8@hotmail.com', NULL, 'mirko_v8@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('136', 'CEPRA', 'giselvb@hotmail.com', NULL, 'giselvb@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('137', 'Juan Manuel Zelaya', 'zejuanma@hotmail.com', NULL, 'zejuanma@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('138', 'Ludmila Cadima Villegas', 'lcadima059@gmail.com', NULL, 'lcadima059@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('139', 'BENTEX Ltda.', 'bentex@bentex.com.bo', NULL, 'bentex@bentex.com.bo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('140', 'ITACAMBA CEMENTO S.A.', 'richard.almendras@itacamba.com', NULL, 'richard.almendras@itacamba.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('141', 'Gerardo Bhrt', 'gerardo.bohrt@gmail.com', NULL, 'gerardo.bohrt@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('142', 'Mario Choque ', 'mchoque_@hotmail.com', NULL, 'mchoque_@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('143', 'Perez ', 'hugothacker@hotmail.com', NULL, 'hugothacker@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('144', 'PRAXIS INGENIERIA S.R.L.', 'saulmanriquep@gmail.com', NULL, 'saulmanriquep@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('145', 'FH-BOLIVIA', 'plimachi@fh.org', NULL, 'plimachi@fh.org', NULL, NULL, NULL, NULL, NULL, '', '0'),
('146', 'Betzabe Choqueticlla', 'constbet@gmail.com', NULL, 'constbet@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('147', 'RICARDA TORRICO', 'caclarost@hotmail.com', NULL, 'caclarost@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('148', 'YUCRA', 'luly_ticona@hotmail.com', NULL, 'luly_ticona@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('149', 'COMPAIA DE PLASTICOS ART LTDA', 'degare_quita@hotmail.com', NULL, 'degare_quita@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('150', 'ATI S.R.L. ', 'amilcar.lanza.zeballos@gmail.c', NULL, 'amilcar.lanza.zeballos@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('151', 'Centellas Gonzales', 'sergiochoque77@gmail.com', NULL, 'sergiochoque77@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('152', 'Camacho', 'petvel.camacho@gmail.com', NULL, 'petvel.camacho@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('153', 'AVALOS', 'roy.arenas@hotmail.com', NULL, 'roy.arenas@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('154', 'JUAN CANAVIRI CH.', 'canaviri12@hotmail.com', NULL, 'canaviri12@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('155', 'Oscar Jimnez', 'ojimenezr@yahoo.com', NULL, 'ojimenezr@yahoo.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('156', 'Ruth Claros ', 'ruthclaros@gmail.com', NULL, 'ruthclaros@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('157', 'Mirtha Lopez', 'mels067@hotmail.com', NULL, 'mels067@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('158', 'MOCELET-BOL Ltda.', 'mocelet.bol@gmail.com', NULL, 'mocelet.bol@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('159', 'EMPRESA DE SERVICIOS CONTACTA ', 'bertha_ramirez_ortiz@hotmail.c', NULL, 'bertha_ramirez_ortiz@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('160', 'RAMIRO VIDOVIC', 'ramiro198906@hotmail.com', NULL, 'ramiro198906@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('161', ' Carlos Calla Carrasco', 'seacon.srl@hotmail.com', NULL, 'seacon.srl@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('162', 'ALTO LIMA  S.R.L.', 'konicocmc@hotmail.com', NULL, 'konicocmc@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('163', 'BRAEZ', 'lizjim411@gmail.com', NULL, 'lizjim411@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('164', 'SAUL RODRIGUEZ', 'rsaulv@gmail.com', NULL, 'rsaulv@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('165', 'Emerson Darwing Justiniano Hur', 'emersoned7@gmail.com', NULL, 'emersoned7@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('166', 'Jenny Chugar Aquino de Andrade', 'jenny.chugar@hotmail.com', NULL, 'jenny.chugar@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('167', 'Marcelo Fabian Parraga Balcaza', 'mp_151@hotmail.com', NULL, 'mp_151@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('168', 'Roger Avendao', 'liz_av.p@hotmail.com', NULL, 'liz_av.p@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('169', 'LITEC S.R.L.', 'gladys.chui@gmail.com', NULL, 'gladys.chui@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('170', 'TICONA', 'jcarlos293@hotmail.es', NULL, 'jcarlos293@hotmail.es', NULL, NULL, NULL, NULL, NULL, '', '0'),
('171', 'Juan Carlos Pallares Torres', 'kjuan5luc@hotmail.com', NULL, 'kjuan5luc@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('172', 'CONSULTORA ORGANIZACIONAL HOYO', 'gabriel@hm-consultores.com', NULL, 'gabriel@hm-consultores.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('173', 'Rosario Ines Aguilera Cruz', 'charito_aguilera@hotmail.com', NULL, 'charito_aguilera@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('174', 'TORO', 'alejandro5493t@gmail.com', NULL, 'alejandro5493t@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('175', 'Inversiones Veterinarias S.A.', 'lvasquez@invetsa.com', NULL, 'lvasquez@invetsa.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('176', 'PEARANDA', 'mpenaranda@natbiosrl.com', NULL, 'mpenaranda@natbiosrl.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('177', 'Alejandra Camargo', 'alejandra.camargo@xpartes.com.', NULL, 'alejandra.camargo@xpartes.com.bo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('178', 'Marcelo Machaca Cahuana', 'interlexcivile.mm@gmail.com', NULL, 'interlexcivile.mm@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('179', 'ANA VARGAS', 'jmvp0410@gmail.com', NULL, 'jmvp0410@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('180', 'SEMCA S.R.L.', 'ross_pool_14@hotmail.com', NULL, 'ross_pool_14@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('181', 'Elvio Montero', 'montero.elvio@saguapac.com.bo', NULL, 'montero.elvio@saguapac.com.bo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('182', 'QUOTEC S.R.L.', 'nevenka.monje@quotec-bolivia.n', NULL, 'nevenka.monje@quotec-bolivia.net', NULL, NULL, NULL, NULL, NULL, '', '0'),
('183', 'Luis Fernando Bejarano', 'luisfer_b2@hotmail.com', NULL, 'luisfer_b2@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('184', 'INGENIO SUCROALCOHOLERO AGUAI ', 'impuestos@aguai.com.bo', NULL, 'impuestos@aguai.com.bo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('185', 'Cristhian Claudio Rodriguez Mo', 'graciela@tecnopeso.com', NULL, 'graciela@tecnopeso.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('186', 'Marcos Lopez', 'lopezfloresmarcos@hotmail.com', NULL, 'lopezfloresmarcos@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('187', 'JOBAR FERNANDEZ', 'jobarf@hotmail.com', NULL, 'jobarf@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('188', 'MONICA NOGALES', 'monica_nogales@hotmail.com', NULL, 'monica_nogales@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('189', 'Rocio Rojas Clavijo', 'rocrojas1@hotmail.com', NULL, 'rocrojas1@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('190', 'EMPRESA PACHECO MONTAO DISTRI', 'm_arnez@hotmail.com', NULL, 'm_arnez@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('191', 'Jimena Mamani Luna', 'jimena.mluna.2492@gmail.com', NULL, 'jimena.mluna.2492@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('192', 'Antezana', 'aguirregirondaelizabeth@gmail.', NULL, 'aguirregirondaelizabeth@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('193', 'Martin Daza', 'Dazgar_jesem@hotmail.com', NULL, 'Dazgar_jesem@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('194', 'Ricardo Silvestre Arze Arze', 'fmaldonadorevollo@gmail.com', NULL, 'fmaldonadorevollo@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('195', 'MVO CONSTRUCCIONES &amp; SERVI', 'donaldvl@hotmail.com', NULL, 'donaldvl@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('196', 'Rolando Aguado', 'rolando.aguado@vidrierianoelia', NULL, 'rolando.aguado@vidrierianoelia.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('197', 'IRUPANA ANDEAN ORGANIC FOOD S.', 'mirthablanco123@hotmail.com', NULL, 'mirthablanco123@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('198', 'ERICK ESPINOZA', 'Lasolucion.gerencia@gmail.com', NULL, 'Lasolucion.gerencia@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('199', 'GRUPO REGIONAL S.R.L.', 'alvarobalderrama@gruporegional', NULL, 'alvarobalderrama@gruporegional.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('200', 'LIZETH ROSARIO FLORES VARGAS', 'Lizethfloresvargas@gmail.com', NULL, 'Lizethfloresvargas@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('201', 'Edner Revollo', 'willyve007@gmail.com', NULL, 'willyve007@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('202', 'NICOLAS RIC BIRABEN', 'julia_rojas_m@hotmail.com', NULL, 'julia_rojas_m@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('203', 'Nelly Maria Molina Medrano', 'nelimar440@gmail.com', NULL, 'nelimar440@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('204', 'Manuel Bonilla', 'contanapo@cotas.com.bo', NULL, 'contanapo@cotas.com.bo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('205', 'Laura', 'blaura@kpmg.com', NULL, 'blaura@kpmg.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('206', 'GOYITA S.R.L.', 'ermisrl02@gmail.com', NULL, 'ermisrl02@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('207', 'SUAREZ', 'pame_dua@hotmail.com', NULL, 'pame_dua@hotmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('208', 'Edgar Soria Veizaga ', 'edsoriaveizaga@gmail.com', NULL, 'edsoriaveizaga@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('209', 'MEGA MOLIBOL S.R.L.', 'samuel.sm690@gmail.com', NULL, 'samuel.sm690@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('210', 'DIANA MEJIA CLAROS', 'kmejia.claros@gmail.com', NULL, 'kmejia.claros@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('211', 'EMPRESA FERROVIARIA ANDINA S.A', 'hmaldonado@fca.com.bo', NULL, 'hmaldonado@fca.com.bo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('212', 'BERTOLETTI', 'ste.btti@gmail.com', NULL, 'ste.btti@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('213', 'LOPEZ', 'berthita7584@gmail.com', NULL, 'berthita7584@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('214', 'Najira Cotjiri Ramirez', 'paola.cotjiri.ramirez@gmail.co', NULL, 'paola.cotjiri.ramirez@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('215', 'Maria Elena Martinez Ramirez', 'elena.aplicar@gmail.com', NULL, 'elena.aplicar@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('216', 'HMS ASSURANCE GROUP S.R.L.', 'hmontano@hmsassurancegroup.com', NULL, 'hmontano@hmsassurancegroup.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('217', 'Gastn Ortega Aroni', 'gastytule.or.ar@gmail.com', NULL, 'gastytule.or.ar@gmail.com', NULL, NULL, NULL, NULL, NULL, '', '0'),
('218', 'COPERAGRO SRL', '210410020', NULL, '210410020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('219', 'Zilma Salcedo Eamara', '7593329017', NULL, '7593329017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('220', 'SONILUM S.R.L.', '173168027', NULL, '173168027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('221', 'LAGUNA', '6135036017', NULL, '6135036017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('222', 'INSTACOM S.R.L.', '171414023', NULL, '171414023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('223', 'DJV S.R.L. CONSTRUCCIONES', '226902024', NULL, '226902024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('224', 'DURAN', '2337013', NULL, '2337013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('225', 'Vladimir Coca Antezana', '3781773019', NULL, '3781773019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('226', 'Jimmy Martinez', '1368976', NULL, '1368976', NULL, NULL, NULL, NULL, NULL, '', '0'),
('227', 'COSSIO', '3890157', NULL, '3890157', NULL, NULL, NULL, NULL, NULL, '', '0'),
('228', 'LIZARAZU', '3347966019', NULL, '3347966019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('229', 'ROLAND BERTN', '4718976011', NULL, '4718976011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('230', 'JAVIER CHAMBI', '6007516', NULL, '6007516', NULL, NULL, NULL, NULL, NULL, '', '0'),
('231', 'ANURA S.R.L.', '342956024', NULL, '342956024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('232', 'Patzi', '7131239012', NULL, '7131239012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('233', 'SAAVEDRA', '4521731013', NULL, '4521731013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('234', 'TACUARANDI S.R.L.', '1011775023', NULL, '1011775023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('235', 'TRANS PLATINIUM S.R.L.', '281306023', NULL, '281306023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('236', 'Orellana', '956515019', NULL, '956515019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('237', 'METALES DEL ORIENTE S.R.L.', '142591020', NULL, '142591020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('238', 'CORMEI SUCURSAL BOLIVIA', '285520021', NULL, '285520021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('239', 'Vctor Len Espinoza', '5667226010', NULL, '5667226010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('240', 'PANAMERICAN SECURITIES S.A.', '1006783024', NULL, '1006783024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('241', 'MAIDANA', '4687321015', NULL, '4687321015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('242', 'ALFREDO QUISPE ROJAS', '2070515011', NULL, '2070515011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('243', 'Basatec Ltda.', '306418026', NULL, '306418026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('244', 'ADRIANA VILLARROEL', '5190005018', NULL, '5190005018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('245', 'GARCIA', '2760873', NULL, '2760873', NULL, NULL, NULL, NULL, NULL, '', '0'),
('246', 'Denisse Salvatierra', '6291519010', NULL, '6291519010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('247', 'Bustillos', '4478623012', NULL, '4478623012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('248', 'Gishay S.R.L.', '1001097022', NULL, '1001097022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('249', 'CECILIA ANGULO', '4773784018', NULL, '4773784018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('250', 'ERWIN BERNAL', '6786983', NULL, '6786983', NULL, NULL, NULL, NULL, NULL, '', '0'),
('251', 'Basilio Aguilar Rodrguez', '6210004', NULL, '6210004', NULL, NULL, NULL, NULL, NULL, '', '0'),
('252', 'Isabel Gallegos', '4337182014', NULL, '4337182014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('253', 'UVAIRENDA S.R.L.', '170160024', NULL, '170160024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('254', 'Litzi Martinez', '4500324', NULL, '4500324', NULL, NULL, NULL, NULL, NULL, '', '0'),
('255', 'Encinas', '3545691', NULL, '3545691', NULL, NULL, NULL, NULL, NULL, '', '0'),
('256', 'Vernica Marek', '11667611', NULL, '11667611', NULL, NULL, NULL, NULL, NULL, '', '0'),
('257', 'HUGO MARCIAL PORTILLO PAREDES', '3828604', NULL, '3828604', NULL, NULL, NULL, NULL, NULL, '', '0'),
('258', 'CRISTOBAL BENITO CHOQUE', '3787472', NULL, '3787472', NULL, NULL, NULL, NULL, NULL, '', '0'),
('259', 'Yanaina Gamez Ruiz', '3628763019', NULL, '3628763019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('260', 'Carlos Hugo Parada', '1583943', NULL, '1583943', NULL, NULL, NULL, NULL, NULL, '', '0'),
('261', 'Norma Llanque Huarachi', '5074779', NULL, '5074779', NULL, NULL, NULL, NULL, NULL, '', '0'),
('262', 'Pirai Ltda. Agencia Despachant', '1011813027', NULL, '1011813027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('263', 'RICHAR CUSSI TICONA', '4792827016', NULL, '4792827016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('264', 'Fabiola Andrea Gonzales Vera', '9665289012', NULL, '9665289012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('265', 'SIC-JAC S.R.L', '202136021', NULL, '202136021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('266', 'PRAXIS INGENIERIA S.R.L.', '303022023', NULL, '303022023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('267', 'Honorato Romero', '1042920', NULL, '1042920', NULL, NULL, NULL, NULL, NULL, '', '0'),
('268', 'Neidy Arteaga', '9809846', NULL, '9809846', NULL, NULL, NULL, NULL, NULL, '', '0'),
('269', 'MUTUAL AMBRA S.R.L.', '274230028', NULL, '274230028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('270', 'Maria Jeannett Galarza Daza', '2441681', NULL, '2441681', NULL, NULL, NULL, NULL, NULL, '', '0'),
('271', 'Miguel Angel Vilacahua', '8599142', NULL, '8599142', NULL, NULL, NULL, NULL, NULL, '', '0'),
('272', 'Daniel Bruno', '3923856', NULL, '3923856', NULL, NULL, NULL, NULL, NULL, '', '0'),
('273', 'Ramiro Aquino', '1989056012', NULL, '1989056012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('274', 'AGENCIAS GENERALES S.A.', '1023281020', NULL, '1023281020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('275', 'Mamani', '6895616', NULL, '6895616', NULL, NULL, NULL, NULL, NULL, '', '0'),
('276', 'ANTEZANA', '970257018', NULL, '970257018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('277', 'FARMEDICAL S.R.L.', '1001285025', NULL, '1001285025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('278', 'Procasa/Bolivia S.R.L.', '305830022', NULL, '305830022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('279', 'COOPERATIVA MADRE Y MAESTRA LT', '1011261026', NULL, '1011261026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('280', 'Quiroga', '3837352014', NULL, '3837352014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('281', 'WHILIAN PEARANDA', '5113361', NULL, '5113361', NULL, NULL, NULL, NULL, NULL, '', '0'),
('282', 'Paola Gutierrez Aguilar', '4372690012', NULL, '4372690012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('283', 'Alcibiades Ribera M.', '2830480011', NULL, '2830480011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('284', 'ELFEC S.A.', '1023213028', NULL, '1023213028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('285', 'Neme', '3534048', NULL, '3534048', NULL, NULL, NULL, NULL, NULL, '', '0'),
('286', 'CARFREDER S.R.L.', '321244024', NULL, '321244024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('287', 'Abruzzese', '3426603013', NULL, '3426603013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('288', 'LABORATORIOS MINERVA S.R.L.', '1006573022', NULL, '1006573022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('289', 'Josias Pedraza', '8193297', NULL, '8193297', NULL, NULL, NULL, NULL, NULL, '', '0'),
('290', 'Gilber Brito', '5355039012', NULL, '5355039012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('291', 'Eurofinsa S.A. Sucursal Bolivi', '280072023', NULL, '280072023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('292', 'SOINCO G.L.P.H. Ltda.', '1020573024', NULL, '1020573024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('293', 'INDEX S.R.L.', '262724027', NULL, '262724027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('294', 'CHRISTIAN BORIS COPA AQUINO', '6547224012', NULL, '6547224012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('295', 'Juan Jos Lpez Galindo', '3538701014', NULL, '3538701014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('296', 'CALERA ORIENTAL S.R.L.', '1025373023', NULL, '1025373023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('297', 'Sierra Trading Company S.R.L. ', '277848022', NULL, '277848022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('298', 'Gonzalo Favio Rojas Echazu', '3275079018', NULL, '3275079018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('299', 'Zarate', '4284949018', NULL, '4284949018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('300', 'Efrain Arauz', '5355147', NULL, '5355147', NULL, NULL, NULL, NULL, NULL, '', '0'),
('301', 'LILIANA ROMERO MELGAR', '6334267019', NULL, '6334267019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('302', 'Empresa Constructora Cochabamb', '1022017029', NULL, '1022017029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('303', 'INDUSTRIAS QUMICAS CIMBOL S.R', '1014651028', NULL, '1014651028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('304', 'International Fuel S.R.L.', '1020197021', NULL, '1020197021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('305', 'Torrico', '6425373', NULL, '6425373', NULL, NULL, NULL, NULL, NULL, '', '0'),
('306', 'Javier', '3841925', NULL, '3841925', NULL, NULL, NULL, NULL, NULL, '', '0'),
('307', 'Navarro', '1047973013', NULL, '1047973013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('308', 'Juan Pablo Chalco Canaviri', '5606692014', NULL, '5606692014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('309', 'Alarcon', '3456810019', NULL, '3456810019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('310', 'TITO', '4053867010', NULL, '4053867010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('311', 'Luizaga', '5194583013', NULL, '5194583013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('312', 'A.I.I S.R.L.- SUCURSAL BOLIVIA', '298068021', NULL, '298068021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('313', 'U.E. Comunidad Cristiana S.R.L', '207744022', NULL, '207744022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('314', 'SOALPRO S.R.L.', '1020409021', NULL, '1020409021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('315', 'GOMEZ', '2717789', NULL, '2717789', NULL, NULL, NULL, NULL, NULL, '', '0'),
('316', 'Quiroga', '836434', NULL, '836434', NULL, NULL, NULL, NULL, NULL, '', '0'),
('317', 'Cristina Paz', '5396131', NULL, '5396131', NULL, NULL, NULL, NULL, NULL, '', '0'),
('318', 'IVAN RUSSVEL ALCOCER RODRIGUEZ', '5281634018', NULL, '5281634018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('319', 'Marisabel Ruffy Toro Ruiloba', '3528568010', NULL, '3528568010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('320', 'Fernando Salinas', '4885266010', NULL, '4885266010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('321', 'Cabezas SRL Corredores y Aseso', '1006433029', NULL, '1006433029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('322', 'INVERSIONES INMOBILIARIAS INDA', '307626021', NULL, '307626021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('323', 'Shirley Cemo Vasquez', '7618987', NULL, '7618987', NULL, NULL, NULL, NULL, NULL, '', '0'),
('324', 'Rodrigo Querejazu', '3004884', NULL, '3004884', NULL, NULL, NULL, NULL, NULL, '', '0'),
('325', 'SAUL SANDRO RAMIREZ MAMANI', '5132916015', NULL, '5132916015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('326', 'Petrofil Ltda', '293468029', NULL, '293468029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('327', 'VARGAS', '344067', NULL, '344067', NULL, NULL, NULL, NULL, NULL, '', '0'),
('328', 'Guidelines Consultores Estrat', '334444028', NULL, '334444028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('329', 'Sanchez Victoria', '4950515010', NULL, '4950515010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('330', 'EMPRESA DE DESARROLLO INMOBILI', '280022021', NULL, '280022021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('331', 'Altamirano', '2462819018', NULL, '2462819018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('332', 'iBOLSA Sociedad de Titularizac', '285872022', NULL, '285872022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('333', 'QUISPE', '3551314', NULL, '3551314', NULL, NULL, NULL, NULL, NULL, '', '0'),
('334', 'AGENCIA DESPACHANTE DE ADUANA ', '126327023', NULL, '126327023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('335', 'Miguel Nava Carrasco', '4088552014', NULL, '4088552014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('336', 'Eduardo Becerra', '2623341012', NULL, '2623341012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('337', 'WILFREDO REMY COMBATA PACHECO', '6564677', NULL, '6564677', NULL, NULL, NULL, NULL, NULL, '', '0'),
('338', 'HEIDY pea', '6343806', NULL, '6343806', NULL, NULL, NULL, NULL, NULL, '', '0'),
('339', 'MORALES', '3071660011', NULL, '3071660011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('340', 'Patricia Romero Padilla', '5313881016', NULL, '5313881016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('341', 'Luis gustavo oliva padilla', '5404611011', NULL, '5404611011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('342', 'Edwin Chavez Montao', '5197416019', NULL, '5197416019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('343', 'Apaza', '9951560', NULL, '9951560', NULL, NULL, NULL, NULL, NULL, '', '0'),
('344', 'VIDAL', '4615057', NULL, '4615057', NULL, NULL, NULL, NULL, NULL, '', '0'),
('345', 'glenda soledad pearanda tirin', '10793297015', NULL, '10793297015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('346', 'Nancy', '3938283012', NULL, '3938283012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('347', '	MAYTA', '6949808', NULL, '6949808', NULL, NULL, NULL, NULL, NULL, '', '0'),
('348', 'ROCHA', '4538439', NULL, '4538439', NULL, NULL, NULL, NULL, NULL, '', '0'),
('349', 'CHINO', '9350370', NULL, '9350370', NULL, NULL, NULL, NULL, NULL, '', '0'),
('350', 'DATA SOURCE S.A', '160004026', NULL, '160004026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('351', 'waldir serrano', '1396534011', NULL, '1396534011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('352', 'roque lopez', '4248254011', NULL, '4248254011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('353', 'Santillan', '4408838', NULL, '4408838', NULL, NULL, NULL, NULL, NULL, '', '0'),
('354', 'Orlando Verduguez Trujillo', '6448088013', NULL, '6448088013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('355', 'javier lopez', '3204255', NULL, '3204255', NULL, NULL, NULL, NULL, NULL, '', '0'),
('356', 'Empresa Laguna Corazon S.A', '1013467022', NULL, '1013467022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('357', 'NATKAS SRL', '307996029', NULL, '307996029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('358', 'PAOLA ANDREA GAMBOA AZUGA', '7306597', NULL, '7306597', NULL, NULL, NULL, NULL, NULL, '', '0'),
('359', 'Ruth Claros', '827166', NULL, '827166', NULL, NULL, NULL, NULL, NULL, '', '0'),
('360', 'Marco Moscoso', '2394441018', NULL, '2394441018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('361', 'Claudia Chavez', '3882130', NULL, '3882130', NULL, NULL, NULL, NULL, NULL, '', '0'),
('362', 'elvis', '5227857', NULL, '5227857', NULL, NULL, NULL, NULL, NULL, '', '0'),
('363', 'Jenny Amelia Ledezma Inturias', '8197236017', NULL, '8197236017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('364', 'Chavarria', '3684083', NULL, '3684083', NULL, NULL, NULL, NULL, NULL, '', '0'),
('365', 'Juan Pablo Ariscain Bernini', '3489808', NULL, '3489808', NULL, NULL, NULL, NULL, NULL, '', '0'),
('366', 'ALEJANDRO OROSCO', '6545847017', NULL, '6545847017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('367', 'orlando ustarez lopez', '4734128012', NULL, '4734128012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('368', 'Corazon Diagnostic Center Srl', '183008023', NULL, '183008023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('369', 'Guillermo Sotomayor', '465761015', NULL, '465761015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('370', 'javier chambi', '6007516014', NULL, '6007516014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('371', 'FUNDACION COMPA', '140265029', NULL, '140265029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('372', 'RICARDO RIVERA', '2475079016', NULL, '2475079016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('373', 'ilse claudio', '3836969', NULL, '3836969', NULL, NULL, NULL, NULL, NULL, '', '0'),
('374', 'guevara y gumiel asociados srl', '293594020', NULL, '293594020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('375', 'Guillermo Fuentes', '2608575019', NULL, '2608575019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('376', 'LEON', '4832554010', NULL, '4832554010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('377', 'Nestor Lazcano Quentasi', '7747077013', NULL, '7747077013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('378', 'CRISPIN ALVARADO', '8362369018', NULL, '8362369018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('379', 'Luis German Quispe Hanco', '5794435018', NULL, '5794435018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('380', 'JORGE LUIS GOMEZ BARRIENTOS', '811951017', NULL, '811951017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('381', 'Mabel Adelaida Lastra Vargas', '5186352', NULL, '5186352', NULL, NULL, NULL, NULL, NULL, '', '0'),
('382', 'Caetano', '4869820', NULL, '4869820', NULL, NULL, NULL, NULL, NULL, '', '0'),
('383', 'Marcelo Cosio', '3937145', NULL, '3937145', NULL, NULL, NULL, NULL, NULL, '', '0'),
('384', 'CONTEC LTDA.', '1015463023', NULL, '1015463023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('385', 'RUTH MARINA RIVERO BARBOZA', '3901049', NULL, '3901049', NULL, NULL, NULL, NULL, NULL, '', '0'),
('386', 'Santiago Pacheco', '7664152', NULL, '7664152', NULL, NULL, NULL, NULL, NULL, '', '0'),
('387', 'Lorena Salas Castillo', '6244077010', NULL, '6244077010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('388', 'Mansilla &amp; Asociados SRL', '295526029', NULL, '295526029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('389', 'Servia', '369651010', NULL, '369651010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('390', 'Roxana Romero Escalante', '4127970', NULL, '4127970', NULL, NULL, NULL, NULL, NULL, '', '0'),
('391', 'Juan Florentino Martinez Galea', '7176851', NULL, '7176851', NULL, NULL, NULL, NULL, NULL, '', '0'),
('392', 'Lola Ortiz', '4196965', NULL, '4196965', NULL, NULL, NULL, NULL, NULL, '', '0'),
('393', 'Sonia Miranda', '3517795015', NULL, '3517795015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('394', 'MALDONADO', '2869699012', NULL, '2869699012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('395', 'CARRASCO', '2294215', NULL, '2294215', NULL, NULL, NULL, NULL, NULL, '', '0'),
('396', 'Centellas', '3481031010', NULL, '3481031010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('397', 'Maria Laura Villalobos Rivas', '1885794013', NULL, '1885794013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('398', 'MANUEL FIGUEROA', '1650768012', NULL, '1650768012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('399', 'RELET SRL', '185334023', NULL, '185334023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('400', 'SUNSET GROUP SRL', '312614025', NULL, '312614025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('401', 'Gerona Power S.R.L.', '191186025', NULL, '191186025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('402', 'JOSE LUIS MARQUEZ', '462305019', NULL, '462305019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('403', 'AUDITORES ASOCIADOS SOC. PROF.', '1005123023', NULL, '1005123023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('404', 'G.A.M. EL CARMEN RIVERO TORREZ', '126481022', NULL, '126481022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('405', 'Roly Gabriel Veizaga Herrera', '6261196019', NULL, '6261196019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('406', 'Guido Vallejos', '8008093', NULL, '8008093', NULL, NULL, NULL, NULL, NULL, '', '0'),
('407', 'TTIS LTDA', '180248023', NULL, '180248023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('408', 'Eduardo Senzano Quintela', '7856892012', NULL, '7856892012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('409', 'CMS SRL', '192026029', NULL, '192026029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('410', 'Jesus Justiniano Moreno', '3956353015', NULL, '3956353015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('411', 'Moreno ', '4893751012', NULL, '4893751012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('412', 'Tejada', '3376092010', NULL, '3376092010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('413', 'SUR ENERGY S.R.L.', '302770026', NULL, '302770026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('414', 'Celina Calcina Ali', '4013849016', NULL, '4013849016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('415', 'PABLO JIMENEZ SANTA CRUZ', '4571301019', NULL, '4571301019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('416', 'Mamani', '4912285010', NULL, '4912285010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('417', 'Gonzalo Cuellar', '3924498', NULL, '3924498', NULL, NULL, NULL, NULL, NULL, '', '0'),
('418', 'Saavedra', '3720217', NULL, '3720217', NULL, NULL, NULL, NULL, NULL, '', '0'),
('419', 'Daniela Torrez', '5353936', NULL, '5353936', NULL, NULL, NULL, NULL, NULL, '', '0'),
('420', 'MARIA PATZI', '452649011', NULL, '452649011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('421', 'Juan Carlos Alba Menacho', '3879651012', NULL, '3879651012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('422', 'Fernando Velarde', '7849704019', NULL, '7849704019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('423', 'HENRY LIENDO LOPEZ', '5241268018', NULL, '5241268018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('424', 'Garca', '4038940014', NULL, '4038940014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('425', 'CRUZTEL SRL', '1026419023', NULL, '1026419023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('426', 'SBO Ltda', '285494021', NULL, '285494021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('427', 'Hugo Orellana', '6337386', NULL, '6337386', NULL, NULL, NULL, NULL, NULL, '', '0'),
('428', 'CALVET', '3391207', NULL, '3391207', NULL, NULL, NULL, NULL, NULL, '', '0'),
('429', 'Hernan Mamani Porco', '7919856', NULL, '7919856', NULL, NULL, NULL, NULL, NULL, '', '0'),
('430', 'Bolog Logstics Group Srl', '321122024', NULL, '321122024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('431', 'Miguel Angel Cardenas Chura', '7024202', NULL, '7024202', NULL, NULL, NULL, NULL, NULL, '', '0'),
('432', 'Perez', '6103351017', NULL, '6103351017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('433', 'ANDRES RIVERO VALDES', '8931512', NULL, '8931512', NULL, NULL, NULL, NULL, NULL, '', '0'),
('434', 'Kevin Dagner Salazar', '7804484016', NULL, '7804484016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('435', 'Maria Coronel', '5799659016', NULL, '5799659016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('436', 'Quisbert', '3441590019', NULL, '3441590019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('437', 'Ortuo', '3433930015', NULL, '3433930015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('438', 'Aluizio Marcinichen Junior', '10138914', NULL, '10138914', NULL, NULL, NULL, NULL, NULL, '', '0'),
('439', 'Empresa Minera Rocamir SRL.', '296454029', NULL, '296454029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('440', 'CMI HOPE SA', '295592021', NULL, '295592021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('441', 'Karen Lucia Montao Paz', '6203970016', NULL, '6203970016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('442', 'Heidi Blanco', '5007127010', NULL, '5007127010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('443', 'Jose L. Blanco Guzman', '5047656012', NULL, '5047656012', NULL, NULL, NULL, NULL, NULL, '', '0');
INSERT INTO `0_crm_persons` VALUES
('444', 'Eduardo Vela', '3699978017', NULL, '3699978017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('445', 'ESPINOZA', '2320665014', NULL, '2320665014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('446', 'BRIAN HODIN ZEBALLOS', '8949520', NULL, '8949520', NULL, NULL, NULL, NULL, NULL, '', '0'),
('447', 'Olivia Paye', '4909294012', NULL, '4909294012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('448', 'Rodriguez', '2611923', NULL, '2611923', NULL, NULL, NULL, NULL, NULL, '', '0'),
('449', 'ROSMERY ROQUE RINALDO', '3516500011', NULL, '3516500011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('450', 'GILDA VALENCIA FLORES', '4895622', NULL, '4895622', NULL, NULL, NULL, NULL, NULL, '', '0'),
('451', 'Farih Andrade', '5351179', NULL, '5351179', NULL, NULL, NULL, NULL, NULL, '', '0'),
('452', 'Arias', '3520911', NULL, '3520911', NULL, NULL, NULL, NULL, NULL, '', '0'),
('453', 'Torres', '5647325018', NULL, '5647325018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('454', 'Ayllon', '4248021019', NULL, '4248021019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('455', 'Villegas', '8130252', NULL, '8130252', NULL, NULL, NULL, NULL, NULL, '', '0'),
('456', 'Maria Teresa Paz Zambrana', '1466593012', NULL, '1466593012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('457', 'RICHARD HURTADO VACA', '4570851', NULL, '4570851', NULL, NULL, NULL, NULL, NULL, '', '0'),
('458', 'Sinder Aguilar', '8179696', NULL, '8179696', NULL, NULL, NULL, NULL, NULL, '', '0'),
('459', 'GRISELDA MORENO', '5055903017', NULL, '5055903017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('460', 'Alejo', '6836234', NULL, '6836234', NULL, NULL, NULL, NULL, NULL, '', '0'),
('461', 'Carola Maldonado', '5251747014', NULL, '5251747014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('462', 'mendoza', '4367408', NULL, '4367408', NULL, NULL, NULL, NULL, NULL, '', '0'),
('463', 'Carlos Orozco', '2762148', NULL, '2762148', NULL, NULL, NULL, NULL, NULL, '', '0'),
('464', 'Beatriz Zuagua Mamani', '1878537', NULL, '1878537', NULL, NULL, NULL, NULL, NULL, '', '0'),
('465', 'Lakhiani', '193188021', NULL, '193188021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('466', 'Villanueva', '4525510', NULL, '4525510', NULL, NULL, NULL, NULL, NULL, '', '0'),
('467', 'GONZALO JORGE NOGUEDA', '8643616015', NULL, '8643616015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('468', 'Jos Mendez Jimenez', '4735627', NULL, '4735627', NULL, NULL, NULL, NULL, NULL, '', '0'),
('469', 'JEIDY MARIELA QUIROGA PANIAGUA', '4118801', NULL, '4118801', NULL, NULL, NULL, NULL, NULL, '', '0'),
('470', 'guarachi', '5908296', NULL, '5908296', NULL, NULL, NULL, NULL, NULL, '', '0'),
('471', 'COPY N&#039; CUT S.R.L', '309144024', NULL, '309144024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('472', 'altuzarra', '6096210013', NULL, '6096210013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('473', 'Deysi Llusco', '4311930013', NULL, '4311930013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('474', 'Bladimir Castro', '4444019019', NULL, '4444019019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('475', 'Arminda Lpez Loaiza', '6229003', NULL, '6229003', NULL, NULL, NULL, NULL, NULL, '', '0'),
('476', 'alvarez olivarez s.r.l.', '337064023', NULL, '337064023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('477', 'Coopertiva Iberocoop Ltda.', '157258028', NULL, '157258028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('478', 'NEMECIO ZEBALLOS CHOQUE', '3862216014', NULL, '3862216014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('479', 'Evert Arroyo Lpez', '7560699011', NULL, '7560699011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('480', 'Gorostiaga', '3405697015', NULL, '3405697015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('481', 'DANIEL MENDOZA VACA', '7821931', NULL, '7821931', NULL, NULL, NULL, NULL, NULL, '', '0'),
('482', 'ARNOLDO ANTELO MORALES', '1589222012', NULL, '1589222012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('483', 'Rosario Valencia', '3236906012', NULL, '3236906012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('484', 'Ana Mara Ribera Ribera', '3896030', NULL, '3896030', NULL, NULL, NULL, NULL, NULL, '', '0'),
('485', 'Limachi Cora Marlene Diva', '7007752014', NULL, '7007752014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('486', 'Condori', '5757629011', NULL, '5757629011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('487', 'Maria Eugenia Delgadillo Viver', '5356911015', NULL, '5356911015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('488', 'Castro', '4806465', NULL, '4806465', NULL, NULL, NULL, NULL, NULL, '', '0'),
('489', 'Empresa Agroseller S.R.L.', '285286027', NULL, '285286027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('490', 'EMPRESA MINERA CALATAYUD SRL', '194188028', NULL, '194188028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('491', 'Gigantografia Impresiona SRL', '344162025', NULL, '344162025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('492', 'Quintanilla', '3327090', NULL, '3327090', NULL, NULL, NULL, NULL, NULL, '', '0'),
('493', 'Luis Quispe', '3701514', NULL, '3701514', NULL, NULL, NULL, NULL, NULL, '', '0'),
('494', 'Nstor Martnez Vsquez', '1388049', NULL, '1388049', NULL, NULL, NULL, NULL, NULL, '', '0'),
('495', 'Jairo Willam Marca', '9604427013', NULL, '9604427013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('496', 'Vctor Hugo Meja', '2293874', NULL, '2293874', NULL, NULL, NULL, NULL, NULL, '', '0'),
('497', 'Gonzales', '3773373', NULL, '3773373', NULL, NULL, NULL, NULL, NULL, '', '0'),
('498', 'Carlos Vargas Moreno', '1991791012', NULL, '1991791012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('499', 'Campos', '5186490', NULL, '5186490', NULL, NULL, NULL, NULL, NULL, '', '0'),
('500', 'COMPANEX BOLIVIA SA.', '1020649021', NULL, '1020649021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('501', 'LILA DEL BARCO', '7115983014', NULL, '7115983014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('502', 'Mario Gonzalo Snchez Medina', '1052744017', NULL, '1052744017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('503', 'ernesto claros ovando', '3330160012', NULL, '3330160012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('504', 'JHON WILSON APAZA CHANA', '6006104015', NULL, '6006104015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('505', 'Bejarano', '2608189', NULL, '2608189', NULL, NULL, NULL, NULL, NULL, '', '0'),
('506', 'OGC S.R.L.', '212210025', NULL, '212210025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('507', 'Gonzales', '464232', NULL, '464232', NULL, NULL, NULL, NULL, NULL, '', '0'),
('508', 'Guzman', '202470028', NULL, '202470028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('509', 'Camacho', '5473062014', NULL, '5473062014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('510', 'Aguilar', '4049090016', NULL, '4049090016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('511', 'Gutierrez', '577388019', NULL, '577388019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('512', 'CASTILLO', '5151387017', NULL, '5151387017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('513', 'Claudia Irma Layme Vasquez', '5480149', NULL, '5480149', NULL, NULL, NULL, NULL, NULL, '', '0'),
('514', 'Soria', '4919734', NULL, '4919734', NULL, NULL, NULL, NULL, NULL, '', '0'),
('515', 'ARIEL ALFONSO LINARES VARGAS', '4783474014', NULL, '4783474014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('516', 'Nina', '4921020012', NULL, '4921020012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('517', 'Adalid Quispe', '6987174', NULL, '6987174', NULL, NULL, NULL, NULL, NULL, '', '0'),
('518', 'baldiviezo', '8417632019', NULL, '8417632019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('519', 'Rocha', '6500521019', NULL, '6500521019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('520', 'INCERCRUZ', '120875027', NULL, '120875027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('521', 'Tade S.R.L.', '240714024', NULL, '240714024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('522', 'Piedades Justiniano', '4663421', NULL, '4663421', NULL, NULL, NULL, NULL, NULL, '', '0'),
('523', 'MICHEL UCHANI SOLIZ', '6448815016', NULL, '6448815016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('524', 'Vidaurre', '6261326', NULL, '6261326', NULL, NULL, NULL, NULL, NULL, '', '0'),
('525', 'Luis quisbert', '8310635', NULL, '8310635', NULL, NULL, NULL, NULL, NULL, '', '0'),
('526', 'Global Insigth Software S.R.L.', '198534021', NULL, '198534021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('527', 'ROSSIO CESPEDES', '3899419', NULL, '3899419', NULL, NULL, NULL, NULL, NULL, '', '0'),
('528', 'Jacha Inti Industrial S.A', '155338026', NULL, '155338026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('529', 'Carmen Cinthia Ribera', '5348991019', NULL, '5348991019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('530', 'ARGANDOA', '3329263016', NULL, '3329263016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('531', 'CARLOS CALIXTO GUTIERREZ ALANO', '5114060010', NULL, '5114060010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('532', 'Delgadillo', '5200108', NULL, '5200108', NULL, NULL, NULL, NULL, NULL, '', '0'),
('533', 'Alejandro Ramos', '1925994011', NULL, '1925994011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('534', 'FARIAS', '3382622', NULL, '3382622', NULL, NULL, NULL, NULL, NULL, '', '0'),
('535', 'Perez', '4500039019', NULL, '4500039019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('536', 'Omar Rodriguez Vargas', '4528825', NULL, '4528825', NULL, NULL, NULL, NULL, NULL, '', '0'),
('537', 'Mirian Consuelo Talamas', '1578778011', NULL, '1578778011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('538', 'RUBEN DARIO BELLIDO ZELADA', '2300879', NULL, '2300879', NULL, NULL, NULL, NULL, NULL, '', '0'),
('539', 'VICTOR HUGO JIMENEZ', '3430846013', NULL, '3430846013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('540', 'AMADOR GALLARDO', '1975277', NULL, '1975277', NULL, NULL, NULL, NULL, NULL, '', '0'),
('541', 'Corina Rosario Echazu Arandia', '3930501', NULL, '3930501', NULL, NULL, NULL, NULL, NULL, '', '0'),
('542', 'Flores', '5748918018', NULL, '5748918018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('543', 'FLORES', '3380186', NULL, '3380186', NULL, NULL, NULL, NULL, NULL, '', '0'),
('544', 'Alex Medrano Sejas', '5229324010', NULL, '5229324010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('545', 'LA CASCADA S.A.', '1006909025', NULL, '1006909025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('546', 'MARCO AURELIO ANTELO RODRIGUEZ', '7723555011', NULL, '7723555011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('547', 'EMPRESA CONSTRUCTORA MILANO SR', '302288022', NULL, '302288022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('548', 'LOPEZ', '6438193', NULL, '6438193', NULL, NULL, NULL, NULL, NULL, '', '0'),
('549', 'MOAN S.R.L. 222432022', '222432022', NULL, '222432022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('550', 'machaca', '10065446013', NULL, '10065446013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('551', 'Zaida Garcia Loayza', '4125485', NULL, '4125485', NULL, NULL, NULL, NULL, NULL, '', '0'),
('552', 'Bernabe condori', '8786228', NULL, '8786228', NULL, NULL, NULL, NULL, NULL, '', '0'),
('553', 'sandra terceros', '3788611', NULL, '3788611', NULL, NULL, NULL, NULL, NULL, '', '0'),
('554', 'DORIS CAZON', '2327733', NULL, '2327733', NULL, NULL, NULL, NULL, NULL, '', '0'),
('555', 'SERGIO SILVA', '8422704013', NULL, '8422704013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('556', 'AF CONTROL SRL', '273124028', NULL, '273124028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('557', 'Marcelo Ibaez Salvatierra', '5619290017', NULL, '5619290017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('558', 'Reyes Ortiz', '6811842', NULL, '6811842', NULL, NULL, NULL, NULL, NULL, '', '0'),
('559', 'Celia Garcia Chileno', '6361872', NULL, '6361872', NULL, NULL, NULL, NULL, NULL, '', '0'),
('560', 'Mauricio Sossa Vasquez', '5600095', NULL, '5600095', NULL, NULL, NULL, NULL, NULL, '', '0'),
('561', 'CHOQUE', '5062084015', NULL, '5062084015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('562', 'Jose Richard Pedriel Vargas', '3898475019', NULL, '3898475019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('563', 'EDITORIAL LA PATRIA LTDA', '1010141024', NULL, '1010141024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('564', 'UTASAWA', '125095020', NULL, '125095020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('565', 'ROTERZU SRL', '273422020', NULL, '273422020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('566', 'Indago Consultora S.R.L', '331442025', NULL, '331442025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('567', 'Ceferina Garcia', '5828510013', NULL, '5828510013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('568', 'Callisaya', '6125155014', NULL, '6125155014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('569', 'RODRIGUEZ', '6735622', NULL, '6735622', NULL, NULL, NULL, NULL, NULL, '', '0'),
('570', 'Sudaval S.A', '1018629028', NULL, '1018629028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('571', 'Sarzuri', '7891380010', NULL, '7891380010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('572', 'Espinoza', '3437727019', NULL, '3437727019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('573', 'ARISPE', '3529451', NULL, '3529451', NULL, NULL, NULL, NULL, NULL, '', '0'),
('574', 'Maria Cristel Sanchez Veizaga', '6413155', NULL, '6413155', NULL, NULL, NULL, NULL, NULL, '', '0'),
('575', 'Jhossep Cristhian Choque Chamo', '7537542019', NULL, '7537542019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('576', 'Carlos Pea', '7164940013', NULL, '7164940013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('577', 'GNAC SRL', '305932026', NULL, '305932026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('578', 'MERY HUAYHUATI', '4457837', NULL, '4457837', NULL, NULL, NULL, NULL, NULL, '', '0'),
('579', 'MENDOZA', '3426647019', NULL, '3426647019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('580', 'David Limachi Coca', '6587474', NULL, '6587474', NULL, NULL, NULL, NULL, NULL, '', '0'),
('581', 'zeballos', '3407404', NULL, '3407404', NULL, NULL, NULL, NULL, NULL, '', '0'),
('582', 'IRMA LOPEZ MONTAO', '8053704', NULL, '8053704', NULL, NULL, NULL, NULL, NULL, '', '0'),
('583', 'Alcocer', '4407713', NULL, '4407713', NULL, NULL, NULL, NULL, NULL, '', '0'),
('584', 'LOZANO', '2458750015', NULL, '2458750015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('585', 'Julio Cesar Peralta', '7551862', NULL, '7551862', NULL, NULL, NULL, NULL, NULL, '', '0'),
('586', 'ERIKA MERCEDES BURGOS MEDINA', '4610692 SC.', NULL, '4610692 SC.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('587', 'CENTRO DE LA MUJER RENGEL S.R.', '199662028', NULL, '199662028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('588', 'NINA', '3418852019', NULL, '3418852019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('589', 'Adriana Villegas', '5774005', NULL, '5774005', NULL, NULL, NULL, NULL, NULL, '', '0'),
('590', 'AVE', '1022939025', NULL, '1022939025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('591', 'FERNANDEZ', '4055530014', NULL, '4055530014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('592', 'EMPETROL S.R.L', '218132024', NULL, '218132024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('593', 'ORLANDO TORRICO R.', '3733526019', NULL, '3733526019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('594', 'CARLOS MIRANDA', '4976275014', NULL, '4976275014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('595', 'Fundacin Helping Hands - La P', '289154022', NULL, '289154022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('596', 'FLORA BETTY QUISPE CONDOVERA', '6148382018', NULL, '6148382018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('597', 'Abigail Baltazar Guarachi', '8946450', NULL, '8946450', NULL, NULL, NULL, NULL, NULL, '', '0'),
('598', 'Teresa Reinalda Ontiveros Gall', '7133359', NULL, '7133359', NULL, NULL, NULL, NULL, NULL, '', '0'),
('599', 'JORGE EGUEZ', '2982312', NULL, '2982312', NULL, NULL, NULL, NULL, NULL, '', '0'),
('600', 'ROGELIA CHIPANA YAPUCHURA', '4979487', NULL, '4979487', NULL, NULL, NULL, NULL, NULL, '', '0'),
('601', 'raquel pocoata', '8348269016', NULL, '8348269016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('602', 'VALLEJOS', '8813566', NULL, '8813566', NULL, NULL, NULL, NULL, NULL, '', '0'),
('603', 'GALLER', '7034474', NULL, '7034474', NULL, NULL, NULL, NULL, NULL, '', '0'),
('604', '7034474', '5398077', NULL, '5398077', NULL, NULL, NULL, NULL, NULL, '', '0'),
('605', 'Epifanio Alanoca Chavez', '2280272011', NULL, '2280272011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('606', 'CHOQUE', '3071866', NULL, '3071866', NULL, NULL, NULL, NULL, NULL, '', '0'),
('607', 'AXONLINE LTDA', '169346024', NULL, '169346024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('608', 'Carlos Balderrama Orozco', '3999087013', NULL, '3999087013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('609', 'TRACKNET S.R.L.', '150520028', NULL, '150520028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('610', 'COANEG S.R.L.', '1022699026', NULL, '1022699026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('611', 'URIONA', '2719483011', NULL, '2719483011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('612', 'Diego Nemtala', '3752888013', NULL, '3752888013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('613', 'Hugo Ali', '6667645', NULL, '6667645', NULL, NULL, NULL, NULL, NULL, '', '0'),
('614', 'RUDY RODOLFO RUIZ SALVATIERRA', '6273607011', NULL, '6273607011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('615', 'Comercializadora Bodylogic de ', '260042020', NULL, '260042020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('616', 'ANGEL ROBLES', '3127170', NULL, '3127170', NULL, NULL, NULL, NULL, NULL, '', '0'),
('617', 'Gabriela Arvalo Angulo', '3393977010', NULL, '3393977010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('618', 'Franklin Nogales Peralta', '4662208010', NULL, '4662208010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('619', 'Marioly Suarez Vasquez', '5581143019', NULL, '5581143019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('620', 'Tania Rodriguez Condori', '5055511', NULL, '5055511', NULL, NULL, NULL, NULL, NULL, '', '0'),
('621', 'MARISELA AGUIRRE CALLEJAS', '7737035011', NULL, '7737035011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('622', 'RICARDO RODRIGUEZ', '4418565010', NULL, '4418565010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('623', 'Julio Caballero', '387720014', NULL, '387720014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('624', 'juana aguilar', '1051022', NULL, '1051022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('625', 'Hortencia Giovana Aramayo Carb', '5643323', NULL, '5643323', NULL, NULL, NULL, NULL, NULL, '', '0'),
('626', 'Javier Medrano', '3119972015', NULL, '3119972015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('627', 'YEVARA', '3352876', NULL, '3352876', NULL, NULL, NULL, NULL, NULL, '', '0'),
('628', 'Rivera', '2639388014', NULL, '2639388014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('629', 'YANINA', '6352587', NULL, '6352587', NULL, NULL, NULL, NULL, NULL, '', '0'),
('630', 'DOMINGO SANCHEZ EGUEZ', '3296545014', NULL, '3296545014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('631', 'Benavidez', '6477936010', NULL, '6477936010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('632', 'Ricardo Franco Ayllon Suyo', '7285045017', NULL, '7285045017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('633', 'Mariza Caba', '5070669016', NULL, '5070669016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('634', 'Sociedad Bblica Boliviana', '1023193021', NULL, '1023193021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('635', 'SILVIA EUGENIA LOPEZ VELASQUEZ', '8191473', NULL, '8191473', NULL, NULL, NULL, NULL, NULL, '', '0'),
('636', 'Gustavo Ruiz', '6828753015', NULL, '6828753015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('637', 'ZENTENO', '3992746019', NULL, '3992746019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('638', 'RIVERA', '3461029', NULL, '3461029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('639', 'villchez', '4777769011', NULL, '4777769011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('640', 'CENE S.A.', '195300020', NULL, '195300020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('641', 'Mamani', '5152371018', NULL, '5152371018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('642', 'Mariano Sosa', '3204615015', NULL, '3204615015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('643', 'Patty', '2600073', NULL, '2600073', NULL, NULL, NULL, NULL, NULL, '', '0'),
('644', 'PROYECTO BOL 101403 - PNUD', '99001', NULL, '99001', NULL, NULL, NULL, NULL, NULL, '', '0'),
('645', 'CAMACHO', '214077017', NULL, '214077017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('646', 'GRUPO APSIS S.R.L.', '343558021', NULL, '343558021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('647', 'Sergio Loma', '4305716', NULL, '4305716', NULL, NULL, NULL, NULL, NULL, '', '0'),
('648', 'Dario Calizaya', '1357679015', NULL, '1357679015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('649', 'Omar Porcel', '994816016', NULL, '994816016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('650', 'Roberto Romero', '8137176019', NULL, '8137176019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('651', 'Mery lilian ruiz cabrera', '7727860', NULL, '7727860', NULL, NULL, NULL, NULL, NULL, '', '0'),
('652', 'Jorge Diaz', '2976760', NULL, '2976760', NULL, NULL, NULL, NULL, NULL, '', '0'),
('653', 'Blanca Encinas', '3760950', NULL, '3760950', NULL, NULL, NULL, NULL, NULL, '', '0'),
('654', 'Marco Antonio Cordova', '3879487', NULL, '3879487', NULL, NULL, NULL, NULL, NULL, '', '0'),
('655', 'IDEAS INTELIGENTES SRL', '65852517', NULL, '65852517', NULL, NULL, NULL, NULL, NULL, '', '0'),
('656', 'JUAN DANIEL VIDAL CAZAS', '5471418018', NULL, '5471418018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('657', 'murillo', '4068098', NULL, '4068098', NULL, NULL, NULL, NULL, NULL, '', '0'),
('658', 'GRUPO ASEBEY SRL', '256962020', NULL, '256962020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('659', 'susy barca', '5798190', NULL, '5798190', NULL, NULL, NULL, NULL, NULL, '', '0'),
('660', 'Norah Terceros', '2929715012', NULL, '2929715012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('661', 'DMC S.A.', '1028679029', NULL, '1028679029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('662', 'LEDY TERESA PINTO ANDIA', '3962850012', NULL, '3962850012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('663', 'Raul Fernando Cardenas irahola', '5338104', NULL, '5338104', NULL, NULL, NULL, NULL, NULL, '', '0'),
('664', 'JUAN BAUTISTA LEON', '7166661', NULL, '7166661', NULL, NULL, NULL, NULL, NULL, '', '0'),
('665', 'METALCI S.A.', '135005024', NULL, '135005024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('666', 'BOHIVA ENGINEERING SRL', '141243022', NULL, '141243022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('667', 'CAMWAVE SRL', '174512021', NULL, '174512021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('668', 'Dennis Vicente Ayala Quispe', '6721762013', NULL, '6721762013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('669', 'Cinthia Bazoalto', '5233399010', NULL, '5233399010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('670', 'Jess Guzmn', '3731329', NULL, '3731329', NULL, NULL, NULL, NULL, NULL, '', '0'),
('671', 'Perez', '7081669', NULL, '7081669', NULL, NULL, NULL, NULL, NULL, '', '0'),
('672', 'Pirovano', '8793101', NULL, '8793101', NULL, NULL, NULL, NULL, NULL, '', '0'),
('673', 'Yumans Reguerin', '5345612', NULL, '5345612', NULL, NULL, NULL, NULL, NULL, '', '0'),
('674', 'ALCIDES BAQUEROS CUELLAR', '3041103018', NULL, '3041103018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('675', 'Alejandra Rivero', '4643626', NULL, '4643626', NULL, NULL, NULL, NULL, NULL, '', '0'),
('676', 'Vargas', '4425708013', NULL, '4425708013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('677', 'Claudia Mendoza', '7998144012', NULL, '7998144012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('678', 'Mamani', '8315948', NULL, '8315948', NULL, NULL, NULL, NULL, NULL, '', '0'),
('679', 'UNEC S.A.', '135891024', NULL, '135891024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('680', 'PLANETCONST SRL', '294918024', NULL, '294918024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('681', 'Marcelo Gedeon Mamani Corazon', '7022295013', NULL, '7022295013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('682', 'Pantoja', '4942387013', NULL, '4942387013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('683', 'plus agro s.r.l.', '1025207023', NULL, '1025207023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('684', 'POWERGEN SRL', '237606022', NULL, '237606022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('685', 'Montero', '5470260011', NULL, '5470260011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('686', 'Gabino Alex Challco', '9214309013', NULL, '9214309013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('687', 'ELIAS FUENTES CHAMBI', '3972578017', NULL, '3972578017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('688', 'Eiverth Castro Mamani', '3488582', NULL, '3488582', NULL, NULL, NULL, NULL, NULL, '', '0'),
('689', 'OCIS S.R.L.', '146066029', NULL, '146066029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('690', 'Barrero &amp; Asociados S.R.L', '313994021', NULL, '313994021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('691', 'Neiza Sandra Monasterios Torre', '3525649', NULL, '3525649', NULL, NULL, NULL, NULL, NULL, '', '0'),
('692', 'BOTELLO', '4774084017', NULL, '4774084017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('693', 'Zeballos', '7893752', NULL, '7893752', NULL, NULL, NULL, NULL, NULL, '', '0'),
('694', 'Henrry Feliciano Cayo Condori', '6637839', NULL, '6637839', NULL, NULL, NULL, NULL, NULL, '', '0'),
('695', 'INOLSA S.R.L.', '159896028', NULL, '159896028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('696', 'Lenny Olivera Flores', '3623173', NULL, '3623173', NULL, NULL, NULL, NULL, NULL, '', '0'),
('697', 'JULIO CESAR ANTELO ARIAS', '8157423', NULL, '8157423', NULL, NULL, NULL, NULL, NULL, '', '0'),
('698', 'HERLAND MARTIN MARAZA', '5331687018', NULL, '5331687018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('699', 'Vicky Coca', '3186357', NULL, '3186357', NULL, NULL, NULL, NULL, NULL, '', '0'),
('700', 'LegalPro Soc. Civ.', '149768022', NULL, '149768022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('701', 'Antonio Bastida Hormigo', '13511875', NULL, '13511875', NULL, NULL, NULL, NULL, NULL, '', '0'),
('702', 'TEC CENTER SRL', '251326028', NULL, '251326028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('703', 'Janeth Herbas Zurita', '4418256016', NULL, '4418256016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('704', 'Zeballos', '8841810', NULL, '8841810', NULL, NULL, NULL, NULL, NULL, '', '0'),
('705', 'Paredes', '2604395', NULL, '2604395', NULL, NULL, NULL, NULL, NULL, '', '0'),
('706', 'PK Bolivia S.R.L.', '256426028', NULL, '256426028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('707', 'MAXAM FANEXA SAM', '1023249027', NULL, '1023249027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('708', 'CMAIO SRL', '306830025', NULL, '306830025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('709', 'FERNANDEZ', '4841723', NULL, '4841723', NULL, NULL, NULL, NULL, NULL, '', '0'),
('710', 'BIOGENESIS BAGO BOLIVIA S.A.', '1014835023', NULL, '1014835023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('711', 'SANTOKH SRL', '283650021', NULL, '283650021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('712', 'Tellez', '2728892', NULL, '2728892', NULL, NULL, NULL, NULL, NULL, '', '0'),
('713', 'EMPRESA CONSTRUCTORA ROYAL S.R', '1023743025', NULL, '1023743025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('714', 'MENDEZ', '3746488013', NULL, '3746488013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('715', 'Sanchez', '2905110', NULL, '2905110', NULL, NULL, NULL, NULL, NULL, '', '0'),
('716', 'Fernandez', '6433658019', NULL, '6433658019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('717', 'Mitma Dafnee Chacon Rivera', '5425600', NULL, '5425600', NULL, NULL, NULL, NULL, NULL, '', '0'),
('718', 'Wolfi Enzo Velasco Medina', '3235441014', NULL, '3235441014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('719', 'MALDONADO', '3722349019', NULL, '3722349019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('720', 'Edgar Medina', '2732977', NULL, '2732977', NULL, NULL, NULL, NULL, NULL, '', '0'),
('721', 'Guzmn', '3491955', NULL, '3491955', NULL, NULL, NULL, NULL, NULL, '', '0'),
('722', 'Patricia Antelo Higazy', '2988130011', NULL, '2988130011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('723', 'Alan Diez', '8863998', NULL, '8863998', NULL, NULL, NULL, NULL, NULL, '', '0'),
('724', 'TORREZ Y HUANSBER ASOCIADOS SR', '178052022', NULL, '178052022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('725', 'Luis Fernando Ramirez Loaiza', '7831440', NULL, '7831440', NULL, NULL, NULL, NULL, NULL, '', '0'),
('726', 'GUTIERREZ', '3489792', NULL, '3489792', NULL, NULL, NULL, NULL, NULL, '', '0'),
('727', 'Elfia Rivero', '1736867014', NULL, '1736867014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('728', 'Alvaro Garron', '2628604', NULL, '2628604', NULL, NULL, NULL, NULL, NULL, '', '0'),
('729', 'Raul Carrillo', '5052451', NULL, '5052451', NULL, NULL, NULL, NULL, NULL, '', '0'),
('730', 'Baltazar', '6514218', NULL, '6514218', NULL, NULL, NULL, NULL, NULL, '', '0'),
('731', 'Cabrera, Cordova y Asociados L', '1017227024', NULL, '1017227024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('732', 'MEGA MOLIBOL S.R.L.', '297460021', NULL, '297460021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('733', 'OLIVARES', '4836936018', NULL, '4836936018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('734', 'EINAR RAMOS ALVAREZ', '4161617', NULL, '4161617', NULL, NULL, NULL, NULL, NULL, '', '0'),
('735', 'Fundacin Pro Mujer', '173342029', NULL, '173342029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('736', 'JAIME GUERRERO PAREDES', '3050120018', NULL, '3050120018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('737', 'Laury Cuellar', '7464299', NULL, '7464299', NULL, NULL, NULL, NULL, NULL, '', '0'),
('738', 'Elvy Paz Mendoza', '5389229', NULL, '5389229', NULL, NULL, NULL, NULL, NULL, '', '0'),
('739', 'DIEGO VILLARROEL', '3882007', NULL, '3882007', NULL, NULL, NULL, NULL, NULL, '', '0'),
('740', 'cimar acua', '5112391', NULL, '5112391', NULL, NULL, NULL, NULL, NULL, '', '0'),
('741', 'SERGIO SANDOVAL', '4118441013', NULL, '4118441013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('742', 'VILLAGOMEZ', '6872321018', NULL, '6872321018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('743', 'RUBEN DARIO QUINTEROS SOLARES', '7595968', NULL, '7595968', NULL, NULL, NULL, NULL, NULL, '', '0'),
('744', 'Jarly Betancourt Vallejos', '5780170015', NULL, '5780170015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('745', 'Yujra', '4905526014', NULL, '4905526014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('746', 'ojeda', '2714128', NULL, '2714128', NULL, NULL, NULL, NULL, NULL, '', '0'),
('747', 'trans 22 de septiembre', '6002815012', NULL, '6002815012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('748', 'ordoez', '6532190', NULL, '6532190', NULL, NULL, NULL, NULL, NULL, '', '0'),
('749', 'JOSE INTURIAS SANCHEZ', '2884387015', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('750', 'VALLEJOS', '6516780', NULL, '6516780', NULL, NULL, NULL, NULL, NULL, '', '0'),
('751', 'PALACIOS', '6422060019', NULL, '6422060019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('752', 'Vernica Soza', '1317736012', NULL, '1317736012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('753', 'Raices Import Export Ltda.', '1027943022', NULL, '1027943022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('754', 'KINESIS TECHNOLOGY S.R.L.', '298750026', NULL, '298750026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('755', 'Hector Lima Calapia', '7170073', NULL, '7170073', NULL, NULL, NULL, NULL, NULL, '', '0'),
('756', 'Arce', '4339706013', NULL, '4339706013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('757', 'EPSA PUERTO RICO', '125341021', NULL, '125341021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('758', 'NICOLAS VARGAS', '5111214011', NULL, '5111214011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('759', 'EMPRESA MINERA MONTE GRANDE S.', '310862029', NULL, '310862029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('760', 'Dionisio Copa', '1335325', NULL, '1335325', NULL, NULL, NULL, NULL, NULL, '', '0'),
('761', 'EMPRESA CONSTRUCTORA DEXIA SRL', '293662023', NULL, '293662023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('762', 'MARITIME SERVICES LINE BOLIVIA', '156684023', NULL, '156684023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('763', 'CORDOVA', '2355917', NULL, '2355917', NULL, NULL, NULL, NULL, NULL, '', '0'),
('764', 'LA GUITA S.R.L.', '136291021', NULL, '136291021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('765', 'Victor Hugo Condorcett', '1037135011', NULL, '1037135011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('766', 'Matilde Saavedra Isita', '7630603013', NULL, '7630603013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('767', 'APRAE-TOTORA', '175300029', NULL, '175300029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('768', 'GALGOSERV SRL.', '310812023', NULL, '310812023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('769', 'Pablo Ramirez', '4252748', NULL, '4252748', NULL, NULL, NULL, NULL, NULL, '', '0'),
('770', 'NEXUS TECHNOLOGY BOLIVIA SA', '1001805020', NULL, '1001805020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('771', 'Jose Noe Aguilera', '4661756', NULL, '4661756', NULL, NULL, NULL, NULL, NULL, '', '0'),
('772', 'Carlos Flores', '1808707010', NULL, '1808707010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('773', 'Henrique Harms', '6279912', NULL, '6279912', NULL, NULL, NULL, NULL, NULL, '', '0'),
('774', 'Maria Rene Pereira', '5899264010', NULL, '5899264010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('775', 'ALI', '6996060', NULL, '6996060', NULL, NULL, NULL, NULL, NULL, '', '0'),
('776', 'VALLE', '2629868014', NULL, '2629868014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('777', 'VARGAS', '988694010', NULL, '988694010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('778', 'Rocio Sandoval', '1936774', NULL, '1936774', NULL, NULL, NULL, NULL, NULL, '', '0'),
('779', 'luis aguilar', '5883645', NULL, '5883645', NULL, NULL, NULL, NULL, NULL, '', '0'),
('780', 'MANUEL SOSA CABRERA', '4921282', NULL, '4921282', NULL, NULL, NULL, NULL, NULL, '', '0'),
('781', 'FERRUFINO', '6084704', NULL, '6084704', NULL, NULL, NULL, NULL, NULL, '', '0'),
('782', 'carolina almanza lopez', '5416483015', NULL, '5416483015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('783', 'diego berazain', '5111098011', NULL, '5111098011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('784', 'David Arevalo', '815383', NULL, '815383', NULL, NULL, NULL, NULL, NULL, '', '0'),
('785', 'IBERICA SRL', '162040020', NULL, '162040020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('786', 'CENTRO CULTURAL ALEMAN', '1017049020', NULL, '1017049020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('787', 'Flores Pamela', '5159803013', NULL, '5159803013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('788', 'Libreria y Papeleria Olimpia S', '1020267022', NULL, '1020267022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('789', 'REYES', '5989229019', NULL, '5989229019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('790', 'DELONIX S.R.L.', '336288024', NULL, '336288024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('791', 'Henry Gallardo Ardaya', '3902650', NULL, '3902650', NULL, NULL, NULL, NULL, NULL, '', '0'),
('792', 'Ruth Peralta', '391971011', NULL, '391971011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('793', 'PLAZA LISSET', '5153674', NULL, '5153674', NULL, NULL, NULL, NULL, NULL, '', '0'),
('794', 'Jhonatan canedo', '8792457', NULL, '8792457', NULL, NULL, NULL, NULL, NULL, '', '0'),
('795', 'Chanel Vsquez Suarez', '5354435', NULL, '5354435', NULL, NULL, NULL, NULL, NULL, '', '0'),
('796', 'fernando valverde arana', '8932731010', NULL, '8932731010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('797', 'Rios', '4773696016', NULL, '4773696016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('798', 'SALAZAR', '3379319014', NULL, '3379319014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('799', 'NICOLAS', '6749886', NULL, '6749886', NULL, NULL, NULL, NULL, NULL, '', '0'),
('800', 'IPSOS APOYO OPINION Y MERCADO ', '1016423027', NULL, '1016423027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('801', 'SILVA', '3498962017', NULL, '3498962017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('802', 'Luis Daniel Mamani Zabala ', '6334514', NULL, '6334514', NULL, NULL, NULL, NULL, NULL, '', '0'),
('803', 'Sociedad Industrial Ceramica S', '1012223027', NULL, '1012223027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('804', 'publicidad e inmobiliaria Icbo', '320412028', NULL, '320412028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('805', 'CEFA  ASOCIADOS SRL', '1018227021', NULL, '1018227021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('806', 'Sergio Carreo', '6392606', NULL, '6392606', NULL, NULL, NULL, NULL, NULL, '', '0'),
('807', 'CONEXIONES ENTRE MUNDOS S.R.L.', '194648021', NULL, '194648021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('808', 'Gonzales', '6871855014', NULL, '6871855014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('809', 'Quispe', '2690548011', NULL, '2690548011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('810', 'TESSCO S.R.L.', '1021707029', NULL, '1021707029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('811', 'IVAN JAIME ALEJANDRO HUAQUISAC', '9184319', NULL, '9184319', NULL, NULL, NULL, NULL, NULL, '', '0'),
('812', 'Gladys Aguilar Villarroel', '9819062017', NULL, '9819062017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('813', 'felicidad viza alvarez', '4787194014', NULL, '4787194014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('814', 'WALTER ZUNIGA', '5857398', NULL, '5857398', NULL, NULL, NULL, NULL, NULL, '', '0'),
('815', 'Wilmer Chipana', '4892156019', NULL, '4892156019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('816', 'rodriguez', '4048202015', NULL, '4048202015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('817', 'Mamani', '6071945018', NULL, '6071945018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('818', 'Iveth Ortiz Serrudo', '7478610019', NULL, '7478610019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('819', 'vasquez', '4057454', NULL, '4057454', NULL, NULL, NULL, NULL, NULL, '', '0'),
('820', 'Cons-i', '3817450013', NULL, '3817450013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('821', 'Gomez', '4834705', NULL, '4834705', NULL, NULL, NULL, NULL, NULL, '', '0'),
('822', 'Maria Carolina Patino Porcel ', '5355108013', NULL, '5355108013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('823', 'Salomon rojas sanchez', '3581795017', NULL, '3581795017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('824', 'JAVIER QUINTANA', '4728092', NULL, '4728092', NULL, NULL, NULL, NULL, NULL, '', '0'),
('825', 'Villarroel', '2557467016', NULL, '2557467016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('826', 'Liz Castelln', '3602297', NULL, '3602297', NULL, NULL, NULL, NULL, NULL, '', '0'),
('827', 'LLanco', '4911746', NULL, '4911746', NULL, NULL, NULL, NULL, NULL, '', '0'),
('828', 'Lujan', '3448468', NULL, '3448468', NULL, NULL, NULL, NULL, NULL, '', '0'),
('829', 'Jose Maria Justiniano Rivero', '5893085', NULL, '5893085', NULL, NULL, NULL, NULL, NULL, '', '0'),
('830', 'Javier Pomacusi Ballesteros', '4092378013', NULL, '4092378013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('831', 'Maximo Baldiviezo C', '4737690', NULL, '4737690', NULL, NULL, NULL, NULL, NULL, '', '0'),
('832', 'GISBERT Y CIA. S.A.', '1007043027', NULL, '1007043027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('833', 'RENE FERNANDO CHAVEZ', '3562142016', NULL, '3562142016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('834', 'Miranda', '3159852010', NULL, '3159852010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('835', 'German Soliz ', '874255016', NULL, '874255016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('836', 'Eloy Ignacio Ramos Quispe', '3971163019', NULL, '3971163019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('837', 'Ramiro Juan Montecinos Viscarr', '3283657', NULL, '3283657', NULL, NULL, NULL, NULL, NULL, '', '0'),
('838', 'Leoncio Ruiz Figueroa', '2937532', NULL, '2937532', NULL, NULL, NULL, NULL, NULL, '', '0'),
('839', 'Ronald Aez Souza', '5590288019', NULL, '5590288019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('840', 'Brocha Gorda Srl', '292748026', NULL, '292748026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('841', 'Ximena Len', '4325531012', NULL, '4325531012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('842', 'MARCOS LOPEZ', '3770853019', NULL, '3770853019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('843', 'delgadiilo', '3382299017', NULL, '3382299017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('844', 'villegas', '3748847', NULL, '3748847', NULL, NULL, NULL, NULL, NULL, '', '0'),
('845', 'lilian choque', '4948162', NULL, '4948162', NULL, NULL, NULL, NULL, NULL, '', '0'),
('846', 'TABULARIS CONSULTORES SRL', '344198022', NULL, '344198022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('847', 'MEFP', '1001543025', NULL, '1001543025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('848', 'Jenny Chugar de Andrade', '3533898017', NULL, '3533898017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('849', 'PEREZ', '2051792016', NULL, '2051792016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('850', 'SAUL GUTIERREZ ZUAZO', '5097380', NULL, '5097380', NULL, NULL, NULL, NULL, NULL, '', '0'),
('851', 'H&amp;S AUDITORES Y CONSULTORE', '318824028', NULL, '318824028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('852', 'Patricia Elke Leon Vargas', '5721040011', NULL, '5721040011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('853', 'Curtiembres Arcuel Srl', '161062023', NULL, '161062023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('854', 'RODUGA INVERSIONES S.A.', '145186023', NULL, '145186023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('855', 'Enrique Luis Cruz V.', '3228505019', NULL, '3228505019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('856', 'Armando Honorio', '2623506', NULL, '2623506', NULL, NULL, NULL, NULL, NULL, '', '0'),
('857', 'DISTRIBUIDORA ANDESFILMS S.A.', '316490028', NULL, '316490028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('858', 'wilson Luna', '3320950010', NULL, '3320950010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('859', 'RVALER Y ASOCIADOS S.R.L.', '328828026', NULL, '328828026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('860', 'Rolando Iglesias', '1054466014', NULL, '1054466014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('861', 'KARLA LORENA MIRANDA ALCOBA', '10810983014', NULL, '10810983014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('862', 'CLAUDIA ROJAS ARANCIBIA', '5413232', NULL, '5413232', NULL, NULL, NULL, NULL, NULL, '', '0'),
('863', 'Cortez', '3421416019', NULL, '3421416019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('864', 'Pozo', '6114982012', NULL, '6114982012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('865', 'Servicios Generales Extra SRL', '298696025', NULL, '298696025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('866', 'Willma Limachi Ramos', '3719948018', NULL, '3719948018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('867', 'Cristian lima fermin', '8215559', NULL, '8215559', NULL, NULL, NULL, NULL, NULL, '', '0'),
('868', 'karen velasquez torrez', '8402190014', NULL, '8402190014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('869', 'SHOGUN S.R.L', '173664029', NULL, '173664029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('870', 'israel Jesus Fernandez Mercado', '6842910', NULL, '6842910', NULL, NULL, NULL, NULL, NULL, '', '0'),
('871', 'Maribel Perez Rivera', '9010872018', NULL, '9010872018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('872', 'EDUCAINNOVANDO CONSULTORES SRL', '281422023', NULL, '281422023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('873', 'Juan Carlos Claudio', '3883844', NULL, '3883844', NULL, NULL, NULL, NULL, NULL, '', '0'),
('874', 'fabian illanes ribera', '9717128', NULL, '9717128', NULL, NULL, NULL, NULL, NULL, '', '0'),
('875', 'Paola Rosales Montao', '6226075014', NULL, '6226075014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('876', 'Vanesa Apaza Guerra', '6245978', NULL, '6245978', NULL, NULL, NULL, NULL, NULL, '', '0'),
('877', 'David Durn', '7501736010', NULL, '7501736010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('878', 'Pacea Srl. Agencia Desp. de A', '1020511026', NULL, '1020511026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('879', 'SIMAPETROL S.R.L.', '162306028', NULL, '162306028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('880', 'Veronica Escalante', '7466561', NULL, '7466561', NULL, NULL, NULL, NULL, NULL, '', '0'),
('881', 'JVJVIRTUAL', '7745081012', NULL, '7745081012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('882', 'denard Mendez', '3886222', NULL, '3886222', NULL, NULL, NULL, NULL, NULL, '', '0'),
('883', 'Navarro', '4306899018', NULL, '4306899018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('884', 'Vela ', '4287590016', NULL, '4287590016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('885', 'Gustavo Davalos Coca', '3755792018', NULL, '3755792018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('886', 'Rodriguez', '4048600015', NULL, '4048600015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('887', 'S.E.C. S.R.L.', '1009477024', NULL, '1009477024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('888', 'MAMANI', '5181973', NULL, '5181973', NULL, NULL, NULL, NULL, NULL, '', '0'),
('889', 'Angela Lucia Galvez Perez', '7463048013', NULL, '7463048013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('890', 'Mamani', '6812832', NULL, '6812832', NULL, NULL, NULL, NULL, NULL, '', '0'),
('891', 'Maria Diaz', '7612602018', NULL, '7612602018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('892', 'Maria Luisa Arenas Medina', '1112631', NULL, '1112631', NULL, NULL, NULL, NULL, NULL, '', '0'),
('893', 'GANESHA LTDA', '175626029', NULL, '175626029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('894', 'Ortuo', '4870675', NULL, '4870675', NULL, NULL, NULL, NULL, NULL, '', '0'),
('895', 'Hooper', '5224517', NULL, '5224517', NULL, NULL, NULL, NULL, NULL, '', '0'),
('896', 'Silvia rodriguez', '4509656', NULL, '4509656', NULL, NULL, NULL, NULL, NULL, '', '0'),
('897', 'Ana Estfano Ramos Uceda', '6029584', NULL, '6029584', NULL, NULL, NULL, NULL, NULL, '', '0'),
('898', 'ROMAY', '4938123', NULL, '4938123', NULL, NULL, NULL, NULL, NULL, '', '0'),
('899', 'karina justiniano justiniano', '3931130019', NULL, '3931130019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('900', 'Juan Fernandez', '5756239', NULL, '5756239', NULL, NULL, NULL, NULL, NULL, '', '0'),
('901', 'julio cesar tasseo', '4590609012', NULL, '4590609012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('902', 'Eliot Rodriguez', '6383551', NULL, '6383551', NULL, NULL, NULL, NULL, NULL, '', '0'),
('903', 'CALLAU', '3871220012', NULL, '3871220012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('904', 'Rios', '3753827', NULL, '3753827', NULL, NULL, NULL, NULL, NULL, '', '0'),
('905', 'Lizarda justiniano abrego', '7661910015', NULL, '7661910015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('906', 'Pamela Espejo', '6198111012', NULL, '6198111012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('907', 'CINTHIA JIMENA ORTEGA MORALES', '7722214019', NULL, '7722214019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('908', 'La ciudad de los nios', '1008811029', NULL, '1008811029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('909', 'BOLIVIA AUDITORES B.A.', '120607022', NULL, '120607022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('910', 'MOVTERRA S.R.L.', '280288028', NULL, '280288028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('911', 'IVONNE PACO', '5657690', NULL, '5657690', NULL, NULL, NULL, NULL, NULL, '', '0'),
('912', 'OCHOA', '6191262013', NULL, '6191262013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('913', 'Gloria Romina Vila Fernandez', '8993905014', NULL, '8993905014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('914', 'Yuri Roman Crdenas', '3372670014', NULL, '3372670014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('915', 'Calatayud', '6047790', NULL, '6047790', NULL, NULL, NULL, NULL, NULL, '', '0'),
('916', 'Bernardo Antonio Veragua Salaz', '6357555017', NULL, '6357555017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('917', 'Luis Rodriguez', '6339019019', NULL, '6339019019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('918', 'SAUL PABLO BERNAL ALCOCER', '7807399', NULL, '7807399', NULL, NULL, NULL, NULL, NULL, '', '0'),
('919', 'Paul David Aruquipa Escobar', '3397307', NULL, '3397307', NULL, NULL, NULL, NULL, NULL, '', '0'),
('920', 'SHEIYLA MAES FARFAN', '3491706', NULL, '3491706', NULL, NULL, NULL, NULL, NULL, '', '0'),
('921', 'INSTITUTO FRANCO BOLIVIANOS', '1020543026', NULL, '1020543026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('922', 'Loredo', '5692292', NULL, '5692292', NULL, NULL, NULL, NULL, NULL, '', '0'),
('923', 'ZOILA ROJAS', '3924791', NULL, '3924791', NULL, NULL, NULL, NULL, NULL, '', '0'),
('924', 'Fernando choque llave', '6638857', NULL, '6638857', NULL, NULL, NULL, NULL, NULL, '', '0'),
('925', 'Bertha Apaza Vargas', '4932432', NULL, '4932432', NULL, NULL, NULL, NULL, NULL, '', '0'),
('926', 'Angela Machua Morales', '8966226', NULL, '8966226', NULL, NULL, NULL, NULL, NULL, '', '0'),
('927', 'Luis Fernando Escobar Tellez', '4479771', NULL, '4479771', NULL, NULL, NULL, NULL, NULL, '', '0'),
('928', 'Pabel Alex Villarroel Sandoval', '5642827012', NULL, '5642827012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('929', 'Bimar Chile Soto', '4020313', NULL, '4020313', NULL, NULL, NULL, NULL, NULL, '', '0'),
('930', 'Aeroprpov SRL', '212648025', NULL, '212648025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('931', 'Ruben Conde', '4900588011', NULL, '4900588011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('932', 'LOURDES MARCELA VELASCO', '3400892010', NULL, '3400892010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('933', 'AHEC SRL', '281048022', NULL, '281048022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('934', 'Jianfan Chen', '4933510011', NULL, '4933510011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('935', 'Enrique Mendieta', '5275672', NULL, '5275672', NULL, NULL, NULL, NULL, NULL, '', '0'),
('936', 'PHISIO BASIC SRL', '163626025', NULL, '163626025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('937', 'Joaquin Flores Coronado', '4087973016', NULL, '4087973016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('938', 'Gustavo Simon gonzales carriza', '4384377015', NULL, '4384377015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('939', 'FABOPAL S.A.', '1008255028', NULL, '1008255028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('940', 'Elvia Yssy Velasquez Villarroe', '7704434', NULL, '7704434', NULL, NULL, NULL, NULL, NULL, '', '0'),
('941', 'FICHTNER GmbH &amp; Co. KG', '125891026', NULL, '125891026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('942', 'Maria Eugenia Rocha Calvimonte', '1116319013', NULL, '1116319013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('943', 'Yenny Zenteno', '9591347018', NULL, '9591347018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('944', 'Graciela Len Angulo', '5341163', NULL, '5341163', NULL, NULL, NULL, NULL, NULL, '', '0'),
('945', 'Condori', '8344008', NULL, '8344008', NULL, NULL, NULL, NULL, NULL, '', '0'),
('946', 'Medicus Mundi', '1020015025', NULL, '1020015025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('947', 'Elias Peredo', '5414587019', NULL, '5414587019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('948', 'PASAPORTES VIAJES Y TURISMO S.', '1008367029', NULL, '1008367029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('949', 'ROMERO', '5228566017', NULL, '5228566017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('950', 'Aviles', '6733643', NULL, '6733643', NULL, NULL, NULL, NULL, NULL, '', '0'),
('951', 'MILTON RODRIGO CONTRERAS SARAV', '6236425011', NULL, '6236425011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('952', 'ROSA VILLARPANDO', '7479123', NULL, '7479123', NULL, NULL, NULL, NULL, NULL, '', '0'),
('953', 'Maria Isabel Copa Condori', '5720860', NULL, '5720860', NULL, NULL, NULL, NULL, NULL, '', '0'),
('954', 'Rodriguez', '3393572011', NULL, '3393572011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('955', 'EDUARDO SALAMANCA ANTEQUERA', '5520090016', NULL, '5520090016', NULL, NULL, NULL, NULL, NULL, '', '0');
INSERT INTO `0_crm_persons` VALUES
('956', 'SERIGRAFA GEELE S.R.L.', '1017033023', NULL, '1017033023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('957', 'Wilmar Stelzer Talavera', '7834145017', NULL, '7834145017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('958', 'Patricia Elke Leon Vargas', ' 5721040011', NULL, ' 5721040011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('959', '	IRMA FERNANDEZ IBARRA', '8524362', NULL, '8524362', NULL, NULL, NULL, NULL, NULL, '', '0'),
('960', 'GUEVARA', '6948000', NULL, '6948000', NULL, NULL, NULL, NULL, NULL, '', '0'),
('961', 'Javier Ach Colque', '4055873014', NULL, '4055873014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('962', 'Ballester', '5500491016', NULL, '5500491016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('963', 'ARIEL ROBLES VASQUEZ', '4573073', NULL, '4573073', NULL, NULL, NULL, NULL, NULL, '', '0'),
('964', 'Vanessa Balcera Cruz', '8890169019', NULL, '8890169019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('965', 'ARBOTT LTDA', '1004517027', NULL, '1004517027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('966', 'Mary Selva Jordan', '6361834016', NULL, '6361834016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('967', 'TELMA VELASQUEZ ORTUSTE', '5683243017', NULL, '5683243017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('968', 'SHARAD CHANDER DHINGRA', '317076027', NULL, '317076027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('969', 'Kenia Melgar Cespedes', '8130422', NULL, '8130422', NULL, NULL, NULL, NULL, NULL, '', '0'),
('970', 'Mauricio Barriga', '	 4662826016', NULL, '	\n4662826016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('971', 'CROWN LTDA', '1023113020', NULL, '1023113020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('972', 'claudia Yolanda Hurtado Grock', '3292355', NULL, '3292355', NULL, NULL, NULL, NULL, NULL, '', '0'),
('973', 'Ormachea', '4807267', NULL, '4807267', NULL, NULL, NULL, NULL, NULL, '', '0'),
('974', 'Cuevas', '3366979011', NULL, '3366979011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('975', 'MAEXPROBOL S.R.L.', '142749020', NULL, '142749020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('976', 'CARLA ANDREA ROMERO RODAS', '7135509', NULL, '7135509', NULL, NULL, NULL, NULL, NULL, '', '0'),
('977', 'Gina Ojeda Medina', '4701761', NULL, '4701761', NULL, NULL, NULL, NULL, NULL, '', '0'),
('978', 'ACERCATE S.R.L.', '219204026', NULL, '219204026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('979', 'VICARIATO APOSTOLICO DE PANDO', '125697029', NULL, '125697029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('980', 'Servicios Integrales Quality S', '279530026', NULL, '279530026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('981', 'Quisbert', '4951228', NULL, '4951228', NULL, NULL, NULL, NULL, NULL, '', '0'),
('982', 'A&amp;P INDUSTRIAL S.R.L', '342294027', NULL, '342294027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('983', 'WILIAM ROMARIO CONDORI HUANCA', '9978236014', NULL, '9978236014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('984', 'Tocokari', '6465113015', NULL, '6465113015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('985', 'Querubin Rivero Muyuro', '5600780011', NULL, '5600780011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('986', 'Eddy Torrico', '3359749', NULL, '3359749', NULL, NULL, NULL, NULL, NULL, '', '0'),
('987', 'AUDIWORK S.R.L.', '336030025', NULL, '336030025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('988', 'Edith lopez', '4046488', NULL, '4046488', NULL, NULL, NULL, NULL, NULL, '', '0'),
('989', 'Luis Felipe Alanes Cordova', '485414', NULL, '485414', NULL, NULL, NULL, NULL, NULL, '', '0'),
('990', 'calatayud', '8333813015', NULL, '8333813015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('991', 'Fernando Pozo Villarroel', '1739766014', NULL, '1739766014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('992', 'Ricarda Torrico Soliz', '811909012', NULL, '811909012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('993', 'JHOVANA CONDORI SARCO', '4253957019', NULL, '4253957019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('994', 'Abrahan Cruz Flores', '6273285', NULL, '6273285', NULL, NULL, NULL, NULL, NULL, '', '0'),
('995', 'Fernando Luis Choque Llave', '66388', NULL, '66388', NULL, NULL, NULL, NULL, NULL, '', '0'),
('996', 'carlos arteaga serna', '1682986019', NULL, '1682986019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('997', 'Luca Tonconi Mamani', '2344300', NULL, '2344300', NULL, NULL, NULL, NULL, NULL, '', '0'),
('998', 'SIEEM S.R.L.', '168512029', NULL, '168512029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('999', 'Pedro Alejandro Anachuri Aguil', '7204961', NULL, '7204961', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1000', 'AGENCIA DESPACHANTE DE ADUANA ', '135077028', NULL, '135077028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1001', 'Edson Yamil Abiles Llanos', '7168901', NULL, '7168901', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1002', 'DANITZA FANOLA CHUNGARA', '4094636014', NULL, '4094636014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1003', 'Romanet Melgar', '5862774', NULL, '5862774', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1004', 'RAZA FUERTE SRL', '287322029', NULL, '287322029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1005', '	 RAZA FUERTE SRL', '	 287322029', NULL, '	\n287322029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1006', 'rodrigo villarroel', '5642359013', NULL, '5642359013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1007', 'SURCO', '4330696 019', NULL, '4330696 019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1008', '	ORLANDO TORRICO R.', '	3733526019', NULL, '	3733526019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1009', 'Delia Estrada Barrientos', '5641887', NULL, '5641887', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1010', 'Jess Enrique Ortega Velasquez', '6278716', NULL, '6278716', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1011', 'Susana vedia villaba', '5381333', NULL, '5381333', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1012', 'Orlando Villca cayo', '4412637014', NULL, '4412637014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1013', 'Richardt Aguilar muoz', '7732569012', NULL, '7732569012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1014', 'salomon condori', '5273117011', NULL, '5273117011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1015', 'Patricia Flores', '206161', NULL, '206161', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1016', 'Mara Magdalena Gallardo Vaca', '7764769017', NULL, '7764769017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1017', 'Bolland y Ca. S.A.', '1028355021', NULL, '1028355021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1018', 'llanos_lucio@yahoo.es', '4943126', NULL, '4943126', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1019', 'Eusebio Lopez Martinez', '31191819010', NULL, '31191819010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1020', 'Josefa guerrero requelme', '6392474010', NULL, '6392474010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1021', 'DATANALISIS LTDA', '305794023', NULL, '305794023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1022', 'Valeria Alarcn Morales', '10388509', NULL, '10388509', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1023', 'Cristian Ramos Pinto', '10421510', NULL, '10421510', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1024', 'zabala', '4759969', NULL, '4759969', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1025', '	Llanos', '	4943126', NULL, '	4943126', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1026', 'TAHUAMANU SA', '1015923029', NULL, '1015923029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1027', 'GABY MARISOL RAMOS', '9211367', NULL, '9211367', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1028', 'Cooperativa de Ahorro y Credit', '1009557026', NULL, '1009557026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1029', 'INDUSTRIAS DE ACEITE S.A.', '1023233029', NULL, '1023233029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1030', 'LOURDES TICONA CORONEL', '5479645', NULL, '5479645', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1031', 'Mara Esther Deuer', '6100833012', NULL, '6100833012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1032', 'Yasuda', '3242468', NULL, '3242468', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1033', 'Luna', '6874519', NULL, '6874519', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1034', 'MORALES', '6899069', NULL, '6899069', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1035', 'Fabin Davis Zurita', '5806327', NULL, '5806327', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1036', 'IGNACIO BEJARANO CUELLAR', '1517452019', NULL, '1517452019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1037', 'Anghy Ericka Urquizu Mamani', '10401942', NULL, '10401942', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1038', 'Benedicto paredes leaos', '2845844019', NULL, '2845844019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1039', 'DAVILA', '4465499014', NULL, '4465499014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1040', 'KAMER RODRIGUEZ VACA', '4190948016', NULL, '4190948016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1041', 'NUTRIMED-Nutricin y Medicina', '3197822016', NULL, '3197822016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1042', 'vista urbana srl', '199288024', NULL, '199288024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1043', 'SIDECON S.R.L.', '1011611027', NULL, '1011611027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1044', 'Maria nela campos vaca', '4192286', NULL, '4192286', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1045', 'CARMEN ROSA GUTIERREZ MILLARES', '9899982', NULL, '9899982', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1046', 'Chorolque', '1327934', NULL, '1327934', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1047', 'alaiza', '6828146', NULL, '6828146', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1048', 'Empresa Industrial Eucaliptus ', '296810026', NULL, '296810026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1049', 'TERMESA S.R.L.', '299894024', NULL, '299894024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1050', 'JOSUE ACERO HUANCA', '4821941015', NULL, '4821941015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1051', 'Renny Pozo', '3710334016', NULL, '3710334016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1052', 'yovana paco', '10854658', NULL, '10854658', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1053', 'limberg saavedra ribera', '3868343', NULL, '3868343', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1054', 'Ximena Dorado Durn', '7754650', NULL, '7754650', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1055', 'Rafael Torrez', '3362407', NULL, '3362407', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1056', 'EMPSAAT', '1023807025', NULL, '1023807025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1057', 'mario villa', '1115243018', NULL, '1115243018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1058', 'Ramrez', '8328227', NULL, '8328227', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1059', 'HUAGO VENANCIO APAZA', '4989482015', NULL, '4989482015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1060', 'leandro', '7032289015', NULL, '7032289015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1061', 'DAVID ARCE', '6055403018', NULL, '6055403018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1062', 'Heddy Claudia Montero Duran', '4669071012', NULL, '4669071012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1063', 'Cooperativa Aguarague Ltda.', '1011655022', NULL, '1011655022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1064', 'CASITA MIA SRL', '321056026', NULL, '321056026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1065', 'Jaime elias saba salomon', '280620028', NULL, '280620028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1066', 'napoleon calcina mendoza', '3823446015', NULL, '3823446015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1067', 'Velez', '4843535018', NULL, '4843535018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1068', 'Bolivia Delgado Zrate', '6700477', NULL, '6700477', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1069', 'FERNANDEZ', '225900022', NULL, '225900022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1070', 'Alianza Seguros S.A.', '1020351029', NULL, '1020351029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1071', 'Asociacion La Fortuna', '5861311', NULL, '5861311', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1072', 'MULTICENTER S.A.', '184288023', NULL, '184288023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1073', 'TRONIK SRL', '283274028', NULL, '283274028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1074', 'Beatriz Gutierrez', '1881184', NULL, '1881184', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1075', 'Vargas', '3769839012', NULL, '3769839012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1076', 'Pascual Jimenez', '681169', NULL, '681169', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1077', 'Flores', '3365402017', NULL, '3365402017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1078', 'Molina', '2446929016', NULL, '2446929016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1079', 'Marcelo Camacho', '6241374010', NULL, '6241374010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1080', 'willams Balderrama O.', '2840275019', NULL, '2840275019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1081', 'Chuyma', '4889973', NULL, '4889973', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1082', 'Weminson Ferreira Rodriguez', '420507018', NULL, '420507018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1083', 'Quisbert', '4455586', NULL, '4455586', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1084', 'PAOLA MONJES', '4411086010', NULL, '4411086010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1085', 'juan flores', '1321857018', NULL, '1321857018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1086', 'VEGAL FARMACEUTICA S.L. SUCURS', '352294020', NULL, '352294020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1087', 'Gutierrez', '61539085', NULL, '61539085', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1088', 'TIERRA', '1001027026', NULL, '1001027026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1089', 'Anibal Alberto Saavedra Revoll', '4583022017', NULL, '4583022017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1090', 'GLORIA BURGOA MENCIAS', '5349688011', NULL, '5349688011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1091', 'Siles', '2865853', NULL, '2865853', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1092', 'agrocentral ltda', '1029047026', NULL, '1029047026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1093', 'Alvaro Santi', '4536980', NULL, '4536980', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1094', 'Flores', '6505446', NULL, '6505446', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1095', 'ELIZABETH RODRIGUEZ', '6557166010', NULL, '6557166010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1096', 'Richard Zonneveld', '3029900', NULL, '3029900', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1097', 'PHI TERRA S.R.L.', '275130026', NULL, '275130026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1098', 'TATIANA FERRUFINO', '11345203', NULL, '11345203', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1099', 'CRAFT SRL', '148718022', NULL, '148718022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1100', 'Emilio Ricaldes Merida', '5288329', NULL, '5288329', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1101', 'Empresa constructora y consult', '1011043026', NULL, '1011043026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1102', 'Comit de Damas Paceas', '1001657023', NULL, '1001657023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1103', 'Petri von landwust srl', '139321027', NULL, '139321027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1104', 'PEREZ', '3472411013', NULL, '3472411013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1105', 'FRIGOR SA', '1028739027', NULL, '1028739027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1106', 'Vito Dorado Sevilla', '2962242014', NULL, '2962242014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1107', 'blanca cordova', '2384100019', NULL, '2384100019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1108', 'felix calle', '4917773', NULL, '4917773', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1109', 'Embriovid S.R.L.', '142469027', NULL, '142469027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1110', 'CONSTRUCTORA &amp; CONSULTORA ', '242406024', NULL, '242406024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1111', 'Centro de Distribucin y Comer', '351918027', NULL, '351918027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1112', 'RANULFO LEAOS', '3922560013', NULL, '3922560013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1113', 'Juvenal Serrano', '1883329012', NULL, '1883329012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1114', 'DICSA BOLIVIA SA.', '1004679025', NULL, '1004679025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1115', 'Jorge Arias Morales', '5240736019', NULL, '5240736019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1116', 'ALEX VACA', '7783548', NULL, '7783548', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1117', 'INGEBOL SRL', '301160021', NULL, '301160021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1118', 'EMPRESA DE SERVICIOS CONTACTA ', '311346022', NULL, '311346022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1119', 'Imathia Construccin SL sucurs', '308216023', NULL, '308216023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1120', 'COMPAIA DE PLASTICOS ART LTDA', '1028453026', NULL, '1028453026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1121', 'FERMINA CORDOVA', '8614011010', NULL, '8614011010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1122', 'NEXUS COMUNICACION TOTAL S.A.', '1007015020', NULL, '1007015020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1123', 'THAMEZ', '7958297018', NULL, '7958297018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1124', 'Yhovana Poma Paredes', '6143596', NULL, '6143596', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1125', 'Aragn Servicios Integrales', '1026809023', NULL, '1026809023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1126', 'Gregorio Veliz Ramirez', '2181759016', NULL, '2181759016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1127', 'Perez', '3435288', NULL, '3435288', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1128', 'Verastegui', '4791335011', NULL, '4791335011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1129', 'fernando lopez zenteno', '3628447011', NULL, '3628447011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1130', 'TEG S.R.L.', '1024305022', NULL, '1024305022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1131', 'LABORATORIO DR ZUNA SRL', '1012497024', NULL, '1012497024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1132', 'herrera ', '4849538', NULL, '4849538', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1133', 'JUDITH BARRETA VARGAS', '4571222010', NULL, '4571222010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1134', 'ROSIO IGNACIO HIDALGO', '3512921015', NULL, '3512921015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1135', 'COMINESA', '1006239027', NULL, '1006239027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1136', 'BELFORD VARGAS RUTZ', '3820705013', NULL, '3820705013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1137', 'AGUIRRE', '2634800', NULL, '2634800', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1138', 'Aranibar', '3377686013', NULL, '3377686013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1139', 'Cuba', '2710785011', NULL, '2710785011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1140', 'ROSA NELLY VILLARROEL', '5867142014', NULL, '5867142014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1141', 'Soluciones y Controles S.R.L.', '128505021', NULL, '128505021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1142', 'FRITZ RONCALES', '3866246', NULL, '3866246', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1143', 'Jutta Weber', '206756025', NULL, '206756025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1144', 'MAIDANA', '468732015', NULL, '468732015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1145', 'veronica valle', '4587303', NULL, '4587303', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1146', 'SAMEQ SRL', '121715023', NULL, '121715023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1147', 'CIRO VIDAURRE VARGAS', '5154179', NULL, '5154179', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1148', 'CONTRATAS IGLESIAS S.A.', '305122023', NULL, '305122023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1149', 'Maldonado', '3394240018', NULL, '3394240018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1150', 'ZULMA COPPA', '4143516', NULL, '4143516', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1151', 'aldana', '2722184', NULL, '2722184', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1152', 'A.P.L', '1021905026', NULL, '1021905026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1153', 'Alvarez', '2310142016', NULL, '2310142016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1154', 'TOPO - REQV S.R.L.', '292584020', NULL, '292584020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1155', 'AGXPLORE INTERNACIONAL S.R.L.', '130893024', NULL, '130893024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1156', 'HOMEX', '4313365013', NULL, '4313365013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1157', 'Vera', '4377392016', NULL, '4377392016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1158', 'Fbrica de Chocolates y Dulces', '1005185029', NULL, '1005185029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1159', 'E&amp;E S.R.L.', '120781026', NULL, '120781026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1160', 'Econstruvsur Srl', '239910029', NULL, '239910029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1161', 'QUEBRACHO SERV. DE PROTECCION ', '1012577027', NULL, '1012577027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1162', 'IBES SRL', '317120021', NULL, '317120021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1163', 'COOPERATIVA DE AHORRO Y CREDIT', '1028775025', NULL, '1028775025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1164', 'INPATGROUP C&amp;V S.R.L', '189348025', NULL, '189348025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1165', 'Cano', '6813931', NULL, '6813931', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1166', 'Jorge Zubieta Aguila', '4400911014', NULL, '4400911014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1167', 'Octavio Elvis Uribe Anibarro', '4087198', NULL, '4087198', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1168', 'TIENDA AMIGA ER S.A', '176592023', NULL, '176592023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1169', 'FUNDACION INSTITUCION EDUCATIV', '122519027', NULL, '122519027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1170', 'ICAT ELECTROGAS S.R.L.', '297788027', NULL, '297788027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1171', 'Hotel Cortez Ltda.', '1015201020', NULL, '1015201020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1172', 'INTERNACIONAL TARIJA SRL', '142109022', NULL, '142109022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1173', 'Fundacin Nuevo Norte', '139193026', NULL, '139193026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1174', 'FREDDY GUTIERREZ MERCADO', '1598326', NULL, '1598326', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1175', 'SOLIZ', '6464831012', NULL, '6464831012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1176', 'CHICKENS KINGDOM S.R.L.', '1009311029', NULL, '1009311029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1177', 'VOLCAN S.A.', '1020467020', NULL, '1020467020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1178', 'SOLIZ', '5970445', NULL, '5970445', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1179', 'henry perales cortez', '2994127011', NULL, '2994127011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1180', 'CBM S.R.L.', '1001811023', NULL, '1001811023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1181', 'HAZEL', '4323106018', NULL, '4323106018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1182', 'INSACRUZ LTDA.', '1028265029', NULL, '1028265029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1183', 'Eliana Mara Candia', '4041734', NULL, '4041734', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1184', 'HELADERIA GRACIA S.R.L.', '152838029', NULL, '152838029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1185', 'Metalrgica R.V.L.', '773153010', NULL, '773153010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1186', 'SyL Ingenieros Ltda.', '1015473020', NULL, '1015473020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1187', 'maria del carmen masanes', '3902935012', NULL, '3902935012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1188', 'INGEDAV S.R.L.', '351753025', NULL, '351753025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1189', 'Constructora malaga hnos sa su', '315798025', NULL, '315798025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1190', 'Juan ivan mamani tapia', '1025281022', NULL, '1025281022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1191', 'ARPEC S.R.L.', '282626026', NULL, '282626026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1192', 'Colegio Medico de Santa Cruz', '122347029', NULL, '122347029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1193', 'PRIME CINEMAS GAMES &amp; REST', '316898027', NULL, '316898027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1194', 'Seta consultores S. R. L.', '1022071023', NULL, '1022071023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1195', 'BYG E GYB CONSULTORES S.R.L.', '232524020', NULL, '232524020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1196', 'walter Montenegro', '5402054', NULL, '5402054', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1197', 'SEFO-SAM', '1009407020', NULL, '1009407020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1198', 'Patricia Aviles', '7141070012', NULL, '7141070012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1199', 'IRRIGACION SCBOL LTDA', '145806024', NULL, '145806024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1200', 'ZEBALLOS', '4836592', NULL, '4836592', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1201', 'Julia Montejo Neira', '4197065013', NULL, '4197065013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1202', 'Leddy Arza ', '7615197', NULL, '7615197', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1203', 'Paulina Chacon Ticona', '3322939017', NULL, '3322939017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1204', 'Maribel Gisbert', '4922125019', NULL, '4922125019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1205', 'DANIEL SCHLUSSELBERG', '3657144012', NULL, '3657144012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1206', 'HERCILIA CORDOVA SILVA', '666789017', NULL, '666789017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1207', 'Daynor Esteban Tancara Martine', '3314711', NULL, '3314711', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1208', 'Carlos Javier Oros Gonzales', '2455521011', NULL, '2455521011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1209', 'jose luis molina selaya', '4035567', NULL, '4035567', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1210', 'Cimar Rodriguez Armella', '4123514', NULL, '4123514', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1211', 'Alejandra Bascope Salvatierra', '5421089010', NULL, '5421089010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1212', 'LUCIO VILLCA CONDORI', '3566235014', NULL, '3566235014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1213', 'aguilar', '2458656', NULL, '2458656', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1214', 'PAULINA SAIGUA ROJAS', '3206786018', NULL, '3206786018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1215', 'Ruddy Quintanilla Flores', '5683578', NULL, '5683578', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1216', 'INDUSTRIAS VENADO S.A.', '1020539025', NULL, '1020539025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1217', 'RAMIRO RINALDO', '2689261', NULL, '2689261', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1218', 'VERONICA SUXO QUENTA', '4947864015', NULL, '4947864015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1219', 'ALVARO GUTIERREZ ZARATE', '6947922', NULL, '6947922', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1220', 'Vicente Vargas Flored', '4096931015', NULL, '4096931015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1221', 'Limberg Sandoval Salvatierra', '3837663016', NULL, '3837663016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1222', 'JUAN CARLOS SALAZAR', '5827448015', NULL, '5827448015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1223', 'Ancieta', '9412877', NULL, '9412877', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1224', 'ALVARO NUEZ SRL', '222166024', NULL, '222166024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1225', 'CRC SA.', '300762026', NULL, '300762026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1226', 'Alvaro Arandia', '3655387018', NULL, '3655387018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1227', 'Hoteleria y Turismo Eubea S.R.', '204332029', NULL, '204332029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1228', 'Montecristo Bolivia S.R.L.', '153566021', NULL, '153566021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1229', 'Boris escalante', '3089404', NULL, '3089404', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1230', 'Total Radio Systems Ltda. Boli', '120601023', NULL, '120601023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1231', 'jhenny lizeth ortiz canaviri', '9235615016', NULL, '9235615016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1232', 'PRIMSA SRL', '142863022', NULL, '142863022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1233', 'EMPRESA CONSTRUCTORA CRT LTDA', '267036024', NULL, '267036024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1234', 'CENDA', '1009341027', NULL, '1009341027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1235', 'LatigidConst S.R.L.', '193734021', NULL, '193734021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1236', 'Alejandra Claure', '7282684018', NULL, '7282684018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1237', 'lienara Ribera', '3901629', NULL, '3901629', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1238', 'Lidercont S.R.L.', '258722022', NULL, '258722022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1239', 'Espinoza', '5851301010', NULL, '5851301010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1240', 'Monica Castillo', '3797822', NULL, '3797822', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1241', 'shai gonzalo lugo rodriguez', '8624371010', NULL, '8624371010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1242', 'EDGAR FLORES ALANES', '3517056013', NULL, '3517056013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1243', 'Abel Garcia Blanco', '3069594016', NULL, '3069594016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1244', 'Spiecapag S.A. Sucursal Bolivi', '241626027', NULL, '241626027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1245', 'ASERRADERO OQUIRIQUIA SRL', '1031031022', NULL, '1031031022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1246', 'TERRAZAS', '3801733014', NULL, '3801733014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1247', 'Inversiones Rokys Bolivia SRL', '1025631024', NULL, '1025631024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1248', 'AGRARIO S.R.L', '328084027', NULL, '328084027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1249', 'JUAN CARLOS TICONA', '5481285017', NULL, '5481285017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1250', 'Espada', '2756748', NULL, '2756748', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1251', 'AQUATEC S.R.L.', '137971028', NULL, '137971028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1252', 'GEA SRL', '299876029', NULL, '299876029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1253', 'SOHER S.R.L.', '192908025', NULL, '192908025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1254', 'Quispia', '3028228015', NULL, '3028228015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1255', 'Remy Orgaz', '961344017', NULL, '961344017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1256', 'NIELZEN SUAREZ', '6021000', NULL, '6021000', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1257', 'EON CONSULTORA INTERDISCIPLINA', '6877613012', NULL, '6877613012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1258', 'OPRO SRL', '198940020', NULL, '198940020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1259', 'REYES', '4270203017', NULL, '4270203017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1260', 'ROBERT WILY MAMANI VASQUEZ', '4940919018', NULL, '4940919018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1261', 'La cuisine de los chef s.r.l.', '187236022', NULL, '187236022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1262', 'Ericka Pardo Molina', '1908221012', NULL, '1908221012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1263', 'U.Coop. de Educacin Juan Pabl', '1000119029', NULL, '1000119029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1264', 'Nemtala', '3839368', NULL, '3839368', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1265', 'Edgar Noe Vasquez Gutierrez', '8219307', NULL, '8219307', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1266', 'GALVAN Y ASOCIADOS S.R.L.', '153250020', NULL, '153250020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1267', 'GRUPO REGIONAL S.R.L.', '159488029', NULL, '159488029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1268', 'Montao', '6410825015', NULL, '6410825015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1269', 'Ligni Soria Nakashima', '1768795', NULL, '1768795', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1270', 'Iber Carballo Moreira', '3948654017', NULL, '3948654017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1271', 'Martnez', '1057707', NULL, '1057707', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1272', 'Ricardo Flores Mendoza', '7259203', NULL, '7259203', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1273', 'ALDO BARRERA', '4019712014', NULL, '4019712014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1274', 'Hugo Maija Chapi', '4172983019', NULL, '4172983019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1275', 'DUARTE Y PEA AUDITORES ASOCIA', '1001045026', NULL, '1001045026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1276', 'ORTIZ', '1725989013', NULL, '1725989013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1277', 'AUDISEM SRL', '1006101028', NULL, '1006101028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1278', 'FERRETERIA SANGUEZA S.R.L.', '294540021', NULL, '294540021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1279', 'Caleb Mogro Maldonado', '4805589', NULL, '4805589', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1280', 'Herman Martinez Solar', '2991283016', NULL, '2991283016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1281', 'JASON ESTEVES', '5681823014', NULL, '5681823014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1282', 'Hassenteufel', '1025438014', NULL, '1025438014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1283', 'Fanny Arredondo', '2836436015', NULL, '2836436015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1284', 'ODALY NOE TAMACOINA', '5387391014', NULL, '5387391014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1285', 'Mer Telecom Bolivia Srl.', '171352023', NULL, '171352023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1286', 'Emili Lily Rivera Villarroel', '6222153013', NULL, '6222153013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1287', 'DISTRIBUIDORA ANDESFILMS S.A.', '316490028', NULL, '316490028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1288', 'Diaz', '8002492', NULL, '8002492', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1289', 'SEMCA S.R.L.', '178782020', NULL, '178782020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1290', 'AGRICOLA GANADERA BJ RANCH S.A', '1027315022', NULL, '1027315022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1291', 'SEAC', '832407010', NULL, '832407010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1292', 'KPLIAN LTDA', '196560027', NULL, '196560027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1293', 'ICEL', '1029995022', NULL, '1029995022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1294', 'gastn eduardo medrano lpez', '1733269013', NULL, '1733269013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1295', 'Hugo Aramayo Vidal', '1101340017', NULL, '1101340017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1296', 'CAROLA MORALES AUZA', '3568892011', NULL, '3568892011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1297', 'COOP. DE A.Y C. JERUSALEN LTDA', '132533023', NULL, '132533023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1298', 'Mario Barriga Garnica', '3645574', NULL, '3645574', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1299', 'ISAIAS CRUZ', '8833248', NULL, '8833248', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1300', 'Domingo Freddy Eguez Alvarez', '1523674018', NULL, '1523674018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1301', 'Aldo Montero', '4687096', NULL, '4687096', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1302', 'kanchay', '1022637026', NULL, '1022637026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1303', 'Roy Antonio Sejas Melendez', '5592295019', NULL, '5592295019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1304', 'UNIDAD EDUCATIVA REFORMADO CRI', '292548029', NULL, '292548029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1305', 'LOURDES LEONOR MANCILLA VIDAL', '921169013', NULL, '921169013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1306', 'SIFA ASOCIADOS SRL', '171886022', NULL, '171886022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1307', 'SOS BOLIVIA', '1020347026', NULL, '1020347026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1308', 'Hector Evia Meave', '2680707013', NULL, '2680707013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1309', 'TORREZ', '4849098018', NULL, '4849098018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1310', 'GUALBERTO QUINTANILLA', '2926976010', NULL, '2926976010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1311', 'Marcelo Onishi', '4181297013', NULL, '4181297013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1312', 'SAUL GALARZA', '701423011', NULL, '701423011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1313', 'JHALEA SRL', '120727029', NULL, '120727029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1314', 'GLORIA DANIELA MEDINA JIMENEZ', '8090906015', NULL, '8090906015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1315', 'Jenny Paz Zelada', '1549236018', NULL, '1549236018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1316', 'COTAS RL', '1028367023', NULL, '1028367023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1317', 'vallejos', '7883286013', NULL, '7883286013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1318', 'CONSULTORA CONTABLE DE Y J S.R', '328486020', NULL, '328486020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1319', 'HENRY VARGAS', '2390703013', NULL, '2390703013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1320', 'MAMANI', '6989116', NULL, '6989116', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1321', 'VILLARREAL', '923256013', NULL, '923256013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1322', 'RONALD MANRIQUE', '8398794', NULL, '8398794', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1323', 'ASOCIACION COLECTIVO REBELDIA', '1014545026', NULL, '1014545026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1324', 'NICANDRO LLAVE VALERIANO', '3719702015', NULL, '3719702015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1325', 'Magaly Martha Aguilar de Sando', '2625682017', NULL, '2625682017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1326', 'EMPRESA DE ALIMENTOS HAMACAS L', '187466029', NULL, '187466029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1327', 'ARIEL FRANKLIN FLORES LAZCANO', '5487037016', NULL, '5487037016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1328', 'SILVANA RIVERA SOTO', '4428324010', NULL, '4428324010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1329', 'nely arancibia victoria', '6537002018', NULL, '6537002018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1330', 'ORLANDO LOZA CAREAGA', '3782459010', NULL, '3782459010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1331', 'FUNDACION FAUTAPO', '1024503027', NULL, '1024503027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1332', 'Amparo Garcia Rodriguez', '1090330', NULL, '1090330', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1333', 'RITA LOPEZ', '3563355', NULL, '3563355', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1334', 'Industrias Metal ever Srl', '272522026', NULL, '272522026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1335', 'Revollo', '4410329015', NULL, '4410329015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1336', 'Juan alberto fernandez', '54167617', NULL, '54167617', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1337', 'victor meliton choquehuanca yu', '2608124', NULL, '2608124', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1338', 'padilla', '466488', NULL, '466488', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1339', 'ENDE CORANI S.A.', '1009393025', NULL, '1009393025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1340', 'Candelaria Tours', '1020818017', NULL, '1020818017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1341', 'SISCOTEC SRL', '1027397029', NULL, '1027397029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1342', 'Wilson Balanza', '1069340', NULL, '1069340', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1343', 'EMPRESA CONSTRUCTORA VECONSER ', '1010773023', NULL, '1010773023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1344', 'Reynaldo Espinoza', '2984675019', NULL, '2984675019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1345', 'ROGER TORRICO', '3783194019', NULL, '3783194019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1346', 'Roxana J. Maita Guzmn', '1884197017', NULL, '1884197017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1347', 'ROMERO', '3474039', NULL, '3474039', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1348', 'ivan pea', '4770102', NULL, '4770102', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1349', 'fundacruz', '1028631020', NULL, '1028631020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1350', 'YVON DORIA MEDINA TERRAZAS', '8926105011', NULL, '8926105011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1351', 'Patricia Lipa Calisaya', '3132359', NULL, '3132359', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1352', 'RUTY BEATRIS VACA JUSTINIANO', '2953524011', NULL, '2953524011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1353', 'Rafael Albis', '5631672', NULL, '5631672', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1354', 'krieger SRL', '281806025', NULL, '281806025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1355', 'Mauricio Martin Llanos Coriang', '7174827', NULL, '7174827', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1356', 'PLASTIFORTE SRL', '1009109025', NULL, '1009109025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1357', 'ECOR LTDA. CANAL 9 TELEORIENTE', '1028449028', NULL, '1028449028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1358', 'U.P.B.', '1023063028', NULL, '1023063028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1359', 'HINOJOSA', '4503823012', NULL, '4503823012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1360', 'JULIO RUBEN VALDIVIA ZAMBRANA', '970631010', NULL, '970631010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1361', 'C.R.&amp; F. ROJAS ABOGADOS SR', '212314020', NULL, '212314020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1362', 'Rene Saavedra Ribera', '463432019', NULL, '463432019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1363', 'Escalera', '5206374', NULL, '5206374', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1364', 'FELIX MARCA MAMANI', '5189899012', NULL, '5189899012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1365', 'Paulina Vargas Rojas', '2839581', NULL, '2839581', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1366', 'salud y nutricion s.r.l.', '307538024', NULL, '307538024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1367', 'Perez', '4760681', NULL, '4760681', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1368', 'Olmos', '3227492', NULL, '3227492', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1369', 'RAMIRO JIMENEZ SANDOVAL', '5231474019', NULL, '5231474019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1370', 'Caxco S.R.L.', '306746028', NULL, '306746028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1371', 'Consultora Audicab SRL', '291050028', NULL, '291050028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1372', 'Ronald Mamani Mamani', '6072636', NULL, '6072636', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1373', 'Industrias Matriz Ibaez IMIBA', '313482024', NULL, '313482024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1374', 'Xeanury S.R.L', '261130022', NULL, '261130022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1375', 'LOPEZ', '3756978', NULL, '3756978', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1376', 'Jenny Gonzales', '6435879018', NULL, '6435879018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1377', 'Lorgio Boris Cabrera Delgado', '4018834014', NULL, '4018834014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1378', 'Cet-Beni', '3337951015', NULL, '3337951015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1379', 'JOSUE OCTAVIO COLQUE RODRIGUEZ', '6623111', NULL, '6623111', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1380', 'PURE BOLIVIA S.R.L.', '230532023', NULL, '230532023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1381', 'EDITORA  CANELAS DEL SUR SRL', '1000817029', NULL, '1000817029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1382', 'TEKHNE S.R.L.', '143515024', NULL, '143515024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1383', 'MOYA', '9199647019', NULL, '9199647019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1384', 'MARCOS MANFRED BELLER MONTERO', '1022519022', NULL, '1022519022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1385', 'Claudia Sanchez', '5979063016', NULL, '5979063016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1386', 'Empresa Mienra Sinchi Metals C', '189722020', NULL, '189722020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1387', 'Luis Suarez', '1919381', NULL, '1919381', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1388', 'ALCOBA ANTONIO', '2693902013', NULL, '2693902013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1389', 'REDAL DE FREDDY ACEBY', '3675743012', NULL, '3675743012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1390', 'maria ynes leaos', '4586513019', NULL, '4586513019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1391', 'Carlos Eduardo Paz Saucedo', '1593144019', NULL, '1593144019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1392', 'Shirley Romay Flores', '3674407', NULL, '3674407', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1393', 'Sandra Nava', '3875688', NULL, '3875688', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1394', 'CICA AUDITORES ASOCIADOS', '1013103029', NULL, '1013103029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1395', 'Mario O bando Carbajal', '954894012', NULL, '954894012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1396', 'CONSTRUCTORA LA ARBOLEDA S.R.L', '248820028', NULL, '248820028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1397', 'Universidad Nacional del Orien', '1014971023', NULL, '1014971023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1398', 'SERPETCOP S.R.L', '286388022', NULL, '286388022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1399', 'Juan Carlos Carreo Mercado', '3212612', NULL, '3212612', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1400', 'ASERVICT S.R.L.', '352774026', NULL, '352774026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1401', '. Felicidad Anagua Quispe', '5733501013', NULL, '5733501013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1402', 'Vela Garcia Enzo Alfredo', '3366399010', NULL, '3366399010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1403', 'Alberto Mercado Machuca', '5938294', NULL, '5938294', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1404', 'Fundacion Energetica Boliviana', '1007061020', NULL, '1007061020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1405', 'GABY TABORGA TABORGA', '4722401015', NULL, '4722401015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1406', 'Colegio del Sagrado Corazn', '121165022', NULL, '121165022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1407', 'consultans services financial ', '310190028', NULL, '310190028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1408', 'tacuri', '5570270', NULL, '5570270', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1409', 'Corporacion de Aquino Bolivia ', '1020367024', NULL, '1020367024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1410', 'CARMEN TINCUTA VALENCIA', '4266890011', NULL, '4266890011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1411', 'Victor Gutierrez E.', '4033965013', NULL, '4033965013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1412', 'GRISEL ALEJANDRA SANTA CRUZ AL', '3482554010', NULL, '3482554010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1413', 'ELIAS SAMUEL FLORES', '4521631018', NULL, '4521631018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1414', 'Mirtha Lopez Soruco', '1837618016', NULL, '1837618016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1415', 'HOSPITAL SAN JUAN DE DIOS', '1030795027', NULL, '1030795027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1416', 'Enrique Ortuo', '5113095', NULL, '5113095', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1417', 'Perez Montao', '802405018', NULL, '802405018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1418', 'Ral Molina', '2717774012', NULL, '2717774012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1419', 'Erwin Galarza Velasco', '6350898', NULL, '6350898', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1420', 'Evelin Flores Blanco', '6277042', NULL, '6277042', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1421', 'Rosario Alczar', '1521525015', NULL, '1521525015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1422', 'HMS ASSURANCE GROUP S.R.L', '160896024', NULL, '160896024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1423', 'GENEX SA', '1028345022', NULL, '1028345022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1424', 'RAMIREZ', '4243376', NULL, '4243376', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1425', 'Raquel Yovana Tapia Espinoza', '8155815019', NULL, '8155815019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1426', 'VIVIAN RIBERA MENACHO', '5820171011', NULL, '5820171011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1427', 'Silvia Wilde', '2836893015', NULL, '2836893015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1428', 'miruca61@hotmail.com', '3505106013', NULL, '3505106013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1429', 'Sergio Farfan', '2712751017', NULL, '2712751017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1430', 'NANCY VILLCA', '3689094011', NULL, '3689094011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1431', 'Finadec Consultores SRL.', '1001017021', NULL, '1001017021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1432', 'Alhena Sujeit Salinas', '9268651', NULL, '9268651', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1433', 'NATALIA DE RADA', '3428013', NULL, '3428013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1434', 'SANDY', '2476813', NULL, '2476813', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1435', 'Universidad Catlica Boliviana', '1020141023', NULL, '1020141023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1436', 'Jorge Hidalgo', '2692132', NULL, '2692132', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1437', 'CONSULTORA COFABOL SRL', '140475029', NULL, '140475029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1438', 'MAGDA SUSANA MADARIAGA LORA', '1821358', NULL, '1821358', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1439', 'Claudia Veliz Perez', '4053598018', NULL, '4053598018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1440', 'Milton Bravo', '5424493012', NULL, '5424493012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1441', 'Orlando Roque', '4274170', NULL, '4274170', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1442', 'Maribel Ychazo Rojas', '3911998017', NULL, '3911998017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1443', 'FELIX CRUZ CUENTAS', '4947344016', NULL, '4947344016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1444', 'Daysi Avendao Reynaga', '5682143', NULL, '5682143', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1445', 'Lizett Bernal', '6556046014', NULL, '6556046014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1446', 'Iver Nina Bueno', '3973150016', NULL, '3973150016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1447', 'ABEL QUIROZ', '3472365', NULL, '3472365', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1448', 'Consultora Multidisciplinaria ', '132901023', NULL, '132901023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1449', 'SERMUR SRL.', '122181025', NULL, '122181025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1450', 'Crespo y Landivar Ltda.', '169044028', NULL, '169044028', NULL, NULL, NULL, NULL, NULL, '', '0');
INSERT INTO `0_crm_persons` VALUES
('1451', 'WENDES SERVICIOS INTEGRALES', '1704569015', NULL, '1704569015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1452', 'Ticona', '4865665', NULL, '4865665', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1453', 'VICTOR CAMACHO VIDAL', '3778789015', NULL, '3778789015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1454', 'Jorge Flor', '5653307015', NULL, '5653307015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1455', 'Berrios', '1236708019', NULL, '1236708019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1456', 'MARCELO EFRAIN HEREDIA CAVERO', '1061552016', NULL, '1061552016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1457', 'Salvador Carballo', '6547755019', NULL, '6547755019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1458', 'Omar Fernando Roman Fernandez', '5969574017', NULL, '5969574017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1459', 'Jhonny Alanes', '5542419010', NULL, '5542419010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1460', 'ELSA QUIROGA VEIZAGA', '6496469016', NULL, '6496469016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1461', 'EDGAR PLAZA AGRADA', '2771773', NULL, '2771773', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1462', 'OSCAR ESPEJO ALCON', '2459684016', NULL, '2459684016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1463', 'Jhonny W. Veizaga A.', '2876283', NULL, '2876283', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1464', 'ROXANA CACERES ARGOTE', '3072142', NULL, '3072142', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1465', 'Todollantas Srl', '348298020', NULL, '348298020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1466', 'Wilma Fernndez Vaca', '2975328010', NULL, '2975328010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1467', 'YAPURA', '4049150', NULL, '4049150', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1468', 'DIRCE IMPORT EXPORT SRL', '168840029', NULL, '168840029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1469', 'Salazar &amp; Machicado S.A.', '286648024', NULL, '286648024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1470', 'Emilse Mariscal', '8891728014', NULL, '8891728014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1471', 'OCA LTDA', '1030417024', NULL, '1030417024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1472', 'WALTER VICTOR RODRIGUEZ FUERTE', '3683495014', NULL, '3683495014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1473', 'Felicia Guzmn Flores', '2947416014', NULL, '2947416014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1474', 'Iiguez', '2479117017', NULL, '2479117017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1475', ' Juan Carlos Soria Pardo', '3902687014', NULL, '3902687014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1476', 'Miguel Alejandro Vargas Ponce', '4742235010', NULL, '4742235010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1477', 'Jose Maria Mejia', '3974809016', NULL, '3974809016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1478', 'Felix Machicado Mendoza', '2325001', NULL, '2325001', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1479', 'Alejandro Roberto Gonzales Gut', '4582991014', NULL, '4582991014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1480', 'Lozano', '2319203015', NULL, '2319203015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1481', 'Julio Pelaez', '674406', NULL, '674406', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1482', 'Ruiz Mealla SRL', '173372024', NULL, '173372024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1483', 'FERNANDO BARRAGAN', '4494282014', NULL, '4494282014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1484', 'INTERSALUD S.R.L.', '292874027', NULL, '292874027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1485', 'ICP INGENIERIA Y CONSTRUCCION ', '1020901029', NULL, '1020901029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1486', 'REYNALDO CHOQUE', '4889486016', NULL, '4889486016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1487', 'Castillo', '2729593015', NULL, '2729593015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1488', 'Hinojosa', '5993413', NULL, '5993413', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1489', 'Juan Chiri Cardenas', '4116627016', NULL, '4116627016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1490', 'SEFI S.R.L', '139787029', NULL, '139787029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1491', 'EDUARDO LAURA', '4770343018', NULL, '4770343018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1492', 'Zeballos', '6551280', NULL, '6551280', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1493', 'Wilson Martinez Oropeza', '5798866011', NULL, '5798866011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1494', 'Marianela Salinas Montero', '6247479', NULL, '6247479', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1495', 'Jaime Vargas', '3418997012', NULL, '3418997012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1496', 'Marca Verde SAFI S.A', '192902029', NULL, '192902029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1497', 'ICAS S.A.', '181630026', NULL, '181630026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1498', 'FREMAR LTDA', '1027955027', NULL, '1027955027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1499', 'L y M CONSULTORES S.R.L.', '1008443020', NULL, '1008443020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1500', 'Herrera', '3512576', NULL, '3512576', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1501', 'FREDDY OVANDO', '994674014', NULL, '994674014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1502', 'OSCAR MARIO RIVAS LOZANO', '1807922013', NULL, '1807922013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1503', 'Kattia Len', '6828701', NULL, '6828701', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1504', 'Flores', '3479339', NULL, '3479339', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1505', 'SOCIEDAD SALESIANA', '1023169027', NULL, '1023169027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1506', 'UNIVERSIDAD TECNOLOGICA BOLIVI', '148406028', NULL, '148406028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1507', 'Luis Sejas', '2440459', NULL, '2440459', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1508', 'Marin&amp;Asociados Consultore', '137145028', NULL, '137145028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1509', 'BUDOVA SRL', '281424024', NULL, '281424024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1510', 'Orellana', '2522640013', NULL, '2522640013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1511', 'MIRELIA ZORAIDA ESPINOZA QUISP', '3480328012', NULL, '3480328012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1512', 'Fidel Angulo Ortega', '4124622013', NULL, '4124622013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1513', 'GOSMART INGENIERIA S.R.L.', '234786023', NULL, '234786023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1514', 'Prieto', '3442734', NULL, '3442734', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1515', 'CARLOS MASAPAIJA NUEZ', '1728744028', NULL, '1728744028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1516', 'alba tapia chocllo', '5649979011', NULL, '5649979011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1517', 'GORAN VRANICIC', '2874144018', NULL, '2874144018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1518', 'IDEAS AUTOMATION', '5312174018', NULL, '5312174018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1519', 'Jose Israel Rojas Montero', '4622480', NULL, '4622480', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1520', 'WISSEND CIA. LOG. COM. BOL. SR', '161158026', NULL, '161158026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1521', 'adela melgar tarraga', '4635394019', NULL, '4635394019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1522', 'Oscar Moscoso', '6233801019', NULL, '6233801019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1523', 'Gustavo Iriarte', '8160222', NULL, '8160222', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1524', 'maxima enterprises', '6765722019', NULL, '6765722019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1525', 'Lopez', '4121004010', NULL, '4121004010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1526', 'jaime guerrero rivero', '1100823011', NULL, '1100823011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1527', 'Ayala', '3057210017', NULL, '3057210017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1528', 'Fernandez', '1249765019', NULL, '1249765019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1529', 'Romulo Santillan Pizarro', '6236559012', NULL, '6236559012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1530', 'claudia miranda', '7553082010', NULL, '7553082010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1531', 'MULTIPHARMA REPRESENTACIONES S', '149692022', NULL, '149692022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1532', 'Check Audit Bolivia S.R.L.', '209306022', NULL, '209306022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1533', 'Pamela Pinto', '3340123', NULL, '3340123', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1534', 'Cooperativa Simn Bolvar Ltda', '1025271023', NULL, '1025271023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1535', 'claudia cotacallapa', '1078765', NULL, '1078765', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1536', 'Mario Mattos', '2229551', NULL, '2229551', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1537', 'Roque', '2724439018', NULL, '2724439018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1538', 'Johanna Escarlent Rojas Pea', '4734423011', NULL, '4734423011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1539', 'ESTACION DE SERVICIO MONTERO', '3235350012', NULL, '3235350012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1540', 'Carlos Santiago Aldunate Valen', '5190314019', NULL, '5190314019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1541', 'Gabriela Ramirez', '9818982', NULL, '9818982', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1542', 'INDSOL S.R.L.', '307590026', NULL, '307590026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1543', 'Spencer Roca', '1927876019', NULL, '1927876019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1544', 'Premium Clean srl', '150710024', NULL, '150710024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1545', 'CONSULTORA SHIRU S.R.L.', '305434024', NULL, '305434024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1546', 'Jaqueline osinaga', '3832535019', NULL, '3832535019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1547', 'SOLDIERS SRL', '292462023', NULL, '292462023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1548', 'RAMOS', '4802012017', NULL, '4802012017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1549', 'ruddy cuellar', '5422320', NULL, '5422320', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1550', 'BETONSER SRL', '298808024', NULL, '298808024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1551', 'ROSA OLIVA EGUEZ', '3919378016', NULL, '3919378016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1552', 'EMCOMUNA S.R.L.', '1023397028', NULL, '1023397028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1553', 'GABRIEL CELSO GALLARDO MISME', '7720594', NULL, '7720594', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1554', 'GENERAL LUX SRL', '189704022', NULL, '189704022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1555', 'LLANOS', '5743019', NULL, '5743019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1556', 'coop. ahorro y credito comarap', '1011951026', NULL, '1011951026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1557', 'Metodista Instituto Americano ', '1015619023', NULL, '1015619023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1558', 'EVA CARBAJAL VARGAS', '5325705', NULL, '5325705', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1559', 'manuel bonilla', '3235703018', NULL, '3235703018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1560', 'Gladys Alejandra Enriquez Roja', '3533390017', NULL, '3533390017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1561', 'Limber Baldiviezo', '1875235015', NULL, '1875235015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1562', 'MONICA MATIAS OVANDO', '6381864018', NULL, '6381864018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1563', 'TRANS MICHEL &amp; GARCIA SRL', '166932029', NULL, '166932029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1564', 'Jos Luis Flores', '3978963013', NULL, '3978963013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1565', 'toledo &amp; carmona srl', '121883028', NULL, '121883028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1566', 'TEOFILO MICHEL LLANES', '5810213014', NULL, '5810213014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1567', 'Trujillo', '2351305012', NULL, '2351305012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1568', 'Codelsa S.R.L', '184972026', NULL, '184972026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1569', 'FERNANDEZ', '3696156', NULL, '3696156', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1570', 'ARTURO SEVERICH BALDIVIESO', '2739047016', NULL, '2739047016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1571', 'DAVID MEALLA', '3497804017', NULL, '3497804017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1572', 'gabriela yave ribera', '7726442', NULL, '7726442', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1573', 'yriberry', '838316', NULL, '838316', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1574', 'SEDIM S.R.L.', '179366027', NULL, '179366027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1575', 'SOFGOM SRL', '300134028', NULL, '300134028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1576', 'DANIEL CHAMBI', '6285695017', NULL, '6285695017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1577', 'Juan Jos Ticona Bautista', '3999113', NULL, '3999113', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1578', 'IN TERMINIS GLOBAL S.R.L.', '317642021', NULL, '317642021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1579', 'MARTHA BEATRIZ GARECA CONDORI', '7155991016', NULL, '7155991016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1580', 'FUNDACION LEVANTATE MUJER', '190188020', NULL, '190188020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1581', 'ERLAND FRANZ LLANO CORDOVA', '2200567016', NULL, '2200567016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1582', 'Maquera', '4955691', NULL, '4955691', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1583', 'ARIEL VEIZAGA', '6412197014', NULL, '6412197014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1584', 'MARIA PAZ DE IBAEZ', '1457212011', NULL, '1457212011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1585', 'COOPERATIVA DE SERVICIOS PUBLI', '123445029', NULL, '123445029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1586', 'PROBIOMA', '1012567029', NULL, '1012567029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1587', 'ROSALNES IMPRESORES LTDA.', '1008275021', NULL, '1008275021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1588', 'conde', '6722474011', NULL, '6722474011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1589', 'Wilfredo Flores Milan', '3130245017', NULL, '3130245017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1590', 'Wilson Juarez Aban', '5781699', NULL, '5781699', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1591', 'MS RATIO S.A.', '153812023', NULL, '153812023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1592', 'VILLARROEL', '125267029', NULL, '125267029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1593', 'BERA DE BOLIVIA SA', '1004633024', NULL, '1004633024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1594', 'OCG Ltda.', '210408023', NULL, '210408023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1595', 'JOSE GARCIA', '6441982017', NULL, '6441982017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1596', 'LAIME &amp; ADUVIRI S.R.L.', '170602029', NULL, '170602029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1597', 'Centro de Inversiones turistic', '159218022', NULL, '159218022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1598', 'jessica fernandez chavez', '7775380', NULL, '7775380', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1599', 'ALIZON CEJAS', '9584427014', NULL, '9584427014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1600', 'ronal hugo ruiz ovando', '5656365016', NULL, '5656365016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1601', 'PATRICIA TICONA', '4950471014', NULL, '4950471014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1602', 'Carlos Rodriguez', '1895278', NULL, '1895278', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1603', 'Biotech  Bolivia Ltda', '1023287024', NULL, '1023287024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1604', 'Isabel Norma Mancilla', '4147015017', NULL, '4147015017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1605', 'Gesely Flores Fonseca', '7633189', NULL, '7633189', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1606', 'RED OX SRL', '220604025', NULL, '220604025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1607', 'Juan Carlos Rivera Sagardia', '3978397', NULL, '3978397', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1608', 'MARIO TABY MANCILLA', '641631', NULL, '641631', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1609', 'zurita', '5227576017', NULL, '5227576017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1610', 'Patricia Chavez', '4814009011', NULL, '4814009011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1611', 'Fundacion Institucion de benef', '127937029', NULL, '127937029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1612', 'consultora cirbian', '4580192013', NULL, '4580192013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1613', 'EMILIO GERARDO LAURA AGUILAR', '4262321012', NULL, '4262321012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1614', 'Waldo Bolvar Quispe', '5123537', NULL, '5123537', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1615', 'Dulce Garca', '6270580', NULL, '6270580', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1616', 'Miguel ngel Yanapa Chapi', '4826013017', NULL, '4826013017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1617', 'ESPINOZA', '48116240146', NULL, '48116240146', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1618', 'Jorge Fernando Hoyos Arrazola', '3936165015', NULL, '3936165015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1619', 'FERNANDEZ', '4319266', NULL, '4319266', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1620', 'ana alejandra rios quispe', '7701422', NULL, '7701422', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1621', 'SALOMON QUIROZ ROMERO', '2993522', NULL, '2993522', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1622', 'Vladimir Porcel', '5952899', NULL, '5952899', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1623', 'Ernesto Cardenas', '4704671', NULL, '4704671', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1624', 'Alejandro Salazar', '7636946', NULL, '7636946', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1625', 'CLAURE', '5212318', NULL, '5212318', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1626', 'SAVIPOR S.R.L.', '261520020', NULL, '261520020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1627', 'Limberg Encinas Fonseca', '5376660', NULL, '5376660', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1628', 'Arroyo', '8023749018', NULL, '8023749018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1629', 'Claudia Mabel Ordez balderas', '7111208019', NULL, '7111208019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1630', 'VARGAS', '6876037', NULL, '6876037', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1631', 'ESSA S.R.L.', '356257029', NULL, '356257029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1632', 'VELASQUEZ', '2288637017', NULL, '2288637017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1633', 'Juan Jose Soto', '3475181016', NULL, '3475181016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1634', 'Ledezma', '4310255', NULL, '4310255', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1635', 'FREDDY LOPEZ MONTERO', '124274+6014', NULL, '124274+6014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1636', 'JUAN CARLOS YUCRA CABRERA', '5013123019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1637', 'AGUSTINA ALCON ROQUE', '2378192016', NULL, '2378192016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1638', 'GUIDO RAMIREZ MEDINA', '7681851011', NULL, '7681851011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1639', 'yilda mimura', '6234231', NULL, '6234231', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1640', 'Luz  Albornos Zabalaga', '6299314018', NULL, '6299314018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1641', 'CONITAR LTDA.', '168292026', NULL, '168292026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1642', 'ACB Filial Cbba. Unidad Carbur', '1007921022', NULL, '1007921022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1643', 'AGATHA CLARICE DA SILVA OVANDO', '4539924013', NULL, '4539924013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1644', 'Alicia nuez Jimenez', '3898855018', NULL, '3898855018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1645', 'diego stanley pedrazas osinaga', '6235484018', NULL, '6235484018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1646', 'COOPAPPI LTDA.', '1011857028', NULL, '1011857028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1647', 'CACGPP SRL', '192876026', NULL, '192876026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1648', 'jhonny acosta', '7995481018', NULL, '7995481018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1649', 'Luis Moreno', '5822652016', NULL, '5822652016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1650', 'Diego Alzugaray', '7889572015', NULL, '7889572015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1651', 'Ruth Antonieta Rada Holguin de', '632857011', NULL, '632857011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1652', 'DYL CHACO LTDA.', '227214029', NULL, '227214029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1653', 'VICTOR SELAEZ', '4306074015', NULL, '4306074015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1654', 'LORENA GARCIA AGUILAR', '7526270', NULL, '7526270', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1655', 'Gonzalo Alcon', '2371869', NULL, '2371869', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1656', 'Arauco', '3119889', NULL, '3119889', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1657', 'DEXTER ESPINOZA', '5277849', NULL, '5277849', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1658', 'ferrufino', '3732661', NULL, '3732661', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1659', 'Jorge Fernando Pea Mojica', '2859304016', NULL, '2859304016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1660', 'Matilde Cabrera', '1527845012', NULL, '1527845012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1661', 'Clemente Gregorio Marquez', '7252206', NULL, '7252206', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1662', 'BRAULIO SARZURI', '2787947011', NULL, '2787947011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1663', 'Ninoska Andrade Garcia', '3113317015', NULL, '3113317015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1664', 'Sonia Cachaca', '5736738', NULL, '5736738', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1665', 'YONY SALDAA ROMAN', '6251014019', NULL, '6251014019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1666', 'Heredia', '6169447017', NULL, '6169447017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1667', 'Mauricio Argandoa', '4538227019', NULL, '4538227019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1668', 'AIR DIVISION MASTERLINE S.R.L.', '137449027', NULL, '137449027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1669', 'SPC Impresores S.A.', '1029191028', NULL, '1029191028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1670', 'Sergio Bejarano Carvajal', '2063946', NULL, '2063946', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1671', 'Dominguez', '3168162', NULL, '3168162', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1672', 'Carlos Chambi Ramos', '3334906', NULL, '3334906', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1673', 'WILTER CHUMACERO', '4173993017', NULL, '4173993017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1674', 'SECOFIN SRL', '129657023', NULL, '129657023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1675', 'WILLY MAGNE CASAS', '3118380011', NULL, '3118380011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1676', 'BALLESTEROS', '4244980010', NULL, '4244980010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1677', 'comercial boliviana carrington', '1004723024', NULL, '1004723024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1678', 'Ariel Gironda Funes', '3431491015', NULL, '3431491015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1679', 'Manfredo Junior Rojas Marin', '9022688010', NULL, '9022688010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1680', 'LITEC SRL', '141563025', NULL, '141563025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1681', 'Virginia Miranda Morales', '3762474018', NULL, '3762474018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1682', 'RIOS RODRIGUEZ', '4454398013', NULL, '4454398013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1683', 'Bladimir Castro', '4444019', NULL, '4444019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1684', 'LUCAS', '3790723', NULL, '3790723', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1685', 'Maria del Carmen Cala Arteaga', '671278014', NULL, '671278014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1686', 'juana claros camacho', '5921371', NULL, '5921371', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1687', 'Vladimir Choque', '3761691012', NULL, '3761691012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1688', 'DIRECTORIO MIXTO DEL PARQUE IN', '165580026', NULL, '165580026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1689', 'Noemi Marisol Ramos Alanoca', '5122241014', NULL, '5122241014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1690', 'Jorge Cardona', '5642820014', NULL, '5642820014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1691', 'Poma', '3365937011', NULL, '3365937011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1692', 'Patricia Verushcka Claros', '3579354011', NULL, '3579354011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1693', 'Mondo Sapori S.R.L.', '314894027', NULL, '314894027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1694', 'Carla Viviana Tellez Ribera', '4731339019', NULL, '4731339019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1695', 'ILSE FERNADEZ CABRERA', '4455946013', NULL, '4455946013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1696', 'CLAUDIA DEMATTEI', '5987945019', NULL, '5987945019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1697', 'James Salazar Guzman', '7944690013', NULL, '7944690013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1698', 'LENY RIBERA GARCIA', '5381646', NULL, '5381646', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1699', 'ALL SUPPLIES SRL', '314732020', NULL, '314732020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1700', 'MKV SOLUCIONES INTEGRADAS SRL', '264632027', NULL, '264632027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1701', 'PORTUGAL', '2308412', NULL, '2308412', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1702', 'luis barrios', '5474343012', NULL, '5474343012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1703', 'Botello', '2205197015', NULL, '2205197015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1704', 'Sonia Fernandez', '5246058015', NULL, '5246058015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1705', 'Codifas s.r.l.', '300880029', NULL, '300880029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1706', 'Maribel', '5012130017', NULL, '5012130017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1707', 'LE MANS LTDA', '1028551027', NULL, '1028551027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1708', 'Janette Gutierrez', '4419002', NULL, '4419002', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1709', 'choquehuanca', '4995890017', NULL, '4995890017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1710', 'paul sandoval', '3936063', NULL, '3936063', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1711', 'JHONNY MAMANI PORCO', '9590819', NULL, '9590819', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1712', 'AVERANGA', '2190734', NULL, '2190734', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1713', 'SSTM SRL', '1005553024', NULL, '1005553024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1714', 'Carlos Alberto Urzagaste Cala', '5074533011', NULL, '5074533011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1715', 'AVERANGA', '4920628014', NULL, '4920628014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1716', 'Gabriela Schmidt Rivero', '7657164', NULL, '7657164', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1717', 'Marlene Flores Guzman', '1527697019', NULL, '1527697019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1718', 'Sandra Blacud Lanuza', '1852486015', NULL, '1852486015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1719', 'MILAGROS WARA PACHECO FLORES', '12482222010', NULL, '12482222010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1720', 'tecno srl', '1012815021', NULL, '1012815021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1721', 'Primera Iglesia Evanglica Bau', '3257834', NULL, '3257834', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1722', 'CERDET', '1024647029', NULL, '1024647029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1723', 'CAMACHO', '4765826010', NULL, '4765826010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1724', 'CABRERA', '2715809', NULL, '2715809', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1725', 'FUNES', '4431817019', NULL, '4431817019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1726', 'PEALOZA &amp; VAES CONSULTORE', '307388028', NULL, '307388028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1727', 'Judith Malena Bejarano Prez', '5537050011', NULL, '5537050011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1728', 'Bac srl', '1021277029', NULL, '1021277029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1729', 'JORGE OLMOS ARDAYA', '3175460', NULL, '3175460', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1730', 'Corporacion Minera de Bolivia', '100696523', NULL, '100696523', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1731', 'Asunta Roda Carrillo', '4682804014', NULL, '4682804014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1732', 'Nazamedh Conny F Medrano', '4878821018', NULL, '4878821018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1733', 'MIRIAM ANDIA TORRES', '1385478013', NULL, '1385478013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1734', 'Paola Ivanna Ticona Garron', '5643381011', NULL, '5643381011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1735', 'INDUSTRIAS ALBUS S.A.', '1006789023', NULL, '1006789023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1736', 'COPIJSUD', '1006897022', NULL, '1006897022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1737', 'Chambi', '3375999', NULL, '3375999', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1738', 'PEA', '2540173018', NULL, '2540173018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1739', 'Kevin Walter Vasquez Benavides', '4878680018', NULL, '4878680018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1740', 'JOSE DAVILA MARTINEZ', '5333472013', NULL, '5333472013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1741', 'GRUPO MEDICO SOLIDARIO S.R.L.', '136935024', NULL, '136935024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1742', 'Aracely vania soliz soliz', '3925193017', NULL, '3925193017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1743', 'Jaime Armando Moreno Maldonado', '7104901', NULL, '7104901', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1744', 'Jorge Morales', '1993672', NULL, '1993672', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1745', 'CHAVEZ', '3441240017', NULL, '3441240017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1746', 'FUNDACION CETABOL', '164992028', NULL, '164992028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1747', 'luz aguilar', '6091343014', NULL, '6091343014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1748', 'Fernandez', '5239011', NULL, '5239011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1749', 'Magaly Fernandez', '5734123', NULL, '5734123', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1750', 'Roberto Arce Cuellar', '1991705', NULL, '1991705', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1751', 'Carmen Janet Mamani Morales', '3546912013', NULL, '3546912013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1752', 'ESPINOZA', '4811624016', NULL, '4811624016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1753', 'Radio San Miguel', '283660028', NULL, '283660028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1754', 'Asociacin Civil Armona', '126975023', NULL, '126975023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1755', 'Miguel Berrios', '3850253014', NULL, '3850253014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1756', 'RICHARD WILSON SALGUERO VALENC', '3869590016', NULL, '3869590016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1757', 'Maribel Crespo Soria', '4506425016', NULL, '4506425016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1758', 'HUAMAN', '6815136', NULL, '6815136', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1759', 'Maribel Virreira', '3468628', NULL, '3468628', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1760', 'DANIELA MENDOZA CARRASCO', '5130512', NULL, '5130512', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1761', 'Lopez Mujica S.R.L.', '199818024', NULL, '199818024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1762', 'Ronald David Inca Quispe', '5239043013', NULL, '5239043013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1763', 'Congregacin de los Hermanos M', '309352025', NULL, '309352025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1764', 'VIANKA TATIANA CAMACHO PEREZ', '6364280010', NULL, '6364280010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1765', 'CAMINO SRL', '1012255027', NULL, '1012255027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1766', 'Edgar Pelez Terrazas', '3064414015', NULL, '3064414015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1767', 'Perez', '4376871', NULL, '4376871', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1768', 'Emerson Justiniano Hurtado', '4885938010', NULL, '4885938010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1769', 'MAYTA ', '6095980', NULL, '6095980', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1770', 'medina', '5281608014', NULL, '5281608014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1771', 'Quiroga ', '981851', NULL, '981851', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1772', 'deyob s.r.l.', '317990027', NULL, '317990027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1773', 'Leonit Ortiz Justiniano', '4641019013', NULL, '4641019013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1774', 'julio tito fernandez mamani', '4955589', NULL, '4955589', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1775', 'MERY YOLANDA BARBA DE BULACIA', '1639698010', NULL, '1639698010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1776', 'Freddy Valle ', '5418800', NULL, '5418800', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1777', 'Oscar Ariel Dvila  ', '6200047', NULL, '6200047', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1778', 'Castro ', '2602571017', NULL, '2602571017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1779', 'Marines Rojas Castro ', '9637429019', NULL, '9637429019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1780', ' Juan XXIII', '1021129021', NULL, '1021129021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1781', 'MARCOS ECHALAR', '8724220', NULL, '8724220', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1782', 'Lidia vaca Surez', '3217840', NULL, '3217840', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1783', 'Julian Raul Fisher Chavez', '1750559', NULL, '1750559', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1784', 'HUGO CHURA', '3405367018', NULL, '3405367018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1785', 'SAUCEDO ', '7657231019', NULL, '7657231019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1786', 'reynaldo aliaga ', '4278020011', NULL, '4278020011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1787', 'mamani', '4904929', NULL, '4904929', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1788', 'MACHACA', '4914142010', NULL, '4914142010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1789', 'Juan Lopez Videla ', '3455043010', NULL, '3455043010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1790', 'andrea torricos', '4696455', NULL, '4696455', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1791', 'RODRIGUEZ &amp; BAUDOIN SRL', '1018245021', NULL, '1018245021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1792', 'MOREIRA', '4828921016', NULL, '4828921016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1793', 'Chenier Fernando Justiniano Ca', '6299377', NULL, '6299377', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1794', 'Armando Tapia Calle', '4362286018', NULL, '4362286018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1795', 'Ericka Arteaga Barba', '7582171017', NULL, '7582171017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1796', 'RIOS', '3009079', NULL, '3009079', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1797', 'ERWIN ORTIZ', '4729547', NULL, '4729547', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1798', 'EVER ERICK CALLATA CHAVEZ', '7283963', NULL, '7283963', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1799', 'REDAL DE FREDDY ACEBEY', '367574012', NULL, '367574012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1800', 'Narciso Torres', '9029134017', NULL, '9029134017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1801', 'Fabian Zurita', '5806327017', NULL, '5806327017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1802', 'SUPER HAAS LTDA.', '1009397029', NULL, '1009397029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1803', 'Jos Jimnez', '213297013', NULL, '213297013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1804', 'David', '6380738SC', NULL, '6380738SC', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1805', 'Jesus medina', '5800441017', NULL, '5800441017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1806', 'Milton Saavedra', '5925095012', NULL, '5925095012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1807', 'ROSEMARY PAZ CHAVEZ', '4835053015', NULL, '4835053015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1808', 'leticia Delgado Mendoza', '3110774018', NULL, '3110774018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1809', 'Matty Flores', '2803312', NULL, '2803312', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1810', 'Marlene Flores Rojas', '3933365', NULL, '3933365', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1811', 'Flores', '6138753', NULL, '6138753', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1812', 'SEGUNDO APAZA QUISPE', '3971355', NULL, '3971355', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1813', 'Juan Carlos alcivar', '5890766015', NULL, '5890766015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1814', 'susana gisel rodriguez schmitt', '4689836', NULL, '4689836', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1815', 'COOPERATIVA DE TRANSPORTE ENTR', '184828025', NULL, '184828025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1816', ' Julio Cesar Vasquez Rocabado', '3130810018', NULL, '3130810018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1817', 'CAMARGO KAREN', '4896821', NULL, '4896821', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1818', 'lopez', '4277112', NULL, '4277112', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1819', 'Sara Betancourt', '4915589', NULL, '4915589', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1820', 'FRALAK COMERCIO IMPORT EXPORT ', '121461022', NULL, '121461022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1821', 'Vivian Marleny Mayta Limachi', '2718852', NULL, '2718852', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1822', 'BAC S.R.L.', '293236023', NULL, '293236023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1823', 'SONDAJES MINEROS S.R.L.', '291142023', NULL, '291142023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1824', 'Herbasbol srl', '120135022', NULL, '120135022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1825', 'Valdivia', '997147019', NULL, '997147019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1826', 'LAZARTE', '5227962012', NULL, '5227962012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1827', 'Comsi Ltda.', '1030629020', NULL, '1030629020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1828', 'Nancy Vargas Aparicio', '2392883015', NULL, '2392883015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1829', 'GONZALO AVILA FLORES', '1058362018', NULL, '1058362018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1830', 'EFRAIN TACURI ARANDIA', '5657935', NULL, '5657935', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1831', 'Sebastin Antelo', '6347386', NULL, '6347386', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1832', 'Monje', '393104011', NULL, '393104011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1833', 'Anahi Matkovic Dedic', '6315526013', NULL, '6315526013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1834', 'EDELBERTO VALDEZ CAZON', '1886356017', NULL, '1886356017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1835', 'CLARITY CONSULTING S.R.L.', '229358022', NULL, '229358022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1836', 'Candelaria Ergueta', '4844132', NULL, '4844132', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1837', 'IVAN ALFARO CASAZOLA', '3557217', NULL, '3557217', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1838', 'Hotel el viejo molino', '1002485025', NULL, '1002485025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1839', 'Franklin Pea Barrios', '5898497019', NULL, '5898497019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1840', 'Rodolfo Moscoso ', '1074862016', NULL, '1074862016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1841', 'Alfredo Camacho Gutierrez', '568897014', NULL, '568897014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1842', 'Yucra', '5728755', NULL, '5728755', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1843', 'Cecilia Moscoso', '7467775011', NULL, '7467775011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1844', 'roger andia salinas', '5199148016', NULL, '5199148016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1845', 'despachante de aduana Mersur s', '157954024', NULL, '157954024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1846', 'Julio Cesar Bazoalto Saucedo', '3841699019', NULL, '3841699019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1847', 'Olga Urea', '3147061', NULL, '3147061', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1848', 'Trans Global SRL', '1002503021', NULL, '1002503021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1849', 'Teresa Taboada Carrasco', '2614939011', NULL, '2614939011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1850', 'Ovalle', '4826852', NULL, '4826852', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1851', 'Mario Morn', '2844911', NULL, '2844911', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1852', 'Murillo', '3484684014', NULL, '3484684014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1853', 'Wilmer Saire', '1765378011', NULL, '1765378011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1854', 'Miguel Zarate Condori', '6073482014', NULL, '6073482014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1855', 'Aduviri', '2691058', NULL, '2691058', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1856', 'ANA HOYOS', '7788618', NULL, '7788618', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1857', 'artero', '6422894018', NULL, '6422894018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1858', 'yanez', '3392844016', NULL, '3392844016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1859', 'guillermo velasquez', '4115341', NULL, '4115341', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1860', 'MOISES IMOPOCO WILLY', '12467626015', NULL, '12467626015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1861', 'Virginia Alejandro Manrriquez', '5382797016', NULL, '5382797016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1862', 'RIVES AUDITORES SRL', '341524024', NULL, '341524024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1863', 'VITECO S.R.L', '307818026', NULL, '307818026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1864', 'cahuana', '2444919', NULL, '2444919', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1865', 'Garcia', '5768596017', NULL, '5768596017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1866', 'Yolanda Vsquez Escbar', '3231882011', NULL, '3231882011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1867', 'CRUZ', '4809943', NULL, '4809943', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1868', 'CARLOS AGUIRRE', '3395033015', NULL, '3395033015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1869', 'MARLENE CARMEN PAICHO VILLARPN', '3718252', NULL, '3718252', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1870', 'Inversiones Inmobiliarias La P', '201336027', NULL, '201336027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1871', 'Blanco ', '4271948015', NULL, '4271948015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1872', 'VANEZA BELL', '5339017', NULL, '5339017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1873', 'Plural Editores S.R.L.', '1002827029', NULL, '1002827029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1874', 'VLADIMIR ARANCIBIA', '5642700015', NULL, '5642700015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1875', 'pari', '8413579', NULL, '8413579', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1876', 'Marco Franco', '4673917', NULL, '4673917', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1877', 'TALLER - COMPACTO', '352361024', NULL, '352361024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1878', 'JUAN CARLOS VELASQUEZ', '3390611016', NULL, '3390611016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1879', 'justina quispe caiza', '8144131010', NULL, '8144131010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1880', 'Claudia Pearanda Vargas', '2476568011', NULL, '2476568011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1881', 'FRITABOL', '226906022', NULL, '226906022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1882', 'CRUZ', '0', NULL, '0', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1883', 'Lourdez santos ', '6629092012', NULL, '6629092012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1884', 'Luis fernando roca', '4192675', NULL, '4192675', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1885', 'TRANS GAAB LTDA ', '13192304', NULL, '13192304', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1886', 'TRANS GAAB LTDA ', '131923024', NULL, '131923024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1887', 'Cruz', '6072817013', NULL, '6072817013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1888', 'cazas', '4256131012', NULL, '4256131012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1889', 'Diaz', '4903126', NULL, '4903126', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1890', 'Alvarado', '7981505', NULL, '7981505', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1891', 'BOLHISPANIA INDUSTRIA Y COMERC', '1002009026', NULL, '1002009026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1892', 'PROSPECCION GEOLOGICA ORIENTAL', '321164024', NULL, '321164024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1893', 'Nayra Terrazas', '3761827', NULL, '3761827', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1894', 'Luis alberto gongora colque', '8183663014', NULL, '8183663014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1895', 'jorge teran', '2961152', NULL, '2961152', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1896', 'ARTEAGA ', '679689', NULL, '679689', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1897', 'Ricardo Soliz Balderas', '1830789011', NULL, '1830789011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1898', 'FILS COMPANY SRL', '122537026', NULL, '122537026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1899', 'Jimena Cardenas', '5346682013', NULL, '5346682013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1900', 'Sacipetrol SRL', '220902028', NULL, '220902028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1901', 'Jorge armando mejia', '7114727', NULL, '7114727', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1902', 'OCJR SOLUCIONES SRL', '359862022', NULL, '359862022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1903', 'Humberto Viana Suarez', '3914299', NULL, '3914299', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1904', 'Ervin Carlos Valverde Romero', '4688176017', NULL, '4688176017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1905', 'Mrida', '3511362', NULL, '3511362', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1906', 'ruben alvarado', '2429521016', NULL, '2429521016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1907', 'MARCELO VARGAS', '5637471', NULL, '5637471', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1908', 'Carmen karina Vasquez Calros', '5153902014', NULL, '5153902014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1909', 'BIOTECNOLOGIA QUIMICA BIOTEQ S', '292540020', NULL, '292540020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1910', 'STAFFING LTDA', '1026251022', NULL, '1026251022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1911', 'Mirtha Blanco', '3344342', NULL, '3344342', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1912', 'JUAN FELIPE PAREJAS MUOZ REYE', '4595179014', NULL, '4595179014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1913', 'Nicodemo Tola Copa', '6411715', NULL, '6411715', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1914', 'WALTER FLORES', '3476189', NULL, '3476189', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1915', 'Salomon Akly', '1503208', NULL, '1503208', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1916', 'Marco Antonio Riofrio Montalva', '4624514', NULL, '4624514', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1917', 'Javier Salazar', '5375825', NULL, '5375825', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1918', 'Mariela Mamani Vasquez', '67776739', NULL, '67776739', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1919', 'Mariela Mamani Vasquez', '4736102012', NULL, '4736102012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1920', 'Espinoza', '4335653010', NULL, '4335653010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1921', 'MARCELO PESSOA ALVAREZ', '6201249012', NULL, '6201249012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1922', 'MIGUEZ', '4404387017', NULL, '4404387017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1923', 'Luis Antonio Carolini ', '4686647014', NULL, '4686647014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1924', 'Laboratorio Bio Medic SRL.', '297098028', NULL, '297098028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1925', 'Carla Noelia Melgar Iturry', '8321453', NULL, '8321453', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1926', 'carmen saenz de salas', '2809812', NULL, '2809812', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1927', 'BALA S.R.L.', '170544025', NULL, '170544025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1928', 'FRANCISCO JAVIER SAAVEDRA SILV', '2638172011', NULL, '2638172011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1929', 'elvis mendoza', '5227857010', NULL, '5227857010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1930', 'henrry lopez lino', '8241483', NULL, '8241483', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1931', 'INDUSTRIAS ENVAZEN S.A.', '341252027', NULL, '341252027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1932', 'Kasas', '8328412', NULL, '8328412', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1933', 'Fundacin Amigos de la Natural', '1025341028', NULL, '1025341028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1934', 'Dayo Gonzales', '2300279018', NULL, '2300279018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1935', 'CASABOOS S.R.L.', '359955025', NULL, '359955025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1936', 'JIMENA MAMANI CALLISAYA', '6944133014', NULL, '6944133014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1937', 'Audra Guiga', '1717018', NULL, '1717018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1938', 'Aruquipa', '4315219010', NULL, '4315219010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1939', 'Marcelino Poquiviqui', '1973121010', NULL, '1973121010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1940', 'Claudia Peralta', '7494458', NULL, '7494458', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1941', 'COOPERATIVA DE SERVICIOS ELECT', '1011247020', NULL, '1011247020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1942', 'Mario Alvarez', '2360280011', NULL, '2360280011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1943', 'GESTORA DE COBRANZA E INVERSIO', '308700020', NULL, '308700020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1944', 'Antonio Hernandez', '2342481', NULL, '2342481', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1945', 'Juan carlos lopez', '4196177', NULL, '4196177', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1946', 'ROMEL ADONAY FRANCO LOPEZ', '2948127015', NULL, '2948127015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1947', 'Lourdes Escobar Surez', '4189260017', NULL, '4189260017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1948', 'vicente colque paco', '7920577011', NULL, '7920577011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1949', 'CONSULTORA CONTABLE ROMAGRI S.', '260940026', NULL, '260940026', NULL, NULL, NULL, NULL, NULL, '', '0');
INSERT INTO `0_crm_persons` VALUES
('1950', 'VERONICA SUAREZ', '6252989019', NULL, '6252989019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1951', 'Baceinfor Ltda.', '282188028', NULL, '282188028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1952', 'VICTOR HUGO FLORES BERTHALET', '2920650015', NULL, '2920650015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1953', 'Transporte internacional los a', '201028028', NULL, '201028028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1954', 'Edith Merubia  oretea', '4564175', NULL, '4564175', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1955', 'ERWIN MARCELO SANCHEZ ARIANTA', '5000423015', NULL, '5000423015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1956', 'marcelino medina choque', '3176381016', NULL, '3176381016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1957', 'Maria Teresa Soliz de Cortes', '3857821014', NULL, '3857821014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1958', 'jimmy rolando quionez chaca', '4042109013', NULL, '4042109013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1959', 'Margoth Ruiz', '3935343', NULL, '3935343', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1960', 'JULIO COLQUE ARGANDOA', '5414379019', NULL, '5414379019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1961', 'Wilson', '4806916', NULL, '4806916', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1962', 'AGRISAM SRL', '306950025', NULL, '306950025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1963', 'PARALELO SRL', '255230023', NULL, '255230023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1964', 'RINA FLORES', '5892397', NULL, '5892397', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1965', 'SINCHI WAYRA S.A.', '1020161028', NULL, '1020161028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1966', 'Laura Pinedo Mamani', '7929252', NULL, '7929252', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1967', 'VASQUEZ', '2224885016', NULL, '2224885016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1968', 'INDUSTRIA ALIMENTICIA BLEYER ', '310822028', NULL, '310822028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1969', 'luis alberto moncada', '3285045014', NULL, '3285045014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1970', 'JRM CARPIO ASOCIADOS S.R.L. ', '288442020', NULL, '288442020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1971', 'Noemi Esther Tiini Chambi', '7050948', NULL, '7050948', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1972', 'chavez', '4833248', NULL, '4833248', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1973', 'FLORA G. COCHI MORANTE', '3467998015', NULL, '3467998015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1974', 'ascarrunz', '3391589011', NULL, '3391589011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1975', 'NM CONSULTING', '5597777014', NULL, '5597777014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1976', 'Delia Saavedra', '2445425013', NULL, '2445425013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1977', 'Jhamel Valda', '5491722', NULL, '5491722', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1978', 'WILFREDO ROMULO JUSTINIANO OLI', '4196639015', NULL, '4196639015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1979', 'VARGAS', '5796470', NULL, '5796470', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1980', 'Luis Vildozo', '1262691017', NULL, '1262691017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1981', 'Urbacorp Servicios Integrales ', '331148024', NULL, '331148024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1982', 'machaca', '2489641011', NULL, '2489641011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1983', 'Centerplast s.r.l.', '1029759021', NULL, '1029759021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1984', 'Altiknits Confecciones S.A.', '181354027', NULL, '181354027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1985', 'Constructora Roma Terrinoni S.', '226258021', NULL, '226258021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1986', 'TUCO', '6144297', NULL, '6144297', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1987', 'Marco Soza', '3690703', NULL, '3690703', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1988', 'GIAPROC SRL', '169448021', NULL, '169448021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1989', 'Nina ', '2525747013', NULL, '2525747013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1990', 'AIDA ANAGUA QUEZADA', '4615942017', NULL, '4615942017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1991', 'Suarez', '4810166', NULL, '4810166', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1992', 'FRUTOS DEL SUR S.R.L.', '187234020', NULL, '187234020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1993', 'Victor Justino Apaza Callisaya', '3462595015', NULL, '3462595015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1994', 'Mendoza', '2635655016', NULL, '2635655016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1995', 'SINAI SRL', '1005847029', NULL, '1005847029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1996', 'Cecilia Silvera', '5872453', NULL, '5872453', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1997', 'SYBELE GUTIERREZ', '5374503', NULL, '5374503', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1998', 'TAPIA HERMANOS TRANSPORTE SRL.', '1005799023', NULL, '1005799023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1999', 'Luis Fernando Arias Paz', '1570775013', NULL, '1570775013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2000', 'Maria Rene Jaldin Cespedes', '9717487', NULL, '9717487', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2001', 'Emerson Garcia', '4612127', NULL, '4612127', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2002', 'Saravia', '45034555016', NULL, '45034555016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2003', 'David Perez', '1396827', NULL, '1396827', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2004', 'VISOR ASOCIADOS S.R.L', '195988022', NULL, '195988022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2005', 'Daniel Garcia Molina', '4422928018', NULL, '4422928018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2006', 'PAGOS SRL', '174992020', NULL, '174992020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2007', 'Ach', '1426236', NULL, '1426236', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2008', 'Jimenez', '6117330013', NULL, '6117330013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2009', 'Melvy Cuevas Silva', '343866010', NULL, '343866010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2010', 'carla lorena ponce gutierrez', '9749376', NULL, '9749376', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2011', 'Mara Isabel Montecinos', '3100076015', NULL, '3100076015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2012', 'Jose Wagner Guarena Chao', '4382389017', NULL, '4382389017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2013', 'Carmen Rosa Condori Vedia', '6591690011', NULL, '6591690011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2014', 'ZAFIR ELENA SANCHEZ DE PERALTA', '6189835014', NULL, '6189835014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2015', 'VICTOR HUGO MEDINA', '4587574013', NULL, '4587574013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2016', 'IM GROUP S.R.L', '328696024', NULL, '328696024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2017', 'EMPRESA CONSTRUCTORA LOPEZ Y Z', '1014441022', NULL, '1014441022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2018', 'Khalil Inti Quiones Escobar', '5303267018', NULL, '5303267018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2019', 'Lilibeth Pea Vargas', '6291751', NULL, '6291751', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2020', 'NAOKI SUSHI DELIVERY SRL', '288986023', NULL, '288986023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2021', 'TABLAN CONSULTING S.L. SUCURSA', '350778021', NULL, '350778021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2022', 'E&amp;S OUTSOURCING SRL', '161216021', NULL, '161216021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2023', 'Servicont Asesoria Impositiva ', '345114029', NULL, '345114029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2024', 'Willy Rivera B.', '1079539', NULL, '1079539', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2025', 'Juan Raul Paniagua Ponce', '4527817010', NULL, '4527817010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2026', 'Ledezma', '1054005', NULL, '1054005', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2027', 'ROCIO SALLUCO AVALOS', '8969367012', NULL, '8969367012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2028', 'edgar soria veizaga', '6365844', NULL, '6365844', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2029', 'melvin vincenti', '3545942018', NULL, '3545942018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2030', 'Javier Pomacusi Ballesteros', '4092378-ch', NULL, '4092378-ch', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2031', 'Wilson Guzmn Coca', '5071354016', NULL, '5071354016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2032', 'STP SANEAR SRL', '1031007028', NULL, '1031007028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2033', 'josiana bacega', '17596', NULL, '17596', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2034', 'MIRIAM PORTILLO', '4789010010', NULL, '4789010010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2035', 'Yosmar Oporto Pasquier', '1145080', NULL, '1145080', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2036', 'KESHIA GUTIERREZ', '6153904', NULL, '6153904', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2037', 'SILVANA SANCHEZ', '4414510019', NULL, '4414510019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2038', 'COMVERSA', '292738028', NULL, '292738028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2039', 'memed', '4522121012', NULL, '4522121012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2040', 'Gonzalo ver Ramos Bermudez', '4061930013', NULL, '4061930013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2041', 'Loza', '4278205', NULL, '4278205', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2042', 'Carlos Alanez', '3006870', NULL, '3006870', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2043', 'ROGELIO RODAS', '5679575015', NULL, '5679575015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2044', 'CLINICA ANGEL FOIANINI S.R.L.', '1028455022', NULL, '1028455022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2045', 'Janneth Nina', '4260258', NULL, '4260258', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2046', 'Transp Nal e Internal GUAJIRO ', '286584020', NULL, '286584020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2047', 'Hugo David Callata Colque', '8993490019', NULL, '8993490019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2048', 'Constructora Vastok Ltda', '1025223023', NULL, '1025223023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2049', 'flores', '4785022', NULL, '4785022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2050', 'MIGUEL ROJAS', '1486705', NULL, '1486705', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2051', 'Jos Miguel Ugarte Vega', '6764473017', NULL, '6764473017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2052', 'Carlos Aguilera', '3830223', NULL, '3830223', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2053', 'Carlos Guna', '3190535', NULL, '3190535', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2054', 'Garfias', '2329277', NULL, '2329277', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2055', 'Constructora Costa Este S.R.L.', '151696028', NULL, '151696028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2056', 'PALMA VERDE S.A.', '170132022', NULL, '170132022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2057', 'AGROLEAD SRL', '195554021', NULL, '195554021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2058', 'IPSE S.R.L.', '195390026', NULL, '195390026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2059', 'EVA ROMERO SAAVEDRA', '2733715011', NULL, '2733715011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2060', 'EVA ROMERO SAAVEDRA', '2733714011', NULL, '2733714011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2061', 'IMAA', '6879348016', NULL, '6879348016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2062', 'Mendoza', '6954693', NULL, '6954693', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2063', 'Humberto De la quintana', '3826511', NULL, '3826511', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2064', 'Ronald Hurtado Orias ', '1988028014', NULL, '1988028014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2065', 'Legal Advices SRL', '215510024', NULL, '215510024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2066', 'SANTOS FERNANDEZ', '6206740', NULL, '6206740', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2067', 'Orlando Antelo Antelo ', '1522979015', NULL, '1522979015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2068', 'Torrez', '2367684', NULL, '2367684', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2069', 'Diego Aguilera camacho', '5895353016', NULL, '5895353016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2070', 'Ana Mara Garca de Cespedes ', '3135907014', NULL, '3135907014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2071', 'EMPRESA CONSTRUCTORA OCIR SRL', '1023595024', NULL, '1023595024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2072', 'KAREN CALLAU PINCKERT ', '8157544', NULL, '8157544', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2073', 'La Casa de Filtros y Mangueras', '299892023', NULL, '299892023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2074', 'ARAMAYO', '4296614', NULL, '4296614', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2075', 'BDP Sociedad de Titularizacin', '120791021', NULL, '120791021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2076', 'Katia Gil', '3890113', NULL, '3890113', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2077', 'MURURE SRL', '292894020', NULL, '292894020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2078', 'ARZE ', '3811532', NULL, '3811532', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2079', 'Miguel A. Kaneki F. ', '5617734', NULL, '5617734', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2080', 'Castro ', '7706285', NULL, '7706285', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2081', 'Guido Diaz Saavedra', '993163011', NULL, '993163011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2082', 'Laredo', '6993398', NULL, '6993398', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2083', 'francisco arriaga', '11250257', NULL, '11250257', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2084', 'Horacio Vaca Tejerina', '5012898012', NULL, '5012898012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2085', 'ELMA CAMACHO DE QUIROZ', '2964242013', NULL, '2964242013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2086', 'Boris escalera herrera', '8814668014', NULL, '8814668014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2087', 'JUAN ALMENDRAS', '7791461013', NULL, '7791461013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2088', 'ASUAPA BATANZOS', '367357021', NULL, '367357021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2089', 'ROLANDO ARAMAYO', '3127948', NULL, '3127948', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2090', 'Jhanneth Milenca Condori', '7423881', NULL, '7423881', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2091', 'VICTOR HUGO MARTINEZ TAPIA', '4151479014', NULL, '4151479014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2092', 'Roberto Flores Ali', '6736853', NULL, '6736853', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2093', 'gregorio carazani', '5697465', NULL, '5697465', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2094', 'MVO CONSTRUCCIONES &amp; SERVI', '318922028', NULL, '318922028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2095', 'ROMULO FLORES ARAUZ', '2807165012', NULL, '2807165012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2096', 'SEAPA - TARATA', '1009213029', NULL, '1009213029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2097', 'quality max srl', '336696024', NULL, '336696024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2098', 'GERMAN FERNANDEZ', '463212', NULL, '463212', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2099', 'COTRAINCUS  S.R.L.', '299218027', NULL, '299218027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2100', 'Lilian Ins Moscoso Carrasco', '6082914', NULL, '6082914', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2101', 'LOGICE SRL.', '327244025', NULL, '327244025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2102', 'TRAILOG SRL', '268020020', NULL, '268020020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2103', 'Lizett Avendao Poquechoque', '7772767', NULL, '7772767', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2104', 'GABRIELA MENDEZ BURGOS', '4706255', NULL, '4706255', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2105', 'AXISCONST S.R.L.', '174136025', NULL, '174136025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2106', 'Alexander Acosta Salvatierra', '5395188', NULL, '5395188', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2107', 'CHOQUETICLLA', '3521927', NULL, '3521927', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2108', 'CONDORI', '4837030017', NULL, '4837030017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2109', 'Construcciones Jamov Ltda', '338560023', NULL, '338560023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2110', 'CONCENTRA ASISTENCIA S.A.', '304730023', NULL, '304730023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2111', 'SANTA JOSEFINA AGROPECUARIA S.', '162402027', NULL, '162402027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2112', 'ESLY ARAMAYO ORIHUELA', '4151991010', NULL, '4151991010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2113', 'Marco Soria Galvarro', '6500023013', NULL, '6500023013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2114', 'Carla Panozo', '1119936', NULL, '1119936', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2115', 'GUILLERMINA BERNAL ', '5064053018', NULL, '5064053018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2116', 'Filomena Fernandez Tejerina ', '5812799017', NULL, '5812799017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2117', 'Gioconda Kilibarda Cassab', '3883055016', NULL, '3883055016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2118', 'Rodrigo Yance Pelez', '5243885019', NULL, '5243885019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2119', 'eduardo calderon', '1281480013', NULL, '1281480013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2120', 'Javier Gonzalez', '2835536', NULL, '2835536', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2121', 'Claudia Carvallo', '5398361', NULL, '5398361', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2122', 'Tecna Bolivia S.A.', '1028581024', NULL, '1028581024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2123', 'CLAUDIA VIANKA ARTEAGA AGUILAR', '5746286', NULL, '5746286', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2124', 'Enrique Antonio Maldonado Alfa', '3420815019', NULL, '3420815019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2125', 'ANALISIS CLINICO TITICACA S.R.', '320790020', NULL, '320790020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2126', 'Productos lacteos capital srl', '332100021', NULL, '332100021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2127', 'INBOLPACK S.R.L.', '1015461020', NULL, '1015461020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2128', 'MTF ASESORIA LEGAL', '330172021', NULL, '330172021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2129', 'CLAUDIA CAHUANA', '4507626017', NULL, '4507626017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2130', 'Juan Alberto Martinez B', '3210951014', NULL, '3210951014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2131', 'ACCL S.A.', '121597027', NULL, '121597027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2132', 'Ana Mara Ribera de Martnez', '3896030016', NULL, '3896030016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2133', 'Semear Group Srl', '308414024', NULL, '308414024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2134', 'CTC SRL ', '1001685020', NULL, '1001685020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2135', 'Mauricio Soliz Torrico', '5405133016', NULL, '5405133016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2136', 'Mathiesen sa', '1028611021', NULL, '1028611021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2137', 'Erika fune', '3742591', NULL, '3742591', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2138', 'Rioyata Madera Import. Export.', '161150022', NULL, '161150022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2139', 'Luis Fernando Marquez', '1054669014', NULL, '1054669014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2140', 'ELIO VEIZAGA CABRERA', '8852865', NULL, '8852865', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2141', 'CECBB S.A.', '1020145025', NULL, '1020145025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2142', 'INDUSTRIAS BELEN S.R.L.', '1015355021', NULL, '1015355021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2143', 'camilo', '14273911', NULL, '14273911', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2144', 'EQUIPETROL SA', '1015407022', NULL, '1015407022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2145', 'COMITE NACIONAL DE DESPACHO DE', '1023203020', NULL, '1023203020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2146', 'EXPRESS GLOBAL BOLIVIA S.R.L.', '1006247027', NULL, '1006247027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2147', 'SERVIAGRICOLA DEL SUR', '364047020', NULL, '364047020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2148', 'Zarate', '11093540019', NULL, '11093540019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2149', 'Edem Caceres', '3116746', NULL, '3116746', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2150', 'TOYOSA SA', '1030029024', NULL, '1030029024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2151', 'CONSTRUCTORA CANISIANA SRL', '265522024', NULL, '265522024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2152', 'EVER CHOQUE SALGADO', '7914153', NULL, '7914153', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2153', 'INGENIO SUCROALCOHOLERO AGUAI ', '147840023', NULL, '147840023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2154', 'Tmf Bolivia srl', '144414026', NULL, '144414026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2155', 'SOFIA CRUZ ESPINOZA', '5558589018', NULL, '5558589018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2156', 'Oscar Flores', '4386099017', NULL, '4386099017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2157', 'ALMA TURISMO S.R.L.', '265726024', NULL, '265726024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2158', 'DANIELA ANEYBA', '4582219017', NULL, '4582219017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2159', 'LYMS SRL ', '353257021', NULL, '353257021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2160', 'Antonio Melena Oliver', '2984594017', NULL, '2984594017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2161', 'Alba', '5308996', NULL, '5308996', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2162', 'BANCO PYME DE LA COMUNIDAD S.A', '1023303022', NULL, '1023303022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2163', 'Ruben Dario Osinaga', '3881177', NULL, '3881177', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2164', 'EMPRESA CONSTRUCTORA ECOZEM S.', '125135024', NULL, '125135024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2165', 'MACCAFERRI DE BOLIVIA LTDA', '1001741026', NULL, '1001741026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2166', 'BLANCO', '6817549', NULL, '6817549', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2167', 'SIE SA', '1007327027', NULL, '1007327027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2168', 'Fernndez', '6845608019', NULL, '6845608019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2169', 'Angelica Laura', '3733773', NULL, '3733773', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2170', 'shirley rodriguez saavedra', '4913208018', NULL, '4913208018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2171', 'candido almazan cruz', '5056311014', NULL, '5056311014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2172', 'Seneide Freitas Fernandez', '4187328', NULL, '4187328', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2173', 'rosales juan ', '3814125014', NULL, '3814125014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2174', 'VASLEC INTERNACIONAL SRL', '1030361028', NULL, '1030361028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2175', 'PAULA YUCRA LUIZAGA', '3740670', NULL, '3740670', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2176', 'SOUTIEN S.R.L. ', '305896029', NULL, '305896029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2177', 'APAZA', '7018122018', NULL, '7018122018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2178', 'JAIME RAMIREZ', '5404001', NULL, '5404001', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2179', 'GUTIERREZ', '2611093011', NULL, '2611093011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2180', 'Jorge Toyama', '2962055', NULL, '2962055', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2181', 'Gonzales', '816970011', NULL, '816970011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2182', 'Guillen', '5979406', NULL, '5979406', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2183', 'DURAN CORONEL ', '3481294014', NULL, '3481294014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2184', 'Jacksson Carlos Negrete Ipabar', '7587236', NULL, '7587236', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2185', 'Toogonet S.R.L. ', '341248027', NULL, '341248027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2186', 'LEGAL ACCOUNTING SERVICES SRL', '263730024', NULL, '263730024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2187', 'ME GUSTA S.R.L. ', '206738025', NULL, '206738025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2188', 'CONAC SRL', '1030023020', NULL, '1030023020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2189', 'SALAZAR ', '2453234', NULL, '2453234', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2190', 'Arsenio Marquez Polanco ', '1143639015', NULL, '1143639015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2191', 'Ana Mara Mendoza', '2975081010', NULL, '2975081010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2192', 'CONFE SEL', '138495020', NULL, '138495020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2193', 'CALVO ', '3454507016', NULL, '3454507016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2194', 'FREDDY DAVID QUISPE LOPEZ', '2529749015', NULL, '2529749015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2195', 'PROYECTOS INMOBILIARIOS EL DOR', '293514021', NULL, '293514021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2196', 'FLORES ', '3091055015', NULL, '3091055015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2197', 'Francy Bravo S ', '4643409', NULL, '4643409', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2198', 'Nelly Castro', '6301589', NULL, '6301589', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2199', 'NADIA EVELIN SANABRIA VEIZAGA ', '3529803019', NULL, '3529803019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2200', 'grapho srl', '191690027', NULL, '191690027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2201', 'SOLACTIVITY INTERNATIONAL SRL', '189170020', NULL, '189170020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2202', 'Marcela Vargas ', '2822500', NULL, '2822500', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2203', 'CLAUDIA CORO PUMA', '9704031012', NULL, '9704031012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2204', 'Rolando Romero Ferrufino', '5491998019', NULL, '5491998019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2205', 'COBAL SRL ', '185386025', NULL, '185386025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2206', 'OFEP', '332738025', NULL, '332738025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2207', 'Felix Cari Quispe', '4265269017', NULL, '4265269017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2208', 'DARLENE VEINTEMILLAS', '2616358012', NULL, '2616358012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2209', 'Loayza', '4986798012', NULL, '4986798012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2210', 'JUAN JAIME VILACAHUA TOLA', '6611766', NULL, '6611766', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2211', 'Flores', '9186449', NULL, '9186449', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2212', 'Clodo Rodriguez Mendoza', '2949458016', NULL, '2949458016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2213', 'NANCY BLANCO', '4786685', NULL, '4786685', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2214', 'Daniela Muoz Rocha', '6240309012', NULL, '6240309012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2215', 'Carmen Roco Gonzles Rodrigue', '5840742010', NULL, '5840742010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2216', 'MARA TERESA MANCILLA LLANOS', '4630337', NULL, '4630337', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2217', 'Robert Surco Zegarra', '4770324018', NULL, '4770324018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2218', 'GUTIERREZ', '5799585010', NULL, '5799585010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2219', 'GRUPO NOVELTY LTDA.', '333346024', NULL, '333346024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2220', 'CHUQUIMIA', '2170335', NULL, '2170335', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2221', 'Legalyse S.R.L.', '336312025', NULL, '336312025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2222', 'JESUS MEDARDO FRIAS GRAGEDA', '3801419010', NULL, '3801419010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2223', 'Essing srl', '190550025', NULL, '190550025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2224', 'Jose Antonio vara', '1075346', NULL, '1075346', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2225', 'CARLOS LIA HUARACHI', '5990806012', NULL, '5990806012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2226', 'Machaca, Jauregui Asociados SR', '171864021', NULL, '171864021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2227', 'CHRISTHIAM ALVAREZ', '4809490', NULL, '4809490', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2228', 'Erlin Pedraza Moreno', '3195037', NULL, '3195037', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2229', 'Cecilia Alejandra Leyton', '5130834013', NULL, '5130834013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2230', 'JUAN CARLOS GUZMAN', '5053365016', NULL, '5053365016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2231', 'Orellana', '3378205017', NULL, '3378205017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2232', 'IPHAE', '126479020', NULL, '126479020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2233', 'KARINA GIOVANNA ROJAS CARDENAS', '1891715', NULL, '1891715', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2234', 'Efrain Lpez', '3001854018', NULL, '3001854018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2235', 'Lujan', '6085483013', NULL, '6085483013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2236', 'Acha Daniel', '3374108017', NULL, '3374108017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2237', 'Support Manage Gold SRL', '305664024', NULL, '305664024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2238', 'PAOLA MORALES LAURA', '8144251', NULL, '8144251', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2239', 'PECAPOR IMPORT EXPORT S.R.L.', '350663024', NULL, '350663024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2240', 'ELY RAMIREZ FELIX', '9314713', NULL, '9314713', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2241', 'Ticona', '3347028', NULL, '3347028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2242', 'VALDIVIA', '672773016', NULL, '672773016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2243', 'salvatierra', '5091319019', NULL, '5091319019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2244', 'abel reyes zeballos ', '4080001019', NULL, '4080001019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2245', 'Maya Monje', '1368884010', NULL, '1368884010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2246', 'Global Bolivia SRL', '1016891025', NULL, '1016891025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2247', 'ANGELA TIRADO', '5672960', NULL, '5672960', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2248', 'YONY SALDAA ROMAN', '6261014019', NULL, '6261014019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2249', 'sanchez', '4756037', NULL, '4756037', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2250', 'Juan pacheco ', '6085860', NULL, '6085860', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2251', 'YAQUELINE ROCHA MENACHO', '4650515', NULL, '4650515', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2252', 'Chacon ', '5280408012', NULL, '5280408012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2253', 'GILBERTO CASTILLO ORTIZ ', '3278088011', NULL, '3278088011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2254', 'yomar gironda', '6881504', NULL, '6881504', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2255', 'Jaime Delgado', '4002065017', NULL, '4002065017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2256', 'Edson Ticona ', '10017218', NULL, '10017218', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2257', 'Carlos Flores', '4915258010', NULL, '4915258010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2258', 'Titanium SRL', '128463026', NULL, '128463026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2259', 'PFS BOLIVIA SA', '139581026', NULL, '139581026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2260', 'Gabriel Mrquez', '1795528016', NULL, '1795528016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2261', 'Agropernavi srl', '337032027', NULL, '337032027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2262', 'Daina cuellar serrate', '3825173014', NULL, '3825173014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2263', 'Juan Silva Chvez', '3367099', NULL, '3367099', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2264', 'Mayko Jhonael Romaa Galindo', '1762647013', NULL, '1762647013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2265', 'Judith Barreta Vargas', '4571216018', NULL, '4571216018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2266', 'GANDARILLAS', '4887529', NULL, '4887529', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2267', 'FREUDENTHAL', '476654', NULL, '476654', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2268', 'JULIA TIINI QUISPE', '4308559016', NULL, '4308559016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2269', 'Jaime Condori', '47152634015', NULL, '47152634015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2270', 'MARIA CRISTINA CLAROS CASTRO', '4625843', NULL, '4625843', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2271', 'MARCO ANTONIO MONTOYA PORTILLO', '6628013', NULL, '6628013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2272', 'NINA LOPEZ', '5500672011', NULL, '5500672011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2273', 'Rodriguez Mlaga Maria', '6447031014', NULL, '6447031014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2274', 'VIVIANA MAMANI CRUZ', '6662599012', NULL, '6662599012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2275', 'Llanque', '2016770', NULL, '2016770', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2276', 'Milton Herrera Laguna', '3162432015', NULL, '3162432015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2277', 'Canedo', '6443207011', NULL, '6443207011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2278', 'ESPINOZA', '3985083015', NULL, '3985083015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2279', 'GIMENA ARIAS', '7108587012', NULL, '7108587012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2280', 'PETRA SICC SRL', '1002361021', NULL, '1002361021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2281', 'Edwin Villaflor', '1105563', NULL, '1105563', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2282', 'VICTOR HUGO MIRANDA', '2018510015', NULL, '2018510015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2283', 'Eugenio Ruiz', '5117454', NULL, '5117454', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2284', 'Macarena E. Callisaya Apo  ', '6941424', NULL, '6941424', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2285', 'Ivonne Morales de Moreno', '813924012', NULL, '813924012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2286', 'EFRAIN TIINI TIINI ', '5943836017', NULL, '5943836017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2287', 'MURANO SRL', '136859026', NULL, '136859026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2288', 'sussy sarage', '1400134', NULL, '1400134', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2289', 'MARIELA BAUTISTA ', '8038318019', NULL, '8038318019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2290', 'acebey', '3675743', NULL, '3675743', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2291', 'KPMG S.R.L.', '1006979026', NULL, '1006979026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2292', 'Nilvia caceres mendieta', '7573319', NULL, '7573319', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2293', 'Irahola', '4500895', NULL, '4500895', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2294', 'Dory Nancy Franco', '1687372016', NULL, '1687372016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2295', 'Maria Eliana Suarez', '3316344', NULL, '3316344', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2296', 'SERDAGEN S.R.L.', '198670028', NULL, '198670028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2297', 'Oscar Leonardo Salgueiro Landi', '1878252015', NULL, '1878252015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2298', 'ARDAYA ', '4453252', NULL, '4453252', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2299', 'Monica soriano', '484959', NULL, '484959', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2300', 'ABROS TECHNOLOGIES SRL', '160462020', NULL, '160462020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2301', 'emizor s.r.l.', '311710026', NULL, '311710026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2302', 'ICOM SRL', '152826022', NULL, '152826022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2303', 'Morales', '3428572', NULL, '3428572', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2304', 'DANIEL VACA MORON', '6201859015', NULL, '6201859015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2305', 'HAEL LOURDES MAMANI CRUZ', '8565260016', NULL, '8565260016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2306', 'Valdez Lpez SRL', '172242024', NULL, '172242024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2307', 'Celin Rosendo Ruiz Martinez', '8068050', NULL, '8068050', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2308', 'FABIO PEREIRA SUAREZ', '5632129010', NULL, '5632129010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2309', 'Nain Caballero', '6221416', NULL, '6221416', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2310', 'OBLITAS', '4310749011', NULL, '4310749011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2311', 'Luis Alberto Flores ', '5404102010', NULL, '5404102010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2312', 'TERMINEX MULTISERVICIOS S.R.L.', '170190028', NULL, '170190028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2313', 'Nelcy judith pea callejas ', '5331217015', NULL, '5331217015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2314', 'Jos David Daza Vaca', '8936174016', NULL, '8936174016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2315', 'IMPALA TERMINALS BOLIVIA SERVI', '180046026', NULL, '180046026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2316', 'ASOSUR', '1013987029', NULL, '1013987029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2317', 'luis nelson rios terceros', '3214368013', NULL, '3214368013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2318', 'industria forestal colser ltda', '121557025', NULL, '121557025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2319', 'paulo edrey franco ', '5604932', NULL, '5604932', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2320', 'PROYECTO INMOBILIARIO ROSAL S.', '302966025', NULL, '302966025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2321', 'Widabol SRL', '1008003024', NULL, '1008003024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2322', 'INDUMETAL BOLIVIA S.A.', '1026503029', NULL, '1026503029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2323', 'ENTEL FINANCIERA ESPM S.R.L.', '328300029', NULL, '328300029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2324', 'Servicios de Ingeniera Multid', '1008349020', NULL, '1008349020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2325', 'Ximena Dorado Durn', '7754650018', NULL, '7754650018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2326', 'Consulting Engineers Salzgitte', '1006319028', NULL, '1006319028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2327', 'CONDE', '4792339', NULL, '4792339', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2328', 'ALVARO PINAYA ', '3590158', NULL, '3590158', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2329', 'Sequeiros', '1405191019', NULL, '1405191019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2330', 'ENTRE MANOS SRL', '344024026', NULL, '344024026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2331', 'Nina Carla', '5959456013', NULL, '5959456013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2332', 'JAVIER CHURA CONDORI', '3367949', NULL, '3367949', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2333', 'IT INNOVATIONS LTDA', '175074028', NULL, '175074028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2334', 'Jorge Choquehuanca Tarqui', '4017375013', NULL, '4017375013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2335', 'Yaneth Ribera Zurita', '5357474', NULL, '5357474', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2336', 'Alexander Vargas Soliz', '2492649014', NULL, '2492649014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2337', 'SICAC SRL', '168352026', NULL, '168352026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2338', 'denard mendez', '3886222014', NULL, '3886222014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2339', 'paola moza aldana', '5887027', NULL, '5887027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2340', 'JUAN MARINO GUERRERO LOPEZ', '7725262015', NULL, '7725262015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2341', 'CLAUDIA VILLEGAS', '4468538017', NULL, '4468538017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2342', 'Jose esteban Mariscal', '5034234014', NULL, '5034234014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2343', 'Vacaflor', '3875197019', NULL, '3875197019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2344', 'CIRO VARGAS ', '1260347', NULL, '1260347', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2345', 'lizarazu', '3113218011', NULL, '3113218011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2346', 'empresa de desarrollos inmobil', '256482028', NULL, '256482028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2347', 'industria textil tsm sa.', '157722020', NULL, '157722020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2348', 'Juan Carlos Enriquez Chambi', '5496331015', NULL, '5496331015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2349', 'Gutemberg Nuez', '298015019', NULL, '298015019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2350', 'NELFY MENDOZA', '10705561', NULL, '10705561', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2351', 'TRUJILLO', '6801361', NULL, '6801361', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2352', 'Eber vicente zabilla', '8913767015', NULL, '8913767015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2353', 'Clover Miguel Romn Vargas', '5009834', NULL, '5009834', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2354', 'Sindicato mixto de transportis', '126225029', NULL, '126225029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2355', 'EVA CELINA COLQUE AVENDAO', '1149795014', NULL, '1149795014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2356', 'Deportodep srl', '291376022', NULL, '291376022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2357', 'VERONICA COSTAS BUTRON', '4611887014', NULL, '4611887014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2358', '5637801017', '5637801017', NULL, '5637801017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2359', 'DAYSI MIRANDA', '7468235017', NULL, '7468235017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2360', 'BT Y ASOCIADOS SRL', '346966025', NULL, '346966025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2361', 'MSS SRL ', '227502020', NULL, '227502020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2362', 'FULL ASSISTANCE S.R.L.', '195964020', NULL, '195964020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2363', 'Luis Iporre ', '5193980011', NULL, '5193980011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2364', 'Rodrigo', '5422898', NULL, '5422898', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2365', ' prado', '3164334016', NULL, '3164334016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2366', 'Vasquez', '3420159013', NULL, '3420159013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2367', 'ANNANCE BOLIVIA SRL', '175336026', NULL, '175336026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2368', 'papandinagroup srl', '358253022', NULL, '358253022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2369', 'Montao', '5013750', NULL, '5013750', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2370', 'ESTEVAN PABLO SUAREZ CASTRO', '3825453', NULL, '3825453', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2371', 'emigdio ordoez huanca', '5014011', NULL, '5014011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2372', 'ESSEDUE VENEERS IMPORT EXPORT ', '173256029', NULL, '173256029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2373', 'Gutierrez', '4404105', NULL, '4404105', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2374', 'CERAMICA BOLITAL SRL', '125805025', NULL, '125805025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2375', 'ALVARO JOSE', '8684988', NULL, '8684988', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2376', 'Jeanine Arimoza Encinas', '6266589011', NULL, '6266589011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2377', 'FORTALEZA SAFI', '1006933020', NULL, '1006933020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2378', 'LOURDES VIRGINIA AVENDAO ORTE', '4594901019', NULL, '4594901019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2379', 'PLAN INTERNATIONAL INC.', '127885029', NULL, '127885029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2380', 'ERIK ACUA', '4312048', NULL, '4312048', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2381', 'Jorge Antonio Robles Salas', '5324977014', NULL, '5324977014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2382', 'gabriel camacho ', '4568838', NULL, '4568838', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2383', 'Marcelo Villarroel', '3268410', NULL, '3268410', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2384', 'Fernando Silva', '2608006011', NULL, '2608006011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2385', 'Renucomex SRL', '158420027', NULL, '158420027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2386', 'Gomez', '3377406', NULL, '3377406', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2387', 'Jorge Burgos', '4607410', NULL, '4607410', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2388', 'ISHIMA S.R.L.', '1013719029', NULL, '1013719029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2389', 'Yangali sanjinez yubanera', '7581284', NULL, '7581284', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2390', 'VELASCO ', '3587422016', NULL, '3587422016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2391', 'Luis Suarez ', '6336293011', NULL, '6336293011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2392', 'Virreira ', '2310513017', NULL, '2310513017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2393', 'Lorena Valdivia ', '4576560', NULL, '4576560', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2394', 'Sinohydro corporativo limited ', '269830023', NULL, '269830023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2395', 'IC NORTE S. A. ', '1009445021', NULL, '1009445021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2396', 'Salazar ', '3496608', NULL, '3496608', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2397', 'neisa espindola', '9661625019', NULL, '9661625019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2398', 'EMPRESA HOTELERA LA QUINTA LTD', '1015529024', NULL, '1015529024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2399', 'Maria Luisa Barrios Bejarano ', '5389225', NULL, '5389225', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2400', ' Lara  ', '3418881', NULL, '3418881', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2401', 'Maria Eugenia Camacho Effen ', '2738003018', NULL, '2738003018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2402', 'Omar Suarez Roca ', '7601716010', NULL, '7601716010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2403', 'COMTECO R. L.', '1009379021', NULL, '1009379021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2404', 'Dayana Flores', '3628497010', NULL, '3628497010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2405', 'Gualberto Eugenio', '3063827', NULL, '3063827', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2406', 'Marina Lascano', '5012564', NULL, '5012564', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2407', 'Silvia Corina Quispe Espinoza', '9104323', NULL, '9104323', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2408', 'Yucra', '2699584014', NULL, '2699584014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2409', 'EMPRESA MINERA ROFEL S.R.L ', '312100029', NULL, '312100029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2410', 'macro fidalga ltda. ', '1028241027', NULL, '1028241027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2411', 'Claudia Rivero', '3903261', NULL, '3903261', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2412', 'VALENTIN CIDAR MEDINACELLI CHA', '3590073018', NULL, '3590073018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2413', 'CIBRESA ', '300462025', NULL, '300462025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2414', 'Rodrigo Maidana Ura ', '6199221016', NULL, '6199221016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2415', 'FOX CARGO INVERSIONES LTDA', '180408029', NULL, '180408029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2416', 'EL MARUCHO LTDA.', '138603028', NULL, '138603028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2417', 'FLORES', '3074911019', NULL, '3074911019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2418', 'Ticona ', '4942841014', NULL, '4942841014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2419', 'Quispe ', '9868928', NULL, '9868928', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2420', 'Guiller Marleni Donaire Marque', '5033953', NULL, '5033953', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2421', 'vaca diez ', '140617020', NULL, '140617020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2422', ' Pedro Alejandro Garrido', '5344918017', NULL, '5344918017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2423', 'imprenta ingavi ', '295426019', NULL, '295426019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2424', 'BOLINTER LTDA.', '1028617020', NULL, '1028617020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2425', 'Conseso Ltda.', '1020957022', NULL, '1020957022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2426', 'Sinopec international petroleu', '175184029', NULL, '175184029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2427', 'PINTO', '3594405', NULL, '3594405', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2428', 'Luis Jimenez Barja ', '3789715016', NULL, '3789715016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2429', 'Carlos Vega Chubiru', '5421151019', NULL, '5421151019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2430', 'MARGARITA PADILLA ', '7144786', NULL, '7144786', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2431', 'INPADE', '127187024', NULL, '127187024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2432', 'Ceologistics Bolivia SRL ', '371086024', NULL, '371086024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2433', 'PROSEVIG S.R.L. ', '344948022', NULL, '344948022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2434', 'COOPERATIVA PROGRESO R.L.', '1026375020', NULL, '1026375020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2435', 'LAFAR S.A.', '1006889026', NULL, '1006889026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2436', 'IVELYCE MAYSA CAMACHO ROMAY', '2925090', NULL, '2925090', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2437', 'Rosario Corrales Cortez', '1954521', NULL, '1954521', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2438', 'Carlos Freddy Espada', '8122357', NULL, '8122357', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2439', 'Milenka Ferrufino', '3373918', NULL, '3373918', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2440', 'Vildoso', '3774310018', NULL, '3774310018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2441', 'Consulado General del Peru ', '3072015', NULL, '3072015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2442', 'IASD ', '1008801020', NULL, '1008801020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2443', 'Automercados S.R.L', '306612023', NULL, '306612023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2444', 'jose rafael burela rios ', '7722854010', NULL, '7722854010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2445', 'G.A.M. CHALLAPATA ', '127587028', NULL, '127587028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2446', 'Flores ', '6932394', NULL, '6932394', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2447', 'Noel Gonzales Ayala', '3536100', NULL, '3536100', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2448', 'unitepc ', '1009199021', NULL, '1009199021', NULL, NULL, NULL, NULL, NULL, '', '0');
INSERT INTO `0_crm_persons` VALUES
('2449', 'Antonio Vargas', '2832010', NULL, '2832010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2450', 'Readers Pablo Cordova Condori', '5473874', NULL, '5473874', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2451', 'Empresa Minera Inti Raymi S.A.', '1020499025', NULL, '1020499025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2452', 'Cervecera Nacional Potos Ltd', '1011193029', NULL, '1011193029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2453', 'EMPRESA AGROPECUARIA NOVAGRO S', '134701028', NULL, '134701028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2454', 'Inversores Asociados S.A.', '133065020', NULL, '133065020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2455', 'Akrofin Construcciones S.R.L.', '285386029', NULL, '285386029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2456', 'GRUPO CONTABLE AYRA SRL', '338724027', NULL, '338724027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2457', 'QUIMICAS ALIADAS SRL', '126505029', NULL, '126505029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2458', 'EPCM CONSULTORES SRL', '157462020', NULL, '157462020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2459', 'Mario Cortez Limachi', '2449807018', NULL, '2449807018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2460', 'Venancio Canizares Ferreira', '3180770019', NULL, '3180770019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2461', 'Maria Susanna Aguilar', '3147882', NULL, '3147882', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2462', 'evelin rivero perez', '1707258012', NULL, '1707258012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2463', 'Silverio Torrez', '2151537', NULL, '2151537', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2464', 'MAMANI CRUZ', '4031887014', NULL, '4031887014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2465', 'VITRO-CRV IMPORTACIONES S.R.L.', '207774025', NULL, '207774025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2466', 'Gather Network en Bolivia ', '135629027', NULL, '135629027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2467', 'Maribel Salazar Ochoa', '6365607012', NULL, '6365607012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2468', 'Daniel Oscar Flores Vargas', '6652143018', NULL, '6652143018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2469', 'Vacaflor', '3545512', NULL, '3545512', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2470', 'Windsor Sanmillan Flores', '4812239', NULL, '4812239', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2471', 'Richard Efrain Parrado Fossati', '370644', NULL, '370644', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2472', 'AGROSEM S.A.', '1015205057', NULL, '1015205057', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2473', 'GERIMEX SRL', '1028741026', NULL, '1028741026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2474', 'FUNDACIN VOCES LIBRES ', '1010967029', NULL, '1010967029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2475', 'Finangroup srl', '211762025', NULL, '211762025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2476', 'CRISTOBAL ', '10315159', NULL, '10315159', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2477', 'Wilson Ramos', '4668831', NULL, '4668831', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2478', 'Sociedad comercial la llave S.', '160890029', NULL, '160890029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2479', 'AGROSEM S.A.', '1015205027', NULL, '1015205027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2480', 'Gamboa', '8323737', NULL, '8323737', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2481', 'OSCAR GONZALES LOAYZA', '1951510019', NULL, '1951510019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2482', 'FORLIFE RESEARCH S.R.L.', '162526028', NULL, '162526028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2483', 'Distribucion y Mercadeo DYM Lt', '1028403021', NULL, '1028403021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2484', 'DANNER RODRIGUEZ ', '3932762', NULL, '3932762', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2485', 'AIR BP BOLIVIA S.A.', '1015497027', NULL, '1015497027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2486', 'litzy vargas ', '61212965', NULL, '61212965', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2487', 'RICHARD TORRICO VELASQUEZ', '4566424010', NULL, '4566424010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2488', 'juan carlos tapia benavidez', '4120660011', NULL, '4120660011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2489', 'VALERIO FANOLA MALDONADO', '783115014', NULL, '783115014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2490', 'Mary hinojosa mendez ', '1915924', NULL, '1915924', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2491', 'FRANCK', '2301680019', NULL, '2301680019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2492', 'Carlos Montao', '5339095', NULL, '5339095', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2493', 'Fernandez ', '4562303', NULL, '4562303', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2494', 'Roberto Caceres', '4804015019', NULL, 'Calle pririta n 15', '77221158', NULL, NULL, 'info@boliviaimpuestos.com', NULL, '', '0'),
('2495', 'Juan carlos carbajal', '8254139016', NULL, '8254139016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2496', 'Menacho', '4593478', NULL, '4593478', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2497', 'Edgar Quiroga Montao', '7785681012', NULL, '7785681012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2498', 'Grecia Blanco', '6170445017', NULL, '6170445017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2499', 'Empresa Constructora Sur Pared', '169004024', NULL, '169004024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2500', 'Martha Montano', '3842834', NULL, '3842834', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2501', 'Elias Polo Cruz', '5393421019', NULL, '5393421019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2502', 'Intelligent Networking S.R.L.', '1026631028', NULL, '1026631028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2503', 'Brenntag Bolivia SRL', '1015179028', NULL, '1015179028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2504', 'Garcia', '3342041', NULL, '3342041', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2505', 'Dey Cabero', '2724258', NULL, '2724258', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2506', 'MUROPANTALLA S.A.', '209610028', NULL, '209610028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2507', 'SEIMEX Ltda.', '125031029', NULL, '125031029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2508', 'Ana Requintas', '7268686', NULL, '7268686', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2509', 'Vargas', '7031199019', NULL, '7031199019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2510', 'Ricardo Lazcano', '6207405', NULL, '6207405', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2511', 'Luis Fernando Quiroga Ramrez', '3138197', NULL, '3138197', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2512', 'Javier Suaznabar Angles', '3575398', NULL, '3575398', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2513', 'CARLOS ANDRES ARGANDOA CMACHO', '4695584011', NULL, '4695584011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2514', 'Franz Cruz', '664154012', NULL, '664154012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2515', 'Zenteno &amp; Asociados Consul', '232320026', NULL, '232320026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2516', 'INDUSTRIA PLASTIC Z S.R.L.', '365262023', NULL, '365262023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2517', 'colaser S.R.L.', '225322022', NULL, '225322022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2518', 'Minerales del Sur S.R.L.', '150318025', NULL, '150318025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2519', 'Fontanero srl', '192410022', NULL, '192410022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2520', 'belzun chavez', '4191486', NULL, '4191486', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2521', 'Roxana Challapa Aguilar', '4508541', NULL, '4508541', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2522', 'Luis Gerardo Suarez', '6336293', NULL, '6336293', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2523', 'Riverijos Ltda.', '1020103027', NULL, '1020103027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2524', 'Gabriela Ramrez Borda ', '9818982013', NULL, '9818982013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2525', ' jesus eguez ayala', '3175193', NULL, '3175193', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2526', 'Zhejiang Provincial N 1', '290058028', NULL, '290058028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2527', 'MIGUEL ALFREDO ESCALERA', '6397377', NULL, '6397377', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2528', 'BISONTE S.R.L.', '146072029', NULL, '146072029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2529', 'POMA CALLIZAYA CAROLINA ', '8317699012', NULL, '8317699012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2530', 'Jose Luis Castro Molina', '5941888', NULL, '5941888', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2531', 'WALDO SOTO BUTRON', '3007247014', NULL, '3007247014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2532', 'NELLY MELGAR ', '5377125', NULL, '5377125', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2533', 'Jenny H. Zegarra Fuentes', '2769422', NULL, '2769422', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2534', 'SAIV LTDA.', '1024725024', NULL, '1024725024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2535', 'Edgar Rodrigo Meneses Echeniqu', '6262393016', NULL, '6262393016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2536', 'TORREZ', '948766', NULL, '948766', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2537', 'Eduardo Arteaga ', '6269575', NULL, '6269575', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2538', 'carlos flores', '3441267011', NULL, '3441267011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2539', 'wilfredo colque ', '5511578', NULL, '5511578', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2540', 'Virginia Barrientos', '139111025', NULL, '139111025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2541', 'ARCENIO JAVIER HUAYTA ALI', '3994224010', NULL, '3994224010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2542', 'NOVAIDEAS ', '4840278013', NULL, '4840278013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2543', 'JUAN CANAVIRI CH.', '442624018', NULL, '442624018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2544', 'Angela Patricia Molina Rojas ', '2929679016', NULL, '2929679016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2545', 'DELGADO', '6183869015', NULL, '6183869015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2546', 'Club Real Potosi ', '1010989025', NULL, '1010989025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2547', 'TEOFILO RIVAS CANAZA', '9671451', NULL, '9671451', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2548', 'Mara Roxana Velsquez Villca', '5132016', NULL, '5132016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2549', 'BFM S.A.', '1006371020', NULL, '1006371020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2550', 'SERAFIN CARVAJAL SALVADOR', '2835386019', NULL, '2835386019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2551', 'Maria Eugenia Mallco', '7240088', NULL, '7240088', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2552', 'PAREDES ', '6769340011', NULL, '6769340011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2553', 'SERVICIOS DE AEROPUERTOS BOLIV', '1028499029', NULL, '1028499029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2554', 'Miguel Angel Carrillo Ortiz', '6345005 ', NULL, '6345005 ', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2555', 'silvia prado', '3153950', NULL, '3153950', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2556', 'Amrica Veizaga Valverde', '1737992', NULL, '1737992', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2557', 'gabriela cronenbold ', '1739486', NULL, '1739486', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2558', 'Yovanna Fernndez', '3906261', NULL, '3906261', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2559', 'APLICAR S.R.L.', '136695020', NULL, '136695020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2560', 'Lucio Cspedes Ontiveros', '2840157014', NULL, '2840157014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2561', 'pcgsrl', '327510020', NULL, '327510020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2562', 'Nina ', '3355786016', NULL, '3355786016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2563', 'Diaz', '4815182010', NULL, '4815182010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2564', 'CAROMER S. R. L.', '355351023', NULL, '355351023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2565', 'Jackeline Chavez Moreno', '3835471013', NULL, '3835471013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2566', 'Egberto Jara Arias', '3683062', NULL, '3683062', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2567', 'Wilson Rodriguez', '214171019', NULL, '214171019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2568', 'william gallardo rodriguez', '1832245', NULL, '1832245', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2569', 'Villanueva', '10929415', NULL, '10929415', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2570', 'EP-BOLIVIA ', '172762026', NULL, '172762026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2571', 'CORTEZ', '4367991016', NULL, '4367991016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2572', 'HENRY MAMANI BALLIVIAN', '4261083018', NULL, '4261083018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2573', 'AyF SRL', '190772026', NULL, '190772026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2574', 'cinthya ruiz ', '1149490015', NULL, '1149490015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2575', 'COMERCIALIZADORA KENNAMETAL BO', '228794029', NULL, '228794029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2576', 'nelo stanley pedrazas osinaga', '3754115016', NULL, '3754115016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2577', 'COMPAIA EDITORA LUNA LLENA S.', '170606026', NULL, '170606026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2578', 'BIOCOMERCIO S.R.L. ', '311162022', NULL, '311162022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2579', 'Imba SA.', '1023201022', NULL, '1023201022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2580', 'Cooperativa Educacional Santa ', '1028279021', NULL, '1028279021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2581', 'ramiro ', '3656893', NULL, '3656893', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2582', 'QUIMICA INDUSTRIAL J. MONTES B', '121707020', NULL, '121707020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2583', 'MOISES HURTADO CESPEDES', '4295049', NULL, '4295049', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2584', 'AUDITOOL S.R.L.', '356256022', NULL, '356256022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2585', 'JENY JANETH ORCKO VELIZ', '5137134014', NULL, '5137134014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2586', 'MARIA ANGELICA CALLE', '7832712', NULL, '7832712', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2587', 'Mara Luisa Flores', '2601713', NULL, '2601713', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2588', 'Gutierrez Consultores S.R.L.', '173350022', NULL, '173350022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2589', 'RICARDO OROPEZA CRUZ ', '9675446', NULL, '9675446', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2590', 'Miguel jancko ', '1367609016', NULL, '1367609016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2591', 'IPTK', '1000615023', NULL, '1000615023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2592', 'Paz Soldn', '3046234', NULL, '3046234', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2593', 'EMPRESA CONSTRUCTORA URQUIETA ', '1010339027', NULL, '1010339027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2594', 'FADACON S.R.L. ', '159932025', NULL, '159932025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2595', 'SAINT ASOCIADOS S.R.L.', '1007651025', NULL, '1007651025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2596', 'PATRICIA TORREZ RIOS ', '5055281014', NULL, '5055281014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2597', 'DANIEL SILVESTRE GUMUCIO CARRA', '5864946015', NULL, '5864946015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2598', 'GONZALES', '3044707010', NULL, '3044707010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2599', 'TIGRE S.A.', '1020113024', NULL, '1020113024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2600', 'COMSUIN S.R.L.', '3703900024', NULL, '3703900024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2601', 'ZAMBRANA', '4452058', NULL, '4452058', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2602', 'LIGIA ELENA ESPINOZA VILLARROE', '6545048011', NULL, '6545048011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2603', 'Daniel Manuel Colque ', '1296838015', NULL, '1296838015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2604', 'QUISPE', '4950128', NULL, '4950128', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2605', 'miranda', '6756817015', NULL, '6756817015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2606', 'Guerrero', '2299978', NULL, '2299978', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2607', 'grupo naferd s.r.l.', '334424023', NULL, '334424023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2608', 'luis alberto montenegro muoz', '3171259010', NULL, '3171259010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2609', 'julio zeballos ', '1577652013', NULL, '1577652013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2610', 'IMESAPI S.A. SUCURSAL BOLIVIA', '190810023', NULL, '190810023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2611', 'V&amp;G-DISTRIBUTING COMPANY S', '352373024', NULL, '352373024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2612', 'Navla Ltda.', '1005447022', NULL, '1005447022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2613', 'Alexia Velasquez', '8228200', NULL, '8228200', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2614', 'CARMEN LAURA SANCHEZ CRUZ', '9022438011', NULL, '9022438011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2615', 'Martin Serrudo', '1099413', NULL, '1099413', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2616', 'Irupana Andean Organic Food S.', '1020225029', NULL, '1020225029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2617', 'MORALES', '4383237017', NULL, '4383237017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2618', 'Marcelo Jaime Villegas Ajhuach', '3524800019', NULL, '3524800019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2619', 'FRANZ HENRRY QUISPE CASTILLO', '6799771', NULL, '6799771', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2620', 'Fundacin Estrellas en la Call', '140217025', NULL, '140217025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2621', 'ATB SANTA CRUZ S.A.', '1015363022', NULL, '1015363022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2622', 'DISAACORP SRL', '344960023', NULL, '344960023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2623', 'LTE BOLIVIA ', '190026023', NULL, '190026023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2624', 'Maria Luisa A de Salvatierra', '2202255', NULL, '2202255', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2625', 'Ruben Dario Ortiz', '6359601016', NULL, '6359601016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2626', 'IVAN GONZALES', '6762537', NULL, '6762537', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2627', 'ISIS RONCALES SCHOENGUT', '4578341', NULL, '4578341', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2628', 'estrada ', '2526288015', NULL, '2526288015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2629', 'Valpergutor S.R.L.', '285128021', NULL, '285128021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2630', 'LYNDON CRUZ CATARI', '1411892011', NULL, '1411892011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2631', 'MUEBLES METALICOS BOLIVAR S.R.', '341032024', NULL, '341032024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2632', 'Marco Antonio Linares Gonzales', '2753578013', NULL, '2753578013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2633', 'Faviola Salgado', '5197593', NULL, '5197593', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2634', 'Transportes Saturno S. R. L.', '129865023', NULL, '129865023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2635', 'Juan Carlos Menacho Virues', '6208180', NULL, '6208180', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2636', 'ISABEL RIVAS CAYO', '2058853010', NULL, '2058853010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2637', 'SANTILLANA DE EDICIONES S.A.', '1020759029', NULL, '1020759029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2638', 'Luis Quispe', '3701514015', NULL, '3701514015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2639', 'FELSY LAURIA HURTADO', '3276778013', NULL, '3276778013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2640', 'ERMOGENES FRANCO VALLEJOS', '6528662013', NULL, '6528662013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2641', 'Carol Sarabia ', '2823053017', NULL, '2823053017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2642', 'ALIAGA', '5953881', NULL, '5953881', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2643', 'Jose Luis Siles Cuellar', '3836046010', NULL, '3836046010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2644', 'DAVID TORDOYA SUAREZ', '14468729012', NULL, '14468729012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2645', 'valeria eugenia quispe carrisa', '8339351017', NULL, '8339351017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2646', 'Ramos', '6893491', NULL, '6893491', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2647', 'David Roca', '3333996', NULL, '3333996', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2648', 'CEINA LTDA', '1025511029', NULL, '1025511029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2649', 'LOZADA VIA URVELINDA CINDY', '8040612', NULL, '8040612', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2650', 'ONG CEPAC', '123957026', NULL, '123957026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2651', 'Leon', '6790829012', NULL, '6790829012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2652', 'TALAVERA', '489491012', NULL, '489491012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2653', 'maria erika caballero', '5342411', NULL, '5342411', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2654', 'Luis gallardo', '7137768', NULL, '7137768', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2655', 'Susy Felicidad Alanoca Condori', '4902634015', NULL, '4902634015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2656', 'virginia ramos', '656011017', NULL, '656011017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2657', 'Jaime Marcelo Zaconeta Pacheco', '4137572019', NULL, '4137572019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2658', 'valencia', '133073015', NULL, '133073015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2659', 'DAVID ALCOCER CLAROS', '6259817', NULL, '6259817', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2660', 'O&amp;C Ingenieria y Represent', '282624028', NULL, '282624028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2661', 'GUTIERREZ', '3591955010', NULL, '3591955010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2662', 'ALEJANDRO GARCIA', '1111846010', NULL, '1111846010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2663', 'GROUPCISC CENTRO EMPRESARIAL S', '303002024', NULL, '303002024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2664', 'WNM', '9184632010', NULL, '9184632010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2665', 'COLEGIO INGLES CATOLICO', '1020599028', NULL, '1020599028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2666', 'Reynoso', '3763803', NULL, '3763803', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2667', 'ECOTAMBO SRL', '238840021', NULL, '238840021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2668', 'NELLY ARGANDOA', '2601408', NULL, '2601408', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2669', 'Wendy Villarroel ', '8449629019', NULL, '8449629019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2670', 'Juan Malale Lopez ', '7650215013', NULL, '7650215013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2671', 'sids s.a.', '1016257022', NULL, '1016257022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2672', 'Rodriguez ', '3763187013', NULL, '3763187013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2673', 'BISA LEASING S.A.', '1007051029', NULL, '1007051029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2674', 'SAMUEL EGUEZ CARTAGENA', '4663830010', NULL, '4663830010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2675', 'Neil Marko Torrez Nogales', '5356802016', NULL, '5356802016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2676', 'ILLIMANI DE COMUNICACIONES S.A', '1020245021', NULL, '1020245021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2677', 'ABRAHAM MIRANDA', '6810203', NULL, '6810203', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2678', 'RUDDY DANIEL VEIZAGA TOLEDO', '7717412011', NULL, '7717412011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2679', 'EMILIO GUTIERREZ', '4543377019', NULL, '4543377019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2680', 'VERONICA VELA', '4094846014', NULL, '4094846014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2681', 'Aranibar', '839246', NULL, '839246', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2682', 'Velasquez', '5138125', NULL, '5138125', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2683', 'luisa norha yana chambi', '5262149', NULL, '5262149', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2684', 'De la Barra', '3371976', NULL, '3371976', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2685', 'Jimena Mamani Luna', '9631372', NULL, '9631372', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2686', 'Amparo Orias', '3348984015', NULL, '3348984015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2687', 'Juan Carlos Fuentes Morales', '1809734016', NULL, '1809734016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2688', 'Vladimir Yamil Lopez Castro', '4756611017', NULL, '4756611017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2689', 'morales ', '4836228', NULL, '4836228', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2690', 'EMPACAR S.A.', '1028123025', NULL, '1028123025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2691', 'MAXCONNECTIONS SRL', '304674028', NULL, '304674028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2692', 'Marcelo Machaca Cahuana', '6044256', NULL, '6044256', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2693', 'BEBIDAS BOLIVIANAS BBO S.A.', '170676025', NULL, '170676025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2694', 'Iver Carlos Pea Contreras', '6295974011', NULL, '6295974011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2695', 'LILY GIOVANA SOLIZ AREVALO', '5299020019', NULL, '5299020019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2696', 'Claudia Vernica Callisaya Gut', '4833483', NULL, '4833483', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2697', 'MARCELO PACAJES', '3466151017', NULL, '3466151017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2698', 'Maldonado', '2348615', NULL, '2348615\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2699', 'ELIAS ORTUO', '5356139018', NULL, '5356139018\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2700', 'Orlando Garnica', '998612012', NULL, '998612012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2701', 'ALIENDRE', '4367360', NULL, '4367360\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2702', 'Hilarion Choque Mamani', '5773706013', NULL, '5773706013\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2703', 'FRANKLIN MENDIETA AGUILERA', '4916531', NULL, '4916531\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2704', 'compeg s.r.l.', '299182029', NULL, '299182029\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2705', 'Luis Bejarano', '5039848', NULL, '5039848\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2706', 'Ximema Evelyn Rivero Mendez', '7775704019', NULL, '7775704019\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2707', 'Carlos Alberto Vargas Menacho', '6256514', NULL, '6256514\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2708', 'Elida Vaca', '1732505', NULL, '1732505\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2709', 'Marco Figueroa', '3819727', NULL, '3819727\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2710', 'ROGHUR S.A.', '1028445023', NULL, '1028445023\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2711', 'MARTHA CALLIZAYA', '4952561019', NULL, '4952561019\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2712', 'MACHACA', '2047987', NULL, '2047987\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2713', 'SALVADOR DEL CARPIO', '2792753014', NULL, '2792753014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2714', 'Genesis Brokers Ltda', '1026557020', NULL, '1026557020\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2715', 'Paola Uribe', '9031337', NULL, '9031337\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2716', 'Compaia de Inversiones Medite', '1011913026', NULL, '1011913026\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2717', 'MONTANO', '4833431', NULL, '4833431\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2718', 'ramirez', '3347555019', NULL, '3347555019\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2719', 'Arturo Humberto Ponce Aguirre', '5811763', NULL, '5811763\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2720', 'SERGIO MASABI TUERO', '9050953016', NULL, '9050953016\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2721', 'Jaime Alberto Fernandez Cruz', '5009293019', NULL, '5009293019\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2722', 'ANTEZANA', '7302415', NULL, '7302415\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2723', 'FUNDACION SAN LUCAS', '333102021', NULL, '333102021\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2724', 'DELIA CONDORI', '6073697', NULL, '6073697\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2725', 'Fidel Aez Orellana', '1727712019', NULL, '1727712019\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2726', 'NEOSERV S.R.L.', '266320020', NULL, '266320020\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2727', 'Ingenieria y Representaciones ', '164276029', NULL, '164276029\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2728', 'Agrishow S.R.L.', '359756020', NULL, '359756020\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2729', 'Juan Marcelo Veza Dorado', '4625766018', NULL, '4625766018\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2730', 'OSWALDO TEJERINA MENDEZ', '1867623011', NULL, '1867623011\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2731', 'SAINT LTDA', '306066025', NULL, '306066025\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2732', 'Romel Jesus Alvis Espinoza', '6381677012', NULL, '6381677012\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2733', 'Vargas', '3468907', NULL, '3468907\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2734', 'Kelly Pency Gonzales Lopez', '3538662014', NULL, '3538662014\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2735', 'Panozo', '1032815', NULL, '1032815\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2736', 'Jaime Miranda Soria', '3886046014', NULL, '3886046014\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2737', 'Javier Moises Baptista Yuca', '5515505', NULL, '5515505\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2738', 'Marcela Ishell Olivares Llonto', '4569166018', NULL, '4569166018\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2739', 'Richard vega mejia', '7144487018', NULL, '7144487018\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2740', 'LAURA SEVILLANO ROMERO', '9411041010', NULL, '9411041010\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2741', 'SUSAN CONTRERAS', '3397880', NULL, '3397880\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2742', 'INSTRUMENTOS E INGENIERIA EXPE', '291754027', NULL, '291754027\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2743', 'NEISA MONTERO', '4279223010', NULL, '4279223010\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2744', 'YOMAVIK SRL', '351335023', NULL, '351335023\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2745', 'alfredo ururi', '2015961016', NULL, '2015961016\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2746', 'Reynaldo Cuellar Oa', '3905129018', NULL, '3905129018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2747', 'Gonzalez', '4247474', NULL, '4247474', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2748', 'ARIAS', '6008638018', NULL, '6008638018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2749', 'DESMART LTDA', '192978029', NULL, '192978029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2750', 'Vega', '3344978', NULL, '3344978', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2751', 'Orlando Franklin Palacio Pinto', '4729620013', NULL, '4729620013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2752', 'Andrea Mendoza', '7881637011', NULL, '7881637011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2753', 'KARINA LILIAN CASAZOLA ARANIBA', '6518948', NULL, '6518948', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2754', 'marisol almaraz pinto', '6497864014', NULL, '6497864014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2755', 'Richard flores calle', '5193024019', NULL, '5193024019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2756', 'Leny Lourdes Uriona Saavedra', '5875262014', NULL, '5875262014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2757', 'Mendez', '7722691', NULL, '7722691', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2758', 'juan jose chavarria flores', '6711780', NULL, '6711780', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2759', 'JORGE CORVERA ', '5785645', NULL, '5785645', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2760', 'JOSE MIGUEL ROMERO', '183020026', NULL, '183020026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2761', 'Aguilar', '3452460', NULL, '3452460', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2762', 'Jacqueline Gemio', '3329387017', NULL, '3329387017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2763', 'RICHARD ARIAS PALACIO', '3927609013', NULL, '3927609013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2764', 'ERICKA VIDAL ROSADO', '6264190', NULL, '6264190', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2765', 'Daysi Vera Ramos', '5571492', NULL, '5571492', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2766', 'SADOT CHOQUE YAMPASI', '2149871', NULL, '2149871', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2767', 'Miguel Garcia Mendoza ', '5204369', NULL, '5204369', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2768', 'Pablo Flores', '3355737', NULL, '3355737', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2769', 'Mariela Gonzales Antezana', '4733882019', NULL, '4733882019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2770', 'Yessica Flores', '8973042', NULL, '8973042', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2771', 'Vasquez', '4756934', NULL, '4756934', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2772', 'LEDA AGUILERA RIBERA ', '3178947012', NULL, '3178947012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2773', 'JULIAN MENDOZA PAQUI', '5011612', NULL, '5011612', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2774', 'Ruth Mostacedo Perez', '8775313', NULL, '8775313', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2775', 'Jean Michael Lijeron Moreno', '6222251019', NULL, '6222251019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2776', 'GUARACHI', '4835513', NULL, '4835513', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2777', 'GESEDAL S.A.', '1020137024', NULL, '1020137024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2778', 'MIG S.A. ', '148218023', NULL, '148218023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2779', 'EXCELSIOR SRL', '189898020', NULL, '189898020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2780', ' Sudtirol Ltda', '371337025', NULL, '371337025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2781', 'Rosario Rodrguez Caro', '8219638013', NULL, '8219638013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2782', 'Empresa Minera Llave SRL ', '350763025', NULL, '350763025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2783', 'cardozo belen ', '6302623013', NULL, '6302623013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2784', 'GALERIA KARLOVY VARY', '1017683028', NULL, '1017683028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2785', 'GRUPOASC LTDA ', '355577027', NULL, '355577027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2786', 'Fatima Carrillo ', '2852005', NULL, '2852005', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2787', 'Daniel Paz Santos', '5079345016', NULL, '5079345016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2788', 'Marciano raldes rojas', '7803106', NULL, '7803106', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2789', 'A&amp;G Soc. Civ. ', '355585020', NULL, '355585020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2790', 'LUISA CONDORI GRAS', '4093375015', NULL, '4093375015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2791', 'Productora y comercializadora ', '176216021', NULL, '176216021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2792', 'Hugo alfredo ', '1764531', NULL, '1764531', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2793', 'COSEAP RL. ', '1012501025', NULL, '1012501025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2794', 'ACLO ', '1000165026', NULL, '1000165026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2795', 'FUNDACION QUIMEL', '152374026', NULL, '152374026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2796', 'Veronica Gaite', '1879022', NULL, '1879022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2797', 'Cardozo', '452831', NULL, '452831', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2798', 'Grenda Vhiestrox Antezana', '2847491016', NULL, '2847491016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2799', 'MOTAVAR S.R.L. ', '346544025', NULL, '346544025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2800', 'CARRASCO MURILLO MARIO GROVER ', '3101873015', NULL, '3101873015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2801', 'Sonia Layme Canaza', '4834426016', NULL, '4834426016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2802', 'VERONICA LUJAN', '7735904', NULL, '7735904', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2803', 'Jhovana Ximena Poma Choque ', '7288738', NULL, '7288738', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2804', 'VILLARROEL', '6503168', NULL, '6503168', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2805', 'Magaly Garcia', '8196553', NULL, '8196553', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2806', 'MARTIN CALLE', '2383851019', NULL, '2383851019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2807', 'TATIANA COYAURE OROSCO', '8354510', NULL, '8354510', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2808', 'Alfaro ', '765624013', NULL, '765624013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2809', 'EMPRESA EDITORA LA LTIMA LLAM', '1022773029', NULL, '1022773029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2810', 'JOSE DEL CARPIO', '1856833014', NULL, '1856833014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2811', 'Yaqueline Centellas Ayala', '4682796011', NULL, '4682796011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2812', 'Lizbeth Torrico Espejo', '4338811', NULL, '4338811', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2813', 'Eulalia Moirenda', '6375953015', NULL, '6375953015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2814', 'CARLOS RIOS', '3734989011', NULL, '3734989011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2815', 'Juan Carlos Sandy Maraon', '1860590011', NULL, '1860590011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2816', 'iglesia metodista', '1020165021', NULL, '1020165021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2817', 'JUAN JOSE MENDOZA MAMANI', '4912522014', NULL, '4912522014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2818', 'Pedro Rojas', '1463052017', NULL, '1463052017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2819', 'ECOLUCSAN S.R.L.', '370393021', NULL, '370393021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2820', 'VELA ', '4773944017', NULL, '4773944017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2821', 'KENNY GROVER CRUZ OYOLA', '5543909', NULL, '5543909', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2822', 'Karla Roxana Aruquipa Durn', '7722015', NULL, '7722015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2823', 'Claudia Aez Hurtado', '3885471', NULL, '3885471', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2824', 'ENRIQUE CAZAS', '3447230', NULL, '3447230', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2825', 'camacho', '7203690', NULL, '7203690', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2826', 'CORINA QUINTANA SILVESTRE', '5385219', NULL, '5385219', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2827', 'Argote cadima ronald', '5247138010', NULL, '5247138010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2828', 'Hermann Bonilla ', '6237888011', NULL, '6237888011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2829', 'Trac Repuestos ', '827865011', NULL, '827865011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2830', 'JUDITH MACHICADO DE VERA', '2214536019', NULL, '2214536019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2831', 'VARGAS ', '4770947011', NULL, '4770947011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2832', 'Nancy cadiz', '7844757', NULL, '7844757', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2833', 'Mariel Uriona ', '5823800', NULL, '5823800', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2834', 'PuntoCom s.r.l. ', '1012295025', NULL, '1012295025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2835', 'FABIOLA TORREZ GUTIERREZ ', '7849533', NULL, '7849533', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2836', 'CARLOS ROBERTO VILLARROEL VILL', '3754065010', NULL, '3754065010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2837', 'condori', '5050412', NULL, '5050412', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2838', 'Danitza Mejia Valdivia', '5494965', NULL, '5494965', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2839', 'BALCAZAR ', '5138702011', NULL, '5138702011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2840', 'ALINA MELGAREJO ', '8014954013', NULL, '8014954013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2841', 'Eugenio Argandoa Crispin', '3369856', NULL, '3369856', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2842', 'BUSTILLLOS ', '2219760', NULL, '2219760', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2843', 'RUTH DAPNE ARAMAYO RIVAS', '6681174112', NULL, '6681174112', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2844', 'Gabriela Vargas Manardy', '6614691016', NULL, '6614691016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2845', 'tecnopeso srl', '373682029', NULL, '373682029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2846', 'Erick Rivero Monasterio ', '6252178', NULL, '6252178', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2847', 'FEGRANDE CONSULTORA CONTABLE ', '360725020', NULL, '360725020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2848', 'Pinto', '9982283', NULL, '9982283', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2849', 'RODRIGO FERNANDO CONCHA ALIAGA', '4778482016', NULL, '4778482016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2850', 'Rubert', '10782999', NULL, '10782999', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2851', 'juan carlos hurtado', '2974499016', NULL, '2974499016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2852', 'vega ', '6305257', NULL, '6305257', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2853', 'Rubn Bejarano', '7696555', NULL, '7696555', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2854', 'PVC COMPUESTOS INDUSTRIALES S.', '1009373022', NULL, '1009373022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2855', 'ELYER MARINA RODRIGUEZ', '6641214014', NULL, '6641214014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2856', 'Vivian Eliane Rivera Aguilera', '9014805', NULL, '9014805', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2857', 'Pablo Cesar Quispe Sejas', '5363396', NULL, '5363396', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2858', 'Illanes ', '5212944014', NULL, '5212944014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2859', 'Mariana Mendez Rocha ', '5596025015', NULL, '5596025015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2860', 'ALEXANDRO CROOKER', '2309399019', NULL, '2309399019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2861', 'Jose Crespo', '3435396', NULL, '3435396', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2862', 'Gol Linhas Aereas S.A. (Suc. B', '129113023', NULL, '129113023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2863', 'NICOLAS VARGAS', '5111214019', NULL, '5111214019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2864', 'Willma Limachi Ramos ', '3719948019', NULL, '3719948019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2865', 'QUISBERT', '2554314', NULL, '2554314', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2866', 'luis carlos zurita orellana', '6377955', NULL, '6377955', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2867', 'Guzman ', '755317018', NULL, '755317018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2868', 'Cristian Orihuela', '3968696', NULL, '3968696', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2869', 'Sindy Mariaca', '6951116', NULL, '6951116', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2870', 'INFOARCH SRL ', '159388028', NULL, '159388028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2871', 'VIOLETTA', '4883460', NULL, '4883460', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2872', 'William Rios', '1812927', NULL, '1812927', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2873', 'Fabio Aquise ', '6940232', NULL, '6940232', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2874', 'Freddy Carlos', '462564016', NULL, '462564016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2875', 'MAURICIO PADILLA ', '1738400011', NULL, '1738400011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2876', 'RAMOS', '1311836010', NULL, '1311836010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2877', 'ANEXO CONSULTORES SRL', '309698022', NULL, '309698022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2878', 'Daniel Edson Mercado Valdivia', '3844403', NULL, '3844403', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2879', 'perez', '3602601010', NULL, '3602601010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2880', 'ESTACION DE SERVICIO CHURUQUEL', '297800026', NULL, '297800026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2881', 'ANGEL VIRGILIO AJATA MONTOYA', '2681086', NULL, '2681086', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2882', 'Miguel A. Campana Pardo ', '3703932019', NULL, '3703932019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2883', 'IBOLSA AGENCIA DE BOLSA S.A. ', '225940027', NULL, '225940027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2884', 'Rocabado ', '6420326010', NULL, '6420326010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2885', 'PADILLA', '344543010', NULL, '344543010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2886', 'IRECFER', '361674024', NULL, '361674024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2887', 'sanchez', '2657912010', NULL, '2657912010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2888', 'Halliburton Latin America SRL ', '1015569020', NULL, '1015569020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2889', 'San Pablo Villa Bolvar SRL.', '1020353026', NULL, '1020353026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2890', 'ALEX SAAVEDRA CASTRO', '7637146010', NULL, '7637146010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2891', 'Liliana Miranda Ocampo ', '7239181', NULL, '7239181', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2892', 'PHARMA SERVICE REPRESENTANTES ', '300480023', NULL, '300480023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2893', 'Fabiola Brenda Ortiz Ramos', '7519711', NULL, '7519711', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2894', 'TECNOQUO SRL ', '301356025', NULL, '301356025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2895', 'TECNOACERO S.R.L', '134475023', NULL, '134475023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2896', 'VITONIO YSITA ARTEAGA', '1710700019', NULL, '1710700019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2897', 'Salas Gilka', '2053774', NULL, '2053774', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2898', 'Heber Marcelo Romero Tellez ', '5687665014', NULL, '5687665014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2899', 'Universidad Bethesda ', '142721029', NULL, '142721029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2900', 'ALIMENTOS DON NENE S.R.L.', '290960028', NULL, '290960028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2901', 'Quelca', '3467797', NULL, '3467797', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2902', 'Victor hugo altamirano ibarra ', '8199762015', NULL, '8199762015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2903', 'John Jairo Melgar ', '8979637014', NULL, '8979637014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2904', 'Lidiane Oa Abrego', '5574786015', NULL, '5574786015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2905', 'Mara Luisa Auza Vidal', '3081666', NULL, '3081666', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2906', 'Ninachoque', '4787509', NULL, '4787509', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2907', 'Yamila Oa Quenta', '3480415016', NULL, '3480415016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2908', 'Rossell ', '12560765', NULL, '12560765', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2909', 'CARLOS YVAR DONOSO RUEDA', '5810473016', NULL, '5810473016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2910', 'guineo srl', '346832024', NULL, '346832024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2911', 'COOPERATIVA DE AHORRO Y CREDIT', '1015611021', NULL, '1015611021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2912', 'Roberto Massimo Patara Brianco', '5688954016', NULL, '5688954016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2913', 'COOPERATIVA MINERA ESTRELLA DE', '1010475026', NULL, '1010475026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2914', 'lourdes condori colque', '77601480', NULL, '77601480', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2915', 'EMMUZ SRL', '324590029', NULL, '324590029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2916', 'FERNANDEZ', '6009108', NULL, '6009108', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2917', 'Carranza', '4781885011', NULL, '4781885011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2918', 'EMSECMAT S.R.L. ', '355758026', NULL, '355758026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2919', 'EASY MARKET SRL', '334208020', NULL, '334208020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2920', 'Juan Pablo Calcina', '6671105', NULL, '6671105', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2921', 'Nilda Judith Peralta Mamani', '8545658015', NULL, '8545658015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2922', 'Marlene Cruz Villca', '6675803017', NULL, '6675803017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2923', 'PREFORTE S.A.', '292900020', NULL, '292900020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2924', 'Mendoza', '13244163', NULL, '13244163', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2925', 'NUEVATEL PCS DE BOLIVIA S.A.', '1007173022', NULL, '1007173022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2926', 'aracely vasquez rioja', '4195060', NULL, '4195060', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2927', 'JOS LUIS MACHICADO CRUZ', '12925193', NULL, '12925193', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2928', 'CONSTRUCTORA PARAMENTO S.R.L.', '373698020', NULL, '373698020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2929', 'miranda ', '6972753014', NULL, '6972753014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2930', 'JUAN CARLOS CABA COSSIO', '6503537012', NULL, '6503537012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2931', 'Belinda Ada Quispe Vedia', '10333531', NULL, '10333531', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2932', 'HSB INDUSTRIAL S.R.L. ', '284394028', NULL, '284394028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2933', 'victor rojas palacios', '2315292', NULL, '2315292', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2934', 'Rolando Rojas Duran', '8102296011', NULL, '8102296011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2935', 'saravia', '4842005', NULL, '4842005', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2936', 'Salinas', '3556813', NULL, '3556813', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2937', 'Eusebio Lpez Martnez', '3119189010', NULL, '3119189010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2938', 'Silvia Torrez ', '2901621011', NULL, '2901621011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2939', 'Casa de la Cultura del Beni ', '214516020', NULL, '214516020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2940', 'Jalasoft S.R.L.', '155018021', NULL, '155018021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2941', 'Viviana', '7212289', NULL, '7212289', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2942', 'FUNDACION HIVOS', '146410021', NULL, '146410021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2943', 'GALINDO', '6454111012', NULL, '6454111012', NULL, NULL, NULL, NULL, NULL, '', '0');
INSERT INTO `0_crm_persons` VALUES
('2944', 'Tatiana Gmez', '3559627', NULL, '3559627', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2945', 'OSCAR MANUEL VEGA ROSSO', '3978388011', NULL, '3978388011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2946', 'Omar Anthony Choque Mamani', '7350339011', NULL, '7350339011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2947', 'NOVUM SRL', '329088021', NULL, '329088021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2948', 'ASERCOMEX SRL ', '1010065024', NULL, '1010065024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2949', 'Arturo Pea Pea', '3886917017', NULL, '3886917017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2950', 'archondo ', '3438270016', NULL, '3438270016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2951', 'Rosi Villalba Ramos', '8229547013', NULL, '8229547013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2952', 'JUNGIE  MINING  INDUSTRY  SRL', '157038023', NULL, '157038023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2953', 'TOYOTA BOLIVIA SA', '1008467028', NULL, '1008467028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2954', 'WILLIAM CHAO RIVERO', '4826345015', NULL, '4826345015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2955', 'ANALIA MAGALLANES', '4674575', NULL, '4674575', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2956', 'Terceros', '6484547013', NULL, '6484547013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2957', 'CALISAYA', '4750968011', NULL, '4750968011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2958', 'PETSERVIN S.R.L.', '312814027', NULL, '312814027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2959', 'Edwin Gareca Figueroa', '5811073', NULL, '5811073', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2960', 'Edwing Romay Alarcn ', '3467487', NULL, '3467487', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2961', 'mijail alexander rivera monta', '7773738', NULL, '7773738', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2962', 'Edwing Romay Alarcn ', '178928029', NULL, '178928029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2963', 'Rocio Padilla Mendoza', '7519689', NULL, '7519689', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2964', 'yohanna benitez ', '10766399', NULL, '10766399', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2965', 'Soledad Laime Alaca', '6561219013', NULL, '6561219013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2966', 'CHAUCA', '9945363017', NULL, '9945363017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2967', 'SANDRO BALLEJOS', '9503206012', NULL, '9503206012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2968', 'montalvo', '5471568', NULL, '5471568', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2969', 'MARCO ANTONIO GONZALEZ MENDOZA', '1988152', NULL, '1988152', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2970', '5918708', '5918708', NULL, '5918708', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2971', 'CONCREMIX SRL', '126467020', NULL, '126467020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2972', 'Wilson Rivas Flores', '10531093', NULL, '10531093', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2973', 'FUNDACION MEDMIN', '1017353029', NULL, '1017353029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2974', 'Gipsia Mabel Perez Michaga', '7242065', NULL, '7242065', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2975', 'Roger Fuentes', '5333437010', NULL, '5333437010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2976', 'BERTHA MOLLO FLORES', '7105472', NULL, '7105472', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2977', 'Yaquelin Leaez', '7180828014', NULL, '7180828014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2978', 'Alan Hctor Garca Padilla', '6703239013', NULL, '6703239013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2979', 'Ingrid Gramajo', '5814091013', NULL, '5814091013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2980', 'TB y GV S.R.L.', '192746028', NULL, '192746028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2981', 'Jimena Mamani Yucra ', '10719654017', NULL, '10719654017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2982', 'Oscar Ernesto Varas Ortiz ', '5690268017', NULL, '5690268017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2983', 'Paniagua ', '3066956', NULL, '3066956', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2984', 'Irma castillo', '5039032015', NULL, '5039032015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2985', 'Luz Alejandra Soto Tapia', '7005677', NULL, '7005677', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2986', 'sonia mejia ', '5193685016', NULL, '5193685016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2987', 'yannet humbelina cuellar I', '1919334', NULL, '1919334', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2988', 'INTERCOMEX SA ', '1014405022', NULL, '1014405022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2989', 'Lissetthe Muoz', '7114197014', NULL, '7114197014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2990', 'Daniel algaraaz justiniano', '4826502011', NULL, '4826502011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2991', 'Ana Claudia Merubia Ruiz', '6213005016', NULL, '6213005016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2992', ' PFENNINGER BOLIVIA S.R.L.', '198100026', NULL, '198100026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2993', 'Sindy Yisela Zuleta Jurado', '6672309', NULL, '6672309', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2994', 'Beimar Isidro Rueda Beitez', '7158728014', NULL, '7158728014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2995', 'Jos Eduardo Aguilar ', '5672875', NULL, '5672875', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2996', 'ROMANO', '3551006014', NULL, '3551006014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2997', 'Karla Adriana Vargas Condori ', '8654916', NULL, '8654916', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2998', 'ALFONSO GOMEZ', '5130333', NULL, '5130333', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2999', 'prado ', '6514248015', NULL, '6514248015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3000', 'Maria Eugenia Paz Aez', '6281916', NULL, '6281916', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3001', 'carrasco ', '2372849', NULL, '2372849', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3002', 'Hugo Salinas Burgos', '3710316015', NULL, '3710316015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3003', ' Maria Teresa Careaga Salazar', '3712282018', NULL, '3712282018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3004', 'Leonardo Salazar ', '8154317', NULL, '8154317', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3005', 'Calvi', '2328138017', NULL, '2328138017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3006', 'de la fuente eddy ', '3751101', NULL, '3751101', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3007', 'Monica Mosciaro ', '4694528', NULL, '4694528', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3008', 'BENITO SILVA GUZMAN', '3905712010', NULL, '3905712010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3009', 'Mario Inca Cruz', '5935523012', NULL, '5935523012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3010', 'Anibal Garcia Ruiz', '10320868', NULL, '10320868', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3011', 'CREADICTOS SRL ', '228672026', NULL, '228672026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3012', 'CARMELO GARY KENOTH AQUIN ', '3873048011', NULL, '3873048011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3013', 'Jaime Armando Moreno Maldonado', '7104901012', NULL, '7104901012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3014', 'ADEL BAUTISTA ', '1896032', NULL, '1896032', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3015', 'Toms Chambi ', '70525014', NULL, '70525014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3016', 'Marco roman', '998472', NULL, '998472', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3017', 'ABIGAIL LOPEZ FLORES', '7252214014', NULL, '7252214014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3018', 'janhs abel gonzales melgar', '4664817015', NULL, '4664817015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3019', 'RONALD ROBERT ROJAS HUAYTA', '7115338015', NULL, '7115338015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3020', 'MIGUEL ANGEL MAMANI MENA', '11309293', NULL, '11309293', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3021', 'Casas Kolping Bolivia S.R.L.', '121157024', NULL, '121157024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3022', 'Andrea Beatriz Mealla', '7122359', NULL, '7122359', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3023', 'Teresa choque', '7162948019', NULL, '7162948019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3024', 'Avendao', '6763200', NULL, '6763200', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3025', '6763200', '214408029', NULL, '214408029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3026', 'Yenny Jerez Segovia', '7180811', NULL, '7180811', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3027', 'victor eugenio herbas espinoza', '3832110017', NULL, '3832110017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3028', 'Ascarrunz', '10916833013', NULL, '10916833013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3029', 'Flor Valdez Ramor', '7178795019', NULL, '7178795019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3030', 'Edith Carminia Canaviri Llanqu', '7127084019', NULL, '7127084019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3031', 'Ximena Lisbeth Fernandez Manci', '7127561', NULL, '7127561', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3032', 'COOPERATIVA DE AHORRO Y CREDIT', '1003135024', NULL, '1003135024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3033', 'Gamarra ', '5048465', NULL, '5048465', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3034', 'Weymar Balcazar Chacon ', '6643385011', NULL, '6643385011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3035', 'Maldonado', '6153242', NULL, '6153242', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3036', 'Llanos', '5047998', NULL, '5047998', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3037', 'Angela Patricia Rivas Limon', '8247636', NULL, '8247636', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3038', 'Mely Melania Canchi Mamani', '7198717015', NULL, '7198717015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3039', 'MARIA ELENA CHIPANA CHURA', '11349825', NULL, '11349825', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3040', 'JOSUE MOISES HUANCA LAURA', '7246361015', NULL, '7246361015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3041', 'Shirley Sandy Morales', '681178010', NULL, '681178010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3042', 'Dexter Adrian Gumiel', '7555647', NULL, '7555647', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3043', 'Machaca', '4823191011', NULL, '4823191011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3044', 'Ana Rosa Lpez', '1815638', NULL, '1815638', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3045', 'Marielin', '10624933', NULL, '10624933', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3046', 'ortiz', '9235615', NULL, '9235615', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3047', 'Siani', '4836601', NULL, '4836601', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3048', 'jhonny moya oropeza', '6465390', NULL, '6465390', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3049', 'Choqueticlla', '3555179', NULL, '3555179', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3050', 'WILSON RAMIREZ', '3342766019', NULL, '3342766019v', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3051', 'TEMEQRAN SRL', '239114021', NULL, '239114021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3052', 'Jose Luis Hiza', '4697882', NULL, '4697882', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3053', 'Rossemary Cutipa Arancibia', '7477561015', NULL, '7477561015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3054', 'Hugo Columba Soleto', '6268548', NULL, '6268548', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3055', 'Froilan Condori Apaza', '4805285011', NULL, '4805285011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3056', 'olga quispe heredia', '7760135016', NULL, '7760135016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3057', 'DUVER CHAVEZ PEREZ', '5663945010', NULL, '5663945010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3058', 'GABRIELA CHOQUE', '8626635', NULL, '8626635', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3059', 'UNIDAD EDUCATIVA BAUTISTA CANA', '1002253025', NULL, '1002253025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3060', 'Marilin Coro', '7537027011', NULL, '7537027011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3061', 'Maria Soledad Mendoza', '7552688', NULL, '7552688', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3062', ' MARIO FAVIO ENCINAS VACALLANO', '3895913010', NULL, '3895913010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3063', 'RAQUEL VASQUEZ ALVAREZ', '8772624012', NULL, '8772624012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3064', 'TRIPOLY S.R.L.', '288222029', NULL, '288222029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3065', 'Edwin Pocori', '4252186011', NULL, '4252186011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3066', 'Gutierrez', '8045325', NULL, '8045325', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3067', 'Fatima Duran Miranda', '7144660', NULL, '7144660', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3068', 'ALEJANDRA HERRERA', '5693335', NULL, '5693335', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3069', 'Guido Pinto fuentes', '7935114012', NULL, '7935114012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3070', 'Giselle Areliz Roca Arce', '3817383019', NULL, '3817383019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3071', 'MILKA BUENO', '4776752018', NULL, '4776752018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3072', 'Lidia Parra Vargas', '7848898', NULL, '7848898', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3073', 'Genaro claros', '2330300', NULL, '2330300', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3074', 'Ninfa duran de zenteno', '3662670019', NULL, '3662670019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3075', 'Raul Gonzales Alanez', '3094602', NULL, '3094602', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3076', 'Marco Antonio Tarqui Alanoca', '6018702', NULL, '6018702', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3077', 'AUDIADMI S.R.L. ', '1017149023', NULL, '1017149023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3078', 'Adrian Fuentes Barba', '5377659', NULL, '5377659', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3079', 'Ingrid Danitza Barrios Garret', '5670882016', NULL, '5670882016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3080', 'JUAN CARLOS SEVERICHE PADILLA ', '6221996017', NULL, '6221996017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3081', 'Dayer Agreda Rojas', '8661050', NULL, '8661050', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3082', 'LILIANA LAIME ', '6394703', NULL, '6394703', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3083', 'Daza', '835493011', NULL, '835493011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3084', 'YOSELIN PILAR RIVAS LIMON', '9028517', NULL, '9028517', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3085', 'Martha Castrillo Estrada', '7205826012', NULL, '7205826012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3086', 'Estacin de Servicio LORETO S.', '1023177028', NULL, '1023177028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3087', 'Cristhian Javier Ardaya Montej', '12437972', NULL, '12437972', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3088', 'OBSERVATORIO SAN CALIXTO', '1016653027', NULL, '1016653027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3089', 'ANTURIANO', '986031', NULL, '986031', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3090', 'MAURICIA DINA PLATA CATARI', '6564707', NULL, '6564707', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3091', 'Jimmy Mogro', '3444723', NULL, '3444723', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3092', 'Karin Gantier de Zambrana', '1980723013', NULL, '1980723013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3093', 'Delgado', '3501558', NULL, '3501558', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3094', 'Silvia Eugenia Yaez', '6713668', NULL, '6713668', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3095', 'Maria Portillo', '7180674', NULL, '7180674', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3096', 'BIANCHI RETAIL STORES LTDA.', '280378026', NULL, '280378026', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3097', 'Beva Ltda. ', '297870027', NULL, '297870027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3098', 'PR Marriott Drilling Ltd (Sucu', '353563027', NULL, '353563027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3099', 'constructora service computer', '137667028', NULL, '137667028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3100', 'Pablo Alberto Moya Arce', '4537439', NULL, '4537439', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3101', 'CIMSA', '1016971020', NULL, '1016971020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3102', 'TITO', '6824104', NULL, '6824104', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3103', 'AGUSTIN ALANOCA', '2514181019', NULL, '2514181019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3104', 'CER LTDA.', '1015781022', NULL, '1015781022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3105', 'BUBULINA S.R.L. ', '206256029', NULL, '206256029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3106', 'NEWPIRAI LTDA', '372875020', NULL, '372875020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3107', 'DEVORA ESTHER HERBAS QUISBERT', '6119640012', NULL, '6119640012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3108', 'DIAKONIA', '10061450258', NULL, '10061450258', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3109', 'RENE ALEJO FLORES VICENTE', '2681311010', NULL, '2681311010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3110', 'PROEZAS S.R.L. ', '375731021', NULL, '375731021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3111', 'DEYMAR OSVALDO MAMANI TICONIPA', '7502318010', NULL, '7502318010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3112', 'Rubert', '1078291010', NULL, '1078291010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3113', 'Tatiana Calle Apaza', '7821930', NULL, '7821930', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3114', 'Balboa', '3397489017', NULL, '3397489017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3115', 'Patricia Valle Trrez', '2629867016', NULL, '2629867016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3116', 'Cinthia Quiroz ', '1920109', NULL, '1920109', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3117', 'CLOVER MIGUEL ROMAN VARGAS', '5009834019', NULL, '5009834019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3118', 'SANDRA ROCABADO ', '3213670019', NULL, '3213670019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3119', 'FRANCE MAMANI SILVESTRE', '6403081019', NULL, '6403081019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3120', 'Sitecal SRL', '357165027', NULL, '357165027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3121', 'Norfa Teresa Villagmez Jimebe', '3293085', NULL, '3293085', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3122', 'MARIZOL VASQUEZ CAMACHO', '6508275010', NULL, '6508275010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3123', 'Rose Mary Viracoche', '3752699013', NULL, '3752699013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3124', 'Gilmar vallejos', '8679551', NULL, '8679551', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3125', 'Ruth Mirian Rivadineira Gallar', '4522777019', NULL, '4522777019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3126', 'SIC FUTURO LTDA. ', '1317869018', NULL, '1317869018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3127', 'SIC FUTURO LTDA. ', '135007027', NULL, '135007027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3128', 'Walter Hugo Vargas Vaca ', '1709643', NULL, '1709643', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3129', 'Gayla Lucero Coca Blanco', '3559618019', NULL, '3559618019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3130', 'ROSA ELIZABETH CALIZAYA MORENO', '3380898', NULL, '3380898', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3131', ' jorge Hugo Vaca Pinto', '1702284012', NULL, '1702284012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3132', 'CARLA SUSANA AJHUACHO OROPEZA ', '8147412017', NULL, '8147412017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3133', 'CATALINA TUMIRI', '4919522013', NULL, '4919522013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3134', 'Joice Alejandra Robles Crdena', '9842109', NULL, '9842109', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3135', 'Asesora Contable Andrmeda LT', '301382023', NULL, '301382023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3136', 'SERVO S.R.L. ', '173742027', NULL, '173742027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3137', 'shirley borda', '5030556', NULL, '5030556', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3138', 'Constructora Apolo Ltda', '1015493028', NULL, '1015493028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3139', 'Jess camacho ', '10476625', NULL, '10476625', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3140', 'Sandra Gutierrez ', '3342536011', NULL, '3342536011', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3141', 'QUINTEROS ', '3361363016', NULL, '3361363016', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3142', 'XPARTES SRL', '312986020', NULL, '312986020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3143', 'GRUPO DEL VIDRIO HR S.R.L. ', '346009021', NULL, '346009021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3144', 'MEC CONSULTORES SRL ', '305666021', NULL, '305666021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3145', 'KYOHEI LTDA.', '375868025', NULL, '375868025', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3146', 'Mendieta ', '2309936015', NULL, '2309936015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3147', 'Fabio Bustos ', '6110457', NULL, '6110457', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3148', 'Martha GianCarla Morales Padil', '3296989', NULL, '3296989', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3149', 'Franz Wieler Wiebe ', '5898055', NULL, '5898055', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3150', 'Carlos Garfias Soliz ', '584922013', NULL, '584922013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3151', 'Torquemada', '2709144014', NULL, '2709144014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3152', 'morales', '3643377014', NULL, '3643377014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3153', 'AUDINORTE S.R.L. ', '145480020', NULL, '145480020', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3154', 'Profima srl', '1006401022', NULL, '1006401022', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3155', 'Avatron SRL. ', '208002023', NULL, '208002023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3156', 'IMPORTADORA LLANTAX LTDA', '1023115029', NULL, '1023115029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3157', 'Dina Elizabeth Arispe Terrazas', '6549826010', NULL, '6549826010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3158', 'Paola Orihuela ', '3193614', NULL, '3193614', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3159', 'Mamani', '8369739', NULL, '8369739', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3160', 'Maria Cristina Armengold', '1736885019', NULL, '1736885019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3161', 'JUSTINIANO ', '6136392', NULL, '6136392', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3162', 'GESCO SA', '1028761021', NULL, '1028761021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3163', 'Isaac Quispe Oropeza', '9665387', NULL, '9665387', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3164', 'Mnica Clavijo ', '3963589018', NULL, '3963589018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3165', 'GALO HENRY CALLE VALENCIA', '4996463010', NULL, '4996463010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3166', 'Flores ', '5066496018', NULL, '5066496018', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3167', 'EMPRESA PACHECO MONTAO DISTRI', '1030517021', NULL, '1030517021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3168', 'audconsul internacional srl', '371317029', NULL, '371317029', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3169', 'Graciela abdala ', '6369852019', NULL, '6369852019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3170', 'HORACIO BECERRA ', '3229112', NULL, '3229112', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3171', 'Cristina aguirre ', '7565633', NULL, '7565633', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3172', 'empresa constructora hermanos ', '1023653024', NULL, '1023653024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3173', 'COLEGIO DE ODONTOLOGOS DE LA P', '1003275024', NULL, '1003275024', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3174', 'Jose Rodriguez Narvaez', '6990128', NULL, '6990128', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3175', 'VILLARROEL', '6704975', NULL, '6704975', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3176', 'NORFIELD SRL', '1013627028', NULL, '1013627028', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3177', 'Complejo Geriatrico Geriland S', '292966027', NULL, '292966027', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3178', 'Aceros Villena ', '2054305013', NULL, '2054305013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3179', 'Luis Arnez Onofre ', '3585531015', NULL, '3585531015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3180', 'Ral cordova', '3977116', NULL, '3977116', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3181', 'LILIA GUZMAN QUIROGA', '2723410014', NULL, '2723410014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3182', 'Marysol Choque Resamano ', '4652452', NULL, '4652452', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3183', 'MURGUIA ', '4284826', NULL, '4284826', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3184', 'IMPORTADORA DOLCETTO SRL ', '348501023', NULL, '348501023', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3185', 'Suxo', '4865383014', NULL, '4865383014', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3186', 'Rodoway Bolivia Srl', '159300021', NULL, '159300021', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3187', 'Crdenas ', '5929792010', NULL, '5929792010', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3188', 'Jos Antonio Maldonado Vicente', '3915697', NULL, '3915697', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3189', 'AIDEE SUAREZ ', '4560118', NULL, '4560118', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3190', 'Eguivar', '4277441', NULL, '4277441', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3191', 'SOLIS ', '3023698', NULL, '3023698', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3192', 'CARLOS MONTENEGRO', '1504040017', NULL, '1504040017', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3193', 'SORIA ', '2612983015', NULL, '2612983015', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3194', 'Felix Pallares ', '3636374013', NULL, '3636374013', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3195', 'Margarita cabrera Flores', '3286349', NULL, '3286349', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3196', 'Sandra Marisol Bacotich Arce d', '1887058019', NULL, '1887058019', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3197', 'Lelis Castillo Barrios ', '4124943012', NULL, '4124943012', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3198', ' Micael Vaca', '5638952018', NULL, '5638952018', NULL, NULL, NULL, NULL, NULL, '', '0');

### Structure of table `0_currencies` ###

DROP TABLE IF EXISTS `0_currencies`;

CREATE TABLE `0_currencies` (
  `currency` varchar(60) NOT NULL DEFAULT '',
  `curr_abrev` char(3) NOT NULL DEFAULT '',
  `curr_symbol` varchar(10) NOT NULL DEFAULT '',
  `country` varchar(100) NOT NULL DEFAULT '',
  `hundreds_name` varchar(15) NOT NULL DEFAULT '',
  `auto_update` tinyint(1) NOT NULL DEFAULT '1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`curr_abrev`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ;

### Data of table `0_currencies` ###

INSERT INTO `0_currencies` VALUES
('Bolivianos', 'BS', 'Bs', 'Bolivia', 'Centavos', '0', '0'),
('US Dollars', 'USD', '$', 'United States', 'Cents', '1', '0');

### Structure of table `0_cust_allocations` ###

DROP TABLE IF EXISTS `0_cust_allocations`;

CREATE TABLE `0_cust_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB AUTO_INCREMENT=435 DEFAULT CHARSET=latin1 ;

### Data of table `0_cust_allocations` ###

INSERT INTO `0_cust_allocations` VALUES
('1', '500', '2017-07-19', '1', '12', '2', '10'),
('2', '179', '2017-09-15', '1', '12', '2', '10'),
('3', '358', '2017-09-15', '2', '12', '3', '10'),
('4', '149', '2017-09-15', '3', '12', '4', '10'),
('5', '477', '2017-09-15', '4', '12', '5', '10'),
('6', '179', '2017-09-15', '5', '12', '6', '10'),
('7', '149', '2017-09-15', '6', '12', '7', '10'),
('8', '358', '2017-09-15', '7', '12', '8', '10'),
('9', '328', '2017-09-15', '8', '12', '9', '10'),
('10', '298', '2017-09-15', '9', '12', '10', '10'),
('11', '98', '2017-09-15', '10', '12', '11', '10'),
('12', '98', '2017-09-15', '11', '12', '12', '10'),
('13', '98', '2017-09-15', '12', '12', '13', '10'),
('14', '98', '2017-09-15', '13', '12', '14', '10'),
('15', '98', '2017-09-15', '14', '12', '15', '10'),
('16', '98', '2017-09-15', '15', '12', '16', '10'),
('17', '98', '2017-09-15', '16', '12', '17', '10'),
('18', '328', '2017-09-15', '17', '12', '18', '10'),
('19', '298', '2017-09-15', '18', '12', '19', '10'),
('20', '98', '2017-09-15', '19', '12', '20', '10'),
('21', '98', '2017-09-15', '20', '12', '21', '10'),
('22', '98', '2017-09-15', '21', '12', '22', '10'),
('23', '98', '2017-09-15', '22', '12', '23', '10'),
('24', '98', '2017-09-15', '23', '12', '24', '10'),
('25', '98', '2017-09-15', '24', '12', '25', '10'),
('26', '98', '2017-09-15', '25', '12', '26', '10'),
('27', '98', '2017-09-15', '26', '12', '27', '10'),
('28', '98', '2017-09-15', '27', '12', '28', '10'),
('29', '1600', '2017-09-16', '28', '12', '29', '10'),
('30', '98', '2017-09-18', '29', '12', '30', '10'),
('31', '98', '2017-09-18', '30', '12', '31', '10'),
('32', '98', '2017-09-18', '31', '12', '32', '10'),
('33', '98', '2017-09-18', '32', '12', '33', '10'),
('34', '98', '2017-09-18', '33', '12', '34', '10'),
('35', '179', '2017-09-18', '34', '12', '35', '10'),
('36', '98', '2017-09-18', '35', '12', '36', '10'),
('37', '98', '2017-09-18', '36', '12', '37', '10'),
('38', '88', '2017-09-18', '37', '12', '38', '10'),
('39', '98', '2017-09-18', '38', '12', '39', '10'),
('40', '98', '2017-09-18', '39', '12', '40', '10'),
('41', '98', '2017-09-18', '40', '12', '41', '10'),
('42', '98', '2017-09-18', '41', '12', '42', '10'),
('43', '98', '2017-09-18', '42', '12', '43', '10'),
('44', '98', '2017-09-18', '43', '12', '44', '10'),
('45', '98', '2017-09-18', '44', '12', '45', '10'),
('46', '98', '2017-09-18', '45', '12', '46', '10'),
('47', '98', '2017-09-18', '46', '12', '47', '10'),
('48', '98', '2017-09-18', '47', '12', '48', '10'),
('49', '98', '2017-09-18', '48', '12', '49', '10'),
('50', '98', '2017-09-18', '49', '12', '50', '10'),
('51', '98', '2017-09-18', '50', '12', '51', '10'),
('52', '98', '2017-09-18', '51', '12', '52', '10'),
('53', '98', '2017-09-18', '52', '12', '53', '10'),
('54', '98', '2017-09-18', '53', '12', '54', '10'),
('55', '98', '2017-09-18', '54', '12', '55', '10'),
('56', '98', '2017-09-18', '55', '12', '56', '10'),
('57', '488', '2017-09-18', '56', '12', '57', '10'),
('58', '98', '2017-09-18', '57', '12', '58', '10'),
('59', '98', '2017-09-18', '58', '12', '59', '10'),
('60', '179', '2017-09-18', '59', '12', '60', '10'),
('61', '98', '2017-09-18', '60', '12', '61', '10'),
('62', '98', '2017-09-18', '61', '12', '62', '10'),
('63', '98', '2017-09-18', '62', '12', '63', '10'),
('64', '98', '2017-09-18', '63', '12', '64', '10'),
('65', '98', '2017-09-18', '64', '12', '65', '10'),
('66', '98', '2017-09-18', '65', '12', '66', '10'),
('67', '98', '2017-09-18', '66', '12', '67', '10'),
('68', '98', '2017-09-18', '67', '12', '68', '10'),
('69', '98', '2017-09-18', '68', '12', '69', '10'),
('70', '179', '2017-09-18', '69', '12', '70', '10'),
('71', '98', '2017-09-18', '70', '12', '71', '10'),
('72', '98', '2017-09-18', '71', '12', '72', '10'),
('73', '98', '2017-09-18', '72', '12', '73', '10'),
('74', '98', '2017-09-18', '73', '12', '74', '10'),
('75', '358', '2017-09-18', '74', '12', '75', '10'),
('76', '98', '2017-09-18', '75', '12', '76', '10'),
('77', '98', '2017-09-18', '76', '12', '77', '10'),
('78', '98', '2017-09-18', '77', '12', '78', '10'),
('79', '98', '2017-09-18', '78', '12', '79', '10'),
('80', '98', '2017-09-18', '79', '12', '80', '10'),
('81', '98', '2017-09-18', '80', '12', '81', '10'),
('82', '98', '2017-09-19', '81', '12', '82', '10'),
('83', '98', '2017-09-19', '82', '12', '83', '10'),
('84', '98', '2017-09-19', '83', '12', '84', '10'),
('85', '358', '2017-09-19', '84', '12', '85', '10'),
('86', '98', '2017-09-19', '85', '12', '86', '10'),
('87', '98', '2017-09-19', '86', '12', '87', '10'),
('88', '98', '2017-09-19', '87', '12', '88', '10'),
('89', '328', '2017-09-19', '88', '12', '89', '10'),
('90', '98', '2017-09-19', '89', '12', '90', '10'),
('91', '98', '2017-09-19', '90', '12', '91', '10'),
('92', '98', '2017-09-19', '91', '12', '92', '10'),
('93', '98', '2017-09-19', '92', '12', '93', '10'),
('94', '98', '2017-09-19', '93', '12', '94', '10'),
('95', '98', '2017-09-19', '94', '12', '95', '10'),
('96', '98', '2017-09-19', '95', '12', '96', '10'),
('97', '98', '2017-09-19', '96', '12', '97', '10'),
('98', '98', '2017-09-19', '97', '12', '98', '10'),
('99', '239', '2017-09-19', '98', '12', '99', '10'),
('100', '98', '2017-09-19', '99', '12', '100', '10'),
('101', '98', '2017-09-19', '100', '12', '101', '10'),
('102', '98', '2017-09-19', '101', '12', '102', '10'),
('103', '98', '2017-09-19', '102', '12', '103', '10'),
('104', '98', '2017-09-19', '103', '12', '104', '10'),
('105', '98', '2017-09-19', '104', '12', '105', '10'),
('106', '98', '2017-09-19', '105', '12', '106', '10'),
('108', '179', '2017-09-19', '107', '12', '108', '10'),
('109', '98', '2017-09-19', '108', '12', '109', '10'),
('110', '98', '2017-09-19', '109', '12', '110', '10'),
('111', '98', '2017-09-20', '110', '12', '111', '10'),
('112', '98', '2017-09-20', '111', '12', '112', '10'),
('113', '98', '2017-09-20', '112', '12', '113', '10'),
('114', '98', '2017-09-20', '113', '12', '114', '10'),
('115', '98', '2017-09-20', '114', '12', '115', '10'),
('116', '98', '2017-09-20', '115', '12', '116', '10'),
('117', '98', '2017-09-20', '116', '12', '117', '10'),
('118', '98', '2017-09-20', '117', '12', '118', '10'),
('119', '98', '2017-09-20', '118', '12', '119', '10'),
('120', '98', '2017-09-20', '119', '12', '120', '10'),
('121', '98', '2017-09-20', '120', '12', '121', '10'),
('122', '98', '2017-09-20', '121', '12', '122', '10'),
('123', '98', '2017-09-20', '122', '12', '123', '10'),
('124', '98', '2017-09-20', '123', '12', '124', '10'),
('125', '98', '2017-09-20', '124', '12', '125', '10'),
('126', '98', '2017-09-20', '125', '12', '126', '10'),
('127', '98', '2017-09-21', '126', '12', '127', '10'),
('128', '358', '2017-09-21', '127', '12', '128', '10'),
('129', '98', '2017-09-21', '128', '12', '129', '10'),
('130', '98', '2017-09-21', '129', '12', '130', '10'),
('131', '98', '2017-09-21', '130', '12', '131', '10'),
('132', '98', '2017-09-21', '131', '12', '132', '10'),
('133', '98', '2017-09-21', '132', '12', '133', '10'),
('134', '98', '2017-09-21', '133', '12', '134', '10'),
('135', '88', '2017-09-21', '134', '12', '135', '10'),
('136', '98', '2017-09-21', '135', '12', '136', '10'),
('137', '179', '2017-09-21', '136', '12', '137', '10'),
('138', '98', '2017-09-21', '137', '12', '138', '10'),
('139', '98', '2017-09-21', '138', '12', '139', '10'),
('140', '98', '2017-09-21', '139', '12', '140', '10'),
('141', '98', '2017-09-21', '140', '12', '141', '10'),
('142', '98', '2017-09-21', '141', '12', '142', '10'),
('143', '98', '2017-09-21', '142', '12', '143', '10'),
('144', '500', '2017-09-25', '143', '12', '144', '10'),
('145', '179', '2017-09-25', '144', '12', '145', '10'),
('146', '98', '2017-09-25', '145', '12', '146', '10'),
('147', '88', '2017-09-25', '146', '12', '147', '10'),
('148', '98', '2017-09-25', '147', '12', '148', '10'),
('149', '239', '2017-09-25', '148', '12', '149', '10'),
('150', '98', '2017-09-25', '149', '12', '150', '10'),
('151', '98', '2017-09-25', '150', '12', '151', '10'),
('152', '98', '2017-09-25', '151', '12', '152', '10'),
('153', '98', '2017-09-25', '152', '12', '153', '10'),
('154', '98', '2017-09-25', '153', '12', '154', '10'),
('155', '98', '2017-09-25', '154', '12', '155', '10'),
('156', '729', '2017-09-25', '155', '12', '156', '10'),
('157', '100', '2017-09-25', '156', '12', '157', '10'),
('158', '98', '2017-09-25', '157', '12', '158', '10'),
('159', '298', '2017-09-27', '158', '12', '159', '10'),
('160', '298', '2017-09-27', '159', '12', '160', '10'),
('161', '98', '2017-09-27', '160', '12', '161', '10'),
('162', '350', '2017-09-27', '161', '12', '162', '10'),
('163', '98', '2017-09-27', '162', '12', '163', '10'),
('164', '98', '2017-09-27', '163', '12', '164', '10'),
('165', '98', '2017-09-27', '164', '12', '165', '10'),
('166', '98', '2017-09-27', '165', '12', '166', '10'),
('167', '418', '2017-09-27', '166', '12', '167', '10'),
('168', '328', '2017-09-27', '167', '12', '168', '10'),
('169', '98', '2017-09-27', '168', '12', '169', '10'),
('170', '98', '2017-09-27', '169', '12', '170', '10'),
('171', '100', '2017-09-29', '170', '12', '171', '10'),
('172', '98', '2017-09-29', '171', '12', '172', '10'),
('173', '98', '2017-09-29', '172', '12', '173', '10'),
('174', '98', '2017-09-29', '173', '12', '174', '10'),
('175', '98', '2017-09-29', '174', '12', '175', '10'),
('176', '98', '2017-09-29', '175', '12', '176', '10'),
('177', '179', '2017-09-29', '176', '12', '177', '10'),
('178', '98', '2017-09-29', '177', '12', '178', '10'),
('179', '98', '2017-09-29', '178', '12', '179', '10'),
('180', '98', '2017-09-29', '179', '12', '180', '10'),
('181', '98', '2017-09-29', '180', '12', '181', '10'),
('182', '98', '2017-09-29', '181', '12', '182', '10'),
('183', '490', '2017-09-29', '182', '12', '183', '10'),
('184', '418', '2017-10-02', '183', '12', '184', '10'),
('185', '98', '2017-10-02', '184', '12', '185', '10'),
('186', '98', '2017-10-02', '185', '12', '186', '10'),
('187', '98', '2017-10-02', '186', '12', '187', '10'),
('188', '179', '2017-10-02', '187', '12', '188', '10'),
('189', '179', '2017-10-02', '188', '12', '189', '10'),
('190', '639', '2017-10-02', '189', '12', '190', '10'),
('192', '98', '2017-10-02', '191', '12', '192', '10'),
('193', '418', '2017-10-02', '192', '12', '193', '10'),
('194', '98', '2017-10-02', '193', '12', '194', '10'),
('195', '98', '2017-10-02', '194', '12', '195', '10'),
('196', '88', '2017-10-02', '195', '12', '196', '10'),
('197', '98', '2017-10-02', '196', '12', '197', '10'),
('198', '768', '2017-10-02', '197', '12', '198', '10'),
('199', '98', '2017-10-02', '198', '12', '199', '10'),
('200', '98', '2017-10-02', '199', '12', '200', '10'),
('201', '499', '2017-10-02', '200', '12', '201', '10'),
('202', '239', '2017-10-02', '201', '12', '202', '10'),
('203', '98', '2017-10-03', '202', '12', '203', '10'),
('204', '179', '2017-10-03', '203', '12', '204', '10'),
('205', '98', '2017-10-03', '204', '12', '205', '10'),
('206', '98', '2017-10-03', '205', '12', '206', '10'),
('207', '98', '2017-10-03', '206', '12', '207', '10'),
('208', '179', '2017-10-03', '207', '12', '208', '10'),
('209', '98', '2017-10-03', '208', '12', '209', '10'),
('210', '98', '2017-10-03', '209', '12', '210', '10'),
('211', '98', '2017-10-03', '210', '12', '211', '10'),
('212', '98', '2017-10-03', '211', '12', '212', '10'),
('213', '98', '2017-10-03', '212', '12', '213', '10'),
('214', '98', '2017-10-03', '213', '12', '214', '10'),
('215', '98', '2017-10-05', '214', '12', '215', '10'),
('216', '149', '2017-10-05', '215', '12', '216', '10'),
('217', '350', '2017-10-05', '216', '12', '217', '10'),
('218', '98', '2017-10-05', '217', '12', '218', '10'),
('219', '98', '2017-10-05', '218', '12', '219', '10'),
('220', '98', '2017-10-05', '219', '12', '220', '10'),
('222', '98', '2017-10-05', '221', '12', '222', '10'),
('223', '98', '2017-10-05', '222', '12', '223', '10'),
('224', '98', '2017-10-05', '223', '12', '224', '10'),
('225', '98', '2017-10-05', '224', '12', '225', '10'),
('226', '328', '2017-10-05', '225', '12', '226', '10'),
('227', '580', '2017-10-05', '226', '12', '227', '10'),
('228', '100', '2017-10-06', '227', '12', '228', '10'),
('229', '98', '2017-10-06', '228', '12', '229', '10'),
('230', '98', '2017-10-06', '229', '12', '230', '10'),
('231', '98', '2017-10-06', '230', '12', '231', '10'),
('232', '98', '2017-10-06', '231', '12', '232', '10'),
('233', '328', '2017-10-09', '232', '12', '233', '10'),
('234', '98', '2017-10-10', '233', '12', '234', '10'),
('235', '98', '2017-10-11', '234', '12', '235', '10'),
('236', '98', '2017-10-11', '235', '12', '236', '10'),
('237', '98', '2017-10-11', '236', '12', '237', '10'),
('238', '669', '2017-10-11', '237', '12', '238', '10'),
('239', '98', '2017-10-11', '238', '12', '239', '10'),
('240', '98', '2017-10-11', '239', '12', '240', '10'),
('241', '98', '2017-10-11', '240', '12', '241', '10'),
('242', '98', '2017-10-11', '241', '12', '242', '10'),
('243', '98', '2017-10-11', '242', '12', '243', '10'),
('244', '98', '2017-10-11', '243', '12', '244', '10'),
('245', '98', '2017-10-11', '244', '12', '245', '10'),
('246', '179', '2017-10-11', '245', '12', '246', '10'),
('247', '98', '2017-10-11', '246', '12', '247', '10'),
('248', '98', '2017-10-12', '247', '12', '248', '10'),
('249', '499', '2017-10-12', '248', '12', '249', '10'),
('250', '98', '2017-10-12', '249', '12', '250', '10'),
('251', '149', '2017-10-12', '250', '12', '251', '10'),
('252', '98', '2017-10-12', '251', '12', '252', '10'),
('253', '98', '2017-10-12', '252', '12', '253', '10'),
('254', '149', '2017-10-12', '253', '12', '254', '10'),
('255', '98', '2017-10-12', '254', '12', '255', '10'),
('256', '98', '2017-10-12', '255', '12', '256', '10'),
('257', '350', '2017-10-12', '256', '12', '257', '10'),
('258', '98', '2017-10-12', '257', '12', '258', '10'),
('259', '149', '2017-10-12', '258', '12', '259', '10'),
('260', '98', '2017-10-12', '259', '12', '260', '10'),
('261', '98', '2017-10-12', '260', '12', '261', '10'),
('262', '179', '2017-10-13', '261', '12', '262', '10'),
('263', '179', '2017-10-13', '262', '12', '263', '10'),
('264', '98', '2017-10-13', '263', '12', '264', '10'),
('265', '98', '2017-10-13', '264', '12', '265', '10'),
('267', '179', '2017-10-13', '266', '12', '267', '10'),
('268', '179', '2017-10-13', '267', '12', '268', '10'),
('269', '149', '2017-10-17', '268', '12', '269', '10'),
('270', '98', '2017-10-17', '269', '12', '270', '10'),
('271', '358', '2017-10-17', '270', '12', '271', '10'),
('272', '98', '2017-10-17', '271', '12', '272', '10'),
('273', '358', '2017-10-17', '272', '12', '273', '10'),
('274', '239', '2017-10-17', '273', '12', '274', '10'),
('275', '350', '2017-10-17', '274', '12', '275', '10'),
('276', '98', '2017-10-17', '275', '12', '276', '10'),
('277', '358', '2017-10-17', '276', '12', '277', '10'),
('278', '179', '2017-10-17', '277', '12', '278', '10'),
('279', '418', '2017-10-17', '278', '12', '279', '10'),
('280', '98', '2017-10-17', '279', '12', '280', '10'),
('281', '98', '2017-10-17', '280', '12', '281', '10'),
('282', '350', '2017-10-17', '281', '12', '282', '10'),
('283', '98', '2017-10-19', '282', '12', '283', '10'),
('284', '98', '2017-10-19', '283', '12', '284', '10'),
('285', '98', '2017-10-19', '284', '12', '285', '10'),
('286', '418', '2017-10-19', '285', '12', '286', '10'),
('287', '328', '2017-10-19', '286', '12', '287', '10'),
('288', '239', '2017-10-19', '287', '12', '288', '10'),
('289', '418', '2017-10-19', '288', '12', '289', '10'),
('290', '98', '2017-10-19', '289', '12', '290', '10'),
('291', '179', '2017-10-19', '290', '12', '291', '10'),
('292', '98', '2017-10-19', '291', '12', '292', '10'),
('293', '149', '2017-10-19', '292', '12', '293', '10'),
('294', '98', '2017-10-19', '293', '12', '294', '10'),
('295', '98', '2017-10-19', '294', '12', '295', '10'),
('296', '179', '2017-10-19', '295', '12', '296', '10'),
('297', '337', '2017-10-19', '296', '12', '297', '10'),
('298', '98', '2017-10-23', '297', '12', '298', '10'),
('299', '98', '2017-10-23', '298', '12', '299', '10'),
('300', '418', '2017-10-23', '299', '12', '300', '10'),
('301', '98', '2017-10-23', '300', '12', '301', '10'),
('302', '100', '2017-10-23', '301', '12', '302', '10'),
('303', '98', '2017-10-23', '302', '12', '303', '10'),
('304', '98', '2017-10-23', '303', '12', '304', '10'),
('305', '478', '2017-10-23', '304', '12', '305', '10'),
('306', '98', '2017-10-23', '305', '12', '306', '10'),
('307', '100', '2017-10-23', '306', '12', '307', '10'),
('308', '100', '2017-10-23', '307', '12', '308', '10'),
('309', '179', '2017-10-23', '308', '12', '309', '10'),
('310', '149', '2017-10-25', '309', '12', '310', '10'),
('311', '400', '2017-10-25', '310', '12', '311', '10'),
('312', '98', '2017-10-25', '311', '12', '312', '10'),
('313', '388', '2017-10-25', '312', '12', '313', '10'),
('314', '98', '2017-10-25', '313', '12', '314', '10'),
('315', '490', '2017-10-25', '314', '12', '315', '10'),
('316', '98', '2017-10-25', '315', '12', '316', '10'),
('317', '98', '2017-10-25', '316', '12', '317', '10'),
('318', '100', '2017-10-25', '317', '12', '318', '10'),
('319', '98', '2017-10-25', '318', '12', '319', '10'),
('320', '98', '2017-10-25', '319', '12', '320', '10'),
('321', '418', '2017-10-25', '320', '12', '321', '10'),
('322', '98', '2017-10-27', '321', '12', '322', '10'),
('323', '98', '2017-10-27', '322', '12', '323', '10'),
('324', '418', '2017-10-27', '323', '12', '324', '10'),
('325', '98', '2017-10-27', '324', '12', '325', '10'),
('326', '98', '2017-10-27', '325', '12', '326', '10'),
('327', '249', '2017-10-27', '326', '12', '327', '10'),
('328', '98', '2017-10-27', '327', '12', '328', '10'),
('329', '179', '2017-10-27', '328', '12', '329', '10'),
('330', '98', '2017-11-03', '329', '12', '330', '10'),
('331', '98', '2017-11-06', '330', '12', '331', '10'),
('332', '98', '2017-11-06', '331', '12', '332', '10'),
('333', '98', '2017-11-07', '332', '12', '333', '10'),
('334', '179', '2017-11-07', '333', '12', '334', '10'),
('335', '239', '2017-11-07', '334', '12', '335', '10'),
('336', '98', '2017-11-07', '335', '12', '336', '10'),
('337', '388', '2017-11-07', '336', '12', '337', '10'),
('338', '98', '2017-11-07', '337', '12', '338', '10'),
('339', '179', '2017-11-07', '338', '12', '339', '10'),
('340', '98', '2017-11-07', '339', '12', '340', '10'),
('341', '88', '2017-11-07', '340', '12', '341', '10'),
('342', '418', '2017-11-07', '341', '12', '342', '10'),
('343', '418', '2017-11-07', '342', '12', '343', '10'),
('344', '490', '2017-11-07', '343', '12', '344', '10'),
('345', '180', '2017-11-07', '344', '12', '345', '10'),
('346', '298', '2017-11-07', '345', '12', '346', '10'),
('347', '98', '2017-11-07', '346', '12', '347', '10'),
('353', '1', '2017-11-07', '352', '12', '353', '10'),
('354', '477', '2017-11-07', '353', '12', '354', '10'),
('355', '98', '2017-11-07', '354', '12', '355', '10'),
('356', '180', '2017-11-07', '355', '12', '356', '10'),
('357', '100', '2017-11-14', '356', '12', '369', '10'),
('358', '209', '2017-11-23', '357', '12', '418', '10'),
('359', '209', '2017-11-23', '358', '12', '436', '10'),
('360', '245', '2017-11-28', '359', '12', '462', '10'),
('361', '245', '2017-11-28', '360', '12', '489', '10'),
('362', '245', '2017-11-28', '361', '12', '508', '10'),
('363', '200', '2017-11-28', '362', '12', '529', '10'),
('364', '245', '2017-11-28', '363', '12', '540', '10'),
('365', '75', '2017-11-28', '364', '12', '543', '10'),
('366', '165', '2017-11-28', '365', '12', '567', '10'),
('367', '245', '2017-11-30', '366', '12', '645', '10'),
('368', '490', '2017-11-30', '367', '12', '705', '10'),
('369', '50', '2017-12-05', '368', '12', '740', '10'),
('370', '350', '2017-12-28', '369', '12', '795', '10'),
('371', '580', '2018-01-10', '370', '12', '837', '10'),
('372', '419', '2018-01-26', '371', '12', '943', '10'),
('373', '179', '2018-01-31', '372', '12', '958', '10'),
('374', '329', '2018-02-02', '373', '12', '993', '10'),
('375', '378', '2018-02-05', '374', '12', '1022', '10'),
('376', '179', '2018-02-05', '375', '12', '1023', '10'),
('377', '388', '2018-02-08', '376', '12', '1083', '10'),
('378', '490', '2018-02-19', '377', '12', '1145', '10'),
('379', '149', '2018-03-08', '378', '12', '1253', '10'),
('380', '477', '2018-03-09', '379', '12', '1305', '10'),
('381', '149', '2018-03-09', '380', '12', '1310', '10'),
('382', '149', '2018-03-09', '381', '12', '1314', '10'),
('383', '500', '2018-03-09', '382', '12', '1321', '10'),
('384', '428', '2018-03-22', '383', '12', '1439', '10'),
('385', '249', '2018-03-22', '384', '12', '1444', '10'),
('386', '490', '2018-03-23', '385', '12', '1469', '10'),
('387', '249', '2018-03-23', '386', '12', '1476', '10'),
('388', '398', '2018-03-29', '387', '12', '1624', '10'),
('389', '249', '2018-04-04', '388', '12', '1700', '10'),
('390', '249', '2018-04-10', '389', '12', '1788', '10'),
('391', '249', '2018-04-10', '390', '12', '1789', '10'),
('392', '149', '2018-04-18', '391', '12', '1869', '10'),
('393', '580', '2018-04-18', '392', '12', '1881', '10'),
('394', '490', '2018-05-07', '393', '12', '2046', '10'),
('395', '150', '2018-05-12', '394', '12', '2075', '10'),
('396', '149', '2018-05-23', '395', '12', '2145', '10'),
('397', '350', '2018-05-23', '396', '12', '2147', '10'),
('398', '249', '2018-05-23', '397', '12', '2150', '10'),
('399', '179', '2018-05-29', '398', '12', '2168', '10'),
('400', '490', '2018-06-02', '399', '12', '2183', '10'),
('401', '149', '2018-06-13', '400', '12', '2239', '10'),
('402', '89', '2018-06-18', '401', '12', '2253', '10'),
('403', '328', '2018-06-23', '402', '12', '2272', '10'),
('404', '350', '2018-06-23', '403', '12', '2273', '10'),
('405', '350', '2018-07-13', '404', '12', '2345', '10'),
('406', '98', '2018-07-13', '405', '12', '2352', '10'),
('407', '398', '2018-07-20', '406', '12', '2389', '10'),
('409', '149', '2018-07-26', '408', '12', '2410', '10'),
('410', '179', '2018-10-01', '409', '12', '2638', '10'),
('411', '179', '2018-10-02', '410', '12', '2670', '10'),
('412', '179', '2018-10-02', '411', '12', '2678', '10'),
('413', '149', '2018-10-05', '412', '12', '2715', '10'),
('414', '179', '2018-10-05', '413', '12', '2719', '10'),
('415', '179', '2018-10-08', '414', '12', '2731', '10'),
('416', '179', '2018-10-18', '415', '12', '2858', '10'),
('417', '676', '2018-10-29', '416', '12', '2949', '10'),
('418', '427', '2018-10-29', '417', '12', '2959', '10'),
('419', '248', '2018-10-29', '418', '12', '2962', '10'),
('420', '427', '2018-10-29', '419', '12', '2969', '10'),
('421', '427', '2018-10-29', '420', '12', '2970', '10'),
('422', '350', '2018-10-30', '421', '12', '3002', '10'),
('424', '248', '2018-11-06', '423', '12', '3034', '10'),
('425', '248', '2018-11-08', '424', '12', '3068', '10'),
('426', '248', '2018-11-14', '425', '12', '3099', '10'),
('427', '248', '2018-11-20', '426', '12', '3152', '10'),
('428', '249', '2018-12-17', '427', '12', '3468', '10'),
('429', '89', '2018-12-18', '428', '12', '3476', '10'),
('430', '89', '2019-01-08', '429', '12', '3522', '10'),
('431', '89', '2019-03-19', '430', '12', '3937', '10'),
('433', '250', '2019-03-22', '432', '12', '3974', '10'),
('434', '248', '2019-03-29', '433', '12', '4039', '10');

### Structure of table `0_cust_branch` ###

DROP TABLE IF EXISTS `0_cust_branch`;

CREATE TABLE `0_cust_branch` (
  `branch_code` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_no` int(11) NOT NULL DEFAULT '0',
  `br_name` varchar(60) NOT NULL DEFAULT '',
  `branch_ref` varchar(30) NOT NULL DEFAULT '',
  `br_address` tinytext NOT NULL,
  `area` int(11) DEFAULT NULL,
  `salesman` int(11) NOT NULL DEFAULT '0',
  `contact_name` varchar(60) NOT NULL DEFAULT '',
  `default_location` varchar(5) NOT NULL DEFAULT '',
  `tax_group_id` int(11) DEFAULT NULL,
  `sales_account` varchar(15) NOT NULL DEFAULT '',
  `sales_discount_account` varchar(15) NOT NULL DEFAULT '',
  `receivables_account` varchar(15) NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) NOT NULL DEFAULT '',
  `default_ship_via` int(11) NOT NULL DEFAULT '1',
  `disable_trans` tinyint(4) NOT NULL DEFAULT '0',
  `br_post_address` tinytext NOT NULL,
  `group_no` int(11) NOT NULL DEFAULT '0',
  `notes` tinytext NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`branch_code`,`debtor_no`),
  KEY `branch_code` (`branch_code`),
  KEY `branch_ref` (`branch_ref`),
  KEY `group_no` (`group_no`)
) ENGINE=MyISAM AUTO_INCREMENT=3201 DEFAULT CHARSET=latin1 ;

### Data of table `0_cust_branch` ###

INSERT INTO `0_cust_branch` VALUES
('1', '1', 'Vladimir Nabokov', 'Vladimir Nabokov', 'Calle pririta n 15', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'Calle pririta n 15', '0', '', '0'),
('3', '3', 'Perez', '10104598', '10104598', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '10104598', '0', '', '0'),
('4', '4', 'Ramirez', '454654654', '454654654', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '454654654', '0', '', '0'),
('5', '5', 'DOMINGO SANCHEZ EGUEZ', '3296545', '3296545', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3296545', '0', '', '0'),
('6', '6', 'MARCO SILVA', 'm_silva_2002@hotmail.com', 'm_silva_2002@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'm_silva_2002@hotmail.com', '0', '', '0'),
('7', '7', 'SAVI S.R.L.', 'marlitorivas@hotmail.com', 'marlitorivas@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'marlitorivas@hotmail.com', '0', '', '0'),
('8', '8', 'Ricardo Roda', 'migrabol.scz@gmail.com', 'migrabol.scz@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'migrabol.scz@gmail.com', '0', '', '0'),
('9', '9', 'EDGAR MAMANI QUISPE', 'quismas70@hotmail.com', 'quismas70@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'quismas70@hotmail.com', '0', '', '0'),
('10', '10', 'CENTRO DE ESTUDIOS Y APOYO AL DESARROLLO LOCAL', 'vicoalano@gmail.com', 'vicoalano@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'vicoalano@gmail.com', '0', '', '0'),
('11', '11', 'ROMY MONTENEGRO', 'romisita_13@hotmail.com', 'romisita_13@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'romisita_13@hotmail.com', '0', '', '0'),
('12', '12', 'TOBOROCHI SUITES S.R.L.', 'ritzerflores1982@gmail.com', 'ritzerflores1982@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'ritzerflores1982@gmail.com', '0', '', '0'),
('13', '13', 'EFRAIN TIINI TIINI', 'efra_tiin@hotmail.com', 'efra_tiin@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'efra_tiin@hotmail.com', '0', '', '0'),
('14', '14', 'YVANA ARREDONDO CORIA', 'yvanarredondo@hotmail.com', 'yvanarredondo@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'yvanarredondo@hotmail.com', '0', '', '0'),
('15', '15', 'Erwin Galarza Velasco', 'erwingv24@gmail.com', 'erwingv24@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'erwingv24@gmail.com', '0', '', '0'),
('16', '16', 'IBERICA S.R.L.', 'rbalcazar@ibericasrl.com', 'rbalcazar@ibericasrl.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'rbalcazar@ibericasrl.com', '0', '', '0'),
('17', '17', 'MARCELA JUSTINIANO', 'cvargasz@gmail.com', 'cvargasz@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'cvargasz@gmail.com', '0', '', '0'),
('18', '18', 'DIGITALWORK S.A.', 'ccartagena@vuela.bo', 'ccartagena@vuela.bo', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'ccartagena@vuela.bo', '0', '', '0'),
('19', '19', 'RAMOS', 'juan.ramos@laqfagal.com', 'juan.ramos@laqfagal.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'juan.ramos@laqfagal.com', '0', '', '0'),
('20', '20', 'MICHAEL AVILA', 'jmas_26@hotmail.com', 'jmas_26@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'jmas_26@hotmail.com', '0', '', '0'),
('21', '21', 'SOFGOM S.R.L.', 'info@sofgom.com', 'info@sofgom.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'info@sofgom.com', '0', '', '0'),
('22', '22', 'DAVID BELTRAN', 'contadordb@outlook.com', 'contadordb@outlook.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'contadordb@outlook.com', '0', '', '0'),
('23', '23', 'Argandoa', 'vjavier.arg@gmail.com', 'vjavier.arg@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'vjavier.arg@gmail.com', '0', '', '0'),
('24', '24', 'P.A.D.I.C. S.R.L.', 'jchirveches@padic-srl.com', 'jchirveches@padic-srl.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'jchirveches@padic-srl.com', '0', '', '0'),
('25', '25', 'Leandro Tumiri Lazcano', 'lean_305@hotmail.com', 'lean_305@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'lean_305@hotmail.com', '0', '', '0'),
('26', '26', 'Pelaez ', 'priscilapelaezzeballos@hotmail', 'priscilapelaezzeballos@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'priscilapelaezzeballos@hotmail.com', '0', '', '0'),
('27', '27', 'Denard Mendez', 'dmendezperez@hotmail.com', 'dmendezperez@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'dmendezperez@hotmail.com', '0', '', '0'),
('28', '28', 'DYL CHACO LTDA.', 'sebastian.majlufbw@gmail.com', 'sebastian.majlufbw@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'sebastian.majlufbw@gmail.com', '0', '', '0'),
('29', '29', 'ODESPRO S.R.L.', 'mcaceres@odespro.com', 'mcaceres@odespro.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'mcaceres@odespro.com', '0', '', '0'),
('30', '30', 'Junior Galvao', 'junior.galvao.h@gmail.com', 'junior.galvao.h@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'junior.galvao.h@gmail.com', '0', '', '0'),
('31', '31', 'PREFORTE S.A.', 'mrevollo@preforte.com.bo', 'mrevollo@preforte.com.bo', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'mrevollo@preforte.com.bo', '0', '', '0'),
('32', '32', 'DOMINGO SANCHEZ EGUEZ', 'mingoeguez@hotmail.com', 'mingoeguez@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'mingoeguez@hotmail.com', '0', '', '0'),
('33', '33', 'TELEFERICOS DOPPELMAYR BOLIVIA S.A.', 'adrian.ledezma@doppelmayr.com', 'adrian.ledezma@doppelmayr.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'adrian.ledezma@doppelmayr.com', '0', '', '0'),
('34', '34', 'EVIA', 'fabianlozapaz@gmail.com', 'fabianlozapaz@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'fabianlozapaz@gmail.com', '0', '', '0'),
('35', '35', 'Pacheco', 'belaiso08@gmail.com', 'belaiso08@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'belaiso08@gmail.com', '0', '', '0'),
('36', '36', 'AUDIADMI S.R.L. AUDITORES Y CONSULTORES', 'francuve79@hotmail.com', 'francuve79@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'francuve79@hotmail.com', '0', '', '0'),
('37', '37', 'HAROLD ALMARAZ S.', 'aldo.aramayo04@hotmail.com', 'aldo.aramayo04@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'aldo.aramayo04@hotmail.com', '0', '', '0'),
('38', '38', 'LIDIA GUARACHI CHIPATA', 'nurkis_18@hotmail.com', 'nurkis_18@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'nurkis_18@hotmail.com', '0', '', '0'),
('39', '39', 'GRUPO PALANTIR S.R.L.', 'zaulo.vasquez@gmail.com', 'zaulo.vasquez@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'zaulo.vasquez@gmail.com', '0', '', '0'),
('40', '40', 'Miguel Sirpa', 'miguel.sirpa@gmail.com', 'miguel.sirpa@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'miguel.sirpa@gmail.com', '0', '', '0'),
('41', '41', 'Giovanna Gutierrez', 'giovannagutierrezfa@hotmail.co', 'giovannagutierrezfa@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'giovannagutierrezfa@hotmail.com', '0', '', '0'),
('42', '42', 'BP-TEK S.R.L.', 'melisa_pardo@hotmail.com', 'melisa_pardo@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'melisa_pardo@hotmail.com', '0', '', '0'),
('43', '43', 'Ramos Calderon Auditores S.R.L.', 'ramiro_calderon76@hotmail.com', 'ramiro_calderon76@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'ramiro_calderon76@hotmail.com', '0', '', '0'),
('44', '44', 'MCOM S.R.L.', 'omedina_rojo@hotmail.com', 'omedina_rojo@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'omedina_rojo@hotmail.com', '0', '', '0'),
('45', '45', 'Juan Paolo Paris Siles', 'sercontpyt@gmail.com', 'sercontpyt@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'sercontpyt@gmail.com', '0', '', '0'),
('46', '46', 'SABIAZUL S.R.L.', 're_esed@hotmail.com', 're_esed@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 're_esed@hotmail.com', '0', '', '0'),
('47', '47', 'RODRIGUEZ', 'jmarisolqm@hotmail.com', 'jmarisolqm@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'jmarisolqm@hotmail.com', '0', '', '0'),
('48', '48', 'HERRERA', 'herrera.heydi@gmail.com', 'herrera.heydi@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'herrera.heydi@gmail.com', '0', '', '0'),
('49', '49', 'FLORES ', 'rfloresadrian@gmail.com', 'rfloresadrian@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'rfloresadrian@gmail.com', '0', '', '0'),
('50', '50', 'CARMEN TINCUTA VALENCIA', 'tv.karmen@gmail.com', 'tv.karmen@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'tv.karmen@gmail.com', '0', '', '0'),
('51', '51', 'Carolina Fernndez Choque', 'consultorahuarache@gmail.com', 'consultorahuarache@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'consultorahuarache@gmail.com', '0', '', '0'),
('52', '52', 'Nitza Morales', 'nitzamorales@gmail.com', 'nitzamorales@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'nitzamorales@gmail.com', '0', '', '0'),
('53', '53', 'COPERAGRA S.R.L.', 'vargaslorgio@gmail.com', 'vargaslorgio@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'vargaslorgio@gmail.com', '0', '', '0'),
('54', '54', 'Enrique Luis Cruz Villarroel', 'marcia_montano_s@hotmail.com', 'marcia_montano_s@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'marcia_montano_s@hotmail.com', '0', '', '0'),
('55', '55', 'Bohiva Engineering S.R.L.', 'rrg@bohiva.com', 'rrg@bohiva.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'rrg@bohiva.com', '0', '', '0'),
('56', '56', 'Laboratorio Bio Medic S.R.L.', 'dbiomedic.2015@hotmail.com', 'dbiomedic.2015@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'dbiomedic.2015@hotmail.com', '0', '', '0'),
('57', '57', 'ORTIZ', 'jortiz_salas@hotmail.com', 'jortiz_salas@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'jortiz_salas@hotmail.com', '0', '', '0'),
('58', '58', 'Christian Lpez', 'chris.w.lopez@gmail.com', 'chris.w.lopez@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'chris.w.lopez@gmail.com', '0', '', '0'),
('59', '59', 'Gitec Consult GmbH Sucursal Bolivia', 'jj.castro@gitec-consult.com', 'jj.castro@gitec-consult.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'jj.castro@gitec-consult.com', '0', '', '0'),
('60', '60', 'SOTCO LTDA.', 'sotco.cotizaciones@gmail.com', 'sotco.cotizaciones@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'sotco.cotizaciones@gmail.com', '0', '', '0'),
('61', '61', 'Augusto Silicuana', 'asilicuana@hotmail.com', 'asilicuana@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'asilicuana@hotmail.com', '0', '', '0'),
('62', '62', 'WIDMAN INTERNATIONAL S.R.L.', 'miguelangel.rocha@widman.biz', 'miguelangel.rocha@widman.biz', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'miguelangel.rocha@widman.biz', '0', '', '0'),
('63', '63', 'PABLO JIMENEZ SANTA CRUZ', 'pablo_jsc76@outlook.com', 'pablo_jsc76@outlook.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'pablo_jsc76@outlook.com', '0', '', '0'),
('64', '64', 'Daniel Perez', 'dperezz@gmail.com', 'dperezz@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'dperezz@gmail.com', '0', '', '0'),
('65', '65', 'Jhonny Montao Ramirez', 'kadmielbolivia@hotmail.com', 'kadmielbolivia@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'kadmielbolivia@hotmail.com', '0', '', '0'),
('66', '66', 'Audiwork S.R.L.', 'juanjitoramos@gmail.com', 'juanjitoramos@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'juanjitoramos@gmail.com', '0', '', '0'),
('67', '67', 'JUAN CARLOS GUZMAN', 'g-asesores@hotmail.com', 'g-asesores@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'g-asesores@hotmail.com', '0', '', '0'),
('68', '68', 'HERRERA', 'giovannaherrera23@hotmail.com', 'giovannaherrera23@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'giovannaherrera23@hotmail.com', '0', '', '0'),
('69', '69', 'David Manzano Souza', 'gerencia.rialtopatrol@hotmail.', 'gerencia.rialtopatrol@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'gerencia.rialtopatrol@hotmail.com', '0', '', '0'),
('70', '70', 'Rioyata Madera Import. Export. S.R.L.', 'chalicito74@hotmail.com', 'chalicito74@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'chalicito74@hotmail.com', '0', '', '0'),
('71', '71', 'UNIVERSAL BROKERS S.A.', 'xavier.palenque@unibrosa.com.b', 'xavier.palenque@unibrosa.com.bo', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'xavier.palenque@unibrosa.com.bo', '0', '', '0'),
('72', '72', 'Flores', 'christian.sin.faan@gmail.com', 'christian.sin.faan@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'christian.sin.faan@gmail.com', '0', '', '0'),
('73', '73', 'Freddy Gutirrez', 'freddygutierrez@outlook.com', 'freddygutierrez@outlook.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'freddygutierrez@outlook.com', '0', '', '0'),
('74', '74', 'MOAN S.R.L.', 'kennethapaza@gmail.com', 'kennethapaza@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'kennethapaza@gmail.com', '0', '', '0'),
('75', '75', 'CENTRO DE INVESTIGACIONES Y DESARROLLO INTEGRAL DE LAS COMUN', 'ana_churqui@hotmail.com', 'ana_churqui@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'ana_churqui@hotmail.com', '0', '', '0'),
('76', '76', 'INMOBILIARIA UBC S.R.L.', 'rcanedo101@gmail.com', 'rcanedo101@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'rcanedo101@gmail.com', '0', '', '0'),
('77', '77', 'MARIA YSABEL MENACHO MORRORE', 'mariaysabel_mm75@hotmail.com', 'mariaysabel_mm75@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'mariaysabel_mm75@hotmail.com', '0', '', '0'),
('78', '78', 'LOPEZ MUJICA S.R.L.', 'lopezmujica.asociados@gmail.co', 'lopezmujica.asociados@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'lopezmujica.asociados@gmail.com', '0', '', '0'),
('79', '79', 'PABLO ROCA', 'procaspt@gmail.com', 'procaspt@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'procaspt@gmail.com', '0', '', '0'),
('80', '80', 'Ana Eisa Montao Flores', 'ana-eisamf@hotmail.com', 'ana-eisamf@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'ana-eisamf@hotmail.com', '0', '', '0'),
('81', '81', 'Marianela Salinas Montero', 'marianelasalinasmontero@gmail.', 'marianelasalinasmontero@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'marianelasalinasmontero@gmail.com', '0', '', '0'),
('82', '82', 'RAMIRO CHOQUE CHOQUE', 'ramiroadmconta@hotmail.com', 'ramiroadmconta@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'ramiroadmconta@hotmail.com', '0', '', '0'),
('83', '83', 'Eduardo Olivo', 'fparada@sudseguros.com', 'fparada@sudseguros.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'fparada@sudseguros.com', '0', '', '0'),
('84', '84', 'Edward Fernandez Zurita', 'edward.fernandez@fernandezcons', 'edward.fernandez@fernandezconsultores.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'edward.fernandez@fernandezconsultores.com', '0', '', '0'),
('85', '85', 'Rafael Agustin Tejada', 'administracion@metalurgicateja', 'administracion@metalurgicatejada.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'administracion@metalurgicatejada.com', '0', '', '0'),
('86', '86', 'Gonzales', 'm.elytabb@hotmail.com', 'm.elytabb@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'm.elytabb@hotmail.com', '0', '', '0'),
('87', '87', 'Edgar Delgado Quintana', 'edgar.delgadoquintana@gmail.co', 'edgar.delgadoquintana@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'edgar.delgadoquintana@gmail.com', '0', '', '0'),
('88', '88', 'Mano a Mano Internacional', 'ryusoalex@gmail.com', 'ryusoalex@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'ryusoalex@gmail.com', '0', '', '0'),
('89', '89', 'Tonconi', 'lucytm756@gmail.com', 'lucytm756@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'lucytm756@gmail.com', '0', '', '0'),
('90', '90', 'TERRAMIA S.A.', 'marcelo.cortez@terramiaresort.', 'marcelo.cortez@terramiaresort.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'marcelo.cortez@terramiaresort.com', '0', '', '0'),
('91', '91', 'FERNANDEZ', 'luz_fernandez_7@hotmail.com', 'luz_fernandez_7@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'luz_fernandez_7@hotmail.com', '0', '', '0'),
('92', '92', 'RAMIRO VELASQUEZ LA FUENTE', 'mividaperla@gmail.com', 'mividaperla@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'mividaperla@gmail.com', '0', '', '0'),
('93', '93', 'POK HA BEK S.R.L.', 'yavi_852@hotmail.com', 'yavi_852@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'yavi_852@hotmail.com', '0', '', '0'),
('94', '94', 'Manuel Robin Galindo Vale', 'mrgv1986@gmail.com', 'mrgv1986@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'mrgv1986@gmail.com', '0', '', '0'),
('95', '95', 'Omar Saucedo Franco', 'omsafran@gmail.com', 'omsafran@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'omsafran@gmail.com', '0', '', '0'),
('96', '96', 'LEBRAND S.R.L.', 'guiselasuarez@bpocenter.com.bo', 'guiselasuarez@bpocenter.com.bo', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'guiselasuarez@bpocenter.com.bo', '0', '', '0'),
('97', '97', 'ANGULO', 'nangulo@gruval.com', 'nangulo@gruval.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'nangulo@gruval.com', '0', '', '0'),
('98', '98', 'URBANOVA DESARROLLOS URBANOS S.R.L.', 'rmontano@micasamivida.bo', 'rmontano@micasamivida.bo', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'rmontano@micasamivida.bo', '0', '', '0'),
('99', '99', 'ESPINOZA', 'e_espinoza75@hotmail.com', 'e_espinoza75@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'e_espinoza75@hotmail.com', '0', '', '0'),
('100', '100', 'RAMON LEDEZMA ZAMBRANA', 'rledezmaz@hotmail.com', 'rledezmaz@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'rledezmaz@hotmail.com', '0', '', '0'),
('101', '101', 'ABEL GARCIA BLANCO', 'abel-garcia-blanco@hotmail.com', 'abel-garcia-blanco@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'abel-garcia-blanco@hotmail.com', '0', '', '0'),
('102', '102', 'Maria Angelica Calle Chambi', 'anyi.cch@gmail.com', 'anyi.cch@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'anyi.cch@gmail.com', '0', '', '0'),
('103', '103', 'NINA', 'nfaby22@hotmail.com', 'nfaby22@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'nfaby22@hotmail.com', '0', '', '0'),
('104', '104', 'Moises Huayta Morales', 'moihuaytam@hotmail.com', 'moihuaytam@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'moihuaytam@hotmail.com', '0', '', '0'),
('105', '105', 'EQUIPOS MORI S.R.L.', 'marcelomendivil@hotmail.com', 'marcelomendivil@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'marcelomendivil@hotmail.com', '0', '', '0'),
('106', '106', 'MARIBEL CRESPO SORIA', 'maribel_mafvaf@hotmail.com', 'maribel_mafvaf@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'maribel_mafvaf@hotmail.com', '0', '', '0'),
('107', '107', 'Virginia Soliz de Becerra', 'vsoliz_becerra@hotmail.com', 'vsoliz_becerra@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'vsoliz_becerra@hotmail.com', '0', '', '0'),
('108', '108', 'Nils Maldonado', 'nils_maldonado@sci.com.bo', 'nils_maldonado@sci.com.bo', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'nils_maldonado@sci.com.bo', '0', '', '0'),
('109', '109', 'INDSOL S.R.L.', 'gcornejo@ind-sol.com', 'gcornejo@ind-sol.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'gcornejo@ind-sol.com', '0', '', '0'),
('110', '110', 'MVO CONSTRUCCIONES &amp; SERVICIOS', 'dvillarroel@mvoconstrucciones.', 'dvillarroel@mvoconstrucciones.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'dvillarroel@mvoconstrucciones.com', '0', '', '0'),
('111', '111', 'CER LTDA.', 'tmacury25@hotmail.com', 'tmacury25@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'tmacury25@hotmail.com', '0', '', '0'),
('112', '112', 'EMPRESA CONSTRUCTORA GYC S.R.L.', 'hugocaballero1962@gmail.com', 'hugocaballero1962@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'hugocaballero1962@gmail.com', '0', '', '0'),
('113', '113', 'IRIARTE ROJAS', 'maria_luisa37@hotmail.com', 'maria_luisa37@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'maria_luisa37@hotmail.com', '0', '', '0'),
('114', '114', 'Nelo Stanley Pedrazas', 'o_gilda_klondy@hotmail.com', 'o_gilda_klondy@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'o_gilda_klondy@hotmail.com', '0', '', '0'),
('115', '115', 'Wilson Yavi Quiroz', 'wilson.yavi@outlook.com', 'wilson.yavi@outlook.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'wilson.yavi@outlook.com', '0', '', '0'),
('116', '116', 'Ezequiel Hurtado Aponte', 'ezequiel_hurtado@hotmail.com', 'ezequiel_hurtado@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'ezequiel_hurtado@hotmail.com', '0', '', '0'),
('117', '117', 'RAQUEL YOVANA TAPIA ESPINOZA', 'raquel.yovana.tapia.espinoza@', 'raquel.yovana.tapia.espinoza@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'raquel.yovana.tapia.espinoza@hotmail.com', '0', '', '0'),
('118', '118', 'LUIS FERNANDO MARQUEZ', 'lourdesacosta2507@gmail.com', 'lourdesacosta2507@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'lourdesacosta2507@gmail.com', '0', '', '0'),
('119', '119', 'VARGAS', 'dvargas@legal.bo', 'dvargas@legal.bo', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'dvargas@legal.bo', '0', '', '0'),
('120', '120', 'Pirai Ltda. Agencia Despachante de Aduanas', 'pedroedwinmamani@gmail.com', 'pedroedwinmamani@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'pedroedwinmamani@gmail.com', '0', '', '0'),
('121', '121', 'Yolanda Vsquez Escobar', 'yvasquez@lacasadelalbanil.com', 'yvasquez@lacasadelalbanil.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'yvasquez@lacasadelalbanil.com', '0', '', '0'),
('122', '122', 'ORELLANA', 'construtech.10@gmail.com', 'construtech.10@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'construtech.10@gmail.com', '0', '', '0'),
('123', '123', 'SOMIVILLA S.R.L.', 'SOMIVILLASRL-2015@HOTMAIL.COM', 'SOMIVILLASRL-2015@HOTMAIL.COM', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'SOMIVILLASRL-2015@HOTMAIL.COM', '0', '', '0'),
('124', '124', 'EMPETROL S.R.L.', 'ruddy_novoa@hotmail.com', 'ruddy_novoa@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'ruddy_novoa@hotmail.com', '0', '', '0'),
('125', '125', 'Bertha Rojas', 'bertharojasve@hotmail.com', 'bertharojasve@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'bertharojasve@hotmail.com', '0', '', '0'),
('126', '126', 'Torrico Julieta ', 'juli_torrico@hotmail.com', 'juli_torrico@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'juli_torrico@hotmail.com', '0', '', '0'),
('127', '127', 'Garcia', 'jacky_leo@hotmail.es', 'jacky_leo@hotmail.es', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'jacky_leo@hotmail.es', '0', '', '0'),
('128', '128', 'RENAN OSCAR BOZO ROJAS', 'oscarbozorojas@gmail.com', 'oscarbozorojas@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'oscarbozorojas@gmail.com', '0', '', '0'),
('129', '129', 'Elvira Villagra', 'villagraoscar@gmail.com', 'villagraoscar@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'villagraoscar@gmail.com', '0', '', '0'),
('130', '130', 'SALAZAR', 'imperator.scz@gmail.com', 'imperator.scz@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'imperator.scz@gmail.com', '0', '', '0'),
('131', '131', 'C.E.H.S. S.R.L.', 'karinarico@hotmail.com', 'karinarico@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'karinarico@hotmail.com', '0', '', '0'),
('132', '132', 'Ach', 'zwapec14@gmail.com', 'zwapec14@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'zwapec14@gmail.com', '0', '', '0'),
('133', '133', 'SALAZAR Y MACHICADO S.A.', 'alannia.rojas@salazarbolivia.c', 'alannia.rojas@salazarbolivia.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'alannia.rojas@salazarbolivia.com', '0', '', '0'),
('134', '134', 'BOLIVIAN CONSTRUCTION COMPANY S.R.L.', 'arnaldysp@gmail.com ', 'arnaldysp@gmail.com ', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'arnaldysp@gmail.com ', '0', '', '0'),
('135', '135', 'CHOQUE', 'w.illycalle@hotmail.com', 'w.illycalle@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'w.illycalle@hotmail.com', '0', '', '0'),
('136', '136', 'Lenny Olivera Flores', 'lenniluc123@gmail.com', 'lenniluc123@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'lenniluc123@gmail.com', '0', '', '0'),
('137', '137', 'Vargas ', 'mirko_v8@hotmail.com', 'mirko_v8@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'mirko_v8@hotmail.com', '0', '', '0'),
('138', '138', 'CEPRA', 'giselvb@hotmail.com', 'giselvb@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'giselvb@hotmail.com', '0', '', '0'),
('139', '139', 'Juan Manuel Zelaya', 'zejuanma@hotmail.com', 'zejuanma@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'zejuanma@hotmail.com', '0', '', '0'),
('140', '140', 'Ludmila Cadima Villegas', 'lcadima059@gmail.com', 'lcadima059@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'lcadima059@gmail.com', '0', '', '0'),
('141', '141', 'BENTEX Ltda.', 'bentex@bentex.com.bo', 'bentex@bentex.com.bo', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'bentex@bentex.com.bo', '0', '', '0'),
('142', '142', 'ITACAMBA CEMENTO S.A.', 'richard.almendras@itacamba.com', 'richard.almendras@itacamba.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'richard.almendras@itacamba.com', '0', '', '0'),
('143', '143', 'Gerardo Bhrt', 'gerardo.bohrt@gmail.com', 'gerardo.bohrt@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'gerardo.bohrt@gmail.com', '0', '', '0'),
('144', '144', 'Mario Choque ', 'mchoque_@hotmail.com', 'mchoque_@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'mchoque_@hotmail.com', '0', '', '0'),
('145', '145', 'Perez ', 'hugothacker@hotmail.com', 'hugothacker@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'hugothacker@hotmail.com', '0', '', '0'),
('146', '146', 'PRAXIS INGENIERIA S.R.L.', 'saulmanriquep@gmail.com', 'saulmanriquep@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'saulmanriquep@gmail.com', '0', '', '0'),
('147', '147', 'FH-BOLIVIA', 'plimachi@fh.org', 'plimachi@fh.org', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'plimachi@fh.org', '0', '', '0'),
('148', '148', 'Betzabe Choqueticlla', 'constbet@gmail.com', 'constbet@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'constbet@gmail.com', '0', '', '0'),
('149', '149', 'RICARDA TORRICO', 'caclarost@hotmail.com', 'caclarost@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'caclarost@hotmail.com', '0', '', '0'),
('150', '150', 'YUCRA', 'luly_ticona@hotmail.com', 'luly_ticona@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'luly_ticona@hotmail.com', '0', '', '0'),
('151', '151', 'COMPAIA DE PLASTICOS ART LTDA.', 'degare_quita@hotmail.com', 'degare_quita@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'degare_quita@hotmail.com', '0', '', '0'),
('152', '152', 'ATI S.R.L. ', 'amilcar.lanza.zeballos@gmail.c', 'amilcar.lanza.zeballos@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'amilcar.lanza.zeballos@gmail.com', '0', '', '0'),
('153', '153', 'Centellas Gonzales', 'sergiochoque77@gmail.com', 'sergiochoque77@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'sergiochoque77@gmail.com', '0', '', '0'),
('154', '154', 'Camacho', 'petvel.camacho@gmail.com', 'petvel.camacho@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'petvel.camacho@gmail.com', '0', '', '0'),
('155', '155', 'AVALOS', 'roy.arenas@hotmail.com', 'roy.arenas@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'roy.arenas@hotmail.com', '0', '', '0'),
('156', '156', 'JUAN CANAVIRI CH.', 'canaviri12@hotmail.com', 'canaviri12@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'canaviri12@hotmail.com', '0', '', '0'),
('157', '157', 'Oscar Jimnez', 'ojimenezr@yahoo.com', 'ojimenezr@yahoo.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'ojimenezr@yahoo.com', '0', '', '0'),
('158', '158', 'Ruth Claros ', 'ruthclaros@gmail.com', 'ruthclaros@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'ruthclaros@gmail.com', '0', '', '0'),
('159', '159', 'Mirtha Lopez', 'mels067@hotmail.com', 'mels067@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'mels067@hotmail.com', '0', '', '0'),
('160', '160', 'MOCELET-BOL Ltda.', 'mocelet.bol@gmail.com', 'mocelet.bol@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'mocelet.bol@gmail.com', '0', '', '0'),
('161', '161', 'EMPRESA DE SERVICIOS CONTACTA S.R.L.', 'bertha_ramirez_ortiz@hotmail.c', 'bertha_ramirez_ortiz@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'bertha_ramirez_ortiz@hotmail.com', '0', '', '0'),
('162', '162', 'RAMIRO VIDOVIC', 'ramiro198906@hotmail.com', 'ramiro198906@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'ramiro198906@hotmail.com', '0', '', '0'),
('163', '163', ' Carlos Calla Carrasco', 'seacon.srl@hotmail.com', 'seacon.srl@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'seacon.srl@hotmail.com', '0', '', '0'),
('164', '164', 'ALTO LIMA  S.R.L.', 'konicocmc@hotmail.com', 'konicocmc@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'konicocmc@hotmail.com', '0', '', '0'),
('165', '165', 'BRAEZ', 'lizjim411@gmail.com', 'lizjim411@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'lizjim411@gmail.com', '0', '', '0'),
('166', '166', 'SAUL RODRIGUEZ', 'rsaulv@gmail.com', 'rsaulv@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'rsaulv@gmail.com', '0', '', '0'),
('167', '167', 'Emerson Darwing Justiniano Hurtado', 'emersoned7@gmail.com', 'emersoned7@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'emersoned7@gmail.com', '0', '', '0'),
('168', '168', 'Jenny Chugar Aquino de Andrade', 'jenny.chugar@hotmail.com', 'jenny.chugar@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'jenny.chugar@hotmail.com', '0', '', '0'),
('169', '169', 'Marcelo Fabian Parraga Balcazar', 'mp_151@hotmail.com', 'mp_151@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'mp_151@hotmail.com', '0', '', '0'),
('170', '170', 'Roger Avendao', 'liz_av.p@hotmail.com', 'liz_av.p@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'liz_av.p@hotmail.com', '0', '', '0'),
('171', '171', 'LITEC S.R.L.', 'gladys.chui@gmail.com', 'gladys.chui@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'gladys.chui@gmail.com', '0', '', '0'),
('172', '172', 'TICONA', 'jcarlos293@hotmail.es', 'jcarlos293@hotmail.es', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'jcarlos293@hotmail.es', '0', '', '0'),
('173', '173', 'Juan Carlos Pallares Torres', 'kjuan5luc@hotmail.com', 'kjuan5luc@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'kjuan5luc@hotmail.com', '0', '', '0'),
('174', '174', 'CONSULTORA ORGANIZACIONAL HOYOS S.R.L.', 'gabriel@hm-consultores.com', 'gabriel@hm-consultores.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'gabriel@hm-consultores.com', '0', '', '0'),
('175', '175', 'Rosario Ines Aguilera Cruz', 'charito_aguilera@hotmail.com', 'charito_aguilera@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'charito_aguilera@hotmail.com', '0', '', '0'),
('176', '176', 'TORO', 'alejandro5493t@gmail.com', 'alejandro5493t@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'alejandro5493t@gmail.com', '0', '', '0'),
('177', '177', 'Inversiones Veterinarias S.A.', 'lvasquez@invetsa.com', 'lvasquez@invetsa.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'lvasquez@invetsa.com', '0', '', '0'),
('178', '178', 'PEARANDA', 'mpenaranda@natbiosrl.com', 'mpenaranda@natbiosrl.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'mpenaranda@natbiosrl.com', '0', '', '0'),
('179', '179', 'Alejandra Camargo', 'alejandra.camargo@xpartes.com.', 'alejandra.camargo@xpartes.com.bo', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'alejandra.camargo@xpartes.com.bo', '0', '', '0'),
('180', '180', 'Marcelo Machaca Cahuana', 'interlexcivile.mm@gmail.com', 'interlexcivile.mm@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'interlexcivile.mm@gmail.com', '0', '', '0'),
('181', '181', 'ANA VARGAS', 'jmvp0410@gmail.com', 'jmvp0410@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'jmvp0410@gmail.com', '0', '', '0'),
('182', '182', 'SEMCA S.R.L.', 'ross_pool_14@hotmail.com', 'ross_pool_14@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'ross_pool_14@hotmail.com', '0', '', '0'),
('183', '183', 'Elvio Montero', 'montero.elvio@saguapac.com.bo', 'montero.elvio@saguapac.com.bo', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'montero.elvio@saguapac.com.bo', '0', '', '0'),
('184', '184', 'QUOTEC S.R.L.', 'nevenka.monje@quotec-bolivia.n', 'nevenka.monje@quotec-bolivia.net', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'nevenka.monje@quotec-bolivia.net', '0', '', '0'),
('185', '185', 'Luis Fernando Bejarano', 'luisfer_b2@hotmail.com', 'luisfer_b2@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'luisfer_b2@hotmail.com', '0', '', '0'),
('186', '186', 'INGENIO SUCROALCOHOLERO AGUAI S.A.', 'impuestos@aguai.com.bo', 'impuestos@aguai.com.bo', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'impuestos@aguai.com.bo', '0', '', '0'),
('187', '187', 'Cristhian Claudio Rodriguez Morales', 'graciela@tecnopeso.com', 'graciela@tecnopeso.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'graciela@tecnopeso.com', '0', '', '0'),
('188', '188', 'Marcos Lopez', 'lopezfloresmarcos@hotmail.com', 'lopezfloresmarcos@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'lopezfloresmarcos@hotmail.com', '0', '', '0'),
('189', '189', 'JOBAR FERNANDEZ', 'jobarf@hotmail.com', 'jobarf@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'jobarf@hotmail.com', '0', '', '0'),
('190', '190', 'MONICA NOGALES', 'monica_nogales@hotmail.com', 'monica_nogales@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'monica_nogales@hotmail.com', '0', '', '0'),
('191', '191', 'Rocio Rojas Clavijo', 'rocrojas1@hotmail.com', 'rocrojas1@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'rocrojas1@hotmail.com', '0', '', '0'),
('192', '192', 'EMPRESA PACHECO MONTAO DISTRIBUIDORA S.R.L.', 'm_arnez@hotmail.com', 'm_arnez@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'm_arnez@hotmail.com', '0', '', '0'),
('193', '193', 'Jimena Mamani Luna', 'jimena.mluna.2492@gmail.com', 'jimena.mluna.2492@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'jimena.mluna.2492@gmail.com', '0', '', '0'),
('194', '194', 'Antezana', 'aguirregirondaelizabeth@gmail.', 'aguirregirondaelizabeth@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'aguirregirondaelizabeth@gmail.com', '0', '', '0'),
('195', '195', 'Martin Daza', 'Dazgar_jesem@hotmail.com', 'Dazgar_jesem@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'Dazgar_jesem@hotmail.com', '0', '', '0'),
('196', '196', 'Ricardo Silvestre Arze Arze', 'fmaldonadorevollo@gmail.com', 'fmaldonadorevollo@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'fmaldonadorevollo@gmail.com', '0', '', '0'),
('197', '197', 'MVO CONSTRUCCIONES &amp; SERVICIOS', 'donaldvl@hotmail.com', 'donaldvl@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'donaldvl@hotmail.com', '0', '', '0'),
('198', '198', 'Rolando Aguado', 'rolando.aguado@vidrierianoelia', 'rolando.aguado@vidrierianoelia.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'rolando.aguado@vidrierianoelia.com', '0', '', '0'),
('199', '199', 'IRUPANA ANDEAN ORGANIC FOOD S.A.', 'mirthablanco123@hotmail.com', 'mirthablanco123@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'mirthablanco123@hotmail.com', '0', '', '0'),
('200', '200', 'ERICK ESPINOZA', 'Lasolucion.gerencia@gmail.com', 'Lasolucion.gerencia@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'Lasolucion.gerencia@gmail.com', '0', '', '0'),
('201', '201', 'GRUPO REGIONAL S.R.L.', 'alvarobalderrama@gruporegional', 'alvarobalderrama@gruporegional.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'alvarobalderrama@gruporegional.com', '0', '', '0'),
('202', '202', 'LIZETH ROSARIO FLORES VARGAS', 'Lizethfloresvargas@gmail.com', 'Lizethfloresvargas@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'Lizethfloresvargas@gmail.com', '0', '', '0'),
('203', '203', 'Edner Revollo', 'willyve007@gmail.com', 'willyve007@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'willyve007@gmail.com', '0', '', '0'),
('204', '204', 'NICOLAS RIC BIRABEN', 'julia_rojas_m@hotmail.com', 'julia_rojas_m@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'julia_rojas_m@hotmail.com', '0', '', '0'),
('205', '205', 'Nelly Maria Molina Medrano', 'nelimar440@gmail.com', 'nelimar440@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'nelimar440@gmail.com', '0', '', '0'),
('206', '206', 'Manuel Bonilla', 'contanapo@cotas.com.bo', 'contanapo@cotas.com.bo', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'contanapo@cotas.com.bo', '0', '', '0'),
('207', '207', 'Laura', 'blaura@kpmg.com', 'blaura@kpmg.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'blaura@kpmg.com', '0', '', '0'),
('208', '208', 'GOYITA S.R.L.', 'ermisrl02@gmail.com', 'ermisrl02@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'ermisrl02@gmail.com', '0', '', '0'),
('209', '209', 'SUAREZ', 'pame_dua@hotmail.com', 'pame_dua@hotmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'pame_dua@hotmail.com', '0', '', '0'),
('210', '210', 'Edgar Soria Veizaga ', 'edsoriaveizaga@gmail.com', 'edsoriaveizaga@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'edsoriaveizaga@gmail.com', '0', '', '0'),
('211', '211', 'MEGA MOLIBOL S.R.L.', 'samuel.sm690@gmail.com', 'samuel.sm690@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'samuel.sm690@gmail.com', '0', '', '0'),
('212', '212', 'DIANA MEJIA CLAROS', 'kmejia.claros@gmail.com', 'kmejia.claros@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'kmejia.claros@gmail.com', '0', '', '0'),
('213', '213', 'EMPRESA FERROVIARIA ANDINA S.A.', 'hmaldonado@fca.com.bo', 'hmaldonado@fca.com.bo', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'hmaldonado@fca.com.bo', '0', '', '0'),
('214', '214', 'BERTOLETTI', 'ste.btti@gmail.com', 'ste.btti@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'ste.btti@gmail.com', '0', '', '0'),
('215', '215', 'LOPEZ', 'berthita7584@gmail.com', 'berthita7584@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'berthita7584@gmail.com', '0', '', '0'),
('216', '216', 'Najira Cotjiri Ramirez', 'paola.cotjiri.ramirez@gmail.co', 'paola.cotjiri.ramirez@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'paola.cotjiri.ramirez@gmail.com', '0', '', '0'),
('217', '217', 'Maria Elena Martinez Ramirez', 'elena.aplicar@gmail.com', 'elena.aplicar@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'elena.aplicar@gmail.com', '0', '', '0'),
('218', '218', 'HMS ASSURANCE GROUP S.R.L.', 'hmontano@hmsassurancegroup.com', 'hmontano@hmsassurancegroup.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'hmontano@hmsassurancegroup.com', '0', '', '0'),
('219', '219', 'Gastn Ortega Aroni', 'gastytule.or.ar@gmail.com', 'gastytule.or.ar@gmail.com', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', 'gastytule.or.ar@gmail.com', '0', '', '0'),
('220', '220', 'COPERAGRO SRL', '210410020', '210410020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '210410020', '0', '', '0'),
('221', '221', 'Zilma Salcedo Eamara', '7593329017', '7593329017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7593329017', '0', '', '0'),
('222', '222', 'SONILUM S.R.L.', '173168027', '173168027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '173168027', '0', '', '0'),
('223', '223', 'LAGUNA', '6135036017', '6135036017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6135036017', '0', '', '0'),
('224', '224', 'INSTACOM S.R.L.', '171414023', '171414023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '171414023', '0', '', '0'),
('225', '225', 'DJV S.R.L. CONSTRUCCIONES', '226902024', '226902024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '226902024', '0', '', '0'),
('226', '226', 'DURAN', '2337013', '2337013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2337013', '0', '', '0'),
('227', '227', 'Vladimir Coca Antezana', '3781773019', '3781773019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3781773019', '0', '', '0'),
('228', '228', 'Jimmy Martinez', '1368976', '1368976', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1368976', '0', '', '0'),
('229', '229', 'COSSIO', '3890157', '3890157', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3890157', '0', '', '0'),
('230', '230', 'LIZARAZU', '3347966019', '3347966019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3347966019', '0', '', '0'),
('231', '231', 'ROLAND BERTN', '4718976011', '4718976011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4718976011', '0', '', '0'),
('232', '232', 'JAVIER CHAMBI', '6007516', '6007516', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6007516', '0', '', '0'),
('233', '233', 'ANURA S.R.L.', '342956024', '342956024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '342956024', '0', '', '0'),
('234', '234', 'Patzi', '7131239012', '7131239012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7131239012', '0', '', '0'),
('235', '235', 'SAAVEDRA', '4521731013', '4521731013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4521731013', '0', '', '0'),
('236', '236', 'TACUARANDI S.R.L.', '1011775023', '1011775023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1011775023', '0', '', '0'),
('237', '237', 'TRANS PLATINIUM S.R.L.', '281306023', '281306023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '281306023', '0', '', '0'),
('238', '238', 'Orellana', '956515019', '956515019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '956515019', '0', '', '0'),
('239', '239', 'METALES DEL ORIENTE S.R.L.', '142591020', '142591020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '142591020', '0', '', '0'),
('240', '240', 'CORMEI SUCURSAL BOLIVIA', '285520021', '285520021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '285520021', '0', '', '0'),
('241', '241', 'Vctor Len Espinoza', '5667226010', '5667226010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5667226010', '0', '', '0'),
('242', '242', 'PANAMERICAN SECURITIES S.A.', '1006783024', '1006783024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1006783024', '0', '', '0'),
('243', '243', 'MAIDANA', '4687321015', '4687321015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4687321015', '0', '', '0'),
('244', '244', 'ALFREDO QUISPE ROJAS', '2070515011', '2070515011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2070515011', '0', '', '0'),
('245', '245', 'Basatec Ltda.', '306418026', '306418026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '306418026', '0', '', '0'),
('246', '246', 'ADRIANA VILLARROEL', '5190005018', '5190005018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5190005018', '0', '', '0'),
('247', '247', 'GARCIA', '2760873', '2760873', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2760873', '0', '', '0'),
('248', '248', 'Denisse Salvatierra', '6291519010', '6291519010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6291519010', '0', '', '0'),
('249', '249', 'Bustillos', '4478623012', '4478623012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4478623012', '0', '', '0'),
('250', '250', 'Gishay S.R.L.', '1001097022', '1001097022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1001097022', '0', '', '0'),
('251', '251', 'CECILIA ANGULO', '4773784018', '4773784018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4773784018', '0', '', '0'),
('252', '252', 'ERWIN BERNAL', '6786983', '6786983', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6786983', '0', '', '0'),
('253', '253', 'Basilio Aguilar Rodrguez', '6210004', '6210004', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6210004', '0', '', '0'),
('254', '254', 'Isabel Gallegos', '4337182014', '4337182014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4337182014', '0', '', '0'),
('255', '255', 'UVAIRENDA S.R.L.', '170160024', '170160024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '170160024', '0', '', '0'),
('256', '256', 'Litzi Martinez', '4500324', '4500324', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4500324', '0', '', '0'),
('257', '257', 'Encinas', '3545691', '3545691', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3545691', '0', '', '0'),
('258', '258', 'Vernica Marek', '11667611', '11667611', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '11667611', '0', '', '0'),
('259', '259', 'HUGO MARCIAL PORTILLO PAREDES', '3828604', '3828604', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3828604', '0', '', '0'),
('260', '260', 'CRISTOBAL BENITO CHOQUE', '3787472', '3787472', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3787472', '0', '', '0'),
('261', '261', 'Yanaina Gamez Ruiz', '3628763019', '3628763019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3628763019', '0', '', '0'),
('262', '262', 'Carlos Hugo Parada', '1583943', '1583943', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1583943', '0', '', '0'),
('263', '263', 'Norma Llanque Huarachi', '5074779', '5074779', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5074779', '0', '', '0'),
('264', '264', 'Pirai Ltda. Agencia Despachante de Aduanas', '1011813027', '1011813027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1011813027', '0', '', '0'),
('265', '265', 'RICHAR CUSSI TICONA', '4792827016', '4792827016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4792827016', '0', '', '0'),
('266', '266', 'Fabiola Andrea Gonzales Vera', '9665289012', '9665289012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '9665289012', '0', '', '0'),
('267', '267', 'SIC-JAC S.R.L', '202136021', '202136021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '202136021', '0', '', '0'),
('268', '268', 'PRAXIS INGENIERIA S.R.L.', '303022023', '303022023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '303022023', '0', '', '0');
INSERT INTO `0_cust_branch` VALUES
('269', '269', 'Honorato Romero', '1042920', '1042920', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1042920', '0', '', '0'),
('270', '270', 'Neidy Arteaga', '9809846', '9809846', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '9809846', '0', '', '0'),
('271', '271', 'MUTUAL AMBRA S.R.L.', '274230028', '274230028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '274230028', '0', '', '0'),
('272', '272', 'Maria Jeannett Galarza Daza', '2441681', '2441681', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2441681', '0', '', '0'),
('273', '273', 'Miguel Angel Vilacahua', '8599142', '8599142', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8599142', '0', '', '0'),
('274', '274', 'Daniel Bruno', '3923856', '3923856', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3923856', '0', '', '0'),
('275', '275', 'Ramiro Aquino', '1989056012', '1989056012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1989056012', '0', '', '0'),
('276', '276', 'AGENCIAS GENERALES S.A.', '1023281020', '1023281020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1023281020', '0', '', '0'),
('277', '277', 'Mamani', '6895616', '6895616', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6895616', '0', '', '0'),
('278', '278', 'ANTEZANA', '970257018', '970257018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '970257018', '0', '', '0'),
('279', '279', 'FARMEDICAL S.R.L.', '1001285025', '1001285025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1001285025', '0', '', '0'),
('280', '280', 'Procasa/Bolivia S.R.L.', '305830022', '305830022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '305830022', '0', '', '0'),
('281', '281', 'COOPERATIVA MADRE Y MAESTRA LTDA.', '1011261026', '1011261026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1011261026', '0', '', '0'),
('282', '282', 'Quiroga', '3837352014', '3837352014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3837352014', '0', '', '0'),
('283', '283', 'WHILIAN PEARANDA', '5113361', '5113361', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5113361', '0', '', '0'),
('284', '284', 'Paola Gutierrez Aguilar', '4372690012', '4372690012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4372690012', '0', '', '0'),
('285', '285', 'Alcibiades Ribera M.', '2830480011', '2830480011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2830480011', '0', '', '0'),
('286', '286', 'ELFEC S.A.', '1023213028', '1023213028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1023213028', '0', '', '0'),
('287', '287', 'Neme', '3534048', '3534048', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3534048', '0', '', '0'),
('288', '288', 'CARFREDER S.R.L.', '321244024', '321244024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '321244024', '0', '', '0'),
('289', '289', 'Abruzzese', '3426603013', '3426603013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3426603013', '0', '', '0'),
('290', '290', 'LABORATORIOS MINERVA S.R.L.', '1006573022', '1006573022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1006573022', '0', '', '0'),
('291', '291', 'Josias Pedraza', '8193297', '8193297', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8193297', '0', '', '0'),
('292', '292', 'Gilber Brito', '5355039012', '5355039012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5355039012', '0', '', '0'),
('293', '293', 'Eurofinsa S.A. Sucursal Bolivia', '280072023', '280072023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '280072023', '0', '', '0'),
('294', '294', 'SOINCO G.L.P.H. Ltda.', '1020573024', '1020573024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1020573024', '0', '', '0'),
('295', '295', 'INDEX S.R.L.', '262724027', '262724027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '262724027', '0', '', '0'),
('296', '296', 'CHRISTIAN BORIS COPA AQUINO', '6547224012', '6547224012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6547224012', '0', '', '0'),
('297', '297', 'Juan Jos Lpez Galindo', '3538701014', '3538701014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3538701014', '0', '', '0'),
('298', '298', 'CALERA ORIENTAL S.R.L.', '1025373023', '1025373023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1025373023', '0', '', '0'),
('299', '299', 'Sierra Trading Company S.R.L. ', '277848022', '277848022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '277848022', '0', '', '0'),
('300', '300', 'Gonzalo Favio Rojas Echazu', '3275079018', '3275079018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3275079018', '0', '', '0'),
('301', '301', 'Zarate', '4284949018', '4284949018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4284949018', '0', '', '0'),
('302', '302', 'Efrain Arauz', '5355147', '5355147', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5355147', '0', '', '0'),
('303', '303', 'LILIANA ROMERO MELGAR', '6334267019', '6334267019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6334267019', '0', '', '0'),
('304', '304', 'Empresa Constructora Cochabamba S.A.', '1022017029', '1022017029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1022017029', '0', '', '0'),
('305', '305', 'INDUSTRIAS QUMICAS CIMBOL S.R.L.', '1014651028', '1014651028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1014651028', '0', '', '0'),
('306', '306', 'International Fuel S.R.L.', '1020197021', '1020197021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1020197021', '0', '', '0'),
('307', '307', 'Torrico', '6425373', '6425373', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6425373', '0', '', '0'),
('308', '308', 'Javier', '3841925', '3841925', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3841925', '0', '', '0'),
('309', '309', 'Navarro', '1047973013', '1047973013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1047973013', '0', '', '0'),
('310', '310', 'Juan Pablo Chalco Canaviri', '5606692014', '5606692014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5606692014', '0', '', '0'),
('311', '311', 'Alarcon', '3456810019', '3456810019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3456810019', '0', '', '0'),
('312', '312', 'TITO', '4053867010', '4053867010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4053867010', '0', '', '0'),
('313', '313', 'Luizaga', '5194583013', '5194583013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5194583013', '0', '', '0'),
('314', '314', 'A.I.I S.R.L.- SUCURSAL BOLIVIA', '298068021', '298068021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '298068021', '0', '', '0'),
('315', '315', 'U.E. Comunidad Cristiana S.R.L.', '207744022', '207744022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '207744022', '0', '', '0'),
('316', '316', 'SOALPRO S.R.L.', '1020409021', '1020409021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1020409021', '0', '', '0'),
('317', '317', 'GOMEZ', '2717789', '2717789', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2717789', '0', '', '0'),
('318', '318', 'Quiroga', '836434', '836434', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '836434', '0', '', '0'),
('319', '319', 'Cristina Paz', '5396131', '5396131', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5396131', '0', '', '0'),
('320', '320', 'IVAN RUSSVEL ALCOCER RODRIGUEZ', '5281634018', '5281634018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5281634018', '0', '', '0'),
('321', '321', 'Marisabel Ruffy Toro Ruiloba', '3528568010', '3528568010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3528568010', '0', '', '0'),
('322', '322', 'Fernando Salinas', '4885266010', '4885266010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4885266010', '0', '', '0'),
('323', '323', 'Cabezas SRL Corredores y Asesores de Seguros', '1006433029', '1006433029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1006433029', '0', '', '0'),
('324', '324', 'INVERSIONES INMOBILIARIAS INDACO S.A.', '307626021', '307626021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '307626021', '0', '', '0'),
('325', '325', 'Shirley Cemo Vasquez', '7618987', '7618987', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7618987', '0', '', '0'),
('326', '326', 'Rodrigo Querejazu', '3004884', '3004884', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3004884', '0', '', '0'),
('327', '327', 'SAUL SANDRO RAMIREZ MAMANI', '5132916015', '5132916015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5132916015', '0', '', '0'),
('328', '328', 'Petrofil Ltda', '293468029', '293468029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '293468029', '0', '', '0'),
('329', '329', 'VARGAS', '344067', '344067', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '344067', '0', '', '0'),
('330', '330', 'Guidelines Consultores Estratgicos S.R.L.', '334444028', '334444028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '334444028', '0', '', '0'),
('331', '331', 'Sanchez Victoria', '4950515010', '4950515010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4950515010', '0', '', '0'),
('332', '332', 'EMPRESA DE DESARROLLO INMOBILIARIOS KORBAN S.R.L', '280022021', '280022021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '280022021', '0', '', '0'),
('333', '333', 'Altamirano', '2462819018', '2462819018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2462819018', '0', '', '0'),
('334', '334', 'iBOLSA Sociedad de Titularizacion S.A.', '285872022', '285872022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '285872022', '0', '', '0'),
('335', '335', 'QUISPE', '3551314', '3551314', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3551314', '0', '', '0'),
('336', '336', 'AGENCIA DESPACHANTE DE ADUANA ARG SA', '126327023', '126327023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '126327023', '0', '', '0'),
('337', '337', 'Miguel Nava Carrasco', '4088552014', '4088552014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4088552014', '0', '', '0'),
('338', '338', 'Eduardo Becerra', '2623341012', '2623341012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2623341012', '0', '', '0'),
('339', '339', 'WILFREDO REMY COMBATA PACHECO', '6564677', '6564677', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6564677', '0', '', '0'),
('340', '340', 'HEIDY pea', '6343806', '6343806', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6343806', '0', '', '0'),
('341', '341', 'MORALES', '3071660011', '3071660011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3071660011', '0', '', '0'),
('342', '342', 'Patricia Romero Padilla', '5313881016', '5313881016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5313881016', '0', '', '0'),
('343', '343', 'Luis gustavo oliva padilla', '5404611011', '5404611011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5404611011', '0', '', '0'),
('344', '344', 'Edwin Chavez Montao', '5197416019', '5197416019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5197416019', '0', '', '0'),
('345', '345', 'Apaza', '9951560', '9951560', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '9951560', '0', '', '0'),
('346', '346', 'VIDAL', '4615057', '4615057', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4615057', '0', '', '0'),
('347', '347', 'glenda soledad pearanda tirina', '10793297015', '10793297015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '10793297015', '0', '', '0'),
('348', '348', 'Nancy', '3938283012', '3938283012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3938283012', '0', '', '0'),
('349', '349', '	MAYTA', '6949808', '6949808', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6949808', '0', '', '0'),
('350', '350', 'ROCHA', '4538439', '4538439', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4538439', '0', '', '0'),
('351', '351', 'CHINO', '9350370', '9350370', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '9350370', '0', '', '0'),
('352', '352', 'DATA SOURCE S.A', '160004026', '160004026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '160004026', '0', '', '0'),
('353', '353', 'waldir serrano', '1396534011', '1396534011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1396534011', '0', '', '0'),
('354', '354', 'roque lopez', '4248254011', '4248254011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4248254011', '0', '', '0'),
('355', '355', 'Santillan', '4408838', '4408838', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4408838', '0', '', '0'),
('356', '356', 'Orlando Verduguez Trujillo', '6448088013', '6448088013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6448088013', '0', '', '0'),
('357', '357', 'javier lopez', '3204255', '3204255', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3204255', '0', '', '0'),
('358', '358', 'Empresa Laguna Corazon S.A', '1013467022', '1013467022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1013467022', '0', '', '0'),
('359', '359', 'NATKAS SRL', '307996029', '307996029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '307996029', '0', '', '0'),
('360', '360', 'PAOLA ANDREA GAMBOA AZUGA', '7306597', '7306597', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7306597', '0', '', '0'),
('361', '361', 'Ruth Claros', '827166', '827166', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '827166', '0', '', '0'),
('362', '362', 'Marco Moscoso', '2394441018', '2394441018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2394441018', '0', '', '0'),
('363', '363', 'Claudia Chavez', '3882130', '3882130', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3882130', '0', '', '0'),
('364', '364', 'elvis', '5227857', '5227857', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5227857', '0', '', '0'),
('365', '365', 'Jenny Amelia Ledezma Inturias', '8197236017', '8197236017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8197236017', '0', '', '0'),
('366', '366', 'Chavarria', '3684083', '3684083', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3684083', '0', '', '0'),
('367', '367', 'Juan Pablo Ariscain Bernini', '3489808', '3489808', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3489808', '0', '', '0'),
('368', '368', 'ALEJANDRO OROSCO', '6545847017', '6545847017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6545847017', '0', '', '0'),
('369', '369', 'orlando ustarez lopez', '4734128012', '4734128012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4734128012', '0', '', '0'),
('370', '370', 'Corazon Diagnostic Center Srl', '183008023', '183008023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '183008023', '0', '', '0'),
('371', '371', 'Guillermo Sotomayor', '465761015', '465761015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '465761015', '0', '', '0'),
('372', '372', 'javier chambi', '6007516014', '6007516014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6007516014', '0', '', '0'),
('373', '373', 'FUNDACION COMPA', '140265029', '140265029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '140265029', '0', '', '0'),
('374', '374', 'RICARDO RIVERA', '2475079016', '2475079016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2475079016', '0', '', '0'),
('375', '375', 'ilse claudio', '3836969', '3836969', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3836969', '0', '', '0'),
('376', '376', 'guevara y gumiel asociados srl', '293594020', '293594020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '293594020', '0', '', '0'),
('377', '377', 'Guillermo Fuentes', '2608575019', '2608575019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2608575019', '0', '', '0'),
('378', '378', 'LEON', '4832554010', '4832554010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4832554010', '0', '', '0'),
('379', '379', 'Nestor Lazcano Quentasi', '7747077013', '7747077013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7747077013', '0', '', '0'),
('380', '380', 'CRISPIN ALVARADO', '8362369018', '8362369018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8362369018', '0', '', '0'),
('381', '381', 'Luis German Quispe Hanco', '5794435018', '5794435018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5794435018', '0', '', '0'),
('382', '382', 'JORGE LUIS GOMEZ BARRIENTOS', '811951017', '811951017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '811951017', '0', '', '0'),
('383', '383', 'Mabel Adelaida Lastra Vargas', '5186352', '5186352', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5186352', '0', '', '0'),
('384', '384', 'Caetano', '4869820', '4869820', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4869820', '0', '', '0'),
('385', '385', 'Marcelo Cosio', '3937145', '3937145', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3937145', '0', '', '0'),
('386', '386', 'CONTEC LTDA.', '1015463023', '1015463023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1015463023', '0', '', '0'),
('387', '387', 'RUTH MARINA RIVERO BARBOZA', '3901049', '3901049', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3901049', '0', '', '0'),
('388', '388', 'Santiago Pacheco', '7664152', '7664152', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7664152', '0', '', '0'),
('389', '389', 'Lorena Salas Castillo', '6244077010', '6244077010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6244077010', '0', '', '0'),
('390', '390', 'Mansilla &amp; Asociados SRL', '295526029', '295526029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '295526029', '0', '', '0'),
('391', '391', 'Servia', '369651010', '369651010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '369651010', '0', '', '0'),
('392', '392', 'Roxana Romero Escalante', '4127970', '4127970', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4127970', '0', '', '0'),
('393', '393', 'Juan Florentino Martinez Galean', '7176851', '7176851', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7176851', '0', '', '0'),
('394', '394', 'Lola Ortiz', '4196965', '4196965', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4196965', '0', '', '0'),
('395', '395', 'Sonia Miranda', '3517795015', '3517795015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3517795015', '0', '', '0'),
('396', '396', 'MALDONADO', '2869699012', '2869699012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2869699012', '0', '', '0'),
('397', '397', 'CARRASCO', '2294215', '2294215', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2294215', '0', '', '0'),
('398', '398', 'Centellas', '3481031010', '3481031010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3481031010', '0', '', '0'),
('399', '399', 'Maria Laura Villalobos Rivas', '1885794013', '1885794013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1885794013', '0', '', '0'),
('400', '400', 'MANUEL FIGUEROA', '1650768012', '1650768012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1650768012', '0', '', '0'),
('401', '401', 'RELET SRL', '185334023', '185334023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '185334023', '0', '', '0'),
('402', '402', 'SUNSET GROUP SRL', '312614025', '312614025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '312614025', '0', '', '0'),
('403', '403', 'Gerona Power S.R.L.', '191186025', '191186025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '191186025', '0', '', '0'),
('404', '404', 'JOSE LUIS MARQUEZ', '462305019', '462305019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '462305019', '0', '', '0'),
('405', '405', 'AUDITORES ASOCIADOS SOC. PROF. LTDA', '1005123023', '1005123023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1005123023', '0', '', '0'),
('406', '406', 'G.A.M. EL CARMEN RIVERO TORREZ', '126481022', '126481022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '126481022', '0', '', '0'),
('407', '407', 'Roly Gabriel Veizaga Herrera', '6261196019', '6261196019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6261196019', '0', '', '0'),
('408', '408', 'Guido Vallejos', '8008093', '8008093', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8008093', '0', '', '0'),
('409', '409', 'TTIS LTDA', '180248023', '180248023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '180248023', '0', '', '0'),
('410', '410', 'Eduardo Senzano Quintela', '7856892012', '7856892012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7856892012', '0', '', '0'),
('411', '411', 'CMS SRL', '192026029', '192026029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '192026029', '0', '', '0'),
('412', '412', 'Jesus Justiniano Moreno', '3956353015', '3956353015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3956353015', '0', '', '0'),
('413', '413', 'Moreno ', '4893751012', '4893751012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4893751012', '0', '', '0'),
('414', '414', 'Tejada', '3376092010', '3376092010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3376092010', '0', '', '0'),
('415', '415', 'SUR ENERGY S.R.L.', '302770026', '302770026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '302770026', '0', '', '0'),
('416', '416', 'Celina Calcina Ali', '4013849016', '4013849016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4013849016', '0', '', '0'),
('417', '417', 'PABLO JIMENEZ SANTA CRUZ', '4571301019', '4571301019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4571301019', '0', '', '0'),
('418', '418', 'Mamani', '4912285010', '4912285010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4912285010', '0', '', '0'),
('419', '419', 'Gonzalo Cuellar', '3924498', '3924498', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3924498', '0', '', '0'),
('420', '420', 'Saavedra', '3720217', '3720217', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3720217', '0', '', '0'),
('421', '421', 'Daniela Torrez', '5353936', '5353936', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5353936', '0', '', '0'),
('422', '422', 'MARIA PATZI', '452649011', '452649011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '452649011', '0', '', '0'),
('423', '423', 'Juan Carlos Alba Menacho', '3879651012', '3879651012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3879651012', '0', '', '0'),
('424', '424', 'Fernando Velarde', '7849704019', '7849704019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7849704019', '0', '', '0'),
('425', '425', 'HENRY LIENDO LOPEZ', '5241268018', '5241268018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5241268018', '0', '', '0'),
('426', '426', 'Garca', '4038940014', '4038940014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4038940014', '0', '', '0'),
('427', '427', 'CRUZTEL SRL', '1026419023', '1026419023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1026419023', '0', '', '0'),
('428', '428', 'SBO Ltda', '285494021', '285494021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '285494021', '0', '', '0'),
('429', '429', 'Hugo Orellana', '6337386', '6337386', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6337386', '0', '', '0'),
('430', '430', 'CALVET', '3391207', '3391207', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3391207', '0', '', '0'),
('431', '431', 'Hernan Mamani Porco', '7919856', '7919856', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7919856', '0', '', '0'),
('432', '432', 'Bolog Logstics Group Srl', '321122024', '321122024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '321122024', '0', '', '0'),
('433', '433', 'Miguel Angel Cardenas Chura', '7024202', '7024202', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7024202', '0', '', '0'),
('434', '434', 'Perez', '6103351017', '6103351017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6103351017', '0', '', '0'),
('435', '435', 'ANDRES RIVERO VALDES', '8931512', '8931512', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8931512', '0', '', '0'),
('436', '436', 'Kevin Dagner Salazar', '7804484016', '7804484016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7804484016', '0', '', '0'),
('437', '437', 'Maria Coronel', '5799659016', '5799659016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5799659016', '0', '', '0'),
('438', '438', 'Quisbert', '3441590019', '3441590019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3441590019', '0', '', '0'),
('439', '439', 'Ortuo', '3433930015', '3433930015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3433930015', '0', '', '0'),
('440', '440', 'Aluizio Marcinichen Junior', '10138914', '10138914', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '10138914', '0', '', '0'),
('441', '441', 'Empresa Minera Rocamir SRL.', '296454029', '296454029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '296454029', '0', '', '0'),
('442', '442', 'CMI HOPE SA', '295592021', '295592021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '295592021', '0', '', '0'),
('443', '443', 'Karen Lucia Montao Paz', '6203970016', '6203970016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6203970016', '0', '', '0'),
('444', '444', 'Heidi Blanco', '5007127010', '5007127010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5007127010', '0', '', '0'),
('445', '445', 'Jose L. Blanco Guzman', '5047656012', '5047656012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5047656012', '0', '', '0'),
('446', '446', 'Eduardo Vela', '3699978017', '3699978017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3699978017', '0', '', '0'),
('447', '447', 'ESPINOZA', '2320665014', '2320665014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2320665014', '0', '', '0'),
('448', '448', 'BRIAN HODIN ZEBALLOS', '8949520', '8949520', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8949520', '0', '', '0'),
('449', '449', 'Olivia Paye', '4909294012', '4909294012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4909294012', '0', '', '0'),
('450', '450', 'Rodriguez', '2611923', '2611923', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2611923', '0', '', '0'),
('451', '451', 'ROSMERY ROQUE RINALDO', '3516500011', '3516500011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3516500011', '0', '', '0'),
('452', '452', 'GILDA VALENCIA FLORES', '4895622', '4895622', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4895622', '0', '', '0'),
('453', '453', 'Farih Andrade', '5351179', '5351179', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5351179', '0', '', '0'),
('454', '454', 'Arias', '3520911', '3520911', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3520911', '0', '', '0'),
('455', '455', 'Torres', '5647325018', '5647325018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5647325018', '0', '', '0'),
('456', '456', 'Ayllon', '4248021019', '4248021019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4248021019', '0', '', '0'),
('457', '457', 'Villegas', '8130252', '8130252', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8130252', '0', '', '0'),
('458', '458', 'Maria Teresa Paz Zambrana', '1466593012', '1466593012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1466593012', '0', '', '0'),
('459', '459', 'RICHARD HURTADO VACA', '4570851', '4570851', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4570851', '0', '', '0'),
('460', '460', 'Sinder Aguilar', '8179696', '8179696', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8179696', '0', '', '0'),
('461', '461', 'GRISELDA MORENO', '5055903017', '5055903017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5055903017', '0', '', '0'),
('462', '462', 'Alejo', '6836234', '6836234', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6836234', '0', '', '0'),
('463', '463', 'Carola Maldonado', '5251747014', '5251747014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5251747014', '0', '', '0'),
('464', '464', 'mendoza', '4367408', '4367408', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4367408', '0', '', '0'),
('465', '465', 'Carlos Orozco', '2762148', '2762148', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2762148', '0', '', '0'),
('466', '466', 'Beatriz Zuagua Mamani', '1878537', '1878537', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1878537', '0', '', '0'),
('467', '467', 'Lakhiani', '193188021', '193188021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '193188021', '0', '', '0'),
('468', '468', 'Villanueva', '4525510', '4525510', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4525510', '0', '', '0'),
('469', '469', 'GONZALO JORGE NOGUEDA', '8643616015', '8643616015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8643616015', '0', '', '0'),
('470', '470', 'Jos Mendez Jimenez', '4735627', '4735627', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4735627', '0', '', '0'),
('471', '471', 'JEIDY MARIELA QUIROGA PANIAGUA', '4118801', '4118801', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4118801', '0', '', '0'),
('472', '472', 'guarachi', '5908296', '5908296', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5908296', '0', '', '0'),
('473', '473', 'COPY N&#039; CUT S.R.L', '309144024', '309144024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '309144024', '0', '', '0'),
('474', '474', 'altuzarra', '6096210013', '6096210013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6096210013', '0', '', '0'),
('475', '475', 'Deysi Llusco', '4311930013', '4311930013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4311930013', '0', '', '0'),
('476', '476', 'Bladimir Castro', '4444019019', '4444019019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4444019019', '0', '', '0'),
('477', '477', 'Arminda Lpez Loaiza', '6229003', '6229003', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6229003', '0', '', '0'),
('478', '478', 'alvarez olivarez s.r.l.', '337064023', '337064023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '337064023', '0', '', '0'),
('479', '479', 'Coopertiva Iberocoop Ltda.', '157258028', '157258028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '157258028', '0', '', '0'),
('480', '480', 'NEMECIO ZEBALLOS CHOQUE', '3862216014', '3862216014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3862216014', '0', '', '0'),
('481', '481', 'Evert Arroyo Lpez', '7560699011', '7560699011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7560699011', '0', '', '0'),
('482', '482', 'Gorostiaga', '3405697015', '3405697015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3405697015', '0', '', '0'),
('483', '483', 'DANIEL MENDOZA VACA', '7821931', '7821931', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7821931', '0', '', '0'),
('484', '484', 'ARNOLDO ANTELO MORALES', '1589222012', '1589222012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1589222012', '0', '', '0'),
('485', '485', 'Rosario Valencia', '3236906012', '3236906012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3236906012', '0', '', '0'),
('486', '486', 'Ana Mara Ribera Ribera', '3896030', '3896030', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3896030', '0', '', '0'),
('487', '487', 'Limachi Cora Marlene Diva', '7007752014', '7007752014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7007752014', '0', '', '0'),
('488', '488', 'Condori', '5757629011', '5757629011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5757629011', '0', '', '0'),
('489', '489', 'Maria Eugenia Delgadillo Viveros', '5356911015', '5356911015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5356911015', '0', '', '0'),
('490', '490', 'Castro', '4806465', '4806465', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4806465', '0', '', '0'),
('491', '491', 'Empresa Agroseller S.R.L.', '285286027', '285286027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '285286027', '0', '', '0'),
('492', '492', 'EMPRESA MINERA CALATAYUD SRL', '194188028', '194188028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '194188028', '0', '', '0'),
('493', '493', 'Gigantografia Impresiona SRL', '344162025', '344162025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '344162025', '0', '', '0'),
('494', '494', 'Quintanilla', '3327090', '3327090', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3327090', '0', '', '0'),
('495', '495', 'Luis Quispe', '3701514', '3701514', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3701514', '0', '', '0'),
('496', '496', 'Nstor Martnez Vsquez', '1388049', '1388049', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1388049', '0', '', '0'),
('497', '497', 'Jairo Willam Marca', '9604427013', '9604427013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '9604427013', '0', '', '0'),
('498', '498', 'Vctor Hugo Meja', '2293874', '2293874', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2293874', '0', '', '0'),
('499', '499', 'Gonzales', '3773373', '3773373', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3773373', '0', '', '0'),
('500', '500', 'Carlos Vargas Moreno', '1991791012', '1991791012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1991791012', '0', '', '0'),
('501', '501', 'Campos', '5186490', '5186490', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5186490', '0', '', '0'),
('502', '502', 'COMPANEX BOLIVIA SA.', '1020649021', '1020649021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1020649021', '0', '', '0'),
('503', '503', 'LILA DEL BARCO', '7115983014', '7115983014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7115983014', '0', '', '0'),
('504', '504', 'Mario Gonzalo Snchez Medina', '1052744017', '1052744017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1052744017', '0', '', '0'),
('505', '505', 'ernesto claros ovando', '3330160012', '3330160012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3330160012', '0', '', '0'),
('506', '506', 'JHON WILSON APAZA CHANA', '6006104015', '6006104015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6006104015', '0', '', '0'),
('507', '507', 'Bejarano', '2608189', '2608189', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2608189', '0', '', '0'),
('508', '508', 'OGC S.R.L.', '212210025', '212210025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '212210025', '0', '', '0'),
('509', '509', 'Gonzales', '464232', '464232', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '464232', '0', '', '0'),
('510', '510', 'Guzman', '202470028', '202470028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '202470028', '0', '', '0'),
('511', '511', 'Camacho', '5473062014', '5473062014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5473062014', '0', '', '0'),
('512', '512', 'Aguilar', '4049090016', '4049090016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4049090016', '0', '', '0'),
('513', '513', 'Gutierrez', '577388019', '577388019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '577388019', '0', '', '0'),
('514', '514', 'CASTILLO', '5151387017', '5151387017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5151387017', '0', '', '0'),
('515', '515', 'Claudia Irma Layme Vasquez', '5480149', '5480149', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5480149', '0', '', '0'),
('516', '516', 'Soria', '4919734', '4919734', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4919734', '0', '', '0'),
('517', '517', 'ARIEL ALFONSO LINARES VARGAS', '4783474014', '4783474014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4783474014', '0', '', '0'),
('518', '518', 'Nina', '4921020012', '4921020012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4921020012', '0', '', '0'),
('519', '519', 'Adalid Quispe', '6987174', '6987174', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6987174', '0', '', '0'),
('520', '520', 'baldiviezo', '8417632019', '8417632019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8417632019', '0', '', '0'),
('521', '521', 'Rocha', '6500521019', '6500521019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6500521019', '0', '', '0'),
('522', '522', 'INCERCRUZ', '120875027', '120875027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '120875027', '0', '', '0'),
('523', '523', 'Tade S.R.L.', '240714024', '240714024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '240714024', '0', '', '0'),
('524', '524', 'Piedades Justiniano', '4663421', '4663421', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4663421', '0', '', '0'),
('525', '525', 'MICHEL UCHANI SOLIZ', '6448815016', '6448815016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6448815016', '0', '', '0'),
('526', '526', 'Vidaurre', '6261326', '6261326', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6261326', '0', '', '0'),
('527', '527', 'Luis quisbert', '8310635', '8310635', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8310635', '0', '', '0'),
('528', '528', 'Global Insigth Software S.R.L.', '198534021', '198534021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '198534021', '0', '', '0'),
('529', '529', 'ROSSIO CESPEDES', '3899419', '3899419', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3899419', '0', '', '0'),
('530', '530', 'Jacha Inti Industrial S.A', '155338026', '155338026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '155338026', '0', '', '0'),
('531', '531', 'Carmen Cinthia Ribera', '5348991019', '5348991019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5348991019', '0', '', '0'),
('532', '532', 'ARGANDOA', '3329263016', '3329263016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3329263016', '0', '', '0'),
('533', '533', 'CARLOS CALIXTO GUTIERREZ ALANOCA', '5114060010', '5114060010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5114060010', '0', '', '0'),
('534', '534', 'Delgadillo', '5200108', '5200108', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5200108', '0', '', '0'),
('535', '535', 'Alejandro Ramos', '1925994011', '1925994011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1925994011', '0', '', '0'),
('536', '536', 'FARIAS', '3382622', '3382622', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3382622', '0', '', '0'),
('537', '537', 'Perez', '4500039019', '4500039019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4500039019', '0', '', '0'),
('538', '538', 'Omar Rodriguez Vargas', '4528825', '4528825', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4528825', '0', '', '0'),
('539', '539', 'Mirian Consuelo Talamas', '1578778011', '1578778011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1578778011', '0', '', '0'),
('540', '540', 'RUBEN DARIO BELLIDO ZELADA', '2300879', '2300879', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2300879', '0', '', '0'),
('541', '541', 'VICTOR HUGO JIMENEZ', '3430846013', '3430846013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3430846013', '0', '', '0'),
('542', '542', 'AMADOR GALLARDO', '1975277', '1975277', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1975277', '0', '', '0'),
('543', '543', 'Corina Rosario Echazu Arandia', '3930501', '3930501', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3930501', '0', '', '0'),
('544', '544', 'Flores', '5748918018', '5748918018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5748918018', '0', '', '0'),
('545', '545', 'FLORES', '3380186', '3380186', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3380186', '0', '', '0'),
('546', '546', 'Alex Medrano Sejas', '5229324010', '5229324010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5229324010', '0', '', '0'),
('547', '547', 'LA CASCADA S.A.', '1006909025', '1006909025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1006909025', '0', '', '0'),
('548', '548', 'MARCO AURELIO ANTELO RODRIGUEZ', '7723555011', '7723555011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7723555011', '0', '', '0'),
('549', '549', 'EMPRESA CONSTRUCTORA MILANO SRL', '302288022', '302288022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '302288022', '0', '', '0'),
('550', '550', 'LOPEZ', '6438193', '6438193', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6438193', '0', '', '0'),
('551', '551', 'MOAN S.R.L. 222432022', '222432022', '222432022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '222432022', '0', '', '0'),
('552', '552', 'machaca', '10065446013', '10065446013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '10065446013', '0', '', '0'),
('553', '553', 'Zaida Garcia Loayza', '4125485', '4125485', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4125485', '0', '', '0'),
('554', '554', 'Bernabe condori', '8786228', '8786228', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8786228', '0', '', '0'),
('555', '555', 'sandra terceros', '3788611', '3788611', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3788611', '0', '', '0'),
('556', '556', 'DORIS CAZON', '2327733', '2327733', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2327733', '0', '', '0'),
('557', '557', 'SERGIO SILVA', '8422704013', '8422704013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8422704013', '0', '', '0'),
('558', '558', 'AF CONTROL SRL', '273124028', '273124028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '273124028', '0', '', '0'),
('559', '559', 'Marcelo Ibaez Salvatierra', '5619290017', '5619290017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5619290017', '0', '', '0'),
('560', '560', 'Reyes Ortiz', '6811842', '6811842', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6811842', '0', '', '0'),
('561', '561', 'Celia Garcia Chileno', '6361872', '6361872', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6361872', '0', '', '0'),
('562', '562', 'Mauricio Sossa Vasquez', '5600095', '5600095', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5600095', '0', '', '0'),
('563', '563', 'CHOQUE', '5062084015', '5062084015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5062084015', '0', '', '0'),
('564', '564', 'Jose Richard Pedriel Vargas', '3898475019', '3898475019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3898475019', '0', '', '0'),
('565', '565', 'EDITORIAL LA PATRIA LTDA', '1010141024', '1010141024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1010141024', '0', '', '0'),
('566', '566', 'UTASAWA', '125095020', '125095020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '125095020', '0', '', '0'),
('567', '567', 'ROTERZU SRL', '273422020', '273422020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '273422020', '0', '', '0'),
('568', '568', 'Indago Consultora S.R.L', '331442025', '331442025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '331442025', '0', '', '0'),
('569', '569', 'Ceferina Garcia', '5828510013', '5828510013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5828510013', '0', '', '0'),
('570', '570', 'Callisaya', '6125155014', '6125155014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6125155014', '0', '', '0'),
('571', '571', 'RODRIGUEZ', '6735622', '6735622', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6735622', '0', '', '0'),
('572', '572', 'Sudaval S.A', '1018629028', '1018629028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1018629028', '0', '', '0'),
('573', '573', 'Sarzuri', '7891380010', '7891380010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7891380010', '0', '', '0'),
('574', '574', 'Espinoza', '3437727019', '3437727019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3437727019', '0', '', '0'),
('575', '575', 'ARISPE', '3529451', '3529451', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3529451', '0', '', '0'),
('576', '576', 'Maria Cristel Sanchez Veizaga', '6413155', '6413155', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6413155', '0', '', '0'),
('577', '577', 'Jhossep Cristhian Choque Chamoso', '7537542019', '7537542019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7537542019', '0', '', '0'),
('578', '578', 'Carlos Pea', '7164940013', '7164940013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7164940013', '0', '', '0'),
('579', '579', 'GNAC SRL', '305932026', '305932026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '305932026', '0', '', '0'),
('580', '580', 'MERY HUAYHUATI', '4457837', '4457837', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4457837', '0', '', '0'),
('581', '581', 'MENDOZA', '3426647019', '3426647019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3426647019', '0', '', '0'),
('582', '582', 'David Limachi Coca', '6587474', '6587474', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6587474', '0', '', '0'),
('583', '583', 'zeballos', '3407404', '3407404', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3407404', '0', '', '0'),
('584', '584', 'IRMA LOPEZ MONTAO', '8053704', '8053704', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8053704', '0', '', '0'),
('585', '585', 'Alcocer', '4407713', '4407713', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4407713', '0', '', '0'),
('586', '586', 'LOZANO', '2458750015', '2458750015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2458750015', '0', '', '0'),
('587', '587', 'Julio Cesar Peralta', '7551862', '7551862', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7551862', '0', '', '0'),
('588', '588', 'ERIKA MERCEDES BURGOS MEDINA', '4610692 SC.', '4610692 SC.', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4610692 SC.', '0', '', '0'),
('589', '589', 'CENTRO DE LA MUJER RENGEL S.R.L.', '199662028', '199662028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '199662028', '0', '', '0'),
('590', '590', 'NINA', '3418852019', '3418852019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3418852019', '0', '', '0'),
('591', '591', 'Adriana Villegas', '5774005', '5774005', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5774005', '0', '', '0'),
('592', '592', 'AVE', '1022939025', '1022939025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1022939025', '0', '', '0'),
('593', '593', 'FERNANDEZ', '4055530014', '4055530014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4055530014', '0', '', '0'),
('594', '594', 'EMPETROL S.R.L', '218132024', '218132024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '218132024', '0', '', '0'),
('595', '595', 'ORLANDO TORRICO R.', '3733526019', '3733526019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3733526019', '0', '', '0'),
('596', '596', 'CARLOS MIRANDA', '4976275014', '4976275014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4976275014', '0', '', '0'),
('597', '597', 'Fundacin Helping Hands - La Paz (Bolivia)', '289154022', '289154022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '289154022', '0', '', '0'),
('598', '598', 'FLORA BETTY QUISPE CONDOVERA', '6148382018', '6148382018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6148382018', '0', '', '0'),
('599', '599', 'Abigail Baltazar Guarachi', '8946450', '8946450', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8946450', '0', '', '0');
INSERT INTO `0_cust_branch` VALUES
('600', '600', 'Teresa Reinalda Ontiveros Gallardo', '7133359', '7133359', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7133359', '0', '', '0'),
('601', '601', 'JORGE EGUEZ', '2982312', '2982312', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2982312', '0', '', '0'),
('602', '602', 'ROGELIA CHIPANA YAPUCHURA', '4979487', '4979487', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4979487', '0', '', '0'),
('603', '603', 'raquel pocoata', '8348269016', '8348269016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8348269016', '0', '', '0'),
('604', '604', 'VALLEJOS', '8813566', '8813566', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8813566', '0', '', '0'),
('605', '605', 'GALLER', '7034474', '7034474', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7034474', '0', '', '0'),
('606', '606', '7034474', '5398077', '5398077', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5398077', '0', '', '0'),
('607', '607', 'Epifanio Alanoca Chavez', '2280272011', '2280272011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2280272011', '0', '', '0'),
('608', '608', 'CHOQUE', '3071866', '3071866', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3071866', '0', '', '0'),
('609', '609', 'AXONLINE LTDA', '169346024', '169346024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '169346024', '0', '', '0'),
('610', '610', 'Carlos Balderrama Orozco', '3999087013', '3999087013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3999087013', '0', '', '0'),
('611', '611', 'TRACKNET S.R.L.', '150520028', '150520028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '150520028', '0', '', '0'),
('612', '612', 'COANEG S.R.L.', '1022699026', '1022699026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1022699026', '0', '', '0'),
('613', '613', 'URIONA', '2719483011', '2719483011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2719483011', '0', '', '0'),
('614', '614', 'Diego Nemtala', '3752888013', '3752888013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3752888013', '0', '', '0'),
('615', '615', 'Hugo Ali', '6667645', '6667645', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6667645', '0', '', '0'),
('616', '616', 'RUDY RODOLFO RUIZ SALVATIERRA', '6273607011', '6273607011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6273607011', '0', '', '0'),
('617', '617', 'Comercializadora Bodylogic de Bolivia SA', '260042020', '260042020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '260042020', '0', '', '0'),
('618', '618', 'ANGEL ROBLES', '3127170', '3127170', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3127170', '0', '', '0'),
('619', '619', 'Gabriela Arvalo Angulo', '3393977010', '3393977010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3393977010', '0', '', '0'),
('620', '620', 'Franklin Nogales Peralta', '4662208010', '4662208010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4662208010', '0', '', '0'),
('621', '621', 'Marioly Suarez Vasquez', '5581143019', '5581143019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5581143019', '0', '', '0'),
('622', '622', 'Tania Rodriguez Condori', '5055511', '5055511', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5055511', '0', '', '0'),
('623', '623', 'MARISELA AGUIRRE CALLEJAS', '7737035011', '7737035011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7737035011', '0', '', '0'),
('624', '624', 'RICARDO RODRIGUEZ', '4418565010', '4418565010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4418565010', '0', '', '0'),
('625', '625', 'Julio Caballero', '387720014', '387720014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '387720014', '0', '', '0'),
('626', '626', 'juana aguilar', '1051022', '1051022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1051022', '0', '', '0'),
('627', '627', 'Hortencia Giovana Aramayo Carballo', '5643323', '5643323', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5643323', '0', '', '0'),
('628', '628', 'Javier Medrano', '3119972015', '3119972015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3119972015', '0', '', '0'),
('629', '629', 'YEVARA', '3352876', '3352876', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3352876', '0', '', '0'),
('630', '630', 'Rivera', '2639388014', '2639388014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2639388014', '0', '', '0'),
('631', '631', 'YANINA', '6352587', '6352587', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6352587', '0', '', '0'),
('632', '632', 'DOMINGO SANCHEZ EGUEZ', '3296545014', '3296545014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3296545014', '0', '', '0'),
('633', '633', 'Benavidez', '6477936010', '6477936010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6477936010', '0', '', '0'),
('634', '634', 'Ricardo Franco Ayllon Suyo', '7285045017', '7285045017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7285045017', '0', '', '0'),
('635', '635', 'Mariza Caba', '5070669016', '5070669016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5070669016', '0', '', '0'),
('636', '636', 'Sociedad Bblica Boliviana', '1023193021', '1023193021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1023193021', '0', '', '0'),
('637', '637', 'SILVIA EUGENIA LOPEZ VELASQUEZ', '8191473', '8191473', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8191473', '0', '', '0'),
('638', '638', 'Gustavo Ruiz', '6828753015', '6828753015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6828753015', '0', '', '0'),
('639', '639', 'ZENTENO', '3992746019', '3992746019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3992746019', '0', '', '0'),
('640', '640', 'RIVERA', '3461029', '3461029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3461029', '0', '', '0'),
('641', '641', 'villchez', '4777769011', '4777769011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4777769011', '0', '', '0'),
('642', '642', 'CENE S.A.', '195300020', '195300020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '195300020', '0', '', '0'),
('643', '643', 'Mamani', '5152371018', '5152371018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5152371018', '0', '', '0'),
('644', '644', 'Mariano Sosa', '3204615015', '3204615015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3204615015', '0', '', '0'),
('645', '645', 'Patty', '2600073', '2600073', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2600073', '0', '', '0'),
('646', '646', 'PROYECTO BOL 101403 - PNUD', '99001', '99001', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '99001', '0', '', '0'),
('647', '647', 'CAMACHO', '214077017', '214077017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '214077017', '0', '', '0'),
('648', '648', 'GRUPO APSIS S.R.L.', '343558021', '343558021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '343558021', '0', '', '0'),
('649', '649', 'Sergio Loma', '4305716', '4305716', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4305716', '0', '', '0'),
('650', '650', 'Dario Calizaya', '1357679015', '1357679015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1357679015', '0', '', '0'),
('651', '651', 'Omar Porcel', '994816016', '994816016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '994816016', '0', '', '0'),
('652', '652', 'Roberto Romero', '8137176019', '8137176019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8137176019', '0', '', '0'),
('653', '653', 'Mery lilian ruiz cabrera', '7727860', '7727860', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7727860', '0', '', '0'),
('654', '654', 'Jorge Diaz', '2976760', '2976760', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2976760', '0', '', '0'),
('655', '655', 'Blanca Encinas', '3760950', '3760950', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3760950', '0', '', '0'),
('656', '656', 'Marco Antonio Cordova', '3879487', '3879487', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3879487', '0', '', '0'),
('657', '657', 'IDEAS INTELIGENTES SRL', '65852517', '65852517', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '65852517', '0', '', '0'),
('658', '658', 'JUAN DANIEL VIDAL CAZAS', '5471418018', '5471418018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5471418018', '0', '', '0'),
('659', '659', 'murillo', '4068098', '4068098', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4068098', '0', '', '0'),
('660', '660', 'GRUPO ASEBEY SRL', '256962020', '256962020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '256962020', '0', '', '0'),
('661', '661', 'susy barca', '5798190', '5798190', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5798190', '0', '', '0'),
('662', '662', 'Norah Terceros', '2929715012', '2929715012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2929715012', '0', '', '0'),
('663', '663', 'DMC S.A.', '1028679029', '1028679029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1028679029', '0', '', '0'),
('664', '664', 'LEDY TERESA PINTO ANDIA', '3962850012', '3962850012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3962850012', '0', '', '0'),
('665', '665', 'Raul Fernando Cardenas irahola', '5338104', '5338104', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5338104', '0', '', '0'),
('666', '666', 'JUAN BAUTISTA LEON', '7166661', '7166661', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7166661', '0', '', '0'),
('667', '667', 'METALCI S.A.', '135005024', '135005024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '135005024', '0', '', '0'),
('668', '668', 'BOHIVA ENGINEERING SRL', '141243022', '141243022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '141243022', '0', '', '0'),
('669', '669', 'CAMWAVE SRL', '174512021', '174512021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '174512021', '0', '', '0'),
('670', '670', 'Dennis Vicente Ayala Quispe', '6721762013', '6721762013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6721762013', '0', '', '0'),
('671', '671', 'Cinthia Bazoalto', '5233399010', '5233399010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5233399010', '0', '', '0'),
('672', '672', 'Jess Guzmn', '3731329', '3731329', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3731329', '0', '', '0'),
('673', '673', 'Perez', '7081669', '7081669', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7081669', '0', '', '0'),
('674', '674', 'Pirovano', '8793101', '8793101', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8793101', '0', '', '0'),
('675', '675', 'Yumans Reguerin', '5345612', '5345612', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5345612', '0', '', '0'),
('676', '676', 'ALCIDES BAQUEROS CUELLAR', '3041103018', '3041103018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3041103018', '0', '', '0'),
('677', '677', 'Alejandra Rivero', '4643626', '4643626', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4643626', '0', '', '0'),
('678', '678', 'Vargas', '4425708013', '4425708013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4425708013', '0', '', '0'),
('679', '679', 'Claudia Mendoza', '7998144012', '7998144012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7998144012', '0', '', '0'),
('680', '680', 'Mamani', '8315948', '8315948', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8315948', '0', '', '0'),
('681', '681', 'UNEC S.A.', '135891024', '135891024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '135891024', '0', '', '0'),
('682', '682', 'PLANETCONST SRL', '294918024', '294918024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '294918024', '0', '', '0'),
('683', '683', 'Marcelo Gedeon Mamani Corazon', '7022295013', '7022295013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7022295013', '0', '', '0'),
('684', '684', 'Pantoja', '4942387013', '4942387013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4942387013', '0', '', '0'),
('685', '685', 'plus agro s.r.l.', '1025207023', '1025207023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1025207023', '0', '', '0'),
('686', '686', 'POWERGEN SRL', '237606022', '237606022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '237606022', '0', '', '0'),
('687', '687', 'Montero', '5470260011', '5470260011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5470260011', '0', '', '0'),
('688', '688', 'Gabino Alex Challco', '9214309013', '9214309013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '9214309013', '0', '', '0'),
('689', '689', 'ELIAS FUENTES CHAMBI', '3972578017', '3972578017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3972578017', '0', '', '0'),
('690', '690', 'Eiverth Castro Mamani', '3488582', '3488582', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3488582', '0', '', '0'),
('691', '691', 'OCIS S.R.L.', '146066029', '146066029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '146066029', '0', '', '0'),
('692', '692', 'Barrero &amp; Asociados S.R.L', '313994021', '313994021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '313994021', '0', '', '0'),
('693', '693', 'Neiza Sandra Monasterios Torrez', '3525649', '3525649', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3525649', '0', '', '0'),
('694', '694', 'BOTELLO', '4774084017', '4774084017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4774084017', '0', '', '0'),
('695', '695', 'Zeballos', '7893752', '7893752', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7893752', '0', '', '0'),
('696', '696', 'Henrry Feliciano Cayo Condori', '6637839', '6637839', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6637839', '0', '', '0'),
('697', '697', 'INOLSA S.R.L.', '159896028', '159896028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '159896028', '0', '', '0'),
('698', '698', 'Lenny Olivera Flores', '3623173', '3623173', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3623173', '0', '', '0'),
('699', '699', 'JULIO CESAR ANTELO ARIAS', '8157423', '8157423', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8157423', '0', '', '0'),
('700', '700', 'HERLAND MARTIN MARAZA', '5331687018', '5331687018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5331687018', '0', '', '0'),
('701', '701', 'Vicky Coca', '3186357', '3186357', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3186357', '0', '', '0'),
('702', '702', 'LegalPro Soc. Civ.', '149768022', '149768022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '149768022', '0', '', '0'),
('703', '703', 'Antonio Bastida Hormigo', '13511875', '13511875', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '13511875', '0', '', '0'),
('704', '704', 'TEC CENTER SRL', '251326028', '251326028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '251326028', '0', '', '0'),
('705', '705', 'Janeth Herbas Zurita', '4418256016', '4418256016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4418256016', '0', '', '0'),
('706', '706', 'Zeballos', '8841810', '8841810', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8841810', '0', '', '0'),
('707', '707', 'Paredes', '2604395', '2604395', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2604395', '0', '', '0'),
('708', '708', 'PK Bolivia S.R.L.', '256426028', '256426028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '256426028', '0', '', '0'),
('709', '709', 'MAXAM FANEXA SAM', '1023249027', '1023249027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1023249027', '0', '', '0'),
('710', '710', 'CMAIO SRL', '306830025', '306830025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '306830025', '0', '', '0'),
('711', '711', 'FERNANDEZ', '4841723', '4841723', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4841723', '0', '', '0'),
('712', '712', 'BIOGENESIS BAGO BOLIVIA S.A.', '1014835023', '1014835023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1014835023', '0', '', '0'),
('713', '713', 'SANTOKH SRL', '283650021', '283650021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '283650021', '0', '', '0'),
('714', '714', 'Tellez', '2728892', '2728892', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2728892', '0', '', '0'),
('715', '715', 'EMPRESA CONSTRUCTORA ROYAL S.R.L.', '1023743025', '1023743025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1023743025', '0', '', '0'),
('716', '716', 'MENDEZ', '3746488013', '3746488013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3746488013', '0', '', '0'),
('717', '717', 'Sanchez', '2905110', '2905110', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2905110', '0', '', '0'),
('718', '718', 'Fernandez', '6433658019', '6433658019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6433658019', '0', '', '0'),
('719', '719', 'Mitma Dafnee Chacon Rivera', '5425600', '5425600', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5425600', '0', '', '0'),
('720', '720', 'Wolfi Enzo Velasco Medina', '3235441014', '3235441014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3235441014', '0', '', '0'),
('721', '721', 'MALDONADO', '3722349019', '3722349019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3722349019', '0', '', '0'),
('722', '722', 'Edgar Medina', '2732977', '2732977', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2732977', '0', '', '0'),
('723', '723', 'Guzmn', '3491955', '3491955', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3491955', '0', '', '0'),
('724', '724', 'Patricia Antelo Higazy', '2988130011', '2988130011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2988130011', '0', '', '0'),
('725', '725', 'Alan Diez', '8863998', '8863998', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8863998', '0', '', '0'),
('726', '726', 'TORREZ Y HUANSBER ASOCIADOS SRL', '178052022', '178052022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '178052022', '0', '', '0'),
('727', '727', 'Luis Fernando Ramirez Loaiza', '7831440', '7831440', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7831440', '0', '', '0'),
('728', '728', 'GUTIERREZ', '3489792', '3489792', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3489792', '0', '', '0'),
('729', '729', 'Elfia Rivero', '1736867014', '1736867014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1736867014', '0', '', '0'),
('730', '730', 'Alvaro Garron', '2628604', '2628604', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2628604', '0', '', '0'),
('731', '731', 'Raul Carrillo', '5052451', '5052451', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5052451', '0', '', '0'),
('732', '732', 'Baltazar', '6514218', '6514218', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6514218', '0', '', '0'),
('733', '733', 'Cabrera, Cordova y Asociados Ltda.', '1017227024', '1017227024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1017227024', '0', '', '0'),
('734', '734', 'MEGA MOLIBOL S.R.L.', '297460021', '297460021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '297460021', '0', '', '0'),
('735', '735', 'OLIVARES', '4836936018', '4836936018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4836936018', '0', '', '0'),
('736', '736', 'EINAR RAMOS ALVAREZ', '4161617', '4161617', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4161617', '0', '', '0'),
('737', '737', 'Fundacin Pro Mujer', '173342029', '173342029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '173342029', '0', '', '0'),
('738', '738', 'JAIME GUERRERO PAREDES', '3050120018', '3050120018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3050120018', '0', '', '0'),
('739', '739', 'Laury Cuellar', '7464299', '7464299', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7464299', '0', '', '0'),
('740', '740', 'Elvy Paz Mendoza', '5389229', '5389229', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5389229', '0', '', '0'),
('741', '741', 'DIEGO VILLARROEL', '3882007', '3882007', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3882007', '0', '', '0'),
('742', '742', 'cimar acua', '5112391', '5112391', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5112391', '0', '', '0'),
('743', '743', 'SERGIO SANDOVAL', '4118441013', '4118441013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4118441013', '0', '', '0'),
('744', '744', 'VILLAGOMEZ', '6872321018', '6872321018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6872321018', '0', '', '0'),
('745', '745', 'RUBEN DARIO QUINTEROS SOLARES', '7595968', '7595968', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7595968', '0', '', '0'),
('746', '746', 'Jarly Betancourt Vallejos', '5780170015', '5780170015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5780170015', '0', '', '0'),
('747', '747', 'Yujra', '4905526014', '4905526014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4905526014', '0', '', '0'),
('748', '748', 'ojeda', '2714128', '2714128', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2714128', '0', '', '0'),
('749', '749', 'trans 22 de septiembre', '6002815012', '6002815012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6002815012', '0', '', '0'),
('750', '750', 'ordoez', '6532190', '6532190', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6532190', '0', '', '0'),
('751', '751', 'JOSE INTURIAS SANCHEZ', '2884387015', '', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '', '0', '', '0'),
('752', '752', 'VALLEJOS', '6516780', '6516780', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6516780', '0', '', '0'),
('753', '753', 'PALACIOS', '6422060019', '6422060019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6422060019', '0', '', '0'),
('754', '754', 'Vernica Soza', '1317736012', '1317736012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1317736012', '0', '', '0'),
('755', '755', 'Raices Import Export Ltda.', '1027943022', '1027943022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1027943022', '0', '', '0'),
('756', '756', 'KINESIS TECHNOLOGY S.R.L.', '298750026', '298750026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '298750026', '0', '', '0'),
('757', '757', 'Hector Lima Calapia', '7170073', '7170073', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7170073', '0', '', '0'),
('758', '758', 'Arce', '4339706013', '4339706013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4339706013', '0', '', '0'),
('759', '759', 'EPSA PUERTO RICO', '125341021', '125341021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '125341021', '0', '', '0'),
('760', '760', 'NICOLAS VARGAS', '5111214011', '5111214011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5111214011', '0', '', '0'),
('761', '761', 'EMPRESA MINERA MONTE GRANDE S.R.L.', '310862029', '310862029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '310862029', '0', '', '0'),
('762', '762', 'Dionisio Copa', '1335325', '1335325', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1335325', '0', '', '0'),
('763', '763', 'EMPRESA CONSTRUCTORA DEXIA SRL', '293662023', '293662023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '293662023', '0', '', '0'),
('764', '764', 'MARITIME SERVICES LINE BOLIVIA SRL', '156684023', '156684023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '156684023', '0', '', '0'),
('765', '765', 'CORDOVA', '2355917', '2355917', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2355917', '0', '', '0'),
('766', '766', 'LA GUITA S.R.L.', '136291021', '136291021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '136291021', '0', '', '0'),
('767', '767', 'Victor Hugo Condorcett', '1037135011', '1037135011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1037135011', '0', '', '0'),
('768', '768', 'Matilde Saavedra Isita', '7630603013', '7630603013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7630603013', '0', '', '0'),
('769', '769', 'APRAE-TOTORA', '175300029', '175300029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '175300029', '0', '', '0'),
('770', '770', 'GALGOSERV SRL.', '310812023', '310812023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '310812023', '0', '', '0'),
('771', '771', 'Pablo Ramirez', '4252748', '4252748', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4252748', '0', '', '0'),
('772', '772', 'NEXUS TECHNOLOGY BOLIVIA SA', '1001805020', '1001805020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1001805020', '0', '', '0'),
('773', '773', 'Jose Noe Aguilera', '4661756', '4661756', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4661756', '0', '', '0'),
('774', '774', 'Carlos Flores', '1808707010', '1808707010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1808707010', '0', '', '0'),
('775', '775', 'Henrique Harms', '6279912', '6279912', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6279912', '0', '', '0'),
('776', '776', 'Maria Rene Pereira', '5899264010', '5899264010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5899264010', '0', '', '0'),
('777', '777', 'ALI', '6996060', '6996060', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6996060', '0', '', '0'),
('778', '778', 'VALLE', '2629868014', '2629868014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2629868014', '0', '', '0'),
('779', '779', 'VARGAS', '988694010', '988694010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '988694010', '0', '', '0'),
('780', '780', 'Rocio Sandoval', '1936774', '1936774', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1936774', '0', '', '0'),
('781', '781', 'luis aguilar', '5883645', '5883645', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5883645', '0', '', '0'),
('782', '782', 'MANUEL SOSA CABRERA', '4921282', '4921282', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4921282', '0', '', '0'),
('783', '783', 'FERRUFINO', '6084704', '6084704', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6084704', '0', '', '0'),
('784', '784', 'carolina almanza lopez', '5416483015', '5416483015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5416483015', '0', '', '0'),
('785', '785', 'diego berazain', '5111098011', '5111098011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5111098011', '0', '', '0'),
('786', '786', 'David Arevalo', '815383', '815383', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '815383', '0', '', '0'),
('787', '787', 'IBERICA SRL', '162040020', '162040020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '162040020', '0', '', '0'),
('788', '788', 'CENTRO CULTURAL ALEMAN', '1017049020', '1017049020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1017049020', '0', '', '0'),
('789', '789', 'Flores Pamela', '5159803013', '5159803013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5159803013', '0', '', '0'),
('790', '790', 'Libreria y Papeleria Olimpia S.R.L.', '1020267022', '1020267022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1020267022', '0', '', '0'),
('791', '791', 'REYES', '5989229019', '5989229019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5989229019', '0', '', '0'),
('792', '792', 'DELONIX S.R.L.', '336288024', '336288024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '336288024', '0', '', '0'),
('793', '793', 'Henry Gallardo Ardaya', '3902650', '3902650', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3902650', '0', '', '0'),
('794', '794', 'Ruth Peralta', '391971011', '391971011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '391971011', '0', '', '0'),
('795', '795', 'PLAZA LISSET', '5153674', '5153674', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5153674', '0', '', '0'),
('796', '796', 'Jhonatan canedo', '8792457', '8792457', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8792457', '0', '', '0'),
('797', '797', 'Chanel Vsquez Suarez', '5354435', '5354435', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5354435', '0', '', '0'),
('798', '798', 'fernando valverde arana', '8932731010', '8932731010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8932731010', '0', '', '0'),
('799', '799', 'Rios', '4773696016', '4773696016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4773696016', '0', '', '0'),
('800', '800', 'SALAZAR', '3379319014', '3379319014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3379319014', '0', '', '0'),
('801', '801', 'NICOLAS', '6749886', '6749886', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6749886', '0', '', '0'),
('802', '802', 'IPSOS APOYO OPINION Y MERCADO SA', '1016423027', '1016423027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1016423027', '0', '', '0'),
('803', '803', 'SILVA', '3498962017', '3498962017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3498962017', '0', '', '0'),
('804', '804', 'Luis Daniel Mamani Zabala ', '6334514', '6334514', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6334514', '0', '', '0'),
('805', '805', 'Sociedad Industrial Ceramica Santa Cruz Ltda', '1012223027', '1012223027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1012223027', '0', '', '0'),
('806', '806', 'publicidad e inmobiliaria Icbolivia S.A', '320412028', '320412028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '320412028', '0', '', '0'),
('807', '807', 'CEFA  ASOCIADOS SRL', '1018227021', '1018227021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1018227021', '0', '', '0'),
('808', '808', 'Sergio Carreo', '6392606', '6392606', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6392606', '0', '', '0'),
('809', '809', 'CONEXIONES ENTRE MUNDOS S.R.L.', '194648021', '194648021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '194648021', '0', '', '0'),
('810', '810', 'Gonzales', '6871855014', '6871855014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6871855014', '0', '', '0'),
('811', '811', 'Quispe', '2690548011', '2690548011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2690548011', '0', '', '0'),
('812', '812', 'TESSCO S.R.L.', '1021707029', '1021707029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1021707029', '0', '', '0'),
('813', '813', 'IVAN JAIME ALEJANDRO HUAQUISACA', '9184319', '9184319', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '9184319', '0', '', '0'),
('814', '814', 'Gladys Aguilar Villarroel', '9819062017', '9819062017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '9819062017', '0', '', '0'),
('815', '815', 'felicidad viza alvarez', '4787194014', '4787194014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4787194014', '0', '', '0'),
('816', '816', 'WALTER ZUNIGA', '5857398', '5857398', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5857398', '0', '', '0'),
('817', '817', 'Wilmer Chipana', '4892156019', '4892156019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4892156019', '0', '', '0'),
('818', '818', 'rodriguez', '4048202015', '4048202015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4048202015', '0', '', '0'),
('819', '819', 'Mamani', '6071945018', '6071945018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6071945018', '0', '', '0'),
('820', '820', 'Iveth Ortiz Serrudo', '7478610019', '7478610019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7478610019', '0', '', '0'),
('821', '821', 'vasquez', '4057454', '4057454', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4057454', '0', '', '0'),
('822', '822', 'Cons-i', '3817450013', '3817450013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3817450013', '0', '', '0'),
('823', '823', 'Gomez', '4834705', '4834705', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4834705', '0', '', '0'),
('824', '824', 'Maria Carolina Patino Porcel ', '5355108013', '5355108013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5355108013', '0', '', '0'),
('825', '825', 'Salomon rojas sanchez', '3581795017', '3581795017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3581795017', '0', '', '0'),
('826', '826', 'JAVIER QUINTANA', '4728092', '4728092', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4728092', '0', '', '0'),
('827', '827', 'Villarroel', '2557467016', '2557467016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2557467016', '0', '', '0'),
('828', '828', 'Liz Castelln', '3602297', '3602297', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3602297', '0', '', '0'),
('829', '829', 'LLanco', '4911746', '4911746', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4911746', '0', '', '0'),
('830', '830', 'Lujan', '3448468', '3448468', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3448468', '0', '', '0'),
('831', '831', 'Jose Maria Justiniano Rivero', '5893085', '5893085', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5893085', '0', '', '0'),
('832', '832', 'Javier Pomacusi Ballesteros', '4092378013', '4092378013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4092378013', '0', '', '0'),
('833', '833', 'Maximo Baldiviezo C', '4737690', '4737690', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4737690', '0', '', '0'),
('834', '834', 'GISBERT Y CIA. S.A.', '1007043027', '1007043027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1007043027', '0', '', '0'),
('835', '835', 'RENE FERNANDO CHAVEZ', '3562142016', '3562142016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3562142016', '0', '', '0'),
('836', '836', 'Miranda', '3159852010', '3159852010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3159852010', '0', '', '0'),
('837', '837', 'German Soliz ', '874255016', '874255016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '874255016', '0', '', '0'),
('838', '838', 'Eloy Ignacio Ramos Quispe', '3971163019', '3971163019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3971163019', '0', '', '0'),
('839', '839', 'Ramiro Juan Montecinos Viscarra', '3283657', '3283657', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3283657', '0', '', '0'),
('840', '840', 'Leoncio Ruiz Figueroa', '2937532', '2937532', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2937532', '0', '', '0'),
('841', '841', 'Ronald Aez Souza', '5590288019', '5590288019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5590288019', '0', '', '0'),
('842', '842', 'Brocha Gorda Srl', '292748026', '292748026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '292748026', '0', '', '0'),
('843', '843', 'Ximena Len', '4325531012', '4325531012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4325531012', '0', '', '0'),
('844', '844', 'MARCOS LOPEZ', '3770853019', '3770853019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3770853019', '0', '', '0'),
('845', '845', 'delgadiilo', '3382299017', '3382299017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3382299017', '0', '', '0'),
('846', '846', 'villegas', '3748847', '3748847', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3748847', '0', '', '0'),
('847', '847', 'lilian choque', '4948162', '4948162', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4948162', '0', '', '0'),
('848', '848', 'TABULARIS CONSULTORES SRL', '344198022', '344198022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '344198022', '0', '', '0'),
('849', '849', 'MEFP', '1001543025', '1001543025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1001543025', '0', '', '0'),
('850', '850', 'Jenny Chugar de Andrade', '3533898017', '3533898017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3533898017', '0', '', '0'),
('851', '851', 'PEREZ', '2051792016', '2051792016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2051792016', '0', '', '0'),
('852', '852', 'SAUL GUTIERREZ ZUAZO', '5097380', '5097380', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5097380', '0', '', '0'),
('853', '853', 'H&amp;S AUDITORES Y CONSULTORES S.R.L.', '318824028', '318824028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '318824028', '0', '', '0'),
('854', '854', 'Patricia Elke Leon Vargas', '5721040011', '5721040011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5721040011', '0', '', '0'),
('855', '855', 'Curtiembres Arcuel Srl', '161062023', '161062023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '161062023', '0', '', '0'),
('856', '856', 'RODUGA INVERSIONES S.A.', '145186023', '145186023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '145186023', '0', '', '0'),
('857', '857', 'Enrique Luis Cruz V.', '3228505019', '3228505019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3228505019', '0', '', '0'),
('858', '858', 'Armando Honorio', '2623506', '2623506', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2623506', '0', '', '0'),
('859', '859', 'DISTRIBUIDORA ANDESFILMS S.A.', '316490028', '316490028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '316490028', '0', '', '0'),
('860', '860', 'wilson Luna', '3320950010', '3320950010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3320950010', '0', '', '0'),
('861', '861', 'RVALER Y ASOCIADOS S.R.L.', '328828026', '328828026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '328828026', '0', '', '0'),
('862', '862', 'Rolando Iglesias', '1054466014', '1054466014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1054466014', '0', '', '0'),
('863', '863', 'KARLA LORENA MIRANDA ALCOBA', '10810983014', '10810983014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '10810983014', '0', '', '0'),
('864', '864', 'CLAUDIA ROJAS ARANCIBIA', '5413232', '5413232', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5413232', '0', '', '0'),
('865', '865', 'Cortez', '3421416019', '3421416019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3421416019', '0', '', '0'),
('866', '866', 'Pozo', '6114982012', '6114982012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6114982012', '0', '', '0'),
('867', '867', 'Servicios Generales Extra SRL', '298696025', '298696025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '298696025', '0', '', '0'),
('868', '868', 'Willma Limachi Ramos', '3719948018', '3719948018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3719948018', '0', '', '0'),
('869', '869', 'Cristian lima fermin', '8215559', '8215559', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8215559', '0', '', '0'),
('870', '870', 'karen velasquez torrez', '8402190014', '8402190014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8402190014', '0', '', '0'),
('871', '871', 'SHOGUN S.R.L', '173664029', '173664029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '173664029', '0', '', '0'),
('872', '872', 'israel Jesus Fernandez Mercado', '6842910', '6842910', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6842910', '0', '', '0'),
('873', '873', 'Maribel Perez Rivera', '9010872018', '9010872018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '9010872018', '0', '', '0'),
('874', '874', 'EDUCAINNOVANDO CONSULTORES SRL', '281422023', '281422023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '281422023', '0', '', '0'),
('875', '875', 'Juan Carlos Claudio', '3883844', '3883844', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3883844', '0', '', '0'),
('876', '876', 'fabian illanes ribera', '9717128', '9717128', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '9717128', '0', '', '0'),
('877', '877', 'Paola Rosales Montao', '6226075014', '6226075014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6226075014', '0', '', '0'),
('878', '878', 'Vanesa Apaza Guerra', '6245978', '6245978', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6245978', '0', '', '0'),
('879', '879', 'David Durn', '7501736010', '7501736010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7501736010', '0', '', '0'),
('880', '880', 'Pacea Srl. Agencia Desp. de Aduana', '1020511026', '1020511026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1020511026', '0', '', '0'),
('881', '881', 'SIMAPETROL S.R.L.', '162306028', '162306028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '162306028', '0', '', '0'),
('882', '882', 'Veronica Escalante', '7466561', '7466561', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7466561', '0', '', '0'),
('883', '883', 'JVJVIRTUAL', '7745081012', '7745081012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7745081012', '0', '', '0'),
('884', '884', 'denard Mendez', '3886222', '3886222', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3886222', '0', '', '0'),
('885', '885', 'Navarro', '4306899018', '4306899018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4306899018', '0', '', '0'),
('886', '886', 'Vela ', '4287590016', '4287590016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4287590016', '0', '', '0'),
('887', '887', 'Gustavo Davalos Coca', '3755792018', '3755792018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3755792018', '0', '', '0'),
('888', '888', 'Rodriguez', '4048600015', '4048600015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4048600015', '0', '', '0'),
('889', '889', 'S.E.C. S.R.L.', '1009477024', '1009477024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1009477024', '0', '', '0'),
('890', '890', 'MAMANI', '5181973', '5181973', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5181973', '0', '', '0'),
('891', '891', 'Angela Lucia Galvez Perez', '7463048013', '7463048013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7463048013', '0', '', '0'),
('892', '892', 'Mamani', '6812832', '6812832', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6812832', '0', '', '0'),
('893', '893', 'Maria Diaz', '7612602018', '7612602018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7612602018', '0', '', '0'),
('894', '894', 'Maria Luisa Arenas Medina', '1112631', '1112631', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1112631', '0', '', '0'),
('895', '895', 'GANESHA LTDA', '175626029', '175626029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '175626029', '0', '', '0'),
('896', '896', 'Ortuo', '4870675', '4870675', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4870675', '0', '', '0'),
('897', '897', 'Hooper', '5224517', '5224517', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5224517', '0', '', '0'),
('898', '898', 'Silvia rodriguez', '4509656', '4509656', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4509656', '0', '', '0'),
('899', '899', 'Ana Estfano Ramos Uceda', '6029584', '6029584', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6029584', '0', '', '0'),
('900', '900', 'ROMAY', '4938123', '4938123', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4938123', '0', '', '0'),
('901', '901', 'karina justiniano justiniano', '3931130019', '3931130019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3931130019', '0', '', '0'),
('902', '902', 'Juan Fernandez', '5756239', '5756239', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5756239', '0', '', '0'),
('903', '903', 'julio cesar tasseo', '4590609012', '4590609012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4590609012', '0', '', '0'),
('904', '904', 'Eliot Rodriguez', '6383551', '6383551', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6383551', '0', '', '0'),
('905', '905', 'CALLAU', '3871220012', '3871220012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3871220012', '0', '', '0'),
('906', '906', 'Rios', '3753827', '3753827', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3753827', '0', '', '0'),
('907', '907', 'Lizarda justiniano abrego', '7661910015', '7661910015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7661910015', '0', '', '0'),
('908', '908', 'Pamela Espejo', '6198111012', '6198111012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6198111012', '0', '', '0'),
('909', '909', 'CINTHIA JIMENA ORTEGA MORALES', '7722214019', '7722214019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7722214019', '0', '', '0'),
('910', '910', 'La ciudad de los nios', '1008811029', '1008811029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1008811029', '0', '', '0'),
('911', '911', 'BOLIVIA AUDITORES B.A.', '120607022', '120607022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '120607022', '0', '', '0'),
('912', '912', 'MOVTERRA S.R.L.', '280288028', '280288028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '280288028', '0', '', '0'),
('913', '913', 'IVONNE PACO', '5657690', '5657690', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5657690', '0', '', '0'),
('914', '914', 'OCHOA', '6191262013', '6191262013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6191262013', '0', '', '0'),
('915', '915', 'Gloria Romina Vila Fernandez', '8993905014', '8993905014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8993905014', '0', '', '0'),
('916', '916', 'Yuri Roman Crdenas', '3372670014', '3372670014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3372670014', '0', '', '0'),
('917', '917', 'Calatayud', '6047790', '6047790', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6047790', '0', '', '0'),
('918', '918', 'Bernardo Antonio Veragua Salazar', '6357555017', '6357555017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6357555017', '0', '', '0'),
('919', '919', 'Luis Rodriguez', '6339019019', '6339019019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6339019019', '0', '', '0'),
('920', '920', 'SAUL PABLO BERNAL ALCOCER', '7807399', '7807399', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7807399', '0', '', '0'),
('921', '921', 'Paul David Aruquipa Escobar', '3397307', '3397307', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3397307', '0', '', '0'),
('922', '922', 'SHEIYLA MAES FARFAN', '3491706', '3491706', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3491706', '0', '', '0'),
('923', '923', 'INSTITUTO FRANCO BOLIVIANOS', '1020543026', '1020543026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1020543026', '0', '', '0'),
('924', '924', 'Loredo', '5692292', '5692292', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5692292', '0', '', '0'),
('925', '925', 'ZOILA ROJAS', '3924791', '3924791', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3924791', '0', '', '0'),
('926', '926', 'Fernando choque llave', '6638857', '6638857', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6638857', '0', '', '0'),
('927', '927', 'Bertha Apaza Vargas', '4932432', '4932432', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4932432', '0', '', '0'),
('928', '928', 'Angela Machua Morales', '8966226', '8966226', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8966226', '0', '', '0'),
('929', '929', 'Luis Fernando Escobar Tellez', '4479771', '4479771', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4479771', '0', '', '0'),
('930', '930', 'Pabel Alex Villarroel Sandoval', '5642827012', '5642827012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5642827012', '0', '', '0'),
('931', '931', 'Bimar Chile Soto', '4020313', '4020313', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4020313', '0', '', '0');
INSERT INTO `0_cust_branch` VALUES
('932', '932', 'Aeroprpov SRL', '212648025', '212648025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '212648025', '0', '', '0'),
('933', '933', 'Ruben Conde', '4900588011', '4900588011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4900588011', '0', '', '0'),
('934', '934', 'LOURDES MARCELA VELASCO', '3400892010', '3400892010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3400892010', '0', '', '0'),
('935', '935', 'AHEC SRL', '281048022', '281048022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '281048022', '0', '', '0'),
('936', '936', 'Jianfan Chen', '4933510011', '4933510011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4933510011', '0', '', '0'),
('937', '937', 'Enrique Mendieta', '5275672', '5275672', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5275672', '0', '', '0'),
('938', '938', 'PHISIO BASIC SRL', '163626025', '163626025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '163626025', '0', '', '0'),
('939', '939', 'Joaquin Flores Coronado', '4087973016', '4087973016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4087973016', '0', '', '0'),
('940', '940', 'Gustavo Simon gonzales carrizales', '4384377015', '4384377015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4384377015', '0', '', '0'),
('941', '941', 'FABOPAL S.A.', '1008255028', '1008255028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1008255028', '0', '', '0'),
('942', '942', 'Elvia Yssy Velasquez Villarroel', '7704434', '7704434', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7704434', '0', '', '0'),
('943', '943', 'FICHTNER GmbH &amp; Co. KG', '125891026', '125891026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '125891026', '0', '', '0'),
('944', '944', 'Maria Eugenia Rocha Calvimontes', '1116319013', '1116319013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1116319013', '0', '', '0'),
('945', '945', 'Yenny Zenteno', '9591347018', '9591347018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '9591347018', '0', '', '0'),
('946', '946', 'Graciela Len Angulo', '5341163', '5341163', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5341163', '0', '', '0'),
('947', '947', 'Condori', '8344008', '8344008', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8344008', '0', '', '0'),
('948', '948', 'Medicus Mundi', '1020015025', '1020015025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1020015025', '0', '', '0'),
('949', '949', 'Elias Peredo', '5414587019', '5414587019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5414587019', '0', '', '0'),
('950', '950', 'PASAPORTES VIAJES Y TURISMO S.R.L.', '1008367029', '1008367029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1008367029', '0', '', '0'),
('951', '951', 'ROMERO', '5228566017', '5228566017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5228566017', '0', '', '0'),
('952', '952', 'Aviles', '6733643', '6733643', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6733643', '0', '', '0'),
('953', '953', 'MILTON RODRIGO CONTRERAS SARAVIA', '6236425011', '6236425011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6236425011', '0', '', '0'),
('954', '954', 'ROSA VILLARPANDO', '7479123', '7479123', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7479123', '0', '', '0'),
('955', '955', 'Maria Isabel Copa Condori', '5720860', '5720860', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5720860', '0', '', '0'),
('956', '956', 'Rodriguez', '3393572011', '3393572011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3393572011', '0', '', '0'),
('957', '957', 'EDUARDO SALAMANCA ANTEQUERA', '5520090016', '5520090016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5520090016', '0', '', '0'),
('958', '958', 'SERIGRAFA GEELE S.R.L.', '1017033023', '1017033023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1017033023', '0', '', '0'),
('959', '959', 'Wilmar Stelzer Talavera', '7834145017', '7834145017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7834145017', '0', '', '0'),
('960', '960', 'Patricia Elke Leon Vargas', ' 5721040011', ' 5721040011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', ' 5721040011', '0', '', '0'),
('961', '961', '	IRMA FERNANDEZ IBARRA', '8524362', '8524362', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8524362', '0', '', '0'),
('962', '962', 'GUEVARA', '6948000', '6948000', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6948000', '0', '', '0'),
('963', '963', 'Javier Ach Colque', '4055873014', '4055873014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4055873014', '0', '', '0'),
('964', '964', 'Ballester', '5500491016', '5500491016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5500491016', '0', '', '0'),
('965', '965', 'ARIEL ROBLES VASQUEZ', '4573073', '4573073', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4573073', '0', '', '0'),
('966', '966', 'Vanessa Balcera Cruz', '8890169019', '8890169019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8890169019', '0', '', '0'),
('967', '967', 'ARBOTT LTDA', '1004517027', '1004517027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1004517027', '0', '', '0'),
('968', '968', 'Mary Selva Jordan', '6361834016', '6361834016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6361834016', '0', '', '0'),
('969', '969', 'TELMA VELASQUEZ ORTUSTE', '5683243017', '5683243017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5683243017', '0', '', '0'),
('970', '970', 'SHARAD CHANDER DHINGRA', '317076027', '317076027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '317076027', '0', '', '0'),
('971', '971', 'Kenia Melgar Cespedes', '8130422', '8130422', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8130422', '0', '', '0'),
('972', '972', 'Mauricio Barriga', '	 4662826016', '	\n4662826016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '	\n4662826016', '0', '', '0'),
('973', '973', 'CROWN LTDA', '1023113020', '1023113020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1023113020', '0', '', '0'),
('974', '974', 'claudia Yolanda Hurtado Grock', '3292355', '3292355', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3292355', '0', '', '0'),
('975', '975', 'Ormachea', '4807267', '4807267', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4807267', '0', '', '0'),
('976', '976', 'Cuevas', '3366979011', '3366979011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3366979011', '0', '', '0'),
('977', '977', 'MAEXPROBOL S.R.L.', '142749020', '142749020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '142749020', '0', '', '0'),
('978', '978', 'CARLA ANDREA ROMERO RODAS', '7135509', '7135509', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7135509', '0', '', '0'),
('979', '979', 'Gina Ojeda Medina', '4701761', '4701761', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4701761', '0', '', '0'),
('980', '980', 'ACERCATE S.R.L.', '219204026', '219204026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '219204026', '0', '', '0'),
('981', '981', 'VICARIATO APOSTOLICO DE PANDO', '125697029', '125697029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '125697029', '0', '', '0'),
('982', '982', 'Servicios Integrales Quality Srl', '279530026', '279530026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '279530026', '0', '', '0'),
('983', '983', 'Quisbert', '4951228', '4951228', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4951228', '0', '', '0'),
('984', '984', 'A&amp;P INDUSTRIAL S.R.L', '342294027', '342294027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '342294027', '0', '', '0'),
('985', '985', 'WILIAM ROMARIO CONDORI HUANCA', '9978236014', '9978236014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '9978236014', '0', '', '0'),
('986', '986', 'Tocokari', '6465113015', '6465113015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6465113015', '0', '', '0'),
('987', '987', 'Querubin Rivero Muyuro', '5600780011', '5600780011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5600780011', '0', '', '0'),
('988', '988', 'Eddy Torrico', '3359749', '3359749', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3359749', '0', '', '0'),
('989', '989', 'AUDIWORK S.R.L.', '336030025', '336030025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '336030025', '0', '', '0'),
('990', '990', 'Edith lopez', '4046488', '4046488', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4046488', '0', '', '0'),
('991', '991', 'Luis Felipe Alanes Cordova', '485414', '485414', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '485414', '0', '', '0'),
('992', '992', 'calatayud', '8333813015', '8333813015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8333813015', '0', '', '0'),
('993', '993', 'Fernando Pozo Villarroel', '1739766014', '1739766014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1739766014', '0', '', '0'),
('994', '994', 'Ricarda Torrico Soliz', '811909012', '811909012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '811909012', '0', '', '0'),
('995', '995', 'JHOVANA CONDORI SARCO', '4253957019', '4253957019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4253957019', '0', '', '0'),
('996', '996', 'Abrahan Cruz Flores', '6273285', '6273285', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6273285', '0', '', '0'),
('997', '997', 'Fernando Luis Choque Llave', '66388', '66388', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '66388', '0', '', '0'),
('998', '998', 'carlos arteaga serna', '1682986019', '1682986019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1682986019', '0', '', '0'),
('999', '999', 'Luca Tonconi Mamani', '2344300', '2344300', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2344300', '0', '', '0'),
('1000', '1000', 'SIEEM S.R.L.', '168512029', '168512029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '168512029', '0', '', '0'),
('1001', '1001', 'Pedro Alejandro Anachuri Aguilera', '7204961', '7204961', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7204961', '0', '', '0'),
('1002', '1002', 'AGENCIA DESPACHANTE DE ADUANA TRIASUR SRL', '135077028', '135077028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '135077028', '0', '', '0'),
('1003', '1003', 'Edson Yamil Abiles Llanos', '7168901', '7168901', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7168901', '0', '', '0'),
('1004', '1004', 'DANITZA FANOLA CHUNGARA', '4094636014', '4094636014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4094636014', '0', '', '0'),
('1005', '1005', 'Romanet Melgar', '5862774', '5862774', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5862774', '0', '', '0'),
('1006', '1006', 'RAZA FUERTE SRL', '287322029', '287322029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '287322029', '0', '', '0'),
('1007', '1007', '	 RAZA FUERTE SRL', '	 287322029', '	\n287322029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '	\n287322029', '0', '', '0'),
('1008', '1008', 'rodrigo villarroel', '5642359013', '5642359013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5642359013', '0', '', '0'),
('1009', '1009', 'SURCO', '4330696 019', '4330696 019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4330696 019', '0', '', '0'),
('1010', '1010', '	ORLANDO TORRICO R.', '	3733526019', '	3733526019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '	3733526019', '0', '', '0'),
('1011', '1011', 'Delia Estrada Barrientos', '5641887', '5641887', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5641887', '0', '', '0'),
('1012', '1012', 'Jess Enrique Ortega Velasquez', '6278716', '6278716', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6278716', '0', '', '0'),
('1013', '1013', 'Susana vedia villaba', '5381333', '5381333', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5381333', '0', '', '0'),
('1014', '1014', 'Orlando Villca cayo', '4412637014', '4412637014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4412637014', '0', '', '0'),
('1015', '1015', 'Richardt Aguilar muoz', '7732569012', '7732569012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7732569012', '0', '', '0'),
('1016', '1016', 'salomon condori', '5273117011', '5273117011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5273117011', '0', '', '0'),
('1017', '1017', 'Patricia Flores', '206161', '206161', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '206161', '0', '', '0'),
('1018', '1018', 'Mara Magdalena Gallardo Vaca', '7764769017', '7764769017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7764769017', '0', '', '0'),
('1019', '1019', 'Bolland y Ca. S.A.', '1028355021', '1028355021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1028355021', '0', '', '0'),
('1020', '1020', 'llanos_lucio@yahoo.es', '4943126', '4943126', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4943126', '0', '', '0'),
('1021', '1021', 'Eusebio Lopez Martinez', '31191819010', '31191819010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '31191819010', '0', '', '0'),
('1022', '1022', 'Josefa guerrero requelme', '6392474010', '6392474010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6392474010', '0', '', '0'),
('1023', '1023', 'DATANALISIS LTDA', '305794023', '305794023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '305794023', '0', '', '0'),
('1024', '1024', 'Valeria Alarcn Morales', '10388509', '10388509', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '10388509', '0', '', '0'),
('1025', '1025', 'Cristian Ramos Pinto', '10421510', '10421510', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '10421510', '0', '', '0'),
('1026', '1026', 'zabala', '4759969', '4759969', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4759969', '0', '', '0'),
('1027', '1027', '	Llanos', '	4943126', '	4943126', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '	4943126', '0', '', '0'),
('1028', '1028', 'TAHUAMANU SA', '1015923029', '1015923029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1015923029', '0', '', '0'),
('1029', '1029', 'GABY MARISOL RAMOS', '9211367', '9211367', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '9211367', '0', '', '0'),
('1030', '1030', 'Cooperativa de Ahorro y Credito Societaria Paulo VI Ltda.', '1009557026', '1009557026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1009557026', '0', '', '0'),
('1031', '1031', 'INDUSTRIAS DE ACEITE S.A.', '1023233029', '1023233029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1023233029', '0', '', '0'),
('1032', '1032', 'LOURDES TICONA CORONEL', '5479645', '5479645', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5479645', '0', '', '0'),
('1033', '1033', 'Mara Esther Deuer', '6100833012', '6100833012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6100833012', '0', '', '0'),
('1034', '1034', 'Yasuda', '3242468', '3242468', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3242468', '0', '', '0'),
('1035', '1035', 'Luna', '6874519', '6874519', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6874519', '0', '', '0'),
('1036', '1036', 'MORALES', '6899069', '6899069', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6899069', '0', '', '0'),
('1037', '1037', 'Fabin Davis Zurita', '5806327', '5806327', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5806327', '0', '', '0'),
('1038', '1038', 'IGNACIO BEJARANO CUELLAR', '1517452019', '1517452019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1517452019', '0', '', '0'),
('1039', '1039', 'Anghy Ericka Urquizu Mamani', '10401942', '10401942', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '10401942', '0', '', '0'),
('1040', '1040', 'Benedicto paredes leaos', '2845844019', '2845844019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2845844019', '0', '', '0'),
('1041', '1041', 'DAVILA', '4465499014', '4465499014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4465499014', '0', '', '0'),
('1042', '1042', 'KAMER RODRIGUEZ VACA', '4190948016', '4190948016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4190948016', '0', '', '0'),
('1043', '1043', 'NUTRIMED-Nutricin y Medicina', '3197822016', '3197822016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3197822016', '0', '', '0'),
('1044', '1044', 'vista urbana srl', '199288024', '199288024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '199288024', '0', '', '0'),
('1045', '1045', 'SIDECON S.R.L.', '1011611027', '1011611027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1011611027', '0', '', '0'),
('1046', '1046', 'Maria nela campos vaca', '4192286', '4192286', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4192286', '0', '', '0'),
('1047', '1047', 'CARMEN ROSA GUTIERREZ MILLARES', '9899982', '9899982', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '9899982', '0', '', '0'),
('1048', '1048', 'Chorolque', '1327934', '1327934', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1327934', '0', '', '0'),
('1049', '1049', 'alaiza', '6828146', '6828146', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6828146', '0', '', '0'),
('1050', '1050', 'Empresa Industrial Eucaliptus cossmil', '296810026', '296810026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '296810026', '0', '', '0'),
('1051', '1051', 'TERMESA S.R.L.', '299894024', '299894024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '299894024', '0', '', '0'),
('1052', '1052', 'JOSUE ACERO HUANCA', '4821941015', '4821941015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4821941015', '0', '', '0'),
('1053', '1053', 'Renny Pozo', '3710334016', '3710334016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3710334016', '0', '', '0'),
('1054', '1054', 'yovana paco', '10854658', '10854658', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '10854658', '0', '', '0'),
('1055', '1055', 'limberg saavedra ribera', '3868343', '3868343', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3868343', '0', '', '0'),
('1056', '1056', 'Ximena Dorado Durn', '7754650', '7754650', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7754650', '0', '', '0'),
('1057', '1057', 'Rafael Torrez', '3362407', '3362407', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3362407', '0', '', '0'),
('1058', '1058', 'EMPSAAT', '1023807025', '1023807025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1023807025', '0', '', '0'),
('1059', '1059', 'mario villa', '1115243018', '1115243018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1115243018', '0', '', '0'),
('1060', '1060', 'Ramrez', '8328227', '8328227', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8328227', '0', '', '0'),
('1061', '1061', 'HUAGO VENANCIO APAZA', '4989482015', '4989482015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4989482015', '0', '', '0'),
('1062', '1062', 'leandro', '7032289015', '7032289015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7032289015', '0', '', '0'),
('1063', '1063', 'DAVID ARCE', '6055403018', '6055403018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6055403018', '0', '', '0'),
('1064', '1064', 'Heddy Claudia Montero Duran', '4669071012', '4669071012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4669071012', '0', '', '0'),
('1065', '1065', 'Cooperativa Aguarague Ltda.', '1011655022', '1011655022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1011655022', '0', '', '0'),
('1066', '1066', 'CASITA MIA SRL', '321056026', '321056026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '321056026', '0', '', '0'),
('1067', '1067', 'Jaime elias saba salomon', '280620028', '280620028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '280620028', '0', '', '0'),
('1068', '1068', 'napoleon calcina mendoza', '3823446015', '3823446015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3823446015', '0', '', '0'),
('1069', '1069', 'Velez', '4843535018', '4843535018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4843535018', '0', '', '0'),
('1070', '1070', 'Bolivia Delgado Zrate', '6700477', '6700477', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6700477', '0', '', '0'),
('1071', '1071', 'FERNANDEZ', '225900022', '225900022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '225900022', '0', '', '0'),
('1072', '1072', 'Alianza Seguros S.A.', '1020351029', '1020351029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1020351029', '0', '', '0'),
('1073', '1073', 'Asociacion La Fortuna', '5861311', '5861311', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5861311', '0', '', '0'),
('1074', '1074', 'MULTICENTER S.A.', '184288023', '184288023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '184288023', '0', '', '0'),
('1075', '1075', 'TRONIK SRL', '283274028', '283274028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '283274028', '0', '', '0'),
('1076', '1076', 'Beatriz Gutierrez', '1881184', '1881184', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1881184', '0', '', '0'),
('1077', '1077', 'Vargas', '3769839012', '3769839012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3769839012', '0', '', '0'),
('1078', '1078', 'Pascual Jimenez', '681169', '681169', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '681169', '0', '', '0'),
('1079', '1079', 'Flores', '3365402017', '3365402017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3365402017', '0', '', '0'),
('1080', '1080', 'Molina', '2446929016', '2446929016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2446929016', '0', '', '0'),
('1081', '1081', 'Marcelo Camacho', '6241374010', '6241374010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6241374010', '0', '', '0'),
('1082', '1082', 'willams Balderrama O.', '2840275019', '2840275019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2840275019', '0', '', '0'),
('1083', '1083', 'Chuyma', '4889973', '4889973', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4889973', '0', '', '0'),
('1084', '1084', 'Weminson Ferreira Rodriguez', '420507018', '420507018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '420507018', '0', '', '0'),
('1085', '1085', 'Quisbert', '4455586', '4455586', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4455586', '0', '', '0'),
('1086', '1086', 'PAOLA MONJES', '4411086010', '4411086010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4411086010', '0', '', '0'),
('1087', '1087', 'juan flores', '1321857018', '1321857018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1321857018', '0', '', '0'),
('1088', '1088', 'VEGAL FARMACEUTICA S.L. SUCURSAL BOLIVIA', '352294020', '352294020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '352294020', '0', '', '0'),
('1089', '1089', 'Gutierrez', '61539085', '61539085', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '61539085', '0', '', '0'),
('1090', '1090', 'TIERRA', '1001027026', '1001027026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1001027026', '0', '', '0'),
('1091', '1091', 'Anibal Alberto Saavedra Revollo', '4583022017', '4583022017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4583022017', '0', '', '0'),
('1092', '1092', 'GLORIA BURGOA MENCIAS', '5349688011', '5349688011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5349688011', '0', '', '0'),
('1093', '1093', 'Siles', '2865853', '2865853', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2865853', '0', '', '0'),
('1094', '1094', 'agrocentral ltda', '1029047026', '1029047026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1029047026', '0', '', '0'),
('1095', '1095', 'Alvaro Santi', '4536980', '4536980', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4536980', '0', '', '0'),
('1096', '1096', 'Flores', '6505446', '6505446', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6505446', '0', '', '0'),
('1097', '1097', 'ELIZABETH RODRIGUEZ', '6557166010', '6557166010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6557166010', '0', '', '0'),
('1098', '1098', 'Richard Zonneveld', '3029900', '3029900', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3029900', '0', '', '0'),
('1099', '1099', 'PHI TERRA S.R.L.', '275130026', '275130026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '275130026', '0', '', '0'),
('1100', '1100', 'TATIANA FERRUFINO', '11345203', '11345203', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '11345203', '0', '', '0'),
('1101', '1101', 'CRAFT SRL', '148718022', '148718022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '148718022', '0', '', '0'),
('1102', '1102', 'Emilio Ricaldes Merida', '5288329', '5288329', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5288329', '0', '', '0'),
('1103', '1103', 'Empresa constructora y consultora ICONOC COHUSI SRL', '1011043026', '1011043026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1011043026', '0', '', '0'),
('1104', '1104', 'Comit de Damas Paceas', '1001657023', '1001657023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1001657023', '0', '', '0'),
('1105', '1105', 'Petri von landwust srl', '139321027', '139321027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '139321027', '0', '', '0'),
('1106', '1106', 'PEREZ', '3472411013', '3472411013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3472411013', '0', '', '0'),
('1107', '1107', 'FRIGOR SA', '1028739027', '1028739027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1028739027', '0', '', '0'),
('1108', '1108', 'Vito Dorado Sevilla', '2962242014', '2962242014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2962242014', '0', '', '0'),
('1109', '1109', 'blanca cordova', '2384100019', '2384100019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2384100019', '0', '', '0'),
('1110', '1110', 'felix calle', '4917773', '4917773', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4917773', '0', '', '0'),
('1111', '1111', 'Embriovid S.R.L.', '142469027', '142469027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '142469027', '0', '', '0'),
('1112', '1112', 'CONSTRUCTORA &amp; CONSULTORA FADICONS S.R.L.', '242406024', '242406024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '242406024', '0', '', '0'),
('1113', '1113', 'Centro de Distribucin y Comercializacin HUEVOCRUZ SRL.', '351918027', '351918027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '351918027', '0', '', '0'),
('1114', '1114', 'RANULFO LEAOS', '3922560013', '3922560013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3922560013', '0', '', '0'),
('1115', '1115', 'Juvenal Serrano', '1883329012', '1883329012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1883329012', '0', '', '0'),
('1116', '1116', 'DICSA BOLIVIA SA.', '1004679025', '1004679025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1004679025', '0', '', '0'),
('1117', '1117', 'Jorge Arias Morales', '5240736019', '5240736019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5240736019', '0', '', '0'),
('1118', '1118', 'ALEX VACA', '7783548', '7783548', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7783548', '0', '', '0'),
('1119', '1119', 'INGEBOL SRL', '301160021', '301160021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '301160021', '0', '', '0'),
('1120', '1120', 'EMPRESA DE SERVICIOS CONTACTA SRL', '311346022', '311346022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '311346022', '0', '', '0'),
('1121', '1121', 'Imathia Construccin SL sucursal Bolivia', '308216023', '308216023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '308216023', '0', '', '0'),
('1122', '1122', 'COMPAIA DE PLASTICOS ART LTDA', '1028453026', '1028453026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1028453026', '0', '', '0'),
('1123', '1123', 'FERMINA CORDOVA', '8614011010', '8614011010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8614011010', '0', '', '0'),
('1124', '1124', 'NEXUS COMUNICACION TOTAL S.A.', '1007015020', '1007015020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1007015020', '0', '', '0'),
('1125', '1125', 'THAMEZ', '7958297018', '7958297018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7958297018', '0', '', '0'),
('1126', '1126', 'Yhovana Poma Paredes', '6143596', '6143596', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6143596', '0', '', '0'),
('1127', '1127', 'Aragn Servicios Integrales', '1026809023', '1026809023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1026809023', '0', '', '0'),
('1128', '1128', 'Gregorio Veliz Ramirez', '2181759016', '2181759016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2181759016', '0', '', '0'),
('1129', '1129', 'Perez', '3435288', '3435288', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3435288', '0', '', '0'),
('1130', '1130', 'Verastegui', '4791335011', '4791335011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4791335011', '0', '', '0'),
('1131', '1131', 'fernando lopez zenteno', '3628447011', '3628447011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3628447011', '0', '', '0'),
('1132', '1132', 'TEG S.R.L.', '1024305022', '1024305022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1024305022', '0', '', '0'),
('1133', '1133', 'LABORATORIO DR ZUNA SRL', '1012497024', '1012497024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1012497024', '0', '', '0'),
('1134', '1134', 'herrera ', '4849538', '4849538', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4849538', '0', '', '0'),
('1135', '1135', 'JUDITH BARRETA VARGAS', '4571222010', '4571222010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4571222010', '0', '', '0'),
('1136', '1136', 'ROSIO IGNACIO HIDALGO', '3512921015', '3512921015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3512921015', '0', '', '0'),
('1137', '1137', 'COMINESA', '1006239027', '1006239027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1006239027', '0', '', '0'),
('1138', '1138', 'BELFORD VARGAS RUTZ', '3820705013', '3820705013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3820705013', '0', '', '0'),
('1139', '1139', 'AGUIRRE', '2634800', '2634800', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2634800', '0', '', '0'),
('1140', '1140', 'Aranibar', '3377686013', '3377686013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3377686013', '0', '', '0'),
('1141', '1141', 'Cuba', '2710785011', '2710785011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2710785011', '0', '', '0'),
('1142', '1142', 'ROSA NELLY VILLARROEL', '5867142014', '5867142014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5867142014', '0', '', '0'),
('1143', '1143', 'Soluciones y Controles S.R.L.', '128505021', '128505021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '128505021', '0', '', '0'),
('1144', '1144', 'FRITZ RONCALES', '3866246', '3866246', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3866246', '0', '', '0'),
('1145', '1145', 'Jutta Weber', '206756025', '206756025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '206756025', '0', '', '0'),
('1146', '1146', 'MAIDANA', '468732015', '468732015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '468732015', '0', '', '0'),
('1147', '1147', 'veronica valle', '4587303', '4587303', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4587303', '0', '', '0'),
('1148', '1148', 'SAMEQ SRL', '121715023', '121715023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '121715023', '0', '', '0'),
('1149', '1149', 'CIRO VIDAURRE VARGAS', '5154179', '5154179', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5154179', '0', '', '0'),
('1150', '1150', 'CONTRATAS IGLESIAS S.A.', '305122023', '305122023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '305122023', '0', '', '0'),
('1151', '1151', 'Maldonado', '3394240018', '3394240018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3394240018', '0', '', '0'),
('1152', '1152', 'ZULMA COPPA', '4143516', '4143516', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4143516', '0', '', '0'),
('1153', '1153', 'aldana', '2722184', '2722184', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2722184', '0', '', '0'),
('1154', '1154', 'A.P.L', '1021905026', '1021905026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1021905026', '0', '', '0'),
('1155', '1155', 'Alvarez', '2310142016', '2310142016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2310142016', '0', '', '0'),
('1156', '1156', 'TOPO - REQV S.R.L.', '292584020', '292584020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '292584020', '0', '', '0'),
('1157', '1157', 'AGXPLORE INTERNACIONAL S.R.L.', '130893024', '130893024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '130893024', '0', '', '0'),
('1158', '1158', 'HOMEX', '4313365013', '4313365013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4313365013', '0', '', '0'),
('1159', '1159', 'Vera', '4377392016', '4377392016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4377392016', '0', '', '0'),
('1160', '1160', 'Fbrica de Chocolates y Dulces Cndor SRL', '1005185029', '1005185029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1005185029', '0', '', '0'),
('1161', '1161', 'E&amp;E S.R.L.', '120781026', '120781026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '120781026', '0', '', '0'),
('1162', '1162', 'Econstruvsur Srl', '239910029', '239910029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '239910029', '0', '', '0'),
('1163', '1163', 'QUEBRACHO SERV. DE PROTECCION AMBIENTAL SRL', '1012577027', '1012577027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1012577027', '0', '', '0'),
('1164', '1164', 'IBES SRL', '317120021', '317120021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '317120021', '0', '', '0'),
('1165', '1165', 'COOPERATIVA DE AHORRO Y CREDITO FATIMA LTDA', '1028775025', '1028775025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1028775025', '0', '', '0'),
('1166', '1166', 'INPATGROUP C&amp;V S.R.L', '189348025', '189348025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '189348025', '0', '', '0'),
('1167', '1167', 'Cano', '6813931', '6813931', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6813931', '0', '', '0'),
('1168', '1168', 'Jorge Zubieta Aguila', '4400911014', '4400911014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4400911014', '0', '', '0'),
('1169', '1169', 'Octavio Elvis Uribe Anibarro', '4087198', '4087198', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4087198', '0', '', '0'),
('1170', '1170', 'TIENDA AMIGA ER S.A', '176592023', '176592023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '176592023', '0', '', '0'),
('1171', '1171', 'FUNDACION INSTITUCION EDUCATIVA PENIEL', '122519027', '122519027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '122519027', '0', '', '0'),
('1172', '1172', 'ICAT ELECTROGAS S.R.L.', '297788027', '297788027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '297788027', '0', '', '0'),
('1173', '1173', 'Hotel Cortez Ltda.', '1015201020', '1015201020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1015201020', '0', '', '0'),
('1174', '1174', 'INTERNACIONAL TARIJA SRL', '142109022', '142109022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '142109022', '0', '', '0'),
('1175', '1175', 'Fundacin Nuevo Norte', '139193026', '139193026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '139193026', '0', '', '0'),
('1176', '1176', 'FREDDY GUTIERREZ MERCADO', '1598326', '1598326', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1598326', '0', '', '0'),
('1177', '1177', 'SOLIZ', '6464831012', '6464831012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6464831012', '0', '', '0'),
('1178', '1178', 'CHICKENS KINGDOM S.R.L.', '1009311029', '1009311029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1009311029', '0', '', '0'),
('1179', '1179', 'VOLCAN S.A.', '1020467020', '1020467020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1020467020', '0', '', '0'),
('1180', '1180', 'SOLIZ', '5970445', '5970445', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5970445', '0', '', '0'),
('1181', '1181', 'henry perales cortez', '2994127011', '2994127011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2994127011', '0', '', '0'),
('1182', '1182', 'CBM S.R.L.', '1001811023', '1001811023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1001811023', '0', '', '0'),
('1183', '1183', 'HAZEL', '4323106018', '4323106018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4323106018', '0', '', '0'),
('1184', '1184', 'INSACRUZ LTDA.', '1028265029', '1028265029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1028265029', '0', '', '0'),
('1185', '1185', 'Eliana Mara Candia', '4041734', '4041734', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4041734', '0', '', '0'),
('1186', '1186', 'HELADERIA GRACIA S.R.L.', '152838029', '152838029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '152838029', '0', '', '0'),
('1187', '1187', 'Metalrgica R.V.L.', '773153010', '773153010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '773153010', '0', '', '0'),
('1188', '1188', 'SyL Ingenieros Ltda.', '1015473020', '1015473020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1015473020', '0', '', '0'),
('1189', '1189', 'maria del carmen masanes', '3902935012', '3902935012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3902935012', '0', '', '0'),
('1190', '1190', 'INGEDAV S.R.L.', '351753025', '351753025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '351753025', '0', '', '0'),
('1191', '1191', 'Constructora malaga hnos sa suc bolivia', '315798025', '315798025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '315798025', '0', '', '0'),
('1192', '1192', 'Juan ivan mamani tapia', '1025281022', '1025281022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1025281022', '0', '', '0'),
('1193', '1193', 'ARPEC S.R.L.', '282626026', '282626026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '282626026', '0', '', '0'),
('1194', '1194', 'Colegio Medico de Santa Cruz', '122347029', '122347029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '122347029', '0', '', '0'),
('1195', '1195', 'PRIME CINEMAS GAMES &amp; RESTAURANT GOMM SRL', '316898027', '316898027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '316898027', '0', '', '0'),
('1196', '1196', 'Seta consultores S. R. L.', '1022071023', '1022071023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1022071023', '0', '', '0'),
('1197', '1197', 'BYG E GYB CONSULTORES S.R.L.', '232524020', '232524020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '232524020', '0', '', '0'),
('1198', '1198', 'walter Montenegro', '5402054', '5402054', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5402054', '0', '', '0'),
('1199', '1199', 'SEFO-SAM', '1009407020', '1009407020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1009407020', '0', '', '0'),
('1200', '1200', 'Patricia Aviles', '7141070012', '7141070012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7141070012', '0', '', '0'),
('1201', '1201', 'IRRIGACION SCBOL LTDA', '145806024', '145806024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '145806024', '0', '', '0'),
('1202', '1202', 'ZEBALLOS', '4836592', '4836592', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4836592', '0', '', '0'),
('1203', '1203', 'Julia Montejo Neira', '4197065013', '4197065013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4197065013', '0', '', '0'),
('1204', '1204', 'Leddy Arza ', '7615197', '7615197', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7615197', '0', '', '0'),
('1205', '1205', 'Paulina Chacon Ticona', '3322939017', '3322939017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3322939017', '0', '', '0'),
('1206', '1206', 'Maribel Gisbert', '4922125019', '4922125019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4922125019', '0', '', '0'),
('1207', '1207', 'DANIEL SCHLUSSELBERG', '3657144012', '3657144012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3657144012', '0', '', '0'),
('1208', '1208', 'HERCILIA CORDOVA SILVA', '666789017', '666789017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '666789017', '0', '', '0'),
('1209', '1209', 'Daynor Esteban Tancara Martinez', '3314711', '3314711', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3314711', '0', '', '0'),
('1210', '1210', 'Carlos Javier Oros Gonzales', '2455521011', '2455521011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2455521011', '0', '', '0'),
('1211', '1211', 'jose luis molina selaya', '4035567', '4035567', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4035567', '0', '', '0'),
('1212', '1212', 'Cimar Rodriguez Armella', '4123514', '4123514', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4123514', '0', '', '0'),
('1213', '1213', 'Alejandra Bascope Salvatierra', '5421089010', '5421089010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5421089010', '0', '', '0'),
('1214', '1214', 'LUCIO VILLCA CONDORI', '3566235014', '3566235014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3566235014', '0', '', '0'),
('1215', '1215', 'aguilar', '2458656', '2458656', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2458656', '0', '', '0'),
('1216', '1216', 'PAULINA SAIGUA ROJAS', '3206786018', '3206786018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3206786018', '0', '', '0'),
('1217', '1217', 'Ruddy Quintanilla Flores', '5683578', '5683578', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5683578', '0', '', '0'),
('1218', '1218', 'INDUSTRIAS VENADO S.A.', '1020539025', '1020539025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1020539025', '0', '', '0'),
('1219', '1219', 'RAMIRO RINALDO', '2689261', '2689261', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2689261', '0', '', '0'),
('1220', '1220', 'VERONICA SUXO QUENTA', '4947864015', '4947864015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4947864015', '0', '', '0'),
('1221', '1221', 'ALVARO GUTIERREZ ZARATE', '6947922', '6947922', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6947922', '0', '', '0'),
('1222', '1222', 'Vicente Vargas Flored', '4096931015', '4096931015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4096931015', '0', '', '0'),
('1223', '1223', 'Limberg Sandoval Salvatierra', '3837663016', '3837663016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3837663016', '0', '', '0'),
('1224', '1224', 'JUAN CARLOS SALAZAR', '5827448015', '5827448015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5827448015', '0', '', '0'),
('1225', '1225', 'Ancieta', '9412877', '9412877', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '9412877', '0', '', '0'),
('1226', '1226', 'ALVARO NUEZ SRL', '222166024', '222166024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '222166024', '0', '', '0'),
('1227', '1227', 'CRC SA.', '300762026', '300762026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '300762026', '0', '', '0'),
('1228', '1228', 'Alvaro Arandia', '3655387018', '3655387018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3655387018', '0', '', '0'),
('1229', '1229', 'Hoteleria y Turismo Eubea S.R.L', '204332029', '204332029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '204332029', '0', '', '0'),
('1230', '1230', 'Montecristo Bolivia S.R.L.', '153566021', '153566021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '153566021', '0', '', '0'),
('1231', '1231', 'Boris escalante', '3089404', '3089404', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3089404', '0', '', '0'),
('1232', '1232', 'Total Radio Systems Ltda. Bolivia TRS Ltda.', '120601023', '120601023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '120601023', '0', '', '0'),
('1233', '1233', 'jhenny lizeth ortiz canaviri', '9235615016', '9235615016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '9235615016', '0', '', '0'),
('1234', '1234', 'PRIMSA SRL', '142863022', '142863022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '142863022', '0', '', '0'),
('1235', '1235', 'EMPRESA CONSTRUCTORA CRT LTDA', '267036024', '267036024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '267036024', '0', '', '0'),
('1236', '1236', 'CENDA', '1009341027', '1009341027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1009341027', '0', '', '0'),
('1237', '1237', 'LatigidConst S.R.L.', '193734021', '193734021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '193734021', '0', '', '0'),
('1238', '1238', 'Alejandra Claure', '7282684018', '7282684018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7282684018', '0', '', '0'),
('1239', '1239', 'lienara Ribera', '3901629', '3901629', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3901629', '0', '', '0'),
('1240', '1240', 'Lidercont S.R.L.', '258722022', '258722022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '258722022', '0', '', '0'),
('1241', '1241', 'Espinoza', '5851301010', '5851301010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5851301010', '0', '', '0'),
('1242', '1242', 'Monica Castillo', '3797822', '3797822', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3797822', '0', '', '0'),
('1243', '1243', 'shai gonzalo lugo rodriguez', '8624371010', '8624371010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8624371010', '0', '', '0'),
('1244', '1244', 'EDGAR FLORES ALANES', '3517056013', '3517056013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3517056013', '0', '', '0'),
('1245', '1245', 'Abel Garcia Blanco', '3069594016', '3069594016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3069594016', '0', '', '0'),
('1246', '1246', 'Spiecapag S.A. Sucursal Bolivia', '241626027', '241626027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '241626027', '0', '', '0'),
('1247', '1247', 'ASERRADERO OQUIRIQUIA SRL', '1031031022', '1031031022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1031031022', '0', '', '0'),
('1248', '1248', 'TERRAZAS', '3801733014', '3801733014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3801733014', '0', '', '0'),
('1249', '1249', 'Inversiones Rokys Bolivia SRL', '1025631024', '1025631024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1025631024', '0', '', '0'),
('1250', '1250', 'AGRARIO S.R.L', '328084027', '328084027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '328084027', '0', '', '0'),
('1251', '1251', 'JUAN CARLOS TICONA', '5481285017', '5481285017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5481285017', '0', '', '0'),
('1252', '1252', 'Espada', '2756748', '2756748', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2756748', '0', '', '0'),
('1253', '1253', 'AQUATEC S.R.L.', '137971028', '137971028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '137971028', '0', '', '0'),
('1254', '1254', 'GEA SRL', '299876029', '299876029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '299876029', '0', '', '0');
INSERT INTO `0_cust_branch` VALUES
('1255', '1255', 'SOHER S.R.L.', '192908025', '192908025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '192908025', '0', '', '0'),
('1256', '1256', 'Quispia', '3028228015', '3028228015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3028228015', '0', '', '0'),
('1257', '1257', 'Remy Orgaz', '961344017', '961344017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '961344017', '0', '', '0'),
('1258', '1258', 'NIELZEN SUAREZ', '6021000', '6021000', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6021000', '0', '', '0'),
('1259', '1259', 'EON CONSULTORA INTERDISCIPLINARIA', '6877613012', '6877613012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6877613012', '0', '', '0'),
('1260', '1260', 'OPRO SRL', '198940020', '198940020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '198940020', '0', '', '0'),
('1261', '1261', 'REYES', '4270203017', '4270203017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4270203017', '0', '', '0'),
('1262', '1262', 'ROBERT WILY MAMANI VASQUEZ', '4940919018', '4940919018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4940919018', '0', '', '0'),
('1263', '1263', 'La cuisine de los chef s.r.l.', '187236022', '187236022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '187236022', '0', '', '0'),
('1264', '1264', 'Ericka Pardo Molina', '1908221012', '1908221012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1908221012', '0', '', '0'),
('1265', '1265', 'U.Coop. de Educacin Juan Pablo II', '1000119029', '1000119029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1000119029', '0', '', '0'),
('1266', '1266', 'Nemtala', '3839368', '3839368', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3839368', '0', '', '0'),
('1267', '1267', 'Edgar Noe Vasquez Gutierrez', '8219307', '8219307', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8219307', '0', '', '0'),
('1268', '1268', 'GALVAN Y ASOCIADOS S.R.L.', '153250020', '153250020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '153250020', '0', '', '0'),
('1269', '1269', 'GRUPO REGIONAL S.R.L.', '159488029', '159488029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '159488029', '0', '', '0'),
('1270', '1270', 'Montao', '6410825015', '6410825015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6410825015', '0', '', '0'),
('1271', '1271', 'Ligni Soria Nakashima', '1768795', '1768795', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1768795', '0', '', '0'),
('1272', '1272', 'Iber Carballo Moreira', '3948654017', '3948654017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3948654017', '0', '', '0'),
('1273', '1273', 'Martnez', '1057707', '1057707', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1057707', '0', '', '0'),
('1274', '1274', 'Ricardo Flores Mendoza', '7259203', '7259203', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7259203', '0', '', '0'),
('1275', '1275', 'ALDO BARRERA', '4019712014', '4019712014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4019712014', '0', '', '0'),
('1276', '1276', 'Hugo Maija Chapi', '4172983019', '4172983019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4172983019', '0', '', '0'),
('1277', '1277', 'DUARTE Y PEA AUDITORES ASOCIADOS SRL', '1001045026', '1001045026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1001045026', '0', '', '0'),
('1278', '1278', 'ORTIZ', '1725989013', '1725989013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1725989013', '0', '', '0'),
('1279', '1279', 'AUDISEM SRL', '1006101028', '1006101028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1006101028', '0', '', '0'),
('1280', '1280', 'FERRETERIA SANGUEZA S.R.L.', '294540021', '294540021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '294540021', '0', '', '0'),
('1281', '1281', 'Caleb Mogro Maldonado', '4805589', '4805589', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4805589', '0', '', '0'),
('1282', '1282', 'Herman Martinez Solar', '2991283016', '2991283016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2991283016', '0', '', '0'),
('1283', '1283', 'JASON ESTEVES', '5681823014', '5681823014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5681823014', '0', '', '0'),
('1284', '1284', 'Hassenteufel', '1025438014', '1025438014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1025438014', '0', '', '0'),
('1285', '1285', 'Fanny Arredondo', '2836436015', '2836436015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2836436015', '0', '', '0'),
('1286', '1286', 'ODALY NOE TAMACOINA', '5387391014', '5387391014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5387391014', '0', '', '0'),
('1287', '1287', 'Mer Telecom Bolivia Srl.', '171352023', '171352023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '171352023', '0', '', '0'),
('1288', '1288', 'Emili Lily Rivera Villarroel', '6222153013', '6222153013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6222153013', '0', '', '0'),
('1289', '1289', 'DISTRIBUIDORA ANDESFILMS S.A.', '316490028', '316490028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '316490028', '0', '', '0'),
('1290', '1290', 'Diaz', '8002492', '8002492', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8002492', '0', '', '0'),
('1291', '1291', 'SEMCA S.R.L.', '178782020', '178782020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '178782020', '0', '', '0'),
('1292', '1292', 'AGRICOLA GANADERA BJ RANCH S.A.', '1027315022', '1027315022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1027315022', '0', '', '0'),
('1293', '1293', 'SEAC', '832407010', '832407010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '832407010', '0', '', '0'),
('1294', '1294', 'KPLIAN LTDA', '196560027', '196560027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '196560027', '0', '', '0'),
('1295', '1295', 'ICEL', '1029995022', '1029995022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1029995022', '0', '', '0'),
('1296', '1296', 'gastn eduardo medrano lpez', '1733269013', '1733269013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1733269013', '0', '', '0'),
('1297', '1297', 'Hugo Aramayo Vidal', '1101340017', '1101340017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1101340017', '0', '', '0'),
('1298', '1298', 'CAROLA MORALES AUZA', '3568892011', '3568892011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3568892011', '0', '', '0'),
('1299', '1299', 'COOP. DE A.Y C. JERUSALEN LTDA.', '132533023', '132533023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '132533023', '0', '', '0'),
('1300', '1300', 'Mario Barriga Garnica', '3645574', '3645574', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3645574', '0', '', '0'),
('1301', '1301', 'ISAIAS CRUZ', '8833248', '8833248', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8833248', '0', '', '0'),
('1302', '1302', 'Domingo Freddy Eguez Alvarez', '1523674018', '1523674018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1523674018', '0', '', '0'),
('1303', '1303', 'Aldo Montero', '4687096', '4687096', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4687096', '0', '', '0'),
('1304', '1304', 'kanchay', '1022637026', '1022637026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1022637026', '0', '', '0'),
('1305', '1305', 'Roy Antonio Sejas Melendez', '5592295019', '5592295019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5592295019', '0', '', '0'),
('1306', '1306', 'UNIDAD EDUCATIVA REFORMADO CRISTIANO', '292548029', '292548029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '292548029', '0', '', '0'),
('1307', '1307', 'LOURDES LEONOR MANCILLA VIDAL', '921169013', '921169013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '921169013', '0', '', '0'),
('1308', '1308', 'SIFA ASOCIADOS SRL', '171886022', '171886022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '171886022', '0', '', '0'),
('1309', '1309', 'SOS BOLIVIA', '1020347026', '1020347026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1020347026', '0', '', '0'),
('1310', '1310', 'Hector Evia Meave', '2680707013', '2680707013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2680707013', '0', '', '0'),
('1311', '1311', 'TORREZ', '4849098018', '4849098018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4849098018', '0', '', '0'),
('1312', '1312', 'GUALBERTO QUINTANILLA', '2926976010', '2926976010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2926976010', '0', '', '0'),
('1313', '1313', 'Marcelo Onishi', '4181297013', '4181297013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4181297013', '0', '', '0'),
('1314', '1314', 'SAUL GALARZA', '701423011', '701423011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '701423011', '0', '', '0'),
('1315', '1315', 'JHALEA SRL', '120727029', '120727029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '120727029', '0', '', '0'),
('1316', '1316', 'GLORIA DANIELA MEDINA JIMENEZ', '8090906015', '8090906015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8090906015', '0', '', '0'),
('1317', '1317', 'Jenny Paz Zelada', '1549236018', '1549236018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1549236018', '0', '', '0'),
('1318', '1318', 'COTAS RL', '1028367023', '1028367023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1028367023', '0', '', '0'),
('1319', '1319', 'vallejos', '7883286013', '7883286013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7883286013', '0', '', '0'),
('1320', '1320', 'CONSULTORA CONTABLE DE Y J S.R.L.', '328486020', '328486020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '328486020', '0', '', '0'),
('1321', '1321', 'HENRY VARGAS', '2390703013', '2390703013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2390703013', '0', '', '0'),
('1322', '1322', 'MAMANI', '6989116', '6989116', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6989116', '0', '', '0'),
('1323', '1323', 'VILLARREAL', '923256013', '923256013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '923256013', '0', '', '0'),
('1324', '1324', 'RONALD MANRIQUE', '8398794', '8398794', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8398794', '0', '', '0'),
('1325', '1325', 'ASOCIACION COLECTIVO REBELDIA', '1014545026', '1014545026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1014545026', '0', '', '0'),
('1326', '1326', 'NICANDRO LLAVE VALERIANO', '3719702015', '3719702015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3719702015', '0', '', '0'),
('1327', '1327', 'Magaly Martha Aguilar de Sandoval', '2625682017', '2625682017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2625682017', '0', '', '0'),
('1328', '1328', 'EMPRESA DE ALIMENTOS HAMACAS LTDA.', '187466029', '187466029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '187466029', '0', '', '0'),
('1329', '1329', 'ARIEL FRANKLIN FLORES LAZCANO', '5487037016', '5487037016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5487037016', '0', '', '0'),
('1330', '1330', 'SILVANA RIVERA SOTO', '4428324010', '4428324010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4428324010', '0', '', '0'),
('1331', '1331', 'nely arancibia victoria', '6537002018', '6537002018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6537002018', '0', '', '0'),
('1332', '1332', 'ORLANDO LOZA CAREAGA', '3782459010', '3782459010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3782459010', '0', '', '0'),
('1333', '1333', 'FUNDACION FAUTAPO', '1024503027', '1024503027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1024503027', '0', '', '0'),
('1334', '1334', 'Amparo Garcia Rodriguez', '1090330', '1090330', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1090330', '0', '', '0'),
('1335', '1335', 'RITA LOPEZ', '3563355', '3563355', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3563355', '0', '', '0'),
('1336', '1336', 'Industrias Metal ever Srl', '272522026', '272522026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '272522026', '0', '', '0'),
('1337', '1337', 'Revollo', '4410329015', '4410329015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4410329015', '0', '', '0'),
('1338', '1338', 'Juan alberto fernandez', '54167617', '54167617', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '54167617', '0', '', '0'),
('1339', '1339', 'victor meliton choquehuanca yujra', '2608124', '2608124', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2608124', '0', '', '0'),
('1340', '1340', 'padilla', '466488', '466488', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '466488', '0', '', '0'),
('1341', '1341', 'ENDE CORANI S.A.', '1009393025', '1009393025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1009393025', '0', '', '0'),
('1342', '1342', 'Candelaria Tours', '1020818017', '1020818017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1020818017', '0', '', '0'),
('1343', '1343', 'SISCOTEC SRL', '1027397029', '1027397029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1027397029', '0', '', '0'),
('1344', '1344', 'Wilson Balanza', '1069340', '1069340', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1069340', '0', '', '0'),
('1345', '1345', 'EMPRESA CONSTRUCTORA VECONSER SRL', '1010773023', '1010773023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1010773023', '0', '', '0'),
('1346', '1346', 'Reynaldo Espinoza', '2984675019', '2984675019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2984675019', '0', '', '0'),
('1347', '1347', 'ROGER TORRICO', '3783194019', '3783194019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3783194019', '0', '', '0'),
('1348', '1348', 'Roxana J. Maita Guzmn', '1884197017', '1884197017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1884197017', '0', '', '0'),
('1349', '1349', 'ROMERO', '3474039', '3474039', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3474039', '0', '', '0'),
('1350', '1350', 'ivan pea', '4770102', '4770102', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4770102', '0', '', '0'),
('1351', '1351', 'fundacruz', '1028631020', '1028631020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1028631020', '0', '', '0'),
('1352', '1352', 'YVON DORIA MEDINA TERRAZAS', '8926105011', '8926105011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8926105011', '0', '', '0'),
('1353', '1353', 'Patricia Lipa Calisaya', '3132359', '3132359', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3132359', '0', '', '0'),
('1354', '1354', 'RUTY BEATRIS VACA JUSTINIANO', '2953524011', '2953524011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2953524011', '0', '', '0'),
('1355', '1355', 'Rafael Albis', '5631672', '5631672', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5631672', '0', '', '0'),
('1356', '1356', 'krieger SRL', '281806025', '281806025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '281806025', '0', '', '0'),
('1357', '1357', 'Mauricio Martin Llanos Corianga', '7174827', '7174827', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '7174827', '0', '', '0'),
('1358', '1358', 'PLASTIFORTE SRL', '1009109025', '1009109025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1009109025', '0', '', '0'),
('1359', '1359', 'ECOR LTDA. CANAL 9 TELEORIENTE', '1028449028', '1028449028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1028449028', '0', '', '0'),
('1360', '1360', 'U.P.B.', '1023063028', '1023063028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1023063028', '0', '', '0'),
('1361', '1361', 'HINOJOSA', '4503823012', '4503823012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4503823012', '0', '', '0'),
('1362', '1362', 'JULIO RUBEN VALDIVIA ZAMBRANA', '970631010', '970631010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '970631010', '0', '', '0'),
('1363', '1363', 'C.R.&amp; F. ROJAS ABOGADOS SRL', '212314020', '212314020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '212314020', '0', '', '0'),
('1364', '1364', 'Rene Saavedra Ribera', '463432019', '463432019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '463432019', '0', '', '0'),
('1365', '1365', 'Escalera', '5206374', '5206374', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5206374', '0', '', '0'),
('1366', '1366', 'FELIX MARCA MAMANI', '5189899012', '5189899012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5189899012', '0', '', '0'),
('1367', '1367', 'Paulina Vargas Rojas', '2839581', '2839581', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2839581', '0', '', '0'),
('1368', '1368', 'salud y nutricion s.r.l.', '307538024', '307538024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '307538024', '0', '', '0'),
('1369', '1369', 'Perez', '4760681', '4760681', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4760681', '0', '', '0'),
('1370', '1370', 'Olmos', '3227492', '3227492', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3227492', '0', '', '0'),
('1371', '1371', 'RAMIRO JIMENEZ SANDOVAL', '5231474019', '5231474019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5231474019', '0', '', '0'),
('1372', '1372', 'Caxco S.R.L.', '306746028', '306746028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '306746028', '0', '', '0'),
('1373', '1373', 'Consultora Audicab SRL', '291050028', '291050028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '291050028', '0', '', '0'),
('1374', '1374', 'Ronald Mamani Mamani', '6072636', '6072636', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6072636', '0', '', '0'),
('1375', '1375', 'Industrias Matriz Ibaez IMIBA S.R.L.', '313482024', '313482024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '313482024', '0', '', '0'),
('1376', '1376', 'Xeanury S.R.L', '261130022', '261130022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '261130022', '0', '', '0'),
('1377', '1377', 'LOPEZ', '3756978', '3756978', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3756978', '0', '', '0'),
('1378', '1378', 'Jenny Gonzales', '6435879018', '6435879018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6435879018', '0', '', '0'),
('1379', '1379', 'Lorgio Boris Cabrera Delgado', '4018834014', '4018834014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4018834014', '0', '', '0'),
('1380', '1380', 'Cet-Beni', '3337951015', '3337951015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3337951015', '0', '', '0'),
('1381', '1381', 'JOSUE OCTAVIO COLQUE RODRIGUEZ', '6623111', '6623111', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6623111', '0', '', '0'),
('1382', '1382', 'PURE BOLIVIA S.R.L.', '230532023', '230532023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '230532023', '0', '', '0'),
('1383', '1383', 'EDITORA  CANELAS DEL SUR SRL', '1000817029', '1000817029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1000817029', '0', '', '0'),
('1384', '1384', 'TEKHNE S.R.L.', '143515024', '143515024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '143515024', '0', '', '0'),
('1385', '1385', 'MOYA', '9199647019', '9199647019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '9199647019', '0', '', '0'),
('1386', '1386', 'MARCOS MANFRED BELLER MONTERO', '1022519022', '1022519022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1022519022', '0', '', '0'),
('1387', '1387', 'Claudia Sanchez', '5979063016', '5979063016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5979063016', '0', '', '0'),
('1388', '1388', 'Empresa Mienra Sinchi Metals Cv Export S. R. L.', '189722020', '189722020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '189722020', '0', '', '0'),
('1389', '1389', 'Luis Suarez', '1919381', '1919381', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1919381', '0', '', '0'),
('1390', '1390', 'ALCOBA ANTONIO', '2693902013', '2693902013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2693902013', '0', '', '0'),
('1391', '1391', 'REDAL DE FREDDY ACEBY', '3675743012', '3675743012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3675743012', '0', '', '0'),
('1392', '1392', 'maria ynes leaos', '4586513019', '4586513019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4586513019', '0', '', '0'),
('1393', '1393', 'Carlos Eduardo Paz Saucedo', '1593144019', '1593144019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1593144019', '0', '', '0'),
('1394', '1394', 'Shirley Romay Flores', '3674407', '3674407', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3674407', '0', '', '0'),
('1395', '1395', 'Sandra Nava', '3875688', '3875688', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3875688', '0', '', '0'),
('1396', '1396', 'CICA AUDITORES ASOCIADOS', '1013103029', '1013103029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1013103029', '0', '', '0'),
('1397', '1397', 'Mario O bando Carbajal', '954894012', '954894012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '954894012', '0', '', '0'),
('1398', '1398', 'CONSTRUCTORA LA ARBOLEDA S.R.L.', '248820028', '248820028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '248820028', '0', '', '0'),
('1399', '1399', 'Universidad Nacional del Oriente', '1014971023', '1014971023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1014971023', '0', '', '0'),
('1400', '1400', 'SERPETCOP S.R.L', '286388022', '286388022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '286388022', '0', '', '0'),
('1401', '1401', 'Juan Carlos Carreo Mercado', '3212612', '3212612', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3212612', '0', '', '0'),
('1402', '1402', 'ASERVICT S.R.L.', '352774026', '352774026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '352774026', '0', '', '0'),
('1403', '1403', '. Felicidad Anagua Quispe', '5733501013', '5733501013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5733501013', '0', '', '0'),
('1404', '1404', 'Vela Garcia Enzo Alfredo', '3366399010', '3366399010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3366399010', '0', '', '0'),
('1405', '1405', 'Alberto Mercado Machuca', '5938294', '5938294', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5938294', '0', '', '0'),
('1406', '1406', 'Fundacion Energetica Boliviana', '1007061020', '1007061020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1007061020', '0', '', '0'),
('1407', '1407', 'GABY TABORGA TABORGA', '4722401015', '4722401015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4722401015', '0', '', '0'),
('1408', '1408', 'Colegio del Sagrado Corazn', '121165022', '121165022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '121165022', '0', '', '0'),
('1409', '1409', 'consultans services financial &amp; tax ltda.', '310190028', '310190028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '310190028', '0', '', '0'),
('1410', '1410', 'tacuri', '5570270', '5570270', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5570270', '0', '', '0'),
('1411', '1411', 'Corporacion de Aquino Bolivia S.A.', '1020367024', '1020367024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1020367024', '0', '', '0'),
('1412', '1412', 'CARMEN TINCUTA VALENCIA', '4266890011', '4266890011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4266890011', '0', '', '0'),
('1413', '1413', 'Victor Gutierrez E.', '4033965013', '4033965013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4033965013', '0', '', '0'),
('1414', '1414', 'GRISEL ALEJANDRA SANTA CRUZ ALCOREZA', '3482554010', '3482554010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3482554010', '0', '', '0'),
('1415', '1415', 'ELIAS SAMUEL FLORES', '4521631018', '4521631018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4521631018', '0', '', '0'),
('1416', '1416', 'Mirtha Lopez Soruco', '1837618016', '1837618016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1837618016', '0', '', '0'),
('1417', '1417', 'HOSPITAL SAN JUAN DE DIOS', '1030795027', '1030795027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1030795027', '0', '', '0'),
('1418', '1418', 'Enrique Ortuo', '5113095', '5113095', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5113095', '0', '', '0'),
('1419', '1419', 'Perez Montao', '802405018', '802405018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '802405018', '0', '', '0'),
('1420', '1420', 'Ral Molina', '2717774012', '2717774012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2717774012', '0', '', '0'),
('1421', '1421', 'Erwin Galarza Velasco', '6350898', '6350898', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6350898', '0', '', '0'),
('1422', '1422', 'Evelin Flores Blanco', '6277042', '6277042', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6277042', '0', '', '0'),
('1423', '1423', 'Rosario Alczar', '1521525015', '1521525015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1521525015', '0', '', '0'),
('1424', '1424', 'HMS ASSURANCE GROUP S.R.L', '160896024', '160896024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '160896024', '0', '', '0'),
('1425', '1425', 'GENEX SA', '1028345022', '1028345022', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1028345022', '0', '', '0'),
('1426', '1426', 'RAMIREZ', '4243376', '4243376', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4243376', '0', '', '0'),
('1427', '1427', 'Raquel Yovana Tapia Espinoza', '8155815019', '8155815019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8155815019', '0', '', '0'),
('1428', '1428', 'VIVIAN RIBERA MENACHO', '5820171011', '5820171011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5820171011', '0', '', '0'),
('1429', '1429', 'Silvia Wilde', '2836893015', '2836893015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2836893015', '0', '', '0'),
('1430', '1430', 'miruca61@hotmail.com', '3505106013', '3505106013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3505106013', '0', '', '0'),
('1431', '1431', 'Sergio Farfan', '2712751017', '2712751017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2712751017', '0', '', '0'),
('1432', '1432', 'NANCY VILLCA', '3689094011', '3689094011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3689094011', '0', '', '0'),
('1433', '1433', 'Finadec Consultores SRL.', '1001017021', '1001017021', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1001017021', '0', '', '0'),
('1434', '1434', 'Alhena Sujeit Salinas', '9268651', '9268651', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '9268651', '0', '', '0'),
('1435', '1435', 'NATALIA DE RADA', '3428013', '3428013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3428013', '0', '', '0'),
('1436', '1436', 'SANDY', '2476813', '2476813', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2476813', '0', '', '0'),
('1437', '1437', 'Universidad Catlica Boliviana San Pablo', '1020141023', '1020141023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1020141023', '0', '', '0'),
('1438', '1438', 'Jorge Hidalgo', '2692132', '2692132', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2692132', '0', '', '0'),
('1439', '1439', 'CONSULTORA COFABOL SRL', '140475029', '140475029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '140475029', '0', '', '0'),
('1440', '1440', 'MAGDA SUSANA MADARIAGA LORA', '1821358', '1821358', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1821358', '0', '', '0'),
('1441', '1441', 'Claudia Veliz Perez', '4053598018', '4053598018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4053598018', '0', '', '0'),
('1442', '1442', 'Milton Bravo', '5424493012', '5424493012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5424493012', '0', '', '0'),
('1443', '1443', 'Orlando Roque', '4274170', '4274170', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4274170', '0', '', '0'),
('1444', '1444', 'Maribel Ychazo Rojas', '3911998017', '3911998017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3911998017', '0', '', '0'),
('1445', '1445', 'FELIX CRUZ CUENTAS', '4947344016', '4947344016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4947344016', '0', '', '0'),
('1446', '1446', 'Daysi Avendao Reynaga', '5682143', '5682143', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5682143', '0', '', '0'),
('1447', '1447', 'Lizett Bernal', '6556046014', '6556046014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6556046014', '0', '', '0'),
('1448', '1448', 'Iver Nina Bueno', '3973150016', '3973150016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3973150016', '0', '', '0'),
('1449', '1449', 'ABEL QUIROZ', '3472365', '3472365', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3472365', '0', '', '0'),
('1450', '1450', 'Consultora Multidisciplinaria Maldonado Hnos.S.R.L.', '132901023', '132901023', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '132901023', '0', '', '0'),
('1451', '1451', 'SERMUR SRL.', '122181025', '122181025', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '122181025', '0', '', '0'),
('1452', '1452', 'Crespo y Landivar Ltda.', '169044028', '169044028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '169044028', '0', '', '0'),
('1453', '1453', 'WENDES SERVICIOS INTEGRALES', '1704569015', '1704569015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1704569015', '0', '', '0'),
('1454', '1454', 'Ticona', '4865665', '4865665', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4865665', '0', '', '0'),
('1455', '1455', 'VICTOR CAMACHO VIDAL', '3778789015', '3778789015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3778789015', '0', '', '0'),
('1456', '1456', 'Jorge Flor', '5653307015', '5653307015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5653307015', '0', '', '0'),
('1457', '1457', 'Berrios', '1236708019', '1236708019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1236708019', '0', '', '0'),
('1458', '1458', 'MARCELO EFRAIN HEREDIA CAVERO', '1061552016', '1061552016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1061552016', '0', '', '0'),
('1459', '1459', 'Salvador Carballo', '6547755019', '6547755019', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6547755019', '0', '', '0'),
('1460', '1460', 'Omar Fernando Roman Fernandez', '5969574017', '5969574017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5969574017', '0', '', '0'),
('1461', '1461', 'Jhonny Alanes', '5542419010', '5542419010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5542419010', '0', '', '0'),
('1462', '1462', 'ELSA QUIROGA VEIZAGA', '6496469016', '6496469016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6496469016', '0', '', '0'),
('1463', '1463', 'EDGAR PLAZA AGRADA', '2771773', '2771773', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2771773', '0', '', '0'),
('1464', '1464', 'OSCAR ESPEJO ALCON', '2459684016', '2459684016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2459684016', '0', '', '0'),
('1465', '1465', 'Jhonny W. Veizaga A.', '2876283', '2876283', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2876283', '0', '', '0'),
('1466', '1466', 'ROXANA CACERES ARGOTE', '3072142', '3072142', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3072142', '0', '', '0'),
('1467', '1467', 'Todollantas Srl', '348298020', '348298020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '348298020', '0', '', '0'),
('1468', '1468', 'Wilma Fernndez Vaca', '2975328010', '2975328010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2975328010', '0', '', '0'),
('1469', '1469', 'YAPURA', '4049150', '4049150', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4049150', '0', '', '0'),
('1470', '1470', 'DIRCE IMPORT EXPORT SRL', '168840029', '168840029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '168840029', '0', '', '0'),
('1471', '1471', 'Salazar &amp; Machicado S.A.', '286648024', '286648024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '286648024', '0', '', '0'),
('1472', '1472', 'Emilse Mariscal', '8891728014', '8891728014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '8891728014', '0', '', '0'),
('1473', '1473', 'OCA LTDA', '1030417024', '1030417024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1030417024', '0', '', '0'),
('1474', '1474', 'WALTER VICTOR RODRIGUEZ FUERTES', '3683495014', '3683495014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3683495014', '0', '', '0'),
('1475', '1475', 'Felicia Guzmn Flores', '2947416014', '2947416014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2947416014', '0', '', '0'),
('1476', '1476', 'Iiguez', '2479117017', '2479117017', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2479117017', '0', '', '0'),
('1477', '1477', ' Juan Carlos Soria Pardo', '3902687014', '3902687014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3902687014', '0', '', '0'),
('1478', '1478', 'Miguel Alejandro Vargas Ponce', '4742235010', '4742235010', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4742235010', '0', '', '0'),
('1479', '1479', 'Jose Maria Mejia', '3974809016', '3974809016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3974809016', '0', '', '0'),
('1480', '1480', 'Felix Machicado Mendoza', '2325001', '2325001', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2325001', '0', '', '0'),
('1481', '1481', 'Alejandro Roberto Gonzales Gutierrez', '4582991014', '4582991014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4582991014', '0', '', '0'),
('1482', '1482', 'Lozano', '2319203015', '2319203015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2319203015', '0', '', '0'),
('1483', '1483', 'Julio Pelaez', '674406', '674406', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '674406', '0', '', '0'),
('1484', '1484', 'Ruiz Mealla SRL', '173372024', '173372024', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '173372024', '0', '', '0'),
('1485', '1485', 'FERNANDO BARRAGAN', '4494282014', '4494282014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4494282014', '0', '', '0'),
('1486', '1486', 'INTERSALUD S.R.L.', '292874027', '292874027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '292874027', '0', '', '0'),
('1487', '1487', 'ICP INGENIERIA Y CONSTRUCCION SRL', '1020901029', '1020901029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1020901029', '0', '', '0'),
('1488', '1488', 'REYNALDO CHOQUE', '4889486016', '4889486016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4889486016', '0', '', '0'),
('1489', '1489', 'Castillo', '2729593015', '2729593015', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '2729593015', '0', '', '0'),
('1490', '1490', 'Hinojosa', '5993413', '5993413', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5993413', '0', '', '0'),
('1491', '1491', 'Juan Chiri Cardenas', '4116627016', '4116627016', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4116627016', '0', '', '0'),
('1492', '1492', 'SEFI S.R.L', '139787029', '139787029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '139787029', '0', '', '0'),
('1493', '1493', 'EDUARDO LAURA', '4770343018', '4770343018', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '4770343018', '0', '', '0'),
('1494', '1494', 'Zeballos', '6551280', '6551280', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6551280', '0', '', '0'),
('1495', '1495', 'Wilson Martinez Oropeza', '5798866011', '5798866011', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '5798866011', '0', '', '0'),
('1496', '1496', 'Marianela Salinas Montero', '6247479', '6247479', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6247479', '0', '', '0'),
('1497', '1497', 'Jaime Vargas', '3418997012', '3418997012', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3418997012', '0', '', '0'),
('1498', '1498', 'Marca Verde SAFI S.A', '192902029', '192902029', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '192902029', '0', '', '0'),
('1499', '1499', 'ICAS S.A.', '181630026', '181630026', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '181630026', '0', '', '0'),
('1500', '1500', 'FREMAR LTDA', '1027955027', '1027955027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1027955027', '0', '', '0'),
('1501', '1501', 'L y M CONSULTORES S.R.L.', '1008443020', '1008443020', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1008443020', '0', '', '0'),
('1502', '1502', 'Herrera', '3512576', '3512576', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3512576', '0', '', '0'),
('1503', '1503', 'FREDDY OVANDO', '994674014', '994674014', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '994674014', '0', '', '0'),
('1504', '1504', 'OSCAR MARIO RIVAS LOZANO', '1807922013', '1807922013', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1807922013', '0', '', '0'),
('1505', '1505', 'Kattia Len', '6828701', '6828701', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '6828701', '0', '', '0'),
('1506', '1506', 'Flores', '3479339', '3479339', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '3479339', '0', '', '0'),
('1507', '1507', 'SOCIEDAD SALESIANA', '1023169027', '1023169027', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '1023169027', '0', '', '0'),
('1508', '1508', 'UNIVERSIDAD TECNOLOGICA BOLIVIANA S.A.', '148406028', '148406028', '1', '1', '', 'DEF', '1', '', '4510', '1200', '4500', '1', '0', '148406028', '0', '', '0'),
