<?php

function numtoletras($xcifra)
{
    $xarray = array(0 => "Cero",
        1 => "Un", "Dos", "Tres", "Cuatro", "Cinco", "Seis", "Siete", "Ocho", "Nueve",
        "Diez", "Once", "Doce", "Trece", "Catorce", "Quince", "Dieciseis", "Diecisiete", "Dieciocho", "Diecinueve",
        "Veinti", 30 => "Treinta", 40 => "Cuarenta", 50 => "Cincuenta", 60 => "Sesenta", 70 => "Setenta", 80 => "Ochenta", 90 => "Noventa",
        100 => "Ciento", 200 => "Doscientos", 300 => "Trescientos", 400 => "Cuatrocientos", 500 => "Quinientos", 600 => "Seiscientos", 700 => "Setecientos", 800 => "Ochocientos", 900 => "Novecientos"
    );
//
    $xcifra = trim($xcifra);
    $xlength = strlen($xcifra);
    $xpos_punto = strpos($xcifra, ".");
    $xaux_int = $xcifra;
    $xdecimales = "00";
    if (!($xpos_punto === false)) {
        if ($xpos_punto == 0) {
            $xcifra = "0" . $xcifra;
            $xpos_punto = strpos($xcifra, ".");
        }
        $xaux_int = substr($xcifra, 0, $xpos_punto); // obtengo el entero de la cifra a covertir
        $xdecimales = substr($xcifra . "00", $xpos_punto + 1, 2); // obtengo los valores decimales
    }

    $XAUX = str_pad($xaux_int, 18, " ", STR_PAD_LEFT); // ajusto la longitud de la cifra, para que sea divisible por centenas de miles (grupos de 6)
    $xcadena = "";
    for ($xz = 0; $xz < 3; $xz++) {
        $xaux = substr($XAUX, $xz * 6, 6);
        $xi = 0;
        $xlimite = 6; // inicializo el contador de centenas xi y establezco el límite a 6 dígitos en la parte entera
        $xexit = true; // bandera para controlar el ciclo del While
        while ($xexit) {
            if ($xi == $xlimite) { // si ya llegó al límite máximo de enteros
                break; // termina el ciclo
            }

            $x3digitos = ($xlimite - $xi) * -1; // comienzo con los tres primeros digitos de la cifra, comenzando por la izquierda
            $xaux = substr($xaux, $x3digitos, abs($x3digitos)); // obtengo la centena (los tres dígitos)
            for ($xy = 1; $xy < 4; $xy++) { // ciclo para revisar centenas, decenas y unidades, en ese orden
                switch ($xy) {
                    case 1: // checa las centenas
                        if (substr($xaux, 0, 3) < 100) { // si el grupo de tres dígitos es menor a una centena ( < 99) no hace nada y pasa a revisar las decenas
                            
                        } else {
                            $key = (int) substr($xaux, 0, 3);
                            if (TRUE === array_key_exists($key, $xarray)){  // busco si la centena es número redondo (100, 200, 300, 400, etc..)
                                $xseek = $xarray[$key];
                                $xsub = subfijo($xaux); // devuelve el subfijo correspondiente (Millón, Millones, Mil o nada)
                                if (substr($xaux, 0, 3) == 100)
                                    $xcadena = " " . $xcadena . " Cien " . $xsub;
                                else
                                    $xcadena = " " . $xcadena . " " . $xseek . " " . $xsub;
                                $xy = 3; // la centena fue redonda, entonces termino el ciclo del for y ya no reviso decenas ni unidades
                            }
                            else { // entra aquí si la centena no fue numero redondo (101, 253, 120, 980, etc.)
                                $key = (int) substr($xaux, 0, 1) * 100;
                                $xseek = $xarray[$key]; // toma el primer caracter de la centena y lo multiplica por cien y lo busca en el arreglo (para que busque 100,200,300, etc)
                                $xcadena = " " . $xcadena . " " . $xseek;
                            } // ENDIF ($xseek)
                        } // ENDIF (substr($xaux, 0, 3) < 100)
                        break;
                    case 2: // checa las decenas (con la misma lógica que las centenas)
                        if (substr($xaux, 1, 2) < 10) {
                            
                        } else {
                            $key = (int) substr($xaux, 1, 2);
                            if (TRUE === array_key_exists($key, $xarray)) {
                                $xseek = $xarray[$key];
                                $xsub = subfijo($xaux);
                                if (substr($xaux, 1, 2) == 20)
                                    $xcadena = " " . $xcadena . " Veinte " . $xsub;
                                else
                                    $xcadena = " " . $xcadena . " " . $xseek . " " . $xsub;
                                $xy = 3;
                            }
                            else {
                                $key = (int) substr($xaux, 1, 1) * 10;
                                $xseek = $xarray[$key];
                                if (20 == substr($xaux, 1, 1) * 10)
                                    $xcadena = " " . $xcadena . " " . $xseek;
                                else
                                    $xcadena = " " . $xcadena . " " . $xseek . " Y ";
                            } // ENDIF ($xseek)
                        } // ENDIF (substr($xaux, 1, 2) < 10)
                        break;
                    case 3: // checa las unidades
                        if (substr($xaux, 2, 1) < 1) { // si la unidad es cero, ya no hace nada
                            
                        } else {
                            $key = (int) substr($xaux, 2, 1);
                            $xseek = $xarray[$key]; // obtengo directamente el valor de la unidad (del uno al nueve)
                            $xsub = subfijo($xaux);
                            $xcadena = " " . $xcadena . " " . $xseek . " " . $xsub;
                        } // ENDIF (substr($xaux, 2, 1) < 1)
                        break;
                } // END SWITCH
            } // END FOR
            $xi = $xi + 3;
        } // ENDDO

        if (substr(trim($xcadena), -5, 5) == "illon") // si la cadena obtenida termina en MILLON o BILLON, entonces le agrega al final la conjuncion DE
            $xcadena.= " De";

        if (substr(trim($xcadena), -7, 7) == "illones") // si la cadena obtenida en MILLONES o BILLONES, entoncea le agrega al final la conjuncion DE
            $xcadena.= " De";

        // ----------- esta línea la puedes cambiar de acuerdo a tus necesidades o a tu país -------
        if (trim($xaux) != "") {
            switch ($xz) {
                case 0:
                    if (trim(substr($XAUX, $xz * 6, 6)) == "1")
                        $xcadena.= "Un Billon ";
                    else
                        $xcadena.= " Billones ";
                    break;
                case 1:
                    if (trim(substr($XAUX, $xz * 6, 6)) == "1")
                        $xcadena.= "Un Millon ";
                    else
                        $xcadena.= " Millones ";
                    break;
                case 2:
                    if ($xcifra < 1) {
                        $xcadena = "Cero $xdecimales/100 Bolivianos";
                    }
                    if ($xcifra >= 1 && $xcifra < 2) {
                        $xcadena = "Un $xdecimales/100 Boliviano";
                    }
                    if ($xcifra >= 2) {
                        $xcadena.= " $xdecimales/100 Bolivianos"; //
                    }
                    break;
            } // endswitch ($xz)
        } // ENDIF (trim($xaux) != "")
        // ------------------      en este caso, para México se usa esta leyenda     ----------------
        $xcadena = str_replace("VEINTI ", "VEINTI", $xcadena); // quito el espacio para el VEINTI, para que quede: VEINTICUATRO, VEINTIUN, VEINTIDOS, etc
        $xcadena = str_replace("  ", " ", $xcadena); // quito espacios dobles
        $xcadena = str_replace("UN UN", "UN", $xcadena); // quito la duplicidad
        $xcadena = str_replace("  ", " ", $xcadena); // quito espacios dobles
        $xcadena = str_replace("BILLON DE MILLONES", "BILLON DE", $xcadena); // corrigo la leyenda
        $xcadena = str_replace("BILLONES DE MILLONES", "BILLONES DE", $xcadena); // corrigo la leyenda
        $xcadena = str_replace("DE UN", "UN", $xcadena); // corrigo la leyenda
    } // ENDFOR ($xz)
    return trim($xcadena);
}

// END FUNCTION

function subfijo($xx)
{ // esta función regresa un subfijo para la cifra
    $xx = trim($xx);
    $xstrlen = strlen($xx);
    if ($xstrlen == 1 || $xstrlen == 2 || $xstrlen == 3)
        $xsub = "";
    //
    if ($xstrlen == 4 || $xstrlen == 5 || $xstrlen == 6)
        $xsub = "Mil";
    //
    return $xsub;
}

function compararFechas($primera, $segunda)
 {
  $valoresPrimera = explode ("/", $primera);   
  $valoresSegunda = explode ("/", $segunda); 

  $diaPrimera    = $valoresPrimera[0];  
  $mesPrimera  = $valoresPrimera[1];  
  $anyoPrimera   = $valoresPrimera[2]; 

  $diaSegunda   = $valoresSegunda[0];  
  $mesSegunda = $valoresSegunda[1];  
  $anyoSegunda  = $valoresSegunda[2];

  // $diasPrimeraJuliano = gregoriantojd($diaPrimera, $mesPrimera, $anyoPrimera);
  // $diasSegundaJuliano = gregoriantojd($diaSegunda, $mesSegunda, $anyoSegunda);

  $diasPrimeraJuliano = gregoriantojd($mesPrimera, $diaPrimera, $anyoPrimera);
  $diasSegundaJuliano = gregoriantojd($mesSegunda, $diaSegunda, $anyoSegunda);

  // if(!checkdate($mesPrimera, $diaPrimera, $anyoPrimera)){
  //   // "La fecha ".$primera." no es válida";
  //   return 0;
  // }elseif(!checkdate($mesSegunda, $diaSegunda, $anyoSegunda)){
  //   // "La fecha ".$segunda." no es válida";
  //   return 0;
  // }else{
  //   return  $diasPrimeraJuliano - $diasSegundaJuliano;
  // } 
return  $diasPrimeraJuliano - $diasSegundaJuliano;
}

function agregarDecimales($numero)
{
    $variable = explode(".", $numero);
    if (!isset($variable[1]))
    {
        $resultado = $numero.'.00';
    }
    else
    { 
        if (strlen($variable[1]) == 1) 
        {
            $resultado = $numero.'0';
        }
        else if (strlen($variable[1]) == 2)
        {
            $resultado = $numero;
        }
        else if (strlen($variable[1]) > 2)
        {
            $resultado = $variable[0] . "." . substr($variable[1], 0, 2);
        }
    } 
    return $resultado;
}

function agregarDecimalesComa($numero)
{
    $variable = explode(".", $numero);
    if (!isset($variable[1]))
    {
        $resultado = $numero.'.00';
    }
    else
    { 
        if (strlen($variable[1]) == 1) 
        {
            $resultado = $numero.'0';
        }
        else if (strlen($variable[1]) == 2)
        {
            $resultado = $numero;
        }
        else if (strlen($variable[1]) > 2)
        {
            $resultado = $variable[0] . "." . substr($variable[1], 0, 2);
        }
    } 
    return number_format($resultado, 2, ".", ",");
}

function generarDimensiones($selected, $enabled, $display)
{
    $dimension = "";
    $dimensiones = get_the_dimensions();
    $dimension .= "<td";

    if (!$display)
    {
        $dimension .= " style='display:none'";
    }
    $dimension .= ">";
    $dimension .= "<select";
    if (!$enabled)
    {
        $dimension .= " disabled";
    }
    $dimension .= ">"; 
    while ($row = mysql_fetch_array($dimensiones))
    {
        $dimension .= "<option value='".$row['id']."'";

        if ($row['id'] == $selected)
        {
            $dimension .= " selected";
        }
        

        $dimension .= ">".$row['name']."";
        $dimension .= "</option>";
    }
    $dimension .= "</select>";
    $dimension .= "</td>";
    return $dimension;
}

function generarCuentas($selected)
{
    $select = "";
    $cuentas = get_gl_accounts(null,null,null);
    $select .= "<td>";
    $select .= '<select style="width: 150px" disabled>';
    while ($row2 = mysql_fetch_array($cuentas))
    {
        $select .= "<option value='".$row2['account_code']."'";

        if ($row2['account_code'] == $selected)
        {
            $select .= " selected";
        }
        $select .= ">".$row2['account_name']."";
        $select .= "</option>";
    }
    $select .= '</select>';
    $select .= "</td>";
    return $select;
}
?>