/*
	#Elaboradores es la ID del input
	Usa jquery, jquery ui js y css
*/
$("#Elaboradores").autocomplete({
	source: function (request, response) {
		$.ajax({
			url: "/documentos/Usuarios/",
			type: "GET",
			dataType: "json",
			data: { term: request.term }, /* Este parametro toma solo a lo que escribiste y te lo manda en la llamada ajax */
			success: function (data) {
				/* La respuesta es solamente un array codificado en Json con php json_encode($array); con los datos */
				response($.map(data, function (item) {
					return { label: item.Nombre + " " + item.Apellido + " [" + item.Username + "]", value: item.Nombre + " " + item.Apellido + " [" + item.Username + "]", id: item.Id };
				}))
			}
		})
	},
	select: function (event, ui) {
		/* Aca en select y focus solamente pongo los valores donde corresponda */
		$("#docElaborador").val(ui.item.id);
	},
	focus: function (event, ui) {
		$("#Elaboradores").val(ui.item.label);
		$("#docElaborador").val(ui.item.id);
	},
	minLength: 2,
});
