<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_SALESTRANSVIEW';
$path_to_root = "../..";
include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/sales/includes/sales_ui.inc");

include_once($path_to_root . "/sales/includes/sales_db.inc");

include_once($path_to_root . "/includes/functions.inc.php");

$js = "";


if (isset($_GET["trans_no"]))
{
	$trans_id = $_GET["trans_no"];
}
elseif (isset($_POST["trans_no"]))
{
	$trans_id = $_POST["trans_no"];
}


$myrow = get_customer_trans($trans_id, ST_SALESINVOICE);

$empresa = get_company_prefs();

$branch = get_branch($myrow["branch_code"]);

$sales_order = get_sales_order_header($myrow["order_"], ST_SALESORDER);


$fecha_limite = DateTime::createFromFormat('Y-m-d', $myrow['due_date']);
$fecha_transaccion = DateTime::createFromFormat('Y-m-d', $myrow['tran_date']);
$fecha_compra = str_replace("-", "", $myrow["tran_date"]);
$fecha_compra_qr = $fecha_transaccion->format('d/m/Y');

$ventas = obtener_ventas();
while ($row = mysql_fetch_array($ventas))
{
	if ($row['trans_no'] == $trans_id)	
	{
		$auth_no = $row['auth_no'];
	}
}

if ($empresa['formato_imp'] == "Carta")
{
	echo "<div style='width=884px;height:484px;padding:20px;'>";
		echo "<div style='position:absolute;width:94%;'>";
			echo "<div>";
			if ($empresa['coy_logo'] != "")
			{
				echo "<img style='float:left;' src='".company_path()."/images/".clean_file_name($empresa['coy_logo'])."' />";
			}
				echo "<div style='margin-top:10px; float:left; clear:left; display:inline;'>".$empresa['coy_name']."</div>";
				echo "<div style='width:200px; float:left; clear:left;'>".substr($empresa['postal_address'], 0, 70)."...</div>";
				echo "<div style='position:absolute; top:10px; left: 580px; display:inline;'>";
					echo "<table style='border:1px solid black;margin:0 !important;border-radius:3px;'>";
						echo "<tr>";
							echo "<td>NIT:</td>"; echo "<td>".$empresa['gst_no']."</td>";
						echo "</tr>";
						echo "<tr>";
							echo "<td>N&deg; FACTURA:</td>"; echo "<td>".$trans_id."</td>";
						echo "</tr>";
						echo "<tr>";
							echo "<td>N&deg; AUTORIZACION:</td>"; echo "<td>".$auth_no."</td>";
						echo "</tr>";				
					echo "</table>";
					echo "<table>";
						echo "<tr>";					
							echo "<td style='font-size:22px;width:210px;text-align:center;'>ORIGINAL</td>";					
						echo "</tr>";
						echo "<tr>";
							echo "<td style='font-size:14px;width:210px;text-align:center;'>".$empresa['act_eco']."</td>";					
						echo "</tr>";
					echo "</table>";			
				echo "</div>";	
			echo "</div>";	
		echo "</div>";
		echo "<div style='position:absolute;top:130px;left:350px;'>";
			echo "<h1>FACTURA</h1>";
		echo "</div>";
		echo "<div style='position:absolute;top:210px;'>";
			echo "<table cellspacing='10' style='border:1px solid black;border-radius:5px;width:821px;'>";
				echo "<tr>";
					echo "<td><b>Lugar y fecha:</b></td><td>La paz, ".$fecha_transaccion->format("d/m/Y")."</td><td><b>NIT/CI:</b></td><td>".$myrow['tax_id']."</td>";
				echo "</tr>";
				echo "<tr>";
					echo "<td><b>Se&ntilde;or(es):</b></td>";echo "<td>".$myrow["DebtorName"]."</td>";
				echo "</tr>";
				echo "<tr>";
					echo "<td><b>Alumno(a):</b></td>";echo "<td>".$myrow["DebtorName"]."</td>";
				echo "</tr>";
			echo "</table>";

			echo "<table cellspacing='10' id='totales' style='border:1px solid black;width:821px;margin-top:10px;'>";
				echo "<tr>";
					echo "<td><b>C&oacute;digo</b></td>";			
					echo "<td><b>Cantidad</b></td>";			
					echo "<td><b>Descripci&oacute;n</b></td>";			
					echo "<td><b>Precio por unidad</b></td>";
					echo "<td><b>Total</b></td>";
				echo "</tr>";

				$result = get_customer_trans_details(ST_SALESINVOICE, $trans_id);
				if (db_num_rows($result) > 0)
				{
					

					$k = 0;	//row colour counter
					$sub_total = 0;
					while ($myrow2 = db_fetch($result))
					{
					    if($myrow2["quantity"]==0) continue;
						alt_table_row_color($k);

						$value = round2(((1 - $myrow2["discount_percent"]) * $myrow2["unit_price"] * $myrow2["quantity"]),
						   user_price_dec());
						$sub_total += $value;

					    if ($myrow2["discount_percent"] == 0)
					    {
						  	$display_discount = "";
					    }
					    else
					    {
						  	$display_discount = percent_format($myrow2["discount_percent"]*100) . "%";
					    }

						echo "<tr><td>";
						echo $myrow2["stock_id"];
						echo "</td><td>";
						echo $myrow2["quantity"];
						echo "</td><td>";
						echo $myrow2["StockDescription"];
						echo "</td><td>";
						echo $myrow2["unit_price"];
						echo "</td><td>";
						echo $value;
						echo "</td></tr>";

					}

					$display_sub_tot = price_format($sub_total);
				}
				else
					display_note(_("There are no line items on this invoice."), 1, 2);

	include($path_to_root .'/control/CodigoControlV7.php');

	/*$numero_autorizacion = '29040011007';
	$numero_factura = '1503';
	$nit_cliente = '4189179011';
	$monto_compra = '2500';
	$clave = '9rCB7Sv4X29d)5k7N%3ab89p-3(5[A';*/

	$total_cc = round($display_sub_tot);



	$codigo_control = CodigoControlV7::generar($auth_no, $trans_id, $myrow['tax_id'], $fecha_compra, $total_cc, $empresa['key_dos']);

	// $codigo_qr = $auth_no;
	// $codigo_qr .= $trans_id;
	// $codigo_qr .= $myrow['tax_id'];
	// $codigo_qr .= $fecha_compra;
	// $codigo_qr .= $display_sub_tot;
	// $codigo_qr .= $empresa['key_dos'];

	$codigo_qr = "";
	$codigo_qr .= $empresa['gst_no'];
	$codigo_qr .= $trans_id;
	$codigo_qr .= $auth_no;
	$codigo_qr .= $fecha_compra_qr;
	$codigo_qr .= $display_sub_tot;
	$codigo_qr .= "0"; 
	$codigo_qr .= $codigo_control;
	$codigo_qr .= $myrow['tax_id'];
	$codigo_qr .= "0000";

				echo "<tr>";
					echo "<td>Son: ";
					echo numtoletras($sub_total);
					echo "</td>";
					echo "<td></td>";
					echo "<td></td>";
					echo "<td style='background-color:black;color:white;'>TOTAL Bs</td>";
					echo "<td>".$display_sub_tot."</td>";
				echo "</tr>";
				echo "<style> #totales tr{border: 1px solid black;}</style>";

			echo "</table>";
			echo "<table cellspacing='10' style='border:1px solid black;width:500px;margin-top:10px;'>";
				echo "<tr>";
					echo "<td><b>C&oacute;digo de control:</b></td><td style='text-align:right;'>".$codigo_control."</td>";				
				echo "</tr>";			
			echo "</table>";
			echo "<table cellspacing='10' style='border:1px solid black;width:500px;margin-top:10px;'>";
				echo "<tr>";
				echo "<td><b>Fecha l&iacute;mite de edici&oacute;n:</b></td><td style='text-align:right;'>".$fecha_limite->format('d/m/Y')."</td>";				
				echo "</tr>";	
			echo "</table>";
			echo "<div style='position:relative;height:100px;width:100px;left:701px;top:-100px;'>";
			echo '<img style="-webkit-user-select: none" src="../../qr.php?cod='.$codigo_qr.'">';
			echo "</div>";
			echo "<h3 style='margin-top: -70px;'>Esta factura constribuye al desarrollo del pais, el uso ilicito de esta sera sancionado de acuerdo a la ley.</h3>";
			echo "<br>";
			echo $empresa['derecho_cons'];
		echo "</div>";
	echo "</div>";
}
else if ($empresa['formato_imp'] == "Rollo")
{

	echo "<div style='width: 302px; background-color: white; border: 1px solid black; text-align:center;'>";
	echo "<hr noshade size=6>";
	echo $empresa['coy_name']."</br>";
	echo $empresa['postal_address']."</br>"."<hr size=1>";
	echo "<b>FACTURA ORIGINAL</b>"."</br>"."<hr noshade size=5>";

	echo "<table style='border:none;width:302px;margin-top:10px; text-align:center;'>"."<tr>";

	echo "<td style='text-align:right; width:151px;'>"."NIT: "."</td>"."<td style='text-align:left; width:151px;'>".$empresa['gst_no']."</td>"."</tr>";	
	echo "<td style='text-align:right; width:151px;'>"."FACTURA No.: "."</td>"."<td style='text-align:left; width:151px;'>".$trans_id."</td>"."</tr>";
	echo "<td style='text-align:right; width:151px;'>"."AUTORIZ. No.: "."</td>"."<td style='text-align:left; width:151px;'>".$auth_no."</td>"."</tr>";
	
	echo "</table>"."<hr noshade size=5>";


	echo "ACTIVIDAD ECONOMICA:"."</br>";
	echo $empresa['act_eco']."</br>";


	echo "<table style='border:none;width:302px;margin-top:10px; text-align:center;'>"."<tr>";

	echo "<td style='text-align:right; width:151px;'>"."FECHA: "."</td>"."<td style='text-align:left; width:151px;'>".$fecha_transaccion->format("d/m/Y")."</td>"."</tr>";
	echo "<td style='text-align:right; width:151px;'>"."NIT/CI: "."</td>"."<td style='text-align:left; width:151px;'>".$myrow['tax_id']."</td>"."</tr>";
	echo "<td style='text-align:right; width:151px;'>"."Se&ntilde;or(es): "."</td>"."<td style='text-align:left; width:151px;'>".$myrow["DebtorName"]."</td>"."</tr>";

	echo "</table>"."<hr noshade size=5>";



	echo "<table id='totales' style='border:1px solid black;width:302px;margin-top:10px; border-collapse:collapse; text-align:center;'>";
				echo "<tr style='border:1px solid black;'>";		
					echo "<td>Cantidad</td>";			
					echo "<td>Detalle</td>";			
					echo "<td>Precio</td>";
					echo "<td>Total</td>";
				echo "</tr>";

	$result = get_customer_trans_details(ST_SALESINVOICE, $trans_id);
				if (db_num_rows($result) > 0)
				{
					

					$k = 0;	//row colour counter
					$sub_total = 0;
					while ($myrow2 = db_fetch($result))
					{
					    if($myrow2["quantity"]==0) continue;
						alt_table_row_color($k);

						$value = round2(((1 - $myrow2["discount_percent"]) * $myrow2["unit_price"] * $myrow2["quantity"]),
						   user_price_dec());
						$sub_total += $value;

					    if ($myrow2["discount_percent"] == 0)
					    {
						  	$display_discount = "";
					    }
					    else
					    {
						  	$display_discount = percent_format($myrow2["discount_percent"]*100) . "%";
					    }

						echo "<tr><td>";
						echo $myrow2["quantity"];
						echo "</td><td>";
						echo $myrow2["StockDescription"];
						echo "</td><td>";
						echo $myrow2["unit_price"];
						echo "</td><td>";
						echo $value;
						echo "</td></tr>";

					}

					$display_sub_tot = price_format($sub_total);
				}
				else
					display_note(_("There are no line items on this invoice."), 1, 2);

	include($path_to_root .'/control/CodigoControlV7.php');

	$total_cc = round($display_sub_tot);



	$codigo_control = CodigoControlV7::generar($auth_no, $trans_id, $myrow['tax_id'], $fecha_compra, $total_cc, $empresa['key_dos']);

	$codigo_qr = "";
	$codigo_qr .= $empresa['gst_no'];
	$codigo_qr .= $trans_id;
	$codigo_qr .= $auth_no;
	$codigo_qr .= $fecha_compra_qr;
	$codigo_qr .= $display_sub_tot;
	$codigo_qr .= "0"; 
	$codigo_qr .= $codigo_control;
	$codigo_qr .= $myrow['tax_id'];
	$codigo_qr .= "0000";

	echo "</table>";

	echo "<table style='border:none;width:297px;margin-top:10px; text-align:center;'>"."<tr>";
	echo "<td style='text-align:right; width:225px;'>"."<b>Total bs</b>"."</td>"."<td style='text-align:right; width:70px;'>"."<b>".$display_sub_tot."</b>"."</td>";
	echo "</tr>"."</table>"."</br>";

	echo "Son: ".numtoletras($sub_total)."</br>"."</br>";

	echo "<table style='border:none;width:302px;margin-top:10px; text-align:center;'>"."<tr>";

	echo "<td style='text-align:left; width:181px;'>"."Codigo de control: "."</td>"."<td style='text-align:left; width:121px;'>".$codigo_control."</td>"."</tr>";
	echo "<td style='text-align:left; width:181px;'>"."Fecha lim. de emision: "."</td>"."<td style='text-align:left; width:121px;'>".$fecha_limite->format('d/m/Y')."</td>"."</tr>";

	echo "</table>"."<hr noshade size=5>";

	echo "<div style='height:100px;width:100px; margin-left:32%;'>";
			echo '<img style="-webkit-user-select: none" src="../../qr.php?cod='.$codigo_qr.'">';
			echo "</div>";
			echo "<h4>Esta factura constribuye al desarrollo del pais, el uso ilicito de esta sera sancionado de acuerdo a la ley.</h3>";
			echo $empresa['derecho_cons'];
	echo "</div>";
	










	echo "</div>";
}

?>